
CREATE TABLE Classes (
  ClassID int NOT NULL,
  Class varchar (50),
  Students int NOT NULL, CONSTRAINT PK_Classes PRIMARY KEY CLUSTERED (ClassID
) )
 
GO

CREATE TABLE Rooms (
  Room int NOT NULL,
  Capacity int NOT NULL,
CONSTRAINT PK_Rooms PRIMARY KEY CLUSTERED (Room) 
)
GO

CREATE TABLE Products (
  Product_ID int NOT NULL,
  Product_Name varchar (25),
  Price money NULL,
CONSTRAINT PK_Products PRIMARY KEY NONCLUSTERED (Product_ID)  
) 
GO

CREATE TABLE Sales (
  Invoice_Num int NOT NULL,
  Invoice_Date datetime NOT NULL,
  Sales_ID int NOT NULL,
  Product_ID int NOT NULL,
  Quantity int NOT NULL,
  Price money NOT NULL,
CONSTRAINT PK_Sales PRIMARY KEY NONCLUSTERED (Invoice_Num)  
) 
GO

CREATE TABLE Salespeople (
  Sales_ID int NOT NULL,
  Salesperson varchar (25),
  ReportsTo_ID int NOT NULL,
CONSTRAINT PK_Salespeople PRIMARY KEY NONCLUSTERED (Sales_ID)  
) 
GO

INSERT INTO Classes (ClassID, Class, Students) VALUES (1, 'Advanced SQL Queries', 65)
INSERT INTO Classes (ClassID, Class, Students) VALUES (2, 'Introduction to MTS', 52)
INSERT INTO Classes (ClassID, Class, Students) VALUES (3, 'SOAP', 35)
GO

INSERT INTO Products (Product_ID, Product_Name, Price) VALUES (1, 'Widgets', 25)
INSERT INTO Products (Product_ID, Product_Name, Price) VALUES (2, 'Gadgets', 50)
INSERT INTO Products (Product_ID, Product_Name, Price) VALUES (3, 'Thingies', 75)
INSERT INTO Products (Product_ID, Product_Name, Price) VALUES (4, 'Whoozits', 90)
INSERT INTO Products (Product_ID, Product_Name, Price) VALUES (5, 'Whatzits', 5)
INSERT INTO Products (Product_ID, Product_Name, Price) VALUES (6, 'Gizmos', 15)
GO

INSERT INTO Rooms (Room, Capacity) VALUES (221, 30)
INSERT INTO Rooms (Room, Capacity) VALUES (222, 40)
INSERT INTO Rooms (Room, Capacity) VALUES (223, 50)
INSERT INTO Rooms (Room, Capacity) VALUES (224, 60)
INSERT INTO Rooms (Room, Capacity) VALUES (225, 70)
GO

INSERT INTO Sales (Invoice_Num, Invoice_Date, Sales_ID, Product_ID, Quantity, Price) VALUES (1, '1/5/99', 1, 1, 10, 25)
INSERT INTO Sales (Invoice_Num, Invoice_Date, Sales_ID, Product_ID, Quantity, Price) VALUES (2, '1/5/99', 2, 4, 2, 100)
INSERT INTO Sales (Invoice_Num, Invoice_Date, Sales_ID, Product_ID, Quantity, Price) VALUES (3, '1/6/99', 2, 2, 1, 10)
INSERT INTO Sales (Invoice_Num, Invoice_Date, Sales_ID, Product_ID, Quantity, Price) VALUES (4, '1/20/99', 3, 3, 5, 50)
INSERT INTO Sales (Invoice_Num, Invoice_Date, Sales_ID, Product_ID, Quantity, Price) VALUES (5, '1/22/99', 2, 4, 7, 90)
INSERT INTO Sales (Invoice_Num, Invoice_Date, Sales_ID, Product_ID, Quantity, Price) VALUES (6, '2/11/99', 2, 4, 1, 55)
INSERT INTO Sales (Invoice_Num, Invoice_Date, Sales_ID, Product_ID, Quantity, Price) VALUES (7, '2/15/99', 3, 5, 50, 5)
INSERT INTO Sales (Invoice_Num, Invoice_Date, Sales_ID, Product_ID, Quantity, Price) VALUES (8, '2/16/99', 3, 1, 5, 25)
INSERT INTO Sales (Invoice_Num, Invoice_Date, Sales_ID, Product_ID, Quantity, Price) VALUES (9, '2/21/99', 3, 2, 5, 50)
INSERT INTO Sales (Invoice_Num, Invoice_Date, Sales_ID, Product_ID, Quantity, Price) VALUES (10, '3/3/99', 1, 1, 50, 20)
INSERT INTO Sales (Invoice_Num, Invoice_Date, Sales_ID, Product_ID, Quantity, Price) VALUES (11, '3/6/99', 1, 1, 100, 15)
GO

INSERT INTO Salespeople (Sales_ID, Salesperson, ReportsTo_ID) VALUES (1, 'Richard', 1)
INSERT INTO Salespeople (Sales_ID, Salesperson, ReportsTo_ID) VALUES (2, 'Steve', 1)
INSERT INTO Salespeople (Sales_ID, Salesperson, ReportsTo_ID) VALUES (3, 'Tom', 2)
GO






