'Created by: X
'Copyright: Created by: X
'E-Mail: mailto:createdbyx@yahoo.com
'Web: http://www.createdbyx.com/
'Date: October 15, 2003
'=============================================

Public Class Form1
    Inherits System.Windows.Forms.Form

#Region " Windows Form Designer generated code "

    Public Sub New()
        MyBase.New()

        'This call is required by the Windows Form Designer.
        InitializeComponent()

        'Add any initialization after the InitializeComponent() call

    End Sub

    'Form overrides dispose to clean up the component list.
    Protected Overloads Overrides Sub Dispose(ByVal disposing As Boolean)
        If disposing Then
            If Not (components Is Nothing) Then
                components.Dispose()
            End If
        End If
        MyBase.Dispose(disposing)
    End Sub

    'Required by the Windows Form Designer
    Private components As System.ComponentModel.IContainer

    'NOTE: The following procedure is required by the Windows Form Designer
    'It can be modified using the Windows Form Designer.  
    'Do not modify it using the code editor.
    <System.Diagnostics.DebuggerStepThrough()> Private Sub InitializeComponent()
        components = New System.ComponentModel.Container()
        Me.Text = "Form1"
    End Sub

#End Region

    Private mobjDX9 As Microsoft.DirectX.Direct3D.Device
    Private mobjPresent As Direct3D.PresentParameters
    Private mobjMesh As Direct3D.Mesh
    Private mobjMaterial, mobjMaterialRed, mobjMaterialGreen As Direct3D.Material
    Private mobjTimer As Timer
    Private msinRotationAngle As Single

    Private Sub OneTimeInit()
        Dim objAdapters As Direct3D.AdapterInformation

        objAdapters = Direct3D.Manager.Adapters(0)

        '
        ' Setup present params
        '
        mobjPresent = New Direct3D.PresentParameters()
        With mobjPresent
            .Windowed = True
            .SwapEffect = Direct3D.SwapEffect.Discard
            .BackBufferFormat = objAdapters.CurrentDisplayMode.Format
            .EnableAutoDepthStencil = True
            .AutoDepthStencilFormat = Direct3D.DepthFormat.D16
        End With



        mobjDX9 = New Direct3D.Device(objAdapters.Adapter, Direct3D.DeviceType.Hardware, Me, _
                                      Direct3D.CreateFlags.HardwareVertexProcessing, mobjPresent)

        AddHandler mobjDX9.DeviceReset, AddressOf Me.OnDeviceReset
    End Sub

    Private Sub frmMain_Load(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles MyBase.Load
        OneTimeInit()
        InitializeDirect3D()
        StartRefreshCycle()
    End Sub

    Private Sub StartRefreshCycle()

        mobjTimer = New Timer()
        mobjTimer.Enabled = True
        mobjTimer.Interval = 20
        AddHandler mobjTimer.Tick, AddressOf Me.FrameMove
        mobjTimer.Start()
    End Sub

    Private Sub InitializeDirect3D()
        CreateCube()
        CreateMaterials()
        CreateLights()
        InitializeView()
    End Sub

    Private Sub OnDeviceReset(ByVal Sender As Object, ByVal e As EventArgs)
        InitializeDirect3D()
    End Sub

    Private Sub CreateCube()

        mobjMesh = Direct3D.Mesh.Box(mobjDX9, 10, 10, 10)
    End Sub

    Private Sub CreateMaterials()

        mobjMaterial = New Direct3D.Material()
        mobjMaterial.Diffuse = Color.FromArgb(1, 0, 0, 255)

        mobjMaterialRed = New Direct3D.Material()
        mobjMaterialRed.Diffuse = Color.FromArgb(1, 255, 0, 0)

        mobjMaterialGreen = New Direct3D.Material()
        mobjMaterialGreen.Diffuse = Color.FromArgb(1, 0, 255, 0)
    End Sub

    Private Sub CreateLights()
        Dim Light0 As Direct3D.Light = mobjDX9.Lights(0)

        Light0.Type = Direct3D.LightType.Directional
        Light0.Direction = New Vector3(0, -1, 1)
        Light0.Diffuse = Color.FromArgb(0, 255, 255, 255)
        Light0.Ambient = Color.FromArgb(0, 255, 255, 255)
        Light0.Enabled = True
        Light0.Commit()

        mobjDX9.RenderState.Lighting = True
        mobjDX9.RenderState.Ambient = Color.FromArgb(0, 20, 20, 20)
    End Sub

    Private Sub InitializeView()

        Dim eyePosition As New Vector3(0, 0, -30)
        Dim direction As New Vector3(0, 0, 0)
        Dim upDirection As New Vector3(0, 1, 0)

        Dim view As Matrix = Matrix.LookAtLH(eyePosition, direction, upDirection)
        mobjDX9.SetTransform(Direct3D.TransformType.View, view)

        Dim fieldOfView As Single = Math.PI / 4
        Dim aspectRatio As Single = 1.0
        Dim nearPlane As Single = 1.0
        Dim farPlane As Single = 500.0

        Dim projection As Matrix = Matrix.PerspectiveFovLH(fieldOfView, aspectRatio, nearPlane, farPlane)
        mobjDX9.SetTransform(Direct3D.TransformType.Projection, projection)
    End Sub

    Private Sub FrameMove(ByVal sender As Object, ByVal e As EventArgs)
        Dim V As Direct3D.Viewport

        msinRotationAngle += 0.05F
        ' VB has no %= operator
        'msinRotationAngle %= Direct3D.Geometry.DegreeToRadian(360)

        Dim rotateZ As Matrix = Matrix.RotationZ(msinRotationAngle)
        Dim rotateY As Matrix = Matrix.RotationY(msinRotationAngle)
        Dim world As Matrix = Matrix.Multiply(rotateZ, rotateY)
        mobjDX9.SetTransform(Direct3D.TransformType.World, world)

        '--------------------------------------------------
        mobjDX9.Clear(Direct3D.ClearFlags.Target Or Direct3D.ClearFlags.ZBuffer, Color.Black.ToArgb(), 1.0, 0)
        mobjDX9.BeginScene()
        mobjDX9.Material = mobjMaterial
        mobjMesh.DrawSubset(0)
        '--------------------------------------------------


        ' render viewport 1
        V = mobjDX9.Viewport
        V.X = 0
        V.Y = 0
        V.Width = Me.ClientSize.Width \ 2
        V.Height = Me.ClientSize.Height \ 2
        mobjDX9.Viewport = V

        mobjDX9.Clear(Direct3D.ClearFlags.Target Or Direct3D.ClearFlags.ZBuffer, Color.Red.ToArgb(), 1.0, 0)
        mobjDX9.Material = mobjMaterialGreen
        mobjMesh.DrawSubset(0)

        ' render viewport 2
        V.X = Me.ClientSize.Width \ 2
        V.Y = Me.ClientSize.Height \ 2
        V.Width = Me.ClientSize.Width \ 2
        V.Height = Me.ClientSize.Height \ 2
        mobjDX9.Viewport = V

        mobjDX9.Clear(Direct3D.ClearFlags.Target Or Direct3D.ClearFlags.ZBuffer, Color.Green.ToArgb(), 1.0, 0)
        mobjDX9.Material = mobjMaterialRed
        mobjMesh.DrawSubset(0)

        mobjDX9.EndScene()
        mobjDX9.Present()


        V.X = 0
        V.Y = 0
        V.Width = Me.ClientSize.Width
        V.Height = Me.ClientSize.Height
        mobjDX9.Viewport = V
    End Sub

    Private Sub Render(Optional ByVal DoClear As Boolean = True, Optional ByVal DoPresent As Boolean = True)

        If DoClear Then mobjDX9.Clear(Direct3D.ClearFlags.Target Or Direct3D.ClearFlags.ZBuffer, Color.Black.ToArgb(), 1.0, 0)

        mobjDX9.BeginScene()
        mobjDX9.Material = mobjMaterial

        mobjMesh.DrawSubset(0)

        mobjDX9.EndScene()
        If DoPresent Then mobjDX9.Present()
    End Sub


    Protected Overrides Sub Finalize()
        MyBase.Finalize()

        mobjTimer.Dispose()
        mobjMesh.Dispose()
        mobjDX9.Dispose()
    End Sub
End Class
