<%@ Page Language="VB" Debug="true" %>
<%@ import Namespace="System.Io" %>
<%@ import Namespace="System.Data" %>
<%@ import Namespace="System.Data.oledb" %>
<script runat="server">

    dim AccountNumber as Integer = 1 'you could customize this to have multiple accounts
                  dim filename as string
                  dim filename1 as string
                  dim filename2 as string
                  dim Filesize as string
                  dim FileNameToDelete as string
                  dim MaxOfSortPosition as integer
                  Dim MyConn as OleDbConnection
                  Dim ConnStr as String
                  Dim ConnectionString As String = "Provider=Microsoft.Jet.OLEDB.4.0;Data Source=" & Server.MapPath("data.mdb")
                  Dim SelectCommand As String = "SELECT Entry_ID, Account_Number, Filename, Comments, SortPosition FROM Pictures WHERE Pictures.Account_Number=" & AccountNumber & " ORDER BY SortPosition;"


                  Dim isEditing As Boolean = False

                  Sub Page_Load(Sender As Object, E As EventArgs)

                    If len(HttpContext.Current.Session("User")) <1 Then
                        ' NOT Logged in
                        Response.Redirect("login.aspx")
                    End IF

                      If Not Page.IsPostBack Then

                          ' Databind the data grid on the first request only
                          ' (on postback, bind only in editing, paging and sorting commands)

                          BindGrid()

                      End If

                  End Sub

                  ' ---------------------------------------------------------------
                  '
                  ' DataGrid Commands
                  '

                  Sub DataGrid_ItemCommand(Sender As Object, E As DataGridCommandEventArgs)

                      ' this powerful event fires prior to all of the other commands on the datagrid.
                      ' This is where you can get the values of all your custom controls
                      ' like the up and down buttons. Also to check if the datagrid is in
                      ' the middle of being edited

                      CheckIsEditing(e.CommandName)
                  If Not isEditing Then
                      ' Check to see if the up or down button has been pressed
                      Select e.commandName
                          'send the datagrid object(Sender) and the arguments(e) to the sub routines
                          Case "up"
                              Up_Button(Sender,E)
                          Case "down"
                              Down_Button(Sender,E)
                      End Select

                  End If

                  End Sub

              Sub Up_Button(Sender As Object, E As DataGridCommandEventArgs)
                  Dim PreviousRow As Integer
                  Dim GridItem As DataGridItem
                  Dim CurrentRow As Integer = e.Item.ItemIndex
                  Dim CurrentPosition As Integer = CType(e.Item.FindControl("Position"), TextBox).Text
                  Dim CurrentEntry_Id As Integer = CType(e.Item.FindControl("myEntry_Id"), TextBox).Text

                  ' Get previous row - the array is zero based so row one is zero
                  If CurrentRow > 0 Then
                      PreviousRow = e.Item.ItemIndex - 1
                  Else
                      PreviousRow = 0
                  End If

                  GridItem = DataGrid1.Items(PreviousRow)
                  Dim PreviousPosition As Integer = CType(GridItem.FindControl("Position"), TextBox).Text
                  Dim PreviousEntry_Id As Integer = CType(GridItem.FindControl("myEntry_Id"), TextBox).Text

                  ' Don't move the row if we are at the first row
                  If CurrentRow > 0 Then
                      MoveRecord(Sender,E,CurrentPosition,currentEntry_Id,PreviousPosition,PreviousEntry_Id)
                  End If

              End Sub

              Sub Down_Button(Sender As Object, E As DataGridCommandEventArgs)
                  Dim NextRow As Integer
                  ' Subtract 1 from the total rows because the array is zero based so we subtract one to account for row zero
                  Dim TotalRows As Integer = DataGrid1.Items.count - 1
                  Dim GridItem As DataGridItem
                  Dim CurrentRow As Integer = e.Item.ItemIndex
                  Dim CurrentPosition As Integer = CType(e.Item.FindControl("Position"), TextBox).Text
                  Dim CurrentEntry_Id As Integer = CType(e.Item.FindControl("myEntry_Id"), TextBox).Text


                  ' Get next row
                  If CurrentRow < TotalRows Then
                      NextRow = e.Item.ItemIndex + 1
                  Else
                      NextRow = TotalRows
                  End If

                  GridItem = DataGrid1.Items(NextRow)
                  Dim NextPosition As Integer = CType(GridItem.FindControl("Position"), TextBox).Text
                  Dim NextEntry_Id As Integer = CType(GridItem.FindControl("myEntry_Id"), TextBox).Text

                  ' Don't move the row if we are at the end
                  If CurrentRow < TotalRows Then
                      MoveRecord(Sender,E,CurrentPosition,currentEntry_Id,NextPosition,NextEntry_Id)
                  End If

              End Sub

              Sub MoveRecord(Sender As Object, E As DataGridCommandEventArgs, position1 As Integer,Entry_ID1 As Integer,position2 As Integer,Entry_ID2 As Integer)
              ' This sub simply puts position2 with record Entry_ID1 and position1 with record Entry_ID2

                  Dim myConnection As New oledbConnection(ConnectionString)
                  Dim UpdateCommand As oledbCommand = new oledbCommand()
                  UpdateCommand.Connection = myConnection

                  UpdateCommand.CommandText = "UPDATE Pictures SET SortPosition = @SortPosition1 WHERE Entry_ID = @Entry_ID2"
                      UpdateCommand.Parameters.Add("@SortPosition1", oledbType.Integer).Value = position1
                      UpdateCommand.Parameters.Add("@Entry_ID2", oledbType.Integer).Value = Entry_ID2

                  myConnection.Open()
                  UpdateCommand.ExecuteNonQuery()
                  myConnection.Close()

                  Dim UpdateCommand2 As oledbCommand = new oledbCommand()
                  UpdateCommand2.Connection = myConnection
                  UpdateCommand2.CommandText = "UPDATE Pictures SET SortPosition = @SortPosition2 WHERE Entry_ID = @Entry_ID1"
                      UpdateCommand2.Parameters.Add("@SortPosition2", oledbType.Integer).Value = position2
                      UpdateCommand2.Parameters.Add("@Entry_ID1", oledbType.Integer).Value = Entry_ID1

                  myConnection.Open()
                  UpdateCommand2.ExecuteNonQuery()
                  myConnection.Close()


                      ' Resort the grid for new records
                      If AddingNew = True Then
                          DataGrid1.CurrentPageIndex = 0
                          AddingNew = false
                      End If

                      ' rebind the grid
                      DataGrid1.EditItemIndex = -1
                      BindGrid()


                 'SET the focus on the grid to the last item that was moved
                 'to do this we have to first make the Anchor_Entry_ID control visible, set the focus, then make it invisable again
                 'This should work with IE and Opera web browsers. If there are problems simply comment out these
                 'lines.

                 ' Create a reference to the TextBox
                 Dim Anchor_Entry_ID as Textbox
                 Anchor_Entry_ID = Datagrid1.Items(e.Item.ItemIndex).Cells(1).FindControl("Anchor_Entry_ID")
                 RegisterStartupScript("focus", "<script language=""JavaScript"">" & _
                 vbCrLf & vbTab & "galleryadmin." & Anchor_Entry_ID.ClientID & ".style.visibility='visible';" & _
                 vbCrLf & vbTab & "galleryadmin." & Anchor_Entry_ID.ClientID & ".focus();" & _
                 vbCrLf & vbTab & "galleryadmin." & Anchor_Entry_ID.ClientID & ".select();" & _
                 vbCrLf & vbTab & "galleryadmin." & Anchor_Entry_ID.ClientID & ".style.visibility='hidden';" & _
                 vbCrLf & "<" & "/script>")

              End Sub



                  Sub CheckIsEditing(commandName As String)

                      If DataGrid1.EditItemIndex <> -1 Then

                          ' we are currently editing a row
                          If commandName <> "Cancel" And commandName <> "Update" Then

                              ' user's edit changes (If any) will not be committed
                              Message.Text = "Your changes have not been saved yet.  Please press update to save your changes, or cancel to discard your changes, before selecting another item."
                              isEditing = True

                          End If

                      End If

                  End Sub

                  Sub DataGrid_Edit(Sender As Object, E As DataGridCommandEventArgs)

                      ' turn on editing for the selected row

                      If Not isEditing Then

                          DataGrid1.EditItemIndex = e.Item.ItemIndex
                          BindGrid()

                     ' Create a reference to the TextBox
                         Dim Comments as TextBox
                         Comments = Datagrid1.Items(e.Item.ItemIndex).Cells(3).FindControl("Comments")

                     'Set the script to focus and select the TextBox
                         RegisterStartupScript("focus", "<script language=""JavaScript"">" & vbCrLf & _
                         vbTab & "galleryadmin." & Comments.ClientID & ".focus();" & _
                         vbCrLf & vbTab & "galleryadmin." & Comments.ClientID & ".select();" & _
                         vbCrLf & "<" & "/script>")

                      End If

                  End Sub

                  Sub DataGrid_Update(Sender As Object, E As DataGridCommandEventArgs)

                      ' update the database with the new values


                      ' the key value for this row is in the DataKeys collection
                      Dim keyValue As String = CStr(DataGrid1.DataKeys(e.Item.ItemIndex))

                      ' get the edit text boxes
                      Dim Entry_ID As Integer = keyValue
                      Dim Account_Number As Integer = AccountNumber
                      'Dim Filename As String = CType(e.Item.Cells(2).Controls(0), TextBox).Text
                      Dim Filename As String = CType(e.Item.FindControl("filename"), label).Text
                      Dim Comments As String = CType(e.Item.FindControl("Comments"), TextBox).Text
                      Dim SortPosition As Integer = CType(e.Item.FindControl("Position"), TextBox).Text

                      ' TODO: update the Command value for your application
                      Dim myConnection As New oledbConnection(ConnectionString)
                      Dim UpdateCommand As oledbCommand = new oledbCommand()
                      UpdateCommand.Connection = myConnection

                          UpdateCommand.CommandText = "UPDATE Pictures SET Account_Number = @Account_Number, Filename = @Filename, Comments = @Comments, SortPosition = @SortPosition WHERE Entry_ID = @Entry_ID"
                              UpdateCommand.Parameters.Add("@Account_Number", oledbType.Integer).Value = Account_Number
                              UpdateCommand.Parameters.Add("@Filename", oledbType.VarChar, 50).Value = Filename
                              UpdateCommand.Parameters.Add("@Comments", oledbType.VarChar, 255).Value = Comments
                              UpdateCommand.Parameters.Add("@SortPosition", oledbType.Integer).Value = SortPosition
                              UpdateCommand.Parameters.Add("@Entry_ID", oledbType.Integer).Value = Entry_ID

                      ' execute the command
                      Try
                          myConnection.Open()
                          UpdateCommand.ExecuteNonQuery()

                      Catch ex as Exception
                          Message.Text = ex.ToString()

                      Finally
                          myConnection.Close()

                      End Try

                      ' Resort the grid for new records
                      If AddingNew = True Then
                          DataGrid1.CurrentPageIndex = 0
                          AddingNew = false
                      End If

                      ' rebind the grid
                      DataGrid1.EditItemIndex = -1
                      BindGrid()

                  End Sub


                  Sub DataGrid_Cancel(Sender As Object, E As DataGridCommandEventArgs)

                      ' cancel editing

                      DataGrid1.EditItemIndex = -1
                      BindGrid()

                      AddingNew = False

                  End Sub

                  Sub DataGrid_Delete(Sender As Object, E As DataGridCommandEventArgs)

                      ' delete the selected row

                      If Not isEditing Then

                          ' the key value for this row is in the DataKeys collection
                          Dim keyValue As String = CStr(DataGrid1.DataKeys(e.Item.ItemIndex))
                          FileNameToDelete = GetFileNameToDelete(keyValue)
                          Dim myConnection As New oledbConnection(ConnectionString)
                          Dim DeleteCommand As New oledbCommand("DELETE from Pictures where Entry_ID=" & keyValue & "", myConnection)

                          ' execute the command
                          myConnection.Open()
                          DeleteCommand.ExecuteNonQuery()
                          myConnection.Close()

                        ' delete the file and the thumbnail from the harddrive
                        File.Delete(Server.MapPath("images\" & FileNameToDelete))
                        File.Delete(Server.MapPath("images\slideshow\" & FileNameToDelete))
                        File.Delete(Server.MapPath("images\thumbnails\" & FileNameToDelete))


                          ' rebind the grid
                          DataGrid1.CurrentPageIndex = 0
                          DataGrid1.EditItemIndex = -1
                          BindGrid()

                      End If

                  End Sub


                  ' *********************************************************************************
                  ' Custom Subs
                  ' *********************************************************************************

                  Sub Insert_Into_DataBase(filename, comments)

                      ' Get the highest sort position and store it in MaxOfSortPosition
                      GetMaxOfSortPosition()

                      ' TODO: update the Command value for your application
                      Dim myConnection As New oledbConnection(ConnectionString)
                      Dim UpdateCommand As oledbCommand = new oledbCommand()
                      UpdateCommand.Connection = myConnection

                          UpdateCommand.CommandText = "INSERT INTO Pictures(Account_Number, Filename, Comments, SortPosition) VALUES (@Account_Number, @Filename, @Comments, @SortPosition)"
                              UpdateCommand.Parameters.Add("@Account_Number", oledbType.Integer).Value = AccountNumber
                              UpdateCommand.Parameters.Add("@Filename", oledbType.VarChar, 50).Value = Filename
                              UpdateCommand.Parameters.Add("@Comments", oledbType.VarChar, 255).Value = Comments
                              UpdateCommand.Parameters.Add("@SortPosition", oledbType.Integer).Value = MaxOfSortPosition


                      ' execute the command
                      Try
                          myConnection.Open()
                          UpdateCommand.ExecuteNonQuery()

                      Catch ex as Exception
                          Message.Text = ex.ToString()

                      Finally
                          myConnection.Close()

                      End Try

                      ' Resort the grid for new records
                      If AddingNew = True Then
                          DataGrid1.CurrentPageIndex = 0
                          AddingNew = false
                      End If

                      ' rebind the grid
                      DataGrid1.EditItemIndex = -1
                      BindGrid()

                  End Sub

                  Sub GetMaxOfSortPosition()
                      Dim SortCommand As String = "SELECT Max(SortPosition) AS MaxOfSortPosition FROM Pictures WHERE Account_Number=" & AccountNumber & ";"
                      Dim conn as New oledbConnection(ConnectionString)
                      Dim objDR as oledbDataReader
                      Dim Cmd as New oledbCommand(SortCommand, conn)
                      conn.Open()
                      objDR=Cmd.ExecuteReader(system.data.CommandBehavior.CloseConnection)
                      While objDR.Read()
                          If IsDBNULL(objDR("MaxOfSortPosition")) Then
                              MaxOfSortPosition = 0
                          Else
                              MaxOfSortPosition=objDR("MaxOfSortPosition")
                          End If
                      End While
                      ' Now increase the sort position by one
                      MaxOfSortPosition = MaxOfSortPosition + 1
                  End Sub

                  Sub SaveThumbnail(Filename2)
                      ' Initialize objects
                      Dim objImage, objThumbnail As System.Drawing.Image
                      Dim strServerPath, strFilename As String
                      Dim shtWidth, shtHeight As Short

                      objImage = objImage.FromFile(Server.MapPath("images/" & Filename2))
                      ' set width
                      shtWidth = 100
                      ' Work out a proportionate height from width
                      shtHeight = objImage.Height / (objImage.Width / shtWidth)
                      ' Create thumbnail
                      objThumbnail = objImage.GetThumbnailImage(shtWidth, shtHeight, Nothing, System.IntPtr.Zero)
                      ' Send down to client
                      objThumbnail.Save(Server.MapPath("images/thumbnails/" & Filename2), System.Drawing.Imaging.ImageFormat.Jpeg)
                      ' Tidy up
                      objImage.Dispose()
                      objThumbnail.Dispose()
                  End Sub

                  Sub SaveSlideShow(Filename2)
                      ' Initialize objects
                      Dim objImage, objThumbnail As System.Drawing.Image
                      Dim strServerPath, strFilename As String
                      Dim shtWidth, shtHeight As Short

                      objImage = objImage.FromFile(Server.MapPath("images/" & Filename2))

                      If objImage.Width > objImage.Height Then
                      ' The image is a landscape image
                        ' set width
                        shtWidth = 450
                        ' Work out a proportionate height from width
                        shtHeight = objImage.Height / (objImage.Width / shtWidth)
                      Else
                        ' set width
                        shtWidth = 300
                        ' Work out a proportionate height from width
                        shtHeight = objImage.Height / (objImage.Width / shtWidth)
                      End If

                      ' Create thumbnail
                      objThumbnail = objImage.GetThumbnailImage(shtWidth, shtHeight, Nothing, System.IntPtr.Zero)
                      ' Send down to client
                      objThumbnail.Save(Server.MapPath("images/slideshow/" & Filename2), System.Drawing.Imaging.ImageFormat.Jpeg)
                      ' Tidy up
                      objImage.Dispose()
                      objThumbnail.Dispose()
                  End Sub


                  ' ---------------------------------------------------------------
                  '
                  ' Helpers Methods:
                  '

                  ' property to keep track of whether we are adding a new record,
                  ' and save it in viewstate between postbacks

                  Property AddingNew() As Boolean

                      Get
                          Dim o As Object = ViewState("AddingNew")
                          If o Is Nothing Then
                              Return False
                          End If
                          Return CBool(o)
                      End Get

                      Set(ByVal Value As Boolean)
                          ViewState("AddingNew") = Value
                      End Set

                  End Property

                  Sub BindGrid()

                      Dim myConnection As New oledbConnection(ConnectionString)
                      Dim myCommand As New oledbDataAdapter(SelectCommand, myConnection)

                      Dim ds As New DataSet()
                      myCommand.Fill(ds)

                      DataGrid1.DataSource = ds
                      DataGrid1.DataBind()

                  End Sub

                  ' *********************************************************************************
                  ' Click Events
                  ' *********************************************************************************

                  Sub Upload_Button_Click(sender As Object, e As EventArgs)

                  'set PassedVAlidation
                  Dim PassedVAlidation as String = "False"

                  ' Get the file name from the input string
                  Filename1= GetFileName(File1.PostedFile.FileName)

                  ' Must have something to upload
                  If (CStr(File1.PostedFile.ContentLength) > 1) Then
                    PassedVAlidation = "True"
                  Else
                     ' There was a problem
                     Upload_Message.Text = "Click BROWSE to locate an image then click UPLOAD to upload it."
                  End If

                  ' Must be less than 500k
                  If (CStr(File1.PostedFile.ContentLength) < 500000) and (PassedVAlidation = "True") Then
                    PassedVAlidation = "True"
                  Else
                     If PassedVAlidation = "True" Then
                        Upload_Message.Text = "You may only upload images that are less that 500 kbs"
                     End If
                  End If

                 ' Must be a .jpg file
                  If (GetFileExtension(Filename1) = "jpg" or GetFileExtension(Filename1) = "JPG" or GetFileExtension(Filename1) = "jpeg" or GetFileExtension(Filename1) = "JPEG") and (PassedVAlidation = "True") Then
                    PassedVAlidation = "True"
                  Else
                     If PassedVAlidation = "True" Then
                        Upload_Message.Text = "You may only upload '.Jpg' images"
                     End If
                  End If

                  If PassedVAlidation = "True" Then
                      ' Get a unique file name
                      Filename2= UniqueFileName() & ".jpg"
                      ' Save file to harddrive
                      File1.PostedFile.SaveAs(Server.MapPath("images/" & Filename2))
                      ' Save the thumbnail
                      SaveThumbnail(Filename2)
                      ' Save the slideshow image
                      SaveSlideShow(Filename2)
                      ' Save the filename to the database
                      Insert_Into_DataBase(Filename2,Upload_Comment.text)
                      ' Clear the Comment box
                      Upload_Comment.text = ""
                  End If


                  End Sub


                  ' *********************************************************************************
                  ' FUNCTIONS
                  ' *********************************************************************************

                  Function GetFileName(fname As String) As String
                      Dim i As Long
                      On Error Resume Next
                      For i = Len(fname) To 1 Step -1
                      If Mid(fname, i, 1) = "\" Then
                      Exit For
                      End If
                      Next i
                      GetFileName = Trim(Mid(fname, i + 1))
                  End Function

                  Function GetFileNameToDelete(Entry_ID As integer) As String
                      Dim SortCommand As String = "SELECT Filename FROM Pictures WHERE Pictures.Entry_ID=" & Entry_ID & ";"
                      Dim conn as New oledbConnection(ConnectionString)
                      Dim objDR as oledbDataReader
                      Dim Cmd as New oledbCommand(SortCommand, conn)
                      conn.Open()
                      objDR=Cmd.ExecuteReader(system.data.CommandBehavior.CloseConnection)
                      While objDR.Read()
                         GetFileNameToDelete=objDR("Filename")
                      End While
                  End Function

                  Public Function GetImage_Location(ByVal Image_Location As Object, ByVal Entry_Id As Object) As String
                      If Image_Location Is DBNull.Value Then
                          Return ""
                      Else
                          Return "<a target='_blank' href='images/" & Image_Location.ToString() & "'><img border='1' src='images/thumbnails/" & Image_Location.ToString() & "' /></a>"
                      End If
                  End Function

                  Public Function UniqueFileName() As String
                      ' Create a unique file name
                      Dim myDate As Date = Now()
                      Dim myTimeString as String = myDate.ToLongTimeString().Replace(":","u")
                      myTimeString = myTimeString.Replace(" AM","11")
                      myTimeString = myTimeString.Replace(" PM","99")
                      myTimeString = MyTimeString & Session.SessionID
                      UniqueFileName = AccountNumber & "_" & MyTimeString
                      Return UniqueFileName
                  End Function

                  Function GetFileExtension(ByVal FileName As String) As String
                      Dim i As Long
                      For i = Len(FileName) To 1 Step -1
                          Select Case Mid$(FileName, i, 1)
                              Case "."
                                  GetFileExtension = Mid$(FileName, i + 1)
                                  Exit For
                              Case ":", "\"
                                  Exit For
                          End Select
                      Next
                  End Function

</script>
<html>
<head>
</head>
<body style="FONT-FAMILY: arial">
    <h2>Def Gallery - Administration&nbsp;
    </h2>
    <p>
        <asp:HyperLink id="HyperLink1" NavigateUrl="default.aspx" Width="169px" runat="server">Back to Gallery</asp:HyperLink>
    </p>
    <p>
        <hr size="1" />
    </p>
    <p>
    </p>
    <p>
    </p>
    <p>
    </p>
    <p>
    </p>
    <p>
    </p>
    <p>
    </p>
    <p>
    </p>
    <form id="galleryadmin" runat="server">
        <div align="center">
            <table id="table1" width="60%" border="0">
                <tbody>
                    <tr>
                        <td align="right">
                            <strong>Select File to Upload:</strong></td>
                        <td>
                            <input id="File1" style="WIDTH: 276px; HEIGHT: 22px" type="file" maxlength="30" accept="image/*" size="26" name="File1" runat="server" /></td>
                    </tr>
                    <tr>
                        <td align="right">
                            &nbsp;<strong>Comments:</strong></td>
                        <td>
                            <asp:TextBox id="Upload_Comment" Width="277px" runat="server" MaxLength="200" Rows="1" TextMode="MultiLine" EnableViewState="False"></asp:TextBox>
                        </td>
                    </tr>
                    <tr>
                        <td colspan="2">
                            <p align="center">
                                <asp:Button id="Upload_Button" onclick="Upload_Button_Click" Width="173px" runat="server" Font-Bold="True" Text="Upload"></asp:Button>
                            </p>
                        </td>
                    </tr>
                    <tr>
                        <td colspan="2">
                            <p align="center">
                                &nbsp;<asp:Label id="Upload_Message" runat="server" enableviewstate="False" forecolor="Red" font-bold="True"></asp:Label>
                            </p>
                        </td>
                    </tr>
                </tbody>
            </table>
        </div>
        <p align="center">
        </p>
        <p align="center">
            <asp:datagrid id="DataGrid1" runat="server" BorderColor="Gray" BorderWidth="1px" width="80%" CellSpacing="1" CellPadding="2" BackColor="White" ForeColor="Black" OnDeleteCommand="DataGrid_Delete" OnCancelCommand="DataGrid_Cancel" OnUpdateCommand="DataGrid_Update" OnEditCommand="DataGrid_Edit" OnItemCommand="DataGrid_ItemCommand" DataKeyField="Entry_ID" AutoGenerateColumns="False" HorizontalAlign="Center">
                <FooterStyle backcolor="#C6C3C6"></FooterStyle>
                <HeaderStyle font-names="Arial" font-bold="True" wrap="False" horizontalalign="Center" forecolor="White" backcolor="Silver"></HeaderStyle>
                <PagerStyle font-size="Smaller" horizontalalign="Right" backcolor="#C6C3C6" mode="NumericPages"></PagerStyle>
                <ItemStyle forecolor="Black" backcolor="White"></ItemStyle>
                <Columns>
                    <asp:TemplateColumn HeaderText="Edit">
                        <ItemStyle horizontalalign="Center" width="10%"></ItemStyle>
                        <ItemTemplate>
                            <asp:LinkButton id="cmdEdit" runat="server" Text="Edit" CommandName="Edit" CausesValidation="false">Edit</asp:LinkButton>
                            <br />
                            <asp:LinkButton id="cmdDel" runat="server" Text="Delete" CommandName="Delete" CausesValidation="false">Delete</asp:LinkButton>
                        </ItemTemplate>
                        <EditItemTemplate>
                            <asp:LinkButton id="cmdUpdate" runat="server" Text="Update" CommandName="Update" CausesValidation="false">Update</asp:LinkButton>
                            <br />
                            <asp:LinkButton id="cmdCancel" runat="server" Text="Cancel" CommandName="Cancel" CausesValidation="false">Cancel</asp:LinkButton>
                        </EditItemTemplate>
                    </asp:TemplateColumn>
                    <asp:TemplateColumn HeaderText="Position">
                        <ItemStyle horizontalalign="Center" width="10%"></ItemStyle>
                        <ItemTemplate>
                            <asp:TextBox runat="server" Size="1" Rows="1" Width="0px" style="visibility: hidden;" id="Position" Text='<%# DataBinder.Eval(Container, "DataItem.SortPosition") %>'></asp:TextBox>
                            <br />
                            <asp:LinkButton id="cmdDown" runat="server" CommandName="down" CausesValidation="false" style="text-decoration: none">
                                <Image src="down_arrow.gif" border="0">
                                    </asp:LinkButton>
                            <asp:LinkButton id="cmdUp" runat="server" CommandName="up" CausesValidation="false" style="text-decoration: none">
                                <Image src="up_arrow.gif" border="0">
                                    </asp:LinkButton>
                            <br />
                            <asp:TextBox id="Anchor_Entry_ID" runat="server" style="visibility: hidden;" Text='' Size="1" Rows="1" Width="0px"></asp:TextBox>
                            </ItemTemplate>
                            <EditItemTemplate>
                                <asp:TextBox runat="server" visible="False" id="Position" Text='<%# DataBinder.Eval(Container, "DataItem.SortPosition") %>'></asp:TextBox>
                                <asp:LinkButton id="cmdDown" runat="server" CommandName="down" CausesValidation="false" style="text-decoration: none">
                                    <Image src="down_arrow.gif" border="0">
                                        </asp:LinkButton>
                                <asp:LinkButton id="cmdUp" runat="server" CommandName="up" CausesValidation="false" style="text-decoration: none">
                                    <Image src="up_arrow.gif" border="0">
                                        </asp:LinkButton>
                                </EditItemTemplate>
                                </asp:TemplateColumn>
                    <asp:TemplateColumn HeaderText="Picture">
                        <ItemStyle horizontalalign="Center" width="10%"></ItemStyle>
                        <ItemTemplate>
                            <%# GetImage_Location(container.dataitem("Filename"),container.dataitem("Entry_ID")) %>
                        </ItemTemplate>
                        <EditItemTemplate>
                            <%# GetImage_Location(container.dataitem("Filename"),container.dataitem("Entry_ID")) %> <asp:Label visible="False" runat="server" id="filename" text='<%# DataBinder.Eval(Container, "DataItem.Filename") %>'></asp:Label>
                        </EditItemTemplate>
                    </asp:TemplateColumn>
                    <asp:TemplateColumn HeaderText="Comments">
                        <ItemTemplate>
                            <asp:Label width="80%" runat="server" id="Comments" text='<%# DataBinder.Eval(Container, "DataItem.Comments") %>'></asp:Label>
                            <asp:TextBox Rows="1" Columns="2" visible= "false" runat="server" id="myEntry_ID" Text='<%# DataBinder.Eval(Container, "DataItem.Entry_ID") %>'></asp:TextBox>
                        </ItemTemplate>
                        <EditItemTemplate>
                            <asp:TextBox Rows="2" TextMode="MultiLine" Columns="50" runat="server" id="Comments" Text='<%# DataBinder.Eval(Container, "DataItem.Comments") %>'></asp:TextBox>
                            <asp:TextBox Rows="1" Columns="2" visible= "false" runat="server" id="myEntry_ID" Text='<%# DataBinder.Eval(Container, "DataItem.Entry_ID") %>'></asp:TextBox>
                        </EditItemTemplate>
                    </asp:TemplateColumn>
                    </Columns>
                    </asp:datagrid>
            </p>
            <p>
                <br />
                <asp:Label id="Message" runat="server" enableviewstate="false" forecolor="red" width="80%"></asp:Label>
            </p>
            </form>
            </body>
            </html>
