﻿<%@ Page Language="VB" Debug="true" %>
<%@ import Namespace="System.Io" %>
<%@ import Namespace="System.Data" %>
<%@ import Namespace="System.Data.oledb" %>
<script runat="server">

    dim AccountNumber as Integer = 1 'you could customize this to have multiple accounts
          Dim MyConn as OleDbConnection
          Dim ConnStr as String
    
          Dim Display_Filename as String
          Dim ImageFilename as String
          Dim ImageWidth, ImageHeight As Short
          Dim imagenumber as Integer
          Dim imagename as String
          Dim imagecomments as String
          Dim numberofimages as Integer
          Dim numberofpages as Integer
          Dim ScrollText as String
          Dim ScrollText2 as String
          Dim ID as Integer
    
          Dim ConnectionString As String = "Provider=Microsoft.Jet.OLEDB.4.0;Data Source=" & Server.MapPath("data.mdb")
          Dim SelectCommand As String = "SELECT Entry_ID, Account_Number, Filename, Comments, SortPosition FROM Pictures WHERE Pictures.Account_Number=" & AccountNumber & " ORDER BY SortPosition;"
    
          Dim myConnection As New oledbConnection(ConnectionString)
          Dim myCommand As New oledbDataAdapter(SelectCommand, myConnection)
    
          Dim ds As New DataSet()
    
    
          Sub Page_Load(Sender As Object, E As EventArgs)
    
              ' Fill the dataset with the list of the pictures
              myCommand.Fill(ds)
              'How many images are there in the dataset?
              numberofimages = ds.Tables(0).Rows.Count - 1
              If numberofimages > -1 Then
                ' Try to grab the ID from the querystring
                ' There will only be avalue here if a thumbnail was clicked
                ID = Request.QueryString("ID")
    
    
                If Not Page.IsPostBack Then
                    ' Check to see if an ID number was passed when a thumbnail was clicked
                    If ID > 0 Then
                            ' Loop through the rows of the dataset looking for the ID number
                            For i as integer = 0 to numberofimages
                                If ds.Tables(0).Rows(i).Item(0).ToString() = ID Then
                                    ' When the ID number is found then imagenumber is set to the index of the
                                    ' row in the dataset
                                    imagenumber = i
                                End If
                            Next i
                        ' Set the hidden text box that tells us what image we are on
                        Imagenumber_box.Text = imagenumber
                        ' Display the image that was selected
                        DisplayImage(imagenumber, numberofimages)
    
                    Else
                        ' This s the first time we have cometo the page
                        BindPicture()
                    End If
    
                End If
               Else
                ' There are no images to display so hide everything on the page
                Image_Panel.Visible = "False"
                Thumbnail_Panel.Visible = "False"
                ThumbnailButton.Visible = "False"
                ImageButton.Visible = "False"
               End If
    
          End Sub
    
          Sub BindPicture()
    
              numberofimages = ds.Tables(0).Rows.Count - 1
              If numberofimages > -1 Then
                imagename = ds.Tables(0).Rows(0).Item(2).ToString()
                imagecomments = ds.Tables(0).Rows(0).Item(3).ToString()
                Imagenumber_box.Text = 0
    
                imagenumber = Imagenumber_box.Text
    
                DisplayImage(imagenumber, numberofimages)
    
                ' Fill array for thumbnails
                Dim Thumbnails as New PagedDataSource()
                Thumbnails.Datasource = ds.Tables(0).DefaultView
                Thumbnails.AllowPaging = True
                Thumbnails.PageSize = 8
    
                Thumbnails.CurrentPageIndex = CurrentPage
                numberofpages = Thumbnails.PageCount.ToString()
                NumberOfPagesTextBox.Text = numberofpages
    
                Thumbnail_Scroll_Label.Text = "" & (CurrentPage + 1).ToString() & " of " & numberofpages
    
                Thumbnail_DataList.DataSource = Thumbnails
                Thumbnail_DataList.DataBind()
               End If
          End Sub
    
          Sub DisplayImage(imagenumber, numberofimages)
    
              imagename = ds.Tables(0).Rows(imagenumber).Item(2).ToString()
              imagecomments = ds.Tables(0).Rows(imagenumber).Item(3).ToString()
              PictureSize(imagename)
    
              'Show Image
              Big_Image_HyperLink.ImageURL = "images/slideshow/" & imagename
              Big_Image_HyperLink.Attributes.Add("onclick","javascript: window.open('images/" & imagename & "','_blank','fullscreen=no,toolbar=no,status=no,menubar=no,scrollbars=no,resizable=yes,width=" & ImageWidth & ",height=" & ImageHeight & ",left=5,top=5');")
              ' Show comments
              Imagecomments_Label.Text = imagecomments
    
              'Show scroll navigation text
              ScrollText = imagenumber + 1 & " out of " & numberofimages + 1
              AnchorTextBox.Text = ScrollText
    
          End Sub
    
    
          Sub SetFocus_Image()
              'SET the focus on the page to the AnchorTextBox
              'This should work with IE and Opera web browsers. If there are problems simply comment out these
              'lines.
    
              RegisterStartupScript("focus", "<script language=""JavaScript"">" & _
              vbCrLf & vbTab & "Defgallery.AnchorTextBox.focus();" & _
              vbCrLf & "<" & "/script>")
          End Sub
    
          Sub SetFocus_Thumbnail()
              'SET the focus on the page to the Thumbnail_Scroll_Label
              'This should work with IE and Opera web browsers. If there are problems simply comment out these
              'lines.
    
              RegisterStartupScript("focus", "<script language=""JavaScript"">" & _
              vbCrLf & vbTab & "Defgallery.Thumbnail_Scroll_Label.focus();" & _
              vbCrLf & "<" & "/script>")
          End Sub
    
    
          ' *********************************************************************************
          ' Click Events
          ' *********************************************************************************
    
    
          Sub TopRightButton_Click(sender As Object, e As ImageClickEventArgs)
              numberofimages = ds.Tables(0).Rows.Count - 1
              If numberofimages > 0 Then
                If Imagenumber_box.Text < numberofimages Then
                    imagenumber = Imagenumber_box.Text
                    imagenumber = imagenumber + 1
                    Imagenumber_box.Text = imagenumber
                        DisplayImage(imagenumber,numberofimages)
                Else
                    imagenumber = 0
                    Imagenumber_box.Text = imagenumber
                        DisplayImage(imagenumber,numberofimages)
                End If
                SetFocus_Image()
              End If
          End Sub
    
          Sub TopLeftButton_Click(sender As Object, e As ImageClickEventArgs)
              numberofimages = ds.Tables(0).Rows.Count - 1
              If numberofimages > 0 Then
                If Imagenumber_box.Text > 0 Then
                    imagenumber = Imagenumber_box.Text
                    imagenumber = imagenumber - 1
                    Imagenumber_box.Text = imagenumber
                        DisplayImage(imagenumber,numberofimages)
                Else
                    imagenumber = numberofimages
                    Imagenumber_box.Text = imagenumber
                        DisplayImage(imagenumber,numberofimages)
                End If
                SetFocus_Image()
              End If
          End Sub
    
          Sub ThumbnailRightButton_Click(sender As Object, e As ImageClickEventArgs)
            numberofpages = NumberOfPagesTextBox.Text
            If CurrentPage < numberofpages - 1 Then
                'Set the viewstate to the Next page
                CurrentPage = CurrentPage + 1
    
                ' Reload control
                BindPicture()
            Else
                'Set the viewstate to the first page
                CurrentPage = 0
    
                ' Reload control
                BindPicture()
            End If
            SetFocus_Thumbnail()
          End Sub
    
          Sub ThumbnailLeftButton_Click(sender As Object, e As ImageClickEventArgs)
              numberofpages = NumberOfPagesTextBox.Text
              If CurrentPage > 0 Then
                'Set the viewstate to the previous page
                CurrentPage = CurrentPage - 1
    
                ' Reload control
                BindPicture()
              ELSE
                'Set the viewstate to the end
                CurrentPage = numberofpages - 1
    
                ' Reload control
                BindPicture()
              End If
              SetFocus_Thumbnail()
          End Sub
    
          Sub Thumbnail_LinkButton_Click(sender As Object, e As ImageClickEventArgs)
              Thumbnail_Panel.Visible = True
              Image_Panel.Visible = False
              ThumbnailButton.Visible = False
              ImageButton.Visible = True
                  ' Reload control
                  BindPicture()
              SetFocus_Thumbnail()
          End Sub
    
          Sub Image_LinkButton_Click(sender As Object, e As ImageClickEventArgs)
              Thumbnail_Panel.Visible = False
              Image_Panel.Visible = True
              ThumbnailButton.Visible = True
              ImageButton.Visible = False
              SetFocus_Image()
          End Sub
    
    
        Sub PictureSize(ImageFilename)
            ' Initialize objects
            Dim objImage As System.Drawing.Image
    
            objImage = objImage.FromFile(Server.MapPath("images/" & ImageFilename))
            ImageWidth = objImage.Width + 20
            ImageHeight = objImage.Height + 20
            objImage.Dispose()
        End Sub
    
    
          ' *********************************************************************************
          ' FUNCTIONS
          ' *********************************************************************************
    
        Public Function GetImage_Location(ByVal Image_Location As Object, ByVal Entry_Id As Object) As String
            If Image_Location Is DBNull.Value Then
                Return ""
            Else
                Return "<a href='?ID=" & Entry_Id.ToString() & "'><img border='1' src='images/thumbnails/" & Image_Location.ToString() & "' /></a>"
            End If
        End Function
    
    
          ' *********************************************************************************
          ' Properties
          ' *********************************************************************************
    
          Property CurrentPage() As Integer
    
              Get
                  Dim o As Object = ViewState("_CurrentPage")
                  If o Is Nothing Then
                      Return False
                  End If
                  Return o
              End Get
    
              Set(ByVal Value As Integer)
                  ViewState("_CurrentPage") = Value
              End Set
    
          End Property
    
          Sub ImageButton1_Click(sender As Object, e As ImageClickEventArgs)
              Thumbnail_Panel.Visible = False
              Image_Panel.Visible = True
              ThumbnailButton.Visible = True
              ImageButton.Visible = False
              SetFocus_Image()
          End Sub

</script>
<html>
<head>
</head>
<body style="FONT-FAMILY: arial">
    <form id="Defgallery" runat="server">
        <p align="center">
        </p>
        <p align="center">
        </p>
        <p>
        </p>
        <div align="center">
            <asp:ImageButton id="ThumbnailButton" onclick="Thumbnail_LinkButton_Click" runat="server" ImageUrl="Thumbnail_View.gif"></asp:ImageButton>
        </div>
        <div align="center">
            <asp:ImageButton id="ImageButton" onclick="Image_LinkButton_Click" runat="server" ImageUrl="Image_View.gif" Visible="False"></asp:ImageButton>
        </div>
        <div>
        </div>
        <div align="center">
        </div>
        <div align="center">
            <asp:Panel id="Image_Panel" runat="server" HorizontalAlign="Center">
                <p align="center">
                    <br />
                    <asp:HyperLink id="Big_Image_HyperLink" onclick="" runat="server" BorderStyle="Solid" BorderWidth="2px" Target="_blank" BorderColor="Blue"></asp:HyperLink>
                    <br />
                    <font color="gray" size="1">(Click on Image to Enlarge)</font> 
                </p>
                <p align="center"></p>
                <p align="center">
                    <asp:Label id="Imagecomments_Label" runat="server"></asp:Label>
                </p>
                <p align="center">
                    <asp:ImageButton id="TopLeftButton" onclick="TopLeftButton_Click" runat="server" ImageUrl="Left.gif"></asp:ImageButton>
                    <asp:TextBox id="AnchorTextBox" style="TEXT-ALIGN: center" runat="server" BorderStyle="None" ReadOnly="True" Wrap="False" Columns="10"></asp:TextBox>
                    <asp:ImageButton id="TopRightButton" onclick="TopRightButton_Click" runat="server" ImageUrl="Right.gif"></asp:ImageButton>
                </p>
                <p align="center">
                    <asp:TextBox id="Imagenumber_box" runat="server" Visible="False" Columns="1"></asp:TextBox>
                    <br />
                    &nbsp; 
                </p>
            </asp:Panel>
        </div>
        <br />
        <div align="center">
            <asp:Panel id="Thumbnail_Panel" runat="server" Visible="False" HorizontalAlign="Center">
                <p align="center">
                    &nbsp; 
                    <asp:DataList id="Thumbnail_DataList" runat="server" Visible="True" BorderStyle="None" BorderWidth="1px" BorderColor="#E7E7FF" RepeatColumns="4" RepeatDirection="Horizontal" GridLines="Horizontal" BackColor="White" CellPadding="3" ShowHeader="False" ShowFooter="False">
                        <ItemTemplate>
                            <%# GetImage_Location(container.dataitem("Filename"),container.dataitem("Entry_ID")) %> 
                        </ItemTemplate>
                        <AlternatingItemStyle backcolor="#F7F7F7"></AlternatingItemStyle>
                    </asp:DataList>
                </p>
                <p align="center">
                    <asp:ImageButton id="ThumbnailButton1" onclick="ThumbnailLeftButton_Click" runat="server" ImageUrl="Left.gif"></asp:ImageButton>
                    <asp:TextBox id="Thumbnail_Scroll_Label" style="TEXT-ALIGN: center" runat="server" BorderStyle="None" ReadOnly="True" Wrap="False" Columns="10"></asp:TextBox>
                    <asp:ImageButton id="ThumbnailButton2" onclick="ThumbnailRightButton_Click" runat="server" ImageUrl="Right.gif"></asp:ImageButton>
                </p>
                <p align="center">
                    <asp:TextBox id="NumberOfPagesTextBox" runat="server" Visible="False" Columns="1"></asp:TextBox>
                </p>
            </asp:Panel>
        </div>
        <p align="center">
        </p>
        <p align="center">
            <font color="#808080" size="1">
            <asp:HyperLink id="HyperLink2" NavigateUrl="admin.aspx" runat="server">Gallery Administration</asp:HyperLink>
            </font>
        </p>
        <p align="center">
            <font color="#808080" size="1"><a class="Normal" id="_ctl0_dnnDotNetNuke_hypDotNetNuke" style="FONT-SIZE: 9px" href="http://www.AdefWebserver.com/">gallery
            source code is copyright © 2004 by Adefwebserver.com. All Rights Reserved</a></font>&nbsp; 
        </p>
    </form>
</body>
</html>
