using System;
using System.Collections;
using System.ComponentModel;
using System.Drawing;
using System.Data;
using System.Windows.Forms;
using System.IO;

namespace FileDragAndDrop
{
	/// <summary>
	/// Summary description for UserControl1.
	/// </summary>
	public class UploadControl : System.Windows.Forms.UserControl
	{
		private System.Windows.Forms.Label label1;
		/// <summary>
		/// Required designer variable.
		/// </summary>
		private System.ComponentModel.Container components = null;

		public UploadControl()
		{
			// This call is required by the Windows.Forms Form Designer.
			InitializeComponent();

			// TODO: Add any initialization after the InitComponent call

		}

		/// <summary>
		/// Clean up any resources being used.
		/// </summary>
		protected override void Dispose( bool disposing )
		{
			if( disposing )
			{
				if( components != null )
					components.Dispose();
			}
			base.Dispose( disposing );
		}

		#region Component Designer generated code
		/// <summary>
		/// Required method for Designer support - do not modify 
		/// the contents of this method with the code editor.
		/// </summary>
		private void InitializeComponent()
		{
			this.label1 = new System.Windows.Forms.Label();
			this.SuspendLayout();
			// 
			// label1
			// 
			this.label1.AllowDrop = true;
			this.label1.Font = new System.Drawing.Font("Lucida Console", 42F, System.Drawing.FontStyle.Bold, System.Drawing.GraphicsUnit.Point, ((System.Byte)(0)));
			this.label1.Location = new System.Drawing.Point(0, 0);
			this.label1.Name = "label1";
			this.label1.Size = new System.Drawing.Size(176, 104);
			this.label1.TabIndex = 0;
			this.label1.Text = "+";
			this.label1.TextAlign = System.Drawing.ContentAlignment.MiddleCenter;
			this.label1.DragEnter += new System.Windows.Forms.DragEventHandler(this.label1_DragEnter);
			this.label1.DragDrop += new System.Windows.Forms.DragEventHandler(this.label1_DragDrop);
			// 
			// UploadControl
			// 
			this.BackColor = System.Drawing.Color.FromArgb(((System.Byte)(255)), ((System.Byte)(128)), ((System.Byte)(0)));
			this.Controls.Add(this.label1);
			this.Name = "UploadControl";
			this.Size = new System.Drawing.Size(176, 104);
			this.ResumeLayout(false);

		}
		#endregion

	
		private void label1_DragDrop(object sender, System.Windows.Forms.DragEventArgs e)
		{	

			string[] filenames = (string[])e.Data.GetData(DataFormats.FileDrop);
			base64.WebServiceImage[] ImageArray = new base64.WebServiceImage[filenames.Length];
			for(int i=0;i<filenames.Length;i++)
			{
				//Cut full path for filename
				int stringcounter = filenames[i].LastIndexOf(@"\");
				string filename = filenames[i].Remove(0, stringcounter+1);


				//Open File
				using(FileStream fs=File.OpenRead(filenames[i]))
				{

					//Initialize return value to size of file
				byte[] SendByte = new Byte[fs.Length];
							
					//Read contents of file
					fs.Read(SendByte,0, (int)fs.Length);
					
					base64.WebServiceImage CurrentImage = new base64.WebServiceImage();
					CurrentImage.FileName = filename;
					CurrentImage.FileBinary = SendByte;
					ImageArray[i] = CurrentImage;
				}
			}

			base64.Base64Images ws = new base64.Base64Images();
			if (ws.AddImages(ImageArray))
			{
				label1.Text = "OK!";
			}
				
			}
			

			
		


		private void label1_DragEnter(object sender, System.Windows.Forms.DragEventArgs e)
		{
			if( e.Data.GetDataPresent(DataFormats.FileDrop, false) == true )
			{
				e.Effect = DragDropEffects.Copy;
			}
		}

	} //Class
} //NS

