using System;
using System.Collections;
using System.ComponentModel;
using System.Data;
using System.Diagnostics;
using System.Web;
using System.Web.Services;
using System.IO;
using System.Text;


namespace WS_Binary
{
	/// <summary>
	/// This is the custom object that will be sent via the web service.
	/// </summary>
	public class WebServiceImage
	{
		public string FileName;
		public Byte[] FileBinary;
	}

		/// <summary>
		/// This service has the ability to upload multiple images 
		/// and retrieve images based on file name.
		/// </summary>
		public class Base64Images : System.Web.Services.WebService
		{
			const string ImageDirectory = @"C:\Inetpub\wwwroot\WS_binary\Images\";
			const string UploadDirectory = @"C:\Inetpub\wwwroot\WS_binary_webclient\upload\";
			public Base64Images()
			{
				//CODEGEN: This call is required by the ASP.NET Web Services Designer
				InitializeComponent();
			}

			#region Component Designer generated code
		
			//Required by the Web Services Designer 
			private IContainer components = null;
				
			/// <summary>
			/// Required method for Designer support - do not modify
			/// the contents of this method with the code editor.
			/// </summary>
			private void InitializeComponent()
			{
			}

			/// <summary>
			/// Clean up any resources being used.
			/// </summary>
			protected override void Dispose( bool disposing )
			{
				if(disposing && components != null)
				{
					components.Dispose();
				}
				base.Dispose(disposing);		
			}
		
			#endregion

			/// <summary>
			/// Returns an image based on image name.
			/// </summary>
			/// <param name="ImageName">the name of a file in the /images/ directory</param>
			/// <returns>Returns a WebServiceImage object based on the file name.
			/// Returns an array of 0 bytes if the image can't be found.</returns>
			[WebMethod(Description="Bytes automagically turned to Base64")]
			public WebServiceImage GetImageBase64(string ImageName)
			{
				if (File.Exists(ImageDirectory + ImageName))
				{
				

					//Open File
					using(FileStream fs=File.OpenRead(ImageDirectory + ImageName))
					{

						//Initialize return value to size of file
						byte[] ReturnByte = new Byte[fs.Length];
							
						//Read contents of file
						fs.Read(ReturnByte,0, (int)fs.Length);
				
						WebServiceImage img = new WebServiceImage();
						img.FileBinary = ReturnByte;
						img.FileName = ImageName;
						return img;
						//Return contents of file as byte array

					}

				}
				else
				{
					//Return blank
					return new WebServiceImage();
				}
			}

/// <summary>
///  Adds a single file, NOTE: the upload directory 
///  is different then the images directory. See defined constants above.
/// </summary>
/// <param name="FileToAdd">A WebServiceImage object</param>
			[WebMethod()]
			private void AddImage(WebServiceImage FileToAdd)
			{

					//Create File
					using(FileStream fs = File.Create(UploadDirectory + FileToAdd.FileName))
					{									
					
					//Write File contents
					byte[] ReturnByte = FileToAdd.FileBinary;
					fs.Write(ReturnByte,0,ReturnByte.Length);
					fs.Flush();
				
					}
			
			
			}
/// <summary>
/// This web method adds multiple images.
/// </summary>
/// <param name="ImageArray">An array of WebServiceImage objects.</param>
/// <returns>true if it worked, false if it didn't. check app event log for more info on failures.</returns>
			[WebMethod(Description = "Adding multiple images")]
			public bool AddImages(WebServiceImage[] ImageArray)
			{
				try
				{
					foreach(WebServiceImage img in ImageArray)
					{
						//Upload the pic
						AddImage(img);
					}
					return true;
				}
				catch (Exception ex)
				{
					//Write to log
					EventLog.WriteEntry("Binary Demo", "Exception: " + ex.Message);
					return false;
				}
			}
		}
	}
