#ifndef  __MNUMBER_H
#define  __MNUMBER_H

#include"mlib.h"

int SetDigitRange(int=0);

class mNumber
{
	private:
		char*num,sign;
		int len;
		long exp;
	public:
		mNumber();
		mNumber(char*);
		mNumber(mNumber&);
		mNumber operator + (char*);
		mNumber operator + (mNumber&);
		mNumber& operator += (char*);
		mNumber& operator += (mNumber&);
		mNumber operator - (char*);
		mNumber operator - (mNumber&);
		mNumber& operator -= (char*);
		mNumber& operator -= (mNumber&);
		mNumber operator * (char*);
		mNumber operator * (mNumber&);
		mNumber& operator *= (char*);
		mNumber& operator *= (mNumber&);
		mNumber operator / (char*);
		mNumber operator / (mNumber&);
		mNumber& operator /= (char*);
		mNumber& operator /= (mNumber&);
		int operator < (mNumber&)const;
		int operator < (char*)const;
		int operator > (mNumber&)const;
		int operator > (char*)const;
		int operator <= (mNumber&)const;
		int operator <= (char*)const;
		int operator >= (mNumber&)const;
		int operator >= (char*)const;
		int operator == (mNumber&)const;
		int operator == (char*)const;
		int operator != (mNumber&)const;
		int operator != (char*)const;
		mNumber& operator = (const mNumber&);
		mNumber& operator = (char*);
		operator char*();
		~mNumber();
		mNumber& Abs();
		mNumber& InvertSign();
		int EvenOdd()const;
		int SignOfNum()const;
		int PowerOfTen(int=0);
		friend ostream& operator << (ostream&,mNumber&);
		friend istream& operator >> (istream&,mNumber&);
};

#endif