///
///  This source code is freeware and is provided on an "as is" basis without warranties of any kind, 
///  whether express or implied, including without limitation warranties that the code is free of defect, 
///  fit for a particular purpose or non-infringing.  The entire risk as to the quality and performance of 
///  the code is with the end user.
///
///  Created by Stefan Goner (stefang@microsoft.com)
///
///
///
///  Configure this module by adding the following section to the web.config:
///
///	<configuration>
///        <appSettings>
///           <add key="LoginUrl" value="/loginchannel/loginpage" />
///        </appSettings>
///        ...
///     </configuration>
///
///
///  More details on this control see here:
///  http://blogs.technet.com/stefan_gossner/archive/2005/04/21/404040.aspx
///
///
///  Latest Updates: 
///      V1.0  first version released
///
///

using System;
using System.Web;
using System.Configuration;
using Microsoft.ContentManagement.Publishing;
using Microsoft.ContentManagement.Web.Security;

namespace StefanG.HttpModule
{
    public class EnhancedCmsAuthorizationModule: IHttpModule
    {

        public virtual void Init(HttpApplication application)
        {
            if (application == null)
            {
                throw new ArgumentNullException("HttpApplication == null");
            }

            // register new Authorization handler
            application.AuthorizeRequest += 
                        new EventHandler(this.OnAuthorizeRequest);
        }

        public virtual void Dispose()
        {
            // nothing to do
        }

        private void OnAuthorizeRequest(object source, EventArgs e)
        {
            HttpApplication httpApplication = (HttpApplication)source;

            try
            {
                // lets try to retrieve the current CmsHttpContext
                CmsHttpContext cmsContext = CmsHttpContext.Current;

                // ok, we got the context. Now lets see if we have permission 
                // to access the current item. 
                // If not, lets present the login page to the user
                if (!cmsContext.UserHasRightToBrowse())
                {
                    redirectToLoginPage(httpApplication);
                }
            }
            catch (CmsAccessDeniedException)
            {
                // ok, no luck accessing the context. Access denied. 
                // We need to logout and redirect to login page
                redirectToLoginPage(httpApplication);
            }
        }

        private void redirectToLoginPage(HttpApplication application)
        {
            // throw away old authentication token to allow access 
            // to logon posting as guest user
            CmsFormsAuthentication.SignOut();

            // get the URL to the login posting from the appSettings section of 
            // the Web.Config
            string loginUrl = ConfigurationSettings.AppSettings["LoginUrl"];

            // we need to call the login page with the ReturnURL to the item we 
            // tried to access if possible we will use the friendly URL
            string ReturnURL = HttpUtility.UrlEncode
                  (application.Context.Request.QueryString["NRORIGINALURL"]);
            if (ReturnURL == null) 
                ReturnURL = HttpUtility.UrlEncode
                  (application.Context.Request.Url.AbsolutePath+
                   application.Context.Request.Url.Query);

            // ok, now lets redirect to the login page
            application.Context.Response.Redirect(loginUrl+"?ReturnUrl="+
                  ReturnURL);
            application.CompleteRequest();
        }
    }
}