//	[Author("Eugene E. Zhukovsky", Version = 0.99, Date = "11.07.2002", Email = "ezhukovsky@attbi.com")]

using System;
using System.IO;
using System.Xml;
using Z3.Network;


namespace FTPAutoBackup
{
	/// <summary>
	/// Summary description for Class1.
	/// </summary>
	class FTPBackup
	{
		/// <summary>
		/// The main entry point for the application.
		/// </summary>
		/// 

		protected static XmlDocument XMLDoc = new XmlDocument();

		[STAThread]
		static void Main(string[] args)
		{
			//
			// TODO: Add code to start application here
			//
			try
			{
				XMLDoc.Load("settings.xml");

			}
			catch(Exception e)
			{
				FTPClientException.WriteLog(2002, e.Message, "FTPBackup"); 
			}
			string sServer = XMLDoc.DocumentElement.GetAttribute("serveraddress");
			string sUser = XMLDoc.DocumentElement.GetAttribute("user");
			string sPassword = XMLDoc.DocumentElement.GetAttribute("password");
			string sPort = XMLDoc.DocumentElement.GetAttribute("port");
			int iPort = 21;
			try
			{
				iPort = (sPort == "") ? 21 : Int32.Parse(sPort);
			}
			catch(Exception e)
			{
				//port entered is not numeric, already defaulted to 21; do nothing
			}
			//FtpClientStream ftps = new FtpClientStream("192.168.1.7","root","qqq",21);
			FTPClientSocket ftps = new FTPClientSocket(sServer,sUser,sPassword,iPort);

			XmlNode root = XMLDoc.FirstChild;
			
			//XmlNodeList elemList = XMLDoc.GetElementsByTagName("location");
			string sLocalName = "";
			string sRemoteName = "";


			//Display the contents of the child nodes.
			if (root.HasChildNodes)
			{
				ftps.Open();

				for (int i=0; i<root.ChildNodes.Count; i++)
				{
					XmlNode myNode = root.ChildNodes[i];
					XmlAttributeCollection ac = myNode.Attributes;
					sLocalName = myNode.ChildNodes[0].InnerText;
					sRemoteName = myNode.ChildNodes[1].InnerText;

					//just in case we're not at the top level
					ftps.FTPExecute(Z3.Network.eFTP_COMMANDS._cdup,"");
			
					bool bPurge = false, bSub = false, bXclude = false;
					try{bSub = (ac["recursive"].Value == "yes");}catch(Exception e){}
					try{bPurge = (ac["purge"].Value == "yes");}catch(Exception e){}
					try{bXclude = (ac["exclude"].Value != "");}catch(Exception e){}


					if(ac["type"].Value == "dir")
					{
						if(bXclude){ftps.XClude(ac["exclude"].Value);}else{ftps.XClude("");}
						//ftps.SendDirectory(sLocalName,sRemoteName,true);
						ftps.SendDirectory(sLocalName,sRemoteName,bSub,bPurge);
					}else{
						//ftps.SendFile(sLocalName,sRemoteName,Z3.Network.TransferMode.Binary);
						ftps.FTPExecute(Z3.Network.eFTP_COMMANDS._stor,sLocalName+FTPCommandList.SEP+sRemoteName);
					}
				}
			}

			


		}
		~ FTPBackup()
		{
			FTPClientException.WriteLog(0, DateTime.Now.ToString() + ", success", "FTPBackup");
		}
	}
}
