using System;
using System.Collections;

namespace Z3.Network
{
	/// <summary>
	/// Summary description for Exclude.
	/// </summary>
	public class Excludes: ICollection
	{
		private ArrayList xArray = new ArrayList(); 

		public Excludes(string excludes)
		{
			Exclude o;

			string[] x = excludes.Split(';');
			for(int i=0; i < x.Length; i++)
			{
				o = new Exclude(x[i]);
				this.Add(o);
			}
		}

		internal Exclude this[int index]
		{
			get{return (Exclude) xArray[index];}
		}
   
		public void CopyTo(Array a, int index)
		{
			xArray.CopyTo(a, index);
		}
		public int Count
		{
			get{return xArray.Count;}
		}
		public object SyncRoot
		{
			get{return this;}
		}
		public bool IsSynchronized
		{
			get{return false;}
		}
		public IEnumerator GetEnumerator()
		{
			return xArray.GetEnumerator();
		}

		internal void Add(Exclude newExclude)
		{
			xArray.Add(newExclude);
		}
		public bool Contains(string name)
		{
			foreach(Exclude x in this)
			{
				if(x.wildcard)
				{
					if(name.ToUpper().IndexOf(x.sExclude.ToUpper()) != -1){return true;}
				}
				else
				{
					if(x.sExclude.ToUpper() == name.ToUpper()){return true;}
				}
			}
			return false;
		}

	}


	internal class Exclude
	{
		public string sExclude;
		public bool wildcard = false;
		private char[] trim = {'*'};
		public Exclude(string exclude)
		{
			sExclude = exclude.Trim(trim);
			wildcard = !(exclude.IndexOf('*') == -1);
		}
	}

}
