using System;
using System.IO;
using System.Threading;


namespace Z3.Network
{
	/// <summary>
	/// General exception class
	/// </summary>
	public sealed class FTPClientException : System.Exception
	{
		int m_iErrorCode = 0;
		string m_sMsg = null;

		/// <summary>
		/// An instance of FTPClientException
		/// </summary>
		public FTPClientException() : base() { }
		/// <summary>
		/// An instance of FTPClientException
		/// </summary>
		/// <param name="code">Error code of this exception</param>
		/// <param name="message">Explains what happened</param>
		public FTPClientException(int code, string message) : base() 
		{
			if(code==0){m_iErrorCode=this.HResult;}else{ m_iErrorCode = code;} 
			m_sMsg = message;
		}
		/// <summary>
		/// An instance of FTPClientException
		/// </summary>
		/// <param name="code">Error code of this exception</param>
		/// <param name="message">Explains what happened</param>
		/// <param name="source">where it happened</param>
		public FTPClientException(int code, string message, string source)  
		{ 
			if(code==0){m_iErrorCode=this.HResult;}else{ m_iErrorCode = code;}
			m_sMsg = message;
			WriteLog(code, message, source);
			Thread.CurrentThread.Abort();
		}
		/// <summary>
		/// write Exception to log.txt
		/// </summary>
		/// <param name="code">Error code of this exception</param>
		/// <param name="message">Explains what happened</param>
		/// <param name="source">where it happened</param>
		public static void WriteLog(int code, string message, string source)  
		{ 
			FileStream fs = new FileStream("log.txt", FileMode.Append, FileAccess.Write, FileShare.Write);
			StreamWriter sw = new StreamWriter(fs);
			sw.Write(FTPCommandList.CRLF + "source: " + source + " message: " + message + " code: " + code);
			sw.Close();
		}

		/// <summary>
		/// write info message to log.txt
		/// </summary>
		/// <param name="message">Information to write to log</param>
		public static void WriteLog(string message)  
		{ 
			FileStream fs = new FileStream("log.txt", FileMode.Append, FileAccess.Write, FileShare.Write);
			StreamWriter sw = new StreamWriter(fs);
			sw.Write(FTPCommandList.CRLF + message);
			sw.Close();
		}
		/// <summary>
		/// Error code. This property is read-only.
		/// </summary>
		public int ErrorCode
		{
			get
			{
				return m_iErrorCode;
			}
		}
		/// <summary>
		/// Message. This property is read-only.
		/// </summary>
		public override string Message
		{
			get
			{
				return m_sMsg;
			}
		}
	}
}
