//	[Author("Eugene E. Zhukovsky", Version = 0.99, Date = "11.07.2002", Email = "ezhukovsky@attbi.com")]

using System;
using System.Net;
using System.Net.Sockets;
using System.Text;
using System.IO;
using System.Collections;
using System.Threading;

namespace Z3.Network
{
	class timerState 
	{
		public int counter = 0;
		public Timer tmr;
		public int pollInt = 1000;
		public int timeOut = 30; //seconds
		public int timerInt = 1000;
		public bool exraRun = false;
		public string commandtext;
		public FTPClientSocket.serverMessage reply;
	}

	/// <summary>
	/// Summary description for FTPBase.
	/// </summary>
	public class FTPClientSocket
	{
		private string m_sUsername = "";
		private string m_sPassword = "";
		private string m_sHost = "";
		private int m_iPort = 21;

		private Excludes m_xclude;
		private FTPServer server;

		private stFTP_COMMAND_DEFINITION stcd;

		// Create the delegate that invokes methods for the timer.
		TimerCallback timerDelegate = new TimerCallback(receiveServerReply);
	
		private static Socket sock = new Socket(AddressFamily.InterNetwork, SocketType.Stream, ProtocolType.Tcp );

		/// <summary>
		/// struct to parse the server message into
		/// </summary>
		public struct serverMessage
		{
			/// <summary>
			/// Server response code
			/// </summary>
			public int code;
			/// <summary>
			/// Server response message
			/// </summary>
			public string message;
			/// <summary>
			/// Server full message, code + message, all
			/// </summary>
			public string fullmessage;
		}


		/// <summary>
		/// Initializes the ftp client
		/// </summary>
		/// <param name="sHost">Hostname of the remote machine</param>
		/// <param name="sUser">User name of the remote machine account</param>
		/// <param name="sPassword">Password of the remote machine account</param>
		/// <param name="iPort">Port of the remote machine</param>
		public FTPClientSocket(string sHost, string sUser, string sPassword, int iPort)
		{
			m_sHost = sHost;
			m_sUsername = sUser;
			m_sPassword = sPassword;
			m_iPort = iPort;
		}

		/// <summary>
		/// Initializes the ftp client
		/// </summary>
		/// <param name="sHost">Hostname of the remote machine</param>
		/// <param name="sUser">User name of the remote machine account</param>
		/// <param name="sPassword">Password of the remote machine account</param>
		public FTPClientSocket(string sHost, string sUser, string sPassword)
		{
			m_sHost = sHost;
			m_sUsername = sUser;
			m_sPassword = sPassword;
		}

		/// <summary>
		/// Initializes the ftp client
		/// </summary>
		/// <param name="sHost">Hostname of the remote machine</param>
		public FTPClientSocket(string sHost)
		{
			m_sHost = sHost;
		}

		/// <summary>
		/// Initializes the ftp client
		/// </summary>
		public FTPClientSocket()
		{
			//
		}

		/// <summary>
		/// Initializes the ftp client
		/// </summary>
		/// <param name="sHost">Hostname of the remote machine</param>
		/// <param name="iPort">Port of the remote machine</param>
		public FTPClientSocket(string sHost, int iPort)
		{
			m_sHost = sHost;
			m_iPort = iPort;
		}

		/// <summary>
		/// Username of the remote machine account
		/// </summary>
		public string Username
		{
			get
			{
				return m_sUsername;
			}
			set
			{
				m_sUsername = value;
			}
		}

		/// <summary>
		/// set up the exclude collection
		/// </summary>
		public void XClude(string xclude)
		{
			m_xclude = new Excludes(xclude);
		}

		/// <summary>
		/// Password of the remote machine account
		/// </summary>
		public string Password
		{
			get
			{
				return m_sPassword;
			}
			set
			{
				m_sPassword = value;
			}
		}

		/// <summary>
		/// Hostname of the remote machine
		/// </summary>
		public string Host
		{
			get
			{
				return m_sHost;
			}
			set
			{
				m_sHost = value;
			}
		}

		/// <summary>
		/// FTP port of the remote machine. This property is set to 21 by default
		/// </summary>
		public int Port
		{
			get
			{
				return m_iPort;
			}
			set
			{
				m_iPort = value;
			}
		}
		/* Below class is used as intial login connection protocol */


 
		/// <summary>
		/// Opens the connection to the remote machine
		/// </summary>
		public void Open() 
		{
			try
			{
				IPAddress hostadd = Dns.Resolve(this.Host).AddressList[0];
				IPEndPoint EPhost = new IPEndPoint(hostadd, 21);

				sock.Connect(EPhost);
				if (!sock.Connected)
				{
					throw new FTPClientException(2002 , "Could noe establish connection for " + " " + this.Host, "Open()");
				}

				if (sock.Connected)
				{
					Console.WriteLine("Connected to " + IPAddress.Parse(((IPEndPoint)sock.RemoteEndPoint).Address.ToString()) +
						", port " + ((IPEndPoint)sock.RemoteEndPoint).Port.ToString());

					Console.WriteLine("Local IP address is :" + IPAddress.Parse(((IPEndPoint)sock.LocalEndPoint).Address.ToString()) +
						", Connected on port " +
						((IPEndPoint)sock.LocalEndPoint).Port.ToString());

 


					byte[] msg = Encoding.ASCII.GetBytes("");
					byte[] welcome = new byte[512];
					int i = sock.Send(msg, 0, msg.Length, SocketFlags.None);

					if(sock.Connected) { User_Login(); Console.WriteLine("--- Connected to Server " + " " + this.Host); }
					if(!sock.Connected) 
					{ 
						throw new FTPClientException(2002 , "FTP Tranfer Denied by server " + " " + this.Host, "Open()");
					}

				}

			}
			catch(FTPClientException e)
			{
				throw new FTPClientException(e.ErrorCode,e.Message,e.Source);
			}
			catch(Exception e)
			{
				throw new FTPClientException(e.GetHashCode(),e.Message,"Open()");
			}

		}

 
		/* Below functions are access control commands */


		private void User_Login() 
		{

			FTPExecute(eFTP_COMMANDS._user, this.Username);
			FTPExecute(eFTP_COMMANDS._password, this.Password);
			FTPExecute(eFTP_COMMANDS._syst,"");
			//initialize server class
			//server = new FTPServer(stcd.servermessage);

			//FTPExecute(eFTP_COMMANDS._help,"");
			//FTPExecute(eFTP_COMMANDS._site_who,"");
			//FTPExecute(eFTP_COMMANDS._site_zone,"");
			FTPExecute(eFTP_COMMANDS._pwd,"");
		}


		/// <summary>
		/// Sets the current remote directory
		/// </summary>
		/// <param name="sDirectory">Directory name</param>
		public void SetCurrentDirectory(string sDirectory)
		{
			FTPExecute(eFTP_COMMANDS._cwd,sDirectory);
		}

		/// <summary>
		/// Sets the current remote directory
		/// </summary>
		/// <param name="sDirectory">Directory name</param>
		/// <param name="bCreate">Create directory if it doesn't exist flag</param>
		public void SetCurrentDirectory(string sDirectory, bool bCreate)
		{
			SetCurrentDirectory(sDirectory);
			
			if(bCreate && ((stcd.servermessage.IndexOf("550") != -1) || stcd.servercode == 550))
			{
				Console.Write("--- Attempting to create directory " + sDirectory + "\r\n");
				FTPExecute(eFTP_COMMANDS._mkdir,sDirectory);
				SetCurrentDirectory(sDirectory);
			}
		}


		private void SendFile(string localfilepath) 
		{

			try
			{
				//try opening the file first, it'll be catch and skip if it's in use
				FileStream fileToRead = new FileStream(localfilepath,FileMode.Open,FileAccess.Read,FileShare.Read,1024,false);

				Socket dataSocket;
				dataSocket = listSocket();
				stFTP_COMMAND_DEFINITION cd = FTPCommandList.FTPcommand(eFTP_COMMANDS._type, "I");
				int j= sock.Send(Encoding.ASCII.GetBytes(cd.commandtext), cd.commandtext.Length, 0);
				serverMessage tRet = this.getReply();

				if (tRet.code != cd.retcode[0]){
					throw new FTPClientException(tRet.code,tRet.message);
				}
				
				j= sock.Send(Encoding.ASCII.GetBytes(stcd.commandtext), stcd.commandtext.Length, 0);
				tRet = this.getReply();
 
				if (!evalRetCode(tRet.code)){
					//throw new FTPClientException(tRet.code, "Could not execute '" + stcd.commandtext + "', " + tRet.message, "SendFile("+localfilepath+")");
					throw new FTPClientException(tRet.code,tRet.message);
				}

				int sizeReceived;
			
				Console.WriteLine("Sending " + localfilepath + "...");

				//file already opened to check if it's in use
				byte[] buffer = new byte[1024];
				int bytesRead;

				do
				{
					bytesRead = fileToRead.Read(buffer,0, 1024);
					sizeReceived = dataSocket.Send(buffer, bytesRead, SocketFlags.None);
					Console.Write('.');

				}
				while (bytesRead == buffer.Length ); // Go back for more if necessary
				fileToRead.Close();
				dataSocket.Close();
			
				this.getReply();

				stcd.servercode = tRet.code;
				stcd.servermessage = tRet.message;
			}
			catch(FTPClientException e)
			{
				FTPClientException.WriteLog(e.ErrorCode, "Could not execute '" + stcd.commandtext + "' " + e.Message, "SendFile("+localfilepath+")");
			}
			catch(IOException e)
			{
				//file access error. Log it and go on?
				FTPClientException.WriteLog(80004008, e.Message, "SendFile("+localfilepath+")");
			}
			catch(Exception e)
			{
				FTPClientException.WriteLog(e.GetHashCode(), e.Message, "SendFile("+localfilepath+")");
			}


		}

 

		private void ReceiveFile(string sFileDest) 
		{
			try
			{
				Socket dataSocket = listSocket();

				stFTP_COMMAND_DEFINITION cd = FTPCommandList.FTPcommand(eFTP_COMMANDS._type, "I");
				int j= sock.Send(Encoding.ASCII.GetBytes(cd.commandtext), cd.commandtext.Length, 0);
				serverMessage tRet = this.getReply();

				if (tRet.code != cd.retcode[0]){throw new FTPClientException(tRet.code,tRet.message);}
				
				j= sock.Send(Encoding.ASCII.GetBytes(stcd.commandtext), stcd.commandtext.Length, 0);
				tRet = this.getReply();
 
				if (!evalRetCode(tRet.code)){throw new FTPClientException(tRet.code,tRet.message);}

				// Now read data from the dataSocket

				Byte[] readBytes;
				ArrayList byteArray = new ArrayList();
				int sizeReceived;
				int totalbytes =0;
				string serverMessage = "";
				FileStream oFileStream = new FileStream(sFileDest , FileMode.Create);
				while (sock.Poll(1000, SelectMode.SelectRead)==true)
				{
					readBytes = new Byte[1024];
					sizeReceived = dataSocket.Receive(readBytes, readBytes.Length, SocketFlags.None);
					totalbytes = totalbytes + sizeReceived;
					serverMessage += Encoding.ASCII.GetString(readBytes, 0, sizeReceived);
					oFileStream.Write(readBytes,0, sizeReceived);
				}
				
				oFileStream.Close();

				stcd.servercode = tRet.code;
				stcd.servermessage = tRet.message;
			}
			catch(FTPClientException e)
			{
				FTPClientException.WriteLog(e.ErrorCode, "Could not execute '" + stcd.commandtext + "', " + e.Message, "ReceiveFile("+sFileDest+")");
			}
			catch(SocketException e)
			{
				FTPClientException.WriteLog(e.ErrorCode, e.Message, "ReceiveFile("+sFileDest+")");
			}
		
			catch(ArgumentNullException e)
			{
				FTPClientException.WriteLog(80004003, e.Message, "ReceiveFile("+sFileDest+")");
				
			}
			catch(ObjectDisposedException e)
			{
				FTPClientException.WriteLog(80004004, e.Message, "ReceiveFile("+sFileDest+")");
			}
			
		}
		/// <summary>
		/// Delete a file from the ftp server, 
		/// from the remote sDirectory specified.
		/// </summary>
		/// <param name="sLocalDirectory">Local directory name</param>
		/// <param name="sRemoteDirectory">Remote directory name</param>
		/// <param name="bSub">Recurse flag</param>
		/// <param name="bPurge">Purge flag</param>
		public void SendDirectory(string sLocalDirectory, string sRemoteDirectory, bool bSub, bool bPurge)
		{
			ListEntry oLE = null;

			//switch to the new dir
			SetCurrentDirectory(sRemoteDirectory,true);
			
			try
			{
				if(bPurge)
				{
					FTPExecute(eFTP_COMMANDS._list,"");
					if(stcd.servermessage != "") //directory is not empty
					{
						//oLE = new ListEntry(stcd.servermessage, sRemoteDirectory);
						oLE = new ListEntry(stcd.servermessage, sRemoteDirectory);

						//while(oLE.MoveNext())
						for(int i=0;i<oLE.Count;i++)
						{
							//purge files
							if(oLE.Item(i).FileType == eFILE_TYPE.FILE_TYPE_FILE)
							{
								if(!File.Exists(sLocalDirectory + "\\" + oLE.Item(i).FileName))
								{
									FTPExecute(eFTP_COMMANDS._delete,oLE.Item(i).FileName);
								}
							}
							//purge dirs
							if(oLE.Item(i).FileType == eFILE_TYPE.FILE_TYPE_DIRECTORY)
							{
								if((!Directory.Exists(sLocalDirectory + "\\" + oLE.Item(i).FileName))
									|| (m_xclude.Contains(oLE.Item(i).FileName)))
								{
									DeleteDirectory(oLE.Item(i).FileName);
								}
							}
						}
					}
				}

				string [] subdirectoryFiles = Directory.GetFiles(sLocalDirectory);
				foreach(string subfiles in subdirectoryFiles) 
				{
					FileInfo fi = new FileInfo(subfiles);
					if(!Object.Equals(null,oLE))
					{
						if(oLE.Contains(fi.Name))
						{
					
							DateTime dt = oLE.Item(fi.Name).FileDate;
							bool b = (dt.Equals(fi.LastWriteTime));
							if(fi.Length == oLE.Item(fi.Name).FileSize)
							{
								Console.WriteLine("--- " + fi.Name + " same size");
								continue;
							}
						}
					}
					stcd = FTPCommandList.FTPcommand(eFTP_COMMANDS._stor,Path.GetFileName(subfiles));
					SendFile(subfiles);
					
				}

				// Recurse into subdirectories of this directory
				if (bSub) 
				{
					string [] subdirectoryEntries = Directory.GetDirectories(sLocalDirectory);
					FileInfo fi;
					foreach(string subdirectory in subdirectoryEntries) 
					{
						fi = new FileInfo(subdirectory);
						if(!m_xclude.Contains(fi.Name))
						{
							SendDirectory(subdirectory, sRemoteDirectory + "//" + fi.Name, bSub, bPurge);
						}
					}
				}
			}
			catch(Exception e)
			{
				FTPClientException.WriteLog(e.GetHashCode(),e.Message,"SendDirectory");
			}
		}
 

		public void DeleteDirectory(string sRemoteDirectory)
		{
			ListEntry oLE = null;

			SetCurrentDirectory(sRemoteDirectory);
		
			FTPExecute(eFTP_COMMANDS._list,"");
			if(stcd.servermessage != "") //directory is not empty
			{
				oLE = new ListEntry(stcd.servermessage, sRemoteDirectory);

				//while(oLE.MoveNext())
				for(int i=0;i<oLE.Count;i++)
				{
					//purge files
					if(oLE.Item(i).FileType == eFILE_TYPE.FILE_TYPE_FILE)
					{
						FTPExecute(eFTP_COMMANDS._delete, oLE.Item(i).FileName);
					}
					//purge dirs
					if(oLE.Item(i).FileType == eFILE_TYPE.FILE_TYPE_DIRECTORY)
					{
						DeleteDirectory(oLE.Item(i).FileName);
					}
				}
			}
			FTPExecute(eFTP_COMMANDS._cdup,"");
			
			//some dir entries are truncated to 2,000 entries, need to repeat
			FTPExecute(eFTP_COMMANDS._rmd,sRemoteDirectory);
			if(!evalRetCode(stcd.servercode))
			{
				DeleteDirectory(sRemoteDirectory);
			}
		}

		/// <summary>
		/// execute all available FTP commands
		/// </summary>
		public stFTP_COMMAND_DEFINITION FTPExecute(eFTP_COMMANDS cmd, string sarg) 
		{
			stcd = FTPCommandList.FTPcommand(cmd,sarg);
					
			try
			{
					
				switch(cmd)
				{
					case eFTP_COMMANDS._list:
						stcd.servermessage = List();
						break;
					case eFTP_COMMANDS._get:
						stcd = FTPCommandList.FTPcommand(cmd,sarg.Split(FTPCommandList.SEP)[0]);
						//get path to destination file from sarg
						ReceiveFile(sarg.Split(FTPCommandList.SEP)[1]);
						break;
					case eFTP_COMMANDS._stor:
						stcd = FTPCommandList.FTPcommand(cmd,sarg.Split(FTPCommandList.SEP)[1]);
						//get path to destination file from sarg
						SendFile(sarg.Split(FTPCommandList.SEP)[0]);
						break;
					default:
						int j= sock.Send(Encoding.ASCII.GetBytes(stcd.commandtext), stcd.commandtext.Length, 0);
					
						serverMessage tRet = this.getReply();
					
						//if (!evalRetCode(tRet.code)){throw new FTPClientException(tRet.code,tRet.message);}
					
						stcd.servercode = tRet.code;
						stcd.servermessage = tRet.message;
						break;
				}
			}
			catch(FTPClientException e)
			{
				FTPClientException.WriteLog(e.ErrorCode, "Could not execute '" + stcd.commandtext + "', " + e.Message, "FTPExecute");
			}

			return stcd;
		}

 
 

		private string List() 
		{
			serverMessage tRet;

			try
			{
				Socket sockList = listSocket();
				int j= sock.Send(Encoding.ASCII.GetBytes(stcd.commandtext), stcd.commandtext.Length, 0);
				tRet = this.getReply();

				if (!evalRetCode(tRet.code)){throw new FTPClientException(tRet.code,tRet.message);}

				Socket temp = new Socket(sock.AddressFamily,sock.SocketType,sock.ProtocolType);
				temp=sock;
				sock=sockList;
				tRet = this.getReply();
				sock=temp;
				
			}
			catch(FTPClientException e)
			{
				throw new FTPClientException(e.ErrorCode, "Could not execute '" + stcd.commandtext + "', " + e.Message, "List()");
			}
			catch(SocketException e)
			{
				throw new FTPClientException(0, e.Message, "List()");
			}
		
			catch(ArgumentNullException e)
			{
				throw new FTPClientException(0, e.Message, "List");
				
			}
			catch(ObjectDisposedException e)
			{
				throw new FTPClientException(0, e.Message, "List");
			}

			return tRet.fullmessage;
		}

 
		private Socket listSocket ()
		{
			string command=null;
			serverMessage reply;
			Socket localSocket=null;
			string fullAddress=null;
			try
			{
			
				command = "PASV" + FTPCommandList.CRLF;
				sock.Send(Encoding.ASCII.GetBytes(command), command.Length, 0);
	
				do
				{
					reply = this.getReply();//try again
				}while(reply.message == "" || Object.Equals(reply.message, null));

				//check for PASV code, and try again: there's server message didn't get received
				if(reply.fullmessage.IndexOf("227") == -1){reply = this.getReply();}//try again
			
				fullAddress = reply.message;

				fullAddress = fullAddress.Remove(0, fullAddress.IndexOf('(') + 1);
				fullAddress = fullAddress.Substring(0, fullAddress.IndexOf(')'));
				string[] addressParts = fullAddress.Split(',');
				string pasvAddress = addressParts[0] + "." + addressParts[1] + "." + addressParts[2] + "." + addressParts[3];
				int pasvPort = Convert.ToInt32(addressParts[4]) * 256 + Convert.ToInt32(addressParts[5]);

				// Open the Data socket
				localSocket = new Socket(AddressFamily.InterNetwork, SocketType.Stream, ProtocolType.Tcp);
				localSocket.Connect(new IPEndPoint(IPAddress.Parse(pasvAddress), pasvPort));

				if(!localSocket.Connected)
				{
					//try again
					localSocket.Connect(new IPEndPoint(IPAddress.Parse(pasvAddress), pasvPort));
				}

			}
			catch(Exception e)
			{
				throw new FTPClientException(0, e.Message, "listSocket");
			}
			return localSocket;

		}

		private serverMessage getReply()
		{
			timerState s = new timerState();

			// Create a timer that waits one/100 of a second, then invokes every second.
			Timer timer = new Timer(timerDelegate, s, 100, s.timerInt);
    
			// Keep a handle to the timer, so it can be disposed.
			s.tmr = timer;
			s.commandtext = stcd.commandtext;

			// The main thread does nothing until the timer is disposed.
			while(s.tmr != null)
				Thread.Sleep(0);

			return s.reply;
		}

		private static void receiveServerReply(Object state)
		{

			serverMessage reply;
			reply.code =0;
			reply.message ="";
			reply.fullmessage = "";
			Byte[] readBytes;
			int sizeReceived;
			string serverMessage = "";

			timerState s =(timerState)state;
			
			if(s.counter == s.timeOut)
			{
				s.tmr.Dispose();
				s.tmr = null;
				throw new FTPClientException(0,"operation " + s.commandtext + " timed out.","receiveServerReply");
			}
			else
			{
				s.counter++;

				if (sock.Poll(s.pollInt, SelectMode.SelectRead) == true )
				{
					do
					{
						readBytes = new Byte[524];
						sizeReceived = sock.Receive(readBytes);
						serverMessage += Encoding.ASCII.GetString(readBytes, 0, sizeReceived);
					}
					while (sizeReceived == readBytes.Length & !serverMessage.EndsWith(FTPCommandList.CRLF));

					reply.fullmessage = serverMessage;
					try{
						reply.message = serverMessage.Substring(4,serverMessage.Length-6);
						reply.code = Convert.ToInt32(serverMessage.Substring(0,3));
						Console.WriteLine(reply.code + " " + reply.message);
					}catch(Exception e)
					{
						//for list message
						Console.WriteLine((reply.fullmessage == "") ? "--- Directory is empty." : reply.fullmessage);
					}
					s.exraRun = true;
				}
				if(s.exraRun)
				{
					s.tmr.Dispose();
					s.tmr = null;
				}
			}

			s.reply = reply;
		}


		private bool evalRetCode(int codereceived)
		{
			bool bret = false;
			for(int i=0;i<stcd.retcode.Length;i++)
			{
				if(stcd.retcode[i] == codereceived){bret = true;break;}
			}
			return bret;
		}

 
		~ FTPClientSocket()
		{
			sock = null;
			FTPClientException.WriteLog(0, "Run completed", "FTPClientSocket");
		}

	}
}

