//	[Author("Eugene E. Zhukovsky", Version = 0.99, Date = "11.07.2002", Email = "ezhukovsky@attbi.com")]

using System;

namespace Z3.Network
{
	/// <summary>
	/// struct to parse the server message into
	/// </summary>
	public enum eFILE_TYPE:int
	{
		/// <summary>
		/// list of successful return codes
		/// </summary>
		FILE_TYPE_DIRECTORY = 2,
		/// <summary>
		/// Sftp command full text
		/// </summary>
		FILE_TYPE_FILE      = 1,
		/// <summary>
		/// Server response code
		/// </summary>
		FILE_TYPE_SYSTEM    = 3,
		/// <summary>
		/// Server response code
		/// </summary>
		FILE_TYPE_UNKNOWN   = 0
	}

	/// <summary>
	/// struct to parse the server message into
	/// </summary>
	public struct stFTP_COMMAND_DEFINITION
	{
		/// <summary>
		/// list of successful return codes
		/// </summary>
		public int[] retcode;
		/// <summary>
		/// Sftp command full text
		/// </summary>
		public string commandtext;
		/// <summary>
		/// Server response code
		/// </summary>
		public int servercode;
		/// <summary>
		/// server message
		/// </summary>
		public string servermessage;
	}

	/// <summary>
	/// ftp cOMMANDS ENUM
	/// </summary>
	public enum eFTP_COMMANDS
	{
		/// <summary>
		/// user username to identify user to the FTP server
		/// </summary>
		_user,
		/// <summary>
		/// user username to identify user to the FTP server
		/// </summary>
		_password,
		/// <summary>
		/// Shows the present working directory (pwd) on the
		/// remote computer			
		/// </summary>
		_pwd,
		/// <summary>
		/// ASCII or Binary transfer mode 
		/// </summary>
		_type,
		/// <summary>
		/// Change the directory on the remote computer
		/// </summary>
		_cwd,
		/// <summary>
		/// List the files in the current directory on the remote
		/// computer.
		/// </summary>
		_ls,
		/// <summary>
		/// List the files in the current directory on the remote
		/// computer.
		/// </summary>
		_list,
		/// <summary>
		/// List the files in the current directory on the remote
		/// computer.
		/// </summary>
		_dir,
		/// <summary>
		/// send or put file
		/// </summary>
		_put,
		/// <summary>
		/// Send one file
		/// </summary>
		_stor,
		/// <summary>
		/// Receive one file
		/// </summary>
		_get,
		/// <summary>
		/// Delete remote file
		/// </summary>
		_delete,
		/// <summary>
		/// make directory on the remote machine
		/// </summary>
		_mkdir,
		/// <summary>
		/// SYSTEM
		/// </summary>
		_syst,
		/// <summary>
		/// system
		/// </summary>
		_rmd,
		/// <summary>
		/// displays server's time zone relative to UTC
		/// </summary>
		_site_zone,
		/// <summary>
		/// returns who is connected: User Name - Connection Date - IP/HostName - Transfer KBps
		/// </summary>
		_site_who,
		/// <summary>
		/// yyyymmddhhmmss[+-xxx] 'path-file' specify the new date/time for the specified filename
		/// </summary>
		_mdtm,
		/// <summary>
		/// remove remote directory (only works if it's empty)
		/// </summary>
		_pasv,
		/// <summary>
		/// help
		/// </summary>
		_help,
		/// <summary>
		/// request asks the server to remove the last slash, and everything following it, from the name prefix.
		/// If this produces an empty name prefix, the new name prefix is a single slash. CDUP parameters are prohibited.
		/// </summary>
		_cdup
	}


	/// <summary>
	/// Summary description for FTPCommandList.
	/// </summary>
	public class FTPCommandList
	{

		/// <summary>
		/// For all VB users - CrLf (those were the times!)
		/// </summary>
		public const String CRLF ="\r\n";

		/// <summary>
		/// For all VB users - CrLf (those were the times!)
		/// </summary>
		public const char SEP = '';

		private static stFTP_COMMAND_DEFINITION stcd;

		/// <summary>
		/// Password of the remote machine account
		/// </summary>
		public static stFTP_COMMAND_DEFINITION FTPcommand(eFTP_COMMANDS cmd, string arg)
		{
				switch(cmd)
				{
					case eFTP_COMMANDS._type:
						stcd = _type(arg);
						break;
						
					case eFTP_COMMANDS._cwd:
						stcd =  _cwd(arg);
						break;

					case eFTP_COMMANDS._delete:
						stcd =  _delete(arg);
						break;

					case eFTP_COMMANDS._list:
						stcd =  _list(arg);
						break;

					case eFTP_COMMANDS._get:
						stcd =  _get(arg);
						break;

					case eFTP_COMMANDS._stor:
						stcd =  _stor(arg);
						break;

					case eFTP_COMMANDS._mkdir:
						stcd =  _mkdir(arg);
						break;

					case eFTP_COMMANDS._password:
						stcd =  _password(arg);
						break;

					case eFTP_COMMANDS._pwd:
						stcd =  _pwd();
						break;

					case eFTP_COMMANDS._user:
						stcd =  _user(arg);
						break;

					case eFTP_COMMANDS._syst:
						stcd =  _syst();
						break;

					case eFTP_COMMANDS._rmd:
						stcd =  _rmd(arg);
						break;

					case eFTP_COMMANDS._pasv:
						stcd =  _pasv();
						break;

					case eFTP_COMMANDS._cdup:
						stcd =  _cdup();
						break;

					case eFTP_COMMANDS._help:
						stcd =  _help();
						break;

					default:
						throw new FTPClientException(1,"Command not recognized", "FTPcommand");

				}
			return stcd;
		}

		/// <summary>
		/// Hostname of the remote machine
		/// USER SP username CRLF
		/// </summary>
		private static stFTP_COMMAND_DEFINITION _user(string susername)
		{
			stcd.commandtext="USER " + susername + CRLF;
			stcd.retcode = new int[] {331, 230, 530, 220};
				return stcd;
		}

		/// <summary>
		/// FTP port of the remote machine. This property is set to 21 by default
		/// </summary>
		private static stFTP_COMMAND_DEFINITION _pwd()
		{
			stcd.commandtext="PWD"+ CRLF;
			stcd.retcode = new int[] {257};
				return stcd;
		}

		/// <summary>
		/// CHANGE WORKING DIRECTORY (CWD)
		/// This command allows the user to work with a different
		///		directory or dataset for file storage or retrieval without
		///     altering his login or accounting information.  Transfer
		/// 	parameters are similarly unchanged
		/// </summary>
		/// <param name="spathname">The argument is a
		///    pathname specifying a directory or other system dependent
		///    file group designator.</param>

		private static stFTP_COMMAND_DEFINITION _cwd(string spathname)
		{
			stcd.commandtext="CWD " + spathname + CRLF;
			stcd.retcode = new int[] {250,550}; //550 is added to attempt to create
			return stcd;
		}

		/// <summary>
		/// Hostname of the remote machine
		/// </summary>
		private static stFTP_COMMAND_DEFINITION _type(string stranfertype)
		{
			stcd.commandtext="TYPE " + stranfertype + CRLF;
			stcd.retcode = new int[] {200};
				return stcd;
		}

		/// <summary>
		/// Hostname of the remote machine
		/// </summary>
		internal static stFTP_COMMAND_DEFINITION _list(string spathname)
		{
			if(spathname == "")
			{
				stcd.commandtext="LIST" + CRLF;
			}
			else
			{
				//if(!spathname.EndsWith("/")){spathname += "/";}
				stcd.commandtext="LIST " + spathname + CRLF;
			}
			stcd.retcode = new int[] {150, 125};
			return stcd;
		}

		/// <summary>
		/// Hostname of the remote machine
		/// </summary>
		internal static stFTP_COMMAND_DEFINITION _get(string spathnames)
		{
			stcd.commandtext="RETR " + spathnames + CRLF;
			stcd.retcode = new int[] {150, 125};
			return stcd;
		}
		/// <summary>
		/// send or put file
		/// </summary>
		internal static stFTP_COMMAND_DEFINITION _stor(string spathnames)
		{
			stcd.commandtext="STOR " + spathnames + CRLF;
			stcd.retcode = new int[] {150, 125};
			return stcd;
		}
		/// <summary>
		/// FTP port of the remote machine. This property is set to 21 by default
		/// </summary>
		private static stFTP_COMMAND_DEFINITION _delete(string sfile)
		{
			stcd.commandtext="DELE " + sfile + CRLF;
			stcd.retcode = new int[] {250};
				return stcd;
		}

		/// <summary>
		/// Hostname of the remote machine
		/// </summary>
		private static stFTP_COMMAND_DEFINITION _mkdir(string dirName)
		{
			if(!dirName.EndsWith("/")){dirName += "/";}
			stcd.commandtext="MKD "+ dirName + CRLF;
			stcd.retcode = new int[] {257, 550, 200};
			return stcd;
		}
		
		/// <summary>
		/// Hostname of the remote machine
		/// </summary>
		private static stFTP_COMMAND_DEFINITION _syst()
		{
			stcd.commandtext="SYST" + CRLF;
			stcd.retcode = new int[] {215};
			return stcd;
		}

		/// <summary>
		/// Hostname of the remote machine
		/// </summary>
		private static stFTP_COMMAND_DEFINITION _rmd(string dirName)
		{
			if(!dirName.EndsWith("/")){dirName += "/";}
			stcd.commandtext="RMD " + dirName + CRLF;
			stcd.retcode = new int[] {250};
			return stcd;
		}
		
		/// <summary>
		/// Hostname of the remote machine
		/// </summary>
		private static stFTP_COMMAND_DEFINITION _password(string spassword)
		{
			stcd.commandtext="PASS " + spassword + CRLF;
			stcd.retcode = new int[] {230, 202};
			return stcd;
		}
		/// <summary>
		/// Hostname of the remote machine
		/// </summary>
		private static stFTP_COMMAND_DEFINITION _pasv()
		{
			stcd.commandtext="PASV" + CRLF;
			stcd.retcode = new int[] {227, 230, 202, 530};
			return stcd;
		}
		/// <summary>
		/// One directory up on the remote machine
		/// </summary>
		private static stFTP_COMMAND_DEFINITION _cdup()
		{
			stcd.commandtext="CDUP" + CRLF;
			stcd.retcode = new int[] {200, 250};
			return stcd;
		}
		/// <summary>
		///  MDTM yyyymmddhhmmss[+-xxx] 'path-file' 
		/// Where yyyymmddhhmmss is a line of text with the year, month, day, hour, minutes, and 
		/// seconds the file should get set to. The next part, [+-xxx], is optional time zone 
		/// information of the FTP client in minutes relative to UTC
		///  MDTM 19980719103029-240. This would set the date and time to 
		///  19 July 1998, 10:30am 29 seconds, and indicates the client is 240 behind UTC
		///  mdtm 19980525162603 file.txt
		/// </summary>
		private static stFTP_COMMAND_DEFINITION _mdtm(string ymdhms, string offset)
		{
			stcd.commandtext="MDTM" + CRLF;
			stcd.retcode = new int[] {200, 250}; //need codes!!!!
			return stcd;
		}
		/// <summary>
		/// return who is connected : User Name - Connection Date - IP/HostName - Transfer KBps
		/// </summary>
		private static stFTP_COMMAND_DEFINITION _site_who()
		{
			stcd.commandtext="SITE WHO" + CRLF;
			stcd.retcode = new int[] {200, 250}; //need codes!!!!
			return stcd;
		}
		/// <summary>su
		/// One directory up on the remote machine
		/// </summary>
		private static stFTP_COMMAND_DEFINITION _site_zone()
		{
			stcd.commandtext="SITE ZONE" + CRLF;
			stcd.retcode = new int[] {210};
			return stcd;
		}
		/// <summary>su
		/// help
		/// </summary>
		private static stFTP_COMMAND_DEFINITION _help()
		{
			stcd.commandtext="HELP" + CRLF;
			stcd.retcode = new int[] {211, 214};
			return stcd;
		}

	}
}
