using System;

namespace Z3.Network
{
	public enum eSERVER_OS:int
	{
		UNIX = 0,
		WINDOWS = 1,
		MAC_OS = 2,
		NETWARE = 3,
		NOT_SUPPORTED = 4
	}
	/// <summary>
	/// Summary description for FTPServer.
	/// </summary>
	public class FTPServer
	{
		private eSERVER_OS os;
		private int offset;

		public FTPServer(string syst)
		{
			string tmp = null;
			string[] arrtemp = syst.Split(new char[] {'\n'});
			for(int i = 0; i < arrtemp.Length; i++)
			{
				if(arrtemp[i].Substring(0,3) == "215")
				{
					tmp = arrtemp[i].Trim().Substring(4,4);
					break;
				}
			}
			switch (tmp.ToUpper()) 
			{
				case "UNIX":
					os = eSERVER_OS.UNIX;
					break;
				case "WIND":
					os = eSERVER_OS.WINDOWS;
					break;
				case "MACO":
					os = eSERVER_OS.MAC_OS;
					break;
				case "NETW":
					os = eSERVER_OS.NETWARE;
					break;
				default:
					os = eSERVER_OS.NOT_SUPPORTED;
					break;
			}
		}

		public eSERVER_OS OS{get{return os;}}
	}
}

//
//		/// <summary>
//		/// To Parse the output of LIST command from Windows FTP services
//		/// </summary>
//		/// <param name="l_arrFiles">Input string read from socket connection</param>
//		/// <returns>DataTable if success, else null</returns>
//		private DataTable ParseStringArrayForWindows(string[] l_arrFiles){
//
//			DataTable l_dtFileList = new DataTable(m_strCurrentWorkingDir);
//			
//			l_dtFileList.Columns.Add(new DataColumn("FileType",typeof(int)));
//			l_dtFileList.Columns.Add(new DataColumn("FileName",typeof(string)));
//			l_dtFileList.Columns.Add(new DataColumn("FilePath",typeof(string)));
//			l_dtFileList.Columns.Add(new DataColumn("CreatedDate",typeof(string)));
//			l_dtFileList.Columns.Add(new DataColumn("FileSize",typeof(int)));
//
//			string l_strcurFile = "";
//			char[] l_arrchSep = new char[2];
//			l_arrchSep[0] = ' ';
//			l_arrchSep[1] = '\0';
//			string[] l_strarrFields = new string[5];
//
//			foreach(object obj in l_arrFiles) {
//				l_strcurFile = (string) obj;
//				l_strcurFile.Trim();
//				
//				if (l_strcurFile == null || l_strcurFile.Length == 0 ) {
//					break;
//				}
//
//				l_strarrFields = SplitStringForWindows(l_strcurFile);
//				if ( l_strarrFields.Length == 1 || l_strarrFields.Length <= 0 ) {
//					/*	If the element is empty, do not attempt to parse it */
//					continue;
//				}
//
//				/*	Each field is now in l_strarrFields */
//				DataRow l_drNew = l_dtFileList.NewRow();
//				/*	Each field is now in l_strarrFields */
//				if ( GetFileInfoForWindows(l_strarrFields,ref l_drNew) == 1 ){
//					if ( l_drNew != null ) {
//						l_dtFileList.Rows.Add(l_drNew);
//					}
//				}
//			}
//			return l_dtFileList;
//		}
//
//		/// <summary>
//		/// 
//		/// </summary>
//		/// <param name="l_strInString"></param>
//		/// <returns></returns>
//		private string[] SplitStringForWindows(string l_strInString){
//			string[] l_strarrOut = new string[5];
//			string l_strTemp = "";
//			char[] l_arrchSep = new char[2];
//			l_arrchSep[0] = ' ';
//			l_arrchSep[1] = '\0';
//			int l_iFieldCount = 0;
//
//			/*	Squeeze more spaces into single space character	*/
//			int l_iCount = 0,l_iLen = l_strInString.Length;
//			for ( ; l_iCount < l_iLen ; l_iCount++ ) {
//				if ( l_strInString[l_iCount] == ' ' ) {
//					if ( l_iFieldCount <= 1 ) {
//						l_strarrOut[l_iFieldCount] = l_strTemp;
//						l_iFieldCount++;
//						l_strTemp = "";
//						if ( l_strInString[l_iCount + 1] == ' ' ) {
//							for ( l_iCount++ ;  l_strInString[l_iCount] == ' '; l_iCount++ ) ;
//							/*	Postion the counter back to previous character	*/
//							l_iCount--;
//						}
//					}
//					else if ( l_iFieldCount == 2 ) {
//						/*	Check for first digit here 
//						 * if '<' then it is a directory
//						 * else it is a file
//						 * */
//						if ( l_strTemp[0] == '<' ) {
//							/*	Directory Flag	*/
//							l_strarrOut[l_iFieldCount] = "D";
//							l_iFieldCount++;
//
//							/*	size of directory is not known	*/
//							l_strarrOut[l_iFieldCount] = "0";
//							l_iFieldCount++;
//							/*	Skip the rest of characters */
//							for ( l_iCount++ ;  l_strInString[l_iCount] != ' '; l_iCount++ ) ;
//						}
//						else {
//							/*	Normal File	*/
//							l_strarrOut[l_iFieldCount] = "N";
//							l_iFieldCount++;
//							l_strarrOut[l_iFieldCount] = l_strTemp;
//							l_iFieldCount++;
//						}
//					}
//				}
//				else {
//					if ( l_iFieldCount == 4 ) {
//						/*	File name */
//						l_strTemp = "";
//						for ( ; l_iCount < l_strInString.Length ; l_iCount++ ){
//							l_strTemp += l_strInString[l_iCount];
//						}
//						/*	remove \r\n character */
//						l_strTemp = l_strTemp.Substring(0,l_strTemp.Length - 1);
//						l_strarrOut[l_iFieldCount] = l_strTemp;
//					}
//					else {
//						l_strTemp += l_strInString[l_iCount];
//					}
//				}
//			}
//			return l_strarrOut;
//		}
//
//		/// <summary>
//		/// 
//		/// </summary>
//		/// <param name="l_strarrFields"></param>
//		/// <param name="l_drNew"></param>
//		/// <returns></returns>
//		private int GetFileInfoForWindows(string[] l_strarrFields,ref DataRow l_drNew){
//
//			string l_strField = "";
//			string l_strFileName = "" ,l_strFilePath = "" ,l_strDateCreated = "";
//			string l_strTimeCreated = "";
//			int l_iFileType = 0,l_iFileSize = 0;
//			int l_iCount = 0;
//
//			foreach(object obj in l_strarrFields) {
//				l_strField = (string) obj;
//				if (l_strField == null ) {
//					break;
//				}
//				switch( l_iCount) {
//					case 0:		/*	Date */
//						l_strDateCreated = l_strField;
//						break;
//					case 1 :	/*	Time */
//						l_strTimeCreated = l_strField;
//						break;
//					case 2 :	/*	File Type  N - normal file, D - directory	*/
//						if ( l_strField.Equals("N") ) {
//							l_iFileType = 1;
//						}
//						else if ( l_strField.Equals("D") ) {
//							l_iFileType = 2;
//						}
//						break;
//					case 3 :	/*	File size in bytes */
//						try {
//							l_iFileSize = int.Parse(l_strField);
//						}
//						catch ( FormatException e ) {
//							l_iFileSize = 0;
//						}
//						break;
//					case 4 :	/*	Name of the file */
//						l_strFileName = l_strField;
//						break;
//				}	/*	End of switch statement */
//				l_iCount++;
//			}	/*	End of for */
//
//			/* If current or parent directory */
//			if ( l_strFileName == "." || l_strFileName == ".." ){
//				l_drNew = null;
//				return 0;
//			}
//
//			if ( m_strCurrentWorkingDir.EndsWith("/") == true ){
//				l_strFilePath = m_strCurrentWorkingDir + l_strFileName;
//			}
//			else {
//				l_strFilePath = m_strCurrentWorkingDir + "/" + l_strFileName;
//			}
//
//			l_drNew[0] = l_iFileType;
//			l_drNew[1] = l_strFileName;
//			l_drNew[2] = l_strFilePath;
//			l_drNew[3] = l_strDateCreated;
//			l_drNew[4] = l_iFileSize;
//			return 1;
//		}