using System;

namespace Z3.Network
{
	/// <summary>
	/// Summary description for ListEntry.
	/// </summary>
	public class ListItem
	{
		private eFILE_TYPE m_iFileType;
		private string m_sFileName;
		private string m_sFilePath;
		private string m_sCreateDate;
		private DateTime m_dtFileDate;
		private int m_iFileSize;
		private string m_sFileOwner;
		private string m_sFileGroup;

		#region get-set
		public eFILE_TYPE FileType{get{return m_iFileType;}set{m_iFileType = value;}}
		public string FileName{get{return m_sFileName;}set{m_sFileName = value;}}
		public string FilePath{get{return m_sFilePath;}set{m_sFilePath = value;}}
		public string CreateDate{get{return m_sCreateDate;}set{m_sCreateDate = value;}}
		public DateTime FileDate{get{return m_dtFileDate;}set{m_dtFileDate = value;}}
		public int FileSize{get{return m_iFileSize;}set{m_iFileSize = value;}}
		public string FileOwner{get{return m_sFileOwner;}set{m_sFileOwner = value;}}
		public string FileGroup{get{return m_sFileGroup;}set{m_sFileGroup = value;}}
		#endregion
	}
		
	public class ListEntry: System.Collections.CollectionBase
	{
		private string m_strCurrentWorkingDir;

		public ListEntry(string sList, string sDir)
		{
			m_strCurrentWorkingDir = sDir;
			ParseStringArrayForUnix(sList.Split("\n".ToCharArray()));
		}

		/// <summary>
		/// 
		/// </summary>
		/// <param name="l_arrFiles"></param>
		/// <returns></returns>
		private void ParseStringArrayForUnix(string[] l_arrFiles)
		{

			string l_strcurFile = "";
			int l_iFileCount = l_arrFiles.Length;
			char[] arrSep = new char[2];
			arrSep[0] = ' ';
			arrSep[1] = '\0';

			foreach(object obj in l_arrFiles) 
			{
				l_strcurFile = (string) obj;

				if(l_strcurFile != "")
				{
					/*	Parse for file info */
					string[] arrFields = SplitStringForUnix(l_strcurFile);
					if (arrFields.Length == 1 || arrFields[0].Length <= 0 ) 
					{
						/*	If the element is empty, do not attempt to parse it */
						continue;
					}
					/*	Each field is now in arrFields */
					GetFileInfoForUnix(arrFields);
				}
			}
		}

		/// <summary>
		/// 
		/// </summary>
		/// <param name="arrFields"></param>
		/// <returns></returns>
		private void GetFileInfoForUnix(string[] arrFields)
		{
			string sField = "";
			string sFileName = "" ,sFilePath = "" ,sDateCreated = "";
			string sFileOwner = "",sFileGroup = "";
			int iFileSize = 0;
			eFILE_TYPE eFileType = eFILE_TYPE.FILE_TYPE_UNKNOWN;
			int iCount = 0;
			char chTemp = '\0';

			foreach(object obj in arrFields) 
			{
				sField = (string) obj;
				if (sField.Length <= 0 ) 
				{
					/*	If error occured while parsing return null and ignore this element */
					return;
				}
				switch( iCount) 
				{
					case 0:		/*	File Type */
						chTemp = sField[0];
						if ( chTemp == '-' ) 
						{
							/*	Normal File */
							eFileType = eFILE_TYPE.FILE_TYPE_FILE;
						}
						else if ( chTemp == 'd') 
						{
							/*	Directory */
							eFileType = eFILE_TYPE.FILE_TYPE_DIRECTORY;
						}
						else if ( chTemp == 'c' ) 
						{
							/*	System file */
							eFileType = eFILE_TYPE.FILE_TYPE_SYSTEM;
						}
						else 
						{
							/*	Unknown file type */
							eFileType = eFILE_TYPE.FILE_TYPE_UNKNOWN;
						}
						break;
					case 1 :	/*	File Links */
						break;
					case 2 :	/*	File Owner */
						sFileOwner = sField;
						break;
					case 3 :	/*	File group */
						sFileGroup = sField;
						break;
					case 4 :	/*	File size in bytes */
						iFileSize = int.Parse(sField);
						break;
					case 5 :	/*	Date created ( contains month in mmm format ) */
						sDateCreated = sField;
						break;
					case 6 :	/*	Date created ( contains day in dd format ) */
						sDateCreated += " " + sField;
						break;
					case 7 :	/*	Date created ( contains time in HH:SS or year in YYYY format ) */
						sDateCreated += " " + sField;
						break;
					case 8 :	/*	File name */
						sFileName = sField;
						sFileName = sFileName.Trim();
						if (sFileName.Length == 0 ) 
						{
							sFileName = "<unknown>";
						}
						break;
					case 9 :
						break;
				}	/*	End of switch statement */
				iCount++;
			}	/*	End of for */

			if ( sFileName == "." || sFileName == ".." )
			{
				return;
			}

			if ( m_strCurrentWorkingDir.EndsWith("/") == true )
			{
				sFilePath = m_strCurrentWorkingDir + sFileName;
			}
			else 
			{
				sFilePath = m_strCurrentWorkingDir + "/" + sFileName;
			}

			ListItem li = new ListItem();

			li.FileType = eFileType;
			li.FileName = sFileName;
			li.FilePath = sFilePath;
			li.CreateDate = sDateCreated;

			System.Globalization.DateTimeFormatInfo v =new System.Globalization.DateTimeFormatInfo();
			v.MonthDayPattern = "MMM d";
			v.ShortTimePattern = "HH:mm";
			v.ShortDatePattern = "yyyy MMM d";
			v.FullDateTimePattern = "yyyy MMM d HH:mm";
			System.IFormatProvider format = v;
			DateTime dt = DateTime.Parse(DateTime.Now.Year+" "+sDateCreated,format,System.Globalization.DateTimeStyles.AllowWhiteSpaces);

			li.FileDate = dt;
			li.FileSize = iFileSize;
			li.FileOwner = sFileOwner;
			li.FileGroup = sFileGroup;

			this.Add(li);
		}

		/// <summary>
		/// This function takes a string and squeezes more than
		/// one space characters into one character and
		/// then splits into array and returns back to the caller
		/// </summary>
		/// <param name="s1Line">Input String</param>
		/// <returns>Output string in an array</returns>
		private string[] SplitStringForUnix(string s1Line)
		{
			string[] arrOut = new string[9];
			char[] arrSep = new char[2];
			arrSep[0] = ' ';
			arrSep[1] = '\0';
			int iField = 0;

			string[] arrTemp = s1Line.Split(arrSep);

			for (int i = 0 ; i < arrTemp.Length ; i++ ) 
			{
				if(iField == 8) 
				{
					
				
					if(arrOut[8] == "")
					{
						arrOut[8] = arrTemp[i];
					}
					else
					{
						if(i == (arrTemp.Length - 1))
						{
							arrOut[8] += ' ' + arrTemp[i].Trim();
						}
						else
						{
							arrOut[8] += ' ' + arrTemp[i];
						}
					}
				}
				else
				{
					if(arrTemp[i] != "")
					{
						arrOut[iField] = arrTemp[i].Trim();
						iField++;
					}
				}
			}

			return arrOut;
		}

		#region list methods and properties
		
		public void Add(ListItem le)
		{
			List.Add(le);
		}

		public ListItem Item(int Index)
		{
			return (ListItem) List[Index];
		}

		public ListItem Item(Object li)
		{
			return (ListItem) List[List.IndexOf(li)];
		}
		public ListItem Item(string name)
		{
			foreach(ListItem li in this)
			{
				if(li.FileName == name)
				{
					return li;
				}
			}
			return null;
		}
		public bool Contains(string name)
		{
			return List.Contains(this.Item(name));
		}

		#endregion

	}
}
