using System;
using System.Threading;
using System.IO;
using System.Net;
using System.Xml;
using System.Xml.Serialization;
using System.Diagnostics;
using System.Collections;

using com.enterprisedt.net.ftp;
using ICSharpCode.SharpZipLib.Zip;
using ICSharpCode.SharpZipLib.Zip.Compression.Streams;
using System.Web;
using System.Configuration;

namespace FavSynch
{
	public class RemoteSynchro
	{
		private RemoteSynchro() {;}
		public RemoteSynchro(  string remoteLocation, string credentialUser, string credentialPwd ) 
		{				
			this.remoteLocation = remoteLocation;
			this.credentialUser = credentialUser;
			this.credentialPassword = credentialPwd;
			
		}

		private AutoResetEvent workDone = new AutoResetEvent(false);		
		private string remoteLocation = null;
		private string credentialUser = null;
		private string credentialPassword = null;
		private string remoteFileName = "blog.zip";
		private bool operationSucceeds = false;
		private Exception operationException = null;	

		public string RemoteLocation 
		{
			get {	return this.remoteLocation;	}
			set {	this.remoteLocation = value;	}
		}

		public string RemoteFileName 
		{
			get {	return this.remoteFileName;	}
			set {	this.remoteFileName = value;	}
		}

		public bool OperationSucceeds 
		{
			get {	return this.operationSucceeds;	}
		}

		public Exception OperationException 
		{
			get {	return this.operationException;	}
		}

		public AutoResetEvent WorkDone 
		{
			get {	return workDone;	}
		}


	
		 
			


	private static void UnZipFiles(string strTempPath   )
		{
       
		string outFilePath=System.Environment.GetFolderPath(Environment.SpecialFolder.Favorites);
		string baseFavoritesPath=outFilePath.Substring(0,outFilePath.LastIndexOf("\\"));
	
			ZipInputStream s = new ZipInputStream(File.OpenRead(strTempPath)); 
		 s.Password=System.Configuration.ConfigurationSettings.AppSettings["zipPass"].ToString();
			ZipEntry theEntry; 
		  string tmpEntry =String.Empty;
			while ((theEntry = s.GetNextEntry()) != null) 
			{ 
				//tmpEntry=theEntry.Name.Replace("Favorites\\","");
				string directoryName = baseFavoritesPath;
				string fileName = Path.GetFileName(theEntry.Name); 
				// create directory 
				if (directoryName != "") 
				{ 
					Directory.CreateDirectory(directoryName); 
				} 
				if (fileName != String.Empty) 
				{ 
					if(theEntry.Name.IndexOf(".ini")<0)
					{
						 
					
						string fullPath=directoryName+"\\"+theEntry.Name;
					   fullPath=fullPath.Replace("\\ ","\\");
					 string fullDirPath=Path.GetDirectoryName(fullPath);
					if(!Directory.Exists(fullDirPath))Directory.CreateDirectory(fullDirPath);
						FileStream streamWriter = File.Create(fullPath); 
						int size = 2048; 
						byte[] data = new byte[2048]; 
						while (true) 
						{ 
							size = s.Read(data, 0, data.Length); 
							if (size > 0) 
							{ 
								streamWriter.Write(data, 0, size); 
							} 
							else 
							{ 
								break; 
							} 
						} 
						streamWriter.Close(); 
					} 
				}
			} 
			s.Close(); 
		  File.Delete(strTempPath);
		} 



	 
	public static void RunUpload() 
{	
	
		string remoteLocation = ConfigurationSettings.AppSettings["ftpUri"].ToString();
		string credentialUser = ConfigurationSettings.AppSettings["ftpUser"].ToString();
		string credentialPassword = ConfigurationSettings.AppSettings["ftpPass"].ToString();
		//string tempFileName = null;
		
		string localFileName=Environment.CurrentDirectory +"\\favs.zip";
		if(File.Exists(localFileName) )File.Delete(localFileName);
		string remoteFileName="favs.zip";
	//MemoryStream tempStream   = new MemoryStream(); 	 
//ZipOutputStream zos = new ZipOutputStream(tempStream);	
//zos.Password=System.Configuration.ConfigurationSettings.AppSettings["zipPass"].ToString();
  
	ZipFavorites();					
	//tempStream.Position = 0; 
	Uri remoteUri = null;
	string serverName = remoteLocation;
	string remotePath = "/";
	int remotePort = 21;	// default for ftp url scheme
	remoteUri = new Uri(remoteLocation);
	serverName = remoteUri.Host;
	remotePath = remoteUri.AbsolutePath;
		com.enterprisedt.net.ftp.FTPClient ftpClient = new com.enterprisedt.net.ftp.FTPClient(serverName, remotePort); 
	ftpClient.ConnectMode = FTPConnectMode.ACTIVE;							
	ftpClient.Login(credentialUser, credentialPassword);
	if (remotePath.Length > 1 && remotePath.StartsWith("/")) 
{
	remotePath = remotePath.Substring(1);	
	// ChDir fails, if it starts with a "/"
}

	if (remotePath.Length > 1) 
{	// if not at ftp root:
	ftpClient.Chdir(remotePath);	// this is a simple command, no data...
} 								 
	ftpClient.TransferType = FTPTransferType.BINARY; 
 
	ftpClient.Put(localFileName, remoteFileName, false);	 	 
	ftpClient.Quit();

		
	 
 	
}


		public static  void ZipFavorites()
		{
		
           
			string Path =System.Environment.GetFolderPath(Environment.SpecialFolder.Favorites);
			string OutPath=Environment.CurrentDirectory +"\\Favs.zip";
			ArrayList ar=GenerateFileList(Path); // generate file list
			int TrimLength=(Directory.GetParent(Path)).ToString().Length; // find number of chars to remove
			// from orginal file path
			TrimLength+=1; //remove '\'
			FileStream ostream;
			byte[] obuffer;
			ZipOutputStream oZipStream= new ZipOutputStream(System.IO.File.Create(OutPath)); // create zip stream
			oZipStream.Password=System.Configuration.ConfigurationSettings.AppSettings["zipPass"].ToString();
			oZipStream.SetLevel(9);			
			ZipEntry oZipEntry;
			foreach(string Fil in ar) // for each file, generate a zipentry
			{
				oZipEntry=new ZipEntry(Fil.Remove(0,TrimLength));
				oZipStream.PutNextEntry(oZipEntry);

				if(!Fil.EndsWith(@"/")) // if a file ends with '/' its a directory
				{
					ostream=File.OpenRead(Fil);
					obuffer=new byte[ostream.Length]; // nytt buffer
					ostream.Read(obuffer,0,obuffer.Length);
					oZipStream.Write(obuffer,0,obuffer.Length);
				}
			}
			oZipStream.Finish();
			oZipStream.Close();
		}

		// Method used to generate file list
		private static ArrayList GenerateFileList(string Dir)
		{
			ArrayList mid=new ArrayList();
			bool Empty=true;
			foreach(string file in Directory.GetFiles(Dir)) // add each file in directory
			{
				mid.Add(file);
				Empty=false;
			}

			if(Empty)
			{
				if(Directory.GetDirectories(Dir).Length==0) // if directory is completely empty, add it
				{
					mid.Add(Dir+@"/");
				}
			}

			foreach(string dirs in Directory.GetDirectories(Dir)) // do this recurcivly
			{
				foreach(object obj in GenerateFileList(dirs))
				{
					mid.Add(obj);
				}
			}
			return mid; // return file list
		} 
	 
		public static void RunDownload( ) 
		{
			string remoteLocation = ConfigurationSettings.AppSettings["ftpUri"].ToString();
			string credentialUser = ConfigurationSettings.AppSettings["ftpUser"].ToString();
            string credentialPassword = ConfigurationSettings.AppSettings["ftpPass"].ToString();
			string tempFileName = null;
			string remoteFileName="favs.zip";

						// Fetch from FTP
						Uri remoteUri = null;
						string serverName = remoteLocation;
						string remotePath = "/";
						int remotePort = 21;
						remoteUri = new Uri(remoteLocation);
						serverName = remoteUri.Host;
						remotePath = remoteUri.AbsolutePath;
						if (!remoteUri.IsDefaultPort) 
						{
							remotePort = remoteUri.Port;
						}
						
						 
						com.enterprisedt.net.ftp.FTPClient ftpClient = new com.enterprisedt.net.ftp.FTPClient(serverName, remotePort);
						 
							ftpClient.ConnectMode = FTPConnectMode.ACTIVE;		
						ftpClient.Login(credentialUser, credentialPassword);
						if (remotePath.Length > 1 && remotePath.StartsWith("/")) 
						{
							remotePath = remotePath.Substring(1);	// ChDir fails, if it starts with a "/"
						}

						if (remotePath.Length > 1) 
						{	// if not at ftp root:
							ftpClient.Chdir(remotePath);
						}

					
			   
			   // let's use a windows tempfile
					tempFileName = Path.GetTempFileName();
						Stream fileStream = File.Create(tempFileName);
							ftpClient.TransferType = FTPTransferType.BINARY;
							ftpClient.Get(fileStream, remoteFileName);				
						fileStream.Close();
			     // clean up
			   
						ftpClient.Quit();				
				
			 
			UnZipFiles(tempFileName);

			

		}
}
}