using System;
using System.IO;
using System.Collections;
using System.ComponentModel;
using System.Data;
using System.Diagnostics;
using System.ServiceProcess;
using LumiSoft.Net.FTP.Server;

namespace LumiSoft.Net.FTP.Server
{
	public class ls_FTP_Service : System.ServiceProcess.ServiceBase
	{
		private System.ComponentModel.IContainer components;		
		private System.Timers.Timer timer1;
		private FTP_Server m_pServer = null;

		private DateTime m_SettingsDate;        // Holds server Settings.xml date.
		private string   m_SartUpPath    = "";	// Path where (this)service relies.
		private string   m_FtpRoot       = "";

		/// <summary>
		/// Default constructor.
		/// </summary>
		public ls_FTP_Service()
		{
			// This call is required by the Windows.Forms Component Designer.
			InitializeComponent();

			// TODO: Add any initialization after the InitComponent call
		}

		// The main entry point for the process
		static void Main()
		{
			System.ServiceProcess.ServiceBase[] ServicesToRun;
	
			// More than one user Service may run within the same process. To add
			// another service to this process, change the following line to
			// create a second service object. For example,
			//
			//   ServicesToRun = new System.ServiceProcess.ServiceBase[] {new Service1(), new MySecondUserService()};
			//
			ServicesToRun = new System.ServiceProcess.ServiceBase[] { new ls_FTP_Service() };

			System.ServiceProcess.ServiceBase.Run(ServicesToRun);
		}

		#region Designer Generated code

		/// <summary> 
		/// Required method for Designer support - do not modify 
		/// the contents of this method with the code editor.
		/// </summary>
		private void InitializeComponent()
		{
			this.components = new System.ComponentModel.Container();
			this.m_pServer = new LumiSoft.Net.FTP.Server.FTP_Server(this.components);
			this.timer1 = new System.Timers.Timer();
			((System.ComponentModel.ISupportInitialize)(this.timer1)).BeginInit();
			// 
			// m_pServer
			// 
			this.m_pServer.CommandIdleTimeOut = 60000;
			this.m_pServer.LogCommands = false;
			this.m_pServer.MaxBadCommands = 30;
			this.m_pServer.SessionIdleTimeOut = 800000;
			this.m_pServer.CreateDir += new LumiSoft.Net.FTP.Server.FileSysEntryEventHandler(this.OnCreateDir);
			this.m_pServer.StoreFile += new LumiSoft.Net.FTP.Server.FileSysEntryEventHandler(this.OnStoreFile);
			this.m_pServer.DeleteDir += new LumiSoft.Net.FTP.Server.FileSysEntryEventHandler(this.OnDeleteDir);
			this.m_pServer.SysError += new LumiSoft.Net.ErrorEventHandler(this.OnSysError);
			this.m_pServer.DirExists += new LumiSoft.Net.FTP.Server.FileSysEntryEventHandler(this.OnDirExists);
			this.m_pServer.FileExists += new LumiSoft.Net.FTP.Server.FileSysEntryEventHandler(this.OnFileExists);
			this.m_pServer.RenameDirFile += new LumiSoft.Net.FTP.Server.FileSysEntryEventHandler(this.OnRenameDirFile);
			this.m_pServer.DeleteFile += new LumiSoft.Net.FTP.Server.FileSysEntryEventHandler(this.OnDeleteFile);
			this.m_pServer.ValidateIPAddress += new LumiSoft.Net.ValidateIPHandler(this.OnValidateIP);
			this.m_pServer.GetFile += new LumiSoft.Net.FTP.Server.FileSysEntryEventHandler(this.OnGetFile);
			this.m_pServer.GetDirInfo += new LumiSoft.Net.FTP.Server.FileSysEntryEventHandler(this.OnGetDirInfo);
			this.m_pServer.AuthUser += new LumiSoft.Net.FTP.Server.AuthUserEventHandler(this.OnAuthUser);
			// 
			// timer1
			// 
			this.timer1.Interval = 15000;
			this.timer1.Elapsed += new System.Timers.ElapsedEventHandler(this.timer1_Elapsed);
			// 
			// Service1
			// 
			this.ServiceName = "Service1";
			((System.ComponentModel.ISupportInitialize)(this.timer1)).EndInit();

		}

		#endregion

		#region method Dispose

		/// <summary>
		/// Clean up any resources being used.
		/// </summary>
		protected override void Dispose( bool disposing )
		{
			if( disposing )
			{
				if (components != null) 
				{
					components.Dispose();
				}
			}
			base.Dispose( disposing );
		}

		#endregion


		#region method OnStart

		/// <summary>
		/// Set things in motion so your service can do its work.
		/// </summary>
		protected override void OnStart(string[] args)
		{
			string filePath     = System.Diagnostics.Process.GetCurrentProcess().MainModule.FileName;
			m_SartUpPath        = filePath.Substring(0,filePath.LastIndexOf('\\')) + "\\";
			Error.ErrorFilePath = m_SartUpPath;
		
			timer1.Enabled = true;
			this.timer1_Elapsed(this,null);
		}

		#endregion

		#region method OnStop
 
		/// <summary>
		/// Stop this service.
		/// </summary>
		protected override void OnStop()
		{
			timer1.Enabled    = false;
			m_pServer.Enabled = true;
		}

		#endregion


		#region Events handling

		#region method timer1_Elapsed

		private void timer1_Elapsed(object sender, System.Timers.ElapsedEventArgs e)
		{
			try
			{	
				//------------ local settings --------------------------------------------------------------//
				DateTime dateSettings = File.GetLastWriteTime(m_SartUpPath + "\\Settings\\Settings.xml");

				if(DateTime.Compare(dateSettings,m_SettingsDate) != 0){
					DataSet ds = new DataSet();
					ds.ReadXml(m_SartUpPath + "\\Settings\\Settings.xml");

					m_FtpRoot = ds.Tables["Settings"].Rows[0]["FtpRoot"].ToString();
					if(m_FtpRoot.EndsWith("\\")){
						m_FtpRoot = m_FtpRoot.Substring(0,m_FtpRoot.Length - 1);
					}

					m_pServer.Port = Convert.ToInt32(ds.Tables["Settings"].Rows[0]["Port"]);
					m_pServer.Enabled = true;

					m_SettingsDate = dateSettings;
				}				
			}
			catch(Exception x){
				Error.DumpError(x,new System.Diagnostics.StackTrace());
			}
		}

		#endregion


		#region FTP server events

		#region method OnAuthUser

		public void OnValidateIP(object sender,ValidateIP_EventArgs e)
		{			
			e.Validated = true;
		}

		#endregion

		#region method OnAuthUser

		public void OnAuthUser(object sender,AuthUser_EventArgs e)
		{			
			if(Impersonate.LogonAndImpersonateUser(e.UserName,e.PasswData)){
				e.Validated = true;
			}
			else{
				e.Validated = false;
			}
		}

		#endregion


		#region method OnGetDirInfo

		public void OnGetDirInfo(object sender,FileSysEntry_EventArgs e)
		{			
			try{				
				DataTable dt = e.DirInfo.Tables["DirInfo"];

				string physicalPath = GetPhysicalPath(e.Name);

				// Add directories
				if(Directory.Exists(physicalPath)){
					string[] dirs = Directory.GetDirectories(physicalPath);
					foreach(string d in dirs){
						DataRow dr = dt.NewRow();
						dr["Name"] = new DirectoryInfo(d).Name;
						dr["Date"] = Directory.GetCreationTime(d);
					//	dr["Size"] = "";
						dr["IsDirectory"] = true;

						dt.Rows.Add(dr);
					}
					
					// Add virtual folders
					if(File.Exists(physicalPath + "__Config_ftp.xml")){
						try{
							DataSet ds = new DataSet();
							ds.ReadXml(physicalPath + "__Config_ftp.xml");

							foreach(DataRow dr in ds.Tables["virtualFolder"].Rows){
								// ToDo: if virtual folder is same name as physical folder

								// Add vitual folder to list only if it exists
								string vDirPhysicalPath = dr["path"].ToString();
								if(Directory.Exists(vDirPhysicalPath)){
									DataRow drX = dt.NewRow();
									drX["Name"] = dr["name"].ToString();
									drX["Date"] = Directory.GetCreationTime(vDirPhysicalPath);
								//	drX["Size"] = "";
									drX["IsDirectory"] = true;

									dt.Rows.Add(drX);
								}
							}
						}
						catch{
						}
					}

					// Add files
					string[] files = Directory.GetFiles(physicalPath);
					foreach(string f in files){
						// Hide config file
						if(Path.GetFileName(f).ToLower() != "__config_ftp.xml"){
							DataRow dr = dt.NewRow();
							dr["Name"] = Path.GetFileName(f);
							dr["Date"] = File.GetCreationTime(f);
							dr["Size"] = new FileInfo(f).Length;
							dr["IsDirectory"] = false;

							dt.Rows.Add(dr);
						}
					}
					
				}
			}
			catch{
				e.Validated = false;
			}
		}

		#endregion

		#region method OnDirExists

		public void OnDirExists(object sender,FileSysEntry_EventArgs e)
		{			
			if(!Directory.Exists(GetPhysicalPath(e.Name))){
				e.Validated = false;
			}
		}

		#endregion

		#region method OnCreateDir

		public void OnCreateDir(object sender,FileSysEntry_EventArgs e)
		{	
			if(Directory.Exists(GetPhysicalPath(e.Name))){
				e.Validated = false;
			}
			else{
				Directory.CreateDirectory(GetPhysicalPath(e.Name));
			}
		}

		#endregion

		#region method OnDeleteDir

		public void OnDeleteDir(object sender,FileSysEntry_EventArgs e)
		{		
			if(!IsVirtualDir(e.Name) && Directory.Exists(GetPhysicalPath(e.Name))){				
				Directory.Delete(GetPhysicalPath(e.Name));				
			}
			else{			
				e.Validated = false;
			}
		}

		#endregion

		#region method OnRenameDirFile

		public void OnRenameDirFile(object sender,FileSysEntry_EventArgs e)
		{
			// Remove last /
			string to   = e.NewName.Substring(0,e.NewName.Length - 1);
			string from = e.Name.Substring(0,e.Name.Length - 1);

			if(IsVirtualDir(to) || IsVirtualDir(from) || Directory.Exists(GetPhysicalPath(to)) || File.Exists(GetPhysicalPath(to))){
				e.Validated = false;
			}
			else{
				if(Directory.Exists(GetPhysicalPath(from))){
					Directory.Move(GetPhysicalPath(from),GetPhysicalPath(to));
				} 
				else if(File.Exists(GetPhysicalPath(from))){
					File.Move(GetPhysicalPath(from),GetPhysicalPath(to));
				}
			}			
		}

		#endregion


		#region method OnFileExists

		public void OnFileExists(object sender,FileSysEntry_EventArgs e)
		{	
			try{
				if(File.Exists(GetPhysicalPath(e.Name))){
					e.Validated = true;
				}
			}
			catch{
				e.Validated = false;
			}
		}

		#endregion

		#region method OnGetFile

		public void OnGetFile(object sender,FileSysEntry_EventArgs e)
		{	
			try{
				if(File.Exists(GetPhysicalPath(e.Name))){
					e.FileStream = File.OpenRead(GetPhysicalPath(e.Name));
				}
			}
			catch{
				e.Validated = false;
			}
		}

		#endregion

		#region method OnStoreFile

		public void OnStoreFile(object sender,FileSysEntry_EventArgs e)
		{	
			try{
				if(!File.Exists(GetPhysicalPath(e.Name))){
					e.FileStream = File.Create(GetPhysicalPath(e.Name));
				}
			}
			catch{
				e.Validated = false;
			}
		}

		#endregion

		#region method OnDeleteFile

		public void OnDeleteFile(object sender,FileSysEntry_EventArgs e)
		{			
			if(File.Exists(GetPhysicalPath(e.Name))){
				File.Delete(GetPhysicalPath(e.Name));
			}
			else{
				e.Validated = false;
			}
		}

		#endregion


		#region method OnSysError

		public void OnSysError(object sender,Error_EventArgs e)
		{			
			Error.DumpError(e.Exception,e.StackTrace);
		}

		#endregion
		
		#endregion

		#endregion


		#region method GetPhysicalPath

		/// <summary>
		/// Gets physical path from absolute path (replaces virtual folders with real path).
		/// </summary>
		/// <param name="path"></param>
		/// <returns></returns>
		private string GetPhysicalPath(string path)
		{
			string pPath = m_FtpRoot + "\\";

			bool endsWithSep = false;

			if(path.StartsWith("/")){
				path = path.Substring(1,path.Length - 1);
			}
			if(path.EndsWith("/")){
				path = path.Substring(0,path.Length - 1);
				endsWithSep = true;
			}

			string[] pathParts = path.Split('/','\\');
			foreach(string part in pathParts){
				if(part.Length > 0){
					// This is physical directory
					if(Directory.Exists(pPath + part)){					
						pPath += part + "/";
					}
					else{
						// See if virtual folder
						if(File.Exists(pPath + "__Config_ftp.xml")){						
							try{
								DataSet ds = new DataSet();
								ds.ReadXml(pPath + "__Config_ftp.xml");

								ds.Tables["virtualFolder"].DefaultView.RowFilter = "name='" + part + "'";
								if(ds.Tables["virtualFolder"].DefaultView.Count > 0){								
									pPath = ds.Tables["virtualFolder"].DefaultView[0]["path"].ToString();
									
									if(!pPath.EndsWith("\\")){
										pPath += "/"; 
									}
								}
								else{
									pPath += part + "/";
								}
							}
							catch{
							}
						}
						else{
							pPath += part + "/";
						}
					}
				}
			}

			if(!endsWithSep && pPath.EndsWith("/")){
				pPath = pPath.Substring(0,pPath.Length - 1);
			}

			return pPath;
		}

		#endregion

		#region method IsVirtualDir

		/// <summary>
		/// Gets if specified dir is virtual directory.
		/// </summary>
		/// <param name="dir"></param>
		/// <returns></returns>
		private bool IsVirtualDir(string dir)
		{
			if(dir.StartsWith("/")){
				dir = dir.Substring(1,dir.Length - 1);
			}
			if(dir.EndsWith("/")){
				dir = dir.Substring(0,dir.Length - 1);
			}

			string pPath = "";

			//--- Move dir up and get physical path
			string[] pathParts = dir.Split('/','\\');
			if(pathParts.Length > 1){
		//		pPath = "";
				for(int i=0;i<(pathParts.Length - 1);i++){
					pPath += pathParts[i] + "/";
				}

				if(pPath.Length == 0){
					pPath = "/";
				}
			}
		//	else{
		//		pPath = "";
		//	}

			pPath = GetPhysicalPath(pPath);
			//---------------------------------------------

			if(!Directory.Exists(pPath + pathParts[pathParts.Length - 1])){				
				// See if virtual folder
				if(File.Exists(pPath + "__Config_ftp.xml")){
					try{
						DataSet ds = new DataSet();
						ds.ReadXml(pPath + "__Config_ftp.xml");

						ds.Tables["virtualFolder"].DefaultView.RowFilter = "name='" + pathParts[pathParts.Length - 1] + "'";
						if(ds.Tables["virtualFolder"].DefaultView.Count > 0){								
							return true;
						}
					}
					catch{
					}
				}
			}

			return false;
		}

		#endregion

	}
}
