using System;
using Microsoft.ContentManagement.Publishing;
using System.Text;
using System.Xml;

namespace GoogleSitemap
{
	class General
	{
		/// <summary>
		/// Application to generate a google sitemap for CMS sites
		/// DotNet framework 1.1 / MCMS 2002 SP1a
		/// http://www.google.com/webmasters/sitemaps
		/// 
		/// Parameters :
		/// -startpath				(eg "/Channels/Site/SubOne" )
		/// -path+name xml result	(eg "c:/inetpub/wwwroot/sitemap.xml )
		/// -xmlns					(eg http://www.google.com/schemas/sitemap/0.84 )
		/// -domain					(eg http://www.mysite.org )
		/// -skipchannels			(eg /Channels/admin/|/Channels/Extra !!!leading and trailing slash)
		/// </summary>
		
		static string strDomain;
		static string strSkip;

		[STAThread]
		static void Main(string[] args)
		{

			CmsApplicationContext cc = new CmsApplicationContext();
			cc.AuthenticateAsCurrentUser();

			Channel ch = (Channel)cc.Searches.GetByPath(args[0]);

			XmlTextWriter xtw = new XmlTextWriter(args[1],  Encoding.UTF8);

			xtw.Formatting = Formatting.Indented;
			xtw.WriteStartDocument();
			xtw.WriteStartElement("urlset", args[2]);
			
			strDomain = args[3];
			strSkip = "|" + args[4].ToLower() + "|";
			BuildSiteMap(ch, xtw); //loop all postings and subchannels from channel ch

			xtw.WriteEndElement();
			xtw.Flush();
			xtw.Close();

		}

		static private void BuildSiteMap(Channel channel, XmlTextWriter xtw) 
		{ 
			if (strSkip.IndexOf("|" + channel.Path.ToLower() + "|") != -1)
			{
				Console.WriteLine("Skipping channel: " + channel.Path);
			}
			else
			{
				Console.WriteLine("Processing channel: " + channel.Path);

				foreach (Posting p in channel.Postings)
				{
					xtw.WriteStartElement("url", null);
					xtw.WriteElementString("loc", strDomain + p.UrlModePublished);
					xtw.WriteElementString("lastmod", p.LastModifiedDate.ToString("yyyy-MM-dd")); 
					xtw.WriteEndElement();
				}

				// process all subchannel of current channel
				foreach (Channel ch in channel.Channels) 
				{  
					BuildSiteMap(ch, xtw); 
				} 
			}
			
		}

	}
}
