///
///  This source code is freeware and is provided on an "as is" basis without warranties of any kind, 
///  whether express or implied, including without limitation warranties that the code is free of defect, 
///  fit for a particular purpose or non-infringing.  The entire risk as to the quality and performance of 
///  the code is with the end user.
///
///  Created by Stefan Goner (stefang@microsoft.com)
///
///  Latest Updates: 
///    31.05.2006  V1.0  release proof of concept
///    16.06.2006  V1.1  support @-sign in placeholder
///    26.07.2006  V1.2  support linebreaks and single quotes in placeholder
///    10.08.2006  V1.3  support connected postings
///

using System; 
using System.IO; 
using System.Web; 
using System.Text.RegularExpressions; 
using Microsoft.ContentManagement.Publishing; 
using Microsoft.ContentManagement.WebControls; 

namespace StefanG.PlaceholderControls 
{ 
	// Customer placeholder control to modify the insertion of object tags to comply to  
	// IE behaviour changes 
	public class AutoActivateHtmlPlaceholderControl : HtmlPlaceholderControl 
	{ 
		public AutoActivateHtmlPlaceholderControl() 
		{ 
			// empty constructor
		} 

		// register a client script blog that modifies the insertion of the object tag for the 
		// editor toolbar 
		protected override void OnLoad(EventArgs e) 
		{ 
			string js = "<script language=\"javascript\" type=\"text/javascript\" src=\""+Page.Request.ApplicationPath+
				"/CMS/WebAuthor/Client/PlaceholderControlSupport/AuthFormClientIE.js\"></script>"; 
			string vbs = "<script language=\"vbscript\" type=\"text/vbscript\" src=\""+Page.Request.ApplicationPath+
				"/CMS/WebAuthor/Client/PlaceholderControlSupport/ActiveXEditing.vbs\"></script>"; 
			string activeX = "<script language=\"Javascript\" src=\""+Page.Request.ApplicationPath+
				"/CreateIEBehaviorChangeJavascript.aspx?script=Toolbar\"></script>\n"+
				"<script language=\"Javascript\">ActiveX_writeToolbar();</script>"; 
			Page.RegisterClientScriptBlock("ActiveXToolbarAndEditorSupportScript", js+"\n"+vbs+"\n"+activeX); 
		} 

		// in the Render method we consume the generated html content from the base class 
		// then we remove the object tag using a regular expression and replace it  
		// with a script tag that get's it content from the external  
		// CreateIEBehaviorChangeJavascript.ASPX page which  
		// generates the javascript code on the fly. 
		protected override void Render(System.Web.UI.HtmlTextWriter output) 
		{ 
			if (((WebAuthorContext.Current.Mode == WebAuthorContextMode.AuthoringReedit)  
				||(WebAuthorContext.Current.Mode == WebAuthorContextMode.AuthoringNew))) 
			{ 
				// in authoring mode catch the output of the original HtmlPlaceholderControl 
				TextWriter tempWriter = new StringWriter(); 
				base.Render(new System.Web.UI.HtmlTextWriter(tempWriter)); 
                 
				string orightml= tempWriter.ToString(); 

				// modify the html content 
				string strRegExp = "<object[^\\0]*</object>"; 
				Regex r = new Regex( strRegExp, RegexOptions.IgnoreCase | RegexOptions.Compiled ); 
				string newhtml = r.Replace( orightml,  
					"<script language=\"Javascript\" src=\""+Page.Request.ApplicationPath+
					"/CreateIEBehaviorChangeJavascript.aspx"+
					"?script=Placeholder"+ 
					"&"+Page.Request.QueryString.ToString()+
					"&PhName="+HttpUtility.UrlEncode(this.BoundPlaceholder.Name)+ 
					"&Width="+this.EditControlWidth+ 
					"&Height="+this.EditControlHeight+ 
					"\"></script>\n"+ 
					"<script lang='javascript'>ActiveX_placeholder_"+this.BoundPlaceholder.Name+"();</script>" );

				// return the modified html content 
				output.Write(newhtml); 
			} 
			else 
			{ 
				// not in authoring mode. Call the base render method. 
				base.Render(output); 
			} 
		} 

	} 
}

