///
///  This source code is freeware and is provided on an "as is" basis without warranties of any kind, 
///  whether express or implied, including without limitation warranties that the code is free of defect, 
///  fit for a particular purpose or non-infringing.  The entire risk as to the quality and performance of 
///  the code is with the end user.
///
///  Created by Stefan Goner (stefang@microsoft.com)
///
///  Latest Updates: 
///    31.05.2006  V1.0  release proof of concept
///    16.06.2006  V1.1  support @-sign in placeholder
///    26.07.2006  V1.2  support linebreaks and single quotes in placeholder
///    10.08.2006  V1.3  support connected postings
///

using System;
using System.Collections;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Web;
using System.Web.SessionState;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.HtmlControls;
using Microsoft.ContentManagement.Publishing;
using Microsoft.ContentManagement.Publishing.Extensions.Placeholders;

namespace SaveActiveXTest
{
	/// <summary>
	/// Summary description for CreateJavaScript.
	/// </summary>
	public class CreateJavaScript : System.Web.UI.Page
	{
		protected override void Render( HtmlTextWriter writer) 
		{ 
			if (Request.QueryString["script"] == "Toolbar") 
			{ 
				// here we emit the object tag for the ActiveX Toolbar
				writer.Write("\n// IE Behavior Change adaption by Stefan Goner\n"+ 
					"function ActiveX_writeToolbar()\n"+ 
					"{\n"+ 
					"document.writeln('<OBJECT ID=\"ToolbarInterface\" "+
					"CLASSID=\"CLSID:E99D3E39-5D92-4360-BA86-2C563B3CFFEB\" \\n');\n"+ 
					"document.writeln('CODEBASE=\""+Page.Request.ApplicationPath+
					"/CMS/WebAuthor/Client/PlaceholderControlSupport/nrdhtml.cab\" "+
					"WIDTH=0 HEIGHT=0>\\n');\n"+ 
					"document.writeln('<PARAM NAME=\"BaseUrl\" VALUE=\""+Page.Request.ApplicationPath+
					"/CMS/WebAuthor/Client/PlaceholderControlSupport/ToolbarImages/\">');\n"+ 
					"document.writeln('</OBJECT>');\n"+ 
					"}\n"); 
			}
			else if (Request.QueryString["script"] == "Placeholder") 
			{ 
				// we need to retrieve the original placeholder content to fill the placeholder control
				string EncodedHtmlContent = ""; 
				Posting p = CmsHttpContext.Current.Posting; 
				if (p != null) 
				{ 
					HtmlPlaceholder htmlPh = (p.Placeholders[HttpUtility.UrlDecode(Request.QueryString["PhName"])] as HtmlPlaceholder); 
					if (htmlPh != null) 
						EncodedHtmlContent = HttpUtility.HtmlEncode(htmlPh.Html); 
				} 

				// here we emit the object tag for the ActiveX Editor Component
				writer.Write("\n// IE Behavior Change adaption by Stefan Goner\n"+ 
					"function ActiveX_placeholder_"+Request.QueryString["PhName"]+"()\n"+ 
					"{\n"+ 
					"document.writeln('<OBJECT CODEBASE=\""+Page.Request.ApplicationPath+
					"/CMS/WebAuthor/Client/PlaceholderControlSupport/NRDHtml.cab\"');\n"+ 
					"document.writeln('ID=\"NCPHRICH_"+Request.QueryString["PhName"]+
					"\" CLASSID=\"CLSID:B33422AC-C567-4F7D-BB28-6583371EC4EE\" width=\""+
					Request.QueryString["Width"]+"\" height=\""+Request.QueryString["Height"]+"\">');\n"+ 
					"document.writeln('<PARAM NAME=\"PostUrl\" VALUE=\""+Page.Request.ApplicationPath+
					"/CMS/WebAuthor/Controls/ActiveXHtmlEditControl/ActiveXUpload.aspx?NRMODE=Update&NRNODEGUID="+
					Request.QueryString["NRNODEGUID"]+"&ph="+Request.QueryString["PhName"]+"\">');\n"+ 
					"document.writeln('   <PARAM NAME=\"HTML\" VALUE=\""+
					EncodedHtmlContent.Replace("\n"," ").Replace("\r"," ").Replace("'","&#039;")+"\"> ');\n"+ 
					"document.writeln('   <PARAM NAME=\"CodePage\" VALUE=\""+
					HttpContext.Current.Response.ContentEncoding.CodePage+"\"> ');\n"+ 
					"document.writeln('   <PARAM NAME=\"Charset\" VALUE=\""+
					HttpContext.Current.Response.ContentEncoding.WebName+"\"> ');\n"+ 
					"document.writeln('</OBJECT>');\n"+ 
					"}\n"); 
			} 
			else 
				writer.Write("SG-Error"); 
		} 

		#region Web Form Designer generated code
		override protected void OnInit(EventArgs e)
		{
			//
			// CODEGEN: This call is required by the ASP.NET Web Form Designer.
			//
			InitializeComponent();
			base.OnInit(e);
		}
		
		/// <summary>
		/// Required method for Designer support - do not modify
		/// the contents of this method with the code editor.
		/// </summary>
		private void InitializeComponent()
		{    
			this.Load += new System.EventHandler(this.Page_Load);

		}
		#endregion

		private void Page_Load(object sender, System.EventArgs e)
		{
	
		}
	}
}
