using System;
using System.IO;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;
using Microsoft.ContentManagement.Publishing;
using Microsoft.ContentManagement.WebControls;
using Microsoft.ContentManagement.WebControls.Design;
using Microsoft.ContentManagement.Publishing.Extensions.Placeholders;


namespace Stefan.PlaceholderControls
{
	/// <summary>
	/// Summary description for Class1.
	/// </summary>
	[
	ToolboxData("<{0}:ImageChangePlaceholderControl runat=server></{0}:ImageChangePlaceholderControl>"), 
	SupportedPlaceholderDefinitionType(typeof(HtmlPlaceholderDefinition))
	]
	public class ImageChangePlaceholderControl : HtmlPlaceholderControl
	{
		public ImageChangePlaceholderControl()
		{
			//
			// TODO: Add constructor logic here
			//
		}

		// internal attributes for the ImageChangePlaceholder Control
		private string AltText = "";
		private string SrcText_out = "";
		private string SrcText_over = "";
		private string ImageUrl_out = "";
		private string ImageUrl_over = "";
		private string LinkUrl = "";
		private string Target = "";

		private string crlf = "\n";

		// Authoring and Presentation Mode Containers
		private System.Web.UI.WebControls.PlaceHolder baseAuthoringContainer;
		private System.Web.UI.WebControls.PlaceHolder basePresentationContainer;


		protected override void CreateAuthoringChildControls(BaseModeContainer authoringContainer)
		{
			baseAuthoringContainer = new System.Web.UI.WebControls.PlaceHolder();
			authoringContainer.Controls.Add(baseAuthoringContainer );
		}

		protected override void CreatePresentationChildControls(BaseModeContainer presentationContainer)
		{
			basePresentationContainer = new System.Web.UI.WebControls.PlaceHolder();
			presentationContainer.Controls.Add(basePresentationContainer );
		}

		private void RenderResourceGalleryRelatedJavascript()
		{
			string strJSWBC_setThinEditIEImage = 
				"<SCRIPT language=\"javascript\"> "																		+ crlf + 
				"SG_DestPh = \"\";"																						+ crlf + 
				"//"																									+ crlf + 
				"// Define new WBC_setThinEditIEImage function which will be used instead of the CMS predefined one."	+ crlf + 
				"//"																									+ crlf + 
				//	"function newWBC_setThinEditIEImage(strPhName, strURL, strHRef, strAltText) {"						+ crlf + 
				"function WBC_setThinEditIEImage(strPhName, strURL, strHRef, strAltText) {"								+ crlf + 
				"        var strMultiPurposeTag;"																		+ crlf + 
				"        if ( strAltText != \"\" ) {"																	+ crlf + 
				"                strMultiPurposeTag = \"<img src=\\\"\" + strURL + \"\\\" border=\\\"0\\\" alt=\\\"\" + strAltText + \"\\\">\";" + crlf + 
				"        } else {"																						+ crlf + 
				"                strMultiPurposeTag = \"<img src=\\\"\" + strURL + \"\\\" border=\\\"0\\\">\";"			+ crlf + 
				"        }"																								+ crlf + 
				""																										+ crlf + 
				"        if ((strHRef != \"\") && (strHRef != IDS_HTTP_PROTOCOL)) {"									+ crlf + 
				"                strMultiPurposeTag = \"<a href=\\\"\" + strHRef + \"\\\">\" + strMultiPurposeTag + \"</a>\";" + crlf + 
				"        }"																								+ crlf + 
				""																										+ crlf + 
				"        if (typeof document.all[\"NCPHRICH_\" + strPhName] != 'undefined') {"							+ crlf + 
				"            document.all[\"NCPHRICH_\" + strPhName].insertHtml(strMultiPurposeTag);"					+ crlf + 
				"        }"																								+ crlf + 
				"        else"																							+ crlf + 
				"        {"																								+ crlf + 
				"           if (typeof document.all[\"ICPH_Img_\" + SG_DestPh] != 'undefined') {"						+ crlf + 
				"               document.all[\"ICPH_Img_\" + SG_DestPh].src = strURL;"									+ crlf + 
				"           }"																							+ crlf + 
				"           if (typeof document.all[\"ICPH_ImgLink_\" + SG_DestPh] != 'undefined') {"					+ crlf + 
				"               document.all[\"ICPH_ImgLink_\" + SG_DestPh].value = strURL;"							+ crlf +						
				"           }"																							+ crlf + 
				"        }"																								+ crlf + 
				"}"																										+ crlf +
				""																										+ crlf + 
				//		"function Override_WBC_setThinEditIEImage() {"															+ crlf +
				//		"	window.WBC_setThinEditIEImage = newWBC_setThinEditIEImage;"											+ crlf +
				//		"	if (ImgChgPh_SavedOnLoad != null)"																	+ crlf +
				//		"		ImgChgPh_SavedOnLoad();"																		+ crlf +
				//		"}"																										+ crlf +
				//		"ImgChgPh_SavedOnLoad = document.body.onload;"															+ crlf + 
				//		"document.body.onload = Override_WBC_setThinEditIEImage;"												+ crlf +
				"</SCRIPT>";

			this.Page.RegisterStartupScript("WBC_setThinEditIEImage",strJSWBC_setThinEditIEImage);
		}

		private void RenderHyperLinkDialogRelatedJavascript()
		{
			string strJScmdCreateLink = "<SCRIPT language=\"javascript\">"												+ crlf +
				"function ICPH_createLink(phName) {"																	+ crlf +
				" var strHref = " + "  document.all[\"ICPH_Href_\" + phName].value;"									+ crlf +
				"   if (strHref == \"\") strHref = \"http://\";"														+ crlf +
				" var strTitle = " + "   document.all[\"ICPH_AltText_\" + phName].value;"								+ crlf +
				" var strTarget = " + "  document.all[\"ICPH_Target_\" + phName].value;"								+ crlf +
				" var strName = \"\";"																					+ crlf +
				""																										+ crlf + 
				" var args = strHref + \";\" + strTitle + \";\" + strTarget + \";\" + strName;"							+ crlf +
				""																										+ crlf + 
				" var strPath = IDS_FRAMEWORK_NEW_VIRTUAL_PATH + \"/Dialogs/HLink/Hlink.aspx\";"						+ crlf +
				""																										+ crlf + 
				" var strDlgRet = window.showModalDialog( strPath, "+
				"args, \"dialogWidth:650px;dialogHeight:350px;status:no;help:no\" );"								+ crlf +
				""																										+ crlf + 
				" if ( typeof(strDlgRet) == \"undefined\" ) " + 
				"      return;"																							+ crlf +
				""																										+ crlf + 
				" if (strDlgRet == \"Cancel\")" +
				"      return;"																							+ crlf +
				""																										+ crlf + 
				" var aAttributes = strDlgRet.split(\";\");"															+ crlf +
				" document.all[\"ICPH_Href_\" + phName].value = aAttributes[0];"										+ crlf +
				" document.all[\"ICPH_AltText_\" + phName].value = aAttributes[1];"										+ crlf +
				" document.all[\"ICPH_Target_\" + phName].value = aAttributes[2];"										+ crlf +
				""																										+ crlf + 
				"}</SCRIPT>";
			this.Page.RegisterClientScriptBlock("ICPH_createLink",strJScmdCreateLink);
		}

//		protected override void OnSavingContent(PlaceholderControlSavingEventArgs e)
//		{
//			FileStream fsLog = null;
//			StreamWriter wLog = null;
//
//			fsLog = new FileStream("c:\\SLG-PH-Log.txt",FileMode.Append,FileAccess.Write);
//			wLog = new StreamWriter(fsLog);
//			wLog.WriteLine("-------------------------------------------------------");
//			wLog.WriteLine("Placeholder Content Saved!");
//			wLog.WriteLine("-------------------------------------------------------");
//
//			wLog.Flush();
//			wLog.Close();
//			fsLog.Close();
//			base.OnSavingContent(e);
//		}

		protected override void LoadPlaceholderContentForAuthoring(PlaceholderControlEventArgs e) 
		{
			HtmlPlaceholder hph = (HtmlPlaceholder) base.BoundPlaceholder;
			string sPhName = this.PlaceholderToBind;
			string html = hph.Html;

			string [] elements = null;
			elements = html.Split('\'');

			// Extract URLs, AltText and Target attribute
			if (elements.Length > 1)
			{
				ImageUrl_out = elements[1];
				ImageUrl_over = elements[3];
				LinkUrl = elements[5];
				AltText = elements[7];
				Target = elements[9];
			}

			// Use LiteralControl to render the client side stuff
			LiteralControl ltCn = new LiteralControl();

			SrcText_out = ImageUrl_out;
			SrcText_over = ImageUrl_over;

			if (SrcText_out == "")
				SrcText_out = Page.Request.ApplicationPath+"/CMS/WebAuthor/Client/PlaceholderControlSupport/Images/InsertImageHere.gif";

			if (SrcText_over == "")
				SrcText_over = Page.Request.ApplicationPath+"/CMS/WebAuthor/Client/PlaceholderControlSupport/Images/InsertImageHere.gif";

			string channelGUID = Page.Request.QueryString["NRCHANNELGUID"];
			if (channelGUID == "")
				channelGUID = "&NRCHANNELGUID="+channelGUID;


			RenderResourceGalleryRelatedJavascript();
			RenderHyperLinkDialogRelatedJavascript();

			string htmlcode = 

				// hidden form fields to hold URL's to the two images
				"<input type=\"hidden\" value=\""+ImageUrl_over+"\" name=\"ICPH_ImgLink_"+sPhName+
					"_over\" placeholderType=\"singleImage\" /><br>"													+ crlf +
				"<input type=\"hidden\" value=\""+ImageUrl_out+"\" name=\"ICPH_ImgLink_"+sPhName+
					"_out\" placeholderType=\"singleImage\" /><br>"														+ crlf +
				
				// table surrounding the authoring time placeholder control child controls
				"<table border=1><tr><td colspan=2>"																	+ crlf +
				"<table><tr><td>"																						+ crlf +

				// image displayed when mouse is out
				"<img name=\"ICPH_Img_"+sPhName+"_out\" src=\""+SrcText_out+"\" width=84 height=84/>"					+ crlf +

				// anchor with action to call the ResourceGallery
				"<a href=\"#\" "																						+ crlf +
					"id=\"ICPH_IconImg_"+sPhName+"_out_Btn\" "															+ crlf +
					"name=\"ICPH_IconImg_"+sPhName+"_out_Btn\" "														+ crlf +
					"target=\"_self\" "																					+ crlf +
					"onclick=\"SG_DestPh='"+sPhName+"_out';"+
						"WBC_launchImageGallery('wbc_purpose=Basic&NRMODE=Unpublished&WBCMODE=PresentationUnpublished&"+
						"FRAMELESS=true"+channelGUID+@"&NRNODEGUID="+Page.Request.QueryString["NRNODEGUID"]+"', '"+
						sPhName+"', 'ThinEditIE', true);"+
						"return false;\">"																				+ crlf +

				"Click to set standard image!</a>"																		+ crlf +
				"</td><td>"																								+ crlf +

				// image displayed when mouse is over
				"<img name=\"ICPH_Img_"+sPhName+"_over\" src=\""+SrcText_over+"\" width=84 height=84/>"					+ crlf +

				// anchor with action to call the ResourceGallery
				"<a href=\"#\" "																						+ crlf +
					"id=\"ICPH_IconImg_"+sPhName+"_over_Btn\" "															+ crlf +
					"name=\"ICPH_IconImg_"+sPhName+"_over_Btn\" "														+ crlf +
					"target=\"_self\" "																					+ crlf +
					"onclick=\"SG_DestPh='"+sPhName+"_over';"+
						"WBC_launchImageGallery('wbc_purpose=Basic&NRMODE=Unpublished&WBCMODE=PresentationUnpublished&"+
						"FRAMELESS=true"+channelGUID+@"&NRNODEGUID="+Page.Request.QueryString["NRNODEGUID"]+@"', '"+
						sPhName+@"', 'ThinEditIE', true);"+
						"return false;\">"																				+ crlf +

				"Click to set mouse-over image!</a>"																	+ crlf +
				"</td></tr></table>"+
				"</td></tr><tr><td>"+

				// controls managing the hyperlink dialog box
				"<center>"																								+ crlf +
					"<INPUT TYPE=BUTTON value=\"Edit Link\nAttributes\" onClick=\"ICPH_createLink('"+sPhName+"')\">"	+ crlf +
				"</center>"																								+ crlf +
				"</td><td><table cellspacing=0 cellpadding=0>"+
				"<tr><td>Link:</td><td width=20></td><td><input size=50 readonly type=\"text\" value=\""+LinkUrl+
					"\" name=\"ICPH_Href_"+sPhName+"\" /></td></tr>"													+ crlf +
				"<tr><td>AltText:</td><td width=20></td><td><input size=50 readonly type=\"text\" value=\""+AltText+
					"\" name=\"ICPH_AltText_"+sPhName+"\" /></td></tr>"													+ crlf +
				"<tr><td>Target:</td><td width=20></td><td><input size=50 readonly type=\"text\" value=\""+Target+
					"\" name=\"ICPH_Target_"+sPhName+"\" /></td></tr>"													+ crlf +
				"</table></td></tr></table>";

			// fill authoring mode control with content
			ltCn.Text=htmlcode;

			EnsureChildControls();
			try 
			{
				baseAuthoringContainer.Controls.Add(ltCn);
			}
			catch (Exception exp) 
			{
				// show the error as placeholder content
				ltCn.Text="<error>" + exp.Message + "</error>";

				baseAuthoringContainer.Controls.Add(ltCn);;
			}
		}

		protected override void LoadPlaceholderContentForPresentation(PlaceholderControlEventArgs e) 
		{
			HtmlPlaceholder hph = (HtmlPlaceholder) base.BoundPlaceholder;
			string sPhName = this.PlaceholderToBind;
			LiteralControl ltCn = new LiteralControl();
			
			string [] elements = null;
			elements = hph.Html.Split('\'');

			// Extract URLs, AltText and Target attribute
			ImageUrl_out = elements[1];
			ImageUrl_over = elements[3];
			LinkUrl = elements[5];
			AltText = elements[7];
			Target = elements[9];

			// Render Javascript to preload images
			string strJSpreload = 
				"<SCRIPT language=\"javascript\">"																		+ crlf +
				"  // preload the Images"																					+ crlf +
				"  "+sPhName+"_image_out = new Image();"																+ crlf +
				"  "+sPhName+"_image_over = new Image();"																+ crlf +
				"  "+sPhName+"_image_out.src = '"+ImageUrl_out+"';"														+ crlf + 
				"  "+sPhName+"_image_over.src = '"+ImageUrl_over+"';"													+ crlf + 
				"</SCRIPT>";
			this.Page.RegisterClientScriptBlock("ICPH_preload_"+sPhName,strJSpreload);


			// render anchor and image tag with mouse over java action.
			ltCn.Text = "";
			if (LinkUrl != "")
				ltCn.Text += "<a href='"+LinkUrl+"' target='"+Target+"'>";
			ltCn.Text += "<img id='ICPH_"+sPhName+"' src='"+ImageUrl_out+"' border=0 alt='"+AltText+"' "+
				"onmouseover=\"document.all['ICPH_"+sPhName+"'].src="+sPhName+"_image_over.src;\" " +
				"onmouseout=\"document.all['ICPH_"+sPhName+"'].src="+sPhName+"_image_out.src;\">";
			if (LinkUrl != "")
				ltCn.Text += "</a>";

			EnsureChildControls();
			try 
			{
				basePresentationContainer.Controls.Add(ltCn);
			}
			catch (Exception exp) 
			{
				// show the error as placeholder content
				ltCn.Text="<error>" + exp.Message + "</error>";

				basePresentationContainer.Controls.Add(ltCn);;
			}
		}

		protected override void SavePlaceholderContent(PlaceholderControlSaveEventArgs e)
		{
			string sPhName = this.PlaceholderToBind;

			EnsureChildControls();

			// collect all data and store in placeholder as img and anchor tags.
			base.SavePlaceholderContent(e);
			HtmlPlaceholder hph = (HtmlPlaceholder) base.BoundPlaceholder;
			string Html = "<img src='"+Page.Request.Form["ICPH_ImgLink_"+sPhName+"_out"]+"'>"+
				"<img src='"+Page.Request.Form["ICPH_ImgLink_"+sPhName+"_over"]+"'>"+
				"<a href='"+Page.Request.Form["ICPH_Href_"+sPhName]+"' title='"+
				            Page.Request.Form["ICPH_AltText_"+sPhName]+"' target='"+
				            Page.Request.Form["ICPH_Target_"+sPhName]+"'>";

			hph.Html = Html;
		}

	}
}
