﻿
//  Copyright (c) Microsoft Corporation.  All Rights Reserved.

using System;
using System.ServiceModel;
using System.Diagnostics;

namespace Microsoft.ServiceModel.Samples
{
    //The service contract is defined in generatedProxy.cs, generated from the service by the svcutil tool.

    //Client implementation code.
    class Client
    {
        static void Main()
        {
			// Create a proxy with given client endpoint configuration
			ICalculator calc;
			ServiceSite mySite = new ServiceSite(new Client());
			calc = ChannelFactory.CreateChannel<ICalculator>("default");

			// Call the Add service operation.
			const int size = 10000;
			double[] value1 = new double[size];
			double[] value2 = new double[size];
			for (int i = 0; i < size; i++)
			{
				value1[i] = i * 2;
				value2[i] = i * 3;
			}
			Stopwatch timer = new Stopwatch();
			double[] result;
			result = calc.Add(value1, value2);
			timer.Start();
			for (int i = 0; i < 100; i++)
				result = calc.Add(value1, value2);
			timer.Stop();
			Console.WriteLine("Time elapsed: " + timer.ElapsedMilliseconds / 100.0);

			Console.WriteLine();
			Console.WriteLine("Press <ENTER> to terminate client.");
			Console.ReadLine();
        }
    }
}
