﻿
//  Copyright (c) Microsoft Corporation.  All Rights Reserved.

using System;
using System.Configuration;
using System.ServiceModel;

namespace Microsoft.ServiceModel.Samples
{
    // Define a service contract.
    [ServiceContract(Namespace="http://Microsoft.ServiceModel.Samples")]
	public interface ICalculator
	{
		[OperationContract]
		double[] Add(double[] n1, double[] n2);
		[OperationContract]
		double[] Subtract(double[] n1, double[] n2);
		[OperationContract]
		double[] Multiply(double[] n1, double[] n2);
		[OperationContract]
		double[] Divide(double[] n1, double[] n2);
	}

    // Service class which implements the service contract.
    // Added code to write output to the console window
	[ServiceBehavior(InstanceMode = InstanceMode.PrivateSession)]
    public class CalculatorService : ICalculator
    {
		public double[] Add(double[] n1, double[] n2)
		{
			//Console.WriteLine("------->Inside Add method");
			double[] result = new double[n1.Length];
			for (int i = 0; i < n1.Length; i++)
				result[i] = n1[i] + n2[i];
			return result;
		}

		public double[] Subtract(double[] n1, double[] n2)
		{
			double[] result = new double[n1.Length];
			for (int i = 0; i < n1.Length; i++)
				result[i] = n1[i] - n2[i];
			return result;
		}

		public double[] Multiply(double[] n1, double[] n2)
		{
			double[] result = new double[n1.Length];
			for (int i = 0; i < n1.Length; i++)
				result[i] = n1[i] * n2[i];
			return result;
		}

		public double[] Divide(double[] n1, double[] n2)
		{
			double[] result = new double[n1.Length];
			for (int i = 0; i < n1.Length; i++)
				result[i] = n1[i] / n2[i];
			return result;
		}

        // Host the service within this EXE console application.
        public static void Main()
        {
            // Get base address from app settings in configuration
            Uri baseAddress = new Uri(ConfigurationManager.AppSettings["baseAddress"]);

            // Create a ServiceHost<T> for the CalculatorService type and provide the base address.
            using (ServiceHost<CalculatorService> serviceHost = new ServiceHost<CalculatorService>(baseAddress))
            {
                // Open the ServiceHost to create listeners and start listening for messages.
                serviceHost.Open();

                // The service can now be accessed.
                Console.WriteLine("The service is ready.");
                Console.WriteLine("Press <ENTER> to terminate service.");
                Console.WriteLine();
                Console.ReadLine();

                // Close the ServiceHost to shutdown the service.
                serviceHost.Close();
            }
        }

    }

}
