﻿
//  Copyright (c) Microsoft Corporation.  All Rights Reserved.

using System;
using System.Runtime.Remoting;
using System.Runtime.Remoting.Activation;
using System.Diagnostics;

namespace Microsoft.ServiceModel.Samples
{
    //Client implementation code.
    class Client
    {
        static void Main()
        {
			CalculatorService calc;
			RemotingConfiguration.Configure("client.exe.config");
			object[] attrs = { new UrlAttribute("tcp://localhost:9001") };
			ObjectHandle handle = (ObjectHandle)Activator.CreateInstance(
				"Service",
				"Microsoft.ServiceModel.Samples.CalculatorService",
				attrs);
			calc = (CalculatorService)handle.Unwrap();

			// Call the Add service operation.
			const int size = 100;
			double[] value1 = new double[size];
			double[] value2 = new double[size];
			for (int i = 0; i < size; i++)
			{
				value1[i] = i * 2;
				value2[i] = i * 3;
			}
			Stopwatch timer = new Stopwatch();
			double[] result;
			result = calc.Add(value1, value2);
			timer.Start();
			for (int i = 0; i < 100; i++)
				result = calc.Add(value1, value2);
			timer.Stop();
			Console.WriteLine("Time elapsed: " + timer.ElapsedMilliseconds / 100.0);

			Console.WriteLine();
			Console.WriteLine("Press <ENTER> to terminate client.");
			Console.ReadLine();
        }
    }
}
