﻿
//  Copyright (c) Microsoft Corporation.  All Rights Reserved.

using System;
using System.Configuration;
using System.Runtime.Remoting;

namespace Microsoft.ServiceModel.Samples
{
	// Define a service contract.
	public interface ICalculator
	{
		double[] Add(double[] n1, double[] n2);
		double[] Subtract(double[] n1, double[] n2);
		double[] Multiply(double[] n1, double[] n2);
		double[] Divide(double[] n1, double[] n2);
	}

	// Service class which implements the service contract.
	// Added code to write output to the console window
	public class CalculatorService : MarshalByRefObject, ICalculator
	{
		public double[] Add(double[] n1, double[] n2)
		{
			//Console.WriteLine("------->Inside Add method");
			double[] result = new double[n1.Length];
			for (int i = 0; i < n1.Length; i++)
				result[i] = n1[i] + n2[i];
			return result;
		}

		public double[] Subtract(double[] n1, double[] n2)
		{
			double[] result = new double[n1.Length];
			for (int i = 0; i < n1.Length; i++)
				result[i] = n1[i] - n2[i];
			return result;
		}

		public double[] Multiply(double[] n1, double[] n2)
		{
			double[] result = new double[n1.Length];
			for (int i = 0; i < n1.Length; i++)
				result[i] = n1[i] * n2[i];
			return result;
		}

		public double[] Divide(double[] n1, double[] n2)
		{
			double[] result = new double[n1.Length];
			for (int i = 0; i < n1.Length; i++)
				result[i] = n1[i] / n2[i];
			return result;
		}

		// Host the service within this EXE console application.
		public static void Main()
		{
			RemotingConfiguration.Configure("service.exe.config");

			// The service can now be accessed.
			Console.WriteLine("The service is ready.");
			Console.WriteLine("Press <ENTER> to terminate service.");
			Console.WriteLine();
			Console.ReadLine();
		}

	}

}
