using System;
using System.Drawing;
using System.Collections;
using System.ComponentModel;
using System.Windows.Forms;
using System.Data;
using Microsoft.Ink;

namespace InkPictureSaveTest
{
	/// <summary>
	/// Summary description for TestForm.
	/// </summary>
	public class TestForm : System.Windows.Forms.Form
	{
		private System.Windows.Forms.Button m_btnSave;
		private System.Windows.Forms.Panel m_panelScroll;
		private Leszynski.Ink.InkToolBar m_inkToolBar;
		private Engworks.Ink.InkPictureEx m_inkPicture;		

		/// <summary>
		/// Required designer variable.
		/// </summary>
		private System.ComponentModel.Container components = null;

		public TestForm()
		{
			//
			// Required for Windows Form Designer support
			//
			InitializeComponent();
			
			// Set up scroll bars
			if (m_inkPicture.Image != null)
                m_panelScroll.AutoScrollMinSize = m_inkPicture.Image.Size;
		}

		/// <summary>
		/// Clean up any resources being used.
		/// </summary>
		protected override void Dispose( bool disposing )
		{
			if( disposing )
			{
				if (components != null) 
				{
					components.Dispose();
				}
			}
			base.Dispose( disposing );
		}

		#region Windows Form Designer generated code
		/// <summary>
		/// Required method for Designer support - do not modify
		/// the contents of this method with the code editor.
		/// </summary>
		private void InitializeComponent()
		{
			System.Resources.ResourceManager resources = new System.Resources.ResourceManager(typeof(TestForm));
			this.m_btnSave = new System.Windows.Forms.Button();
			this.m_panelScroll = new System.Windows.Forms.Panel();
			this.m_inkPicture = new Engworks.Ink.InkPictureEx();
			this.m_inkToolBar = new Leszynski.Ink.InkToolBar();
			this.m_panelScroll.SuspendLayout();
			this.SuspendLayout();
			// 
			// m_btnSave
			// 
			this.m_btnSave.FlatStyle = System.Windows.Forms.FlatStyle.System;
			this.m_btnSave.Location = new System.Drawing.Point(323, 5);
			this.m_btnSave.Name = "m_btnSave";
			this.m_btnSave.TabIndex = 2;
			this.m_btnSave.Text = "Save";
			this.m_btnSave.Click += new System.EventHandler(this.OnSaveButton_Click);
			// 
			// m_panelScroll
			// 
			this.m_panelScroll.AutoScroll = true;
			this.m_panelScroll.Controls.Add(this.m_inkPicture);
			this.m_panelScroll.Dock = System.Windows.Forms.DockStyle.Fill;
			this.m_panelScroll.Location = new System.Drawing.Point(0, 34);
			this.m_panelScroll.Name = "m_panelScroll";
			this.m_panelScroll.Size = new System.Drawing.Size(720, 516);
			this.m_panelScroll.TabIndex = 5;
			// 
			// m_inkPicture
			// 
			this.m_inkPicture.Dock = System.Windows.Forms.DockStyle.Fill;
			this.m_inkPicture.Image = ((System.Drawing.Image)(resources.GetObject("m_inkPicture.Image")));
			this.m_inkPicture.Location = new System.Drawing.Point(0, 0);
			this.m_inkPicture.MarginX = -2147483648;
			this.m_inkPicture.MarginY = -2147483648;
			this.m_inkPicture.Name = "m_inkPicture";
			this.m_inkPicture.Size = new System.Drawing.Size(720, 516);
			this.m_inkPicture.TabIndex = 0;
			// 
			// m_inkToolBar
			// 
			this.m_inkToolBar.ButtonSize = new System.Drawing.Size(31, 30);
			this.m_inkToolBar.InkPictureBinding = this.m_inkPicture;
			this.m_inkToolBar.Location = new System.Drawing.Point(0, 0);
			this.m_inkToolBar.Name = "m_inkToolBar";
			this.m_inkToolBar.Size = new System.Drawing.Size(720, 34);
			this.m_inkToolBar.TabIndex = 6;
			// 
			// TestForm
			// 
			this.AutoScaleBaseSize = new System.Drawing.Size(5, 13);
			this.ClientSize = new System.Drawing.Size(720, 550);
			this.Controls.Add(this.m_btnSave);
			this.Controls.Add(this.m_panelScroll);
			this.Controls.Add(this.m_inkToolBar);
			this.Name = "TestForm";
			this.Text = "InkPicture Save Test";
			this.m_panelScroll.ResumeLayout(false);
			this.ResumeLayout(false);

		}
		#endregion

		/// <summary>
		/// The main entry point for the application.
		/// </summary>
		[STAThread]
		static void Main() 
		{
			Application.Run(new TestForm());
		}

		private void OnSaveButton_Click(object sender, System.EventArgs e)
		{
			using (Image i = m_inkPicture.GenerateCombinedImage())
			{
				i.Save("combined.bmp", System.Drawing.Imaging.ImageFormat.Bmp);
			}			
		}
	}
}
