Imports System
Imports System.Drawing.Drawing2D
Imports System.Windows.Forms
Imports System.Text
Imports System.IO
Imports System.Xml
Imports System.Data.SqlClient


'The Ink namespace containing the Tablet PC Platform API
Imports Microsoft.Ink

Public Class frmMain

    Inherits System.Windows.Forms.Form

    'The one and only ink collector
    Private myInkCollector As InkCollector
    Friend WithEvents mySaveDialog As System.Windows.Forms.SaveFileDialog
    Friend WithEvents myOpenFileDialog As System.Windows.Forms.OpenFileDialog
    Private WithEvents Menubar As System.Windows.Forms.MainMenu



    Protected myDa As SqlDataAdapter
    Protected myCbd As SqlCommandBuilder
    Protected myCmd As SqlCommand
    Protected dsInk As DataSet
    Protected connectionString As String = "Server=localhost;" & _
        "DataBase=Northwind;" & _
        "Integrated Security=SSPI"

#Region " Windows Form Designer generated code "

    Public Sub New()
        MyBase.New()

        'This call is required by the Windows Form Designer.
        InitializeComponent()

        'Add any initialization after the InitializeComponent() call

        'Create the InkCollector and attach it to the signature GroupBox
        myInkCollector = New InkCollector(gbInkArea.Handle)
        myInkCollector.Enabled = True

    End Sub

    'Form overrides dispose to clean up the component list.
    Protected Overloads Overrides Sub Dispose(ByVal disposing As Boolean)
        If disposing Then
            If Not (components Is Nothing) Then
                components.Dispose()
            End If
        End If
        MyBase.Dispose(disposing)
    End Sub

    'Required by the Windows Form Designer
    Private components As System.ComponentModel.IContainer

    'NOTE: The following procedure is required by the Windows Form Designer
    'It can be modified using the Windows Form Designer.  
    'Do not modify it using the code editor.
    Friend WithEvents gbInkArea As System.Windows.Forms.GroupBox
    Friend WithEvents btnSaveDB As System.Windows.Forms.Button
    Friend WithEvents btnSaveFile As System.Windows.Forms.Button
    Friend WithEvents btnExit As System.Windows.Forms.Button
    Friend WithEvents btnOpen As System.Windows.Forms.Button
    Friend WithEvents btnClear As System.Windows.Forms.Button
    Friend WithEvents Label5 As System.Windows.Forms.Label
    Friend WithEvents Label4 As System.Windows.Forms.Label
    Friend WithEvents btnDisplay As System.Windows.Forms.Button
    Friend WithEvents lstInk As System.Windows.Forms.ListBox
    Friend WithEvents Label1 As System.Windows.Forms.Label
    Friend WithEvents btnRefresh As System.Windows.Forms.Button
    Friend WithEvents inkEdFileName As Microsoft.Ink.InkEdit
    <System.Diagnostics.DebuggerStepThrough()> Private Sub InitializeComponent()
        Me.gbInkArea = New System.Windows.Forms.GroupBox()
        Me.btnSaveDB = New System.Windows.Forms.Button()
        Me.btnSaveFile = New System.Windows.Forms.Button()
        Me.btnExit = New System.Windows.Forms.Button()
        Me.btnClear = New System.Windows.Forms.Button()
        Me.btnOpen = New System.Windows.Forms.Button()
        Me.Label5 = New System.Windows.Forms.Label()
        Me.Label4 = New System.Windows.Forms.Label()
        Me.btnDisplay = New System.Windows.Forms.Button()
        Me.lstInk = New System.Windows.Forms.ListBox()
        Me.btnRefresh = New System.Windows.Forms.Button()
        Me.Label1 = New System.Windows.Forms.Label()
        Me.inkEdFileName = New Microsoft.Ink.InkEdit()
        Me.SuspendLayout()
        '
        'gbInkArea
        '
        Me.gbInkArea.Location = New System.Drawing.Point(24, 24)
        Me.gbInkArea.Name = "gbInkArea"
        Me.gbInkArea.Size = New System.Drawing.Size(368, 272)
        Me.gbInkArea.TabIndex = 2
        Me.gbInkArea.TabStop = False
        Me.gbInkArea.Text = "Ink Collection Area"
        '
        'btnSaveDB
        '
        Me.btnSaveDB.BackColor = System.Drawing.SystemColors.InactiveCaptionText
        Me.btnSaveDB.Location = New System.Drawing.Point(640, 320)
        Me.btnSaveDB.Name = "btnSaveDB"
        Me.btnSaveDB.Size = New System.Drawing.Size(104, 23)
        Me.btnSaveDB.TabIndex = 3
        Me.btnSaveDB.Text = "Save in DB"
        '
        'btnSaveFile
        '
        Me.btnSaveFile.Location = New System.Drawing.Point(536, 72)
        Me.btnSaveFile.Name = "btnSaveFile"
        Me.btnSaveFile.Size = New System.Drawing.Size(104, 23)
        Me.btnSaveFile.TabIndex = 4
        Me.btnSaveFile.Text = "Save in File"
        '
        'btnExit
        '
        Me.btnExit.BackColor = System.Drawing.Color.FromArgb(CType(255, Byte), CType(128, Byte), CType(128, Byte))
        Me.btnExit.Location = New System.Drawing.Point(208, 344)
        Me.btnExit.Name = "btnExit"
        Me.btnExit.Size = New System.Drawing.Size(104, 23)
        Me.btnExit.TabIndex = 5
        Me.btnExit.Text = "Exit"
        '
        'btnClear
        '
        Me.btnClear.Location = New System.Drawing.Point(48, 344)
        Me.btnClear.Name = "btnClear"
        Me.btnClear.Size = New System.Drawing.Size(104, 23)
        Me.btnClear.TabIndex = 6
        Me.btnClear.Text = "Clear"
        '
        'btnOpen
        '
        Me.btnOpen.Location = New System.Drawing.Point(408, 72)
        Me.btnOpen.Name = "btnOpen"
        Me.btnOpen.Size = New System.Drawing.Size(104, 23)
        Me.btnOpen.TabIndex = 7
        Me.btnOpen.Text = "Open from File"
        '
        'Label5
        '
        Me.Label5.ImeMode = System.Windows.Forms.ImeMode.NoControl
        Me.Label5.Location = New System.Drawing.Point(408, 176)
        Me.Label5.Name = "Label5"
        Me.Label5.Size = New System.Drawing.Size(295, 48)
        Me.Label5.TabIndex = 13
        Me.Label5.Text = "The listbox contains all of the ink data you have saved to the database. To displ" & _
        "ay saved Ink, select the filename and click the DISPLAY button."
        '
        'Label4
        '
        Me.Label4.Font = New System.Drawing.Font("Microsoft Sans Serif", 9.75!, System.Drawing.FontStyle.Bold)
        Me.Label4.ForeColor = System.Drawing.Color.Black
        Me.Label4.ImeMode = System.Windows.Forms.ImeMode.NoControl
        Me.Label4.Location = New System.Drawing.Point(408, 144)
        Me.Label4.Name = "Label4"
        Me.Label4.Size = New System.Drawing.Size(144, 23)
        Me.Label4.TabIndex = 12
        Me.Label4.Text = "DataBase Ink"
        '
        'btnDisplay
        '
        Me.btnDisplay.BackColor = System.Drawing.SystemColors.InactiveCaptionText
        Me.btnDisplay.ImeMode = System.Windows.Forms.ImeMode.NoControl
        Me.btnDisplay.Location = New System.Drawing.Point(640, 280)
        Me.btnDisplay.Name = "btnDisplay"
        Me.btnDisplay.Size = New System.Drawing.Size(104, 23)
        Me.btnDisplay.TabIndex = 10
        Me.btnDisplay.Text = "&Display"
        '
        'lstInk
        '
        Me.lstInk.Location = New System.Drawing.Point(408, 232)
        Me.lstInk.Name = "lstInk"
        Me.lstInk.Size = New System.Drawing.Size(208, 134)
        Me.lstInk.TabIndex = 9
        '
        'btnRefresh
        '
        Me.btnRefresh.BackColor = System.Drawing.SystemColors.InactiveCaptionText
        Me.btnRefresh.ImeMode = System.Windows.Forms.ImeMode.NoControl
        Me.btnRefresh.Location = New System.Drawing.Point(640, 240)
        Me.btnRefresh.Name = "btnRefresh"
        Me.btnRefresh.Size = New System.Drawing.Size(104, 23)
        Me.btnRefresh.TabIndex = 14
        Me.btnRefresh.Text = "&Refresh List"
        '
        'Label1
        '
        Me.Label1.Font = New System.Drawing.Font("Microsoft Sans Serif", 9.75!, System.Drawing.FontStyle.Bold)
        Me.Label1.ForeColor = System.Drawing.Color.Black
        Me.Label1.ImeMode = System.Windows.Forms.ImeMode.NoControl
        Me.Label1.Location = New System.Drawing.Point(408, 32)
        Me.Label1.Name = "Label1"
        Me.Label1.Size = New System.Drawing.Size(144, 23)
        Me.Label1.TabIndex = 16
        Me.Label1.Text = "File Ink"
        '
        'inkEdFileName
        '
        Me.inkEdFileName.BorderStyle = System.Windows.Forms.BorderStyle.FixedSingle
        Me.inkEdFileName.Cursor = System.Windows.Forms.Cursors.Default
        Me.inkEdFileName.Font = New System.Drawing.Font("Microsoft Sans Serif", 8.25!)
        Me.inkEdFileName.ForeColor = System.Drawing.SystemColors.ActiveCaption
        Me.inkEdFileName.Location = New System.Drawing.Point(24, 304)
        Me.inkEdFileName.Name = "inkEdFileName"
        Me.inkEdFileName.Size = New System.Drawing.Size(320, 32)
        Me.inkEdFileName.TabIndex = 62
        Me.inkEdFileName.Text = ""
        Me.inkEdFileName.UseMouseForInput = True
        '
        'frmMain
        '
        Me.AutoScaleBaseSize = New System.Drawing.Size(5, 13)
        Me.ClientSize = New System.Drawing.Size(784, 398)
        Me.Controls.AddRange(New System.Windows.Forms.Control() {Me.inkEdFileName, Me.btnRefresh, Me.Label5, Me.Label4, Me.btnDisplay, Me.lstInk, Me.btnOpen, Me.btnClear, Me.btnExit, Me.btnSaveFile, Me.btnSaveDB, Me.gbInkArea, Me.Label1})
        Me.Name = "frmMain"
        Me.Text = "My Ink Save  Example"
        Me.ResumeLayout(False)

    End Sub

#End Region






    Private Sub LoadXML(ByVal s As Stream)
        ' This function will load XML into the ink object.
        ' This object will encode our byte data to a UTF8 string
        Dim utf8 As UTF8Encoding = New UTF8Encoding()

        Dim myXD As XmlDocument = New XmlDocument()
        Dim myNodes As XmlNodeList
        Dim loadedInk As Ink = New Ink()

        ' Load the XML data into an XMLDocument object
        myXD.Load(s)

        ' Get the data in the ink node
        myNodes = myXD.GetElementsByTagName("Ink")

        ' load the ink into a new ink object
        ' once an ink object has been "dirtied" it can never load ink again
        If myNodes.Count <> 0 Then

            loadedInk.Load(utf8.GetBytes(myNodes(0).InnerXml))

            ' temporarily disable the ink collector and swap ink objects
            myInkCollector.Enabled = False
            myInkCollector.Ink = loadedInk
            myInkCollector.Enabled = True

            ' Repaint the inkable region
            gbInkArea.Invalidate()

        End If
    End Sub


    Private Sub LoadISF(ByVal s As Stream)

        'Load ISF into the ink object 
        Dim LoadedInk As Ink = New Ink()
        Dim isfBytes() As Byte = New Byte() {0}
        ReDim isfBytes(s.Length)

        ' read in the ISF
        s.Read(isfBytes, 0, CInt(s.Length))

        ' Load the ink into a new ink object
        ' Once an ink object has been "dirtied" it can never load ink again
        LoadedInk.Load(isfBytes)

        ' temporarily disable the ink collector and swap ink objects
        myInkCollector.Enabled = False
        myInkCollector.Ink = LoadedInk
        myInkCollector.Enabled = True

        ' Repaint the inkable region
        gbInkArea.Invalidate()

    End Sub



    '------------------------
    ' Button Events
    '------------------------

    Private Sub btnSaveFile_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles btnSaveFile.Click
        'It allows the user to specify a filename, location, and type of format to save as.

        'Create a stream which will be used to save data to the output file
        Dim myStream As Stream

        'Create the SaveFileDialog, and present to the user
        Dim mySaveDialog As SaveFileDialog = New SaveFileDialog()

        'Set the filter to suggest our recommended extensions
        mySaveDialog.Filter = "Ink Serialized Format files (*.isf)|*.isf|XML files (*.xml)|*.xml|" & _
                              "HTML files (*.htm)|*.htm"

        'If the dialog exits and the user didn't choose Cancel
        If mySaveDialog.ShowDialog = DialogResult.OK Then


            '(the try...catch section in this function handles the errors  for the helper methods called.)
            Try
                'Attempt to Open the file with read/write permission
                myStream = mySaveDialog.OpenFile()
                If Not myStream Is Nothing Then

                    'Change the filename to Lower Case
                    Dim filename As String = mySaveDialog.FileName.ToLower()

                    'Get a version of the filename without an extension
                    'This will be used for saving the associated Ink Data
                    Dim extensionlessFilename As String = Path.GetFileNameWithoutExtension(filename)

                    'Get the extension of the file 
                    Dim extension As String = Path.GetExtension(filename)

                    'Use the extension to determine what form to save the data in
                    Select Case extension
                        Case ".xml"
                            SaveXML(myStream)
                        Case ".htm", ".html"
                            'The two HTML cases require a filename for saving associated images
                            SaveHTML(myStream, extensionlessFilename)
                        Case Else
                            'If unfamiliar with the extension, use ISF, the most "native format"
                            SaveISF(myStream)
                    End Select
                Else
                    'Throw an exception if a null pointer is returned for the stream
                    Throw New IOException()
                End If
            Catch excpt As IOException
                MessageBox.Show("File error")
            Finally
                'Close the stream in the finally clause so it
                'is always reached, regardless of whether an 
                'exception occurs.  SaveXML, SaveHTML, and
                'SaveISF can throw, so this precaution is necessary.
                If Not myStream Is Nothing Then
                    myStream.Close()
                End If
            End Try

        End If 'End if user chose OK from dialog 

    End Sub

    Private Sub btnExit_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles btnExit.Click
        myInkCollector.Enabled = False
        inkEdFileName.Enabled = False
        Me.Dispose()
    End Sub

    Private Sub btnClear_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles btnClear.Click
        'Erase the ink
        myInkCollector.Ink.DeleteStrokes()
        inkEdFileName.Text = ""
        gbInkArea.Invalidate()
        inkEdFileName.Invalidate()
    End Sub

    Private Sub btnOpen_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles btnOpen.Click
        ' Create a stream which will be used to load data from the output file
        Dim myStream As Stream

        myOpenFileDialog = New OpenFileDialog()
        ' Set the filter to suggest our recommended extensions
        myOpenFileDialog.Filter = "All Known Files (*.isf;*.xml)|*.isf;*.xml|Ink Serialized Format files (*.isf)|*.isf| XML files (*.xml)|*.xml|All Files (*.*)|*.*"

        ' If the dialog exits and the user didn't choose Cancel
        If myOpenFileDialog.ShowDialog() = DialogResult.OK Then
            Try
                ' Attempt to Open the file with read only permission
                myStream = myOpenFileDialog.OpenFile()
                If Not myStream Is Nothing Then
                    ' Just a readability move
                    Dim filename As String = myOpenFileDialog.FileName.ToLower()
                    ' Get the extension of the file 
                    Dim extension As String = filename.Substring(filename.LastIndexOf("."))

                    ' Use the extension to determine what form to save the data in
                    Select Case extension
                        Case ".isf"
                            LoadISF(myStream)
                        Case ".xml"
                            LoadXML(myStream)
                        Case Else
                            'If unfamiliar with the extension, assume ISF, the most "native format"
                            LoadISF(myStream)
                    End Select
                    inkEdFileName.Text = filename
                    'repaint the inkEdit area
                    inkEdFileName.Invalidate()
                Else
                    'Throw an exception if a null pointer is returned for the stream
                    Throw New IOException()
                End If
            Catch excpt As IOException
                MessageBox.Show("File error")
            Catch
                'Display an error and exit
                MessageBox.Show("An error occured while loading ink from the specified file. Please verify that the file contains valid serialized ink and try again.", "Serialization", MessageBoxButtons.OK)
            Finally
                ' Close the stream in the finally clause so it
                ' is always reached, regardless of whether an 
                ' exception occurs.  LoadXML, LoadHTML, and
                ' LoadISF can throw, so this precaution is necessary.
                If Not myStream Is Nothing Then
                    myStream.Close()
                End If
            End Try
        End If
    End Sub


    Private Sub btnSaveDB_Click(ByVal sender As System.Object, _
                 ByVal e As System.EventArgs) Handles btnSaveDB.Click

        ' The SQL Server Image datatype is a binary datatype. 
        ' To save it to the database we must convert the ink 
        ' to an array of bytes. We will use
        ' MemoryStream with the inkCollector.Ink.Save method.
        Dim Filename As String
        Dim isf As Byte()

        If inkEdFileName.Text.Length = 0 Then
            MessageBox.Show("You must enter a file name.", _
                                        "Missing File Name", _
                                        MessageBoxButtons.OK, _
                                        MessageBoxIcon.Error)
        Else
            ' Perform the serialization
            isf = _
            myInkCollector.Ink.Save(PersistenceFormat.InkSerializedFormat)

            'append the .ink extension to denote .INK data
            inkEdFileName.Text = Trim(inkEdFileName.Text) & ".ink"
            Filename = inkEdFileName.Text

            Dim isConnecting As Boolean = True
            While isConnecting
                Try

                    Dim northwindConnection As _
                         New SqlConnection(connectionString)
                    Dim strSQL As String = _
                        "INSERT INTO Picture (Filename, Picture)" & _
                        "VALUES (@Filename, @Picture)"

                    myCmd = New SqlCommand(strSQL, northwindConnection)

                    With myCmd
                        ' Add parameters required by SQL statement. 
                        'PictureID is an 
                        ' identity field  so only pass values for 
                        'the two remaining fields.
                        .Parameters.Add(New SqlParameter _
                           ("@Filename", SqlDbType.NVarChar, 50)).Value _
                           = Filename

                        .Parameters.Add(New SqlParameter("@Picture", SqlDbType.Image)).Value = isf
                    End With

                    ' Open the connection, execute the command, 
                    'and close the connection. 
                    northwindConnection.Open()
                    myCmd.ExecuteNonQuery()
                    northwindConnection.Close()

                    ' Data has been successfully submitted, 
                    'so break out of the loop
                    isConnecting = False

                    MessageBox.Show(Filename & " saved to the database.", _
                        "Ink Save Status", MessageBoxButtons.OK, _
                        MessageBoxIcon.Information)

                Catch sqlExc As SqlException
                    MessageBox.Show(sqlExc.ToString, _
                        "SQL Exception Error!", _
                        MessageBoxButtons.OK, MessageBoxIcon.Error)
                    Exit While
                Catch exc As Exception
                    ' Unable to connect to SQL Server
                    MessageBox.Show("Error connecting to Database.", _
                        "Connection Failed!", _
                        MessageBoxButtons.OK, MessageBoxIcon.Error)
                End Try
            End While
        End If
    End Sub



    Sub SaveISF(ByRef s As Stream)
        ' This function saves the form in ISF format.
        Dim isf As Byte()

        ' Perform the serialization
        isf = myInkCollector.Ink.Save(PersistenceFormat.InkSerializedFormat)

        ' Write the ISF to the stream
        s.Write(isf, 0, isf.Length)
    End Sub


    Sub SaveXML(ByRef s As Stream)
        ' This function saves the form in XML format.
        ' It uses the base64 encoded version of the ink, which is most suitable
        ' for representation in XML. 

        ' This object will encode our byte data to a UTF8 string
        Dim utf8 As UTF8Encoding = New UTF8Encoding()
        Dim base64ISF_bytes As Byte()
        Dim base64ISF_string As String

        ' Create a new XmlTextWriter.
        Dim myXWriter As XmlTextWriter = New XmlTextWriter(s, System.Text.Encoding.UTF8)

        ' Write the beginning of the document including the document declaration. 
        myXWriter.WriteStartDocument()

        ' Write the beginning of the "data" element. This is the opening tag to our data 
        myXWriter.WriteStartElement("SerializationSampleData")

        ' Get the base64 encoded ISF
        base64ISF_bytes = myInkCollector.Ink.Save(PersistenceFormat.Base64InkSerializedFormat)

        ' Convert it to a String
        base64ISF_string = utf8.GetString(base64ISF_bytes)

        ' Write the ISF containing node to the XML
        myXWriter.WriteElementString("Ink", base64ISF_string)

        'End the "data" element.
        myXWriter.WriteEndElement()

        'End the document
        myXWriter.WriteEndDocument()

        'Close the xml document.
        myXWriter.Close()
    End Sub


    Sub SaveHTML(ByRef s As Stream, ByVal nameBase As String)
        ' This function saves the form in HTML format.
        ' It also creates an ink fortified GIF which is referenced by the HTML.

        ' It is not possible to save an empty .gif, so ensure that the ink 
        ' has a bounding box (i.e. the ink is not empty).  
        ' Use bounding box  for this check instead of checking if the stroke
        ' count is zero, since the ink could still be empty if the 
        ' strokes don't contain any points.
        If (myInkCollector.Ink.Strokes.GetBoundingBox().IsEmpty) Then
            MessageBox.Show("Unable to save empty ink in HTML persistence format.")
        Else

            Dim gifFile As FileStream
            Dim fortifiedGif As Byte()
            Dim html As String
            Dim htmlBytes As Byte()

            ' This object will encode our byte data to a UTF8 string
            Dim utf8 As UTF8Encoding = New UTF8Encoding()

            ' Create a directory to store the fortified GIF which also contains ISF
            ' and open the file for writing
            Directory.CreateDirectory(nameBase + "_files")
            gifFile = File.OpenWrite(nameBase + "_files\\myInk.gif")

            ' Generate the fortified GIF represenation of the ink
            fortifiedGif = myInkCollector.Ink.Save(PersistenceFormat.Gif)

            ' Write and close the gif file
            gifFile.Write(fortifiedGif, 0, fortifiedGif.Length)
            gifFile.Close()

            ' Create the HTML output
            ' Note that the names are stored in HTML tags, rather
            ' than custom properties, so that these properties can 
            ' be easily retrieved from the HTML.
            html = _
                "<HTML><HEAD></HEAD><BODY>" & _
                "<P>Ink Save Test: " & nameBase & "</P>" & _
                "<P><IMG src='" & _
                nameBase + "_files\\myInk.gif" & _
                "'/IMG></P>" & _
                "</BODY></HTML>"

            ' Convert the HTML to a byte array for writing to the stream
            htmlBytes = utf8.GetBytes(html)

            ' Write the HTML to the stream
            s.Write(htmlBytes, 0, htmlBytes.Length)
        End If
    End Sub


    Private Sub btnDisplay_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles btnDisplay.Click

        ' Handles the Display button click event, allowing the user to display an image 
        ' stored in the database.

        ' When nothing is selected in the ListBox, the SelectedIndex = -1.
        If lstInk.SelectedIndex < 0 Then
            MessageBox.Show("There are no ink selections in the database to display.", _
                "Empty Database!", MessageBoxButtons.OK, MessageBoxIcon.Information)
        Else
            ' The SQL Server Image datatype is a binary datatype. Therefore, to 
            ' generate ink from it, you must first create a stream object 
            ' containing the binary data. 
            Dim arrInk() As Byte = CType(dsInk.Tables(0).Rows(lstInk.SelectedIndex)("Picture"), Byte())
            Dim myStream As New MemoryStream(arrInk)

            Try
                LoadISF(myStream)
                inkEdFileName.Text = dsInk.Tables(0).Rows(lstInk.SelectedIndex)("FileName").ToString
            Catch
                'Display an error and exit
                MessageBox.Show("An error occured while loading ink. Please verify the data selected contains valid serialized ink and try again.", "Serialization", MessageBoxButtons.OK)
            Finally
                ' Close the stream object to release the resource.
                If Not myStream Is Nothing Then
                    myStream.Close()
                End If
            End Try
        End If
    End Sub



    Private Sub btnRefresh_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles btnRefresh.Click
        ' Create DataSet and bind to a ListBox control 

        Dim isConnecting As Boolean = True
        While isConnecting
            ' Attempt to connect to the local SQL server instance (with Northwind).  

            Try

                Dim northwindConnection As New SqlConnection(connectionString)

                ' A SqlCommand object is used to execute the SQL commands.
                myCmd = New SqlCommand("SELECT * " & _
                                          "FROM Picture", _
                                          northwindConnection)

                ' The SqlDataAdapter is responsible for filling a DataSet.
                myDa = New SqlDataAdapter(myCmd)


                ' Normally, TheSqlCommandBuilder will be used for handling other 
                'operations on  the picture table in the databse
                myCbd = New SqlCommandBuilder(myDa)

                dsInk = New DataSet()
                myDa.Fill(dsInk)

                ' Data has been successfully retrieved, so break out of the loop
                isConnecting = False

                ' Display the filenames of the pictures in the DataSet.
                With lstInk
                    .DataSource = dsInk.Tables(0)
                    .DisplayMember = "FileName"
                End With

            Catch sqlExc As SqlException
                MessageBox.Show(sqlExc.ToString, "SQL Exception Error!", _
                        MessageBoxButtons.OK, MessageBoxIcon.Error)
                Exit While

            Catch exc As Exception
                MessageBox.Show("Error Connecting to DataBase.", "Connection Failed!", MessageBoxButtons.OK, _
                       MessageBoxIcon.Error)
            End Try
        End While
    End Sub


    Private Sub frmMain_Load(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles MyBase.Load

    End Sub
End Class