/* LightFTPServer.Authentication
 * Author: joel@collude.com.au
 * Date: 17/11/2003
 * Description: 
 *	This is the authentication class. It uses an xml called ``config.xml'' to resolve the authentication of the user
 *	about to log in. One could see this class becoming an interface and getting the FTP server to load an 
 *	authentication assembly at runtime based on user input. 
 */


using System;
using System.Xml;

namespace LightFTPServer
{
	public class Authentication
	{
		private string username;
		private string homeDirectory;
		private bool restrictHome;

		private Authentication(string username, string homedirectory, bool restrictHome)
		{
			this.username = username;
			this.homeDirectory = homedirectory;
			this.restrictHome = restrictHome;
		}

		public string HomeDirectory 
		{
			get
			{
				return homeDirectory;
			}
		}

		public string Username 
		{
			get
			{
				return username;
			}
		}

		public bool RestrictHomeDirectory
		{
			get
			{
				return restrictHome;
			}
		}

		public static Authentication Authenticate(string username, string password)
		{
			XmlDocument doc = new XmlDocument();
			doc.Load("config.xml");

			foreach (XmlNode node in doc.SelectNodes("/lightftpserver/ftpusers//user"))
			{
				if ((node.SelectSingleNode("name").InnerText == username) && (node.SelectSingleNode("password").InnerText == password) && (node.SelectSingleNode("activated").InnerText == "true"))
				{
					XmlNode restrictHomeNode = node.SelectSingleNode("restricthome");
					bool restrict = false;
					if (restrictHomeNode!=null)
						restrict = bool.Parse(restrictHomeNode.InnerText);
					return new Authentication(username, node.SelectSingleNode("home").InnerText, restrict);
				}
			}
			return null;
		}

	}
}
