using System;

namespace LightFTPServer
{
	public class ConsoleLog : LightFTPServerLogInterface.LogOutput
	{
		public ConsoleLog()
		{
		}

		public void WriteLogOutput(string uid, string logoutput)
		{
			Console.WriteLine(uid + ":" + System.DateTime.Now.ToString() + ":\t" + logoutput);			
		}

		public void WriteLogOutput(string uid, byte[] streamoutput)
		{
			Console.WriteLine(System.Text.Encoding.ASCII.GetString(streamoutput));
		}		

		public void WriteLine(string output)
		{
			Console.WriteLine(output);
		}

		public void DebugWriteLine(string output)
		{
			Console.WriteLine(">>>>>>>>>>");
			Console.WriteLine(output);
			Console.WriteLine(">>>>>>>>>>");
		}
	
		public void Flush()
		{
			return;
		}

		public void Close()
		{
			return;
		}
	}
}
