/* LightFTPServer.Listener
 * Author: joel@collude.com.au
 * Date: 17/11/2003
 * Description: 
 *	This class takes care of the initial connections from the outside world. It binds to the externally visible
 *	network interface. Be careful when you connect to ``localhost'' as it may not work. 
 */

using System;
using System.Threading;
using System.IO;
using System.Net;
using System.Net.Sockets;
using System.Collections;
using System.Diagnostics;
using System.Reflection;

namespace LightFTPServer
{
	class Listener
	{
		protected TcpListener serverListener;
		protected int port;
		ArrayList clients;

		LightFTPServerLogInterface.LogOutput logOutput;

		private static int listenCounter = 0;
		
		public Listener(int port, LightFTPServerLogInterface.LogOutput logAssembly)
		{
			this.port = port;
			this.logOutput = logAssembly;
			clients = new ArrayList();
		}

		public void StartListen()
		{
			try
			{
				serverListener = new TcpListener(Dns.GetHostByName(Dns.GetHostName()).AddressList[0],port);
				serverListener.Start();
				logOutput.WriteLine("Light FTP starting on port " + port.ToString());

				do
				{
					TcpClient client = serverListener.AcceptTcpClient();
					Console.WriteLine("Connection accepted.");

					// add the new client
					FTPServerControl control = new FTPServerControl(client, logOutput);
					Thread clientThread = new Thread(new ThreadStart(control.StartProcessing));
					clientThread.Start();
					// TODO: well, we don't have a mechanism to remove the user from this ArrayList, the GC wont collect this
					// Need to develop a mechanism to track and dispose of user threads. I suspect it'll be a
					// event/delegate scenario, when we hit QuitAndKillThread. I'll take a look at this later.
					clients.Add(clientThread);
				}
				while (true);
			}
			catch (System.Net.Sockets.SocketException ex)
			{
#if DEBUG
				logOutput.DebugWriteLine(ex.Message);
#endif
				logOutput.WriteLine("Unable to attach to socket, it is currently in use");
				Environment.Exit(1);
			}
			catch (Exception ex)
			{
				Debug.WriteLine(ex.Message);

				if (listenCounter>4)
				{
					logOutput.WriteLine("Unable to listen to incomming connections, trying again...");
					Thread.Sleep(5000);
					StartListen();
				}
				else
				{
					logOutput.WriteLine("Unable to listen. Stopping.");
				}
			}
		}


		[STAThread]
		static void Main(string[] args)
		{
			LightFTPServerLogInterface.LogOutput logOutput = null;
			string loggingAssembly = "";
			if (args.Length>0)
				loggingAssembly = args[0];

			// figure out the way we're going to talk to the outside world
			if (!(loggingAssembly==null) && !(loggingAssembly.Length==0))
			{
				try
				{
					Assembly loggingasm = Assembly.LoadFrom(loggingAssembly);
					foreach (Type t in loggingasm.GetTypes())
					{
						if (t.GetInterface("LightFTPServerLogInterface.LogOutput")!=null)
						{
							logOutput = (LightFTPServerLogInterface.LogOutput) System.Activator.CreateInstance(t, null);
							break;
						}
					}

					if (logOutput==null)
						logOutput = new ConsoleLog();
				}
				catch (Exception ex)
				{
					// loading failed, so we direct the log output to null
					logOutput = new ConsoleLog();
				}
			}
			else
			{
				// we're not going to talk to the outside world.
				logOutput = new ConsoleLog();
			}

			// start the FTP server
			Listener listen = new Listener(21, logOutput);
			listen.StartListen();
		}
	}
}
