/**
 * @file CmsAuthendicationType.cs
 *
 * MCMS Manager
 *
 * MCMS Manager is the legal property of its developer
 * Chester Ragel <chesterr@gmail.com> - Developer and Maintainer
 * Yahoo ID : chesterr1979 
 * MSN : chesterr79@hotmail.com
 *
 * If you want more information, found any bugs or have any doubts you 
 * can mail me or contact me through my yahoo id.
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2.1 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#region Namespaces
using System;
#endregion

namespace MCMS
{
	/// <summary>
	/// Summary description for CmsAuthendicationType.
	/// </summary>
	
	#region Common
	public enum CmsAuthenticationType
	{
		AuthenticateAsCurrentUser = 1,
		AuthenticateAsUser = 2,
		AuthenticateUsingUserHandle = 3
	}

	public enum CmsScriptType
	{
		ServerSide = 1,
		ClientSide = 2
	}
	#endregion

	#region Export
	public enum ExportIncludeCreatedBy
	{
		CMS_EXPORT_NOT_INCLUDE_CREATED_BY_USER=1,
		CMS_EXPORT_INCLUDE_CREATED_BY_USER=2
	}

	public enum ExportIncludeRightsGroups
	{
		CMS_EXPORT_RIGHTS_GROUPS_NONE  = 1,
		CMS_EXPORT_RIGHTS_GROUP_WITHOUT_MEMBERS = 2,
		CMS_EXPORT_RIGHTS_GROUP_WITH_MEMBERS = 3
	}
	#endregion

	#region Import
	public enum ImportIncludeCreatedBy
	{
		CMS_IMPORT_CREATED_BY_CURRENT_USER = 1,
		CMS_IMPORT_CREATED_BY_USE_PACKAGE = 2
	}

	public enum ImportIncludeRightsGroups
	{
		CMS_IMPORT_RIGHTS_GROUPS_NONE = 1,
		CMS_IMPORT_RIGHTS_GROUP_WITHOUT_MEMBERS = 2,
		CMS_IMPORT_RIGHTS_GROUP_USE_PACKAGE_MEMBERS = 3
	}

	public enum ImportRightsOnAdd
	{
		CMS_IMPORT_RIGHTS_ON_ADD_NO_RIGHTS = 1,
		CMS_IMPORT_RIGHTS_ON_ADD_INHERIT_FROM_PARENT = 2,
		CMS_IMPORT_RIGHTS_ON_ADD_USE_PACKAGE = 3
	}

	public enum ImportRightsOnReplace
	{
		CMS_IMPORT_RIGHTS_ON_REPLACE_KEEP_EXISTING = 1,
		CMS_IMPORT_RIGHTS_ON_REPLACE_USE_PACKAGE = 2
	}
	#endregion
	
}
