/**
 * @file CmsExport.cs
 *
 * MCMS Manager
 *
 * MCMS Manager is the legal property of its developer
 * Chester Ragel <chesterr@gmail.com> - Developer and Maintainer
 * Yahoo ID : chesterr1979 
 * MSN : chesterr79@hotmail.com
 *
 * If you want more information, found any bugs or have any doubts you 
 * can mail me or contact me through my yahoo id.
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2.1 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#region Namespaces
using System;
using System.Collections;
using System.Data;
//MCMS components
using Microsoft.ContentManagement.Common;
using Microsoft.ContentManagement.Publishing;
#endregion

namespace MCMS
{
	/// <summary>
	/// Summary description for CmsExport.
	/// </summary>
	public class CmsExport
	{

		#region Private Variables
		private CmsAuthenticationType authenticationType;
		private CmsScriptType scriptType;
		private ExportIncludeCreatedBy includeCreatedBy;
		private ExportIncludeRightsGroups includeRightsGroups;
		private string sdoFile;
		private string sdoArchive;
		private string reportPath;
		private string containerGuid;
		private string serverUrl;
		private int timeInterval;
		private string userName;
		private string password;
		private string script;
		#endregion

		#region Constructor
		public CmsExport()
		{
			authenticationType = CmsAuthenticationType.AuthenticateAsCurrentUser;
			scriptType = CmsScriptType.ServerSide;
			includeCreatedBy = ExportIncludeCreatedBy.CMS_EXPORT_NOT_INCLUDE_CREATED_BY_USER;
			includeRightsGroups = ExportIncludeRightsGroups.CMS_EXPORT_RIGHTS_GROUPS_NONE;
			timeInterval = 0;
			serverUrl = FormMCMSManager.serverName;
		}
		#endregion

		#region Properties

		public int TimeInterval
		{
			get
			{
				return timeInterval;
			}
			set
			{
				timeInterval = value;
			}
		}

		public string UserName
		{
			get
			{
				return userName;
			}
			set
			{
				userName = value;
			}
		}

		public string ScriptFile
		{
			get
			{
				return script;
			}
			set
			{
				script = value;
			}
		}

		public string Password
		{
			get
			{
				return password;
			}
			set
			{
				password = value;
			}
		}

		public string SDOFilePath
		{
			get
			{
				return sdoFile;
			}
			set
			{
				sdoFile = value;
			}
		}

		public string ContainerGuid
		{
			get
			{
				return containerGuid;
			}
			set
			{
				containerGuid = value;
			}
		}

		public string ServerUrl
		{
			get
			{
				return serverUrl;
			}
			set
			{
				serverUrl = value;
			}
		}

		public string ReportFilePath
		{
			get
			{
				return reportPath;
			}
			set
			{
				reportPath = value;
			}
		}

		public string SDOArchivePath
		{
			get
			{
				return sdoArchive;
			}
			set
			{
				sdoArchive = value;
			}
		}

		public CmsAuthenticationType AuthenticationType
		{
			get
			{
				return authenticationType;
			}
			set
			{
				authenticationType = value;
			}
		}

		public CmsScriptType ScriptType
		{
			get
			{
				return scriptType;
			}
			set
			{
				scriptType = value;
			}
		}

		public ExportIncludeCreatedBy CreatedBy
		{
			get
			{
				return includeCreatedBy;
			}
			set
			{
				includeCreatedBy = value;
			}
		}

		public ExportIncludeRightsGroups RightsGroups
		{
			get
			{
				return includeRightsGroups;
			}
			set
			{
				includeRightsGroups = value;
			}
		}
		#endregion

	}
}
