/**
 * @file CmsImport.cs
 *
 * MCMS Manager
 *
 * MCMS Manager is the legal property of its developer
 * Chester Ragel <chesterr@gmail.com> - Developer and Maintainer
 * Yahoo ID : chesterr1979 
 * MSN : chesterr79@hotmail.com
 *
 * If you want more information, found any bugs or have any doubts you 
 * can mail me or contact me through my yahoo id.
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2.1 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#region Namespaces
using System;
using System.Collections;
using System.Data;
//MCMS components
using Microsoft.ContentManagement.Common;
using Microsoft.ContentManagement.Publishing;
#endregion

namespace MCMS
{
	/// <summary>
	/// Summary description for CmsImport.
	/// </summary>
	public class CmsImport
	{

		#region Private Variables
		private CmsAuthenticationType authenticationType;
		private CmsScriptType scriptType;
		private ImportIncludeCreatedBy includeCreatedBy;
		private ImportIncludeRightsGroups includeRightsGroups;
		private ImportRightsOnAdd rightsOnAdd;
		private ImportRightsOnReplace rightsOnReplace;
		private string sdoFile;
		private string reportPath;
		private string serverUrl;
		private string userName;
		private string password;
		private string script;
		#endregion

		#region Constructor
		public CmsImport()
		{
			authenticationType = CmsAuthenticationType.AuthenticateAsCurrentUser;
			scriptType = CmsScriptType.ServerSide;
			includeCreatedBy = ImportIncludeCreatedBy.CMS_IMPORT_CREATED_BY_CURRENT_USER;
			includeRightsGroups = ImportIncludeRightsGroups.CMS_IMPORT_RIGHTS_GROUP_WITHOUT_MEMBERS;
			rightsOnAdd = ImportRightsOnAdd.CMS_IMPORT_RIGHTS_ON_ADD_NO_RIGHTS;
			rightsOnReplace = ImportRightsOnReplace.CMS_IMPORT_RIGHTS_ON_REPLACE_USE_PACKAGE;
			serverUrl = FormMCMSManager.serverName;
		}
		#endregion

		#region Properties

		public string UserName
		{
			get
			{
				return userName;
			}
			set
			{
				userName = value;
			}
		}

		public string Password
		{
			get
			{
				return password;
			}
			set
			{
				password = value;
			}
		}

		public string ScriptFile
		{
			get
			{
				return script;
			}
			set
			{
				script = value;
			}
		}

		public string SDOFilePath
		{
			get
			{
				return sdoFile;
			}
			set
			{
				sdoFile = value;
			}
		}

		public string ServerUrl
		{
			get
			{
				return serverUrl;
			}
			set
			{
				serverUrl = value;
			}
		}

		public string ReportFilePath
		{
			get
			{
				return reportPath;
			}
			set
			{
				reportPath = value;
			}
		}

		public ImportRightsOnAdd RightsOnAdd
		{
			get
			{
				return rightsOnAdd;
			}
			set
			{
				rightsOnAdd = value;
			}
		}

		public CmsAuthenticationType AuthenticationType
		{
			get
			{
				return authenticationType;
			}
			set
			{
				authenticationType = value;
			}
		}

		public CmsScriptType ScriptType
		{
			get
			{
				return scriptType;
			}
			set
			{
				scriptType = value;
			}
		}

		public ImportIncludeCreatedBy CreatedBy
		{
			get
			{
				return includeCreatedBy;
			}
			set
			{
				includeCreatedBy = value;
			}
		}

		public ImportIncludeRightsGroups RightsGroups
		{
			get
			{
				return includeRightsGroups;
			}
			set
			{
				includeRightsGroups = value;
			}
		}

		public ImportRightsOnReplace RightsOnReplace
		{
			get
			{
				return rightsOnReplace;
			}
			set
			{
				rightsOnReplace = value;
			}
		}
		#endregion

	}
}
