/**
 * @file CmsPosting.cs
 *
 * MCMS Manager
 *
 * MCMS Manager is the legal property of its developer
 * Chester Ragel <chesterr@gmail.com> - Developer and Maintainer
 * Yahoo ID : chesterr1979 
 * MSN : chesterr79@hotmail.com
 *
 * If you want more information, found any bugs or have any doubts you 
 * can mail me or contact me through my yahoo id.
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2.1 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#region Namespaces
using System;
using Microsoft.ContentManagement.Publishing;
#endregion

namespace MCMS
{
	/// <summary>
	/// Custom Cms posting with other log information
	/// </summary>
	public class CmsPosting
	{

		#region Private Variables
		private string _name; 
		private int[] _hitCount;
		private int _totalHit = 0;
		private string _guid;
		private string _channelName;
		private PostingState _cmsPostingState;
		private DateTime _createdOn;
		private DateTime _expiredOn;
		private string[] _accessedBy;
		private string[] _accessedFrom;
		private string[] _accessedOnDate;
		private string[] _accessedOnTime;
		#endregion

		#region Public Methods

		public string Name
		{
			get
			{
				return _name;
			}
			set
			{
				_name=value;
			}
		}

		public DateTime CreatedOn
		{
			get
			{
				return _createdOn;
			}
			set
			{
				_createdOn = value;
			}
		}

		public DateTime ExpiredOn
		{
			get
			{
				return _expiredOn;
			}
			set
			{
				_expiredOn = value;
			}
		}

		public string[] AccessedBy
		{
			get
			{
				return _accessedBy;
			}
			set
			{
				_accessedBy = value;
			}
		}

		public string[] AccessedFrom
		{
			get
			{
				return _accessedFrom;
			}
			set
			{
				_accessedFrom = value;
			}
		}

		public string[] AccessedOnDate
		{
			get
			{
				return _accessedOnDate;
			}
			set
			{
				_accessedOnDate = value;
			}
		}

		public string[] AccessedOnTime
		{
			get
			{
				return _accessedOnTime;
			}
			set
			{
				_accessedOnTime = value;
			}
		}

		public string ChannelName
		{
			get
			{
				return _channelName;
			}
			set
			{
				_channelName = value;
			}
		}

		public PostingState CmsPostingState 
		{
			get
			{
				return _cmsPostingState;
			}
			set
			{
				_cmsPostingState = value;
			}
		}

		public string Guid
		{
			get
			{
				return _guid;
			}
			set
			{
				_guid = value;
			}
		}

		public int[] HitCount
		{
			get
			{
				return _hitCount;
			}
			set
			{
				_hitCount = value;
			}
		}

		public int TotalHit
		{
			get
			{
				_totalHit = 0;
				for(int i=0;i<_hitCount.Length;i++)
				{
					_totalHit += _hitCount[i];
				}
				return _totalHit;
			}
		}
		#endregion

		#region Constructor
		public CmsPosting()
		{
		}
		#endregion

	}
}
