/**
 * @file DirtyPlaceholder.cs
 *
 * MCMS Manager
 *
 * MCMS Manager is the legal property of its developer
 * Chester Ragel <chesterr@gmail.com> - Developer and Maintainer
 * Yahoo ID : chesterr1979 
 * MSN : chesterr79@hotmail.com
 *
 * If you want more information, found any bugs or have any doubts you 
 * can mail me or contact me through my yahoo id.
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2.1 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#region Name Space
using System;
#endregion

namespace MCMS
{
	/// <summary>
	/// This is to hold the editted data of the placehoder which may be added to the 
	/// posting later per confirmation
	/// </summary>
	public class DirtyPlaceholder
	{
		#region Private Variables
		private bool isDirty;
		private string name;
		private string rowContent;
		private bool isHtml;
		#endregion

		#region Public Methods
		public DirtyPlaceholder()
		{
		}
		#endregion

		#region Properties
		/// <summary>
		/// Html placeholder or not
		/// </summary>
		public bool IsHtml
		{
			get
			{
				return isHtml;
			}
			set
			{
				isHtml = value;
			}
		}

		/// <summary>
		/// Mark whether this content is editted
		/// </summary>
		public bool IsDirty
		{
			get
			{
				return isDirty;
			}
			set
			{
				isDirty = value;
			}
		}

		/// <summary>
		/// name of the placeholder
		/// </summary>
		public string Name
		{
			get
			{
				return name;
			}
			set
			{
				name = value;
			}
		}

		/// <summary>
		/// Content of the placeholder
		/// </summary>
		public string RowContent
		{
			get
			{
				return rowContent;
			}
			set
			{
				rowContent = value;
			}
		}
		#endregion

	}
}
