/**
 * @file FormConvertor.cs
 *
 * MCMS Manager
 *
 * MCMS Manager is the legal property of its developer
 * Chester Ragel <chesterr@gmail.com> - Developer and Maintainer
 * Yahoo ID : chesterr1979 
 * MSN : chesterr79@hotmail.com
 *
 * If you want more information, found any bugs or have any doubts you 
 * can mail me or contact me through my yahoo id.
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2.1 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#region NameSpaces
using System;
using System.Drawing;
using System.IO;
using System.Text.RegularExpressions;
using System.Collections;
using System.ComponentModel;
using System.Windows.Forms;
//MCMS components
using Microsoft.ContentManagement.Common;
using Microsoft.ContentManagement.Publishing;
//Application block
using Microsoft.Practices.EnterpriseLibrary.Configuration;
#endregion

namespace MCMS
{
	/// <summary>
	/// To convert iis log files to mcms log files
	/// </summary>
	public class FormConvertor : System.Windows.Forms.Form
	{
		#region Private Variables

		private System.Windows.Forms.OpenFileDialog openFileDialog;
		private System.Windows.Forms.Button buttonFileBrowse;
		private System.Windows.Forms.TextBox textBoxFiles;
		private System.Windows.Forms.TextBox textBoxFolder;
		private System.Windows.Forms.Button buttonFolderBrowse;
		private System.Windows.Forms.FolderBrowserDialog folderBrowserDialog;
		private System.Windows.Forms.ProgressBar progressBar;
		private System.Windows.Forms.Button buttonConvert;
		private System.Windows.Forms.Button buttonExit;
		private System.ComponentModel.Container components = null;

		private bool fullCheck = false;
		private bool convertButton = true;
		private MCMSManagerConfig mcmsLog;
		private static string iisLogFiles;
		private System.Windows.Forms.Label labelProgressFile;
		private System.Windows.Forms.Label labelIIS;
		private System.Windows.Forms.Label labelMCMS;
		private System.Windows.Forms.CheckBox checkBoxFull;
		private static string mcmsLogFolder;
		private CmsApplicationContext cmsApplication = new CmsApplicationContext();

		#endregion

		#region Private delegate to start search/stop search
		private delegate void ConvertIISDelegate();
		#endregion

		#region Init/Dispose

		public FormConvertor()
		{
			InitializeComponent();
		}

		/// <summary>
		/// Clean up any resources being used.
		/// </summary>
		protected override void Dispose( bool disposing )
		{
			if( disposing )
			{
				if(components != null)
				{
					components.Dispose();
					try
					{
						cmsApplication.Dispose();
					}
					catch{}
				}
			}
			base.Dispose( disposing );
		}

		#region Windows Form Designer generated code
		/// <summary>
		/// Required method for Designer support - do not modify
		/// the contents of this method with the code editor.
		/// </summary>
		private void InitializeComponent()
		{
			System.Resources.ResourceManager resources = new System.Resources.ResourceManager(typeof(FormConvertor));
			this.labelIIS = new System.Windows.Forms.Label();
			this.openFileDialog = new System.Windows.Forms.OpenFileDialog();
			this.buttonFileBrowse = new System.Windows.Forms.Button();
			this.labelMCMS = new System.Windows.Forms.Label();
			this.textBoxFiles = new System.Windows.Forms.TextBox();
			this.textBoxFolder = new System.Windows.Forms.TextBox();
			this.buttonFolderBrowse = new System.Windows.Forms.Button();
			this.folderBrowserDialog = new System.Windows.Forms.FolderBrowserDialog();
			this.progressBar = new System.Windows.Forms.ProgressBar();
			this.buttonConvert = new System.Windows.Forms.Button();
			this.buttonExit = new System.Windows.Forms.Button();
			this.labelProgressFile = new System.Windows.Forms.Label();
			this.checkBoxFull = new System.Windows.Forms.CheckBox();
			this.SuspendLayout();
			// 
			// labelIIS
			// 
			this.labelIIS.Location = new System.Drawing.Point(8, 8);
			this.labelIIS.Name = "labelIIS";
			this.labelIIS.Size = new System.Drawing.Size(248, 23);
			this.labelIIS.TabIndex = 0;
			this.labelIIS.Text = "IIS Log File(s) to be converted to IIS - MCMS log";
			// 
			// openFileDialog
			// 
			this.openFileDialog.DefaultExt = "log";
			this.openFileDialog.Filter = "IIS Log Files|*.log";
			this.openFileDialog.InitialDirectory = "\\windows\\system32\\logfiles";
			this.openFileDialog.Multiselect = true;
			this.openFileDialog.Title = "Pick an ISS log file to convert";
			// 
			// buttonFileBrowse
			// 
			this.buttonFileBrowse.Location = new System.Drawing.Point(456, 8);
			this.buttonFileBrowse.Name = "buttonFileBrowse";
			this.buttonFileBrowse.Size = new System.Drawing.Size(24, 23);
			this.buttonFileBrowse.TabIndex = 0;
			this.buttonFileBrowse.Text = "...";
			this.buttonFileBrowse.Click += new System.EventHandler(this.buttonFileBrowse_Click);
			// 
			// labelMCMS
			// 
			this.labelMCMS.Location = new System.Drawing.Point(8, 40);
			this.labelMCMS.Name = "labelMCMS";
			this.labelMCMS.Size = new System.Drawing.Size(224, 23);
			this.labelMCMS.TabIndex = 2;
			this.labelMCMS.Text = "Output directory of the IIS - MCMS log file";
			// 
			// textBoxFiles
			// 
			this.textBoxFiles.Location = new System.Drawing.Point(248, 8);
			this.textBoxFiles.Name = "textBoxFiles";
			this.textBoxFiles.ReadOnly = true;
			this.textBoxFiles.Size = new System.Drawing.Size(192, 20);
			this.textBoxFiles.TabIndex = 300;
			this.textBoxFiles.TabStop = false;
			this.textBoxFiles.Text = "";
			// 
			// textBoxFolder
			// 
			this.textBoxFolder.Location = new System.Drawing.Point(248, 40);
			this.textBoxFolder.Name = "textBoxFolder";
			this.textBoxFolder.ReadOnly = true;
			this.textBoxFolder.Size = new System.Drawing.Size(192, 20);
			this.textBoxFolder.TabIndex = 400;
			this.textBoxFolder.TabStop = false;
			this.textBoxFolder.Text = "";
			// 
			// buttonFolderBrowse
			// 
			this.buttonFolderBrowse.Location = new System.Drawing.Point(456, 40);
			this.buttonFolderBrowse.Name = "buttonFolderBrowse";
			this.buttonFolderBrowse.Size = new System.Drawing.Size(24, 23);
			this.buttonFolderBrowse.TabIndex = 1;
			this.buttonFolderBrowse.Text = "...";
			this.buttonFolderBrowse.Click += new System.EventHandler(this.buttonFolderBrowse_Click);
			// 
			// folderBrowserDialog
			// 
			this.folderBrowserDialog.Description = "Select the directory to place the converted logs";
			this.folderBrowserDialog.SelectedPath = "\\WINDOWS\\system32\\Logfiles";
			// 
			// progressBar
			// 
			this.progressBar.Location = new System.Drawing.Point(8, 120);
			this.progressBar.Name = "progressBar";
			this.progressBar.Size = new System.Drawing.Size(288, 16);
			this.progressBar.TabIndex = 600;
			// 
			// buttonConvert
			// 
			this.buttonConvert.Location = new System.Drawing.Point(312, 112);
			this.buttonConvert.Name = "buttonConvert";
			this.buttonConvert.TabIndex = 3;
			this.buttonConvert.Text = "&Convert";
			this.buttonConvert.Click += new System.EventHandler(this.buttonConvert_Click);
			// 
			// buttonExit
			// 
			this.buttonExit.DialogResult = System.Windows.Forms.DialogResult.Cancel;
			this.buttonExit.Location = new System.Drawing.Point(408, 112);
			this.buttonExit.Name = "buttonExit";
			this.buttonExit.TabIndex = 4;
			this.buttonExit.Text = "E&xit";
			this.buttonExit.Click += new System.EventHandler(this.buttonExit_Click);
			// 
			// labelProgressFile
			// 
			this.labelProgressFile.Location = new System.Drawing.Point(8, 96);
			this.labelProgressFile.Name = "labelProgressFile";
			this.labelProgressFile.Size = new System.Drawing.Size(288, 23);
			this.labelProgressFile.TabIndex = 9;
			// 
			// checkBoxFull
			// 
			this.checkBoxFull.Location = new System.Drawing.Point(8, 64);
			this.checkBoxFull.Name = "checkBoxFull";
			this.checkBoxFull.Size = new System.Drawing.Size(456, 24);
			this.checkBoxFull.TabIndex = 2;
			this.checkBoxFull.Text = "Analyze IIS log file fully (This will take more time)";
			this.checkBoxFull.CheckedChanged += new System.EventHandler(this.checkBoxFull_CheckedChanged);
			// 
			// FormConvertor
			// 
			this.AcceptButton = this.buttonConvert;
			this.AutoScaleBaseSize = new System.Drawing.Size(5, 13);
			this.CancelButton = this.buttonExit;
			this.ClientSize = new System.Drawing.Size(490, 151);
			this.Controls.Add(this.checkBoxFull);
			this.Controls.Add(this.labelProgressFile);
			this.Controls.Add(this.buttonExit);
			this.Controls.Add(this.buttonConvert);
			this.Controls.Add(this.progressBar);
			this.Controls.Add(this.buttonFolderBrowse);
			this.Controls.Add(this.textBoxFolder);
			this.Controls.Add(this.textBoxFiles);
			this.Controls.Add(this.labelMCMS);
			this.Controls.Add(this.buttonFileBrowse);
			this.Controls.Add(this.labelIIS);
			this.FormBorderStyle = System.Windows.Forms.FormBorderStyle.FixedSingle;
			this.Icon = ((System.Drawing.Icon)(resources.GetObject("$this.Icon")));
			this.MaximizeBox = false;
			this.Name = "FormConvertor";
			this.StartPosition = System.Windows.Forms.FormStartPosition.CenterScreen;
			this.Text = "Convertor";
			this.Closing += new System.ComponentModel.CancelEventHandler(this.FormConvertor_Closing);
			this.Load += new System.EventHandler(this.FormConvertor_Load);
			this.ResumeLayout(false);

		}
		#endregion

		private void FormConvertor_Load(object sender, System.EventArgs e)
		{
			cmsApplication.AuthenticateAsUser(FormMCMSManager.userName,FormMCMSManager.password,PublishingMode.Update);
			Init();
		}

		private void FormConvertor_Closing(object sender, System.ComponentModel.CancelEventArgs e)
		{
			try
			{
				cmsApplication.Dispose();
			}
			catch{}
		}

		private void Init()
		{
			//get the information from the config file
			try
			{
				mcmsLog = ConfigurationManager.GetConfiguration("MCMSSettings") as MCMSManagerConfig;
				if(mcmsLog!=null)
				{
					iisLogFiles = mcmsLog.IISLogFiles;
					mcmsLogFolder =  mcmsLog.MCMSLogFolder;
					if(iisLogFiles!="")
					{
						string[] logFiles = iisLogFiles.Split(';');
						string files = "";
						foreach(string file in logFiles)
						{
							if(file!="")
								files +=file.Split('\\')[file.Split('\\').Length-1]+";";
						}
						this.textBoxFiles.Text = files;
					}
					if(mcmsLogFolder!="")
					{
						this.textBoxFolder.Text = mcmsLogFolder;
					}
				}
			}
			catch(Exception ex)
			{
				MessageBox.Show("Configuration Management exception : "+ex.Message,"Error",MessageBoxButtons.OK,MessageBoxIcon.Error);
			}
		}

		#endregion

		#region Events
		private void buttonExit_Click(object sender, System.EventArgs e)
		{
			//save the information
			mcmsLog.IISLogFiles = iisLogFiles;
			mcmsLog.MCMSLogFolder = mcmsLogFolder;
			ConfigurationManager.WriteConfiguration("MCMSSettings",mcmsLog);
			cmsApplication.Dispose();
			this.Close();
		}

		private void buttonFileBrowse_Click(object sender, System.EventArgs e)
		{
			DialogResult result = openFileDialog.ShowDialog();
			if(result!=DialogResult.Cancel)
			{
				string fullFile = "";
				foreach(string files in openFileDialog.FileNames)
				{
					fullFile += files+";";
				}
				mcmsLog.IISLogFiles = fullFile;
				ConfigurationManager.WriteConfiguration("MCMSSettings",mcmsLog);
				Init();
			}
		}

		private void checkBoxFull_CheckedChanged(object sender, System.EventArgs e)
		{
			if(checkBoxFull.Checked)
			{
				fullCheck = true;
			}
			else
			{
				fullCheck = false;
			}
		}

		private void buttonFolderBrowse_Click(object sender, System.EventArgs e)
		{
			DialogResult result = folderBrowserDialog.ShowDialog();
			if(result!=DialogResult.Cancel)
			{
				mcmsLog.MCMSLogFolder = folderBrowserDialog.SelectedPath;
				ConfigurationManager.WriteConfiguration("MCMSSettings",mcmsLog);
				Init();
			}		
		}


		private void buttonConvert_Click(object sender, System.EventArgs e)
		{
			if(convertButton)
			{
				this.buttonExit.Enabled = false;
				this.checkBoxFull.Enabled = false;
				this.buttonFileBrowse.Enabled = false;
				this.buttonFolderBrowse.Enabled = false;
				convertButton = false;
				this.buttonConvert.Text = "Stop";
				ConvertIISDelegate convert = new ConvertIISDelegate(Convert);
				convert.BeginInvoke(null,null);
			}
			else
			{
				convertButton = true;
				this.buttonConvert.Enabled = false;
				this.buttonConvert.Text = "Stopping...";
			}
			this.labelProgressFile.Text = "";
		}
		#endregion

		#region Convert Files
		private void Convert()
		{
			string[] myFiles = iisLogFiles.Split(';');
			try
			{
				foreach (string file in myFiles )
				{
					if(!convertButton)
					{
						if(file.Trim() != "")
						{
							this.labelProgressFile.Text = "Now Converting file : "+file.Split('\\')[file.Split('\\').Length-1];
                            Transform(file,mcmsLogFolder + @"\" + "MCMSLog_" + (file.Split('\\')[file.Split('\\').Length-1].Trim()));
							this.progressBar.Value = 0;
							try
							{
								cmsApplication.Dispose();
							}
							catch{}
							cmsApplication = new CmsApplicationContext();
							cmsApplication.AuthenticateAsUser(FormMCMSManager.userName,FormMCMSManager.password,PublishingMode.Update);
						}
					}
				}
				if(!convertButton)
				{
					this.progressBar.Value = 0;
					this.buttonExit.Enabled = true;
					this.buttonFileBrowse.Enabled = true;
					this.buttonFolderBrowse.Enabled = true;
					this.checkBoxFull.Enabled = true;
					this.labelProgressFile.Text = "Conversion completed sucessfully";
					convertButton = true;
					this.buttonConvert.Text = "Convert";
					MessageBox.Show(" Files Converted","Conversion Complete",MessageBoxButtons.OK,MessageBoxIcon.Information);	
				}
			}
			catch(Exception ex)
			{
				MessageBox.Show("While accessing the log file an exception was thrown. Exception : "+ex.Message,"Error",MessageBoxButtons.OK,MessageBoxIcon.Error);
				this.progressBar.Value = 0;
				this.buttonExit.Enabled = true;
				this.buttonFileBrowse.Enabled = true;
				this.buttonFolderBrowse.Enabled = true;
				this.checkBoxFull.Enabled = true;
				this.labelProgressFile.Text = "An error occured while converting";
				convertButton = true;
				this.buttonConvert.Text = "Convert";
			}
		}

		private	void Transform(string inFile,string outFile)
		{
			//is search not stopped yet
			StreamReader sr = new StreamReader(inFile );
			StreamWriter sw = new StreamWriter(outFile, true);
			try
			{	string line;
				int lineCount=0;
				int posUrl = -1;
				while(sr.ReadLine()!=null)
				{
					lineCount++;
				}
				sr.BaseStream.Position = 0;
				this.progressBar.Maximum = (lineCount>0?lineCount-1:0);
				this.progressBar.Minimum = 0;
				this.progressBar.Step = 1;
				bool isFound = false;
				int lineNo = 0;
				string tempText = this.labelProgressFile.Text;
				while ((line = sr.ReadLine()) != null) 
				{
					lineNo++;
					this.labelProgressFile.Text = tempText + ", Line : "+lineNo.ToString();
					if(!convertButton)
					{
						if(!fullCheck)
						{
							string tmp;
							int iPos = 0;
							Regex exeres = new Regex(@"(/NR/exeres/[^ ]*)");
							//do i need to check other url forms as well?
							Regex exehtm = new Regex(@"([^ ]*\.htm)");
							if((iPos = line.IndexOf(@"/NR/exeres/")) > 0)
							{
								tmp = line.Substring(iPos+11, 36);
								Posting pPosting = cmsApplication.Searches.GetByGuid("{"+tmp+"}") as Posting;
								if (pPosting != null) 
								{
									sw.WriteLine(exeres.Replace(line, "/NR/exeres/"+tmp));
								}
							}
							else if(line.IndexOf(@".htm") > 0)
							{
								Posting pPosting = cmsApplication.Searches.GetByUrl(exehtm.Match(line).Value) as Posting;
								if (pPosting != null)
								{
									sw.WriteLine(exehtm.Replace(line, "/NR/exeres/"+pPosting.Guid.Replace("{","").Replace("}","")));
								}
							}
							else
							{
								sw.WriteLine(line);
							}
							this.progressBar.Increment(1);
						}
						else
						{
							Regex fields = new Regex(@"(#Fields:[^ ]*)");
							Regex software = new Regex(@"(#Software:[^ ]*)");
							if(fields.IsMatch(line))
							{
								sw.WriteLine(line);
								string[] pos = line.Split(' ');
								for(int i=0;i<pos.Length;i++)
								{
									if(pos[i]=="cs-uri-stem")
									{
										posUrl = i-1;
									}
								}
								isFound = true;
							}
							else if(software.IsMatch(line))
							{
								sw.WriteLine(line);
								isFound = false;
							}
							else if(isFound)
							{
								if(posUrl>0)
								{
									Posting pPosting = null;
									try
									{
										pPosting = cmsApplication.Searches.GetByUrl(line.Split(' ')[posUrl]) as Posting;
									}
									catch{}
									if (pPosting != null)
									{
										string addLine = "";
										string[] temp = line.Split(' ');
										for(int i =0;i<temp.Length;i++)
										{
											if(i!=posUrl)
											{
												addLine += temp[i]+" ";
											}
											else
											{
												addLine += "/NR/exeres/"+pPosting.Guid.Replace("{","").Replace("}","")+" ";
											}
										}
										sw.WriteLine(addLine);
									}
									else
									{
										sw.WriteLine(line);
									}
								}
							}
							else
							{
								sw.WriteLine(line);
							}
							this.progressBar.Increment(1);

						}
					}
					else
					{
						//stoped clicked. so stop.
						convertButton = true;
						this.buttonConvert.Text = "&Convert";
						this.buttonExit.Enabled = true;
						this.buttonConvert.Enabled = true;
						this.checkBoxFull.Enabled = true;
						this.buttonFileBrowse.Enabled = true;
						this.buttonFolderBrowse.Enabled = true;
						this.labelProgressFile.Text = "Conversion canceled by user";
						sr.Close();
						sw.Close();
						return;
					}
				}		
				sr.Close();
				sw.Close();
			}
			catch(Exception ex)
			{
				MessageBox.Show("While accessing the log file an exception was thrown. Exception : "+ex.Message,"Error",MessageBoxButtons.OK,MessageBoxIcon.Error);
				this.progressBar.Value = 0;
				this.buttonExit.Enabled = true;
				this.buttonFileBrowse.Enabled = true;
				this.buttonFolderBrowse.Enabled = true;
				this.checkBoxFull.Enabled = true;
				this.labelProgressFile.Text = "An error occured while converting";
				convertButton = true;
				this.buttonConvert.Text = "Convert";
				sr.Close();
				sw.Close();
			}
		}
		#endregion

	}
}