/**
 * @file FormEdit.cs
 *
 * MCMS Manager
 *
 * MCMS Manager is the legal property of its developer
 * Chester Ragel <chesterr@gmail.com> - Developer and Maintainer
 * Yahoo ID : chesterr1979 
 * MSN : chesterr79@hotmail.com
 *
 * If you want more information, found any bugs or have any doubts you 
 * can mail me or contact me through my yahoo id.
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2.1 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#region Namespaces
using System;
using System.Drawing;
using System.Collections;
using System.ComponentModel;
using System.Windows.Forms;
using System.Data;
//MCMS components
using Microsoft.ContentManagement.Common;
using Microsoft.ContentManagement.Publishing;
using Microsoft.ContentManagement.Publishing.Extensions.Placeholders;
#endregion

namespace MCMS
{
	/// <summary>
	/// This is the place where the content is editted.
	/// </summary>
	
	public class FormEdit : System.Windows.Forms.Form
	{

		#region Private Variables

		private System.Windows.Forms.Button buttonExit;
		private System.Windows.Forms.Label labelPlaceHolder;
		private System.ComponentModel.Container components = null;

		private System.Windows.Forms.Label labelPlaceholderContent;
		private ArrayList currentPlaceholders;
		private int previousSelectedIndex = 0;
		private bool isDirty = false;
		private System.Windows.Forms.ComboBox comboBoxPlaceHolder;
		private Microsoft.ConsultingServices.HtmlEditor.HtmlEditorControl htmlEditorControl;
		private System.Windows.Forms.Button buttonSave;

		#endregion

		#region Init/Dispose Controls

		public FormEdit()
		{
			InitializeComponent();
		}

		/// <summary>
		/// Clean up any resources being used.
		/// </summary>
		protected override void Dispose( bool disposing )
		{
			if( disposing )
			{
				if(components != null)
				{
					components.Dispose();
					FormMCMSManager.currentPosting = null;
					previousSelectedIndex = 0;
				}
			}
			base.Dispose( disposing );
		}
	

		#region Windows Form Designer generated code
		/// <summary>
		/// Required method for Designer support - do not modify
		/// the contents of this method with the code editor.
		/// </summary>
		private void InitializeComponent()
		{
			System.Resources.ResourceManager resources = new System.Resources.ResourceManager(typeof(FormEdit));
			this.buttonExit = new System.Windows.Forms.Button();
			this.labelPlaceHolder = new System.Windows.Forms.Label();
			this.labelPlaceholderContent = new System.Windows.Forms.Label();
			this.comboBoxPlaceHolder = new System.Windows.Forms.ComboBox();
			this.buttonSave = new System.Windows.Forms.Button();
			this.Cursor = Cursors.WaitCursor;
			this.htmlEditorControl = new Microsoft.ConsultingServices.HtmlEditor.HtmlEditorControl();
			this.SuspendLayout();
			// 
			// buttonExit
			// 
			this.buttonExit.Location = new System.Drawing.Point(600, 488);
			this.buttonExit.Name = "buttonExit";
			this.buttonExit.Size = new System.Drawing.Size(96, 23);
			this.buttonExit.TabIndex = 4;
			this.buttonExit.Text = "E&xit";
			this.buttonExit.Click += new System.EventHandler(this.buttonExit_Click);
			// 
			// labelPlaceHolder
			// 
			this.labelPlaceHolder.Location = new System.Drawing.Point(11, 16);
			this.labelPlaceHolder.Name = "labelPlaceHolder";
			this.labelPlaceHolder.Size = new System.Drawing.Size(144, 40);
			this.labelPlaceHolder.TabIndex = 3;
			this.labelPlaceHolder.Text = "Name of the PlaceHolder";
			// 
			// labelPlaceholderContent
			// 
			this.labelPlaceholderContent.Location = new System.Drawing.Point(11, 48);
			this.labelPlaceholderContent.Name = "labelPlaceholderContent";
			this.labelPlaceholderContent.Size = new System.Drawing.Size(184, 23);
			this.labelPlaceholderContent.TabIndex = 6;
			this.labelPlaceholderContent.Text = "Placeholder Content";
			// 
			// comboBoxPlaceHolder
			// 
			this.comboBoxPlaceHolder.DropDownStyle = System.Windows.Forms.ComboBoxStyle.DropDownList;
			this.comboBoxPlaceHolder.Location = new System.Drawing.Point(192, 16);
			this.comboBoxPlaceHolder.Name = "comboBoxPlaceHolder";
			this.comboBoxPlaceHolder.Size = new System.Drawing.Size(496, 21);
			this.comboBoxPlaceHolder.TabIndex = 8;
			this.comboBoxPlaceHolder.SelectedIndexChanged += new System.EventHandler(this.comboBoxPlaceHolder_SelectedIndexChanged);
			// 
			// buttonSave
			// 
			this.buttonSave.Location = new System.Drawing.Point(488, 488);
			this.buttonSave.Name = "buttonSave";
			this.buttonSave.Size = new System.Drawing.Size(88, 23);
			this.buttonSave.TabIndex = 9;
			this.buttonSave.Text = "&Save && Exit";
			this.buttonSave.Click += new System.EventHandler(this.buttonSave_Click);
			// 
			// htmlEditorControl
			// 
			this.htmlEditorControl.HtmlEdit = true;
			this.htmlEditorControl.InnerText = null;
			this.htmlEditorControl.Location = new System.Drawing.Point(8, 72);
			this.htmlEditorControl.Name = "htmlEditorControl";
			this.htmlEditorControl.Size = new System.Drawing.Size(688, 400);
			this.htmlEditorControl.TabIndex = 10;
			// 
			// FormEdit
			// 
			this.AutoScaleBaseSize = new System.Drawing.Size(5, 13);
			this.ClientSize = new System.Drawing.Size(706, 520);
			this.Controls.Add(this.htmlEditorControl);
			this.Controls.Add(this.buttonSave);
			this.Controls.Add(this.comboBoxPlaceHolder);
			this.Controls.Add(this.labelPlaceholderContent);
			this.Controls.Add(this.labelPlaceHolder);
			this.Controls.Add(this.buttonExit);
			this.FormBorderStyle = System.Windows.Forms.FormBorderStyle.FixedSingle;
			this.Icon = ((System.Drawing.Icon)(resources.GetObject("$this.Icon")));
			this.MaximizeBox = false;
			this.Name = "FormEdit";
			this.ShowInTaskbar = false;
			this.StartPosition = System.Windows.Forms.FormStartPosition.CenterScreen;
			this.Text = "Edit";
			this.Load += new System.EventHandler(this.FormEdit_Load);
			this.ResumeLayout(false);

		}
		#endregion

		private void FormEdit_Load(object sender, System.EventArgs e)
		{
			this.Text = "Edit Posting : "+FormMCMSManager.currentPosting.Name;
			LoadCombo();
			this.Cursor = Cursors.Default;
		}

		private void LoadCombo()
		{
			//clear the combobox
			comboBoxPlaceHolder.Items.Clear();
			currentPlaceholders = new ArrayList();
			for(int i=0 ; i<FormMCMSManager.currentPosting.Placeholders.Count ; i++)
			{
				//add placeholder text to the combobox
				comboBoxPlaceHolder.Items.Add(FormMCMSManager.currentPosting.Placeholders[i].Name);
				DirtyPlaceholder ph = new DirtyPlaceholder();
				ph.IsHtml = false;
				ph.Name = FormMCMSManager.currentPosting.Placeholders[i].Name;
				ph.RowContent = FormMCMSManager.currentPosting.Placeholders[i].Datasource.RawContent;
				if(FormMCMSManager.currentPosting.Placeholders[i] is HtmlPlaceholder)
				{
					ph.IsHtml = true;
				}
				ph.IsDirty = false;
				currentPlaceholders.Add(ph);
			}
			if(comboBoxPlaceHolder.Items.Count>0)
			{
				//select the first node or selected node
				comboBoxPlaceHolder.SelectedItem = comboBoxPlaceHolder.Items[previousSelectedIndex];
			}
		}

		#endregion

		#region Content Changes

		private void comboBoxPlaceHolder_SelectedIndexChanged(object sender, System.EventArgs e)
		{
			this.Cursor = Cursors.WaitCursor;
			//if text is changed

				//now all are dirty, must check it back later and do the commit if needed
				DirtyPlaceholder phOld = currentPlaceholders[previousSelectedIndex] as DirtyPlaceholder;
				if(htmlEditorControl.InnerHtml!= null && phOld.RowContent != htmlEditorControl.InnerHtml)
				{
					phOld.RowContent = htmlEditorControl.InnerHtml;
					phOld.IsDirty = true;
					isDirty = true;
				}
			try
			{
				//get the placeholder to get the text out of it
				DirtyPlaceholder ph = currentPlaceholders[comboBoxPlaceHolder.SelectedIndex] as DirtyPlaceholder;
				previousSelectedIndex = comboBoxPlaceHolder.SelectedIndex;
				if(ph!=null)
				{
					htmlEditorControl.InnerHtml = ph.RowContent;
					if(ph.IsHtml)
					{
						htmlEditorControl.HtmlEdit = true;
					}
					else
					{
						htmlEditorControl.HtmlEdit = false;
					}
				}
			}
			catch(CmsException ex)
			{
				MessageBox.Show("Exception is : "+ ex.Message,"Error",MessageBoxButtons.OK,MessageBoxIcon.Error);
				this.Cursor = Cursors.Default;
			}
			this.Cursor = Cursors.Default;
		}

		private void buttonExit_Click(object sender, System.EventArgs e)
		{
			try
			{
				this.Cursor = Cursors.WaitCursor;
				DirtyPlaceholder ph = currentPlaceholders[comboBoxPlaceHolder.SelectedIndex] as DirtyPlaceholder;
				if(isDirty || (htmlEditorControl.InnerHtml != null && ph.RowContent != htmlEditorControl.InnerHtml))
				{
					DialogResult result = MessageBox.Show("Do you want to exit without committing changes? ","Exit without Commit Changes",MessageBoxButtons.YesNo,MessageBoxIcon.Question);
					if(result == DialogResult.No)
					{
						this.Cursor = Cursors.Default;
						return;
					}
				}
				this.Cursor = Cursors.Default;
				isDirty = false;
				this.Close();
			}
			catch
			{}
		}

		private void buttonSave_Click(object sender, System.EventArgs e)
		{
			try
			{
				this.Cursor = Cursors.WaitCursor;
				//now all are dirty, must check it back later and do the commit if needed
				DirtyPlaceholder phOld = currentPlaceholders[previousSelectedIndex] as DirtyPlaceholder;
				if(phOld.RowContent != htmlEditorControl.InnerHtml)
				{
					phOld.IsDirty = true;
					phOld.RowContent = htmlEditorControl.InnerHtml;
					isDirty = true;
				}
				if(isDirty)
				{
					foreach(DirtyPlaceholder ph in currentPlaceholders)
					{
						if(ph.IsDirty)
						{
							FormMCMSManager.currentPosting.Placeholders[ph.Name].Datasource.RawContent = ph.RowContent;
						}
					}
					FormMCMSManager.cmsApplicationContext.CommitAll();
				}
				this.Cursor = Cursors.Default;
				isDirty = false;
				this.Close();
			}
			catch(Exception ex)
			{
				FormMCMSManager.cmsApplicationContext.RollbackAll();
				FormMCMSManager.cmsApplicationContext.Dispose();
				FormMCMSManager.cmsApplicationContext = new CmsApplicationContext();
				FormMCMSManager.cmsApplicationContext.AuthenticateAsUser(FormMCMSManager.userName,FormMCMSManager.password,PublishingMode.Update);
				MessageBox.Show("While trying to commit the changes, an exception was thrown and the action was rolled back. Exception is : "+ ex.Message,"Error",MessageBoxButtons.OK,MessageBoxIcon.Error);
				this.Cursor = Cursors.Default;
			}
			this.Cursor = Cursors.Default;
		}

		#endregion

	}
}
