/**
 * @file FormExport.cs
 *
 * MCMS Manager
 *
 * MCMS Manager is the legal property of its developer
 * Chester Ragel <chesterr@gmail.com> - Developer and Maintainer
 * Yahoo ID : chesterr1979 
 * MSN : chesterr79@hotmail.com
 *
 * If you want more information, found any bugs or have any doubts you 
 * can mail me or contact me through my yahoo id.
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2.1 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#region Namespaces
using System;
using System.Drawing;
using System.Collections;
using System.ComponentModel;
using System.Windows.Forms;
using System.Text.RegularExpressions;
using System.IO;
using System.Xml;
//MCMS components
using Microsoft.ContentManagement.Common;
using Microsoft.ContentManagement.Publishing;
#endregion

namespace MCMS
{
	/// <summary>
	/// Summary description for FormExport.
	/// </summary>
	public class FormExport : System.Windows.Forms.Form
	{

		#region Private Controls
		private System.Windows.Forms.TabControl tabControl;
		private System.Windows.Forms.TabPage tabPageItems;
		private System.Windows.Forms.TabPage tabPageRights;
		private System.Windows.Forms.Label label1;
		private System.Windows.Forms.TabPage tabPageType;
		private System.Windows.Forms.GroupBox groupBoxAuthentication;
		private System.Windows.Forms.TabPage tabPageOptions;
		private System.Windows.Forms.Label label4;
		private System.Windows.Forms.Label label6;
		private System.Windows.Forms.Button buttonAdd;
		private System.Windows.Forms.TreeView treeViewChannel;
		private System.Windows.Forms.ListView listViewChannel;
		private System.Windows.Forms.Button buttonRemove;
		private System.Windows.Forms.TextBox textBoxFileName;
		private System.Windows.Forms.Label labelFileName;
		private System.Windows.Forms.Button buttonBrowse;
		private System.Windows.Forms.MainMenu mainMenu;
		private System.Windows.Forms.ColumnHeader columnHeaderName;
		private System.Windows.Forms.ColumnHeader columnHeaderGuid;
		private System.Windows.Forms.ColumnHeader columnHeaderPath;
		private System.Windows.Forms.RadioButton radioButtonServer;
		private System.Windows.Forms.RadioButton radioButtonClient;
		private System.Windows.Forms.GroupBox groupBoxServerClient;
		private System.Windows.Forms.Label labelServer;
		private System.Windows.Forms.Label labelClient1;
		private System.Windows.Forms.Label labelClient2;
		private System.Windows.Forms.RadioButton radioButtonAuthenticateAsCurrentUser;
		private System.Windows.Forms.Label label2;
		private System.Windows.Forms.RadioButton radioButtonAuthenticateAsUser;
		private System.Windows.Forms.Label label3;
		private System.Windows.Forms.Label labelUserName;
		private System.Windows.Forms.TextBox textBoxUserName;
		private System.Windows.Forms.Label labelPassword;
		private System.Windows.Forms.ComboBox comboBoxIncludeRightsGroups;
		private System.Windows.Forms.Label labelIncludeCreatedBy;
		private System.Windows.Forms.Label label5;
		private System.Windows.Forms.MenuItem menuItemFile;
		private System.Windows.Forms.MenuItem menuItemExit;
		private System.Windows.Forms.MenuItem menuItemNew;
		private System.Windows.Forms.MenuItem menuItemOpen;
		private System.Windows.Forms.MenuItem menuItemSave;
		private System.Windows.Forms.MenuItem menuItem6;
		private System.Windows.Forms.TabPage tabPageMore;
		private System.Windows.Forms.Button buttonReport;
		private System.Windows.Forms.TextBox textBoxReport;
		private System.Windows.Forms.Button buttonSDOArchive;
		private System.Windows.Forms.TextBox textBoxSDOArchive;
		private System.Windows.Forms.Label labelSDOArchive;
		private System.Windows.Forms.Label labelReport;
		private System.Windows.Forms.Label labelSDO;
		private System.Windows.Forms.Button buttonSDO;
		private System.Windows.Forms.TextBox textBoxSDO;
		private System.Windows.Forms.Label label7;
		private System.Windows.Forms.Label label8;
		private System.Windows.Forms.Label label9;
		private System.Windows.Forms.Label labelServerUrl;
		private System.Windows.Forms.TextBox textBoxServer;
		private System.Windows.Forms.TextBox textBoxPassword;
		private System.Windows.Forms.SaveFileDialog saveFileDialog;
		private System.Windows.Forms.Button buttonGenerate;
		private System.Windows.Forms.ComboBox comboboxIncludeCreatedBy;
		private System.Windows.Forms.NumericUpDown numericUpDown;
		private System.Windows.Forms.Label labelTimeInterval;
		private System.Windows.Forms.Label label10;
		private System.Windows.Forms.Label label11;
		private System.Windows.Forms.FolderBrowserDialog folderBrowserDialog;
		private System.Windows.Forms.SaveFileDialog saveFileDialogsdo;
		private System.Windows.Forms.SaveFileDialog saveFileDialogReport;
		private System.Windows.Forms.SaveFileDialog saveFileDialogXml;
		private System.Windows.Forms.OpenFileDialog openFileDialogXml;

		/// <summary>
		/// Required designer variable.
		/// </summary>
		private System.ComponentModel.Container components = null;

		#endregion

		#region Public Varibales

		private static Channel selectedChannel;

		#endregion

		#region Private Variables

		private bool isDirty = false;
		private bool isOpened = false;
		private CmsExport cmsExport = new CmsExport();
		private XmlDocument exportDocument;
		
        private CmsApplicationContext cmsApplicationContext = new CmsApplicationContext();

		#endregion

		#region Init/Dispose
		public FormExport(Channel c)
		{
			InitializeComponent();
			FormExport.selectedChannel = c;
			Init();
			InitParent();
		}

		public FormExport()
		{
			InitializeComponent();
			Init();
			InitNew();
		}

		private void Init()
		{
			cmsApplicationContext.AuthenticateAsUser(FormMCMSManager.userName,FormMCMSManager.password,PublishingMode.Update);
			TreeNode node = new TreeNode(cmsApplicationContext.RootChannel.Name);
			node.Tag = cmsApplicationContext.RootChannel;
			treeViewChannel.Nodes.Add(node);
			CreateTree(cmsApplicationContext.RootChannel,node);
			treeViewChannel.SelectedNode = treeViewChannel.Nodes[0];
			this.comboboxIncludeCreatedBy.Items.Add("CMS_EXPORT_NOT_INCLUDE_CREATED_BY_USER");
			this.comboboxIncludeCreatedBy.Items.Add("CMS_EXPORT_INCLUDE_CREATED_BY_USER");
			this.comboBoxIncludeRightsGroups.Items.Add("CMS_EXPORT_RIGHTS_GROUPS_NONE");
			this.comboBoxIncludeRightsGroups.Items.Add("CMS_EXPORT_RIGHTS_GROUP_WITHOUT_MEMBERS");
			this.comboBoxIncludeRightsGroups.Items.Add("CMS_EXPORT_RIGHTS_GROUP_WITH_MEMBERS");
		}

		private void MakeDefault()
		{
			this.radioButtonAuthenticateAsCurrentUser.Checked = true;
			this.textBoxUserName.Enabled = false;
			this.textBoxPassword.Enabled = false;
			this.radioButtonServer.Checked = true;
			this.buttonGenerate.Enabled = false;
			this.numericUpDown.Value = 0;
			this.listViewChannel.Items.Clear();
			this.textBoxUserName.Text = "";
			this.textBoxPassword.Text = "";
			this.textBoxSDO.Text = "";
			this.textBoxReport.Text = "";
			this.textBoxSDOArchive.Text = "";
			this.comboBoxIncludeRightsGroups.SelectedText = "CMS_EXPORT_NOT_INCLUDE_CREATED_BY_USER";
			this.comboboxIncludeCreatedBy.SelectedText = "CMS_EXPORT_RIGHTS_GROUPS_NONE";
			this.textBoxServer.Text = FormMCMSManager.serverName;
			if(FormExport.selectedChannel!=null)
			{
				ListViewItem lv = new ListViewItem(new string[]{selectedChannel.Name,selectedChannel.Guid,selectedChannel.Path});
				lv.Tag = selectedChannel;
				this.listViewChannel.Items.Add(lv);
				cmsExport.ContainerGuid = selectedChannel.Guid;
				this.buttonRemove.Enabled = true;
				this.buttonAdd.Enabled = false;
			}
			else
			{
				this.buttonRemove.Enabled = false;
				this.buttonAdd.Enabled = true;
			}
			this.comboboxIncludeCreatedBy.SelectedItem = cmsExport.CreatedBy.ToString();
			this.comboBoxIncludeRightsGroups.SelectedItem = cmsExport.RightsGroups.ToString();
			isOpened = false;
		}

		private void InitOpen()
		{
			try
			{
				FormExport.selectedChannel = null;
				MakeDefault();
				cmsExport = new CmsExport();
				DialogResult result = openFileDialogXml.ShowDialog();
				if(result==DialogResult.OK)
				{
					exportDocument = new XmlDocument();
					exportDocument.Load(openFileDialogXml.FileName);
					XmlNodeList ele = exportDocument.GetElementsByTagName("AuthenticationType");
					if(ele.Item(0).InnerText=="1")
					{
						cmsExport.AuthenticationType = CmsAuthenticationType.AuthenticateAsCurrentUser;
						this.radioButtonAuthenticateAsCurrentUser.Checked = true;
						this.textBoxUserName.Enabled = false;
						this.textBoxPassword.Enabled = false;
					}
					else
					{
						cmsExport.AuthenticationType = CmsAuthenticationType.AuthenticateAsUser;
						this.radioButtonAuthenticateAsUser.Checked = true;
						this.textBoxUserName.Enabled = true;
						this.textBoxPassword.Enabled = true;
					}
					ele = exportDocument.GetElementsByTagName("ScriptType");
					if(ele.Item(0).InnerText=="1")
					{
						cmsExport.ScriptType = CmsScriptType.ServerSide;
						this.radioButtonServer.Checked = true;
					}
					else
					{
						cmsExport.ScriptType = CmsScriptType.ClientSide;
						this.radioButtonClient.Checked = true;
					}
                    ele = exportDocument.GetElementsByTagName("TimeInterval");
					int inter = 0;
					try
					{
						inter = int.Parse(ele.Item(0).InnerText);
					}
					catch{}
					cmsExport.TimeInterval = inter;
                    this.numericUpDown.Value = inter;
					ele = exportDocument.GetElementsByTagName("RightsGroups");
					if(ele.Item(0).InnerText=="1")
					{
						this.comboBoxIncludeRightsGroups.SelectedIndex = 0;
						cmsExport.RightsGroups = ExportIncludeRightsGroups.CMS_EXPORT_RIGHTS_GROUPS_NONE;
					}
					else if(ele.Item(0).InnerText=="2")
					{
						this.comboBoxIncludeRightsGroups.SelectedIndex = 1;
						cmsExport.RightsGroups = ExportIncludeRightsGroups.CMS_EXPORT_RIGHTS_GROUP_WITHOUT_MEMBERS;
					}
					else
					{
						this.comboBoxIncludeRightsGroups.SelectedIndex = 2;
						cmsExport.RightsGroups = ExportIncludeRightsGroups.CMS_EXPORT_RIGHTS_GROUP_WITH_MEMBERS;
					}
					ele = exportDocument.GetElementsByTagName("CreatedBy");
					if(ele.Item(0).InnerText=="1")
					{
						this.comboboxIncludeCreatedBy.SelectedIndex = 0;
						cmsExport.CreatedBy = ExportIncludeCreatedBy.CMS_EXPORT_NOT_INCLUDE_CREATED_BY_USER;
					}
					else if(ele.Item(0).InnerText=="2")
					{
						this.comboboxIncludeCreatedBy.SelectedIndex = 1;
						cmsExport.CreatedBy = ExportIncludeCreatedBy.CMS_EXPORT_INCLUDE_CREATED_BY_USER;
					}
					ele = exportDocument.GetElementsByTagName("ServerUrl");
					this.textBoxServer.Text = ele.Item(0).InnerText;
					cmsExport.ServerUrl = ele.Item(0).InnerText;
					ele = exportDocument.GetElementsByTagName("ContainerGuid");
					if(ele.Item(0).InnerText!="")
					{
						try
						{
							Channel c = cmsApplicationContext.Searches.GetByGuid(ele.Item(0).InnerText) as Channel;
							if(c!=null)
							{
								ListViewItem lv = new ListViewItem(new string[]{c.Name,c.Guid,c.Path});
								lv.Tag = c;
								this.listViewChannel.Items.Add(lv);
								cmsExport.ContainerGuid = c.Guid;
								this.buttonRemove.Enabled = true;
								this.buttonAdd.Enabled = false;
								FormExport.selectedChannel = c;
							}
						}
						catch{}
					}
					ele = exportDocument.GetElementsByTagName("UserName");
					this.textBoxUserName.Text = ele.Item(0).InnerText;
					cmsExport.UserName =  ele.Item(0).InnerText;
					ele = exportDocument.GetElementsByTagName("Password");
					this.textBoxPassword.Text = ele.Item(0).InnerText;
					cmsExport.Password =  ele.Item(0).InnerText;
					ele = exportDocument.GetElementsByTagName("ReportFilePath");
					this.textBoxReport.Text = ele.Item(0).InnerText;
					cmsExport.ReportFilePath =  ele.Item(0).InnerText;
					ele = exportDocument.GetElementsByTagName("SDOArchivePath");
					this.textBoxSDOArchive.Text = ele.Item(0).InnerText;
					cmsExport.SDOArchivePath =  ele.Item(0).InnerText;
					ele = exportDocument.GetElementsByTagName("SDOFilePath");
					this.textBoxSDO.Text = ele.Item(0).InnerText;
					cmsExport.SDOFilePath =  ele.Item(0).InnerText;
					ele = exportDocument.GetElementsByTagName("ScriptFile");
					this.textBoxFileName.Text = ele.Item(0).InnerText;
					cmsExport.ScriptFile =  ele.Item(0).InnerText;
					this.buttonGenerate.Enabled = false;
					if(cmsExport.ScriptFile!="")
					{
						this.buttonGenerate.Enabled = true;
					}
						
					isDirty = false;
				}
			}
			catch(Exception ex)
			{
				MessageBox.Show("While trying to open the document, an error occured. Error - "+ex.ToString(),"Error",MessageBoxButtons.OK,MessageBoxIcon.Error);
			}

		}

		private void InitNew()
		{
			FormExport.selectedChannel = null;
			MakeDefault();
			exportDocument = new XmlDocument();
			exportDocument.LoadXml("<export>" +
				"<AuthenticationType>1</AuthenticationType>" +
				"<TimeInterval>0</TimeInterval>" +
				"<SDOFilePath></SDOFilePath>" +
				"<ContainerGuid></ContainerGuid>" +
				"<ServerUrl>http://localhost</ServerUrl>" +
				"<ReportFilePath></ReportFilePath>" +
				"<SDOArchivePath></SDOArchivePath>" +
				"<ScriptType>1</ScriptType>" +
				"<CreatedBy>1</CreatedBy>" +
				"<RightsGroups>1</RightsGroups>" +
				"<UserName></UserName>" +
				"<Password></Password>" +
				"<ScriptFile></ScriptFile>" +
				"</export>");
			isDirty = false;
		}

		private void InitParent()
		{
			MakeDefault();
			exportDocument = new XmlDocument();
			exportDocument.LoadXml("<export>" +
				"<AuthenticationType>1</AuthenticationType>" +
				"<TimeInterval>0</TimeInterval>" +
				"<SDOFilePath></SDOFilePath>" +
				"<ContainerGuid></ContainerGuid>" +
				"<ServerUrl>http://localhost</ServerUrl>" +
				"<ReportFilePath></ReportFilePath>" +
				"<SDOArchivePath></SDOArchivePath>" +
				"<ScriptType>1</ScriptType>" +
				"<CreatedBy>1</CreatedBy>" +
				"<RightsGroups>1</RightsGroups>" +
				"<UserName></UserName>" +
				"<Password></Password>" +
				"<ScriptFile></ScriptFile>" +
				"</export>");
			isDirty = false;
		}
		
		private void CreateTree(Channel parentChannel,TreeNode parentNode)
		{
			foreach(Channel c in parentChannel.Channels)
			{
				TreeNode node = new TreeNode(c.Name);
				node.Tag = c;
				parentNode.Nodes.Add(node);
				if(c.Channels!=null && c.Channels.Count>0)
				{
					CreateTree(c,node);
				}
			}
		}

		/// <summary>
		/// Clean up any resources being used.
		/// </summary>
		protected override void Dispose( bool disposing )
		{
			if( disposing )
			{
				if(components != null)
				{
					components.Dispose();
				}
			}
			base.Dispose( disposing );
		}

		#region Windows Form Designer generated code
		/// <summary>
		/// Required method for Designer support - do not modify
		/// the contents of this method with the code editor.
		/// </summary>
		private void InitializeComponent()
		{
			System.Resources.ResourceManager resources = new System.Resources.ResourceManager(typeof(FormExport));
			this.tabControl = new System.Windows.Forms.TabControl();
			this.tabPageItems = new System.Windows.Forms.TabPage();
			this.buttonAdd = new System.Windows.Forms.Button();
			this.treeViewChannel = new System.Windows.Forms.TreeView();
			this.label1 = new System.Windows.Forms.Label();
			this.tabPageType = new System.Windows.Forms.TabPage();
			this.groupBoxServerClient = new System.Windows.Forms.GroupBox();
			this.labelServerUrl = new System.Windows.Forms.Label();
			this.textBoxServer = new System.Windows.Forms.TextBox();
			this.labelClient2 = new System.Windows.Forms.Label();
			this.labelClient1 = new System.Windows.Forms.Label();
			this.labelServer = new System.Windows.Forms.Label();
			this.radioButtonServer = new System.Windows.Forms.RadioButton();
			this.radioButtonClient = new System.Windows.Forms.RadioButton();
			this.tabPageRights = new System.Windows.Forms.TabPage();
			this.groupBoxAuthentication = new System.Windows.Forms.GroupBox();
			this.textBoxPassword = new System.Windows.Forms.TextBox();
			this.labelPassword = new System.Windows.Forms.Label();
			this.textBoxUserName = new System.Windows.Forms.TextBox();
			this.labelUserName = new System.Windows.Forms.Label();
			this.label3 = new System.Windows.Forms.Label();
			this.label2 = new System.Windows.Forms.Label();
			this.radioButtonAuthenticateAsCurrentUser = new System.Windows.Forms.RadioButton();
			this.radioButtonAuthenticateAsUser = new System.Windows.Forms.RadioButton();
			this.label11 = new System.Windows.Forms.Label();
			this.tabPageOptions = new System.Windows.Forms.TabPage();
			this.label10 = new System.Windows.Forms.Label();
			this.labelTimeInterval = new System.Windows.Forms.Label();
			this.numericUpDown = new System.Windows.Forms.NumericUpDown();
			this.label5 = new System.Windows.Forms.Label();
			this.comboBoxIncludeRightsGroups = new System.Windows.Forms.ComboBox();
			this.comboboxIncludeCreatedBy = new System.Windows.Forms.ComboBox();
			this.label6 = new System.Windows.Forms.Label();
			this.label4 = new System.Windows.Forms.Label();
			this.labelIncludeCreatedBy = new System.Windows.Forms.Label();
			this.tabPageMore = new System.Windows.Forms.TabPage();
			this.label9 = new System.Windows.Forms.Label();
			this.label8 = new System.Windows.Forms.Label();
			this.label7 = new System.Windows.Forms.Label();
			this.labelSDO = new System.Windows.Forms.Label();
			this.buttonSDO = new System.Windows.Forms.Button();
			this.textBoxSDO = new System.Windows.Forms.TextBox();
			this.labelReport = new System.Windows.Forms.Label();
			this.buttonReport = new System.Windows.Forms.Button();
			this.textBoxReport = new System.Windows.Forms.TextBox();
			this.labelSDOArchive = new System.Windows.Forms.Label();
			this.buttonSDOArchive = new System.Windows.Forms.Button();
			this.textBoxSDOArchive = new System.Windows.Forms.TextBox();
			this.listViewChannel = new System.Windows.Forms.ListView();
			this.columnHeaderName = new System.Windows.Forms.ColumnHeader();
			this.columnHeaderGuid = new System.Windows.Forms.ColumnHeader();
			this.columnHeaderPath = new System.Windows.Forms.ColumnHeader();
			this.buttonRemove = new System.Windows.Forms.Button();
			this.textBoxFileName = new System.Windows.Forms.TextBox();
			this.labelFileName = new System.Windows.Forms.Label();
			this.buttonBrowse = new System.Windows.Forms.Button();
			this.buttonGenerate = new System.Windows.Forms.Button();
			this.mainMenu = new System.Windows.Forms.MainMenu();
			this.menuItemFile = new System.Windows.Forms.MenuItem();
			this.menuItemNew = new System.Windows.Forms.MenuItem();
			this.menuItemOpen = new System.Windows.Forms.MenuItem();
			this.menuItemSave = new System.Windows.Forms.MenuItem();
			this.menuItem6 = new System.Windows.Forms.MenuItem();
			this.menuItemExit = new System.Windows.Forms.MenuItem();
			this.saveFileDialog = new System.Windows.Forms.SaveFileDialog();
			this.folderBrowserDialog = new System.Windows.Forms.FolderBrowserDialog();
			this.saveFileDialogsdo = new System.Windows.Forms.SaveFileDialog();
			this.saveFileDialogReport = new System.Windows.Forms.SaveFileDialog();
			this.saveFileDialogXml = new System.Windows.Forms.SaveFileDialog();
			this.openFileDialogXml = new System.Windows.Forms.OpenFileDialog();
			this.tabControl.SuspendLayout();
			this.tabPageItems.SuspendLayout();
			this.tabPageType.SuspendLayout();
			this.groupBoxServerClient.SuspendLayout();
			this.tabPageRights.SuspendLayout();
			this.groupBoxAuthentication.SuspendLayout();
			this.tabPageOptions.SuspendLayout();
			((System.ComponentModel.ISupportInitialize)(this.numericUpDown)).BeginInit();
			this.tabPageMore.SuspendLayout();
			this.SuspendLayout();
			// 
			// tabControl
			// 
			this.tabControl.Controls.Add(this.tabPageItems);
			this.tabControl.Controls.Add(this.tabPageType);
			this.tabControl.Controls.Add(this.tabPageRights);
			this.tabControl.Controls.Add(this.tabPageOptions);
			this.tabControl.Controls.Add(this.tabPageMore);
			this.tabControl.Dock = System.Windows.Forms.DockStyle.Top;
			this.tabControl.Location = new System.Drawing.Point(0, 0);
			this.tabControl.Name = "tabControl";
			this.tabControl.SelectedIndex = 0;
			this.tabControl.Size = new System.Drawing.Size(568, 248);
			this.tabControl.TabIndex = 0;
			// 
			// tabPageItems
			// 
			this.tabPageItems.Controls.Add(this.buttonAdd);
			this.tabPageItems.Controls.Add(this.treeViewChannel);
			this.tabPageItems.Controls.Add(this.label1);
			this.tabPageItems.Location = new System.Drawing.Point(4, 22);
			this.tabPageItems.Name = "tabPageItems";
			this.tabPageItems.Size = new System.Drawing.Size(560, 222);
			this.tabPageItems.TabIndex = 0;
			this.tabPageItems.Text = "Item Selection";
			// 
			// buttonAdd
			// 
			this.buttonAdd.Location = new System.Drawing.Point(462, 186);
			this.buttonAdd.Name = "buttonAdd";
			this.buttonAdd.TabIndex = 1;
			this.buttonAdd.Text = "Include";
			this.buttonAdd.Click += new System.EventHandler(this.buttonAdd_Click);
			// 
			// treeViewChannel
			// 
			this.treeViewChannel.ImageIndex = -1;
			this.treeViewChannel.Location = new System.Drawing.Point(16, 48);
			this.treeViewChannel.Name = "treeViewChannel";
			this.treeViewChannel.SelectedImageIndex = -1;
			this.treeViewChannel.Size = new System.Drawing.Size(520, 128);
			this.treeViewChannel.TabIndex = 0;
			// 
			// label1
			// 
			this.label1.Location = new System.Drawing.Point(16, 16);
			this.label1.Name = "label1";
			this.label1.Size = new System.Drawing.Size(200, 23);
			this.label1.TabIndex = 0;
			this.label1.Text = "Choose Channel for export :";
			// 
			// tabPageType
			// 
			this.tabPageType.Controls.Add(this.groupBoxServerClient);
			this.tabPageType.Location = new System.Drawing.Point(4, 22);
			this.tabPageType.Name = "tabPageType";
			this.tabPageType.Size = new System.Drawing.Size(560, 222);
			this.tabPageType.TabIndex = 2;
			this.tabPageType.Text = "Script Type";
			// 
			// groupBoxServerClient
			// 
			this.groupBoxServerClient.Controls.Add(this.labelServerUrl);
			this.groupBoxServerClient.Controls.Add(this.textBoxServer);
			this.groupBoxServerClient.Controls.Add(this.labelClient2);
			this.groupBoxServerClient.Controls.Add(this.labelClient1);
			this.groupBoxServerClient.Controls.Add(this.labelServer);
			this.groupBoxServerClient.Controls.Add(this.radioButtonServer);
			this.groupBoxServerClient.Controls.Add(this.radioButtonClient);
			this.groupBoxServerClient.Location = new System.Drawing.Point(8, 8);
			this.groupBoxServerClient.Name = "groupBoxServerClient";
			this.groupBoxServerClient.Size = new System.Drawing.Size(544, 208);
			this.groupBoxServerClient.TabIndex = 3;
			this.groupBoxServerClient.TabStop = false;
			this.groupBoxServerClient.Text = "Client Site / Server Site";
			// 
			// labelServerUrl
			// 
			this.labelServerUrl.Location = new System.Drawing.Point(72, 176);
			this.labelServerUrl.Name = "labelServerUrl";
			this.labelServerUrl.Size = new System.Drawing.Size(64, 23);
			this.labelServerUrl.TabIndex = 10;
			this.labelServerUrl.Text = "Server URL";
			// 
			// textBoxServer
			// 
			this.textBoxServer.Location = new System.Drawing.Point(152, 176);
			this.textBoxServer.Name = "textBoxServer";
			this.textBoxServer.Size = new System.Drawing.Size(208, 20);
			this.textBoxServer.TabIndex = 9;
			this.textBoxServer.Text = "";
			this.textBoxServer.TextChanged += new System.EventHandler(this.textBoxServer_TextChanged);
			// 
			// labelClient2
			// 
			this.labelClient2.Location = new System.Drawing.Point(16, 144);
			this.labelClient2.Name = "labelClient2";
			this.labelClient2.Size = new System.Drawing.Size(456, 23);
			this.labelClient2.TabIndex = 6;
			this.labelClient2.Text = "Access between server and client is provided using the HTTP or HTTPS protocol. ";
			// 
			// labelClient1
			// 
			this.labelClient1.Location = new System.Drawing.Point(16, 112);
			this.labelClient1.Name = "labelClient1";
			this.labelClient1.Size = new System.Drawing.Size(496, 32);
			this.labelClient1.TabIndex = 5;
			this.labelClient1.Text = "The client-side objects of the site deployment API are intended for use in script" +
				"s running remotely on an MCMS client. ";
			// 
			// labelServer
			// 
			this.labelServer.Location = new System.Drawing.Point(16, 48);
			this.labelServer.Name = "labelServer";
			this.labelServer.Size = new System.Drawing.Size(496, 32);
			this.labelServer.TabIndex = 4;
			this.labelServer.Text = "The server-side objects of the site deployment API are intended for use in script" +
				"s running locally on an MCMS server. ";
			// 
			// radioButtonServer
			// 
			this.radioButtonServer.Location = new System.Drawing.Point(16, 24);
			this.radioButtonServer.Name = "radioButtonServer";
			this.radioButtonServer.Size = new System.Drawing.Size(152, 16);
			this.radioButtonServer.TabIndex = 0;
			this.radioButtonServer.Text = "Server-side";
			this.radioButtonServer.CheckedChanged += new System.EventHandler(this.radioButtonServer_CheckedChanged);
			// 
			// radioButtonClient
			// 
			this.radioButtonClient.Location = new System.Drawing.Point(16, 88);
			this.radioButtonClient.Name = "radioButtonClient";
			this.radioButtonClient.TabIndex = 1;
			this.radioButtonClient.Text = "Client-side";
			this.radioButtonClient.CheckedChanged += new System.EventHandler(this.radioButtonClient_CheckedChanged);
			// 
			// tabPageRights
			// 
			this.tabPageRights.Controls.Add(this.groupBoxAuthentication);
			this.tabPageRights.Location = new System.Drawing.Point(4, 22);
			this.tabPageRights.Name = "tabPageRights";
			this.tabPageRights.Size = new System.Drawing.Size(560, 222);
			this.tabPageRights.TabIndex = 1;
			this.tabPageRights.Text = "Authentication";
			// 
			// groupBoxAuthentication
			// 
			this.groupBoxAuthentication.Controls.Add(this.textBoxPassword);
			this.groupBoxAuthentication.Controls.Add(this.labelPassword);
			this.groupBoxAuthentication.Controls.Add(this.textBoxUserName);
			this.groupBoxAuthentication.Controls.Add(this.labelUserName);
			this.groupBoxAuthentication.Controls.Add(this.label3);
			this.groupBoxAuthentication.Controls.Add(this.label2);
			this.groupBoxAuthentication.Controls.Add(this.radioButtonAuthenticateAsCurrentUser);
			this.groupBoxAuthentication.Controls.Add(this.radioButtonAuthenticateAsUser);
			this.groupBoxAuthentication.Controls.Add(this.label11);
			this.groupBoxAuthentication.Location = new System.Drawing.Point(8, 8);
			this.groupBoxAuthentication.Name = "groupBoxAuthentication";
			this.groupBoxAuthentication.Size = new System.Drawing.Size(536, 208);
			this.groupBoxAuthentication.TabIndex = 1;
			this.groupBoxAuthentication.TabStop = false;
			this.groupBoxAuthentication.Text = "Authentication Type";
			// 
			// textBoxPassword
			// 
			this.textBoxPassword.Location = new System.Drawing.Point(416, 168);
			this.textBoxPassword.Name = "textBoxPassword";
			this.textBoxPassword.PasswordChar = '*';
			this.textBoxPassword.Size = new System.Drawing.Size(104, 20);
			this.textBoxPassword.TabIndex = 3;
			this.textBoxPassword.Text = "";
			this.textBoxPassword.TextChanged += new System.EventHandler(this.textBoxPassword_TextChanged);
			// 
			// labelPassword
			// 
			this.labelPassword.Location = new System.Drawing.Point(360, 168);
			this.labelPassword.Name = "labelPassword";
			this.labelPassword.TabIndex = 7;
			this.labelPassword.Text = "Password";
			// 
			// textBoxUserName
			// 
			this.textBoxUserName.Location = new System.Drawing.Point(192, 168);
			this.textBoxUserName.Name = "textBoxUserName";
			this.textBoxUserName.Size = new System.Drawing.Size(152, 20);
			this.textBoxUserName.TabIndex = 2;
			this.textBoxUserName.Text = "";
			this.textBoxUserName.TextChanged += new System.EventHandler(this.textBoxUserName_TextChanged);
			// 
			// labelUserName
			// 
			this.labelUserName.Location = new System.Drawing.Point(16, 168);
			this.labelUserName.Name = "labelUserName";
			this.labelUserName.Size = new System.Drawing.Size(184, 23);
			this.labelUserName.TabIndex = 5;
			this.labelUserName.Text = "User Name (WinNT://domain/user)";
			// 
			// label3
			// 
			this.label3.Location = new System.Drawing.Point(16, 136);
			this.label3.Name = "label3";
			this.label3.Size = new System.Drawing.Size(512, 24);
			this.label3.TabIndex = 4;
			this.label3.Text = "Establishes the specified user account as the account to use for an upcoming expo" +
				"rt operation.";
			// 
			// label2
			// 
			this.label2.Location = new System.Drawing.Point(16, 56);
			this.label2.Name = "label2";
			this.label2.Size = new System.Drawing.Size(512, 32);
			this.label2.TabIndex = 3;
			this.label2.Text = "Establishes the user account under which the script is running as the account to " +
				"use for an upcoming export operation.";
			// 
			// radioButtonAuthenticateAsCurrentUser
			// 
			this.radioButtonAuthenticateAsCurrentUser.Location = new System.Drawing.Point(16, 24);
			this.radioButtonAuthenticateAsCurrentUser.Name = "radioButtonAuthenticateAsCurrentUser";
			this.radioButtonAuthenticateAsCurrentUser.Size = new System.Drawing.Size(160, 24);
			this.radioButtonAuthenticateAsCurrentUser.TabIndex = 0;
			this.radioButtonAuthenticateAsCurrentUser.Text = "AuthenticateAsCurrentUser";
			this.radioButtonAuthenticateAsCurrentUser.CheckedChanged += new System.EventHandler(this.radioButtonAuthenticateAsCurrentUser_CheckedChanged);
			// 
			// radioButtonAuthenticateAsUser
			// 
			this.radioButtonAuthenticateAsUser.Location = new System.Drawing.Point(16, 104);
			this.radioButtonAuthenticateAsUser.Name = "radioButtonAuthenticateAsUser";
			this.radioButtonAuthenticateAsUser.Size = new System.Drawing.Size(192, 24);
			this.radioButtonAuthenticateAsUser.TabIndex = 1;
			this.radioButtonAuthenticateAsUser.Text = "AuthenticateAsUser";
			this.radioButtonAuthenticateAsUser.CheckedChanged += new System.EventHandler(this.radioButtonAuthenticateAsUser_CheckedChanged);
			// 
			// label11
			// 
			this.label11.Location = new System.Drawing.Point(216, 56);
			this.label11.Name = "label11";
			this.label11.Size = new System.Drawing.Size(192, 23);
			this.label11.TabIndex = 8;
			this.label11.Text = "label11";
			// 
			// tabPageOptions
			// 
			this.tabPageOptions.Controls.Add(this.label10);
			this.tabPageOptions.Controls.Add(this.labelTimeInterval);
			this.tabPageOptions.Controls.Add(this.numericUpDown);
			this.tabPageOptions.Controls.Add(this.label5);
			this.tabPageOptions.Controls.Add(this.comboBoxIncludeRightsGroups);
			this.tabPageOptions.Controls.Add(this.comboboxIncludeCreatedBy);
			this.tabPageOptions.Controls.Add(this.label6);
			this.tabPageOptions.Controls.Add(this.label4);
			this.tabPageOptions.Controls.Add(this.labelIncludeCreatedBy);
			this.tabPageOptions.Location = new System.Drawing.Point(4, 22);
			this.tabPageOptions.Name = "tabPageOptions";
			this.tabPageOptions.Size = new System.Drawing.Size(560, 222);
			this.tabPageOptions.TabIndex = 3;
			this.tabPageOptions.Text = "Export Options";
			// 
			// label10
			// 
			this.label10.Location = new System.Drawing.Point(16, 184);
			this.label10.Name = "label10";
			this.label10.Size = new System.Drawing.Size(512, 23);
			this.label10.TabIndex = 11;
			this.label10.Text = "A Long integer containing a time period specifying a number of minutes.";
			// 
			// labelTimeInterval
			// 
			this.labelTimeInterval.Location = new System.Drawing.Point(16, 160);
			this.labelTimeInterval.Name = "labelTimeInterval";
			this.labelTimeInterval.Size = new System.Drawing.Size(80, 23);
			this.labelTimeInterval.TabIndex = 10;
			this.labelTimeInterval.Text = "TimeInterval ";
			// 
			// numericUpDown
			// 
			this.numericUpDown.Location = new System.Drawing.Point(104, 160);
			this.numericUpDown.Maximum = new System.Decimal(new int[] {
																		  100000,
																		  0,
																		  0,
																		  0});
			this.numericUpDown.Name = "numericUpDown";
			this.numericUpDown.Size = new System.Drawing.Size(96, 20);
			this.numericUpDown.TabIndex = 9;
			// 
			// label5
			// 
			this.label5.Location = new System.Drawing.Point(16, 128);
			this.label5.Name = "label5";
			this.label5.Size = new System.Drawing.Size(528, 24);
			this.label5.TabIndex = 8;
			this.label5.Text = "Gets or sets a value that controls how the rights groups and the user lists of ri" +
				"ghts groups are exported.";
			// 
			// comboBoxIncludeRightsGroups
			// 
			this.comboBoxIncludeRightsGroups.DropDownStyle = System.Windows.Forms.ComboBoxStyle.DropDownList;
			this.comboBoxIncludeRightsGroups.Location = new System.Drawing.Point(184, 96);
			this.comboBoxIncludeRightsGroups.Name = "comboBoxIncludeRightsGroups";
			this.comboBoxIncludeRightsGroups.Size = new System.Drawing.Size(360, 21);
			this.comboBoxIncludeRightsGroups.TabIndex = 1;
			this.comboBoxIncludeRightsGroups.SelectedIndexChanged += new System.EventHandler(this.comboBoxIncludeRightsGroups_SelectedIndexChanged);
			// 
			// comboboxIncludeCreatedBy
			// 
			this.comboboxIncludeCreatedBy.DropDownStyle = System.Windows.Forms.ComboBoxStyle.DropDownList;
			this.comboboxIncludeCreatedBy.Location = new System.Drawing.Point(184, 16);
			this.comboboxIncludeCreatedBy.Name = "comboboxIncludeCreatedBy";
			this.comboboxIncludeCreatedBy.Size = new System.Drawing.Size(360, 21);
			this.comboboxIncludeCreatedBy.TabIndex = 0;
			this.comboboxIncludeCreatedBy.SelectedIndexChanged += new System.EventHandler(this.comboboxIncludeCreatedBy_SelectedIndexChanged);
			// 
			// label6
			// 
			this.label6.Location = new System.Drawing.Point(16, 96);
			this.label6.Name = "label6";
			this.label6.Size = new System.Drawing.Size(152, 23);
			this.label6.TabIndex = 4;
			this.label6.Text = "IncludeRightsGroups";
			// 
			// label4
			// 
			this.label4.Location = new System.Drawing.Point(16, 48);
			this.label4.Name = "label4";
			this.label4.Size = new System.Drawing.Size(528, 40);
			this.label4.TabIndex = 3;
			this.label4.Text = "Gets or sets a value that controls whether or not information about who created a" +
				"n object is to be included in the export operation.";
			// 
			// labelIncludeCreatedBy
			// 
			this.labelIncludeCreatedBy.Location = new System.Drawing.Point(16, 16);
			this.labelIncludeCreatedBy.Name = "labelIncludeCreatedBy";
			this.labelIncludeCreatedBy.TabIndex = 0;
			this.labelIncludeCreatedBy.Text = "IncludeCreatedBy";
			// 
			// tabPageMore
			// 
			this.tabPageMore.Controls.Add(this.label9);
			this.tabPageMore.Controls.Add(this.label8);
			this.tabPageMore.Controls.Add(this.label7);
			this.tabPageMore.Controls.Add(this.labelSDO);
			this.tabPageMore.Controls.Add(this.buttonSDO);
			this.tabPageMore.Controls.Add(this.textBoxSDO);
			this.tabPageMore.Controls.Add(this.labelReport);
			this.tabPageMore.Controls.Add(this.buttonReport);
			this.tabPageMore.Controls.Add(this.textBoxReport);
			this.tabPageMore.Controls.Add(this.labelSDOArchive);
			this.tabPageMore.Controls.Add(this.buttonSDOArchive);
			this.tabPageMore.Controls.Add(this.textBoxSDOArchive);
			this.tabPageMore.Location = new System.Drawing.Point(4, 22);
			this.tabPageMore.Name = "tabPageMore";
			this.tabPageMore.Size = new System.Drawing.Size(560, 222);
			this.tabPageMore.TabIndex = 4;
			this.tabPageMore.Text = "More Options";
			// 
			// label9
			// 
			this.label9.Location = new System.Drawing.Point(16, 178);
			this.label9.Name = "label9";
			this.label9.Size = new System.Drawing.Size(528, 32);
			this.label9.TabIndex = 19;
			this.label9.Text = "With the export, a report will be generated (This file will contain the export in" +
				"formation and errors occured which exporting).";
			// 
			// label8
			// 
			this.label8.Location = new System.Drawing.Point(16, 120);
			this.label8.Name = "label8";
			this.label8.Size = new System.Drawing.Size(528, 32);
			this.label8.TabIndex = 18;
			this.label8.Text = "Place of the sdo archive folder, where it should be placed for backup - later use" +
				". This is usually a local folder.";
			// 
			// label7
			// 
			this.label7.Location = new System.Drawing.Point(16, 50);
			this.label7.Name = "label7";
			this.label7.Size = new System.Drawing.Size(536, 32);
			this.label7.TabIndex = 17;
			this.label7.Text = "Place of the sdo file, where it should be placed after creation. This is usually " +
				"a file on a remote machine.";
			// 
			// labelSDO
			// 
			this.labelSDO.Location = new System.Drawing.Point(16, 18);
			this.labelSDO.Name = "labelSDO";
			this.labelSDO.Size = new System.Drawing.Size(120, 16);
			this.labelSDO.TabIndex = 16;
			this.labelSDO.Text = "SDO file";
			// 
			// buttonSDO
			// 
			this.buttonSDO.Location = new System.Drawing.Point(448, 18);
			this.buttonSDO.Name = "buttonSDO";
			this.buttonSDO.TabIndex = 15;
			this.buttonSDO.Text = "Browse...";
			this.buttonSDO.Click += new System.EventHandler(this.buttonSDO_Click);
			// 
			// textBoxSDO
			// 
			this.textBoxSDO.Location = new System.Drawing.Point(136, 18);
			this.textBoxSDO.Name = "textBoxSDO";
			this.textBoxSDO.Size = new System.Drawing.Size(296, 20);
			this.textBoxSDO.TabIndex = 14;
			this.textBoxSDO.Text = "";
			this.textBoxSDO.TextChanged += new System.EventHandler(this.textBoxSDO_TextChanged);
			// 
			// labelReport
			// 
			this.labelReport.Location = new System.Drawing.Point(16, 154);
			this.labelReport.Name = "labelReport";
			this.labelReport.Size = new System.Drawing.Size(85, 16);
			this.labelReport.TabIndex = 13;
			this.labelReport.Text = "Report file";
			// 
			// buttonReport
			// 
			this.buttonReport.Location = new System.Drawing.Point(448, 154);
			this.buttonReport.Name = "buttonReport";
			this.buttonReport.TabIndex = 12;
			this.buttonReport.Text = "Browse...";
			this.buttonReport.Click += new System.EventHandler(this.buttonReport_Click);
			// 
			// textBoxReport
			// 
			this.textBoxReport.Location = new System.Drawing.Point(136, 154);
			this.textBoxReport.Name = "textBoxReport";
			this.textBoxReport.Size = new System.Drawing.Size(296, 20);
			this.textBoxReport.TabIndex = 11;
			this.textBoxReport.Text = "";
			this.textBoxReport.TextChanged += new System.EventHandler(this.textBoxReport_TextChanged);
			// 
			// labelSDOArchive
			// 
			this.labelSDOArchive.Location = new System.Drawing.Point(16, 90);
			this.labelSDOArchive.Name = "labelSDOArchive";
			this.labelSDOArchive.Size = new System.Drawing.Size(120, 32);
			this.labelSDOArchive.TabIndex = 10;
			this.labelSDOArchive.Text = "SDO Archive folder";
			// 
			// buttonSDOArchive
			// 
			this.buttonSDOArchive.Location = new System.Drawing.Point(448, 90);
			this.buttonSDOArchive.Name = "buttonSDOArchive";
			this.buttonSDOArchive.TabIndex = 8;
			this.buttonSDOArchive.Text = "Browse...";
			this.buttonSDOArchive.Click += new System.EventHandler(this.buttonSDOArchive_Click);
			// 
			// textBoxSDOArchive
			// 
			this.textBoxSDOArchive.Location = new System.Drawing.Point(136, 90);
			this.textBoxSDOArchive.Name = "textBoxSDOArchive";
			this.textBoxSDOArchive.Size = new System.Drawing.Size(296, 20);
			this.textBoxSDOArchive.TabIndex = 6;
			this.textBoxSDOArchive.Text = "";
			this.textBoxSDOArchive.TextChanged += new System.EventHandler(this.textBoxSDOArchive_TextChanged);
			// 
			// listViewChannel
			// 
			this.listViewChannel.Columns.AddRange(new System.Windows.Forms.ColumnHeader[] {
																							  this.columnHeaderName,
																							  this.columnHeaderGuid,
																							  this.columnHeaderPath});
			this.listViewChannel.Location = new System.Drawing.Point(8, 256);
			this.listViewChannel.Name = "listViewChannel";
			this.listViewChannel.Size = new System.Drawing.Size(544, 64);
			this.listViewChannel.TabIndex = 1;
			this.listViewChannel.View = System.Windows.Forms.View.Details;
			// 
			// columnHeaderName
			// 
			this.columnHeaderName.Text = "Name";
			this.columnHeaderName.Width = 150;
			// 
			// columnHeaderGuid
			// 
			this.columnHeaderGuid.Text = "Guid";
			this.columnHeaderGuid.Width = 240;
			// 
			// columnHeaderPath
			// 
			this.columnHeaderPath.Text = "Path";
			this.columnHeaderPath.Width = 150;
			// 
			// buttonRemove
			// 
			this.buttonRemove.Location = new System.Drawing.Point(480, 328);
			this.buttonRemove.Name = "buttonRemove";
			this.buttonRemove.TabIndex = 2;
			this.buttonRemove.Text = "Exclude";
			this.buttonRemove.Click += new System.EventHandler(this.buttonRemove_Click);
			// 
			// textBoxFileName
			// 
			this.textBoxFileName.Location = new System.Drawing.Point(152, 360);
			this.textBoxFileName.Name = "textBoxFileName";
			this.textBoxFileName.ReadOnly = true;
			this.textBoxFileName.Size = new System.Drawing.Size(232, 20);
			this.textBoxFileName.TabIndex = 3;
			this.textBoxFileName.Text = "";
			// 
			// labelFileName
			// 
			this.labelFileName.Location = new System.Drawing.Point(8, 360);
			this.labelFileName.Name = "labelFileName";
			this.labelFileName.Size = new System.Drawing.Size(136, 23);
			this.labelFileName.TabIndex = 4;
			this.labelFileName.Text = "Export Script Name";
			// 
			// buttonBrowse
			// 
			this.buttonBrowse.Location = new System.Drawing.Point(392, 360);
			this.buttonBrowse.Name = "buttonBrowse";
			this.buttonBrowse.TabIndex = 4;
			this.buttonBrowse.Text = "Browse...";
			this.buttonBrowse.Click += new System.EventHandler(this.buttonBrowse_Click);
			// 
			// buttonGenerate
			// 
			this.buttonGenerate.Location = new System.Drawing.Point(480, 360);
			this.buttonGenerate.Name = "buttonGenerate";
			this.buttonGenerate.TabIndex = 5;
			this.buttonGenerate.Text = "Generate";
			this.buttonGenerate.Click += new System.EventHandler(this.buttonGenerate_Click);
			// 
			// mainMenu
			// 
			this.mainMenu.MenuItems.AddRange(new System.Windows.Forms.MenuItem[] {
																					 this.menuItemFile});
			// 
			// menuItemFile
			// 
			this.menuItemFile.Index = 0;
			this.menuItemFile.MenuItems.AddRange(new System.Windows.Forms.MenuItem[] {
																						 this.menuItemNew,
																						 this.menuItemOpen,
																						 this.menuItemSave,
																						 this.menuItem6,
																						 this.menuItemExit});
			this.menuItemFile.Text = "&File";
			// 
			// menuItemNew
			// 
			this.menuItemNew.Index = 0;
			this.menuItemNew.Text = "&New";
			this.menuItemNew.Click += new System.EventHandler(this.menuItemNew_Click);
			// 
			// menuItemOpen
			// 
			this.menuItemOpen.Index = 1;
			this.menuItemOpen.Text = "&Open";
			this.menuItemOpen.Click += new System.EventHandler(this.menuItemOpen_Click);
			// 
			// menuItemSave
			// 
			this.menuItemSave.Index = 2;
			this.menuItemSave.Text = "&Save";
			this.menuItemSave.Click += new System.EventHandler(this.menuItemSave_Click);
			// 
			// menuItem6
			// 
			this.menuItem6.Index = 3;
			this.menuItem6.Text = "-";
			// 
			// menuItemExit
			// 
			this.menuItemExit.Index = 4;
			this.menuItemExit.Text = "E&xit";
			this.menuItemExit.Click += new System.EventHandler(this.menuItemExit_Click);
			// 
			// saveFileDialog
			// 
			this.saveFileDialog.Filter = "Vb Script|*.vbs";
			// 
			// saveFileDialogsdo
			// 
			this.saveFileDialogsdo.Filter = "SDO files|*.sdo";
			// 
			// saveFileDialogReport
			// 
			this.saveFileDialogReport.Filter = "Report file|*.txt";
			// 
			// saveFileDialogXml
			// 
			this.saveFileDialogXml.Filter = "Export Xml|*.xml";
			// 
			// openFileDialogXml
			// 
			this.openFileDialogXml.Filter = "Export Xml|*.xml";
			// 
			// FormExport
			// 
			this.AutoScaleBaseSize = new System.Drawing.Size(5, 13);
			this.ClientSize = new System.Drawing.Size(568, 393);
			this.Controls.Add(this.buttonGenerate);
			this.Controls.Add(this.buttonBrowse);
			this.Controls.Add(this.labelFileName);
			this.Controls.Add(this.textBoxFileName);
			this.Controls.Add(this.buttonRemove);
			this.Controls.Add(this.listViewChannel);
			this.Controls.Add(this.tabControl);
			this.Icon = ((System.Drawing.Icon)(resources.GetObject("$this.Icon")));
			this.MaximizeBox = false;
			this.Menu = this.mainMenu;
			this.Name = "FormExport";
			this.StartPosition = System.Windows.Forms.FormStartPosition.CenterScreen;
			this.Text = "Incremental Site Deployment Export Script - MCMS Manager";
			this.Closing += new System.ComponentModel.CancelEventHandler(this.FormExport_Closing);
			this.tabControl.ResumeLayout(false);
			this.tabPageItems.ResumeLayout(false);
			this.tabPageType.ResumeLayout(false);
			this.groupBoxServerClient.ResumeLayout(false);
			this.tabPageRights.ResumeLayout(false);
			this.groupBoxAuthentication.ResumeLayout(false);
			this.tabPageOptions.ResumeLayout(false);
			((System.ComponentModel.ISupportInitialize)(this.numericUpDown)).EndInit();
			this.tabPageMore.ResumeLayout(false);
			this.ResumeLayout(false);

		}
		#endregion

		private void menuItemExit_Click(object sender, System.EventArgs e)
		{
			if(isDirty)
			{
				DialogResult result = MessageBox.Show("Do you want to save?","Not saved",MessageBoxButtons.YesNo,MessageBoxIcon.Question);
				if(result == DialogResult.Yes)
				{
					Save();
				}
			}
			isDirty = false;
			this.Close();
		}

		#endregion

		#region Generate Script

		private void FormExport_Closing(object sender, System.ComponentModel.CancelEventArgs e)
		{
			if(isDirty)
			{
				DialogResult result = MessageBox.Show("Do you want to save before exit?","Not saved",MessageBoxButtons.YesNo,MessageBoxIcon.Question);
				if(result == DialogResult.Yes)
				{
					Save();
				}
			}
			cmsApplicationContext.Dispose();
			selectedChannel = null;
		}

		private void radioButtonServer_CheckedChanged(object sender, System.EventArgs e)
		{
			if(radioButtonServer.Checked)
			{
				cmsExport.ScriptType = CmsScriptType.ServerSide;
				this.textBoxServer.Enabled = false;
			}
			else
			{
				cmsExport.ScriptType = CmsScriptType.ClientSide;
				this.textBoxServer.Enabled = true;
			}
			isDirty = true;
		}

		private void radioButtonAuthenticateAsCurrentUser_CheckedChanged(object sender, System.EventArgs e)
		{
			if(!radioButtonAuthenticateAsCurrentUser.Checked)
			{
				this.textBoxUserName.Enabled = true;
				this.textBoxPassword.Enabled = true;
				cmsExport.AuthenticationType = CmsAuthenticationType.AuthenticateAsUser;
			}
			else
			{
				this.textBoxUserName.Enabled = false;
				this.textBoxPassword.Enabled = false;
				cmsExport.AuthenticationType = CmsAuthenticationType.AuthenticateAsCurrentUser;
			}
			isDirty = true;
		}

		private void buttonBrowse_Click(object sender, System.EventArgs e)
		{
			this.saveFileDialog.ShowDialog();
			if(this.saveFileDialog.FileName!="")
			{
				this.textBoxFileName.Text=saveFileDialog.FileName;
				this.saveFileDialog.FileName = "";
				this.buttonGenerate.Enabled = true;
			}
		}

		private void buttonSDO_Click(object sender, System.EventArgs e)
		{
			this.saveFileDialogsdo.ShowDialog();
			if(this.saveFileDialogsdo.FileName!="")
			{
				this.textBoxSDO.Text=saveFileDialogsdo.FileName;
				cmsExport.SDOFilePath = saveFileDialogsdo.FileName;
				this.saveFileDialogsdo.FileName = "";
				isDirty = true;
			}
		}

		private void buttonSDOArchive_Click(object sender, System.EventArgs e)
		{
			this.folderBrowserDialog.ShowDialog();
			if(this.folderBrowserDialog.SelectedPath!="")
			{
				this.textBoxSDOArchive.Text=this.folderBrowserDialog.SelectedPath;
				cmsExport.SDOArchivePath = this.folderBrowserDialog.SelectedPath;
				this.folderBrowserDialog.SelectedPath = "";
				isDirty = true;
			}
		}

		private void buttonReport_Click(object sender, System.EventArgs e)
		{
			this.saveFileDialogReport.ShowDialog();
			if(this.saveFileDialogReport.FileName!="")
			{
				this.textBoxReport.Text=saveFileDialogReport.FileName;
				cmsExport.ReportFilePath = saveFileDialogReport.FileName;
				this.saveFileDialogReport.FileName = "";
				isDirty = true;
			}
		}

		private void buttonGenerate_Click(object sender, System.EventArgs e)
		{
			this.Cursor = Cursors.WaitCursor;
			try
			{
				//Set the script type
				string scriptType = "CmsDeployServer";
				int timeInt = 0;
				try
				{
					timeInt = int.Parse(this.numericUpDown.Value.ToString());
				}
				catch{}
				if(cmsExport.ScriptType==CmsScriptType.ClientSide)
				{
					scriptType = "CmsDeployClient";
				}

				StreamWriter sw = new StreamWriter(this.textBoxFileName.Text);
				ScriptComment sc = new ScriptComment(sw);
				sc.WriteComment();
				sw.WriteLine("Call Export");
				sw.WriteLine("Sub WriteErrorsToFile(reportTime,errorMsg)");
				sw.WriteLine("	Set fs = CreateObject(\"Scripting.FileSystemObject\")");
				sw.WriteLine("	Set ReportFile = fs.OpenTextFile(\""+this.textBoxReport.Text +"\",8,True,0)");
				sw.WriteLine("	ReportFile.WriteLine(\"Export Error @ \" & reportTime & \".\" & vbCrlf & \"Error Message: \" & errorMsg & vbCrlf)");
				sw.WriteLine("End Sub");
				sw.WriteLine("");
				sw.WriteLine("Sub Export");
				sw.WriteLine("	Dim pCmsDeployExport");
				sw.WriteLine("	Dim shell");
				sw.WriteLine("	Dim pExportOptions");
				sw.WriteLine("	Dim pReportTime");
				sw.WriteLine("	Dim pArchiveFileName");
				if(cmsExport.AuthenticationType == CmsAuthenticationType.AuthenticateAsUser)
				{
					sw.WriteLine("	Dim strUserLogon");
					sw.WriteLine("	Dim strUserPwd");
					sw.WriteLine("	strUserLogon = \""+this.textBoxUserName.Text +"\"");
					sw.WriteLine("	strUserPwd = \""+this.textBoxPassword.Text+"\"");
				}
				sw.WriteLine("	On Error Resume Next");
				sw.WriteLine("	Set pCmsDeployExport = CreateObject(\""+ scriptType +".CmsDeployExport.1\")");
				sw.WriteLine("	If ( Err.Number <> 0 ) Then");
				sw.WriteLine("		Call WriteErrorsToFile(now,Err.Description)");
				sw.WriteLine("		Set pCmsDeployExport = Nothing");
				sw.WriteLine("		Exit Sub");
				sw.WriteLine("	End If");
				if(cmsExport.AuthenticationType == CmsAuthenticationType.AuthenticateAsUser)
				{
					if(cmsExport.ScriptType==CmsScriptType.ClientSide)
					{
						sw.WriteLine("	Call pCmsDeployExport.AuthenticateAsUser(\""+this.textBoxServer.Text+"\",strUserLogon,strUserPwd)");
					}
					else
					{
						sw.WriteLine("	Call pCmsDeployExport.AuthenticateAsUser(strUserLogon,strUserPwd)");
					}
				}
				else
				{
					if(cmsExport.ScriptType==CmsScriptType.ClientSide)
					{
						sw.WriteLine("	Call pCmsDeployExport.AuthenticateAsCurrentUser(\""+this.textBoxServer.Text+"\")");
					}
					else
					{
						sw.WriteLine("	Call pCmsDeployExport.AuthenticateAsCurrentUser()");
					}
				}
				sw.WriteLine("	If ( Err.Number <> 0 ) Then");
				sw.WriteLine("		Call WriteErrorsToFile(now,Err.Description)");
				sw.WriteLine("		Set pCmsDeployExport = Nothing");
				sw.WriteLine("		Exit Sub");
				sw.WriteLine("	End If");
				sw.WriteLine("	Set pExportOptions = pCmsDeployExport.Options");
				sw.WriteLine("	If ( Err.Number <> 0 ) Then");
				sw.WriteLine("		Call WriteErrorsToFile(now,Err.Description)");
				sw.WriteLine("		Set pCmsDeployExport = Nothing");
				sw.WriteLine("		Set pExportOptions = Nothing");
				sw.WriteLine("		Exit Sub");
				sw.WriteLine("	End If");
				sw.WriteLine("	pExportOptions.IncludeRightsGroups = "+ (int)cmsExport.RightsGroups);
				sw.WriteLine("	pExportOptions.IncludeCreatedBy = "+(int)cmsExport.CreatedBy);
				sw.WriteLine("	Dim strPackageFileName");
				sw.WriteLine("	Dim strReportUrl");
				sw.WriteLine("	strPackageFileName = \""+this.textBoxSDO.Text+"\"");
				sw.WriteLine("	strReportUrl = pCmsDeployExport.Export(\""+this.textBoxSDO.Text+"\","+timeInt+","+ "\""+cmsExport.ContainerGuid+"\")");
				sw.WriteLine("	If ( Err.Number <> 0 ) Then");
				sw.WriteLine("		Call WriteErrorsToFile(now,Err.Description)");
				sw.WriteLine("		Set pCmsDeployExport = Nothing");
				sw.WriteLine("		Set pExportOptions = Nothing");
				sw.WriteLine("		Exit Sub");
				sw.WriteLine("	End If");
				sw.WriteLine("	pReportTime = now");
				sw.WriteLine("	pReportTime = Replace(pReportTime,\" \",\"-\")");
				sw.WriteLine("	pReportTime = Replace(pReportTime,\"/\",\"-\")");
				sw.WriteLine("	pReportTime = Replace(pReportTime,\":\",\"-\")");
				sw.WriteLine("	Set fs = CreateObject(\"Scripting.FileSystemObject\")");
				sw.WriteLine("	pArchiveFilePath = \""+this.textBoxSDOArchive.Text+"\\\"");
				sw.WriteLine("	pArchiveFileName = \"export_\" & pReportTime & \".sdo\"");
				sw.WriteLine("	Call fs.CopyFile(\""+this.textBoxSDO.Text+"\", pArchiveFilePath & pArchiveFileName)");
				sw.WriteLine("	If (Err.number <> 0 ) Then");
				sw.WriteLine("		Call WriteErrorsToFile(pReportTime,Err.Description)");
				sw.WriteLine("		Set pCmsDeployExport = Nothing");
				sw.WriteLine("		Set pExportOptions = Nothing");
				sw.WriteLine("		Exit Sub");
				sw.WriteLine("	End If");
				sw.WriteLine("	Set ReportFile = fs.OpenTextFile(\""+this.textBoxReport.Text+"\",8,True,0)");
				sw.WriteLine("	ReportFile.WriteLine(\"Export Completed @ \" & pReportTime & \".\" & vbCrlf & \"Report URL: "+ this.textBoxServer.Text +"\" & strReportUrl & vbCrlf)");	
				sw.WriteLine("	Set pCmsDeployExport = Nothing");
				sw.WriteLine("	Set pExportOptions = Nothing");
				sw.WriteLine("	Set pReportTime = Nothing");
				sw.WriteLine("	Set fs = Nothing");
				sw.WriteLine("End Sub");
				sw.Flush();
				sw.Close();
				this.Cursor = Cursors.Default;
				MessageBox.Show("Script generated","Done",MessageBoxButtons.OK,MessageBoxIcon.Information);
			}
			catch(Exception ex)
			{
				this.Cursor = Cursors.Default;
				MessageBox.Show("While generating the script, an error occured. Error - " + ex.ToString(),"Error",MessageBoxButtons.OK,MessageBoxIcon.Error);
			}
			this.Cursor = Cursors.Default;
		}

		private void radioButtonClient_CheckedChanged(object sender, System.EventArgs e)
		{
			if(radioButtonClient.Checked)
			{
				cmsExport.ScriptType = CmsScriptType.ClientSide;
				this.textBoxServer.Enabled = true;
			}
			else
			{
				cmsExport.ScriptType = CmsScriptType.ServerSide;
				this.textBoxServer.Enabled = false;
			}
			isDirty = true;
		}

		private void radioButtonAuthenticateAsUser_CheckedChanged(object sender, System.EventArgs e)
		{
			if(radioButtonAuthenticateAsUser.Checked)
			{
				this.textBoxUserName.Enabled = true;
				this.textBoxPassword.Enabled = true;
				cmsExport.AuthenticationType = CmsAuthenticationType.AuthenticateAsUser;
			}
			else
			{
				this.textBoxUserName.Enabled = false;
				this.textBoxPassword.Enabled = false;
				cmsExport.AuthenticationType = CmsAuthenticationType.AuthenticateAsCurrentUser;
			}
			isDirty = true;
		}

		private void buttonRemove_Click(object sender, System.EventArgs e)
		{
			this.listViewChannel.Items.Clear();
			this.buttonRemove.Enabled = false;
			this.buttonAdd.Enabled = true;
			this.buttonGenerate.Enabled = false;
			isDirty = true;
		}

		private void buttonAdd_Click(object sender, System.EventArgs e)
		{
			Channel c = this.treeViewChannel.SelectedNode.Tag as Channel;
			ListViewItem lv = new ListViewItem(new string[]{c.Name,c.Guid,c.Path});
			lv.Tag = c;
			this.listViewChannel.Items.Add(lv);
			cmsExport.ContainerGuid = c.Guid;
			this.buttonRemove.Enabled = true;
			this.buttonAdd.Enabled = false;
			isDirty = true;
		}

		private void comboboxIncludeCreatedBy_SelectedIndexChanged(object sender, System.EventArgs e)
		{
			cmsExport.CreatedBy = (ExportIncludeCreatedBy)this.comboboxIncludeCreatedBy.SelectedIndex+1;
			isDirty = true;
		}

		private void comboBoxIncludeRightsGroups_SelectedIndexChanged(object sender, System.EventArgs e)
		{
			cmsExport.RightsGroups = (ExportIncludeRightsGroups)this.comboBoxIncludeRightsGroups.SelectedIndex+1;
			isDirty = true;
		}
		private void textBoxUserName_TextChanged(object sender, System.EventArgs e)
		{
			isDirty = true;
		}

		private void textBoxPassword_TextChanged(object sender, System.EventArgs e)
		{
			isDirty = true;
		}

		private void textBoxServer_TextChanged(object sender, System.EventArgs e)
		{
			isDirty = true;
		}

		private void textBoxSDO_TextChanged(object sender, System.EventArgs e)
		{
			isDirty = true;
		}

		private void textBoxSDOArchive_TextChanged(object sender, System.EventArgs e)
		{
			isDirty = true;
		}

		private void textBoxReport_TextChanged(object sender, System.EventArgs e)
		{
			isDirty = true;
		}

		#endregion

		#region Export XML

		private void menuItemNew_Click(object sender, System.EventArgs e)
		{
			if(isDirty)
			{
				DialogResult result = MessageBox.Show("Do you want to save?","Not saved",MessageBoxButtons.YesNo,MessageBoxIcon.Question);
				if(result == DialogResult.Yes)
				{
					Save();
				}
			}
			InitNew();
			isDirty = false;
		}

		private void menuItemSave_Click(object sender, System.EventArgs e)
		{
			if(Save())
			{
				MessageBox.Show("Export Xml file Saved","File Saved",MessageBoxButtons.OK,MessageBoxIcon.Information);
			}
		}

		private bool Save()
		{
			exportDocument.RemoveAll();
			exportDocument.LoadXml("<export>" +
				"<AuthenticationType>"+(int)cmsExport.AuthenticationType+"</AuthenticationType>" +
				"<TimeInterval>"+cmsExport.TimeInterval+"</TimeInterval>" +
				"<SDOFilePath>"+cmsExport.SDOFilePath+"</SDOFilePath>" +
				"<ContainerGuid>"+cmsExport.ContainerGuid+"</ContainerGuid>" +
				"<ServerUrl>"+this.textBoxServer.Text+"</ServerUrl>" +
				"<ReportFilePath>"+cmsExport.ReportFilePath+"</ReportFilePath>" +
				"<SDOArchivePath>"+cmsExport.SDOArchivePath+"</SDOArchivePath>" +
				"<ScriptType>"+(int)cmsExport.ScriptType+"</ScriptType>" +
				"<CreatedBy>"+(int)cmsExport.CreatedBy+"</CreatedBy>" +
				"<RightsGroups>"+(int)cmsExport.RightsGroups+"</RightsGroups>" +
				"<UserName>"+this.textBoxUserName.Text+"</UserName>" +
				"<Password>"+this.textBoxPassword.Text+"</Password>" +
				"<ScriptFile>"+this.textBoxFileName.Text+"</ScriptFile>" +
				"</export>");
			if(!isOpened)
			{
				saveFileDialogXml.ShowDialog();
				if(saveFileDialogXml.FileName!="")
				{
					try
					{
						exportDocument.Save(saveFileDialogXml.FileName);
						isDirty = false;
						isOpened = true;
						return true;
					}
					catch(Exception ex)
					{
						MessageBox.Show("While trying to save the document, an error occured. Error - "+ex.ToString(),"Error",MessageBoxButtons.OK,MessageBoxIcon.Error);
					}
				}
			}
			else
			{
				try
				{
					if(openFileDialogXml.FileName!="")
					{
						exportDocument.Save(openFileDialogXml.FileName);
					}
					else
					{
						exportDocument.Save(saveFileDialog.FileName);
					}
					isDirty = false;
					isOpened = true;
					return true;
				}
				catch(Exception ex)
				{
					MessageBox.Show("While trying to save the document, an error occured. Error - "+ex.ToString(),"Error",MessageBoxButtons.OK,MessageBoxIcon.Error);
				}
			}
			return false;
		}

		private void menuItemOpen_Click(object sender, System.EventArgs e)
		{
			if(isDirty)
			{
				DialogResult result = MessageBox.Show("Do you want to save?","Not saved",MessageBoxButtons.YesNo,MessageBoxIcon.Question);
				if(result == DialogResult.Yes)
				{
					Save();
				}
			}
			InitOpen();
			isOpened = true;
		}

		#endregion

	}
}
