/**
 * @file FormImport.cs
 *
 * MCMS Manager
 *
 * MCMS Manager is the legal property of its developer
 * Chester Ragel <chesterr@gmail.com> - Developer and Maintainer
 * Yahoo ID : chesterr1979 
 * MSN : chesterr79@hotmail.com
 *
 * If you want more information, found any bugs or have any doubts you 
 * can mail me or contact me through my yahoo id.
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2.1 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#region Namespaces
using System;
using System.Drawing;
using System.Collections;
using System.ComponentModel;
using System.Windows.Forms;
using System.Text.RegularExpressions;
using System.IO;
using System.Xml;
//MCMS components
using Microsoft.ContentManagement.Common;
using Microsoft.ContentManagement.Publishing;
#endregion

namespace MCMS
{
	/// <summary>
	/// Summary description for FormImport.
	/// </summary>
	public class FormImport : System.Windows.Forms.Form
	{

		#region Private Controls
		private System.Windows.Forms.TabControl tabControl;
		private System.Windows.Forms.TabPage tabPageRights;
		private System.Windows.Forms.TabPage tabPageType;
		private System.Windows.Forms.TabPage tabPageOptions;
		private System.Windows.Forms.Label labelFileName;
		private System.Windows.Forms.TextBox textBoxFileName;
		private System.Windows.Forms.GroupBox groupBoxServerClient;
		private System.Windows.Forms.Label labelClient2;
		private System.Windows.Forms.Label labelClient1;
		private System.Windows.Forms.Label labelServer;
		private System.Windows.Forms.RadioButton radioButtonServer;
		private System.Windows.Forms.RadioButton radioButtonClient;
		private System.Windows.Forms.Button buttonBrowse;
		private System.Windows.Forms.Button buttonGenerate;
		private System.Windows.Forms.GroupBox groupBoxAuthentication;
		private System.Windows.Forms.Label labelPassword;
		private System.Windows.Forms.TextBox textBoxUserName;
		private System.Windows.Forms.Label labelUserName;
		private System.Windows.Forms.Label label1;
		private System.Windows.Forms.Label label6;
		private System.Windows.Forms.RadioButton radioButtonAuthenticateAsCurrentUser;
		private System.Windows.Forms.RadioButton radioButtonAuthenticateAsUser;
		private System.Windows.Forms.ComboBox comboBoxRightsOnReplace;
		private System.Windows.Forms.Label labelRightsOnReplace;
		private System.Windows.Forms.Label labelRightsOnAdd;
		private System.Windows.Forms.Label labelIncludeRightsGroups;
		private System.Windows.Forms.Label labelIncludeCreatedBy;
		private System.Windows.Forms.ComboBox comboBoxRightsOnAdd;
		private System.Windows.Forms.ComboBox comboBoxIncludeRightsGroups;
		private System.Windows.Forms.ComboBox comboBoxIncludeCreatedBy;
		private System.Windows.Forms.Label label;
		private System.Windows.Forms.Label label2;
		private System.Windows.Forms.Label label3;
		private System.Windows.Forms.Label label4;
		private System.Windows.Forms.MenuItem menuItem4;
		private System.Windows.Forms.MenuItem menuItemFile;
		private System.Windows.Forms.MenuItem menuItemOpen;
		private System.Windows.Forms.MenuItem menuItemSave;
		private System.Windows.Forms.MenuItem menuItemExit;
		private System.Windows.Forms.MenuItem menuItemNew;
		private System.Windows.Forms.MainMenu mainMenu;
		private System.Windows.Forms.Label label9;
		private System.Windows.Forms.Label label7;
		private System.Windows.Forms.Label labelSDO;
		private System.Windows.Forms.Button buttonSDO;
		private System.Windows.Forms.TextBox textBoxSDO;
		private System.Windows.Forms.Label labelReport;
		private System.Windows.Forms.Button buttonReport;
		private System.Windows.Forms.TextBox textBoxReport;
		private System.Windows.Forms.TabPage tabPageMore;
		private System.Windows.Forms.Label labelServerUrl;
		private System.Windows.Forms.TextBox textBoxServer;
		private System.Windows.Forms.SaveFileDialog saveFileDialog;
		private System.Windows.Forms.FolderBrowserDialog folderBrowserDialog;
		private System.Windows.Forms.SaveFileDialog saveFileDialogXml;
		private System.Windows.Forms.OpenFileDialog openFileDialogXml;
		private System.Windows.Forms.SaveFileDialog saveFileDialogReport;
		private System.Windows.Forms.TextBox textBoxPassword;
		/// <summary>
		/// Required designer variable.
		/// </summary>
		private System.ComponentModel.Container components = null;
		#endregion

		#region Private Variables
		
		private bool isDirty = false;
		private bool isOpened = false;
		private CmsImport cmsImport = new CmsImport();
		private XmlDocument importDocument;
		private System.Windows.Forms.OpenFileDialog saveFileDialogsdo;

		private CmsApplicationContext cmsApplicationContext = new CmsApplicationContext();

		#endregion

		#region Init/Dispose
		public FormImport()
		{
			InitializeComponent();
			Init();
			InitNew();
		}

		/// <summary>
		/// Clean up any resources being used.
		/// </summary>
		protected override void Dispose( bool disposing )
		{
			if( disposing )
			{
				if(components != null)
				{
					components.Dispose();
				}
			}
			base.Dispose( disposing );
		}

		private void textBoxUserName_TextChanged(object sender, System.EventArgs e)
		{
			isDirty = true;
		}

		private void textBoxPassword_TextChanged(object sender, System.EventArgs e)
		{
			isDirty = true;
		}


		#region Windows Form Designer generated code
		/// <summary>
		/// Required method for Designer support - do not modify
		/// the contents of this method with the code editor.
		/// </summary>
		private void InitializeComponent()
		{
			System.Resources.ResourceManager resources = new System.Resources.ResourceManager(typeof(FormImport));
			this.tabControl = new System.Windows.Forms.TabControl();
			this.tabPageRights = new System.Windows.Forms.TabPage();
			this.groupBoxAuthentication = new System.Windows.Forms.GroupBox();
			this.textBoxPassword = new System.Windows.Forms.TextBox();
			this.labelPassword = new System.Windows.Forms.Label();
			this.textBoxUserName = new System.Windows.Forms.TextBox();
			this.labelUserName = new System.Windows.Forms.Label();
			this.label1 = new System.Windows.Forms.Label();
			this.label6 = new System.Windows.Forms.Label();
			this.radioButtonAuthenticateAsCurrentUser = new System.Windows.Forms.RadioButton();
			this.radioButtonAuthenticateAsUser = new System.Windows.Forms.RadioButton();
			this.tabPageType = new System.Windows.Forms.TabPage();
			this.groupBoxServerClient = new System.Windows.Forms.GroupBox();
			this.labelServerUrl = new System.Windows.Forms.Label();
			this.textBoxServer = new System.Windows.Forms.TextBox();
			this.labelClient2 = new System.Windows.Forms.Label();
			this.labelClient1 = new System.Windows.Forms.Label();
			this.labelServer = new System.Windows.Forms.Label();
			this.radioButtonServer = new System.Windows.Forms.RadioButton();
			this.radioButtonClient = new System.Windows.Forms.RadioButton();
			this.tabPageOptions = new System.Windows.Forms.TabPage();
			this.label4 = new System.Windows.Forms.Label();
			this.label3 = new System.Windows.Forms.Label();
			this.label2 = new System.Windows.Forms.Label();
			this.label = new System.Windows.Forms.Label();
			this.comboBoxRightsOnReplace = new System.Windows.Forms.ComboBox();
			this.comboBoxRightsOnAdd = new System.Windows.Forms.ComboBox();
			this.comboBoxIncludeRightsGroups = new System.Windows.Forms.ComboBox();
			this.comboBoxIncludeCreatedBy = new System.Windows.Forms.ComboBox();
			this.labelRightsOnReplace = new System.Windows.Forms.Label();
			this.labelRightsOnAdd = new System.Windows.Forms.Label();
			this.labelIncludeRightsGroups = new System.Windows.Forms.Label();
			this.labelIncludeCreatedBy = new System.Windows.Forms.Label();
			this.tabPageMore = new System.Windows.Forms.TabPage();
			this.label9 = new System.Windows.Forms.Label();
			this.label7 = new System.Windows.Forms.Label();
			this.labelSDO = new System.Windows.Forms.Label();
			this.buttonSDO = new System.Windows.Forms.Button();
			this.textBoxSDO = new System.Windows.Forms.TextBox();
			this.labelReport = new System.Windows.Forms.Label();
			this.buttonReport = new System.Windows.Forms.Button();
			this.textBoxReport = new System.Windows.Forms.TextBox();
			this.labelFileName = new System.Windows.Forms.Label();
			this.textBoxFileName = new System.Windows.Forms.TextBox();
			this.buttonBrowse = new System.Windows.Forms.Button();
			this.buttonGenerate = new System.Windows.Forms.Button();
			this.mainMenu = new System.Windows.Forms.MainMenu();
			this.menuItemFile = new System.Windows.Forms.MenuItem();
			this.menuItemNew = new System.Windows.Forms.MenuItem();
			this.menuItemOpen = new System.Windows.Forms.MenuItem();
			this.menuItemSave = new System.Windows.Forms.MenuItem();
			this.menuItem4 = new System.Windows.Forms.MenuItem();
			this.menuItemExit = new System.Windows.Forms.MenuItem();
			this.saveFileDialog = new System.Windows.Forms.SaveFileDialog();
			this.folderBrowserDialog = new System.Windows.Forms.FolderBrowserDialog();
			this.saveFileDialogXml = new System.Windows.Forms.SaveFileDialog();
			this.openFileDialogXml = new System.Windows.Forms.OpenFileDialog();
			this.saveFileDialogReport = new System.Windows.Forms.SaveFileDialog();
			this.saveFileDialogsdo = new System.Windows.Forms.OpenFileDialog();
			this.tabControl.SuspendLayout();
			this.tabPageRights.SuspendLayout();
			this.groupBoxAuthentication.SuspendLayout();
			this.tabPageType.SuspendLayout();
			this.groupBoxServerClient.SuspendLayout();
			this.tabPageOptions.SuspendLayout();
			this.tabPageMore.SuspendLayout();
			this.SuspendLayout();
			// 
			// tabControl
			// 
			this.tabControl.Controls.Add(this.tabPageRights);
			this.tabControl.Controls.Add(this.tabPageType);
			this.tabControl.Controls.Add(this.tabPageOptions);
			this.tabControl.Controls.Add(this.tabPageMore);
			this.tabControl.Dock = System.Windows.Forms.DockStyle.Top;
			this.tabControl.Location = new System.Drawing.Point(0, 0);
			this.tabControl.Name = "tabControl";
			this.tabControl.SelectedIndex = 0;
			this.tabControl.Size = new System.Drawing.Size(544, 320);
			this.tabControl.TabIndex = 0;
			// 
			// tabPageRights
			// 
			this.tabPageRights.Controls.Add(this.groupBoxAuthentication);
			this.tabPageRights.Location = new System.Drawing.Point(4, 22);
			this.tabPageRights.Name = "tabPageRights";
			this.tabPageRights.Size = new System.Drawing.Size(536, 294);
			this.tabPageRights.TabIndex = 0;
			this.tabPageRights.Text = "Authentication";
			// 
			// groupBoxAuthentication
			// 
			this.groupBoxAuthentication.Controls.Add(this.textBoxPassword);
			this.groupBoxAuthentication.Controls.Add(this.labelPassword);
			this.groupBoxAuthentication.Controls.Add(this.textBoxUserName);
			this.groupBoxAuthentication.Controls.Add(this.labelUserName);
			this.groupBoxAuthentication.Controls.Add(this.label1);
			this.groupBoxAuthentication.Controls.Add(this.label6);
			this.groupBoxAuthentication.Controls.Add(this.radioButtonAuthenticateAsCurrentUser);
			this.groupBoxAuthentication.Controls.Add(this.radioButtonAuthenticateAsUser);
			this.groupBoxAuthentication.Location = new System.Drawing.Point(8, 8);
			this.groupBoxAuthentication.Name = "groupBoxAuthentication";
			this.groupBoxAuthentication.Size = new System.Drawing.Size(520, 280);
			this.groupBoxAuthentication.TabIndex = 0;
			this.groupBoxAuthentication.TabStop = false;
			this.groupBoxAuthentication.Text = "Authentication Type";
			// 
			// textBoxPassword
			// 
			this.textBoxPassword.Location = new System.Drawing.Point(168, 232);
			this.textBoxPassword.Name = "textBoxPassword";
			this.textBoxPassword.PasswordChar = '*';
			this.textBoxPassword.Size = new System.Drawing.Size(168, 20);
			this.textBoxPassword.TabIndex = 3;
			this.textBoxPassword.Text = "";
			this.textBoxPassword.TextChanged += new System.EventHandler(this.textBoxPassword_TextChanged);
			// 
			// labelPassword
			// 
			this.labelPassword.Location = new System.Drawing.Point(16, 232);
			this.labelPassword.Name = "labelPassword";
			this.labelPassword.TabIndex = 7;
			this.labelPassword.Text = "Password";
			// 
			// textBoxUserName
			// 
			this.textBoxUserName.Location = new System.Drawing.Point(168, 192);
			this.textBoxUserName.Name = "textBoxUserName";
			this.textBoxUserName.Size = new System.Drawing.Size(240, 20);
			this.textBoxUserName.TabIndex = 2;
			this.textBoxUserName.Text = "";
			this.textBoxUserName.TextChanged += new System.EventHandler(this.textBoxUserName_TextChanged);
			// 
			// labelUserName
			// 
			this.labelUserName.Location = new System.Drawing.Point(16, 192);
			this.labelUserName.Name = "labelUserName";
			this.labelUserName.Size = new System.Drawing.Size(160, 40);
			this.labelUserName.TabIndex = 5;
			this.labelUserName.Text = "User Name (WinNT://domain/username)";
			// 
			// label1
			// 
			this.label1.Location = new System.Drawing.Point(16, 144);
			this.label1.Name = "label1";
			this.label1.Size = new System.Drawing.Size(464, 40);
			this.label1.TabIndex = 4;
			this.label1.Text = "Establishes the specified user account as the account to use for an upcoming expo" +
				"rt operation.";
			// 
			// label6
			// 
			this.label6.Location = new System.Drawing.Point(16, 64);
			this.label6.Name = "label6";
			this.label6.Size = new System.Drawing.Size(496, 32);
			this.label6.TabIndex = 3;
			this.label6.Text = "Establishes the user account under which the script is running as the account to " +
				"use for an upcoming export operation.";
			// 
			// radioButtonAuthenticateAsCurrentUser
			// 
			this.radioButtonAuthenticateAsCurrentUser.Location = new System.Drawing.Point(16, 32);
			this.radioButtonAuthenticateAsCurrentUser.Name = "radioButtonAuthenticateAsCurrentUser";
			this.radioButtonAuthenticateAsCurrentUser.Size = new System.Drawing.Size(160, 24);
			this.radioButtonAuthenticateAsCurrentUser.TabIndex = 0;
			this.radioButtonAuthenticateAsCurrentUser.Text = "AuthenticateAsCurrentUser";
			this.radioButtonAuthenticateAsCurrentUser.CheckedChanged += new System.EventHandler(this.radioButtonAuthenticateAsCurrentUser_CheckedChanged);
			// 
			// radioButtonAuthenticateAsUser
			// 
			this.radioButtonAuthenticateAsUser.Location = new System.Drawing.Point(16, 112);
			this.radioButtonAuthenticateAsUser.Name = "radioButtonAuthenticateAsUser";
			this.radioButtonAuthenticateAsUser.Size = new System.Drawing.Size(192, 24);
			this.radioButtonAuthenticateAsUser.TabIndex = 1;
			this.radioButtonAuthenticateAsUser.Text = "AuthenticateAsUser";
			this.radioButtonAuthenticateAsUser.CheckedChanged += new System.EventHandler(this.radioButtonAuthenticateAsUser_CheckedChanged);
			// 
			// tabPageType
			// 
			this.tabPageType.Controls.Add(this.groupBoxServerClient);
			this.tabPageType.Location = new System.Drawing.Point(4, 22);
			this.tabPageType.Name = "tabPageType";
			this.tabPageType.Size = new System.Drawing.Size(536, 294);
			this.tabPageType.TabIndex = 1;
			this.tabPageType.Text = "Script Type";
			// 
			// groupBoxServerClient
			// 
			this.groupBoxServerClient.Controls.Add(this.labelServerUrl);
			this.groupBoxServerClient.Controls.Add(this.textBoxServer);
			this.groupBoxServerClient.Controls.Add(this.labelClient2);
			this.groupBoxServerClient.Controls.Add(this.labelClient1);
			this.groupBoxServerClient.Controls.Add(this.labelServer);
			this.groupBoxServerClient.Controls.Add(this.radioButtonServer);
			this.groupBoxServerClient.Controls.Add(this.radioButtonClient);
			this.groupBoxServerClient.Location = new System.Drawing.Point(16, 16);
			this.groupBoxServerClient.Name = "groupBoxServerClient";
			this.groupBoxServerClient.Size = new System.Drawing.Size(504, 264);
			this.groupBoxServerClient.TabIndex = 4;
			this.groupBoxServerClient.TabStop = false;
			this.groupBoxServerClient.Text = "Client Site / Server Site";
			// 
			// labelServerUrl
			// 
			this.labelServerUrl.Location = new System.Drawing.Point(48, 216);
			this.labelServerUrl.Name = "labelServerUrl";
			this.labelServerUrl.Size = new System.Drawing.Size(64, 23);
			this.labelServerUrl.TabIndex = 10;
			this.labelServerUrl.Text = "Server URL";
			// 
			// textBoxServer
			// 
			this.textBoxServer.Location = new System.Drawing.Point(128, 216);
			this.textBoxServer.Name = "textBoxServer";
			this.textBoxServer.Size = new System.Drawing.Size(208, 20);
			this.textBoxServer.TabIndex = 9;
			this.textBoxServer.Text = "";
			this.textBoxServer.TextChanged += new System.EventHandler(this.textBoxServer_TextChanged);
			// 
			// labelClient2
			// 
			this.labelClient2.Location = new System.Drawing.Point(16, 184);
			this.labelClient2.Name = "labelClient2";
			this.labelClient2.Size = new System.Drawing.Size(456, 23);
			this.labelClient2.TabIndex = 6;
			this.labelClient2.Text = "Access between server and client is provided using the HTTP or HTTPS protocol. ";
			// 
			// labelClient1
			// 
			this.labelClient1.Location = new System.Drawing.Point(16, 144);
			this.labelClient1.Name = "labelClient1";
			this.labelClient1.Size = new System.Drawing.Size(440, 32);
			this.labelClient1.TabIndex = 5;
			this.labelClient1.Text = "The client-side objects of the site deployment API are intended for use in script" +
				"s running remotely on an MCMS client. ";
			// 
			// labelServer
			// 
			this.labelServer.Location = new System.Drawing.Point(16, 56);
			this.labelServer.Name = "labelServer";
			this.labelServer.Size = new System.Drawing.Size(464, 40);
			this.labelServer.TabIndex = 4;
			this.labelServer.Text = "The server-side objects of the site deployment API are intended for use in script" +
				"s running locally on an MCMS server. ";
			// 
			// radioButtonServer
			// 
			this.radioButtonServer.Location = new System.Drawing.Point(16, 24);
			this.radioButtonServer.Name = "radioButtonServer";
			this.radioButtonServer.Size = new System.Drawing.Size(152, 32);
			this.radioButtonServer.TabIndex = 0;
			this.radioButtonServer.Text = "Server-side";
			this.radioButtonServer.CheckedChanged += new System.EventHandler(this.radioButtonServer_CheckedChanged);
			// 
			// radioButtonClient
			// 
			this.radioButtonClient.Location = new System.Drawing.Point(16, 112);
			this.radioButtonClient.Name = "radioButtonClient";
			this.radioButtonClient.TabIndex = 2;
			this.radioButtonClient.Text = "Client-side";
			this.radioButtonClient.CheckedChanged += new System.EventHandler(this.radioButtonClient_CheckedChanged);
			// 
			// tabPageOptions
			// 
			this.tabPageOptions.Controls.Add(this.label4);
			this.tabPageOptions.Controls.Add(this.label3);
			this.tabPageOptions.Controls.Add(this.label2);
			this.tabPageOptions.Controls.Add(this.label);
			this.tabPageOptions.Controls.Add(this.comboBoxRightsOnReplace);
			this.tabPageOptions.Controls.Add(this.comboBoxRightsOnAdd);
			this.tabPageOptions.Controls.Add(this.comboBoxIncludeRightsGroups);
			this.tabPageOptions.Controls.Add(this.comboBoxIncludeCreatedBy);
			this.tabPageOptions.Controls.Add(this.labelRightsOnReplace);
			this.tabPageOptions.Controls.Add(this.labelRightsOnAdd);
			this.tabPageOptions.Controls.Add(this.labelIncludeRightsGroups);
			this.tabPageOptions.Controls.Add(this.labelIncludeCreatedBy);
			this.tabPageOptions.Location = new System.Drawing.Point(4, 22);
			this.tabPageOptions.Name = "tabPageOptions";
			this.tabPageOptions.Size = new System.Drawing.Size(536, 294);
			this.tabPageOptions.TabIndex = 2;
			this.tabPageOptions.Text = "Import Options";
			// 
			// label4
			// 
			this.label4.Location = new System.Drawing.Point(16, 256);
			this.label4.Name = "label4";
			this.label4.Size = new System.Drawing.Size(504, 32);
			this.label4.TabIndex = 11;
			this.label4.Text = "Gets or sets a value that specifies how rights are established for containers rep" +
				"laced during an import operation.";
			// 
			// label3
			// 
			this.label3.Location = new System.Drawing.Point(16, 176);
			this.label3.Name = "label3";
			this.label3.Size = new System.Drawing.Size(504, 40);
			this.label3.TabIndex = 10;
			this.label3.Text = "Gets or sets a value that specifies how rights are established for containers add" +
				"ed during an import operation.";
			// 
			// label2
			// 
			this.label2.Location = new System.Drawing.Point(16, 112);
			this.label2.Name = "label2";
			this.label2.Size = new System.Drawing.Size(504, 32);
			this.label2.TabIndex = 9;
			this.label2.Text = "Gets or sets a value that specifies how rights groups and user lists are establis" +
				"hed during an import operation.";
			// 
			// label
			// 
			this.label.Location = new System.Drawing.Point(16, 40);
			this.label.Name = "label";
			this.label.Size = new System.Drawing.Size(504, 40);
			this.label.TabIndex = 8;
			this.label.Text = "Gets or sets a value that specifies how information about who created an object i" +
				"s to be set during an import operation.";
			// 
			// comboBoxRightsOnReplace
			// 
			this.comboBoxRightsOnReplace.DropDownStyle = System.Windows.Forms.ComboBoxStyle.DropDownList;
			this.comboBoxRightsOnReplace.Location = new System.Drawing.Point(208, 224);
			this.comboBoxRightsOnReplace.Name = "comboBoxRightsOnReplace";
			this.comboBoxRightsOnReplace.Size = new System.Drawing.Size(312, 21);
			this.comboBoxRightsOnReplace.TabIndex = 7;
			this.comboBoxRightsOnReplace.SelectedIndexChanged += new System.EventHandler(this.comboBoxRightsOnReplace_SelectedIndexChanged);
			// 
			// comboBoxRightsOnAdd
			// 
			this.comboBoxRightsOnAdd.DropDownStyle = System.Windows.Forms.ComboBoxStyle.DropDownList;
			this.comboBoxRightsOnAdd.Location = new System.Drawing.Point(208, 152);
			this.comboBoxRightsOnAdd.Name = "comboBoxRightsOnAdd";
			this.comboBoxRightsOnAdd.Size = new System.Drawing.Size(312, 21);
			this.comboBoxRightsOnAdd.TabIndex = 5;
			this.comboBoxRightsOnAdd.SelectedIndexChanged += new System.EventHandler(this.comboBoxRightsOnAdd_SelectedIndexChanged);
			// 
			// comboBoxIncludeRightsGroups
			// 
			this.comboBoxIncludeRightsGroups.DropDownStyle = System.Windows.Forms.ComboBoxStyle.DropDownList;
			this.comboBoxIncludeRightsGroups.Location = new System.Drawing.Point(208, 88);
			this.comboBoxIncludeRightsGroups.Name = "comboBoxIncludeRightsGroups";
			this.comboBoxIncludeRightsGroups.Size = new System.Drawing.Size(312, 21);
			this.comboBoxIncludeRightsGroups.TabIndex = 3;
			this.comboBoxIncludeRightsGroups.SelectedIndexChanged += new System.EventHandler(this.comboBoxIncludeRightsGroups_SelectedIndexChanged);
			// 
			// comboBoxIncludeCreatedBy
			// 
			this.comboBoxIncludeCreatedBy.DropDownStyle = System.Windows.Forms.ComboBoxStyle.DropDownList;
			this.comboBoxIncludeCreatedBy.Location = new System.Drawing.Point(208, 16);
			this.comboBoxIncludeCreatedBy.Name = "comboBoxIncludeCreatedBy";
			this.comboBoxIncludeCreatedBy.Size = new System.Drawing.Size(312, 21);
			this.comboBoxIncludeCreatedBy.TabIndex = 1;
			this.comboBoxIncludeCreatedBy.SelectedIndexChanged += new System.EventHandler(this.comboBoxIncludeCreatedBy_SelectedIndexChanged);
			// 
			// labelRightsOnReplace
			// 
			this.labelRightsOnReplace.Location = new System.Drawing.Point(16, 224);
			this.labelRightsOnReplace.Name = "labelRightsOnReplace";
			this.labelRightsOnReplace.Size = new System.Drawing.Size(136, 23);
			this.labelRightsOnReplace.TabIndex = 6;
			this.labelRightsOnReplace.Text = "RightsOnReplace ";
			// 
			// labelRightsOnAdd
			// 
			this.labelRightsOnAdd.Location = new System.Drawing.Point(16, 152);
			this.labelRightsOnAdd.Name = "labelRightsOnAdd";
			this.labelRightsOnAdd.Size = new System.Drawing.Size(152, 23);
			this.labelRightsOnAdd.TabIndex = 4;
			this.labelRightsOnAdd.Text = "RightsOnAdd";
			// 
			// labelIncludeRightsGroups
			// 
			this.labelIncludeRightsGroups.Location = new System.Drawing.Point(16, 88);
			this.labelIncludeRightsGroups.Name = "labelIncludeRightsGroups";
			this.labelIncludeRightsGroups.Size = new System.Drawing.Size(152, 23);
			this.labelIncludeRightsGroups.TabIndex = 2;
			this.labelIncludeRightsGroups.Text = "IncludeRightsGroups";
			// 
			// labelIncludeCreatedBy
			// 
			this.labelIncludeCreatedBy.Location = new System.Drawing.Point(16, 16);
			this.labelIncludeCreatedBy.Name = "labelIncludeCreatedBy";
			this.labelIncludeCreatedBy.Size = new System.Drawing.Size(104, 23);
			this.labelIncludeCreatedBy.TabIndex = 0;
			this.labelIncludeCreatedBy.Text = "IncludeCreatedBy";
			// 
			// tabPageMore
			// 
			this.tabPageMore.Controls.Add(this.label9);
			this.tabPageMore.Controls.Add(this.label7);
			this.tabPageMore.Controls.Add(this.labelSDO);
			this.tabPageMore.Controls.Add(this.buttonSDO);
			this.tabPageMore.Controls.Add(this.textBoxSDO);
			this.tabPageMore.Controls.Add(this.labelReport);
			this.tabPageMore.Controls.Add(this.buttonReport);
			this.tabPageMore.Controls.Add(this.textBoxReport);
			this.tabPageMore.Location = new System.Drawing.Point(4, 22);
			this.tabPageMore.Name = "tabPageMore";
			this.tabPageMore.Size = new System.Drawing.Size(536, 294);
			this.tabPageMore.TabIndex = 3;
			this.tabPageMore.Text = "More Options";
			// 
			// label9
			// 
			this.label9.Location = new System.Drawing.Point(8, 168);
			this.label9.Name = "label9";
			this.label9.Size = new System.Drawing.Size(512, 32);
			this.label9.TabIndex = 31;
			this.label9.Text = "With the import, a report will be generated (This file will contain the import in" +
				"formation and errors occured which importing).";
			// 
			// label7
			// 
			this.label7.Location = new System.Drawing.Point(8, 64);
			this.label7.Name = "label7";
			this.label7.Size = new System.Drawing.Size(512, 32);
			this.label7.TabIndex = 29;
			this.label7.Text = "Place of the sdo file, where it is placed which should be imported. This is usual" +
				"ly a file on a local machine.";
			// 
			// labelSDO
			// 
			this.labelSDO.Location = new System.Drawing.Point(8, 35);
			this.labelSDO.Name = "labelSDO";
			this.labelSDO.Size = new System.Drawing.Size(96, 16);
			this.labelSDO.TabIndex = 28;
			this.labelSDO.Text = "SDO file";
			// 
			// buttonSDO
			// 
			this.buttonSDO.Location = new System.Drawing.Point(440, 31);
			this.buttonSDO.Name = "buttonSDO";
			this.buttonSDO.TabIndex = 27;
			this.buttonSDO.Text = "Browse...";
			this.buttonSDO.Click += new System.EventHandler(this.buttonSDO_Click);
			// 
			// textBoxSDO
			// 
			this.textBoxSDO.Location = new System.Drawing.Point(120, 32);
			this.textBoxSDO.Name = "textBoxSDO";
			this.textBoxSDO.Size = new System.Drawing.Size(296, 20);
			this.textBoxSDO.TabIndex = 26;
			this.textBoxSDO.Text = "";
			// 
			// labelReport
			// 
			this.labelReport.Location = new System.Drawing.Point(8, 136);
			this.labelReport.Name = "labelReport";
			this.labelReport.Size = new System.Drawing.Size(85, 16);
			this.labelReport.TabIndex = 25;
			this.labelReport.Text = "Report file";
			// 
			// buttonReport
			// 
			this.buttonReport.Location = new System.Drawing.Point(440, 135);
			this.buttonReport.Name = "buttonReport";
			this.buttonReport.TabIndex = 24;
			this.buttonReport.Text = "Browse...";
			this.buttonReport.Click += new System.EventHandler(this.buttonReport_Click);
			// 
			// textBoxReport
			// 
			this.textBoxReport.Location = new System.Drawing.Point(120, 136);
			this.textBoxReport.Name = "textBoxReport";
			this.textBoxReport.Size = new System.Drawing.Size(296, 20);
			this.textBoxReport.TabIndex = 23;
			this.textBoxReport.Text = "";
			// 
			// labelFileName
			// 
			this.labelFileName.Location = new System.Drawing.Point(16, 344);
			this.labelFileName.Name = "labelFileName";
			this.labelFileName.Size = new System.Drawing.Size(120, 23);
			this.labelFileName.TabIndex = 1;
			this.labelFileName.Text = "Import Script Name";
			// 
			// textBoxFileName
			// 
			this.textBoxFileName.Location = new System.Drawing.Point(128, 344);
			this.textBoxFileName.Name = "textBoxFileName";
			this.textBoxFileName.ReadOnly = true;
			this.textBoxFileName.Size = new System.Drawing.Size(240, 20);
			this.textBoxFileName.TabIndex = 1;
			this.textBoxFileName.Text = "";
			// 
			// buttonBrowse
			// 
			this.buttonBrowse.Location = new System.Drawing.Point(378, 342);
			this.buttonBrowse.Name = "buttonBrowse";
			this.buttonBrowse.TabIndex = 2;
			this.buttonBrowse.Text = "Browse...";
			this.buttonBrowse.Click += new System.EventHandler(this.buttonBrowse_Click);
			// 
			// buttonGenerate
			// 
			this.buttonGenerate.Location = new System.Drawing.Point(458, 342);
			this.buttonGenerate.Name = "buttonGenerate";
			this.buttonGenerate.TabIndex = 3;
			this.buttonGenerate.Text = "Generate";
			this.buttonGenerate.Click += new System.EventHandler(this.buttonGenerate_Click);
			// 
			// mainMenu
			// 
			this.mainMenu.MenuItems.AddRange(new System.Windows.Forms.MenuItem[] {
																					 this.menuItemFile});
			// 
			// menuItemFile
			// 
			this.menuItemFile.Index = 0;
			this.menuItemFile.MenuItems.AddRange(new System.Windows.Forms.MenuItem[] {
																						 this.menuItemNew,
																						 this.menuItemOpen,
																						 this.menuItemSave,
																						 this.menuItem4,
																						 this.menuItemExit});
			this.menuItemFile.Text = "&File";
			// 
			// menuItemNew
			// 
			this.menuItemNew.Index = 0;
			this.menuItemNew.Text = "&New";
			this.menuItemNew.Click += new System.EventHandler(this.menuItemNew_Click);
			// 
			// menuItemOpen
			// 
			this.menuItemOpen.Index = 1;
			this.menuItemOpen.Text = "&Open";
			this.menuItemOpen.Click += new System.EventHandler(this.menuItemOpen_Click);
			// 
			// menuItemSave
			// 
			this.menuItemSave.Index = 2;
			this.menuItemSave.Text = "&Save";
			this.menuItemSave.Click += new System.EventHandler(this.menuItemSave_Click);
			// 
			// menuItem4
			// 
			this.menuItem4.Index = 3;
			this.menuItem4.Text = "-";
			// 
			// menuItemExit
			// 
			this.menuItemExit.Index = 4;
			this.menuItemExit.Text = "E&xit";
			this.menuItemExit.Click += new System.EventHandler(this.menuItemExit_Click);
			// 
			// saveFileDialog
			// 
			this.saveFileDialog.Filter = "Vb Script|*.vbs";
			// 
			// saveFileDialogXml
			// 
			this.saveFileDialogXml.Filter = "Import Xml|*.xml";
			// 
			// openFileDialogXml
			// 
			this.openFileDialogXml.Filter = "Import Xml|*.xml";
			// 
			// saveFileDialogReport
			// 
			this.saveFileDialogReport.Filter = "Report file|*.txt";
			// 
			// saveFileDialogsdo
			// 
			this.saveFileDialogsdo.Filter = "SDO files|*.sdo";
			// 
			// FormImport
			// 
			this.AutoScaleBaseSize = new System.Drawing.Size(5, 13);
			this.ClientSize = new System.Drawing.Size(544, 382);
			this.Controls.Add(this.buttonGenerate);
			this.Controls.Add(this.buttonBrowse);
			this.Controls.Add(this.textBoxFileName);
			this.Controls.Add(this.labelFileName);
			this.Controls.Add(this.tabControl);
			this.Icon = ((System.Drawing.Icon)(resources.GetObject("$this.Icon")));
			this.MaximizeBox = false;
			this.Menu = this.mainMenu;
			this.Name = "FormImport";
			this.StartPosition = System.Windows.Forms.FormStartPosition.CenterScreen;
			this.Text = "Incremental Site Deployment Import Script - MCMS Manager";
			this.Closing += new System.ComponentModel.CancelEventHandler(this.FormImport_Closing);
			this.tabControl.ResumeLayout(false);
			this.tabPageRights.ResumeLayout(false);
			this.groupBoxAuthentication.ResumeLayout(false);
			this.tabPageType.ResumeLayout(false);
			this.groupBoxServerClient.ResumeLayout(false);
			this.tabPageOptions.ResumeLayout(false);
			this.tabPageMore.ResumeLayout(false);
			this.ResumeLayout(false);

		}
		#endregion

		private void Init()
		{
			cmsApplicationContext.AuthenticateAsUser(FormMCMSManager.userName,FormMCMSManager.password,PublishingMode.Update);
			this.comboBoxIncludeCreatedBy.Items.Add("CMS_IMPORT_CREATED_BY_CURRENT_USER");
			this.comboBoxIncludeCreatedBy.Items.Add("CMS_IMPORT_CREATED_BY_USE_PACKAGE");
			this.comboBoxIncludeRightsGroups.Items.Add("CMS_IMPORT_RIGHTS_GROUPS_NONE");
			this.comboBoxIncludeRightsGroups.Items.Add("CMS_IMPORT_RIGHTS_GROUP_WITHOUT_MEMBERS");
			this.comboBoxIncludeRightsGroups.Items.Add("CMS_IMPORT_RIGHTS_GROUP_USE_PACKAGE_MEMBERS");
			this.comboBoxRightsOnAdd.Items.Add("CMS_IMPORT_RIGHTS_ON_ADD_NO_RIGHTS");
			this.comboBoxRightsOnAdd.Items.Add("CMS_IMPORT_RIGHTS_ON_ADD_INHERIT_FROM_PARENT");
			this.comboBoxRightsOnAdd.Items.Add("CMS_IMPORT_RIGHTS_ON_ADD_USE_PACKAGE");
			this.comboBoxRightsOnReplace.Items.Add("CMS_IMPORT_RIGHTS_ON_REPLACE_KEEP_EXISTING");
			this.comboBoxRightsOnReplace.Items.Add("CMS_IMPORT_RIGHTS_ON_REPLACE_USE_PACKAGE");
		}
		private void MakeDefault()
		{
			this.radioButtonAuthenticateAsCurrentUser.Checked = true;
			this.textBoxUserName.Enabled = false;
			this.textBoxPassword.Enabled = false;
			this.radioButtonServer.Checked = true;
			this.buttonGenerate.Enabled = false;
			this.textBoxUserName.Text = "";
			this.textBoxPassword.Text = "";
			this.textBoxSDO.Text = "";
			this.textBoxReport.Text = "";
			this.comboBoxIncludeRightsGroups.SelectedIndex = 1;
			this.comboBoxIncludeCreatedBy.SelectedIndex = 0;
			this.comboBoxRightsOnAdd.SelectedIndex = 0;
			this.comboBoxRightsOnReplace.SelectedIndex = 1;
			this.textBoxServer.Text = FormMCMSManager.serverName;
			isOpened = false;
		}

		private void textBoxServer_TextChanged(object sender, System.EventArgs e)
		{
			isDirty = true;
		}

		#endregion

		#region Script Generation

		private void FormImport_Closing(object sender, System.ComponentModel.CancelEventArgs e)
		{
			if(isDirty)
			{
				DialogResult result = MessageBox.Show("Do you want to save before exit?","Not saved",MessageBoxButtons.YesNo,MessageBoxIcon.Question);
				if(result == DialogResult.Yes)
				{
					Save();
				}
			}
			cmsApplicationContext.Dispose();
		}

		private void buttonGenerate_Click(object sender, System.EventArgs e)
		{
			this.Cursor = Cursors.WaitCursor;
			try
			{
				//Set the script type
				string scriptType = "CmsDeployServer";
				if(cmsImport.ScriptType==CmsScriptType.ClientSide)
				{
					scriptType = "CmsDeployClient";
				}

				StreamWriter sw = new StreamWriter(this.textBoxFileName.Text);
				ScriptComment sc = new ScriptComment(sw);
				sc.WriteComment();
				sw.WriteLine("Dim strImportFile");
				sw.WriteLine("strImportFile = \""+cmsImport.SDOFilePath+"\"");
				sw.WriteLine("Set fso = WScript.CreateObject(\"Scripting.FileSystemObject\")");
				sw.WriteLine("If(fso.FileExists(strImportFile))Then");
				sw.WriteLine("	Call Import(strImportFile)");
				sw.WriteLine("Else");
				sw.WriteLine("	Call WriteErrorsToFile(now,\"The import file \"\"\" & strImportFile & \"\"\" does not exist.\")");
				sw.WriteLine("End If");
				sw.WriteLine("Sub WriteErrorsToFile(reportTime,ErrorMsg)");
				sw.WriteLine("	Set fs = CreateObject(\"Scripting.FileSystemObject\")");
				sw.WriteLine("	Set ReportFile = fs.OpenTextFile(\""+this.textBoxReport.Text +"\",8,True,0)");
				sw.WriteLine("	ReportFile.WriteLine(\"Import Error @ \" & reportTime & \".\" & vbCrlf & \"Error Message: \" & errorMsg & vbCrlf)");
				sw.WriteLine("End Sub");
				sw.WriteLine("");
				sw.WriteLine("Sub Import(strImportFile)");
				sw.WriteLine("	Dim pCmsDeployImport");
				sw.WriteLine("	Dim pImportOptions");
				sw.WriteLine("	Dim pReportTime");
				if(cmsImport.AuthenticationType == CmsAuthenticationType.AuthenticateAsUser)
				{
					sw.WriteLine("	Dim strUserLogon");
					sw.WriteLine("	Dim strUserPwd");
					sw.WriteLine("	strUserLogon = \""+this.textBoxUserName.Text +"\"");
					sw.WriteLine("	strUserPwd = \""+this.textBoxPassword.Text+"\"");
				}
				sw.WriteLine("	On Error Resume Next");
				sw.WriteLine("	Set pCmsDeployImport = CreateObject(\""+ scriptType +".CmsDeployImport.1\")");
				sw.WriteLine("	If ( Err.Number <> 0 ) Then");
				sw.WriteLine("		Call WriteErrorsToFile(now,Err.Description)");
				sw.WriteLine("		Set pCmsDeployImport = Nothing");
				sw.WriteLine("		Exit Sub");
				sw.WriteLine("	End If");
				if(cmsImport.AuthenticationType == CmsAuthenticationType.AuthenticateAsUser)
				{
					if(cmsImport.ScriptType==CmsScriptType.ClientSide)
					{
						sw.WriteLine("	Call pCmsDeployImport.AuthenticateAsUser(\""+this.textBoxServer.Text+"\",strUserLogon,strUserPwd)");
					}
					else
					{
						sw.WriteLine("	Call pCmsDeployImport.AuthenticateAsUser(strUserLogon,strUserPwd)");
					}
				}
				else
				{
					if(cmsImport.ScriptType==CmsScriptType.ClientSide)
					{
						sw.WriteLine("	Call pCmsDeployImport.AuthenticateAsCurrentUser(\""+this.textBoxServer.Text+"\")");
					}
					else
					{
						sw.WriteLine("	Call pCmsDeployImport.AuthenticateAsCurrentUser()");
					}
				}
				sw.WriteLine("	If ( Err.Number <> 0 ) Then");
				sw.WriteLine("		Call WriteErrorsToFile(now,Err.Description)");
				sw.WriteLine("		Set pCmsDeployImport = Nothing");
				sw.WriteLine("		Exit Sub");
				sw.WriteLine("	End If");
				sw.WriteLine("	Set pImportOptions = pCmsDeployImport.Options");
				sw.WriteLine("	If ( Err.Number <> 0 ) Then");
				sw.WriteLine("		Call WriteErrorsToFile(now,Err.Description)");
				sw.WriteLine("		Set pCmsDeployImport = Nothing");
				sw.WriteLine("		Set pImportOptions = Nothing");
				sw.WriteLine("		Exit Sub");
				sw.WriteLine("	End If");
				sw.WriteLine("	pImportOptions.IncludeRightsGroups = "+ (int)cmsImport.RightsGroups);
				sw.WriteLine("	pImportOptions.IncludeCreatedBy = "+(int)cmsImport.CreatedBy);
				sw.WriteLine("	pImportOptions.RightsOnAdd = "+ (int)cmsImport.RightsOnAdd);
				sw.WriteLine("	pImportOptions.RightsOnReplace = "+(int)cmsImport.RightsOnReplace);
				sw.WriteLine("	Dim strReportUrl");
				sw.WriteLine("	strReportUrl = pCmsDeployImport.Import(strImportFile)");
				sw.WriteLine("	If ( Err.Number <> 0 ) Then");
				sw.WriteLine("		Call WriteErrorsToFile(now,Err.Description)");
				sw.WriteLine("		Set pCmsDeployImport = Nothing");
				sw.WriteLine("		Set pImportOptions = Nothing");
				sw.WriteLine("		Exit Sub");
				sw.WriteLine("	End If");
				sw.WriteLine("	pReportTime = now");
				sw.WriteLine("	pReportTime = Replace(pReportTime,\" \",\"-\")");
				sw.WriteLine("	pReportTime = Replace(pReportTime,\"/\",\"-\")");
				sw.WriteLine("	pReportTime = Replace(pReportTime,\":\",\"-\")");
				sw.WriteLine("	Set fs = CreateObject(\"Scripting.FileSystemObject\")");
				sw.WriteLine("	Set ReportFile = fs.OpenTextFile(\""+this.textBoxReport.Text+"\",8,True,0)");
				sw.WriteLine("	ReportFile.WriteLine(\"Import Completed @ \" & pReportTime & \".\" & vbCrlf & \"Report URL: "+ this.textBoxServer.Text +"\" & strReportUrl & vbCrlf)");	
				sw.WriteLine("	Set pCmsDeployImport = Nothing");
				sw.WriteLine("	Set pImportOptions = Nothing");
				sw.WriteLine("	Set pReportTime = Nothing");
				sw.WriteLine("	Set fs = Nothing");
				sw.WriteLine("End Sub");
				sw.Flush();
				sw.Close();
				this.Cursor = Cursors.Default;
				MessageBox.Show("Script generated","Done",MessageBoxButtons.OK,MessageBoxIcon.Information);
			}
			catch(Exception ex)
			{
				this.Cursor = Cursors.Default;
				MessageBox.Show("While generating the script, an error occured. Error - " + ex.ToString(),"Error",MessageBoxButtons.OK,MessageBoxIcon.Error);
			}
			this.Cursor = Cursors.Default;
		}

		private void menuItemOpen_Click(object sender, System.EventArgs e)
		{
			if(isDirty)
			{
				DialogResult result = MessageBox.Show("Do you want to save?","Not saved",MessageBoxButtons.YesNo,MessageBoxIcon.Question);
				if(result == DialogResult.Yes)
				{
					Save();
				}
			}
			InitOpen();
			isOpened = true;
		}

		private void InitOpen()
		{
			try
			{
				MakeDefault();
				cmsImport = new CmsImport();
				DialogResult result = openFileDialogXml.ShowDialog();
				if(result==DialogResult.OK)
				{
					importDocument = new XmlDocument();
					importDocument.Load(openFileDialogXml.FileName);
					XmlNodeList ele = importDocument.GetElementsByTagName("AuthenticationType");
					if(ele.Item(0).InnerText=="1")
					{
						cmsImport.AuthenticationType = CmsAuthenticationType.AuthenticateAsCurrentUser;
						this.radioButtonAuthenticateAsCurrentUser.Checked = true;
						this.textBoxUserName.Enabled = false;
						this.textBoxPassword.Enabled = false;
					}
					else
					{
						cmsImport.AuthenticationType = CmsAuthenticationType.AuthenticateAsUser;
						this.radioButtonAuthenticateAsUser.Checked = true;
						this.textBoxUserName.Enabled = true;
						this.textBoxPassword.Enabled = true;
					}
					ele = importDocument.GetElementsByTagName("ScriptType");
					if(ele.Item(0).InnerText=="1")
					{
						cmsImport.ScriptType = CmsScriptType.ServerSide;
						this.radioButtonServer.Checked = true;
					}
					else
					{
						cmsImport.ScriptType = CmsScriptType.ClientSide;
						this.radioButtonClient.Checked = true;
					}
					this.buttonGenerate.Enabled = false;
					ele = importDocument.GetElementsByTagName("RightsGroups");
					if(ele.Item(0).InnerText=="1")
					{
						this.comboBoxIncludeRightsGroups.SelectedIndex = 0;
						cmsImport.RightsGroups = ImportIncludeRightsGroups.CMS_IMPORT_RIGHTS_GROUPS_NONE;
					}
					else if(ele.Item(0).InnerText=="2")
					{
						this.comboBoxIncludeRightsGroups.SelectedIndex = 1;
						cmsImport.RightsGroups = ImportIncludeRightsGroups.CMS_IMPORT_RIGHTS_GROUP_WITHOUT_MEMBERS;
					}
					else
					{
						this.comboBoxIncludeRightsGroups.SelectedIndex = 2;
						cmsImport.RightsGroups = ImportIncludeRightsGroups.CMS_IMPORT_RIGHTS_GROUP_USE_PACKAGE_MEMBERS;
					}
					ele = importDocument.GetElementsByTagName("CreatedBy");
					if(ele.Item(0).InnerText=="1")
					{
						this.comboBoxIncludeCreatedBy.SelectedIndex = 0;
						cmsImport.CreatedBy = ImportIncludeCreatedBy.CMS_IMPORT_CREATED_BY_CURRENT_USER;
					}
					else if(ele.Item(0).InnerText=="2")
					{
						this.comboBoxIncludeCreatedBy.SelectedIndex = 1;
						cmsImport.CreatedBy = ImportIncludeCreatedBy.CMS_IMPORT_CREATED_BY_USE_PACKAGE;
					}
					
					ele = importDocument.GetElementsByTagName("RightsOnReplace");
					if(ele.Item(0).InnerText=="1")
					{
						this.comboBoxRightsOnReplace.SelectedIndex = 0;
						cmsImport.RightsOnReplace = ImportRightsOnReplace.CMS_IMPORT_RIGHTS_ON_REPLACE_KEEP_EXISTING;
					}
					else if(ele.Item(0).InnerText=="2")
					{
						this.comboBoxRightsOnReplace.SelectedIndex = 1;
						cmsImport.RightsOnReplace = ImportRightsOnReplace.CMS_IMPORT_RIGHTS_ON_REPLACE_USE_PACKAGE;
					}
					
					ele = importDocument.GetElementsByTagName("RightsOnAdd");
					if(ele.Item(0).InnerText=="1")
					{
						this.comboBoxRightsOnAdd.SelectedIndex = 0;
						cmsImport.RightsOnAdd = ImportRightsOnAdd.CMS_IMPORT_RIGHTS_ON_ADD_NO_RIGHTS;
					}
					else if(ele.Item(0).InnerText=="2")
					{
						this.comboBoxRightsOnAdd.SelectedIndex = 1;
						cmsImport.RightsOnAdd = ImportRightsOnAdd.CMS_IMPORT_RIGHTS_ON_ADD_INHERIT_FROM_PARENT;
					}
					else if(ele.Item(0).InnerText=="3")
					{
						this.comboBoxRightsOnAdd.SelectedIndex = 2;
						cmsImport.RightsOnAdd = ImportRightsOnAdd.CMS_IMPORT_RIGHTS_ON_ADD_USE_PACKAGE;
					}

					ele = importDocument.GetElementsByTagName("ServerUrl");
					this.textBoxServer.Text = ele.Item(0).InnerText;
					cmsImport.ServerUrl = ele.Item(0).InnerText;
					ele = importDocument.GetElementsByTagName("UserName");
					this.textBoxUserName.Text = ele.Item(0).InnerText;
					cmsImport.UserName =  ele.Item(0).InnerText;
					ele = importDocument.GetElementsByTagName("Password");
					this.textBoxPassword.Text = ele.Item(0).InnerText;
					cmsImport.Password =  ele.Item(0).InnerText;
					ele = importDocument.GetElementsByTagName("ReportFilePath");
					this.textBoxReport.Text = ele.Item(0).InnerText;
					cmsImport.ReportFilePath =  ele.Item(0).InnerText;
					ele = importDocument.GetElementsByTagName("SDOFilePath");
					this.textBoxSDO.Text = ele.Item(0).InnerText;
					cmsImport.SDOFilePath =  ele.Item(0).InnerText;
					ele = importDocument.GetElementsByTagName("ScriptFile");
					this.textBoxFileName.Text = ele.Item(0).InnerText;
					cmsImport.ScriptFile =  ele.Item(0).InnerText;
					this.buttonGenerate.Enabled = false;
					if(cmsImport.ScriptFile!="")
					{
						this.buttonGenerate.Enabled = true;
					}
					isDirty = false;
				}
			}
			catch(Exception ex)
			{
				MessageBox.Show("While trying to open the document, an error occured. Error - "+ex.ToString(),"Error",MessageBoxButtons.OK,MessageBoxIcon.Error);
			}

		}

		private void InitNew()
		{
			MakeDefault();
			importDocument = new XmlDocument();
			importDocument.LoadXml("<Import>" +
				"<AuthenticationType>1</AuthenticationType>" +
				"<SDOFilePath></SDOFilePath>" +
				"<ServerUrl>http://localhost</ServerUrl>" +
				"<ReportFilePath></ReportFilePath>" +
				"<ScriptType>1</ScriptType>" +
				"<CreatedBy>1</CreatedBy>" +
				"<RightsGroups>2</RightsGroups>" +
				"<RightsOnAdd>1</RightsOnAdd>" +
				"<RightsOnReplace>2</RightsOnReplace>" +
				"<UserName></UserName>" +
				"<Password></Password>" +
				"<ScriptFile></ScriptFile>" +
				"</Import>");
			isDirty = false;
		}

		private void menuItemSave_Click(object sender, System.EventArgs e)
		{
			if(Save())
			{
				MessageBox.Show("Import Xml file Saved","File Saved",MessageBoxButtons.OK,MessageBoxIcon.Information);
			}
		}

		private void menuItemExit_Click(object sender, System.EventArgs e)
		{
			if(isDirty)
			{
				DialogResult result = MessageBox.Show("Do you want to save?","Not saved",MessageBoxButtons.YesNo,MessageBoxIcon.Question);
				if(result == DialogResult.Yes)
				{
					Save();
				}
			}
			isDirty = false;
			this.Close();
		}

		private void radioButtonAuthenticateAsCurrentUser_CheckedChanged(object sender, System.EventArgs e)
		{
			if(!radioButtonAuthenticateAsCurrentUser.Checked)
			{
				this.textBoxUserName.Enabled = true;
				this.textBoxPassword.Enabled = true;
				cmsImport.AuthenticationType = CmsAuthenticationType.AuthenticateAsUser;
			}
			else
			{
				this.textBoxUserName.Enabled = false;
				this.textBoxPassword.Enabled = false;
				cmsImport.AuthenticationType = CmsAuthenticationType.AuthenticateAsCurrentUser;
			}
			isDirty = true;
		}

		private void radioButtonAuthenticateAsUser_CheckedChanged(object sender, System.EventArgs e)
		{
			if(radioButtonAuthenticateAsUser.Checked)
			{
				this.textBoxUserName.Enabled = true;
				this.textBoxPassword.Enabled = true;
				cmsImport.AuthenticationType = CmsAuthenticationType.AuthenticateAsUser;
			}
			else
			{
				this.textBoxUserName.Enabled = false;
				this.textBoxPassword.Enabled = false;
				cmsImport.AuthenticationType = CmsAuthenticationType.AuthenticateAsCurrentUser;
			}
			isDirty = true;
		}

		private void radioButtonServer_CheckedChanged(object sender, System.EventArgs e)
		{
			if(radioButtonServer.Checked)
			{
				cmsImport.ScriptType = CmsScriptType.ServerSide;
				this.textBoxServer.Enabled = false;
			}
			else
			{
				cmsImport.ScriptType = CmsScriptType.ClientSide;
				this.textBoxServer.Enabled = true;
			}
			isDirty = true;
		}

		private void buttonBrowse_Click(object sender, System.EventArgs e)
		{
			this.saveFileDialog.ShowDialog();
			if(this.saveFileDialog.FileName!="")
			{
				this.textBoxFileName.Text=saveFileDialog.FileName;
				this.saveFileDialog.FileName = "";
				this.buttonGenerate.Enabled = true;
			}
		}

		private void comboBoxIncludeCreatedBy_SelectedIndexChanged(object sender, System.EventArgs e)
		{
			cmsImport.CreatedBy = (ImportIncludeCreatedBy)this.comboBoxIncludeCreatedBy.SelectedIndex+1;
			isDirty = true;
		}

		private void comboBoxIncludeRightsGroups_SelectedIndexChanged(object sender, System.EventArgs e)
		{
			cmsImport.RightsGroups = (ImportIncludeRightsGroups)this.comboBoxIncludeRightsGroups.SelectedIndex+1;
			isDirty = true;
		}

		private void comboBoxRightsOnAdd_SelectedIndexChanged(object sender, System.EventArgs e)
		{
			cmsImport.RightsOnAdd = (ImportRightsOnAdd)this.comboBoxRightsOnAdd.SelectedIndex+1;
			isDirty = true;		
		}

		private void comboBoxRightsOnReplace_SelectedIndexChanged(object sender, System.EventArgs e)
		{
			cmsImport.RightsOnReplace = (ImportRightsOnReplace)this.comboBoxRightsOnReplace.SelectedIndex+1;
			isDirty = true;		
		}

		private bool Save()
		{
			importDocument.RemoveAll();
			importDocument.LoadXml("<Import>" +
				"<AuthenticationType>"+(int)cmsImport.AuthenticationType+"</AuthenticationType>" +
				"<SDOFilePath>"+cmsImport.SDOFilePath+"</SDOFilePath>" +
				"<ServerUrl>"+cmsImport.ServerUrl+"</ServerUrl>" +
				"<ReportFilePath>"+cmsImport.ReportFilePath+"</ReportFilePath>" +
				"<ScriptType>"+(int)cmsImport.ScriptType+"</ScriptType>" +
				"<CreatedBy>"+(int)cmsImport.CreatedBy+"</CreatedBy>" +
				"<RightsGroups>"+(int)cmsImport.RightsGroups+"</RightsGroups>" +
				"<RightsOnAdd>"+(int)cmsImport.RightsOnAdd+"</RightsOnAdd>" +
				"<RightsOnReplace>"+(int)cmsImport.RightsOnReplace+"</RightsOnReplace>" +
				"<UserName>"+this.textBoxUserName.Text+"</UserName>" +
				"<Password>"+this.textBoxPassword.Text+"</Password>" +
				"<ScriptFile>"+this.textBoxFileName.Text+"</ScriptFile>" +
				"</Import>");
			if(!isOpened)
			{
				saveFileDialogXml.ShowDialog();
				if(saveFileDialogXml.FileName!="")
				{
					try
					{
						importDocument.Save(saveFileDialogXml.FileName);
						isDirty = false;
						isOpened = true;
						return true;
					}
					catch(Exception ex)
					{
						MessageBox.Show("While trying to save the document, an error occured. Error - "+ex.ToString(),"Error",MessageBoxButtons.OK,MessageBoxIcon.Error);
					}
				}
			}
			else
			{
				try
				{
					if(openFileDialogXml.FileName!="")
					{
						importDocument.Save(openFileDialogXml.FileName);
					}
					else
					{
						importDocument.Save(saveFileDialogXml.FileName);
					}
					
					isDirty = false;
					isOpened = true;
					return true;
				}
				catch(Exception ex)
				{
					MessageBox.Show("While trying to save the document, an error occured. Error - "+ex.ToString(),"Error",MessageBoxButtons.OK,MessageBoxIcon.Error);
				}
			}
			return false;
		}

		private void menuItemNew_Click(object sender, System.EventArgs e)
		{
			if(isDirty)
			{
				DialogResult result = MessageBox.Show("Do you want to save?","Not saved",MessageBoxButtons.YesNo,MessageBoxIcon.Question);
				if(result == DialogResult.Yes)
				{
					Save();
				}
			}
			InitNew();
			isDirty = false;
		}

		private void radioButtonClient_CheckedChanged(object sender, System.EventArgs e)
		{
			if(radioButtonClient.Checked)
			{
				cmsImport.ScriptType = CmsScriptType.ClientSide;
				this.textBoxServer.Enabled = true;
			}
			else
			{
				cmsImport.ScriptType = CmsScriptType.ServerSide;
				this.textBoxServer.Enabled = false;
			}
			isDirty = true;
		}

		private void buttonSDO_Click(object sender, System.EventArgs e)
		{
			this.saveFileDialogsdo.ShowDialog();
			if(this.saveFileDialogsdo.FileName!="")
			{
				this.textBoxSDO.Text=saveFileDialogsdo.FileName;
				cmsImport.SDOFilePath = saveFileDialogsdo.FileName;
				this.saveFileDialogsdo.FileName = "";
				isDirty = true;
			}
		}

		private void buttonReport_Click(object sender, System.EventArgs e)
		{
			this.saveFileDialogReport.ShowDialog();
			if(this.saveFileDialogReport.FileName!="")
			{
				this.textBoxReport.Text=saveFileDialogReport.FileName;
				cmsImport.ReportFilePath = saveFileDialogReport.FileName;
				this.saveFileDialogReport.FileName = "";
				isDirty = true;
			}
		}

		#endregion

	}
}
