/**
 * @file FormLogViewer.cs
 *
 * MCMS Manager
 *
 * MCMS Manager is the legal property of its developer
 * Chester Ragel <chesterr@gmail.com> - Developer and Maintainer
 * Yahoo ID : chesterr1979 
 * MSN : chesterr79@hotmail.com
 *
 * If you want more information, found any bugs or have any doubts you 
 * can mail me or contact me through my yahoo id.
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2.1 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#region NameSpaces
using System;
using System.Drawing;
using System.Collections;
using System.ComponentModel;
using System.Windows.Forms;
using System.IO;
using System.Text.RegularExpressions;

using Microsoft.ContentManagement.Publishing;
#endregion

namespace MCMS
{
	/// <summary>
	/// Viewer to view the MCMS log files
	/// </summary>
	public class FormLogViewer : System.Windows.Forms.Form
	{

		#region Private Variables
		private System.Windows.Forms.Label labelFile;
		private System.Windows.Forms.Button buttonOpenFiles;
		private System.Windows.Forms.ComboBox comboBoxPostings;
		private System.Windows.Forms.Label labelPosting;
		private System.Windows.Forms.Button buttonExit;

		private System.Windows.Forms.ColumnHeader columnCreatedOn;
		private System.Windows.Forms.ColumnHeader columnGuid;
		private System.Windows.Forms.ColumnHeader columnPageHits;
		private System.Windows.Forms.ColumnHeader columnAccessedBy;
		private System.Windows.Forms.ColumnHeader columnAccessedFrom;
		private System.Windows.Forms.ColumnHeader columnName;
		private System.Windows.Forms.ColumnHeader columnPostingState;
		private System.Windows.Forms.ColumnHeader columnChannel;
		private System.Windows.Forms.ColumnHeader columnAccessedOnDate;
		private System.Windows.Forms.ColumnHeader columnAccessedOnTime;

		private ListViewColumnSorter lvwColumnSorter;
		private System.Windows.Forms.ListView listViewPostings;
		private System.Windows.Forms.OpenFileDialog openFileDialog;
		private System.Windows.Forms.TextBox textBoxFile;

		private CmsPostings postings;
		private System.Windows.Forms.StatusBar statusBar;
		private System.Windows.Forms.StatusBarPanel statusBarPanel;
		private System.Windows.Forms.ImageList imageList;
		private System.ComponentModel.IContainer components;
		#endregion

		#region Init/Dispose
		public FormLogViewer()
		{
			InitializeComponent();
		}

		/// <summary>
		/// Clean up any resources being used.
		/// </summary>
		protected override void Dispose( bool disposing )
		{
			if( disposing )
			{
				if(components != null)
				{
					components.Dispose();
				}
			}
			base.Dispose( disposing );
		}

		#region Windows Form Designer generated code
		/// <summary>
		/// Required method for Designer support - do not modify
		/// the contents of this method with the code editor.
		/// </summary>
		private void InitializeComponent()
		{
			this.components = new System.ComponentModel.Container();
			System.Resources.ResourceManager resources = new System.Resources.ResourceManager(typeof(FormLogViewer));
			this.openFileDialog = new System.Windows.Forms.OpenFileDialog();
			this.labelFile = new System.Windows.Forms.Label();
			this.buttonOpenFiles = new System.Windows.Forms.Button();
			this.comboBoxPostings = new System.Windows.Forms.ComboBox();
			this.listViewPostings = new System.Windows.Forms.ListView();
			this.imageList = new System.Windows.Forms.ImageList(this.components);
			this.buttonExit = new System.Windows.Forms.Button();
			this.textBoxFile = new System.Windows.Forms.TextBox();
			this.labelPosting = new System.Windows.Forms.Label();
			this.columnAccessedBy = new System.Windows.Forms.ColumnHeader();
			this.columnAccessedFrom = new System.Windows.Forms.ColumnHeader();
			this.columnAccessedOnDate = new System.Windows.Forms.ColumnHeader();
			this.columnAccessedOnTime = new System.Windows.Forms.ColumnHeader();
			this.columnPageHits = new System.Windows.Forms.ColumnHeader();
			this.columnName = new System.Windows.Forms.ColumnHeader();
			this.columnChannel = new System.Windows.Forms.ColumnHeader();
			this.columnPostingState = new System.Windows.Forms.ColumnHeader();
			this.columnCreatedOn = new System.Windows.Forms.ColumnHeader();
			this.columnGuid = new System.Windows.Forms.ColumnHeader();
			this.statusBar = new System.Windows.Forms.StatusBar();
			this.statusBarPanel = new System.Windows.Forms.StatusBarPanel();
			((System.ComponentModel.ISupportInitialize)(this.statusBarPanel)).BeginInit();
			this.SuspendLayout();
			// 
			// openFileDialog
			// 
			this.openFileDialog.DefaultExt = "log";
			this.openFileDialog.Filter = "MCMS Log Files|*.log";
			// 
			// labelFile
			// 
			this.labelFile.Location = new System.Drawing.Point(8, 8);
			this.labelFile.Name = "labelFile";
			this.labelFile.Size = new System.Drawing.Size(224, 23);
			this.labelFile.TabIndex = 0;
			this.labelFile.Text = "Select the MCMS log file which to view";
			// 
			// buttonOpenFiles
			// 
			this.buttonOpenFiles.Location = new System.Drawing.Point(648, 8);
			this.buttonOpenFiles.Name = "buttonOpenFiles";
			this.buttonOpenFiles.Size = new System.Drawing.Size(24, 20);
			this.buttonOpenFiles.TabIndex = 0;
			this.buttonOpenFiles.Text = "...";
			this.buttonOpenFiles.Click += new System.EventHandler(this.buttonOpenFiles_Click);
			// 
			// comboBoxPostings
			// 
			this.comboBoxPostings.DropDownStyle = System.Windows.Forms.ComboBoxStyle.DropDownList;
			this.comboBoxPostings.Location = new System.Drawing.Point(136, 40);
			this.comboBoxPostings.Name = "comboBoxPostings";
			this.comboBoxPostings.Size = new System.Drawing.Size(240, 21);
			this.comboBoxPostings.TabIndex = 1;
			this.comboBoxPostings.SelectedIndexChanged += new System.EventHandler(this.comboBoxPostings_SelectedIndexChanged);
			// 
			// listViewPostings
			// 
			this.listViewPostings.AllowColumnReorder = true;
			this.listViewPostings.FullRowSelect = true;
			this.listViewPostings.LargeImageList = this.imageList;
			this.listViewPostings.Location = new System.Drawing.Point(5, 72);
			this.listViewPostings.Name = "listViewPostings";
			this.listViewPostings.Size = new System.Drawing.Size(672, 280);
			this.listViewPostings.SmallImageList = this.imageList;
			this.listViewPostings.StateImageList = this.imageList;
			this.listViewPostings.TabIndex = 2;
			this.listViewPostings.View = System.Windows.Forms.View.Details;
			this.listViewPostings.DoubleClick += new System.EventHandler(this.listViewPostings_DoubleClick);
			this.listViewPostings.ColumnClick += new System.Windows.Forms.ColumnClickEventHandler(this.listViewPostings_ColumnClick);
			this.listViewPostings.SelectedIndexChanged += new System.EventHandler(this.listViewPostings_SelectedIndexChanged);
			// 
			// imageList
			// 
			this.imageList.ImageSize = new System.Drawing.Size(16, 16);
			this.imageList.ImageStream = ((System.Windows.Forms.ImageListStreamer)(resources.GetObject("imageList.ImageStream")));
			this.imageList.TransparentColor = System.Drawing.Color.Transparent;
			// 
			// buttonExit
			// 
			this.buttonExit.DialogResult = System.Windows.Forms.DialogResult.Cancel;
			this.buttonExit.Location = new System.Drawing.Point(600, 360);
			this.buttonExit.Name = "buttonExit";
			this.buttonExit.TabIndex = 3;
			this.buttonExit.Text = "&Exit";
			this.buttonExit.Click += new System.EventHandler(this.buttonExit_Click);
			// 
			// textBoxFile
			// 
			this.textBoxFile.Location = new System.Drawing.Point(224, 8);
			this.textBoxFile.Name = "textBoxFile";
			this.textBoxFile.ReadOnly = true;
			this.textBoxFile.Size = new System.Drawing.Size(408, 20);
			this.textBoxFile.TabIndex = 400;
			this.textBoxFile.TabStop = false;
			this.textBoxFile.Text = "";
			// 
			// labelPosting
			// 
			this.labelPosting.Location = new System.Drawing.Point(8, 40);
			this.labelPosting.Name = "labelPosting";
			this.labelPosting.Size = new System.Drawing.Size(120, 23);
			this.labelPosting.TabIndex = 5;
			this.labelPosting.Text = "Name of the Posting";
			// 
			// columnAccessedBy
			// 
			this.columnAccessedBy.Text = "Accessed By";
			this.columnAccessedBy.Width = 150;
			// 
			// columnAccessedFrom
			// 
			this.columnAccessedFrom.Text = "Accessed From";
			this.columnAccessedFrom.Width = 150;
			// 
			// columnAccessedOnDate
			// 
			this.columnAccessedOnDate.Text = "Accessed On (Date)";
			this.columnAccessedOnDate.Width = 140;
			// 
			// columnAccessedOnTime
			// 
			this.columnAccessedOnTime.Text = "Accessed On (Time)";
			this.columnAccessedOnTime.Width = 140;
			// 
			// columnPageHits
			// 
			this.columnPageHits.Text = "Page Hits";
			// 
			// columnName
			// 
			this.columnName.Text = "Name";
			this.columnName.Width = 125;
			// 
			// columnChannel
			// 
			this.columnChannel.Text = "Channel";
			this.columnChannel.Width = 130;
			// 
			// columnPostingState
			// 
			this.columnPostingState.Text = "Posting State";
			this.columnPostingState.Width = 100;
			// 
			// columnCreatedOn
			// 
			this.columnCreatedOn.Text = "Created On";
			this.columnCreatedOn.Width = 75;
			// 
			// columnGuid
			// 
			this.columnGuid.Text = "Guid";
			this.columnGuid.Width = 175;
			// 
			// statusBar
			// 
			this.statusBar.Location = new System.Drawing.Point(0, 393);
			this.statusBar.Name = "statusBar";
			this.statusBar.Panels.AddRange(new System.Windows.Forms.StatusBarPanel[] {
																						 this.statusBarPanel});
			this.statusBar.ShowPanels = true;
			this.statusBar.Size = new System.Drawing.Size(682, 22);
			this.statusBar.TabIndex = 600;
			// 
			// statusBarPanel
			// 
			this.statusBarPanel.Width = 682;
			// 
			// FormLogViewer
			// 
			this.AutoScaleBaseSize = new System.Drawing.Size(5, 13);
			this.CancelButton = this.buttonExit;
			this.ClientSize = new System.Drawing.Size(682, 415);
			this.Controls.Add(this.statusBar);
			this.Controls.Add(this.labelPosting);
			this.Controls.Add(this.textBoxFile);
			this.Controls.Add(this.buttonExit);
			this.Controls.Add(this.listViewPostings);
			this.Controls.Add(this.comboBoxPostings);
			this.Controls.Add(this.buttonOpenFiles);
			this.Controls.Add(this.labelFile);
			this.FormBorderStyle = System.Windows.Forms.FormBorderStyle.FixedSingle;
			this.Icon = ((System.Drawing.Icon)(resources.GetObject("$this.Icon")));
			this.MaximizeBox = false;
			this.Name = "FormLogViewer";
			this.StartPosition = System.Windows.Forms.FormStartPosition.CenterScreen;
			this.Text = "MCMS Log Viewer - MCMS Manager";
			this.Load += new System.EventHandler(this.FormLogViewer_Load);
			((System.ComponentModel.ISupportInitialize)(this.statusBarPanel)).EndInit();
			this.ResumeLayout(false);

		}
		#endregion

		private void FormLogViewer_Load(object sender, System.EventArgs e)
		{
			postings = new CmsPostings();
			lvwColumnSorter = new ListViewColumnSorter();
			this.listViewPostings.ListViewItemSorter = lvwColumnSorter;
		}

		#endregion

		#region List Column according to Item		

		private void InitListViewPostings()
		{
			this.listViewPostings.Columns.Clear();
			this.listViewPostings.Columns.AddRange(new System.Windows.Forms.ColumnHeader[] {
																							   this.columnName,
																							   this.columnGuid,
																							   this.columnChannel,
																							   this.columnPostingState,
																							   this.columnPageHits,
																							   this.columnCreatedOn});
		}

		private void InitListViewPosting()
		{
			this.listViewPostings.Columns.Clear();
			this.listViewPostings.Columns.AddRange(new System.Windows.Forms.ColumnHeader[] {
																							   this.columnAccessedBy,
																							   this.columnAccessedFrom,
																							   this.columnAccessedOnDate,
																							   this.columnAccessedOnTime,
																							   this.columnPageHits});
		}

		#endregion

		#region Sorting
		private void listViewPostings_ColumnClick(object sender, System.Windows.Forms.ColumnClickEventArgs e)
		{
			if (e.Column == lvwColumnSorter.SortColumn)
			{
				// Reverse the current sort direction for this column.
				if (lvwColumnSorter.Order == SortOrder.Ascending)
				{
					lvwColumnSorter.Order = SortOrder.Descending;
				}
				else
				{
					lvwColumnSorter.Order = SortOrder.Ascending;
				}
			}
			else
			{
				// Set the column number that is to be sorted; default to ascending.
				lvwColumnSorter.SortColumn = e.Column;
				lvwColumnSorter.Order = SortOrder.Ascending;
			}

			// Perform the sort with these new sort options.
			this.listViewPostings.Sort();
		}
		#endregion

		#region Events
		private void buttonExit_Click(object sender, System.EventArgs e)
		{
			this.Close();
		}

		private void buttonOpenFiles_Click(object sender, System.EventArgs e)
		{
			DialogResult result = openFileDialog.ShowDialog();
			if(result!=DialogResult.Cancel)
			{
				postings.Clear();
				this.comboBoxPostings.Items.Clear();
				this.listViewPostings.Items.Clear();
				LoadFile(openFileDialog.FileName);
				this.textBoxFile.Text = openFileDialog.FileName;
			}
		}

		private void listViewPostings_SelectedIndexChanged(object sender, System.EventArgs e)
		{
			if(this.comboBoxPostings.SelectedIndex == 0 )
			{
				this.statusBarPanel.Text = "Selected Posting(s) Count : "+listViewPostings.SelectedIndices.Count;
			}
			else
			{
				this.statusBarPanel.Text = "Selected Count : "+listViewPostings.SelectedIndices.Count;
			}		
		}

		private void listViewPostings_DoubleClick(object sender, System.EventArgs e)
		{
			this.comboBoxPostings.SelectedIndex = Convert.ToInt32(this.listViewPostings.SelectedItems[0].Tag);
		}

		private void comboBoxPostings_SelectedIndexChanged(object sender, System.EventArgs e)
		{
			if(comboBoxPostings.SelectedIndex == 0) 
			{
				InitListViewPostings();
				this.listViewPostings.Items.Clear();
				for(int i = 0;i<postings.Count;i++)
				{
					ListViewItem item = new ListViewItem(new string[] {postings[i].Name,postings[i].Guid,postings[i].ChannelName,postings[i].CmsPostingState.ToString(),postings[i].TotalHit.ToString(),postings[i].CreatedOn.ToShortDateString()},0);
					item.Tag = i+1;
					listViewPostings.Items.Add(item);
				}
				this.statusBarPanel.Text = "";
			}
			else
			{
				InitListViewPosting();
				this.listViewPostings.Items.Clear();
				for(int i=0;i<postings[this.comboBoxPostings.SelectedIndex-1].AccessedBy.Length;i++)
				{
					ListViewItem item = new ListViewItem(new string[] {postings[this.comboBoxPostings.SelectedIndex-1].AccessedBy[i],postings[this.comboBoxPostings.SelectedIndex-1].AccessedFrom[i],postings[this.comboBoxPostings.SelectedIndex-1].AccessedOnDate[i],postings[this.comboBoxPostings.SelectedIndex-1].AccessedOnTime[i],postings[this.comboBoxPostings.SelectedIndex-1].HitCount[i].ToString()});
					listViewPostings.Items.Add(item);
				}
				this.statusBarPanel.Text = "";
			}
		}
		#endregion

		#region View File
		private void LoadFile(string fileName)
		{
			try
			{
				StreamReader sr = new StreamReader(fileName);
				Regex fields = new Regex(@"(#Fields:[^ ]*)");
				Regex software = new Regex(@"(#Software:[^ ]*)");

				string line;
				bool isFound = false;
				int posGuid = -1;
				int posName = -1;
				int posUser = -1;
				int posDate = -1;
				int posTime = -1;
				int posState = -1;
				int posHit = -1;
				int posCreated = -1;
				int posExpired = -1;
				int posAccessedBy = -1;
				int posAccessedFrom = -1;
				int posChannel = -1;
				while((line=sr.ReadLine())!=null)
				{
					if(fields.IsMatch(line))
					{
						string[] pos = line.Split(' ');
						for(int i=0;i<pos.Length;i++)
						{
							if(pos[i]=="guid")
							{
								posGuid = i-1;
							}
							if(pos[i]=="user")
							{
								posUser = i-1;
							}
							if(pos[i]=="date")
							{
								posDate = i-1;
							}
							if(pos[i]=="time")
							{
								posTime = i-1;
							}
							if(pos[i]=="state")
							{
								posState = i-1;
							}
							if(pos[i]=="hit")
							{
								posHit = i-1;
							}
							if(pos[i]=="created")
							{
								posCreated = i-1;
							}
							if(pos[i]=="expired")
							{
								posExpired = i-1;
							}
							if(pos[i]=="accessedby")
							{
								posAccessedBy = i-1;
							}
							if(pos[i]=="accessedfrom")
							{
								posAccessedFrom = i-1;
							}
							if(pos[i]=="name")
							{
								posName = i-1;
							}
							if(pos[i]=="channel")
							{
								posChannel = i-1;
							}
						}
						isFound = true;
					}
					else if(software.IsMatch(line))
					{
						isFound = false;
					}
					else if(isFound)
					{
						bool found = false;
						CmsPosting post = null;
						foreach(CmsPosting p in postings)
						{
							if(p.Guid==line.Split(' ')[posGuid])
							{
								post = p;
								found = true;
							}
						}
						if(found && post!=null)
						{
							int count = post.AccessedBy.Length;
							
							string[] tempChange = new string[count];
							for(int k =0;k<count;k++)
							{
								tempChange[k] = post.AccessedBy[k];
							}
							post.AccessedBy = new string[count+1];
							for(int k =0;k<count;k++)
							{
								post.AccessedBy[k] = tempChange[k];
							}
							post.AccessedBy[count] = line.Split(' ')[posAccessedBy];

							tempChange = new string[count];
							for(int k =0;k<count;k++)
							{
								tempChange[k] = post.AccessedFrom[k];
							}
							post.AccessedFrom = new string[count+1];
							for(int k =0;k<count;k++)
							{
								post.AccessedFrom[k] = tempChange[k];
							}
							post.AccessedFrom[count] = line.Split(' ')[posAccessedFrom];

							int[] tempChangeI = new int[count];
							for(int k =0;k<count;k++)
							{
								tempChangeI[k] = post.HitCount[k];
							}
							post.HitCount = new int[count+1];
							for(int k =0;k<count;k++)
							{
								post.HitCount[k] = tempChangeI[k];
							}
							post.HitCount[count] = Convert.ToInt32(line.Split(' ')[posHit]);
							
							tempChange = new string[count];
							for(int k =0;k<count;k++)
							{
								tempChange[k] = post.AccessedOnDate[k];
							}
							post.AccessedOnDate = new string[count+1];
							for(int k =0;k<count;k++)
							{
								post.AccessedOnDate[k] = tempChange[k];
							}
							post.AccessedOnDate[count] = line.Split(' ')[posDate];
													
							tempChange = new string[count];
							for(int k =0;k<count;k++)
							{
								tempChange[k] = post.AccessedOnTime[k];
							}
							post.AccessedOnTime = new string[count+1];
							for(int k =0;k<count;k++)
							{
								post.AccessedOnTime[k] = tempChange[k];
							}
							post.AccessedOnTime[count] = line.Split(' ')[posTime];
						}
						else
						{
							CmsPosting posting = new CmsPosting();
							posting.Guid = line.Split(' ')[posGuid];
							posting.CreatedOn = Convert.ToDateTime(line.Split(' ')[posCreated]);
							posting.Name = line.Split(' ')[posName];
							posting.ChannelName = line.Split(' ')[posChannel];
							posting.ExpiredOn = Convert.ToDateTime(line.Split(' ')[posExpired]);
							switch(line.Split(' ')[posState])
							{
								case "Approved":
								{
									posting.CmsPostingState = PostingState.Approved;
									break;
								}
								case "Deleted":
								{
									posting.CmsPostingState = PostingState.Deleted;
									break;
								}
								case "EditorDeclined":
								{
									posting.CmsPostingState = PostingState.EditorDeclined;
									break;
								}
								case "Expired":
								{
									posting.CmsPostingState = PostingState.Expired;
									break;
								}
								case "Historical":
								{
									posting.CmsPostingState = PostingState.Historical;
									break;
								}
								case "ModeratorDeclined":
								{
									posting.CmsPostingState = PostingState.ModeratorDeclined;
									break;
								}
								case "New":
								{
									posting.CmsPostingState = PostingState.New;
									break;
								}
								case "None":
								{
									posting.CmsPostingState = PostingState.None;
									break;
								}
								case "Published":
								{
									posting.CmsPostingState = PostingState.Published;
									break;
								}
								case "Saved":
								{
									posting.CmsPostingState = PostingState.Saved;
									break;
								}
								case "WaitingForEditorApproval":
								{
									posting.CmsPostingState = PostingState.WaitingForEditorApproval;
									break;
								}
								case "WaitingForModeratorApproval":
								{
									posting.CmsPostingState = PostingState.WaitingForModeratorApproval;
									break;
								}
							}
							posting.AccessedBy = new string[1];
							posting.AccessedBy[0] = line.Split(' ')[posAccessedBy];
							posting.AccessedFrom = new string[1];
							posting.AccessedFrom[0] = line.Split(' ')[posAccessedFrom];
							posting.HitCount = new int[1];
							posting.HitCount[0] = Convert.ToInt32(line.Split(' ')[posHit]);
							posting.AccessedOnDate = new string[1];
							posting.AccessedOnDate[0] = line.Split(' ')[posDate];
							posting.AccessedOnTime = new string[1];
							posting.AccessedOnTime[0] = line.Split(' ')[posTime];
							postings.Add(posting);
						}
						post = null;
						found = false;
					}

				}
				sr.Close();
				this.comboBoxPostings.Items.Add("All");
				for(int i=0;i<postings.Count;i++)
				{
					this.comboBoxPostings.Items.Add(postings[i].Name);
				}
				if(this.comboBoxPostings.Items.Count>0)
				{
					this.comboBoxPostings.SelectedItem = this.comboBoxPostings.Items[0];
				}
			}
			catch(Exception ex)
			{
				MessageBox.Show("While opening the MCMS log file an exception was thrown. Exception : "+ex.Message,"Error",MessageBoxButtons.OK,MessageBoxIcon.Error);
			}
		}
		#endregion
	}
}
