/**
 * @file Login.cs
 *
 * MCMS Manager
 *
 * MCMS Manager is the legal property of its developer
 * Chester Ragel <chesterr@gmail.com> - Developer and Maintainer
 * Yahoo ID : chesterr1979 
 * MSN : chesterr79@hotmail.com
 *
 * If you want more information, found any bugs or have any doubts you 
 * can mail me or contact me through my yahoo id.
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2.1 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#region NameSpaces
using System;
using System.Drawing;
using System.Collections;
using System.ComponentModel;
using System.Windows.Forms;
using System.Configuration;
using System.Security.Cryptography;
using System.IO;
using System.Text;
//MCMS components
using Microsoft.ContentManagement.Common;
using Microsoft.ContentManagement.Publishing;
//Application block
using Microsoft.Practices.EnterpriseLibrary.Configuration;
using Microsoft.Practices.EnterpriseLibrary.Security.Cryptography;
#endregion

namespace MCMS
{
	/// <summary>
	/// To login to MCMS authendication is required. This form is 
	/// used to get user information to create CmsApplicationContext 
	/// which will be used through out the session until it get refreshes.
	/// </summary>
	public class FormLogin : System.Windows.Forms.Form
	{

		#region Controls Initialization
		private System.Windows.Forms.Label lableUserName;
		private System.Windows.Forms.Label labelPassword;
		private System.Windows.Forms.TextBox textBoxUserName;
		private System.Windows.Forms.TextBox textBoxPassword;
		private System.Windows.Forms.Button buttonOk;
		private System.Windows.Forms.Button buttonCancel;
		private System.Windows.Forms.ToolTip toolTip;
		private System.Windows.Forms.Label labelEg;
		private System.Windows.Forms.CheckBox checkBoxLogin;
		private System.Windows.Forms.Label labelServerName;
		private System.Windows.Forms.TextBox textBoxServerName;
		private System.ComponentModel.IContainer components;
		private MCMSManagerConfig mcmsConfig;
		private System.Windows.Forms.Label labelServerFormat;
		private string serverName = "";
		#endregion

		#region Init/Dispose Controls

		public FormLogin()
		{
			InitializeComponent();
			this.DialogResult = DialogResult.None;
			//Creation of a fresh CmsApplicationContext which will be used for this
			//application
			FormMCMSManager.cmsApplicationContext = new CmsApplicationContext();
		}

		/// <summary>
		/// Clean up any resources being used.
		/// </summary>
		protected override void Dispose( bool disposing )
		{
			if( disposing )
			{
				if(components != null)
				{
					components.Dispose();
				}
			}
			base.Dispose( disposing );
		}

		#region Windows Form Designer generated code
		/// <summary>
		/// Required method for Designer support - do not modify
		/// the contents of this method with the code editor.
		/// </summary>
		private void InitializeComponent()
		{
			this.components = new System.ComponentModel.Container();
			System.Resources.ResourceManager resources = new System.Resources.ResourceManager(typeof(FormLogin));
			this.lableUserName = new System.Windows.Forms.Label();
			this.labelPassword = new System.Windows.Forms.Label();
			this.textBoxUserName = new System.Windows.Forms.TextBox();
			this.textBoxPassword = new System.Windows.Forms.TextBox();
			this.buttonOk = new System.Windows.Forms.Button();
			this.buttonCancel = new System.Windows.Forms.Button();
			this.toolTip = new System.Windows.Forms.ToolTip(this.components);
			this.textBoxServerName = new System.Windows.Forms.TextBox();
			this.labelEg = new System.Windows.Forms.Label();
			this.checkBoxLogin = new System.Windows.Forms.CheckBox();
			this.labelServerName = new System.Windows.Forms.Label();
			this.labelServerFormat = new System.Windows.Forms.Label();
			this.SuspendLayout();
			// 
			// lableUserName
			// 
			this.lableUserName.Location = new System.Drawing.Point(16, 14);
			this.lableUserName.Name = "lableUserName";
			this.lableUserName.TabIndex = 0;
			this.lableUserName.Text = "User Name";
			// 
			// labelPassword
			// 
			this.labelPassword.Location = new System.Drawing.Point(16, 62);
			this.labelPassword.Name = "labelPassword";
			this.labelPassword.TabIndex = 1;
			this.labelPassword.Text = "Password";
			// 
			// textBoxUserName
			// 
			this.textBoxUserName.Location = new System.Drawing.Point(176, 14);
			this.textBoxUserName.Name = "textBoxUserName";
			this.textBoxUserName.Size = new System.Drawing.Size(216, 20);
			this.textBoxUserName.TabIndex = 0;
			this.textBoxUserName.Text = "";
			this.toolTip.SetToolTip(this.textBoxUserName, "Username format WinNT://domain/username");
			// 
			// textBoxPassword
			// 
			this.textBoxPassword.Location = new System.Drawing.Point(176, 62);
			this.textBoxPassword.Name = "textBoxPassword";
			this.textBoxPassword.PasswordChar = '*';
			this.textBoxPassword.Size = new System.Drawing.Size(216, 20);
			this.textBoxPassword.TabIndex = 1;
			this.textBoxPassword.Text = "";
			// 
			// buttonOk
			// 
			this.buttonOk.DialogResult = System.Windows.Forms.DialogResult.OK;
			this.buttonOk.Location = new System.Drawing.Point(112, 182);
			this.buttonOk.Name = "buttonOk";
			this.buttonOk.TabIndex = 4;
			this.buttonOk.Text = "O&k";
			this.buttonOk.Click += new System.EventHandler(this.buttonOk_Click);
			// 
			// buttonCancel
			// 
			this.buttonCancel.DialogResult = System.Windows.Forms.DialogResult.Cancel;
			this.buttonCancel.Location = new System.Drawing.Point(224, 182);
			this.buttonCancel.Name = "buttonCancel";
			this.buttonCancel.TabIndex = 5;
			this.buttonCancel.Text = "Ca&ncel";
			this.buttonCancel.Click += new System.EventHandler(this.buttonCancel_Click);
			// 
			// textBoxServerName
			// 
			this.textBoxServerName.Location = new System.Drawing.Point(176, 102);
			this.textBoxServerName.Name = "textBoxServerName";
			this.textBoxServerName.Size = new System.Drawing.Size(216, 20);
			this.textBoxServerName.TabIndex = 2;
			this.textBoxServerName.Text = "";
			this.toolTip.SetToolTip(this.textBoxServerName, "Server name format http://servername");
			// 
			// labelEg
			// 
			this.labelEg.Location = new System.Drawing.Point(176, 38);
			this.labelEg.Name = "labelEg";
			this.labelEg.Size = new System.Drawing.Size(216, 23);
			this.labelEg.TabIndex = 6;
			this.labelEg.Text = "(format WinNT://domain/username)";
			// 
			// checkBoxLogin
			// 
			this.checkBoxLogin.Location = new System.Drawing.Point(16, 150);
			this.checkBoxLogin.Name = "checkBoxLogin";
			this.checkBoxLogin.Size = new System.Drawing.Size(264, 24);
			this.checkBoxLogin.TabIndex = 3;
			this.checkBoxLogin.Text = "Save this information";
			// 
			// labelServerName
			// 
			this.labelServerName.Location = new System.Drawing.Point(16, 103);
			this.labelServerName.Name = "labelServerName";
			this.labelServerName.Size = new System.Drawing.Size(168, 23);
			this.labelServerName.TabIndex = 8;
			this.labelServerName.Text = "Server Name (Current Machine)";
			// 
			// labelServerFormat
			// 
			this.labelServerFormat.Location = new System.Drawing.Point(176, 126);
			this.labelServerFormat.Name = "labelServerFormat";
			this.labelServerFormat.Size = new System.Drawing.Size(192, 23);
			this.labelServerFormat.TabIndex = 9;
			this.labelServerFormat.Text = "(format http://servername)";
			// 
			// FormLogin
			// 
			this.AcceptButton = this.buttonOk;
			this.AutoScaleBaseSize = new System.Drawing.Size(5, 13);
			this.CancelButton = this.buttonCancel;
			this.ClientSize = new System.Drawing.Size(416, 215);
			this.ControlBox = false;
			this.Controls.Add(this.labelServerFormat);
			this.Controls.Add(this.textBoxServerName);
			this.Controls.Add(this.textBoxPassword);
			this.Controls.Add(this.textBoxUserName);
			this.Controls.Add(this.labelServerName);
			this.Controls.Add(this.checkBoxLogin);
			this.Controls.Add(this.labelEg);
			this.Controls.Add(this.buttonCancel);
			this.Controls.Add(this.buttonOk);
			this.Controls.Add(this.labelPassword);
			this.Controls.Add(this.lableUserName);
			this.FormBorderStyle = System.Windows.Forms.FormBorderStyle.FixedSingle;
			this.Icon = ((System.Drawing.Icon)(resources.GetObject("$this.Icon")));
			this.MaximizeBox = false;
			this.Name = "FormLogin";
			this.StartPosition = System.Windows.Forms.FormStartPosition.CenterScreen;
			this.Text = "Login";
			this.Load += new System.EventHandler(this.FormLogin_Load);
			this.ResumeLayout(false);

		}
		#endregion

		private void FormLogin_Load(object sender, System.EventArgs e)
		{
			//get the information from the config file
			try
			{
				mcmsConfig = ConfigurationManager.GetConfiguration("MCMSSettings") as MCMSManagerConfig;
				if(mcmsConfig!=null)
				{
					string loginName = mcmsConfig.UserName;
					string loginPassword =  mcmsConfig.Password;
					serverName = mcmsConfig.ServerName;
					int showPreview = mcmsConfig.ShowPreview;
					FormMCMSManager.thumbnailHeight = mcmsConfig.ThumbNailHeight;
					FormMCMSManager.thumbnailWidth = mcmsConfig.ThumbnailWidth;
					FormMCMSManager.resolutionHeight = mcmsConfig.ResolutionHeight;
					FormMCMSManager.resolutionWidth = mcmsConfig.ResolutionWidth;
					FormMCMSManager.thumbnailPath = mcmsConfig.ThumbnailFolder;
					int showPreviewResource = mcmsConfig.ShowPreviewResource;
					int showPreviewTemplate = mcmsConfig.ShowPreviewTemplate;
                    if(loginName!="")
					{
						this.textBoxUserName.Text = loginName;
					}
					if(loginPassword!="")
					{
						this.textBoxPassword.Text = Decrypt(loginPassword);
					}
					if(serverName!="")
					{
						this.textBoxServerName.Text = serverName;
					}
					if(showPreview==0)
					{
						FormMCMSManager.showPreview =true;
					}
					else
					{
						FormMCMSManager.showPreview =false;
					}
					if(showPreviewResource==0)
					{
						FormMCMSManager.showPreviewResource =true;
					}
					else
					{
						FormMCMSManager.showPreviewResource =false;
					}
					if(showPreviewTemplate==0)
					{
						FormMCMSManager.showPreviewTemplate =true;
					}
					else
					{
						FormMCMSManager.showPreviewTemplate =false;
					}
				}
			}
			catch(Exception ex)
			{
				MessageBox.Show("Configuration Management exception : "+ex.Message,"Error",MessageBoxButtons.OK,MessageBoxIcon.Error);
			}

		}

		#endregion 

		#region Login/Cancel

		private void buttonOk_Click(object sender, System.EventArgs e)
		{
			try
			{
				this.DialogResult = DialogResult.None;
				string userName = "";
				string password = "";
				userName = this.textBoxUserName.Text;
				password = this.textBoxPassword.Text;
				serverName = this.textBoxServerName.Text;
				if(userName!="")
				{
					if(password!="")
					{
						try
						{
							//Authenticating the given user to the context
							FormMCMSManager.cmsApplicationContext.AuthenticateAsUser(userName,password,PublishingMode.Update);
							this.DialogResult = DialogResult.OK;
							FormMCMSManager.userName = userName;
							FormMCMSManager.password = password;
							FormMCMSManager.serverName = serverName;
							//must save the data for later use
							if(this.checkBoxLogin.Checked)
							{
								mcmsConfig.ServerName = serverName;
								mcmsConfig.UserName = userName;
								//encrypt before you save
								mcmsConfig.Password = Encrypt(password);
								ConfigurationManager.WriteConfiguration("MCMSSettings",mcmsConfig);
							}
							this.Close();
						}
						catch(CmsAccessDeniedException accessDenied)
						{
							//User doesn't have rights to login
							MessageBox.Show("Access denied : "+ accessDenied.Message);
							this.textBoxUserName.Focus();
						}

						catch(Exception ex)
						{
							//Some other issue when authentication
							MessageBox.Show("Error occured while login  : "+ex.Message,"Error",MessageBoxButtons.OK,MessageBoxIcon.Error);
							this.textBoxUserName.Focus();
						}
					}
					else
					{
						//password is blank
						MessageBox.Show("MCMS doesn't support blank password");
						this.textBoxPassword.Focus();
					}
				}
				else
				{
					//username is blank
					MessageBox.Show("Username cannot be blank!");
					this.textBoxUserName.Focus();
				}
			}
			catch(Exception ex)
			{
				MessageBox.Show("While trying to login, an exception was thrown. Exception : "+ex.Message,"Error",MessageBoxButtons.OK,MessageBoxIcon.Error);

			}
		}

		private void buttonCancel_Click(object sender, System.EventArgs e)
		{
			//exit without login
			FormMCMSManager.cmsApplicationContext.Dispose();
			this.DialogResult = DialogResult.Cancel;
			this.Close();
		}
		#endregion

		#region Basic Encryption

		private string Encrypt(string text)
		{
			byte[] mBytes = null;
			try
			{
				//creates a basic SymmetricAlgorithm to encrypt the password
				SymmetricAlgorithm  mCryptProv = SymmetricAlgorithm.Create();
				MemoryStream  mMemStr = new MemoryStream();
				//a key which is always used.. not the best idea, but easiest
				PasswordDeriveBytes pdb = new PasswordDeriveBytes("MCMSKey", 
					new byte[] {0x49, 0x76, 0x61, 0x6e, 0x20, 0x4d,  0x65, 0x64, 0x76, 0x65, 0x64, 0x65, 0x76}); 
				mCryptProv.Key = pdb.GetBytes(32);
				mCryptProv.IV = pdb.GetBytes(16);
				ICryptoTransform mTransform = mCryptProv.CreateEncryptor();
				CryptoStream mCSWriter = new CryptoStream(mMemStr, mTransform, CryptoStreamMode.Write);
				StreamWriter mSWriter = new StreamWriter(mCSWriter);
				mSWriter.Write(text);
				mSWriter.Flush();
				mCSWriter.FlushFinalBlock();
				mBytes = new byte[mMemStr.Length];
				mMemStr.Position = 0;
				mMemStr.Read(mBytes, 0, Convert.ToInt32(mMemStr.Length));
				mMemStr.Position = 0;
				//return base 64 string to save
				return Convert.ToBase64String(mBytes);
			}
			catch(Exception ex)
			{
				MessageBox.Show("Encryption exception : "+ex.Message,"Error",MessageBoxButtons.OK,MessageBoxIcon.Error);
			}
			return "";
		}

		private string Decrypt(string text)
		{
			StreamReader mStrREader = null;
			try
			{
				//decrypt the password from base64 string
				byte[] mBytes = Convert.FromBase64String(text);
				MemoryStream mMemStr = new MemoryStream();
				mMemStr.Write(mBytes,0,mBytes.Length);
				mMemStr.Position = 0;
				SymmetricAlgorithm  mCryptProv = SymmetricAlgorithm.Create();	
				PasswordDeriveBytes pdb = new PasswordDeriveBytes("MCMSKey", 
					new byte[] {0x49, 0x76, 0x61, 0x6e, 0x20, 0x4d,  0x65, 0x64, 0x76, 0x65, 0x64, 0x65, 0x76}); 
				mCryptProv.Key = pdb.GetBytes(32);
				mCryptProv.IV = pdb.GetBytes(16);
				ICryptoTransform mTransform = mCryptProv.CreateDecryptor();
				CryptoStream mCSReader = new CryptoStream(mMemStr, mTransform, CryptoStreamMode.Read);
				mStrREader = new StreamReader(mCSReader);
				return mStrREader.ReadToEnd();
			}
			catch(Exception ex)
			{
				MessageBox.Show("Decryption exception : "+ex.Message,"Error",MessageBoxButtons.OK,MessageBoxIcon.Error);
			}
			return "";
		}
		#endregion

	}
}
