/**
 * @file MCMSManager.cs
 *
 * MCMS Manager
 *
 * MCMS Manager is the legal property of its developer
 * Chester Ragel <chesterr@gmail.com> - Developer and Maintainer
 * Yahoo ID : chesterr1979 
 * MSN : chesterr79@hotmail.com
 *
 * If you want more information, found any bugs or have any doubts you 
 * can mail me or contact me through my yahoo id.
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2.1 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#region Namespaces
using System;
using System.Drawing;
using System.Collections;
using System.ComponentModel;
using System.Windows.Forms;
using System.Data;
using System.Configuration;
using System.IO;
using System.Diagnostics;
using System.Collections.Specialized;
//MCMS components
using Microsoft.ContentManagement.Common;
using Microsoft.ContentManagement.Publishing;
//Stefan/MSFT Resource Dependency
using StefanG.Tools;
#endregion

namespace MCMS
{
	/// <summary>
	/// This form does all the necessary works. Authentication is done 
	/// through the login page and this will give the needed functionality 
	/// to the program
	/// </summary>
	public class FormMCMSManager : System.Windows.Forms.Form
	{

		#region Control Initializion

		private System.Windows.Forms.ContextMenu contextMenuChannel;
		private System.Windows.Forms.ContextMenu contextMenuPosting;
		private System.Windows.Forms.MainMenu mainMenu;
		private System.Windows.Forms.ImageList imageListTree;
		private System.Windows.Forms.ImageList imageList;
		private System.ComponentModel.IContainer components;

		private ListViewColumnSorter lvwColumnSorter;
		private FloatControl thumbNailImage;

		private ListViewItem lastListItemOver = null;
		#endregion

		#region Static variables used throughout the session
		//common variables used accross the session
		public static CmsApplicationContext cmsApplicationContext;
		public static string serverName="";
		public static Posting currentPosting;
		public static string userName;
		public static string password;
		public static int thumbnailWidth;
		public static int thumbnailHeight;
		public static int resolutionWidth;
		public static int resolutionHeight;
		public static bool showPreview;
		public static string thumbnailPath;
		public static bool showPreviewResource;
		public static bool showPreviewTemplate;
		public static Size desktopSize;
		#endregion

		#region Private delegate to create image
		private delegate void CreateImagePostingDelegate(Channel channel);
		private delegate void CreateImageTemplateDelegate(TemplateGallery gallery);
		#endregion

		#region Private Variables
		#endregion
		
		#region Menu Item
		private MenuItem channelGuid = null;
		private MenuItem channelRefresh = null;
		private MenuItem channelOwnedBy = null;
		private MenuItem channelSearch = null;
		private MenuItem channelStatistics = null;

		private MenuItem resourceGGuid = null;
		private MenuItem resourceGRefresh = null;
		private MenuItem resourceGOwnedBy = null;
		
		private MenuItem templateGGuid = null;
		private MenuItem templateGRefresh = null;
		private MenuItem templateGOwnedBy = null;
        		
		private MenuItem postingGuid = null;
		private MenuItem postingTemplateGuid = null;
		private MenuItem postingReleaseOwner = null;
		private MenuItem postingOwner = null;
		private MenuItem postingApprove = null;
		private MenuItem postingSubmit = null;
		private MenuItem postingDecline = null;
		private MenuItem postingPublichedURL = null;
		private MenuItem postingUnPublichedURL = null;
		private MenuItem postingUpdateURL = null;
		private MenuItem postingEdit = null;
		private MenuItem postingProperties = null;
		private MenuItem postingConnected = null;

		private MenuItem resourceGuid = null;
		private MenuItem resourceOwner = null;
		private MenuItem resourceSave = null;
		private MenuItem resourceOpen = null;
		private MenuItem resourceUsingPosting = null;
        
		private MenuItem templateGuid = null;
		private MenuItem templateOwner = null;
		private MenuItem templateReleaseOwner = null;
		private MenuItem templateSubmit = null;
		private MenuItem templatePath = null;
		private MenuItem templateUsingPosting = null;
		private MenuItem templateSourceFile = null;

		private MenuItem generateExportScript = null;
        
		#endregion

		#region Views
		private TreeNode selectedNode = null;
		private System.Windows.Forms.ToolTip toolTip;
		private System.Windows.Forms.MenuItem menuFile;
		private System.Windows.Forms.MenuItem menuExit;
		private System.Windows.Forms.MenuItem menuItemTools;
		private System.Windows.Forms.MenuItem menuItemConvert;
		private System.Windows.Forms.MenuItem menuItemLogViewer;
		private System.Windows.Forms.MenuItem menuHelp;
		private System.Windows.Forms.MenuItem menuHowTo;
		private System.Windows.Forms.MenuItem menuAbout;
		private System.Windows.Forms.MenuItem menuItemSep;
		private System.Windows.Forms.MenuItem menuItemIntroduction;
		private System.Windows.Forms.MenuItem menuItemEditAPosting;
		private System.Windows.Forms.MenuItem menuItemEditProperties;
		private System.Windows.Forms.MenuItem menuItemReleaseOwnership;
		private System.Windows.Forms.MenuItem menuItemBrowse;
		private System.Windows.Forms.MenuItem menuItemSearch;
		private System.Windows.Forms.MenuItem menuItemReports;
		private System.Windows.Forms.MenuItem menuItem1;
		private System.Windows.Forms.MenuItem menuItem2;
		private System.Windows.Forms.MenuItem menuItem3;
		private System.Windows.Forms.MenuItem menuItem4;
		private System.Windows.Forms.MenuItem menuItemLogin;
		private System.Windows.Forms.MenuItem menuItem6;
		private System.Windows.Forms.ToolBar toolBar;
		private System.Windows.Forms.ToolBarButton toolBarButtonRefresh;
		private System.Windows.Forms.ImageList imageListToolbar;
		private System.Windows.Forms.Panel panelToolBar;
		private System.Windows.Forms.Panel panelTree;
		private System.Windows.Forms.TabControl tabControl;
		private System.Windows.Forms.TabPage tabPageChannels;
		private System.Windows.Forms.TreeView treeViewChannels;
		private System.Windows.Forms.TabPage tabPageResourceGallery;
		private System.Windows.Forms.TreeView treeViewResourceGallery;
		private System.Windows.Forms.TabPage tabPageTemplateGallery;
		private System.Windows.Forms.TreeView treeViewTemplateGallery;
		private System.Windows.Forms.Splitter splitter;
		private System.Windows.Forms.Panel panelPostings;
		private System.Windows.Forms.ListView listViewPostings;
		private System.Windows.Forms.ColumnHeader columnName;
		private System.Windows.Forms.ColumnHeader columnGUID;
		private System.Windows.Forms.ColumnHeader columnState;
		private System.Windows.Forms.ColumnHeader columnCreator;
		private System.Windows.Forms.ColumnHeader columnCreatedOn;
		private System.Windows.Forms.ContextMenu contextMenuResource;
		private System.Windows.Forms.ContextMenu contextMenuTemplate;
		private System.Windows.Forms.SaveFileDialog saveFileDialogResource;
		private System.Windows.Forms.MenuItem menuItem5;
		private System.Windows.Forms.MenuItem menuItemPostingTemplate;
		private System.Windows.Forms.MenuItem menuItem7;
		private System.Windows.Forms.MenuItem menuItemSaveResource;
		private System.Windows.Forms.MenuItem menuItemPostingResource;
		private System.Windows.Forms.MenuItem menuItemConnectedPostings;
		private System.Windows.Forms.MenuItem menuItem9;
		private System.Windows.Forms.MenuItem menuItemSeperator;
		private System.Windows.Forms.MenuItem menuItemOptions;
		private System.Windows.Forms.MenuItem menuItem8;
		private System.Windows.Forms.MenuItem menuItemThumbNail;
		private System.Windows.Forms.MenuItem menuItemUserGroupBackupRestore;
		private System.Windows.Forms.MenuItem menuItem11;
		private System.Windows.Forms.MenuItem menuItem12;
		private System.Windows.Forms.MenuItem menuItem13;
		private System.Windows.Forms.MenuItem menuItemExport;
		private System.Windows.Forms.MenuItem menuItem10;
		private System.Windows.Forms.MenuItem menuItemIncrementalExport;
		private System.Windows.Forms.MenuItem menuItemIncrementalImport;
		private System.Windows.Forms.MenuItem menuItem16;
		private System.Windows.Forms.MenuItem menuItemUserGroupBackupRestoreHelp;
		private ListViewItem selectedItem = null;
		#endregion

		#region Sorting

		private void listViewPostings_ColumnClick(object sender, System.Windows.Forms.ColumnClickEventArgs e)
		{
			if (e.Column == lvwColumnSorter.SortColumn)
			{
				// Reverse the current sort direction for this column.
				if (lvwColumnSorter.Order == SortOrder.Ascending)
				{
					lvwColumnSorter.Order = SortOrder.Descending;
				}
				else
				{
					lvwColumnSorter.Order = SortOrder.Ascending;
				}
			}
			else
			{
				// Set the column number that is to be sorted; default to ascending.
				lvwColumnSorter.SortColumn = e.Column;
				lvwColumnSorter.Order = SortOrder.Ascending;
			}

			// Perform the sort with these new sort options.
			this.listViewPostings.Sort();
		}

		#endregion

		#region Init/Dispose Controls

		private void menuItemExport_Click(object sender, System.EventArgs e)
		{
			FormExport export = new FormExport();
			export.Show();
		}

		private void menuItem11_Click(object sender, System.EventArgs e)
		{
			FormImport import = new FormImport();
			import.Show();
		}

		private void generateExportScript_Click(object sender, EventArgs e)
		{
			Channel channel = (Channel)selectedNode.Tag;
			if(channel!=null)
			{
				FormExport export = new FormExport(channel);
				export.Show();
			}
			else
			{
				MessageBox.Show("Specified channel not found.","Error",MessageBoxButtons.OK,MessageBoxIcon.Error);
			}
            
		}

		private void menuItemUserGroupBackupRestore_Click(object sender, System.EventArgs e)
		{
			FormUserGroup userGroup = new FormUserGroup();
			userGroup.Show();
		}

		public FormMCMSManager()
		{
			InitializeComponent();
		}

		protected override void Dispose( bool disposing )
		{
			if( disposing )
			{
				if (components != null) 
				{
					components.Dispose();
				}
			}
			base.Dispose( disposing );
		}

		#region Windows Form Designer generated code
		/// <summary>
		/// Required method for Designer support - do not modify
		/// the contents of this method with the code editor.
		/// </summary>
		private void InitializeComponent()
		{
			this.components = new System.ComponentModel.Container();
			System.Resources.ResourceManager resources = new System.Resources.ResourceManager(typeof(FormMCMSManager));
			this.contextMenuChannel = new System.Windows.Forms.ContextMenu();
			this.imageListTree = new System.Windows.Forms.ImageList(this.components);
			this.contextMenuPosting = new System.Windows.Forms.ContextMenu();
			this.imageList = new System.Windows.Forms.ImageList(this.components);
			this.mainMenu = new System.Windows.Forms.MainMenu();
			this.menuFile = new System.Windows.Forms.MenuItem();
			this.menuExit = new System.Windows.Forms.MenuItem();
			this.menuItemTools = new System.Windows.Forms.MenuItem();
			this.menuItemConvert = new System.Windows.Forms.MenuItem();
			this.menuItemLogViewer = new System.Windows.Forms.MenuItem();
			this.menuItemSeperator = new System.Windows.Forms.MenuItem();
			this.menuItemExport = new System.Windows.Forms.MenuItem();
			this.menuItem11 = new System.Windows.Forms.MenuItem();
			this.menuItem12 = new System.Windows.Forms.MenuItem();
			this.menuItemUserGroupBackupRestore = new System.Windows.Forms.MenuItem();
			this.menuItem13 = new System.Windows.Forms.MenuItem();
			this.menuItemOptions = new System.Windows.Forms.MenuItem();
			this.menuHelp = new System.Windows.Forms.MenuItem();
			this.menuItemIntroduction = new System.Windows.Forms.MenuItem();
			this.menuHowTo = new System.Windows.Forms.MenuItem();
			this.menuItemLogin = new System.Windows.Forms.MenuItem();
			this.menuItem6 = new System.Windows.Forms.MenuItem();
			this.menuItemBrowse = new System.Windows.Forms.MenuItem();
			this.menuItem2 = new System.Windows.Forms.MenuItem();
			this.menuItemEditAPosting = new System.Windows.Forms.MenuItem();
			this.menuItemEditProperties = new System.Windows.Forms.MenuItem();
			this.menuItem1 = new System.Windows.Forms.MenuItem();
			this.menuItemReleaseOwnership = new System.Windows.Forms.MenuItem();
			this.menuItem3 = new System.Windows.Forms.MenuItem();
			this.menuItemSearch = new System.Windows.Forms.MenuItem();
			this.menuItem4 = new System.Windows.Forms.MenuItem();
			this.menuItemReports = new System.Windows.Forms.MenuItem();
			this.menuItem5 = new System.Windows.Forms.MenuItem();
			this.menuItemPostingResource = new System.Windows.Forms.MenuItem();
			this.menuItemPostingTemplate = new System.Windows.Forms.MenuItem();
			this.menuItem7 = new System.Windows.Forms.MenuItem();
			this.menuItemSaveResource = new System.Windows.Forms.MenuItem();
			this.menuItem9 = new System.Windows.Forms.MenuItem();
			this.menuItemConnectedPostings = new System.Windows.Forms.MenuItem();
			this.menuItem8 = new System.Windows.Forms.MenuItem();
			this.menuItemThumbNail = new System.Windows.Forms.MenuItem();
			this.menuItemSep = new System.Windows.Forms.MenuItem();
			this.menuAbout = new System.Windows.Forms.MenuItem();
			this.toolTip = new System.Windows.Forms.ToolTip(this.components);
			this.treeViewChannels = new System.Windows.Forms.TreeView();
			this.toolBar = new System.Windows.Forms.ToolBar();
			this.toolBarButtonRefresh = new System.Windows.Forms.ToolBarButton();
			this.imageListToolbar = new System.Windows.Forms.ImageList(this.components);
			this.tabPageResourceGallery = new System.Windows.Forms.TabPage();
			this.treeViewResourceGallery = new System.Windows.Forms.TreeView();
			this.contextMenuResource = new System.Windows.Forms.ContextMenu();
			this.treeViewTemplateGallery = new System.Windows.Forms.TreeView();
			this.contextMenuTemplate = new System.Windows.Forms.ContextMenu();
			this.listViewPostings = new System.Windows.Forms.ListView();
			this.columnName = new System.Windows.Forms.ColumnHeader();
			this.columnGUID = new System.Windows.Forms.ColumnHeader();
			this.columnState = new System.Windows.Forms.ColumnHeader();
			this.columnCreator = new System.Windows.Forms.ColumnHeader();
			this.columnCreatedOn = new System.Windows.Forms.ColumnHeader();
			this.panelToolBar = new System.Windows.Forms.Panel();
			this.panelTree = new System.Windows.Forms.Panel();
			this.tabControl = new System.Windows.Forms.TabControl();
			this.tabPageChannels = new System.Windows.Forms.TabPage();
			this.tabPageTemplateGallery = new System.Windows.Forms.TabPage();
			this.splitter = new System.Windows.Forms.Splitter();
			this.panelPostings = new System.Windows.Forms.Panel();
			this.saveFileDialogResource = new System.Windows.Forms.SaveFileDialog();
			this.menuItem10 = new System.Windows.Forms.MenuItem();
			this.menuItemIncrementalExport = new System.Windows.Forms.MenuItem();
			this.menuItemIncrementalImport = new System.Windows.Forms.MenuItem();
			this.menuItem16 = new System.Windows.Forms.MenuItem();
			this.menuItemUserGroupBackupRestoreHelp = new System.Windows.Forms.MenuItem();
			this.tabPageResourceGallery.SuspendLayout();
			this.panelToolBar.SuspendLayout();
			this.panelTree.SuspendLayout();
			this.tabControl.SuspendLayout();
			this.tabPageChannels.SuspendLayout();
			this.tabPageTemplateGallery.SuspendLayout();
			this.panelPostings.SuspendLayout();
			this.SuspendLayout();
			// 
			// imageListTree
			// 
			this.imageListTree.ImageSize = new System.Drawing.Size(16, 16);
			this.imageListTree.ImageStream = ((System.Windows.Forms.ImageListStreamer)(resources.GetObject("imageListTree.ImageStream")));
			this.imageListTree.TransparentColor = System.Drawing.Color.Transparent;
			// 
			// imageList
			// 
			this.imageList.ImageSize = new System.Drawing.Size(16, 16);
			this.imageList.ImageStream = ((System.Windows.Forms.ImageListStreamer)(resources.GetObject("imageList.ImageStream")));
			this.imageList.TransparentColor = System.Drawing.Color.Transparent;
			// 
			// mainMenu
			// 
			this.mainMenu.MenuItems.AddRange(new System.Windows.Forms.MenuItem[] {
																					 this.menuFile,
																					 this.menuItemTools,
																					 this.menuHelp});
			// 
			// menuFile
			// 
			this.menuFile.Index = 0;
			this.menuFile.MenuItems.AddRange(new System.Windows.Forms.MenuItem[] {
																					 this.menuExit});
			this.menuFile.Text = "&File";
			// 
			// menuExit
			// 
			this.menuExit.Index = 0;
			this.menuExit.Text = "E&xit";
			this.menuExit.Click += new System.EventHandler(this.menuExit_Click);
			// 
			// menuItemTools
			// 
			this.menuItemTools.Index = 1;
			this.menuItemTools.MenuItems.AddRange(new System.Windows.Forms.MenuItem[] {
																						  this.menuItemConvert,
																						  this.menuItemLogViewer,
																						  this.menuItemSeperator,
																						  this.menuItemExport,
																						  this.menuItem11,
																						  this.menuItem12,
																						  this.menuItemUserGroupBackupRestore,
																						  this.menuItem13,
																						  this.menuItemOptions});
			this.menuItemTools.Text = "&Tools";
			// 
			// menuItemConvert
			// 
			this.menuItemConvert.Index = 0;
			this.menuItemConvert.Text = "&Convert";
			this.menuItemConvert.Click += new System.EventHandler(this.menuItemConvert_Click);
			// 
			// menuItemLogViewer
			// 
			this.menuItemLogViewer.Index = 1;
			this.menuItemLogViewer.Text = "&Log Viewer";
			this.menuItemLogViewer.Click += new System.EventHandler(this.menuItemLogViewer_Click);
			// 
			// menuItemSeperator
			// 
			this.menuItemSeperator.Index = 2;
			this.menuItemSeperator.Text = "-";
			// 
			// menuItemExport
			// 
			this.menuItemExport.Index = 3;
			this.menuItemExport.Text = "Incremental Export Sc&ript";
			this.menuItemExport.Click += new System.EventHandler(this.menuItemExport_Click);
			// 
			// menuItem11
			// 
			this.menuItem11.Index = 4;
			this.menuItem11.Text = "Incremental Import Scr&ipt";
			this.menuItem11.Click += new System.EventHandler(this.menuItem11_Click);
			// 
			// menuItem12
			// 
			this.menuItem12.Index = 5;
			this.menuItem12.Text = "-";
			// 
			// menuItemUserGroupBackupRestore
			// 
			this.menuItemUserGroupBackupRestore.Index = 6;
			this.menuItemUserGroupBackupRestore.Text = "UserGroupBack&upRestore";
			this.menuItemUserGroupBackupRestore.Click += new System.EventHandler(this.menuItemUserGroupBackupRestore_Click);
			// 
			// menuItem13
			// 
			this.menuItem13.Index = 7;
			this.menuItem13.Text = "-";
			// 
			// menuItemOptions
			// 
			this.menuItemOptions.Index = 8;
			this.menuItemOptions.Text = "&Options";
			this.menuItemOptions.Click += new System.EventHandler(this.menuItemOptions_Click);
			// 
			// menuHelp
			// 
			this.menuHelp.Index = 2;
			this.menuHelp.MenuItems.AddRange(new System.Windows.Forms.MenuItem[] {
																					 this.menuItemIntroduction,
																					 this.menuHowTo,
																					 this.menuItemSep,
																					 this.menuAbout});
			this.menuHelp.Text = "&Help";
			// 
			// menuItemIntroduction
			// 
			this.menuItemIntroduction.Index = 0;
			this.menuItemIntroduction.Text = "&Introduction";
			this.menuItemIntroduction.Click += new System.EventHandler(this.menuItemIntroduction_Click);
			// 
			// menuHowTo
			// 
			this.menuHowTo.Index = 1;
			this.menuHowTo.MenuItems.AddRange(new System.Windows.Forms.MenuItem[] {
																					  this.menuItemLogin,
																					  this.menuItem6,
																					  this.menuItemBrowse,
																					  this.menuItem2,
																					  this.menuItemEditAPosting,
																					  this.menuItemEditProperties,
																					  this.menuItem1,
																					  this.menuItemReleaseOwnership,
																					  this.menuItem3,
																					  this.menuItemSearch,
																					  this.menuItem4,
																					  this.menuItemReports,
																					  this.menuItem5,
																					  this.menuItemPostingResource,
																					  this.menuItemPostingTemplate,
																					  this.menuItem7,
																					  this.menuItemSaveResource,
																					  this.menuItem9,
																					  this.menuItemConnectedPostings,
																					  this.menuItem8,
																					  this.menuItemThumbNail,
																					  this.menuItem10,
																					  this.menuItemIncrementalExport,
																					  this.menuItemIncrementalImport,
																					  this.menuItem16,
																					  this.menuItemUserGroupBackupRestoreHelp});
			this.menuHowTo.Text = "Ho&w To....";
			// 
			// menuItemLogin
			// 
			this.menuItemLogin.Index = 0;
			this.menuItemLogin.Text = "&Login";
			this.menuItemLogin.Click += new System.EventHandler(this.menuItemLogin_Click);
			// 
			// menuItem6
			// 
			this.menuItem6.Index = 1;
			this.menuItem6.Text = "-";
			// 
			// menuItemBrowse
			// 
			this.menuItemBrowse.Index = 2;
			this.menuItemBrowse.Text = "&Browse";
			this.menuItemBrowse.Click += new System.EventHandler(this.menuItemBrowse_Click);
			// 
			// menuItem2
			// 
			this.menuItem2.Index = 3;
			this.menuItem2.Text = "-";
			// 
			// menuItemEditAPosting
			// 
			this.menuItemEditAPosting.Index = 4;
			this.menuItemEditAPosting.Text = "&Edit a posting";
			this.menuItemEditAPosting.Click += new System.EventHandler(this.menuItemEditAPosting_Click);
			// 
			// menuItemEditProperties
			// 
			this.menuItemEditProperties.Index = 5;
			this.menuItemEditProperties.Text = "Edit &properties";
			this.menuItemEditProperties.Click += new System.EventHandler(this.menuItemEditProperties_Click);
			// 
			// menuItem1
			// 
			this.menuItem1.Index = 6;
			this.menuItem1.Text = "-";
			// 
			// menuItemReleaseOwnership
			// 
			this.menuItemReleaseOwnership.Index = 7;
			this.menuItemReleaseOwnership.Text = "&Release ownership";
			this.menuItemReleaseOwnership.Click += new System.EventHandler(this.menuItemReleaseOwnership_Click);
			// 
			// menuItem3
			// 
			this.menuItem3.Index = 8;
			this.menuItem3.Text = "-";
			// 
			// menuItemSearch
			// 
			this.menuItemSearch.Index = 9;
			this.menuItemSearch.Text = "&Search";
			this.menuItemSearch.Click += new System.EventHandler(this.menuItemSearch_Click);
			// 
			// menuItem4
			// 
			this.menuItem4.Index = 10;
			this.menuItem4.Text = "-";
			// 
			// menuItemReports
			// 
			this.menuItemReports.Index = 11;
			this.menuItemReports.Text = "Generate Rep&ort";
			this.menuItemReports.Click += new System.EventHandler(this.menuItemReports_Click);
			// 
			// menuItem5
			// 
			this.menuItem5.Index = 12;
			this.menuItem5.Text = "-";
			// 
			// menuItemPostingResource
			// 
			this.menuItemPostingResource.Index = 13;
			this.menuItemPostingResource.Text = "Postings on a Resource";
			this.menuItemPostingResource.Click += new System.EventHandler(this.menuItemPostingResource_Click);
			// 
			// menuItemPostingTemplate
			// 
			this.menuItemPostingTemplate.Index = 14;
			this.menuItemPostingTemplate.Text = "Postings on a Template";
			this.menuItemPostingTemplate.Click += new System.EventHandler(this.menuItemPostingTemplate_Click);
			// 
			// menuItem7
			// 
			this.menuItem7.Index = 15;
			this.menuItem7.Text = "-";
			// 
			// menuItemSaveResource
			// 
			this.menuItemSaveResource.Index = 16;
			this.menuItemSaveResource.Text = "Save Resource";
			this.menuItemSaveResource.Click += new System.EventHandler(this.menuItemSaveResource_Click);
			// 
			// menuItem9
			// 
			this.menuItem9.Index = 17;
			this.menuItem9.Text = "-";
			// 
			// menuItemConnectedPostings
			// 
			this.menuItemConnectedPostings.Index = 18;
			this.menuItemConnectedPostings.Text = "Connected Postings";
			this.menuItemConnectedPostings.Click += new System.EventHandler(this.menuItemConnectedPostings_Click);
			// 
			// menuItem8
			// 
			this.menuItem8.Index = 19;
			this.menuItem8.Text = "-";
			// 
			// menuItemThumbNail
			// 
			this.menuItemThumbNail.Index = 20;
			this.menuItemThumbNail.Text = "Preview";
			this.menuItemThumbNail.Click += new System.EventHandler(this.menuItemThumbNail_Click);
			// 
			// menuItemSep
			// 
			this.menuItemSep.Index = 2;
			this.menuItemSep.Text = "-";
			// 
			// menuAbout
			// 
			this.menuAbout.Index = 3;
			this.menuAbout.Text = "A&bout";
			this.menuAbout.Click += new System.EventHandler(this.menuAbout_Click);
			// 
			// treeViewChannels
			// 
			this.treeViewChannels.ContextMenu = this.contextMenuChannel;
			this.treeViewChannels.Dock = System.Windows.Forms.DockStyle.Fill;
			this.treeViewChannels.ImageList = this.imageListTree;
			this.treeViewChannels.Location = new System.Drawing.Point(0, 0);
			this.treeViewChannels.Name = "treeViewChannels";
			this.treeViewChannels.SelectedImageIndex = 1;
			this.treeViewChannels.Size = new System.Drawing.Size(208, 519);
			this.treeViewChannels.TabIndex = 0;
			this.toolTip.SetToolTip(this.treeViewChannels, "Channel Browser");
			this.treeViewChannels.MouseDown += new System.Windows.Forms.MouseEventHandler(this.treeViewChannels_MouseDown);
			this.treeViewChannels.AfterExpand += new System.Windows.Forms.TreeViewEventHandler(this.treeViewChannels_AfterExpand);
			this.treeViewChannels.AfterSelect += new System.Windows.Forms.TreeViewEventHandler(this.treeViewChannels_AfterSelect);
			// 
			// toolBar
			// 
			this.toolBar.Buttons.AddRange(new System.Windows.Forms.ToolBarButton[] {
																					   this.toolBarButtonRefresh});
			this.toolBar.DropDownArrows = true;
			this.toolBar.ImageList = this.imageListToolbar;
			this.toolBar.Location = new System.Drawing.Point(0, 0);
			this.toolBar.Name = "toolBar";
			this.toolBar.ShowToolTips = true;
			this.toolBar.Size = new System.Drawing.Size(952, 42);
			this.toolBar.TabIndex = 3;
			this.toolTip.SetToolTip(this.toolBar, "This will create a new CmsApplicationContext");
			this.toolBar.ButtonClick += new System.Windows.Forms.ToolBarButtonClickEventHandler(this.toolBar_ButtonClick);
			// 
			// toolBarButtonRefresh
			// 
			this.toolBarButtonRefresh.ImageIndex = 0;
			this.toolBarButtonRefresh.Text = "Refresh";
			// 
			// imageListToolbar
			// 
			this.imageListToolbar.ImageSize = new System.Drawing.Size(16, 16);
			this.imageListToolbar.ImageStream = ((System.Windows.Forms.ImageListStreamer)(resources.GetObject("imageListToolbar.ImageStream")));
			this.imageListToolbar.TransparentColor = System.Drawing.Color.Transparent;
			// 
			// tabPageResourceGallery
			// 
			this.tabPageResourceGallery.Controls.Add(this.treeViewResourceGallery);
			this.tabPageResourceGallery.Location = new System.Drawing.Point(4, 4);
			this.tabPageResourceGallery.Name = "tabPageResourceGallery";
			this.tabPageResourceGallery.Size = new System.Drawing.Size(208, 519);
			this.tabPageResourceGallery.TabIndex = 1;
			this.tabPageResourceGallery.Text = "Resources";
			this.toolTip.SetToolTip(this.tabPageResourceGallery, "Resource Gallery Browser");
			this.tabPageResourceGallery.Visible = false;
			// 
			// treeViewResourceGallery
			// 
			this.treeViewResourceGallery.ContextMenu = this.contextMenuResource;
			this.treeViewResourceGallery.Dock = System.Windows.Forms.DockStyle.Fill;
			this.treeViewResourceGallery.ImageIndex = 2;
			this.treeViewResourceGallery.ImageList = this.imageListTree;
			this.treeViewResourceGallery.Location = new System.Drawing.Point(0, 0);
			this.treeViewResourceGallery.Name = "treeViewResourceGallery";
			this.treeViewResourceGallery.SelectedImageIndex = 3;
			this.treeViewResourceGallery.Size = new System.Drawing.Size(208, 519);
			this.treeViewResourceGallery.TabIndex = 0;
			this.toolTip.SetToolTip(this.treeViewResourceGallery, "Resource Gallery Browser");
			this.treeViewResourceGallery.MouseDown += new System.Windows.Forms.MouseEventHandler(this.treeViewResourceGallery_MouseDown);
			this.treeViewResourceGallery.AfterExpand += new System.Windows.Forms.TreeViewEventHandler(this.treeViewResourceGallery_AfterExpand);
			this.treeViewResourceGallery.AfterSelect += new System.Windows.Forms.TreeViewEventHandler(this.treeViewResourceGallery_AfterSelect);
			// 
			// treeViewTemplateGallery
			// 
			this.treeViewTemplateGallery.ContextMenu = this.contextMenuTemplate;
			this.treeViewTemplateGallery.Dock = System.Windows.Forms.DockStyle.Fill;
			this.treeViewTemplateGallery.ImageIndex = 5;
			this.treeViewTemplateGallery.ImageList = this.imageListTree;
			this.treeViewTemplateGallery.Location = new System.Drawing.Point(0, 0);
			this.treeViewTemplateGallery.Name = "treeViewTemplateGallery";
			this.treeViewTemplateGallery.SelectedImageIndex = 6;
			this.treeViewTemplateGallery.Size = new System.Drawing.Size(208, 519);
			this.treeViewTemplateGallery.TabIndex = 0;
			this.toolTip.SetToolTip(this.treeViewTemplateGallery, "Template Gallery Browser");
			this.treeViewTemplateGallery.MouseDown += new System.Windows.Forms.MouseEventHandler(this.treeViewTemplateGallery_MouseDown);
			this.treeViewTemplateGallery.AfterExpand += new System.Windows.Forms.TreeViewEventHandler(this.treeViewTemplateGallery_AfterExpand);
			this.treeViewTemplateGallery.AfterSelect += new System.Windows.Forms.TreeViewEventHandler(this.treeViewTemplateGallery_AfterSelect);
			// 
			// listViewPostings
			// 
			this.listViewPostings.AllowColumnReorder = true;
			this.listViewPostings.Columns.AddRange(new System.Windows.Forms.ColumnHeader[] {
																							   this.columnName,
																							   this.columnGUID,
																							   this.columnState,
																							   this.columnCreator,
																							   this.columnCreatedOn});
			this.listViewPostings.ContextMenu = this.contextMenuPosting;
			this.listViewPostings.Dock = System.Windows.Forms.DockStyle.Fill;
			this.listViewPostings.FullRowSelect = true;
			this.listViewPostings.LargeImageList = this.imageList;
			this.listViewPostings.Location = new System.Drawing.Point(0, 0);
			this.listViewPostings.MultiSelect = false;
			this.listViewPostings.Name = "listViewPostings";
			this.listViewPostings.Size = new System.Drawing.Size(733, 545);
			this.listViewPostings.SmallImageList = this.imageList;
			this.listViewPostings.Sorting = System.Windows.Forms.SortOrder.Ascending;
			this.listViewPostings.StateImageList = this.imageList;
			this.listViewPostings.TabIndex = 0;
			this.listViewPostings.View = System.Windows.Forms.View.Details;
			this.listViewPostings.MouseDown += new System.Windows.Forms.MouseEventHandler(this.listViewPostings_MouseDown);
			this.listViewPostings.DoubleClick += new System.EventHandler(this.listViewPostings_DoubleClick);
			this.listViewPostings.ColumnClick += new System.Windows.Forms.ColumnClickEventHandler(this.listViewPostings_ColumnClick);
			this.listViewPostings.MouseMove += new System.Windows.Forms.MouseEventHandler(this.listViewPostings_MouseMove);
			this.listViewPostings.MouseLeave += new System.EventHandler(this.listViewPostings_MouseLeave);
			// 
			// columnName
			// 
			this.columnName.Text = "Name";
			this.columnName.Width = 200;
			// 
			// columnGUID
			// 
			this.columnGUID.Text = "Guid";
			this.columnGUID.Width = 243;
			// 
			// columnState
			// 
			this.columnState.Text = "Posting State";
			this.columnState.Width = 140;
			// 
			// columnCreator
			// 
			this.columnCreator.Text = "Created By";
			this.columnCreator.Width = 79;
			// 
			// columnCreatedOn
			// 
			this.columnCreatedOn.Text = "Created On";
			this.columnCreatedOn.Width = 138;
			// 
			// panelToolBar
			// 
			this.panelToolBar.Controls.Add(this.toolBar);
			this.panelToolBar.Dock = System.Windows.Forms.DockStyle.Top;
			this.panelToolBar.Location = new System.Drawing.Point(0, 0);
			this.panelToolBar.Name = "panelToolBar";
			this.panelToolBar.Size = new System.Drawing.Size(952, 40);
			this.panelToolBar.TabIndex = 4;
			// 
			// panelTree
			// 
			this.panelTree.Controls.Add(this.tabControl);
			this.panelTree.Dock = System.Windows.Forms.DockStyle.Left;
			this.panelTree.Location = new System.Drawing.Point(0, 40);
			this.panelTree.Name = "panelTree";
			this.panelTree.Size = new System.Drawing.Size(216, 545);
			this.panelTree.TabIndex = 5;
			// 
			// tabControl
			// 
			this.tabControl.Alignment = System.Windows.Forms.TabAlignment.Bottom;
			this.tabControl.Controls.Add(this.tabPageChannels);
			this.tabControl.Controls.Add(this.tabPageResourceGallery);
			this.tabControl.Controls.Add(this.tabPageTemplateGallery);
			this.tabControl.Dock = System.Windows.Forms.DockStyle.Fill;
			this.tabControl.Location = new System.Drawing.Point(0, 0);
			this.tabControl.Name = "tabControl";
			this.tabControl.Padding = new System.Drawing.Point(0, 0);
			this.tabControl.SelectedIndex = 0;
			this.tabControl.Size = new System.Drawing.Size(216, 545);
			this.tabControl.TabIndex = 1;
			this.tabControl.SelectedIndexChanged += new System.EventHandler(this.tabControl_SelectedIndexChanged);
			// 
			// tabPageChannels
			// 
			this.tabPageChannels.Controls.Add(this.treeViewChannels);
			this.tabPageChannels.Location = new System.Drawing.Point(4, 4);
			this.tabPageChannels.Name = "tabPageChannels";
			this.tabPageChannels.Size = new System.Drawing.Size(208, 519);
			this.tabPageChannels.TabIndex = 0;
			this.tabPageChannels.Text = "Channels";
			// 
			// tabPageTemplateGallery
			// 
			this.tabPageTemplateGallery.Controls.Add(this.treeViewTemplateGallery);
			this.tabPageTemplateGallery.Location = new System.Drawing.Point(4, 4);
			this.tabPageTemplateGallery.Name = "tabPageTemplateGallery";
			this.tabPageTemplateGallery.Size = new System.Drawing.Size(208, 519);
			this.tabPageTemplateGallery.TabIndex = 2;
			this.tabPageTemplateGallery.Text = "Templates";
			this.tabPageTemplateGallery.Visible = false;
			// 
			// splitter
			// 
			this.splitter.Location = new System.Drawing.Point(216, 40);
			this.splitter.Name = "splitter";
			this.splitter.Size = new System.Drawing.Size(3, 545);
			this.splitter.TabIndex = 6;
			this.splitter.TabStop = false;
			// 
			// panelPostings
			// 
			this.panelPostings.Controls.Add(this.listViewPostings);
			this.panelPostings.Dock = System.Windows.Forms.DockStyle.Fill;
			this.panelPostings.Location = new System.Drawing.Point(219, 40);
			this.panelPostings.Name = "panelPostings";
			this.panelPostings.Size = new System.Drawing.Size(733, 545);
			this.panelPostings.TabIndex = 7;
			// 
			// saveFileDialogResource
			// 
			this.saveFileDialogResource.Filter = "All files | *.*";
			// 
			// menuItem10
			// 
			this.menuItem10.Index = 21;
			this.menuItem10.Text = "-";
			// 
			// menuItemIncrementalExport
			// 
			this.menuItemIncrementalExport.Index = 22;
			this.menuItemIncrementalExport.Text = "Incremental Export ";
			this.menuItemIncrementalExport.Click += new System.EventHandler(this.menuItemIncrementalExport_Click);
			// 
			// menuItemIncrementalImport
			// 
			this.menuItemIncrementalImport.Index = 23;
			this.menuItemIncrementalImport.Text = "Incremental Import";
			this.menuItemIncrementalImport.Click += new System.EventHandler(this.menuItemIncrementalImport_Click);
			// 
			// menuItem16
			// 
			this.menuItem16.Index = 24;
			this.menuItem16.Text = "-";
			// 
			// menuItemUserGroupBackupRestoreHelp
			// 
			this.menuItemUserGroupBackupRestoreHelp.Index = 25;
			this.menuItemUserGroupBackupRestoreHelp.Text = "UserGroupBackupRestore";
			this.menuItemUserGroupBackupRestoreHelp.Click += new System.EventHandler(this.menuItemUserGroupBackupRestoreHelp_Click);
			// 
			// FormMCMSManager
			// 
			this.AutoScaleBaseSize = new System.Drawing.Size(5, 13);
			this.ClientSize = new System.Drawing.Size(952, 585);
			this.Controls.Add(this.panelPostings);
			this.Controls.Add(this.splitter);
			this.Controls.Add(this.panelTree);
			this.Controls.Add(this.panelToolBar);
			this.Icon = ((System.Drawing.Icon)(resources.GetObject("$this.Icon")));
			this.Menu = this.mainMenu;
			this.Name = "FormMCMSManager";
			this.StartPosition = System.Windows.Forms.FormStartPosition.CenterScreen;
			this.Text = "MCMS Manager";
			this.Load += new System.EventHandler(this.FormMCMSManager_Load);
			this.tabPageResourceGallery.ResumeLayout(false);
			this.panelToolBar.ResumeLayout(false);
			this.panelTree.ResumeLayout(false);
			this.tabControl.ResumeLayout(false);
			this.tabPageChannels.ResumeLayout(false);
			this.tabPageTemplateGallery.ResumeLayout(false);
			this.panelPostings.ResumeLayout(false);
			this.ResumeLayout(false);

		}
		#endregion

		private void menuExit_Click(object sender, System.EventArgs e)
		{
			//When exit, dispose the context
			cmsApplicationContext.Dispose();
			this.Close();
		}

		private void menuAbout_Click(object sender, System.EventArgs e)
		{
			FormAbout about = new FormAbout();
			about.ShowDialog();
		}

		[STAThread]
		static void Main() 
		{
			//get the current process
			Process oCurrentProcess = Process.GetCurrentProcess();

			//get all other process by the same name, atleast one will be returned - the current one.
			Process[] arrProcesses = Process.GetProcessesByName(oCurrentProcess.ProcessName);

			bool bProcess = false;
			//go thru all of them
			foreach(Process oProcess in arrProcesses)
			{
				//if the id is different, that means another process by the same name exists
				if(oProcess.Id != oCurrentProcess.Id) //
				{
					bProcess = true;
					break;
				}
			}

			if(!bProcess)
			{
				//if process not found, start one
				Application.Run(new FormMCMSManager());
			}
			else
			{
				//else exit
				Application.Exit();

			}
		}

		//Login is done in the form load
		private void FormMCMSManager_Load(object sender, System.EventArgs e)
		{
			bool exit = false;
			FormLogin login = new FormLogin();
			//Until login/exit do the check again and again
			while(!exit)
			{
				DialogResult result = login.ShowDialog();
				if(result==DialogResult.Cancel)
				{
					this.Close();
					exit = true;
				}
				else if(result==DialogResult.OK)
				{
					Init();
					this.WindowState = FormWindowState.Maximized;
					this.listViewPostings.Sorting = SortOrder.Ascending;
					break;
				}
			}
		}

		//Inititalize the controls
		private void Init()
		{
			this.WindowState = FormWindowState.Maximized;
			FormMCMSManager.desktopSize = new Size(Screen.PrimaryScreen.Bounds.Width,Screen.PrimaryScreen.Bounds.Height);
			//thumbnail init
			this.thumbNailImage = new FloatControl();
			this.thumbNailImage.Name = "Thumbnail";
			this.thumbNailImage.TabStop = false;
			this.thumbNailImage.Visible = false;

			lvwColumnSorter = new ListViewColumnSorter();
			this.listViewPostings.ListViewItemSorter = lvwColumnSorter;
			lvwColumnSorter.Order = SortOrder.Ascending;
			listViewPostings.Sort();
			//Clear treeview
			treeViewChannels.Nodes.Clear();
			//The parent node to add all the child nodes
			TreeNode currentNode = new TreeNode(cmsApplicationContext.RootChannel.Name);
			currentNode.Tag = cmsApplicationContext.RootChannel;
			ChannelImage(cmsApplicationContext.RootChannel,currentNode);
			treeViewChannels.Nodes.Add(currentNode);
			BuildChannels(cmsApplicationContext.RootChannel,treeViewChannels.Nodes[0]);
			treeViewChannels.SelectedNode = treeViewChannels.Nodes[0];

			#region Menu Item initialization

			#region Tree view Channel
			channelGuid = new MenuItem("Guid");
			channelOwnedBy = new MenuItem("Owned By");
			channelSearch = new MenuItem("Search");
			channelStatistics = new MenuItem("Statistics");
			channelRefresh = new MenuItem("Refresh");
			
			channelGuid.Click +=new EventHandler(channelGuid_Click);
			channelOwnedBy.Click +=new EventHandler(channelOwnedBy_Click);
			channelRefresh.Click +=new EventHandler(channelRefresh_Click);
			channelSearch.Click +=new EventHandler(channelSearch_Click);
			channelStatistics.Click +=new EventHandler(channelStatistics_Click);
			#endregion

			#region TreeView Resource
			resourceGGuid = new MenuItem("Guid");
			resourceGOwnedBy = new MenuItem("Owned By");
			resourceGRefresh = new MenuItem("Refresh");

			resourceGGuid.Click +=new EventHandler(resourceGGuid_Click);
			resourceGOwnedBy.Click +=new EventHandler(resourceGOwnedBy_Click);
			resourceGRefresh.Click+=new EventHandler(resourceGRefresh_Click);
			#endregion

			#region Treeview Template
			templateGGuid = new MenuItem("Guid");
			templateGOwnedBy = new MenuItem("Owned By");
			templateGRefresh = new MenuItem("Refresh");

			templateGGuid.Click +=new EventHandler(templateGGuid_Click);
			templateGOwnedBy.Click +=new EventHandler(templateGOwnedBy_Click);
			templateGRefresh.Click +=new EventHandler(templateGRefresh_Click);
			#endregion
			
			#region Posting Listview
			postingTemplateGuid = new MenuItem("Template Guid");
			postingGuid = new MenuItem("Posting Guid");
			postingReleaseOwner = new MenuItem("Kill Lock");
			postingOwner = new MenuItem("Owned By");
			postingApprove = new MenuItem("Approve");
			postingDecline = new MenuItem("Decline");
			postingSubmit = new MenuItem("Submit");
			postingPublichedURL = new MenuItem("Open in Published Mode");
			postingUpdateURL = new MenuItem("Open in Update Mode");
			postingUnPublichedURL = new MenuItem("Open in Unpublished Mode");
			postingEdit = new MenuItem("Edit");
			postingProperties = new MenuItem("Edit Custom Properties");
			postingConnected = new MenuItem("Get Connected Postings");

			postingTemplateGuid.Click +=new EventHandler(postingTemplateGuid_Click);
			postingGuid.Click +=new EventHandler(postingGuid_Click);
			postingReleaseOwner.Click +=new EventHandler(postingReleaseOwner_Click);
			postingOwner.Click +=new EventHandler(postingOwner_Click);
			postingApprove.Click +=new EventHandler(postingApprove_Click);
			postingDecline.Click +=new EventHandler(postingDecline_Click);
			postingSubmit.Click+=new EventHandler(postingSubmit_Click);
			postingPublichedURL.Click +=new EventHandler(postingPublichedURL_Click);
			postingUnPublichedURL.Click +=new EventHandler(postingUnPublichedURL_Click);
			postingUpdateURL.Click +=new EventHandler(postingUpdateURL_Click);
			postingEdit.Click +=new EventHandler(postingEdit_Click);
			postingProperties.Click +=new EventHandler(postingProperties_Click);
			postingConnected.Click +=new EventHandler(postingConnected_Click);
			
			#endregion 

			#region Resource ListView
			resourceGuid = new MenuItem("Guid");
			resourceOwner = new MenuItem("Owned By");
			resourceOpen = new MenuItem("Browse");
			resourceSave = new MenuItem("Save As");
			resourceUsingPosting = new MenuItem("Using Postings");

			resourceGuid.Click +=new EventHandler(resourceGuid_Click);
			resourceOwner.Click +=new EventHandler(resourceOwner_Click);
			resourceOpen.Click +=new EventHandler(resourceOpen_Click);
			resourceSave.Click +=new EventHandler(resourceSave_Click);
			resourceUsingPosting.Click +=new EventHandler(resourceUsingPosting_Click);
			#endregion 

			#region Template ListView
			templateGuid = new MenuItem("Guid");
			templateOwner = new MenuItem("Owned By");
			templateReleaseOwner = new MenuItem("Kill Lock");
			templateSubmit = new MenuItem("Submit");
			templatePath = new MenuItem("Path");
			templateUsingPosting = new MenuItem("Using Postings");
			templateSourceFile = new MenuItem("Source File");

			templateGuid.Click +=new EventHandler(templateGuid_Click);
			templateOwner.Click +=new EventHandler(templateOwner_Click);
			templateReleaseOwner.Click +=new EventHandler(templateReleaseOwner_Click);
			templateSubmit.Click +=new EventHandler(templateSubmit_Click);
			templatePath.Click +=new EventHandler(templatePath_Click);
			templateUsingPosting.Click +=new EventHandler(templateUsingPosting_Click);
			templateSourceFile.Click +=new EventHandler(templateSourceFile_Click);

			#endregion

			#region Script
			
			generateExportScript = new MenuItem("Generate Export Script");
			generateExportScript.Click +=new EventHandler(generateExportScript_Click);
			
			#endregion

			#endregion
		}

		#endregion

		#region Channel

		private void treeViewChannels_AfterExpand(object sender, System.Windows.Forms.TreeViewEventArgs e)
		{
			if(e.Node.FirstNode!= null && e.Node.FirstNode.IsVisible && e.Node.FirstNode.FirstNode==null)
			{
				Channel c = e.Node.Tag as Channel;
				if(c!=null && c.Channels!= null && c.Channels.Count>0)
				{
					for(int i=0;i<c.Channels.Count;i++)
					{
						BuildChannels(c.Channels[i],e.Node.Nodes[i]);
					}
				}
			}
		}

		private void ThumbnailChannel(Channel channel)
		{
			try
			{
				if(FormMCMSManager.showPreview)
				{
					string postingUrls="";
					for(int j=0;j<channel.Postings.Count;j++)
					{
						//is this the only way to find find...
						if(channel.Postings[j].UrlModePublished.ToLower().StartsWith("http://"))
						{
							postingUrls += channel.Postings[j].UrlModePublished+"|"+FormMCMSManager.thumbnailPath+"\\"+channel.Postings[j].Guid+".jpg"+"|"+FormMCMSManager.resolutionWidth+"|"+FormMCMSManager.resolutionHeight+"|"+FormMCMSManager.thumbnailWidth+"|"+FormMCMSManager.thumbnailHeight+"|";
						}
						else
						{
							postingUrls += FormMCMSManager.serverName+channel.Postings[j].UrlModePublished+"|"+FormMCMSManager.thumbnailPath+"\\"+channel.Postings[j].Guid+".jpg"+"|"+FormMCMSManager.resolutionWidth+"|"+FormMCMSManager.resolutionHeight+"|"+FormMCMSManager.thumbnailWidth+"|"+FormMCMSManager.thumbnailHeight+"|";
						}
						int oupPara = 0;
						//may be 5 is too much. because it is passed as parameter,
						//sometimes it may throw an exception
						Math.DivRem(j,5,out oupPara);
						if(oupPara == 0 && j != 0 )
						{
							postingUrls = postingUrls!=""?postingUrls.Substring(0,postingUrls.Length-1):"";
							if(postingUrls!="")
							{
								Process process = Process.Start(Application.StartupPath+"//HtmlThumbnail.exe"/*"c:\\*/,postingUrls);
								Cursor = Cursors.Default;
								process.WaitForExit();						
							}
							postingUrls="";
						}
					}
					postingUrls = postingUrls!=""?postingUrls.Substring(0,postingUrls.Length-1):"";
					if(postingUrls!="")
					{
						Process process = Process.Start(Application.StartupPath+"//HtmlThumbnail.exe"/*"c:\\*/,postingUrls);
						//this is useless i think. it is not working properly.
						Cursor = Cursors.Default;
						process.WaitForExit();						
					}
				}
			}
			catch
			{}
		}
		//A recursive methord to load the channels to the tree
		private void BuildChannels(Channel channel,TreeNode node)
		{
			if(channel.Channels!= null && channel.Channels.Count>0)
			{
				if(node.Nodes.Count==0)
				{
					for(int i=0;i<channel.Channels.Count;i++)
					{
						TreeNode currentNode = new TreeNode(channel.Channels[i].Name);
						ChannelImage(channel.Channels[i],currentNode);
						currentNode.Tag = channel.Channels[i];
						node.Nodes.Add(currentNode);
						if(FormMCMSManager.showPreview)
						{
							if(thumbNailImage.BackgroundImage !=null)
								thumbNailImage.BackgroundImage = null;
							//delete the images before creation
							foreach(Posting p in channel.Channels[i].Postings)
							{
								try
								{
									if(File.Exists(FormMCMSManager.thumbnailPath+"/"+p.Guid+".jpg"))
									{
										File.Delete(FormMCMSManager.thumbnailPath+"/"+p.Guid+".jpg");
									}
								}
								catch{}
							}
							//asyn is needed because otherwise it will take more time.. which is really
							//not good as per my experience
							CreateImagePostingDelegate create = new CreateImagePostingDelegate(ThumbnailChannel);
							create.BeginInvoke(channel.Channels[i],null,null);
						}
					}
				}
			}
		}

		private void ChannelImage(Channel currentChannel, TreeNode currentNode)
		{
			if(currentChannel.IsHiddenModePublished && currentChannel.IsImportant)
			{
				currentNode.ImageIndex = 11;
				currentNode.SelectedImageIndex = 12;
			}
			else if(currentChannel.IsImportant)
			{
				currentNode.ImageIndex = 7;
				currentNode.SelectedImageIndex = 8;
			}
			else if(currentChannel.IsHiddenModePublished)
			{
				currentNode.ImageIndex = 9;
				currentNode.SelectedImageIndex = 10;
			}
			else
			{
				currentNode.ImageIndex = 0;
				currentNode.SelectedImageIndex = 1;
			}
		}

		private void treeViewChannels_MouseDown(object sender, System.Windows.Forms.MouseEventArgs e)
		{
			contextMenuChannel.MenuItems.Clear();
			selectedNode = null;
			if(e.Button == MouseButtons.Right)
			{
				selectedNode = treeViewChannels.GetNodeAt(e.X,e.Y);
				if(selectedNode!=null)
				{
					contextMenuChannel.MenuItems.Add(channelGuid);
					contextMenuChannel.MenuItems.Add(channelOwnedBy);
					contextMenuChannel.MenuItems.Add("-");
					contextMenuChannel.MenuItems.Add(channelSearch);
					contextMenuChannel.MenuItems.Add(channelStatistics);
					contextMenuChannel.MenuItems.Add("-");
					contextMenuChannel.MenuItems.Add(generateExportScript);
					contextMenuChannel.MenuItems.Add("-");
					contextMenuChannel.MenuItems.Add(channelRefresh);
				}
			}
		}

		private void channelOwnedBy_Click(object sender, EventArgs e)
		{
			Channel channel = (Channel)selectedNode.Tag;
			if(channel!=null)
			{
				MessageBox.Show("Owner of the Channel : "+channel.OwnedBy,"Owner");
			}
			else
			{
				MessageBox.Show("Specified channel not found.","Error",MessageBoxButtons.OK,MessageBoxIcon.Error);
			}
		}

		private void channelRefresh_Click(object sender, EventArgs e)
		{
			Channel channel = (Channel)selectedNode.Tag;
			if(channel!=null)
			{
				try
				{
					treeViewChannels.SelectedNode = selectedNode;
					selectedNode.Nodes.Clear();
					BuildChannels(channel,selectedNode);
					if(selectedNode.FirstNode!=null && selectedNode.FirstNode.IsVisible)
					{
						if(channel.Channels!=null && channel.Channels.Count>0)
						{
							for(int i=0;i<channel.Channels.Count;i++)
							{
								BuildChannels(channel.Channels[i],selectedNode.Nodes[i]);
							}
						}
					}
				}
				catch(Exception ex)
				{
					MessageBox.Show("While trying to refresh was thrown. The message was : "+ex.Message,"Error",MessageBoxButtons.OK,MessageBoxIcon.Error);
				}
			}
			else
			{
				MessageBox.Show("Specified channel not found","Error",MessageBoxButtons.OK,MessageBoxIcon.Error);
			}
		}

		private void channelGuid_Click(object sender, EventArgs e)
		{
			Channel channel = (Channel)selectedNode.Tag;
			if(channel!=null)
			{
				try
				{
					MessageBox.Show("Guid of the Channel : "+channel.Guid+"\nThis Guid is copied to the clipboard.","Guid");
					Clipboard.SetDataObject(channel.Guid,true);
				}
				catch(Exception ex)
				{

					MessageBox.Show("While trying to copy the Guid to clipboard an was thrown. The message was : "+ex.Message,"Error",MessageBoxButtons.OK,MessageBoxIcon.Error);
				}
			}
			else
			{
				MessageBox.Show("Specified channel not found","Error",MessageBoxButtons.OK,MessageBoxIcon.Error);
			}
		}

		private void channelSearch_Click(object sender, EventArgs e)
		{
			Channel channel = (Channel)selectedNode.Tag;
			if(channel!=null)
			{
				FormSearch search = new FormSearch();
				search.Text+=" in channel : " + channel.Name;
				FormSearch.ChannelGuid = channel.Guid;
				search.ShowDialog();
			}
			else
			{
				MessageBox.Show("Specified channel not found.","Error",MessageBoxButtons.OK,MessageBoxIcon.Error);
			}
		}

		
		private void channelStatistics_Click(object sender, EventArgs e)
		{
			Channel channel = (Channel)selectedNode.Tag;
			if(channel!=null)
			{
				FormStatistics statistics = new FormStatistics();
				statistics.Text+= channel.Name;
				FormStatistics.channelGuid  = channel.Guid;
				statistics.Show();
			}
			else
			{
				MessageBox.Show("Specified channel not found.","Error",MessageBoxButtons.OK,MessageBoxIcon.Error);
			}
		}

		#endregion

		#region Build TreeViews
		private void tabControl_SelectedIndexChanged(object sender, System.EventArgs e)
		{
			if(tabControl.SelectedIndex==0)
			{
				listViewPostings.Columns.Clear();
				listViewPostings.Items.Clear();
				listViewPostings.Columns.Add("Name",200,HorizontalAlignment.Left);
				listViewPostings.Columns.Add("Guid",243,HorizontalAlignment.Left);
				listViewPostings.Columns.Add("Posting State",140,HorizontalAlignment.Left);
				listViewPostings.Columns.Add("Created By",79,HorizontalAlignment.Left);
				listViewPostings.Columns.Add("Created On",130,HorizontalAlignment.Left);
				lvwColumnSorter.Order = SortOrder.Ascending;
				listViewPostings.Sort();
				if(treeViewChannels.Nodes.Count==0)
				{
					TreeNode currentNode = new TreeNode(cmsApplicationContext.RootChannel.Name);
					currentNode.Tag = cmsApplicationContext.RootChannel;
					treeViewChannels.Nodes.Add(currentNode);
					BuildChannels(cmsApplicationContext.RootChannel,treeViewChannels.Nodes[0]);
					treeViewChannels.SelectedNode = treeViewChannels.Nodes[0];
					if(FormMCMSManager.showPreview)
					{
						if(thumbNailImage.BackgroundImage !=null)
							thumbNailImage.BackgroundImage = null;
						//delete the images before creation
						foreach(Posting p in cmsApplicationContext.RootChannel.Postings)
						{
							try
							{
								if(File.Exists(FormMCMSManager.thumbnailPath+"/"+p.Guid+".jpg"))
								{
									File.Delete(FormMCMSManager.thumbnailPath+"/"+p.Guid+".jpg");
								}
							}
							catch{}
						}
						//asyn is needed because otherwise it will take more time.. which is really
						//not good as per my experience
						CreateImagePostingDelegate create = new CreateImagePostingDelegate(ThumbnailChannel);
						create.BeginInvoke(cmsApplicationContext.RootChannel,null,null);
					}
				}
				else
				{
					ChannelsAfterSelect();
				}
			}
			else if(tabControl.SelectedIndex==1)
			{
				listViewPostings.Items.Clear();
				listViewPostings.Columns.Clear();
				listViewPostings.Columns.Add("Name",210,HorizontalAlignment.Left);
				listViewPostings.Columns.Add("Guid",243,HorizontalAlignment.Left);
				listViewPostings.Columns.Add("Is Deleted",75,HorizontalAlignment.Left);
				listViewPostings.Columns.Add("Authoring",65,HorizontalAlignment.Left);
				listViewPostings.Columns.Add("Created By",79,HorizontalAlignment.Left);
				listViewPostings.Columns.Add("Created On",129,HorizontalAlignment.Left);
				lvwColumnSorter.Order = SortOrder.Ascending;
				listViewPostings.Sort();
				if(treeViewResourceGallery.Nodes.Count==0)
				{
					TreeNode currentNode = new TreeNode(cmsApplicationContext.RootResourceGallery.Name);
					currentNode.Tag = cmsApplicationContext.RootResourceGallery;
					treeViewResourceGallery.Nodes.Add(currentNode);
					BuildResource(cmsApplicationContext.RootResourceGallery,treeViewResourceGallery.Nodes[0]);
					treeViewResourceGallery.SelectedNode = treeViewResourceGallery.Nodes[0];
				}
				else
				{
					ResourceGalleryAfterSelect();
				}
			}
			else
			{
				listViewPostings.Items.Clear();
				listViewPostings.Columns.Clear();
				listViewPostings.Columns.Add("Name",200,HorizontalAlignment.Left);
				listViewPostings.Columns.Add("Guid",243,HorizontalAlignment.Left);
				listViewPostings.Columns.Add("State",80,HorizontalAlignment.Left);
				listViewPostings.Columns.Add("Authoring",65,HorizontalAlignment.Left);
				listViewPostings.Columns.Add("Created By",79,HorizontalAlignment.Left);
				listViewPostings.Columns.Add("Created On",130,HorizontalAlignment.Left);
				lvwColumnSorter.Order = SortOrder.Ascending;
				listViewPostings.Sort();
				if(treeViewTemplateGallery.Nodes.Count==0)
				{
					TreeNode currentNode = new TreeNode(cmsApplicationContext.RootTemplateGallery.Name);
					currentNode.Tag = cmsApplicationContext.RootTemplateGallery;
					treeViewTemplateGallery.Nodes.Add(currentNode);
					BuildTemplate(cmsApplicationContext.RootTemplateGallery,treeViewTemplateGallery.Nodes[0]);
					treeViewTemplateGallery.SelectedNode = treeViewTemplateGallery.Nodes[0];
					if(FormMCMSManager.showPreviewTemplate)
					{
						if(thumbNailImage.BackgroundImage !=null)
							thumbNailImage.BackgroundImage = null;
						foreach(Template t in cmsApplicationContext.RootTemplateGallery.Templates)
						{
							try
							{
								//delete the files before creation, if not it will show the old image
								if(File.Exists(FormMCMSManager.thumbnailPath+"/"+t.Guid+".jpg"))
								{
									File.Delete(FormMCMSManager.thumbnailPath+"/"+t.Guid+".jpg");
								}
							}
							catch{}
						}
						CreateImageTemplateDelegate create = new CreateImageTemplateDelegate(ThumbnailTemplate);
						create.BeginInvoke(cmsApplicationContext.RootTemplateGallery,null,null);
					}
				}
				else
				{
					TemplateGalleryAfterSelect();
				}
			}
		}
		#endregion

		#region Refresh
		private void toolBar_ButtonClick(object sender, System.Windows.Forms.ToolBarButtonClickEventArgs e)
		{
			treeViewChannels.Nodes.Clear();
			treeViewResourceGallery.Nodes.Clear();
			treeViewTemplateGallery.Nodes.Clear();
			try
			{
				//Close the old Cms Context and open a new one to get the new changes
				cmsApplicationContext.Dispose();
				cmsApplicationContext = new CmsApplicationContext();
				//Authendicate the user with his crediatials
				cmsApplicationContext.AuthenticateAsUser(userName,password,PublishingMode.Update);
				//Create a parent node to add child node
				TreeNode currentNode = new TreeNode(cmsApplicationContext.RootChannel.Name);
				currentNode.Tag = cmsApplicationContext.RootChannel;
				treeViewChannels.Nodes.Add(currentNode);
				//build the tree
				BuildChannels(cmsApplicationContext.RootChannel,treeViewChannels.Nodes[0]);
				treeViewChannels.SelectedNode = treeViewChannels.Nodes[0];
				if(FormMCMSManager.showPreview)
				{
					if(thumbNailImage.BackgroundImage !=null)
						thumbNailImage.BackgroundImage = null;
					//delete the images before creation
					foreach(Posting p in cmsApplicationContext.RootChannel.Postings)
					{
						try
						{
							if(File.Exists(FormMCMSManager.thumbnailPath+"/"+p.Guid+".jpg"))
							{
								File.Delete(FormMCMSManager.thumbnailPath+"/"+p.Guid+".jpg");
							}
						}
						catch{}
					}
					//asyn is needed because otherwise it will take more time.. which is really
					//not good as per my experience
					CreateImagePostingDelegate create = new CreateImagePostingDelegate(ThumbnailChannel);
					create.BeginInvoke(cmsApplicationContext.RootChannel,null,null);
				}

				currentNode = new TreeNode(cmsApplicationContext.RootResourceGallery.Name);
				currentNode.Tag = cmsApplicationContext.RootResourceGallery;
				treeViewResourceGallery.Nodes.Add(currentNode);
				//build the tree
				BuildResource(cmsApplicationContext.RootResourceGallery,treeViewResourceGallery.Nodes[0]);
				treeViewResourceGallery.SelectedNode = treeViewResourceGallery.Nodes[0];

				currentNode = new TreeNode(cmsApplicationContext.RootTemplateGallery.Name);
				currentNode.Tag = cmsApplicationContext.RootTemplateGallery;
				treeViewTemplateGallery.Nodes.Add(currentNode);
				//build the tree
				BuildTemplate(cmsApplicationContext.RootTemplateGallery,treeViewTemplateGallery.Nodes[0]);
				treeViewTemplateGallery.SelectedNode = treeViewTemplateGallery.Nodes[0];
				if(FormMCMSManager.showPreviewTemplate)
				{
					if(thumbNailImage.BackgroundImage !=null)
						thumbNailImage.BackgroundImage = null;
					foreach(Template t in cmsApplicationContext.RootTemplateGallery.Templates)
					{
						try
						{
							//delete the files before creation, if not it will show the old image
							if(File.Exists(FormMCMSManager.thumbnailPath+"/"+t.Guid+".jpg"))
							{
								File.Delete(FormMCMSManager.thumbnailPath+"/"+t.Guid+".jpg");
							}
						}
						catch{}
					}
					CreateImageTemplateDelegate create = new CreateImageTemplateDelegate(ThumbnailTemplate);
					create.BeginInvoke(cmsApplicationContext.RootTemplateGallery,null,null);
				}


				tabControl.SelectedIndex = 0;
				ChannelsAfterSelect();
			}
			catch{}
		}
		#endregion
		
		#region Resource

		private string[] CanDeleteResource(Resource res)
		{
			StringCollection sColl = CheckResourceDependencies.GetDependendPosting(FormMCMSManager.cmsApplicationContext, res);
			string[] postingGuids = new string[sColl.Count];
            for(int i=0;i<sColl.Count;i++)
			{
				postingGuids[i] = sColl[i];
			}
			return postingGuids;
		}

		private void BuildResource(ResourceGallery resources,TreeNode node)
		{
			if(resources.ResourceGalleries!= null && resources.ResourceGalleries.Count>0)
			{
				if(node.Nodes.Count==0)
				{
					for(int i=0;i<resources.ResourceGalleries.Count;i++)
					{
						TreeNode currentNode = new TreeNode(resources.ResourceGalleries[i].Name);
						currentNode.Tag = resources.ResourceGalleries[i];
						node.Nodes.Add(currentNode);
					}
				}
			}
		}

		private void treeViewResourceGallery_AfterSelect(object sender, System.Windows.Forms.TreeViewEventArgs e)
		{
			BuildResource((ResourceGallery)e.Node.Tag,e.Node);
			//Listview is created with postings
			listViewPostings.Items.Clear();
			ResourceGallery resources = (ResourceGallery)e.Node.Tag;
			try
			{
				foreach(Resource r in resources.Resources)
				{
					string clientName = r.CreatedBy.ClientAccountName;
					ListViewItem currentItem = null;
					if(clientName.IndexOf("/")==-1)
					{
						currentItem = new ListViewItem(new string[]{r.Name,r.Guid,r.IsDeleted==true?"Deleted":"Not Deleted",r.CanUseForAuthoring==true?"Can use":"Can't use",clientName,r.CreatedDate.ToString()},1);
					}
					else
					{
						currentItem = new ListViewItem(new string[]{r.Name,r.Guid,r.IsDeleted==true?"Deleted":"Not Deleted",r.CanUseForAuthoring==true?"Can use":"Can't use",clientName.Split('/')[clientName.Split('/').Length-1],r.CreatedDate.ToString()},1);
					}
					currentItem.Tag = r;
					listViewPostings.Items.Add(currentItem);
				}
			}
				//Sometimes if its disposing it may throw an exception which we don't worry about
			catch
			{}
		}

		private void ResourceGalleryAfterSelect()
		{
			//Listview is created with postings
			listViewPostings.Items.Clear();
			try
			{
				foreach(Resource r in ((ResourceGallery)treeViewResourceGallery.SelectedNode.Tag).Resources)
				{
					string clientName = r.CreatedBy.ClientAccountName;
					ListViewItem currentItem = null;
					if(clientName.IndexOf("/")==-1)
					{
						currentItem = new ListViewItem(new string[]{r.Name,r.Guid,r.IsDeleted==true?"Deleted":"Not Deleted",r.CanUseForAuthoring==true?"Can use":"Can't use",clientName,r.CreatedDate.ToString()},1);
					}
					else
					{
						currentItem = new ListViewItem(new string[]{r.Name,r.Guid,r.IsDeleted==true?"Deleted":"Not Deleted",r.CanUseForAuthoring==true?"Can use":"Can't use",clientName.Split('/')[clientName.Split('/').Length-1],r.CreatedDate.ToString()},1);
					}
					currentItem.Tag = r;
					listViewPostings.Items.Add(currentItem);
				}
			}
				//Sometimes if its disposing it may throw an exception which we don't worry about
			catch
			{}
		}

		private void treeViewResourceGallery_AfterExpand(object sender, System.Windows.Forms.TreeViewEventArgs e)
		{
			if(e.Node.FirstNode!= null && e.Node.FirstNode.IsVisible && e.Node.FirstNode.FirstNode==null)
			{
				ResourceGallery r = e.Node.Tag as ResourceGallery;
				if(r!=null && r.ResourceGalleries!= null && r.ResourceGalleries.Count>0)
				{
					for(int i=0;i<r.ResourceGalleries.Count;i++)
					{
						BuildResource(r.ResourceGalleries[i],e.Node.Nodes[i]);
					}
				}
			}
		}
			
		private void treeViewResourceGallery_MouseDown(object sender, System.Windows.Forms.MouseEventArgs e)
		{
			contextMenuResource.MenuItems.Clear();
			selectedNode = null;
			if(e.Button == MouseButtons.Right)
			{
				selectedNode = treeViewResourceGallery.GetNodeAt(e.X,e.Y);
				if(selectedNode!=null)
				{
					contextMenuResource.MenuItems.Add(resourceGGuid);
					contextMenuResource.MenuItems.Add(resourceGOwnedBy);
					contextMenuResource.MenuItems.Add("-");
					contextMenuResource.MenuItems.Add(resourceGRefresh);
				}
			}
		}

		private void resourceGGuid_Click(object sender, EventArgs e)
		{
			ResourceGallery gallery = selectedNode.Tag as ResourceGallery;
			if(gallery!=null)
			{
				try
				{
					MessageBox.Show("Guid of the Resource Gallery : "+gallery.Guid+"\nThis Guid is copied to the clipboard.","Guid");
					Clipboard.SetDataObject(gallery.Guid,true);
				}
				catch(Exception ex)
				{
					MessageBox.Show("While trying to copy the Guid to clipboard an was thrown. The message was : "+ex.Message,"Error",MessageBoxButtons.OK,MessageBoxIcon.Error);
				}
			}
			else
			{
				MessageBox.Show("Specified resource gallery not found","Error",MessageBoxButtons.OK,MessageBoxIcon.Error);
			}

		}

		private void resourceGOwnedBy_Click(object sender, EventArgs e)
		{
			ResourceGallery gallery = selectedNode.Tag as ResourceGallery;
			if(gallery!=null)
			{
				MessageBox.Show("Owner of the Resource Gallery : "+gallery.OwnedBy,"Owner");
			}
			else
			{
				MessageBox.Show("Specified resource gallery not found.","Error",MessageBoxButtons.OK,MessageBoxIcon.Error);
			}
		}

		private void resourceGRefresh_Click(object sender, EventArgs e)
		{
			ResourceGallery gallery = selectedNode.Tag as ResourceGallery;
			if(gallery!=null)
			{
				try
				{
					treeViewResourceGallery.SelectedNode = selectedNode;
					selectedNode.Nodes.Clear();
					BuildResource(gallery,selectedNode);
					if(selectedNode.FirstNode!=null && selectedNode.FirstNode.IsVisible)
					{
						if(gallery.ResourceGalleries!=null && gallery.ResourceGalleries.Count>0)
						{
							for(int i=0;i<gallery.ResourceGalleries.Count;i++)
							{
								BuildResource(gallery.ResourceGalleries[i],selectedNode.Nodes[i]);
							}
						}
					}
				}
				catch(Exception ex)
				{
					MessageBox.Show("While trying to refresh was thrown. The message was : "+ex.Message,"Error",MessageBoxButtons.OK,MessageBoxIcon.Error);
				}
			}
			else
			{
				MessageBox.Show("Specified resource gallery was not found","Error",MessageBoxButtons.OK,MessageBoxIcon.Error);
			}
		}
		

		private void resourceGuid_Click(object sender, EventArgs e)
		{
			Resource resource = selectedItem.Tag as Resource;
			if(resource!=null)
			{
				try
				{
					//Copy the guid to the clipboard
					Clipboard.SetDataObject(resource.Guid,true);
					MessageBox.Show("Resource's Guid is copied to the clipboard.","Guid Copied");
				}
				catch(Exception ex)
				{

					MessageBox.Show("While trying to copy the Guid to clipboard an was thrown. The message was : "+ex.Message,"Error",MessageBoxButtons.OK,MessageBoxIcon.Error);
				}
			}
			else
			{
				MessageBox.Show("Selected resource not found","Error",MessageBoxButtons.OK,MessageBoxIcon.Error);
			}
		}

		private void resourceOwner_Click(object sender, EventArgs e)
		{
			Resource resource = selectedItem.Tag as Resource;
			if(resource!=null)
			{
				//Get the owner of the selected posting
				if(resource.OwnedBy.ClientAccountName.IndexOf("/")==-1)
				{
					MessageBox.Show("This resource is owned by : "+resource.OwnedBy.ClientAccountName,"Owner");
				}
				else
				{
					MessageBox.Show("This resource is owned by : "+resource.OwnedBy.ClientAccountName.Split('/')[resource.CreatedBy.ClientAccountName.Split('/').Length-1],"Owner");
				}
			}
			else
			{
				MessageBox.Show("Selected resource not found","Error",MessageBoxButtons.OK,MessageBoxIcon.Error);
			}
		}

		private void resourceOpen_Click(object sender, EventArgs e)
		{
			Resource resource = selectedItem.Tag as Resource;
			if(resource!=null)
			{
				try
				{
					System.Diagnostics.Process.Start(serverName + resource.Url);//,"iexplorer.exe");
				}
				catch(Exception ex)
				{
					MessageBox.Show("While trying to open the resource an exception was thrown. The message was : "+ex.Message,"Error",MessageBoxButtons.OK,MessageBoxIcon.Error);
				}
			}
			else
			{
				MessageBox.Show("Selected resoruce not found","Error",MessageBoxButtons.OK,MessageBoxIcon.Error);
			}
		}

		private void resourceUsingPosting_Click(object sender, EventArgs e)
		{
			Resource resource = selectedItem.Tag as Resource;
			if(resource!=null)
			{
				try
				{
					//string[] postings = CanDeleteResource(resource.Path);
					string[] postings = CanDeleteResource(resource);
					if(postings==null)
					{
						MessageBox.Show("This resource is not used by any postings","Resource Dependency",MessageBoxButtons.OK,MessageBoxIcon.Information);
					}
					else if(postings.Length==1)
					{
						MessageBox.Show("This resource is used by 1 posting. The Guid of the posting is "+postings[0]+" and it is copied to clipboard","Resource Dependency",MessageBoxButtons.OK,MessageBoxIcon.Information);
						Clipboard.SetDataObject(postings[0],true);
					}
					else
					{
						string displayPosting = "";
						for(int i=0;i<postings.Length;i++)
						{
							if(i!=postings.Length-1)
							{
								displayPosting += postings[i]+",";
							}
							else
							{
								displayPosting += postings[i];
							}
						}
						MessageBox.Show("This resource is used by "+postings.Length+" postings. The Guid of the postings are "+displayPosting+" and it is copied to clipboard","Resource Dependency",MessageBoxButtons.OK,MessageBoxIcon.Information);
						Clipboard.SetDataObject(displayPosting,true);
					}
				}
				catch(Exception ex)
				{
					MessageBox.Show("While trying to open the resource an exception was thrown. The message was : "+ex.Message,"Error",MessageBoxButtons.OK,MessageBoxIcon.Error);
				}
			}
			else
			{
				MessageBox.Show("Selected resoruce not found","Error",MessageBoxButtons.OK,MessageBoxIcon.Error);
			}
		}

		private void resourceSave_Click(object sender, EventArgs e)
		{
			Resource resource = selectedItem.Tag as Resource;
			if(resource!=null)
			{
				try
				{
					saveFileDialogResource.Reset();
					saveFileDialogResource.FileName = resource.Name;
					saveFileDialogResource.Filter =resource.FileExtension.ToUpper() +" files|*."+resource.FileExtension;
					DialogResult result = saveFileDialogResource.ShowDialog();
					if(result == DialogResult.OK)
					{
						FileStream fs = new FileStream(saveFileDialogResource.FileName,FileMode.Create);
						Stream stream = resource.OpenReadStream();
						int currentByte=-1;
						while((currentByte=stream.ReadByte())!=-1)
						{
							fs.WriteByte((byte)currentByte);
						}
						stream.Close();
						fs.Close();
					}
				}
				catch(Exception ex)
				{
					MessageBox.Show("While trying to save the resource an exception was thrown. The message was : "+ex.Message,"Error",MessageBoxButtons.OK,MessageBoxIcon.Error);
				}
			}
			else
			{
				MessageBox.Show("Selected resoruce not found","Error",MessageBoxButtons.OK,MessageBoxIcon.Error);
			}
		}

		#endregion

		#region List View
		//Load the listview menu control for given state
		private void listViewPostings_MouseDown(object sender, System.Windows.Forms.MouseEventArgs e)
		{
			OnListBoxMouseCancel();
			if(tabControl.SelectedIndex ==0)
			{
				contextMenuPosting.MenuItems.Clear();
				selectedItem = null;
				//Is the click is right mouse click
				if(e.Button == MouseButtons.Right)
				{
					//Get the item which is selected
					selectedItem = listViewPostings.GetItemAt(e.X,e.Y);
					if(selectedItem!=null)
					{
						//Get the posting in the current context
						Posting posting = (Posting)selectedItem.Tag;
						//Is locked by any user
						contextMenuPosting.MenuItems.Add(postingOwner);
						if(!posting.OwnedBy.IsEverybody)
						{
							contextMenuPosting.MenuItems.Add(postingReleaseOwner);
						}
						contextMenuPosting.MenuItems.Add("-");
						//If can edit the posting must be able to edit
						contextMenuPosting.MenuItems.Add(postingEdit);
						//contextMenuPosting.MenuItems.Add(postingEditDB);
						//Can the current user edit custom properties/do the posting has properties
						if(posting.CanSetProperties && posting.CustomProperties.Count>0)
						{
							contextMenuPosting.MenuItems.Add(postingProperties);
						}
						contextMenuPosting.MenuItems.Add("-");
						//Can this posting approved
						if(posting.CanApprove)
						{
							//Can submitted
							if(posting.CanSubmit)
							{
								contextMenuPosting.MenuItems.Add(postingSubmit);
							}
							contextMenuPosting.MenuItems.Add(postingApprove);
							//This is to check decline
							if(posting.State != PostingState.Saved && posting.State != PostingState.Published)
							{
								contextMenuPosting.MenuItems.Add(postingDecline);
							}
							contextMenuPosting.MenuItems.Add("-");
						}
						else
						{
							if(posting.State != PostingState.Saved)
							{
								if(posting.State!= PostingState.Published)
								{
									contextMenuPosting.MenuItems.Add(postingDecline);
									contextMenuPosting.MenuItems.Add("-");
								}
							}
							else if(posting.CanSubmit)
							{
								contextMenuPosting.MenuItems.Add(postingSubmit);
								contextMenuPosting.MenuItems.Add("-");
							}
						}
						//General items in context menu
						contextMenuPosting.MenuItems.Add(postingGuid);
						contextMenuPosting.MenuItems.Add(postingTemplateGuid);
						contextMenuPosting.MenuItems.Add("-");
						contextMenuPosting.MenuItems.Add(postingPublichedURL);
						contextMenuPosting.MenuItems.Add(postingUnPublichedURL);
						contextMenuPosting.MenuItems.Add(postingUpdateURL);
						if(posting.ConnectedPostings.Count>0)
						{
							contextMenuPosting.MenuItems.Add("-");
							contextMenuPosting.MenuItems.Add(postingConnected);
						}
					}
				}
			}
			else if(tabControl.SelectedIndex == 1)
			{
				contextMenuPosting.MenuItems.Clear();
				selectedItem = null;
				//Is the click is right mouse click
				if(e.Button == MouseButtons.Right)
				{
					//Get the item which is selected
					selectedItem = listViewPostings.GetItemAt(e.X,e.Y);
					if(selectedItem!=null)
					{
						//Get the posting in the current context
						Resource resource = selectedItem.Tag as Resource;
						contextMenuPosting.MenuItems.Add(resourceOwner);
						contextMenuPosting.MenuItems.Add(resourceGuid);
						contextMenuPosting.MenuItems.Add("-");
						contextMenuPosting.MenuItems.Add(resourceOpen);
						contextMenuPosting.MenuItems.Add(resourceSave);
						contextMenuPosting.MenuItems.Add("-");
						contextMenuPosting.MenuItems.Add(resourceUsingPosting);
					}
				}
			}
			else
			{
				contextMenuPosting.MenuItems.Clear();
				selectedItem = null;
				//Is the click is right mouse click
				if(e.Button == MouseButtons.Right)
				{
					//Get the item which is selected
					selectedItem = listViewPostings.GetItemAt(e.X,e.Y);
					if(selectedItem!=null)
					{
						//Get the template in the current context
						Template template = selectedItem.Tag as Template;
						//General items in context menu
						contextMenuPosting.MenuItems.Add(templateGuid);
						contextMenuPosting.MenuItems.Add(templateOwner);
						contextMenuPosting.MenuItems.Add("-");
						contextMenuPosting.MenuItems.Add(templatePath);
						contextMenuPosting.MenuItems.Add(templateSourceFile);
						//Is locked by any user
						if(!template.OwnedBy.IsEverybody)
						{
							contextMenuPosting.MenuItems.Add("-");
							contextMenuPosting.MenuItems.Add(templateReleaseOwner);
						}
						//Can this posting approved
						//Can submitted
						if(template.CanSubmit)
						{
							contextMenuPosting.MenuItems.Add("-");
							contextMenuPosting.MenuItems.Add(templateSubmit);
						}
						if(template.CanUseForAuthoring)
						{
							contextMenuPosting.MenuItems.Add("-");
							contextMenuPosting.MenuItems.Add(templateUsingPosting);
						}
					}
				}
			}
		}
		#endregion

		#region Template

		private void BuildTemplate(TemplateGallery templates,TreeNode node)
		{
			if(templates.TemplateGalleries!= null && templates.TemplateGalleries.Count>0)
			{
				if(node.Nodes.Count==0)
				{
					for(int i=0;i<templates.TemplateGalleries.Count;i++)
					{
						TreeNode currentNode = new TreeNode(templates.TemplateGalleries[i].Name);
						currentNode.Tag = templates.TemplateGalleries[i];
						node.Nodes.Add(currentNode);
						if(FormMCMSManager.showPreviewTemplate)
						{
							if(thumbNailImage.BackgroundImage !=null)
								thumbNailImage.BackgroundImage = null;
							foreach(Template t in templates.TemplateGalleries[i].Templates)
							{
								try
								{
									//delete the files before creation, if not it will show the old image
									if(File.Exists(FormMCMSManager.thumbnailPath+"/"+t.Guid+".jpg"))
									{
										File.Delete(FormMCMSManager.thumbnailPath+"/"+t.Guid+".jpg");
									}
								}
								catch{}
							}
							CreateImageTemplateDelegate create = new CreateImageTemplateDelegate(ThumbnailTemplate);
							create.BeginInvoke(templates.TemplateGalleries[i],null,null);
						}
					}
				}
			}
		}

		private void ThumbnailTemplate(TemplateGallery templates)
		{
			try
			{
				if(FormMCMSManager.showPreviewTemplate)
				{
					string templateUrls="";
					int test = templates.Templates.Count;
					for(int j=0;j<templates.Templates.Count;j++)
					{
						if(templates.Templates[j].UrlAsPosting().ToLower().StartsWith("http://"))
						{
							templateUrls += templates.Templates[j].UrlAsPosting()+"|"+FormMCMSManager.thumbnailPath+"\\"+templates.Templates[j].Guid+".jpg"+"|"+FormMCMSManager.resolutionWidth+"|"+FormMCMSManager.resolutionHeight+"|"+FormMCMSManager.thumbnailWidth+"|"+FormMCMSManager.thumbnailHeight+"|";
						}
						else
						{
							templateUrls += FormMCMSManager.serverName+templates.Templates[j].UrlAsPosting()+"|"+FormMCMSManager.thumbnailPath+"\\"+templates.Templates[j].Guid+".jpg"+"|"+FormMCMSManager.resolutionWidth+"|"+FormMCMSManager.resolutionHeight+"|"+FormMCMSManager.thumbnailWidth+"|"+FormMCMSManager.thumbnailHeight+"|";
						}
						int oupPara = 0;
						Math.DivRem(j,5,out oupPara);
						if(oupPara == 0 && j != 0 )
						{
							templateUrls = templateUrls!=""?templateUrls.Substring(0,templateUrls.Length-1):"";
							if(templateUrls!="")
							{
								Process process = Process.Start(Application.StartupPath+"//HtmlThumbnail.exe"/*"c:\\*/,templateUrls);
								this.Cursor = Cursors.Default;
								process.WaitForExit();						
							}
							templateUrls="";
						}
					}
					templateUrls = templateUrls!=""?templateUrls.Substring(0,templateUrls.Length-1):"";
					if(templateUrls!="")
					{
						Process process = Process.Start(Application.StartupPath+"//HtmlThumbnail.exe"/*"c:\\*/,templateUrls);
						this.Cursor = Cursors.Default;
						process.WaitForExit();						
					}
				}
			}
			catch
			{}
		}
		private void treeViewTemplateGallery_AfterSelect(object sender, System.Windows.Forms.TreeViewEventArgs e)
		{
			BuildTemplate((TemplateGallery)e.Node.Tag,e.Node);
			//Listview is created with postings
			listViewPostings.Items.Clear();
			TemplateGallery templates = (TemplateGallery)e.Node.Tag;
			try
			{
				foreach(Template t in templates.Templates)
				{
					string clientName = t.CreatedBy.ClientAccountName;
					ListViewItem currentItem = null;
					if(clientName.IndexOf("/")==-1)
					{
						currentItem = new ListViewItem(new string[]{t.Name,t.Guid,t.State.ToString(),t.CanUseForAuthoring==true?"Can use":"Can't use",clientName,t.CreatedDate.ToString()},t.ConnectedTemplates.Count>0?4:2);
					}
					else
					{
						currentItem = new ListViewItem(new string[]{t.Name,t.Guid,t.State.ToString(),t.CanUseForAuthoring==true?"Can use":"Can't use",clientName.Split('/')[clientName.Split('/').Length-1],t.CreatedDate.ToString()},t.ConnectedTemplates.Count>0?4:2);
					}
					currentItem.Tag = t;
					listViewPostings.Items.Add(currentItem);
				}
			}
				//Sometimes if its disposing it may throw an exception which we don't worry about
			catch
			{}
		}

		private void TemplateGalleryAfterSelect()
		{
			//Listview is created with postings
			listViewPostings.Items.Clear();
			TemplateGallery templates = cmsApplicationContext.RootTemplateGallery;
			try
			{
				foreach(Template t in ((TemplateGallery)treeViewTemplateGallery.SelectedNode.Tag).Templates)
				{
					string clientName = t.CreatedBy.ClientAccountName;
					ListViewItem currentItem = null;
					if(clientName.IndexOf("/")==-1)
					{
						currentItem = new ListViewItem(new string[]{t.Name,t.Guid,t.State.ToString(),t.CanUseForAuthoring==true?"Can use":"Can't use",clientName,t.CreatedDate.ToString()},t.ConnectedTemplates.Count>0?4:2);
					}
					else
					{
						currentItem = new ListViewItem(new string[]{t.Name,t.Guid,t.State.ToString(),t.CanUseForAuthoring==true?"Can use":"Can't use",clientName.Split('/')[clientName.Split('/').Length-1],t.CreatedDate.ToString()},t.ConnectedTemplates.Count>0?4:2);
					}
					currentItem.Tag = t;
					listViewPostings.Items.Add(currentItem);
				}
			}
				//Sometimes if its disposing it may throw an exception which we don't worry about
			catch
			{}
		}


		private void treeViewTemplateGallery_AfterExpand(object sender, System.Windows.Forms.TreeViewEventArgs e)
		{
			if(e.Node.FirstNode!= null && e.Node.FirstNode.IsVisible && e.Node.FirstNode.FirstNode==null)
			{
				TemplateGallery t = e.Node.Tag as TemplateGallery;
				if(t!=null && t.TemplateGalleries!= null && t.TemplateGalleries.Count>0)
				{
					for(int i=0;i<t.TemplateGalleries.Count;i++)
					{
						BuildTemplate(t.TemplateGalleries[i],e.Node.Nodes[i]);
					}
				}
			}
		}

		private void treeViewTemplateGallery_MouseDown(object sender, System.Windows.Forms.MouseEventArgs e)
		{
			contextMenuTemplate.MenuItems.Clear();
			selectedNode = null;
			if(e.Button == MouseButtons.Right)
			{
				selectedNode = treeViewTemplateGallery.GetNodeAt(e.X,e.Y);
				if(selectedNode!=null)
				{
					contextMenuTemplate.MenuItems.Add(templateGGuid);
					contextMenuTemplate.MenuItems.Add(templateGOwnedBy);
					contextMenuTemplate.MenuItems.Add("-");
					contextMenuTemplate.MenuItems.Add(templateGRefresh);
				}
			}
		}

		private void templateGGuid_Click(object sender, EventArgs e)
		{
			TemplateGallery gallery = selectedNode.Tag as TemplateGallery;
			if(gallery!=null)
			{
				try
				{
					MessageBox.Show("Guid of the Template Gallery : "+gallery.Guid+"\nThis Guid is copied to the clipboard.","Guid");
					Clipboard.SetDataObject(gallery.Guid,true);
				}
				catch(Exception ex)
				{

					MessageBox.Show("While trying to copy the Guid to clipboard an was thrown. The message was : "+ex.Message,"Error",MessageBoxButtons.OK,MessageBoxIcon.Error);
				}
			}
			else
			{
				MessageBox.Show("Specified template gallery not found","Error",MessageBoxButtons.OK,MessageBoxIcon.Error);
			}

		}

		private void templateGOwnedBy_Click(object sender, EventArgs e)
		{
			TemplateGallery gallery = selectedNode.Tag as TemplateGallery;
			if(gallery!=null)
			{
				MessageBox.Show("Owner of the Template Gallery : "+gallery.OwnedBy,"Owner");
			}
			else
			{
				MessageBox.Show("Specified template gallery not found.","Error",MessageBoxButtons.OK,MessageBoxIcon.Error);
			}
		}

		private void templateGRefresh_Click(object sender, EventArgs e)
		{
			TemplateGallery galery = selectedNode.Tag as TemplateGallery;
			if(galery!=null)
			{
				try
				{
					treeViewTemplateGallery.SelectedNode = selectedNode;
					selectedNode.Nodes.Clear();
					BuildTemplate(galery,selectedNode);
					if(selectedNode.FirstNode!=null && selectedNode.FirstNode.IsVisible)
					{
						if(galery.TemplateGalleries!=null && galery.TemplateGalleries.Count>0)
						{
							for(int i=0;i<galery.TemplateGalleries.Count;i++)
							{
								BuildTemplate(galery.TemplateGalleries[i],selectedNode.Nodes[i]);
							}
						}
					}
				}
				catch(Exception ex)
				{
					MessageBox.Show("While trying to refresh was thrown. The message was : "+ex.Message,"Error",MessageBoxButtons.OK,MessageBoxIcon.Error);
				}
			}
			else
			{
				MessageBox.Show("Specified template gallery not found","Error",MessageBoxButtons.OK,MessageBoxIcon.Error);
			}

		}
		private void templateGuid_Click(object sender, EventArgs e)
		{
			Template template = selectedItem.Tag as Template;
			
			if(template!=null)
			{
				try
				{
					//Copy the guid to the clipboard
					Clipboard.SetDataObject(template.Guid,true);
					MessageBox.Show("Template Guid is copied to the clipboard.","Guid Copied");
				}
				catch(Exception ex)
				{

					MessageBox.Show("While trying to copy the Guid to clipboard an was thrown. The message was : "+ex.Message,"Error",MessageBoxButtons.OK,MessageBoxIcon.Error);
				}
			}
			else
			{
				MessageBox.Show("Selected template not found","Error",MessageBoxButtons.OK,MessageBoxIcon.Error);
			}

		}

		private void templateOwner_Click(object sender, EventArgs e)
		{
			Template template = selectedItem.Tag as Template;
			if(template!=null)
			{
				//Get the owner of the selected posting
				if(template.OwnedBy.ClientAccountName.IndexOf("/")==-1)
				{
					MessageBox.Show("This template is owned by : "+template.OwnedBy.ClientAccountName,"Owner");
				}
				else
				{
					MessageBox.Show("This template is owned by : "+template.OwnedBy.ClientAccountName.Split('/')[template.CreatedBy.ClientAccountName.Split('/').Length-1],"Owner");
				}
			}
			else
			{
				MessageBox.Show("Selected template not found","Error",MessageBoxButtons.OK,MessageBoxIcon.Error);
			}
		}

		private void templateReleaseOwner_Click(object sender, EventArgs e)
		{
			Template template = selectedItem.Tag as Template;
			if(template!=null)
			{
				try
				{
					//Release the ownership on the given posting
					template.ReleaseOwnership(true);
					cmsApplicationContext.CommitAll();
					//Reload the list view
					listViewPostings.Items.Clear();
					TemplateGallery gallery = treeViewTemplateGallery.SelectedNode.Tag as TemplateGallery;
					foreach(Template t in gallery.Templates)
					{
						string clientName = t.CreatedBy.ClientAccountName;
						ListViewItem currentItem = null;
						if(clientName.IndexOf("/")==-1)
						{
							currentItem = new ListViewItem(new string[]{t.Name,t.Guid,t.State.ToString(),t.CanUseForAuthoring==true?"Can use":"Can't use",clientName,t.CreatedDate.ToString()},t.ConnectedTemplates.Count>0?4:2);
						}
						else
						{
							currentItem = new ListViewItem(new string[]{t.Name,t.Guid,t.State.ToString(),t.CanUseForAuthoring==true?"Can use":"Can't use",clientName.Split('/')[clientName.Split('/').Length-1],t.CreatedDate.ToString()},t.ConnectedTemplates.Count>0?4:2);
						}
						currentItem.Tag = t;
						listViewPostings.Items.Add(currentItem);
					}
				}
				catch(Exception ex)
				{
					MessageBox.Show("While trying to release the ownership an exception was thrown. The message was : "+ex.Message,"Error",MessageBoxButtons.OK,MessageBoxIcon.Error);
				}
			}
			else
			{
				MessageBox.Show("Selected template not found","Error",MessageBoxButtons.OK,MessageBoxIcon.Error);
			}
		}

		private void templateSubmit_Click(object sender, EventArgs e)
		{
			Template template = selectedItem.Tag as Template;
			if(template!=null)
			{
				DialogResult result = MessageBox.Show("This will try to submit the current template. Do you want to proceed?","Warning!",MessageBoxButtons.OKCancel);
				if(result == DialogResult.OK)
				{
					try
					{
						//Submit the posting
						template.Submit();
						cmsApplicationContext.CommitAll();
						//Reset list view
						listViewPostings.Items.Clear();
						TemplateGallery galery = treeViewTemplateGallery.SelectedNode.Tag as TemplateGallery; 
						foreach(Template t in galery.Templates)
						{
							string clientName = t.CreatedBy.ClientAccountName;
							ListViewItem currentItem = null;
							if(clientName.IndexOf("/")==-1)
							{
								currentItem = new ListViewItem(new string[]{t.Name,t.Guid,t.State.ToString(),t.CanUseForAuthoring==true?"Can use":"Can't use",clientName,t.CreatedDate.ToString()},t.ConnectedTemplates.Count>0?4:2);
							}
							else
							{
								currentItem = new ListViewItem(new string[]{t.Name,t.Guid,t.State.ToString(),t.CanUseForAuthoring==true?"Can use":"Can't use",clientName.Split('/')[clientName.Split('/').Length-1],t.CreatedDate.ToString()},t.ConnectedTemplates.Count>0?4:2);
							}
							currentItem.Tag = t;
							listViewPostings.Items.Add(currentItem);
						}
					}
					catch(Exception ex)
					{
						MessageBox.Show("While trying to submit the template an exception was thrown. The message was : "+ex.Message,"Error",MessageBoxButtons.OK,MessageBoxIcon.Error);
					}
				}			
			}
			else
			{
				MessageBox.Show("Selected template not found","Error",MessageBoxButtons.OK,MessageBoxIcon.Error);
			}
		}

		private void templatePath_Click(object sender, EventArgs e)
		{
			Template template = selectedItem.Tag as Template;
			if(template!=null)
			{
				try
				{
					//Copy the guid to the clipboard
					Clipboard.SetDataObject(template.Path,true);
					MessageBox.Show("Template's path is "+template.Path+". Its path copied to the clipboard.","Path Copied");
				}
				catch(Exception ex)
				{

					MessageBox.Show("While trying to copy the path to clipboard an was thrown. The message was : "+ex.Message,"Error",MessageBoxButtons.OK,MessageBoxIcon.Error);
				}
			}
			else
			{
				MessageBox.Show("Selected template not found","Error",MessageBoxButtons.OK,MessageBoxIcon.Error);
			}
		}

		private void templateUsingPosting_Click(object sender, EventArgs e)
		{
			Template template = selectedItem.Tag as Template;
			if(template!=null)
			{
				try
				{
					FormSearch search = new FormSearch();
					search.Text+=" in channel : " + cmsApplicationContext.RootChannel.Name;
					FormSearch.ChannelGuid = cmsApplicationContext.RootChannel.Guid;
					FormSearch.TemplateGuid = template.Guid;
					search.ShowDialog();
					FormSearch.TemplateGuid = "";
				}
				catch(Exception ex)
				{
					MessageBox.Show("While trying to search an was thrown. The message was : "+ex.Message,"Error",MessageBoxButtons.OK,MessageBoxIcon.Error);
				}
			}
			else
			{
				MessageBox.Show("Selected template not found","Error",MessageBoxButtons.OK,MessageBoxIcon.Error);
			}
		}

		private void templateSourceFile_Click(object sender, EventArgs e)
		{
			Template template = selectedItem.Tag as Template;
			if(template!=null)
			{
				try
				{
					//Copy the guid to the clipboard
					Clipboard.SetDataObject(template.SourceFile,true);
					MessageBox.Show("Template's source file is "+template.SourceFile+". Its path copied to the clipboard.","Path Copied");
				}
				catch(Exception ex)
				{

					MessageBox.Show("While trying to copy the path to clipboard an was thrown. The message was : "+ex.Message,"Error",MessageBoxButtons.OK,MessageBoxIcon.Error);
				}
			}
			else
			{
				MessageBox.Show("Selected template not found","Error",MessageBoxButtons.OK,MessageBoxIcon.Error);
			}
		}
	
		#endregion

		#region Tools - File Convertor

		private void menuItemConvert_Click(object sender, System.EventArgs e)
		{
			FormConvertor convert = new FormConvertor();
			convert.Show();
		}

		private void menuItemLogViewer_Click(object sender, System.EventArgs e)
		{
			FormLogViewer viewer = new FormLogViewer();
			viewer.Show();
		}

		#endregion

		#region Posting

		private void treeViewChannels_AfterSelect(object sender, System.Windows.Forms.TreeViewEventArgs e)
		{
			BuildChannels((Channel)e.Node.Tag,e.Node);
			//Listview is created with postings
			listViewPostings.Items.Clear();
			Channel channel = (Channel)e.Node.Tag;
            try
			{
				foreach(Posting p in channel.Postings)
				{
					string clientName = p.CreatedBy.ClientAccountName;
					ListViewItem currentItem = null;
					if(clientName.IndexOf("/")==-1)
					{
						currentItem = new ListViewItem(new string[]{p.Name,p.Guid,p.State.ToString(),clientName,p.CreatedDate.ToString()},p.ConnectedPostings.Count>0?3:0);
					}
					else
					{
						currentItem = new ListViewItem(new string[]{p.Name,p.Guid,p.State.ToString(),clientName.Split('/')[clientName.Split('/').Length-1],p.CreatedDate.ToString()},p.ConnectedPostings.Count>0?3:0);
					}
					currentItem.Tag = p;
					listViewPostings.Items.Add(currentItem);
				}
				
			}
				//Sometimes if its disposing it may throw an exception which we don't worry about
			catch
			{}
		}

		private void ChannelsAfterSelect()
		{
			listViewPostings.Items.Clear();
			try
			{
				foreach(Posting p in ((Channel)treeViewChannels.SelectedNode.Tag).Postings)
				{
					string clientName = p.CreatedBy.ClientAccountName;
					ListViewItem currentItem = null;
					if(clientName.IndexOf("/")==-1)
					{
						currentItem = new ListViewItem(new string[]{p.Name,p.Guid,p.State.ToString(),clientName,p.CreatedDate.ToString()},p.ConnectedPostings.Count>0?3:0);
					}
					else
					{
						currentItem = new ListViewItem(new string[]{p.Name,p.Guid,p.State.ToString(),clientName.Split('/')[clientName.Split('/').Length-1],p.CreatedDate.ToString()},p.ConnectedPostings.Count>0?3:0);
					}
					currentItem.Tag = p;
					listViewPostings.Items.Add(currentItem);
				}
			}
				//Sometimes if its disposing it may throw an exception which we don't worry about
			catch
			{}
		}

		private void postingGuid_Click(object sender, EventArgs e)
		{
			Posting posting = (Posting)selectedItem.Tag;
			
			if(posting!=null)
			{
				try
				{
					//Copy the guid to the clipboard
					Clipboard.SetDataObject(posting.Guid,true);
					MessageBox.Show("Posting Guid is copied to the clipboard.","Guid Copied");
				}
				catch(Exception ex)
				{

					MessageBox.Show("While trying to copy the Guid to clipboard an was thrown. The message was : "+ex.Message,"Error",MessageBoxButtons.OK,MessageBoxIcon.Error);
				}
			}
			else
			{
				MessageBox.Show("Selected posting not found","Error",MessageBoxButtons.OK,MessageBoxIcon.Error);
			}
		}
			
		private void postingOwner_Click(object sender, EventArgs e)
		{
			Posting posting = (Posting)selectedItem.Tag;
			if(posting!=null)
			{
				//Get the owner of the selected posting
				if(posting.OwnedBy.ClientAccountName.IndexOf("/")==-1)
				{
					MessageBox.Show("This posting is owned by : "+posting.OwnedBy.ClientAccountName,"Owner");
				}
				else
				{
					MessageBox.Show("This posting is owned by : "+posting.OwnedBy.ClientAccountName.Split('/')[posting.CreatedBy.ClientAccountName.Split('/').Length-1],"Owner");
				}
			}
			else
			{
				MessageBox.Show("Selected posting not found","Error",MessageBoxButtons.OK,MessageBoxIcon.Error);
			}
		}

		private void postingReleaseOwner_Click(object sender, EventArgs e)
		{
			Posting posting = (Posting)selectedItem.Tag;
			if(posting!=null)
			{
				DialogResult result = MessageBox.Show("This will try to release the ownership on "+posting.Name+". If the state of the posting is not saved, because of a bug in MCMS 2002 it will change the state to saved.","Warning!",MessageBoxButtons.OKCancel);
				if(result == DialogResult.OK)
				{
					try
					{
						//Release the ownership on the given posting
						posting.ReleaseOwnership(true);
						cmsApplicationContext.CommitAll();
						//Reload the list view
						listViewPostings.Items.Clear();
						Channel channel = (Channel)treeViewChannels.SelectedNode.Tag;
						foreach(Posting p in channel.Postings)
						{
							string clientName = p.CreatedBy.ClientAccountName;
							ListViewItem currentItem = null;
							if(clientName.IndexOf("/")==-1)
							{
								currentItem = new ListViewItem(new string[]{p.Name,p.Guid,p.State.ToString(),clientName,p.CreatedDate.ToString()},p.ConnectedPostings.Count>0?3:0);
							}
							else
							{
								currentItem = new ListViewItem(new string[]{p.Name,p.Guid,p.State.ToString(),clientName.Split('/')[clientName.Split('/').Length-1],p.CreatedDate.ToString()},p.ConnectedPostings.Count>0?3:0);
							}
							currentItem.Tag = p;
							listViewPostings.Items.Add(currentItem);
						}
					}
					catch(Exception ex)
					{
						MessageBox.Show("While trying to release the ownership an exception was thrown. The message was : "+ex.Message,"Error",MessageBoxButtons.OK,MessageBoxIcon.Error);
					}
				}
			}
			else
			{
				MessageBox.Show("Selected posting not found","Error",MessageBoxButtons.OK,MessageBoxIcon.Error);
			}
		}

		private void postingState_Click(object sender, EventArgs e)
		{
			Posting posting = (Posting)selectedItem.Tag;
			if(posting!=null)
			{
				//Get the state of the posting
				MessageBox.Show("State of the Posting : "+posting.State.ToString(),"Posting State");
			}
			else
			{
				MessageBox.Show("Selected posting not found","Error",MessageBoxButtons.OK,MessageBoxIcon.Error);
			}
		}

		private void postingApprove_Click(object sender, EventArgs e)
		{
			Posting posting = (Posting)selectedItem.Tag;
			if(posting!=null)
			{
				DialogResult result = MessageBox.Show("This will change the state of the posting to the next approved level according to the rights the channel has and this user has. Do you want to proceed?","Warning!",MessageBoxButtons.OKCancel);
				if(result == DialogResult.OK)
				{
					try
					{
						//Approve the posting
						posting.Approve();
						//Commit it
						cmsApplicationContext.CommitAll();
						//Reload the list view
						listViewPostings.Items.Clear();
						Channel channel = (Channel)treeViewChannels.SelectedNode.Tag;
						foreach(Posting p in channel.Postings)
						{
							string clientName = p.CreatedBy.ClientAccountName;
							ListViewItem currentItem = null;
							if(clientName.IndexOf("/")==-1)
							{
								currentItem = new ListViewItem(new string[]{p.Name,p.Guid,p.State.ToString(),clientName,p.CreatedDate.ToString()},p.ConnectedPostings.Count>0?3:0);
							}
							else
							{
								currentItem = new ListViewItem(new string[]{p.Name,p.Guid,p.State.ToString(),clientName.Split('/')[clientName.Split('/').Length-1],p.CreatedDate.ToString()},p.ConnectedPostings.Count>0?3:0);
							}
							currentItem.Tag = p;
							listViewPostings.Items.Add(currentItem);
						}
					}
					catch(Exception ex)
					{
						MessageBox.Show("While trying to approve the posting an exception was thrown. The message was : "+ex.Message,"Error",MessageBoxButtons.OK,MessageBoxIcon.Error);
					}
				}			
			}
			else
			{
				MessageBox.Show("Selected posting not found","Error",MessageBoxButtons.OK,MessageBoxIcon.Error);
			}
		}

		private void postingDecline_Click(object sender, EventArgs e)
		{
			Posting posting = (Posting)selectedItem.Tag;
			if(posting!=null)
			{
				DialogResult result = MessageBox.Show("This will change the state of the posting as declined. Do you want to proceed?","Warning!",MessageBoxButtons.OKCancel);
				if(result == DialogResult.OK)
				{
					try
					{
						//Decline the positng
						posting.Decline();
						cmsApplicationContext.CommitAll();
						//Reset list view
						listViewPostings.Items.Clear();
						Channel channel = (Channel)treeViewChannels.SelectedNode.Tag;
						foreach(Posting p in channel.Postings)
						{
							string clientName = p.CreatedBy.ClientAccountName;
							ListViewItem currentItem = null;
							if(clientName.IndexOf("/")==-1)
							{
								currentItem = new ListViewItem(new string[]{p.Name,p.Guid,p.State.ToString(),clientName,p.CreatedDate.ToString()},p.ConnectedPostings.Count>0?3:0);
							}
							else
							{
								currentItem = new ListViewItem(new string[]{p.Name,p.Guid,p.State.ToString(),clientName.Split('/')[clientName.Split('/').Length-1],p.CreatedDate.ToString()},p.ConnectedPostings.Count>0?3:0);
							}
							currentItem.Tag = p;
							listViewPostings.Items.Add(currentItem);
						}
					}
					catch(Exception ex)
					{
						MessageBox.Show("While trying to decline the posting an exception was thrown. The message was : "+ex.Message,"Error",MessageBoxButtons.OK,MessageBoxIcon.Error);
					}
				}			
			}
			else
			{
				MessageBox.Show("Selected posting not found","Error",MessageBoxButtons.OK,MessageBoxIcon.Error);
			}
		}

		private void postingSubmit_Click(object sender, EventArgs e)
		{
			Posting posting = (Posting)selectedItem.Tag;
			if(posting!=null)
			{
				DialogResult result = MessageBox.Show("This will try to submit the current posting. Do you want to proceed?","Warning!",MessageBoxButtons.OKCancel);
				if(result == DialogResult.OK)
				{
					try
					{
						//Submit the posting
						posting.Submit();
						cmsApplicationContext.CommitAll();
						//Reset list view
						listViewPostings.Items.Clear();
						Channel channel = (Channel)treeViewChannels.SelectedNode.Tag;
						foreach(Posting p in channel.Postings)
						{
							string clientName = p.CreatedBy.ClientAccountName;
							ListViewItem currentItem = null;
							if(clientName.IndexOf("/")==-1)
							{
								currentItem = new ListViewItem(new string[]{p.Name,p.Guid,p.State.ToString(),clientName,p.CreatedDate.ToString()},p.ConnectedPostings.Count>0?3:0);
							}
							else
							{
								currentItem = new ListViewItem(new string[]{p.Name,p.Guid,p.State.ToString(),clientName.Split('/')[clientName.Split('/').Length-1],p.CreatedDate.ToString()},p.ConnectedPostings.Count>0?3:0);
							}
							currentItem.Tag = p;
							listViewPostings.Items.Add(currentItem);
						}
					}
					catch(Exception ex)
					{
						MessageBox.Show("While trying to submit the posting an exception was thrown. The message was : "+ex.Message,"Error",MessageBoxButtons.OK,MessageBoxIcon.Error);
					}
				}			
			}
			else
			{
				MessageBox.Show("Selected posting not found","Error",MessageBoxButtons.OK,MessageBoxIcon.Error);
			}
		}
		
		//Open the posting in a browser
		private void postingPublichedURL_Click(object sender, EventArgs e)
		{
			Posting posting = (Posting)selectedItem.Tag;
			if(posting!=null)
			{
				try
				{
					if(posting.UrlModePublished.ToLower().StartsWith("http://"))
					{
						System.Diagnostics.Process.Start(posting.UrlModePublished);//,"iexplorer.exe");
					}
					else
					{
						System.Diagnostics.Process.Start(serverName + posting.UrlModePublished);//,"iexplorer.exe");
					}
				}
				catch(Exception ex)
				{
					MessageBox.Show("While trying to open posting an exception was thrown. The message was : "+ex.Message,"Error",MessageBoxButtons.OK,MessageBoxIcon.Error);
				}
			}
			else
			{
				MessageBox.Show("Selected posting not found","Error",MessageBoxButtons.OK,MessageBoxIcon.Error);
			}
		}

		private void postingUnPublichedURL_Click(object sender, EventArgs e)
		{
			Posting posting = (Posting)selectedItem.Tag;
			if(posting!=null)
			{
				try
				{
					System.Diagnostics.Process.Start(serverName + posting.UrlModeUnpublished + "&WBCMODE=PresentationUnpublished&wbc_purpose=Basic");//,"iexplorer.exe");
				}
				catch(Exception ex)
				{
					MessageBox.Show("While trying to open posting an exception was thrown. The message was : "+ex.Message,"Error",MessageBoxButtons.OK,MessageBoxIcon.Error);
				}
			}
			else
			{
				MessageBox.Show("Selected posting not found","Error",MessageBoxButtons.OK,MessageBoxIcon.Error);
			}
		}

		private void postingUpdateURL_Click(object sender, EventArgs e)
		{
			Posting posting = (Posting)selectedItem.Tag;
			if(posting!=null)
			{
				try
				{
					System.Diagnostics.Process.Start(serverName + posting.UrlModeUpdate + "&WBCMODE=PresentationUnpublished");//,"iexplorer.exe");
				}
				catch(Exception ex)
				{
					MessageBox.Show("While trying to open posting an exception was thrown. The message was : "+ex.Message);
				}
			}
			else
			{
				MessageBox.Show("Selected posting not found","Error",MessageBoxButtons.OK,MessageBoxIcon.Error);
			}
		}

		private void listViewPostings_DoubleClick(object sender, System.EventArgs e)
		{
			if(tabControl.SelectedIndex==0)
			{
				Posting posting = (Posting)listViewPostings.SelectedItems[0].Tag;
				if(posting!=null)
				{
					try
					{
						System.Diagnostics.Process.Start(serverName + posting.Url);//,"iexplorer.exe");
					}
					catch(Exception ex)
					{
						MessageBox.Show("While trying to open posting an exception was thrown. The message was : "+ex.Message,"Error",MessageBoxButtons.OK,MessageBoxIcon.Error);
					}
				}
		
				else
				{
					MessageBox.Show("Selected posting not found","Error",MessageBoxButtons.OK,MessageBoxIcon.Error);
				}
			}
			else if(tabControl.SelectedIndex==1)
			{
			}
			else
			{
			}
		}

		private void postingEdit_Click(object sender, EventArgs e)
		{
			this.Cursor = Cursors.WaitCursor;
			Posting posting = (Posting)selectedItem.Tag;
			if(posting!=null)
			{
				bool edit = false;
				if(posting.State==PostingState.Saved)
				{
					edit = true;
				}
				else
				{
					DialogResult result = MessageBox.Show("State of the selected posting '"+posting.Name +"' is "+posting.State+". If you edit the content, then it must go through the workflow. Do you want to continue?","Posting State in not Saved",MessageBoxButtons.YesNo,MessageBoxIcon.Question);
					if(result == DialogResult.Yes)
					{
						edit = true;
					}
				}
				if(edit)
				{
					//Whehter the selected posting has data or not
					if(posting.Placeholders!=null && posting.Placeholders.Count>0)
					{
						currentPosting = posting;
						FormEdit editForm = new FormEdit();
						editForm.ShowDialog();
						
						//Reload the list view
						listViewPostings.Items.Clear();
						Channel channel = (Channel)treeViewChannels.SelectedNode.Tag;
						foreach(Posting p in channel.Postings)
						{
							string clientName = p.CreatedBy.ClientAccountName;
							ListViewItem currentItem = null;
							if(clientName.IndexOf("/")==-1)
							{
								currentItem = new ListViewItem(new string[]{p.Name,p.Guid,p.State.ToString(),clientName,p.CreatedDate.ToString()},p.ConnectedPostings.Count>0?3:0);
							}
							else
							{
								currentItem = new ListViewItem(new string[]{p.Name,p.Guid,p.State.ToString(),clientName.Split('/')[clientName.Split('/').Length-1],p.CreatedDate.ToString()},p.ConnectedPostings.Count>0?3:0);
							}
							currentItem.Tag = p;
							listViewPostings.Items.Add(currentItem);
						}
					}
					else
					{
						MessageBox.Show("Selected posting '"+posting.Name +"' doesn't have any data which can be editted","No data",MessageBoxButtons.OK,MessageBoxIcon.Information);
					}
				}
			}
			this.Cursor = Cursors.Default;
		}

		private void postingProperties_Click(object sender, EventArgs e)
		{
			Posting posting = (Posting)selectedItem.Tag;
			if(posting!=null)
			{
				if(posting!=null)
				{
					bool edit = false;
					if(posting.State==PostingState.Saved)
					{
						edit = true;
					}
					else
					{
						DialogResult result = MessageBox.Show("State of the selected posting '"+posting.Name +"' is "+posting.State+". If you edit properties, then it must go through the workflow. Do you want to continue?","Posting State in not Saved",MessageBoxButtons.YesNo,MessageBoxIcon.Question);
						if(result == DialogResult.Yes)
						{
							edit = true;
						}
					}
					if(edit)
					{
						currentPosting = posting;
						FormProperties editForm = new FormProperties();
						editForm.ShowDialog();
						//Reload the list view
						listViewPostings.Items.Clear();
						Channel channel = (Channel)treeViewChannels.SelectedNode.Tag;
						foreach(Posting p in channel.Postings)
						{
							string clientName = p.CreatedBy.ClientAccountName;
							ListViewItem currentItem = null;
							if(clientName.IndexOf("/")==-1)
							{
								currentItem = new ListViewItem(new string[]{p.Name,p.Guid,p.State.ToString(),clientName,p.CreatedDate.ToString()},p.ConnectedPostings.Count>0?3:0);
							}
							else
							{
								currentItem = new ListViewItem(new string[]{p.Name,p.Guid,p.State.ToString(),clientName.Split('/')[clientName.Split('/').Length-1],p.CreatedDate.ToString()},p.ConnectedPostings.Count>0?3:0);
							}
							currentItem.Tag = p;
							listViewPostings.Items.Add(currentItem);
						}

					}		
				}
			}
		}

		private void postingTemplateGuid_Click(object sender, EventArgs e)
		{
			Posting posting = (Posting)selectedItem.Tag;
			
			if(posting!=null && posting.Template!=null)
			{
				try
				{
					//Copy the guid to the clipboard
					Clipboard.SetDataObject(posting.Template.Guid,true);
					MessageBox.Show("Template Guid of this posting is : "+posting.Template.Guid+ ". The Guid is copied to the clipboard.","Guid Copied");
				}
				catch(Exception ex)
				{

					MessageBox.Show("While trying to copy the Guid to clipboard an was thrown. The message was : "+ex.Message,"Error",MessageBoxButtons.OK,MessageBoxIcon.Error);
				}
			}
			else
			{
				MessageBox.Show("Selected posting not found","Error",MessageBoxButtons.OK,MessageBoxIcon.Error);
			}

		}

		private void postingConnected_Click(object sender, EventArgs e)
		{
			Posting posting = (Posting)selectedItem.Tag;
			if(posting!=null)
			{
				try
				{
					FormConnectedSearch connectedSearch = new FormConnectedSearch();
					connectedSearch.Text+=", Posting Name : " + posting.Name;
					FormConnectedSearch.ConnectedPostingGuid = posting.Guid;
					connectedSearch.ShowDialog();
				}
				catch(Exception ex)
				{

					MessageBox.Show("While trying to get the connected posting an was thrown. The message was : "+ex.Message,"Error",MessageBoxButtons.OK,MessageBoxIcon.Error);
				}
			}
			else
			{
				MessageBox.Show("Selected posting not found","Error",MessageBoxButtons.OK,MessageBoxIcon.Error);
			}
		}
		
		#endregion

		#region ThumpNail
		private void listViewPostings_MouseMove(object sender, System.Windows.Forms.MouseEventArgs e)
		{
			OnListBoxMouseMove();
		}

		private void listViewPostings_MouseLeave(object sender, System.EventArgs e)
		{
			OnListBoxMouseCancel();
		}

		private void OnListBoxMouseCancel()
		{
			if (thumbNailImage.Visible)
			{
				thumbNailImage.Hide();
				lastListItemOver = null;
			}
		}

		private void OnListBoxMouseMove()
		{
			ListViewItem itemOver = null;

			Point pt = GetItemLocation(ref itemOver);
			Point thumbPoint = new Point(0,0);
			//this is bit trickey. the image must be shown with some knowledge. otherwise may
			//hide somewhere.
			if(FormMCMSManager.desktopSize.Height<pt.Y+20+FormMCMSManager.thumbnailHeight && FormMCMSManager.desktopSize.Width<pt.X+11+FormMCMSManager.thumbnailWidth)
			{
				thumbPoint = new Point(FormMCMSManager.desktopSize.Width-FormMCMSManager.thumbnailWidth,FormMCMSManager.desktopSize.Height-FormMCMSManager.thumbnailHeight);
			}
			else if(FormMCMSManager.desktopSize.Height<pt.Y+20+FormMCMSManager.thumbnailHeight)
			{
				thumbPoint = new Point(pt.X+11,FormMCMSManager.desktopSize.Height-FormMCMSManager.thumbnailHeight);
			}
			else if(FormMCMSManager.desktopSize.Width<pt.X+11+FormMCMSManager.thumbnailWidth)
			{
				thumbPoint = new Point(FormMCMSManager.desktopSize.Width-FormMCMSManager.thumbnailWidth,pt.Y+20);
			}
			else
			{
				thumbPoint = new Point(pt.X+11,pt.Y+20);
			}
			
			thumbNailImage.Location = thumbPoint;
			if (itemOver != lastListItemOver)
			{
				if (itemOver != null)
				{
					thumbNailImage.Location = thumbPoint;
					if(tabControl.SelectedIndex==0)
					{
						if(FormMCMSManager.showPreview)
						{
							Posting posting = (Posting)itemOver.Tag;
							if(File.Exists(FormMCMSManager.thumbnailPath+"\\"+posting.Guid+".jpg"))
							{
								try
								{
									thumbNailImage.Text = "";
									this.thumbNailImage.BackgroundImage = Bitmap.FromFile(FormMCMSManager.thumbnailPath+"\\"+posting.Guid+".jpg");
									this.thumbNailImage.Size = this.thumbNailImage.BackgroundImage.Size;
									thumbNailImage.ShowFloating();
								}
								catch{}
							}
							else
							{
								thumbPoint = new Point(pt.X+11,pt.Y+20);
								thumbNailImage.Location = thumbPoint;
								thumbNailImage.Text = "Preview is not available...";
								thumbNailImage.BackColor = SystemColors.Info;
								thumbNailImage.Size = new Size(140,16);
								this.thumbNailImage.BackgroundImage = null;
								thumbNailImage.ForeColor = SystemColors.InfoText;
								thumbNailImage.ShowFloating();
							}
						}
					}
					else if(tabControl.SelectedIndex==1)
					{
						if(FormMCMSManager.showPreviewResource)
						{
							Resource resource = (Resource)itemOver.Tag;
							try
							{
								thumbNailImage.Text = "";
								this.thumbNailImage.BackgroundImage = Bitmap.FromStream(resource.OpenReadStream());
								this.thumbNailImage.Size = this.thumbNailImage.BackgroundImage.Size;
								thumbNailImage.ShowFloating();
							}
								//must be something else
							catch
							{
								thumbNailImage.Hide();
							}
						}
					}
					if(tabControl.SelectedIndex==2)
					{
						if(FormMCMSManager.showPreviewTemplate)
						{
							Template template = (Template)itemOver.Tag;
							if(File.Exists(FormMCMSManager.thumbnailPath+"\\"+template.Guid+".jpg"))
							{
								try
								{
									thumbNailImage.Text = "";
									this.thumbNailImage.BackgroundImage = Bitmap.FromFile(FormMCMSManager.thumbnailPath+"\\"+template.Guid+".jpg");
									this.thumbNailImage.Size = this.thumbNailImage.BackgroundImage.Size;
									thumbNailImage.ShowFloating();
								}
								catch{}
							}
							else
							{
								thumbPoint = new Point(pt.X+11,pt.Y+20);
								thumbNailImage.Location = thumbPoint;
								thumbNailImage.Text = "Preview is not available...";
								thumbNailImage.BackColor = SystemColors.Info;
								thumbNailImage.Size = new Size(140,16);
								this.thumbNailImage.BackgroundImage = null;
								thumbNailImage.ForeColor = SystemColors.InfoText;
								thumbNailImage.ShowFloating();
							}
						}
					}
				}
				else
				{
					OnListBoxMouseCancel();
				}
			}			
			lastListItemOver = itemOver;

		}

		private Point GetItemLocation(ref ListViewItem itemOver)
		{
			itemOver = null;
			Point cursorPosition = Cursor.Position;
			Point location = new Point(0,0);			
			// Convert cursor position to ListBox coordinates:
			cursorPosition = listViewPostings.PointToClient(cursorPosition);
			itemOver = listViewPostings.GetItemAt(cursorPosition.X,cursorPosition.Y);
			return listViewPostings.PointToScreen(cursorPosition);
		}


		#endregion

		#region Settings
		private void menuItemOptions_Click(object sender, System.EventArgs e)
		{
			FormSettings settings = new FormSettings();
			settings.ShowDialog();
		}
		#endregion

		#region Help

		private void menuItemReleaseOwnership_Click(object sender, System.EventArgs e)
		{
			try
			{
				System.Diagnostics.Process.Start(Application.StartupPath+"/doc/KillLock.htm");
			}
			catch(Exception ex)
			{
				MessageBox.Show("While opening the help file an exception was thrown. Exception : "+ex.Message,"Error",MessageBoxButtons.OK,MessageBoxIcon.Error);
			}
		}

		private void menuItemIntroduction_Click(object sender, System.EventArgs e)
		{
			try
			{
				System.Diagnostics.Process.Start(Application.StartupPath+"/doc/Introduction.htm");
			}
			catch(Exception ex)
			{
				MessageBox.Show("While opening the help file an exception was thrown. Exception : "+ex.Message,"Error",MessageBoxButtons.OK,MessageBoxIcon.Error);
			}
		}

		private void menuItemLogin_Click(object sender, System.EventArgs e)
		{
			try
			{
				System.Diagnostics.Process.Start(Application.StartupPath+"/doc/Login.htm");
			}
			catch(Exception ex)
			{
				MessageBox.Show("While opening the help file an exception was thrown. Exception : "+ex.Message,"Error",MessageBoxButtons.OK,MessageBoxIcon.Error);
			}
		}

		private void menuItemBrowse_Click(object sender, System.EventArgs e)
		{
			try
			{
				System.Diagnostics.Process.Start(Application.StartupPath+"/doc/Browse.htm");
			}
			catch(Exception ex)
			{
				MessageBox.Show("While opening the help file an exception was thrown. Exception : "+ex.Message,"Error",MessageBoxButtons.OK,MessageBoxIcon.Error);
			}
		}

		private void menuItemEditAPosting_Click(object sender, System.EventArgs e)
		{
			try
			{
				System.Diagnostics.Process.Start(Application.StartupPath+"/doc/Edit.htm");
			}
			catch(Exception ex)
			{
				MessageBox.Show("While opening the help file an exception was thrown. Exception : "+ex.Message,"Error",MessageBoxButtons.OK,MessageBoxIcon.Error);
			}
		}

		private void menuItemEditProperties_Click(object sender, System.EventArgs e)
		{
			try
			{
				System.Diagnostics.Process.Start(Application.StartupPath+"/doc/Editproperties.htm");
			}
			catch(Exception ex)
			{
				MessageBox.Show("While opening the help file an exception was thrown. Exception : "+ex.Message,"Error",MessageBoxButtons.OK,MessageBoxIcon.Error);
			}		
		}

		private void menuItemSearch_Click(object sender, System.EventArgs e)
		{
			try
			{
				System.Diagnostics.Process.Start(Application.StartupPath+"/doc/Search.htm");
			}
			catch(Exception ex)
			{
				MessageBox.Show("While opening the help file an exception was thrown. Exception : "+ex.Message,"Error",MessageBoxButtons.OK,MessageBoxIcon.Error);
			}		
		}

		private void menuItemReports_Click(object sender, System.EventArgs e)
		{
			try
			{
				System.Diagnostics.Process.Start(Application.StartupPath+"/doc/Reports.htm");
			}
			catch(Exception ex)
			{
				MessageBox.Show("While opening the help file an exception was thrown. Exception : "+ex.Message,"Error",MessageBoxButtons.OK,MessageBoxIcon.Error);
			}
		}

		private void menuItemPostingTemplate_Click(object sender, System.EventArgs e)
		{
			try
			{
				System.Diagnostics.Process.Start(Application.StartupPath+"/doc/PostingsOnTemplate.htm");
			}
			catch(Exception ex)
			{
				MessageBox.Show("While opening the help file an exception was thrown. Exception : "+ex.Message,"Error",MessageBoxButtons.OK,MessageBoxIcon.Error);
			}		
		}

		private void menuItemSaveResource_Click(object sender, System.EventArgs e)
		{
			try
			{
				System.Diagnostics.Process.Start(Application.StartupPath+"/doc/SaveResource.htm");
			}
			catch(Exception ex)
			{
				MessageBox.Show("While opening the help file an exception was thrown. Exception : "+ex.Message,"Error",MessageBoxButtons.OK,MessageBoxIcon.Error);
			}		
		}

		private void menuItemPostingResource_Click(object sender, System.EventArgs e)
		{
			try
			{
				System.Diagnostics.Process.Start(Application.StartupPath+"/doc/PostingsOnResource.htm");
			}
			catch(Exception ex)
			{
				MessageBox.Show("While opening the help file an exception was thrown. Exception : "+ex.Message,"Error",MessageBoxButtons.OK,MessageBoxIcon.Error);
			}	
		}

		private void menuItemConnectedPostings_Click(object sender, System.EventArgs e)
		{
			try
			{
				System.Diagnostics.Process.Start(Application.StartupPath+"/doc/ConnectedPostings.htm");
			}
			catch(Exception ex)
			{
				MessageBox.Show("While opening the help file an exception was thrown. Exception : "+ex.Message,"Error",MessageBoxButtons.OK,MessageBoxIcon.Error);
			}	
		}

		private void menuItemThumbNail_Click(object sender, System.EventArgs e)
		{
			try
			{
				System.Diagnostics.Process.Start(Application.StartupPath+"/doc/Preview.htm");
			}
			catch(Exception ex)
			{
				MessageBox.Show("While opening the help file an exception was thrown. Exception : "+ex.Message,"Error",MessageBoxButtons.OK,MessageBoxIcon.Error);
			}	
		}

		private void menuItemIncrementalExport_Click(object sender, System.EventArgs e)
		{
			try
			{
				System.Diagnostics.Process.Start(Application.StartupPath+"/doc/IncrementalExport.htm");
			}
			catch(Exception ex)
			{
				MessageBox.Show("While opening the help file an exception was thrown. Exception : "+ex.Message,"Error",MessageBoxButtons.OK,MessageBoxIcon.Error);
			}		
		}

		private void menuItemIncrementalImport_Click(object sender, System.EventArgs e)
		{
			try
			{
				System.Diagnostics.Process.Start(Application.StartupPath+"/doc/IncrementalImport.htm");
			}
			catch(Exception ex)
			{
				MessageBox.Show("While opening the help file an exception was thrown. Exception : "+ex.Message,"Error",MessageBoxButtons.OK,MessageBoxIcon.Error);
			}		
		}

		private void menuItemUserGroupBackupRestoreHelp_Click(object sender, System.EventArgs e)
		{
			try
			{
				System.Diagnostics.Process.Start(Application.StartupPath+"/doc/UserGroupBackupRestore.htm");
			}
			catch(Exception ex)
			{
				MessageBox.Show("While opening the help file an exception was thrown. Exception : "+ex.Message,"Error",MessageBoxButtons.OK,MessageBoxIcon.Error);
			}		
		}

		#endregion

	}
}