/**
 * @file FormProperties.cs
 *
 * MCMS Manager
 *
 * MCMS Manager is the legal property of its developer
 * Chester Ragel <chesterr@gmail.com> - Developer and Maintainer
 * Yahoo ID : chesterr1979 
 * MSN : chesterr79@hotmail.com
 *
 * If you want more information, found any bugs or have any doubts you 
 * can mail me or contact me through my yahoo id.
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2.1 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */


#region Namespaces
using System;
using System.Drawing;
using System.Collections;
using System.ComponentModel;
using System.Windows.Forms;
using System.Data;
//MCMS components
using Microsoft.ContentManagement.Common;
using Microsoft.ContentManagement.Publishing;
#endregion

namespace MCMS
{
	/// <summary>
	/// Custom properties editor
	/// </summary>
	public class FormProperties : System.Windows.Forms.Form
	{
		#region Private Variables
		private System.Windows.Forms.ComboBox comboBoxProperty;
		private System.Windows.Forms.Label labelCustomPRoperty;
		private System.ComponentModel.Container components = null;

		private bool textChanged = false;
		private System.Windows.Forms.Button buttonExit;
		private System.Windows.Forms.Button buttonCommitAll;
		private System.Windows.Forms.Label labelPlaceholderContent;
		private System.Windows.Forms.TextBox textBoxContent;
		private System.Windows.Forms.TextBox textBoxDefaultValue;
		private System.Windows.Forms.Label labelDefaultValue;
		private System.Windows.Forms.ListBox listBoxAllowedValues;
		private System.Windows.Forms.Label labelAllowedValues;
		private int previousSelectedIndex = 0;
		#endregion

		#region Init/Dispose Controls
		
		public FormProperties()
		{
			InitializeComponent();
		}

		/// <summary>
		/// Clean up any resources being used.
		/// </summary>
		protected override void Dispose( bool disposing )
		{
			if( disposing )
			{
				if(components != null)
				{
					components.Dispose();
				}
			}
			base.Dispose( disposing );
		}

		#region Windows Form Designer generated code
		/// <summary>
		/// Required method for Designer support - do not modify
		/// the contents of this method with the code editor.
		/// </summary>
		private void InitializeComponent()
		{
			System.Resources.ResourceManager resources = new System.Resources.ResourceManager(typeof(FormProperties));
			this.comboBoxProperty = new System.Windows.Forms.ComboBox();
			this.labelCustomPRoperty = new System.Windows.Forms.Label();
			this.buttonExit = new System.Windows.Forms.Button();
			this.buttonCommitAll = new System.Windows.Forms.Button();
			this.labelPlaceholderContent = new System.Windows.Forms.Label();
			this.textBoxContent = new System.Windows.Forms.TextBox();
			this.textBoxDefaultValue = new System.Windows.Forms.TextBox();
			this.labelDefaultValue = new System.Windows.Forms.Label();
			this.listBoxAllowedValues = new System.Windows.Forms.ListBox();
			this.labelAllowedValues = new System.Windows.Forms.Label();
			this.SuspendLayout();
			// 
			// comboBoxProperty
			// 
			this.comboBoxProperty.DropDownStyle = System.Windows.Forms.ComboBoxStyle.DropDownList;
			this.comboBoxProperty.Location = new System.Drawing.Point(152, 16);
			this.comboBoxProperty.Name = "comboBoxProperty";
			this.comboBoxProperty.Size = new System.Drawing.Size(256, 21);
			this.comboBoxProperty.TabIndex = 0;
			this.comboBoxProperty.SelectedIndexChanged += new System.EventHandler(this.comboBoxProperty_SelectedIndexChanged);
			// 
			// labelCustomPRoperty
			// 
			this.labelCustomPRoperty.Location = new System.Drawing.Point(8, 16);
			this.labelCustomPRoperty.Name = "labelCustomPRoperty";
			this.labelCustomPRoperty.Size = new System.Drawing.Size(128, 23);
			this.labelCustomPRoperty.TabIndex = 7;
			this.labelCustomPRoperty.Text = "Custom Property";
			// 
			// buttonExit
			// 
			this.buttonExit.DialogResult = System.Windows.Forms.DialogResult.Cancel;
			this.buttonExit.Location = new System.Drawing.Point(314, 164);
			this.buttonExit.Name = "buttonExit";
			this.buttonExit.Size = new System.Drawing.Size(96, 23);
			this.buttonExit.TabIndex = 5;
			this.buttonExit.Text = "E&xit";
			this.buttonExit.Click += new System.EventHandler(this.buttonExit_Click);
			// 
			// buttonCommitAll
			// 
			this.buttonCommitAll.Location = new System.Drawing.Point(210, 164);
			this.buttonCommitAll.Name = "buttonCommitAll";
			this.buttonCommitAll.Size = new System.Drawing.Size(96, 23);
			this.buttonCommitAll.TabIndex = 4;
			this.buttonCommitAll.Text = "Sa&ve";
			this.buttonCommitAll.Visible = false;
			this.buttonCommitAll.Click += new System.EventHandler(this.buttonCommitAll_Click);
			// 
			// labelPlaceholderContent
			// 
			this.labelPlaceholderContent.Location = new System.Drawing.Point(8, 80);
			this.labelPlaceholderContent.Name = "labelPlaceholderContent";
			this.labelPlaceholderContent.Size = new System.Drawing.Size(108, 23);
			this.labelPlaceholderContent.TabIndex = 11;
			this.labelPlaceholderContent.Text = "Value";
			// 
			// textBoxContent
			// 
			this.textBoxContent.Enabled = false;
			this.textBoxContent.Location = new System.Drawing.Point(152, 80);
			this.textBoxContent.Name = "textBoxContent";
			this.textBoxContent.Size = new System.Drawing.Size(256, 20);
			this.textBoxContent.TabIndex = 2;
			this.textBoxContent.Text = "";
			this.textBoxContent.KeyPress += new System.Windows.Forms.KeyPressEventHandler(this.textBoxContent_KeyPress);
			// 
			// textBoxDefaultValue
			// 
			this.textBoxDefaultValue.Enabled = false;
			this.textBoxDefaultValue.Location = new System.Drawing.Point(152, 48);
			this.textBoxDefaultValue.Name = "textBoxDefaultValue";
			this.textBoxDefaultValue.Size = new System.Drawing.Size(256, 20);
			this.textBoxDefaultValue.TabIndex = 1;
			this.textBoxDefaultValue.Text = "";
			// 
			// labelDefaultValue
			// 
			this.labelDefaultValue.Location = new System.Drawing.Point(8, 48);
			this.labelDefaultValue.Name = "labelDefaultValue";
			this.labelDefaultValue.TabIndex = 13;
			this.labelDefaultValue.Text = "Default Value";
			// 
			// listBoxAllowedValues
			// 
			this.listBoxAllowedValues.Enabled = false;
			this.listBoxAllowedValues.Location = new System.Drawing.Point(152, 112);
			this.listBoxAllowedValues.Name = "listBoxAllowedValues";
			this.listBoxAllowedValues.Size = new System.Drawing.Size(256, 43);
			this.listBoxAllowedValues.TabIndex = 3;
			this.listBoxAllowedValues.SelectedIndexChanged += new System.EventHandler(this.listBoxAllowedValues_SelectedIndexChanged);
			// 
			// labelAllowedValues
			// 
			this.labelAllowedValues.Location = new System.Drawing.Point(8, 112);
			this.labelAllowedValues.Name = "labelAllowedValues";
			this.labelAllowedValues.TabIndex = 15;
			this.labelAllowedValues.Text = "Allowed Values";
			// 
			// FormProperties
			// 
			this.AcceptButton = this.buttonCommitAll;
			this.AutoScaleBaseSize = new System.Drawing.Size(5, 13);
			this.ClientSize = new System.Drawing.Size(424, 197);
			this.Controls.Add(this.labelAllowedValues);
			this.Controls.Add(this.listBoxAllowedValues);
			this.Controls.Add(this.labelDefaultValue);
			this.Controls.Add(this.textBoxDefaultValue);
			this.Controls.Add(this.labelPlaceholderContent);
			this.Controls.Add(this.textBoxContent);
			this.Controls.Add(this.buttonExit);
			this.Controls.Add(this.buttonCommitAll);
			this.Controls.Add(this.comboBoxProperty);
			this.Controls.Add(this.labelCustomPRoperty);
			this.FormBorderStyle = System.Windows.Forms.FormBorderStyle.FixedSingle;
			this.Icon = ((System.Drawing.Icon)(resources.GetObject("$this.Icon")));
			this.MaximizeBox = false;
			this.Name = "FormProperties";
			this.ShowInTaskbar = false;
			this.StartPosition = System.Windows.Forms.FormStartPosition.CenterScreen;
			this.Text = "Custom Properties Editor";
			this.Load += new System.EventHandler(this.FormProperties_Load);
			this.ResumeLayout(false);

		}
		#endregion

		private void FormProperties_Load(object sender, System.EventArgs e)
		{
			this.Text = "Edit Custom properties for posting : "+FormMCMSManager.currentPosting.Name;
			LoadCombo();
		}

		private void LoadCombo()
		{
			//clear the combobox
			comboBoxProperty.Items.Clear();
			for(int i=0 ; i<FormMCMSManager.currentPosting.CustomProperties.Count ; i++)
			{
				//add placeholder text to the combobox
				comboBoxProperty.Items.Add(FormMCMSManager.currentPosting.CustomProperties[i].Name);
			}
			//select the first node or selected node
			comboBoxProperty.SelectedItem = comboBoxProperty.Items[previousSelectedIndex];
		}

		#endregion

		#region Content Changes

		private void textBoxContent_KeyPress(object sender, System.Windows.Forms.KeyPressEventArgs e)
		{
			textChanged = true;
			buttonCommitAll.Visible = true;
		}

		private void buttonCommitAll_Click(object sender, System.EventArgs e)
		{
			try
			{
				//Commit the changes to the database
				FormMCMSManager.currentPosting.CustomProperties[previousSelectedIndex].Value = textBoxContent.Text;
				//committed, hide commit button
				textChanged = false;
				buttonCommitAll.Visible = false;
			}
			catch(CmsException ex)
			{
				MessageBox.Show("While trying to save properties, an exception was thrown. The exception is : "+ex.Message,"Error",MessageBoxButtons.OK,MessageBoxIcon.Error);
			}
		}

		private void buttonExit_Click(object sender, System.EventArgs e)
		{
			try
			{
				//withoput saving?
				if(textChanged)
				{
					DialogResult result = MessageBox.Show("There are some changes which are not saved. Do you want to save them? ","Before Exiting....",MessageBoxButtons.YesNo,MessageBoxIcon.Question);
					if(result == DialogResult.Yes)
					{
						FormMCMSManager.cmsApplicationContext.CommitAll();
					}
					else
					{
					}
				}
				FormMCMSManager.currentPosting = null;
				this.Close();
			}
			catch
			{}
		}

		private void comboBoxProperty_SelectedIndexChanged(object sender, System.EventArgs e)
		{
			//if text is changed
			if(textChanged)
			{
				DialogResult result = MessageBox.Show("There are some changes which are not saved. Do you want to save them? ","Save changes....",MessageBoxButtons.YesNo,MessageBoxIcon.Question);
				if(result == DialogResult.Yes)
				{
					try
					{
						// set the context
						FormMCMSManager.currentPosting.CustomProperties[previousSelectedIndex].Value = textBoxContent.Text;
					}
					catch(CmsException ex)
					{
						MessageBox.Show("When changing the custom properties an error was thrown. Please check the new content. Exception is : "+ ex.Message,"Error",MessageBoxButtons.OK,MessageBoxIcon.Error);
						comboBoxProperty.SelectedItem = comboBoxProperty.Items[previousSelectedIndex];
					}
				}
				textChanged = false;
				buttonCommitAll.Visible = false;
			}
			try
			{
				//get the placeholder to get the text out of it
				CustomProperty cp = FormMCMSManager.currentPosting.CustomProperties[comboBoxProperty.SelectedIndex];
				textBoxDefaultValue.Text = "";
				textBoxContent.Text = "";
				textBoxContent.Enabled = true;
				listBoxAllowedValues.Enabled = false;
				listBoxAllowedValues.Items.Clear();
				previousSelectedIndex = comboBoxProperty.SelectedIndex;
				if(cp!=null)
				{
					textBoxDefaultValue.Text = cp.DefaultValue;
					textBoxContent.Text = cp.Value;
					for(int i=0;i<cp.AllowedValues.Count;i++)
					{
						textBoxContent.Enabled = false;
						listBoxAllowedValues.Enabled = true;
						listBoxAllowedValues.Items.Add(cp.AllowedValues[i]);
					}
				}
				else
				{

				}
			}
			catch(CmsException ex)
			{
				MessageBox.Show("Exception is : "+ ex.Message,"Error",MessageBoxButtons.OK,MessageBoxIcon.Error);
			}
		}

		private void listBoxAllowedValues_SelectedIndexChanged(object sender, System.EventArgs e)
		{
			textBoxContent.Text = listBoxAllowedValues.SelectedItem.ToString();
			textChanged = true;
			buttonCommitAll.Visible = true;
		}

		#endregion
	}
}
