/**
 * @file FormSearch.cs
 *
 * MCMS Manager
 *
 * MCMS Manager is the legal property of its developer
 * Chester Ragel <chesterr@gmail.com> - Developer and Maintainer
 * Yahoo ID : chesterr1979 
 * MSN : chesterr79@hotmail.com
 *
 * If you want more information, found any bugs or have any doubts you 
 * can mail me or contact me through my yahoo id.
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2.1 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#region Namespaces
using System;
using System.Drawing;
using System.Collections;
using System.ComponentModel;
using System.Windows.Forms;
using System.Text.RegularExpressions;
using System.IO;
using System.Diagnostics;
//MCMS components
using Microsoft.ContentManagement.Common;
using Microsoft.ContentManagement.Publishing;
using Microsoft.ContentManagement.Publishing.Extensions.Placeholders.Office;
using Microsoft.ContentManagement.Publishing.Extensions.Placeholders;
#endregion

namespace MCMS
{
	/// <summary>
	/// Search form. This will be verymuch useful. Postings can be found using the search
	/// function now.
	/// </summary>
	public class FormSearch : System.Windows.Forms.Form
	{

		#region Private Controls
		private System.Windows.Forms.TextBox textBoxGuid;
		private System.Windows.Forms.Label labelPlaceholder;
		private System.Windows.Forms.TextBox textBoxPlaceHolder;
		private System.Windows.Forms.Label labelResults;
		private System.Windows.Forms.Button buttonSearch;
		private System.Windows.Forms.Label labelFilesFound;
		private ListViewColumnSorter lvwColumnSorter;
		private System.ComponentModel.IContainer components;
		private System.Windows.Forms.ListView listViewPosting;
		private System.Windows.Forms.ColumnHeader columnName;
		private System.Windows.Forms.ColumnHeader columnCreator;
		private System.Windows.Forms.ColumnHeader columnGuid;
		private System.Windows.Forms.ColumnHeader columnCreated;
		private System.Windows.Forms.ColumnHeader columnPostingState;
		private System.Windows.Forms.ContextMenu contextMenu;
		private System.Windows.Forms.ImageList imageList;
		private System.Windows.Forms.GroupBox groupBoxAdvanced;
		private System.Windows.Forms.Label labelPostingName;
		private System.Windows.Forms.Label labelPostingGuid;
		private System.Windows.Forms.CheckBox checkBoxPostingState;
		private System.Windows.Forms.CheckBox checkBoxAuthor;
		private System.Windows.Forms.CheckBox checkBoxDateCreated;
		private System.Windows.Forms.ComboBox comboBoxPostingState;
		private System.Windows.Forms.TextBox textBoxAuthor;
		private System.Windows.Forms.DateTimePicker dateTimePickerFrom;
		private System.Windows.Forms.DateTimePicker dateTimePickerTo;
		private System.Windows.Forms.TextBox textBoxName;
		private System.Windows.Forms.Button buttonClose;
		private System.Windows.Forms.Label labelTo;
		private System.Windows.Forms.Label labelFrom;
		private System.Windows.Forms.Label labelPlace;
		private System.Windows.Forms.Label labelTemplateName;
		private System.Windows.Forms.TextBox textBoxTemplateName;
		private ListViewItem selectedItem = null;
		private System.Windows.Forms.ToolTip toolTip;
		private System.Windows.Forms.ColumnHeader columnChannel;
		private System.Windows.Forms.Label labelSearchType;
		private System.Windows.Forms.ComboBox comboBoxSearchType;
		private System.Windows.Forms.Label labelTemplateGuid;
		private System.Windows.Forms.TextBox textBoxTemplateGuid;

		#endregion

		#region Menus
		private MenuItem postingGuid = null;
		private MenuItem postingReleaseOwner = null;
		private MenuItem postingOwner = null;
		private MenuItem postingApprove = null;
		private MenuItem postingSubmit = null;
		private MenuItem postingDecline = null;
		private MenuItem postingPublichedURL = null;
		private MenuItem postingUnPublichedURL = null;
		private MenuItem postingUpdateURL = null;
		private MenuItem postingEdit = null;
		private MenuItem postingProperties = null;
		private MenuItem postingConnected = null;
		#endregion
		
		#region Private Variables
		private int postingFound = 0;
		private bool searchButton = true;
		private int searchType = 0;
		private FloatControl thumbNailImage;
		private ListViewItem lastListItemOver = null;

		
		private CmsApplicationContext cmsApplication = new CmsApplicationContext();
		#endregion
	
		#region Public static Variables
		public static string ChannelGuid;
		private System.Windows.Forms.GroupBox groupBoxPosting;
		private System.Windows.Forms.GroupBox groupBoxTemplate;
		private System.Windows.Forms.CheckBox checkBoxPlaceholder;
		private System.Windows.Forms.ComboBox comboBoxPlaceholder;
		private System.Windows.Forms.CheckBox checkBoxImportant;
		private System.Windows.Forms.CheckBox checkBoxNew;
		private System.Windows.Forms.Label labeldays;
		private System.Windows.Forms.NumericUpDown numericUpDownDays;
		public static string TemplateGuid="";
		#endregion

		#region Private delegate to start search/stop search
		private delegate void SearchPostingsDelegate(Channel rootChannel);
		#endregion

		#region Init/Close
		public FormSearch()
		{
			InitializeComponent();
		}

		/// <summary>
		/// Clean up any resources being used.
		/// </summary>
		protected override void Dispose( bool disposing )
		{
			if( disposing )
			{
				if(components != null)
				{
					components.Dispose();
					try
					{
						//dispose the cms context if not
						ChannelGuid = "";
						cmsApplication.Dispose();
					}
					catch{}
				}
			}
			base.Dispose( disposing );
		}

		#region Windows Form Designer generated code
		/// <summary>
		/// Required method for Designer support - do not modify
		/// the contents of this method with the code editor.
		/// </summary>
		private void InitializeComponent()
		{
			this.components = new System.ComponentModel.Container();
			System.Resources.ResourceManager resources = new System.Resources.ResourceManager(typeof(FormSearch));
			this.labelPostingName = new System.Windows.Forms.Label();
			this.textBoxGuid = new System.Windows.Forms.TextBox();
			this.listViewPosting = new System.Windows.Forms.ListView();
			this.columnName = new System.Windows.Forms.ColumnHeader();
			this.columnChannel = new System.Windows.Forms.ColumnHeader();
			this.columnGuid = new System.Windows.Forms.ColumnHeader();
			this.columnPostingState = new System.Windows.Forms.ColumnHeader();
			this.columnCreator = new System.Windows.Forms.ColumnHeader();
			this.columnCreated = new System.Windows.Forms.ColumnHeader();
			this.contextMenu = new System.Windows.Forms.ContextMenu();
			this.imageList = new System.Windows.Forms.ImageList(this.components);
			this.labelPlaceholder = new System.Windows.Forms.Label();
			this.textBoxPlaceHolder = new System.Windows.Forms.TextBox();
			this.labelResults = new System.Windows.Forms.Label();
			this.buttonSearch = new System.Windows.Forms.Button();
			this.labelFilesFound = new System.Windows.Forms.Label();
			this.groupBoxAdvanced = new System.Windows.Forms.GroupBox();
			this.labeldays = new System.Windows.Forms.Label();
			this.checkBoxNew = new System.Windows.Forms.CheckBox();
			this.numericUpDownDays = new System.Windows.Forms.NumericUpDown();
			this.comboBoxPlaceholder = new System.Windows.Forms.ComboBox();
			this.checkBoxPlaceholder = new System.Windows.Forms.CheckBox();
			this.checkBoxDateCreated = new System.Windows.Forms.CheckBox();
			this.checkBoxAuthor = new System.Windows.Forms.CheckBox();
			this.checkBoxPostingState = new System.Windows.Forms.CheckBox();
			this.dateTimePickerTo = new System.Windows.Forms.DateTimePicker();
			this.dateTimePickerFrom = new System.Windows.Forms.DateTimePicker();
			this.labelTo = new System.Windows.Forms.Label();
			this.labelFrom = new System.Windows.Forms.Label();
			this.textBoxAuthor = new System.Windows.Forms.TextBox();
			this.comboBoxPostingState = new System.Windows.Forms.ComboBox();
			this.checkBoxImportant = new System.Windows.Forms.CheckBox();
			this.textBoxName = new System.Windows.Forms.TextBox();
			this.labelPostingGuid = new System.Windows.Forms.Label();
			this.buttonClose = new System.Windows.Forms.Button();
			this.labelPlace = new System.Windows.Forms.Label();
			this.toolTip = new System.Windows.Forms.ToolTip(this.components);
			this.labelSearchType = new System.Windows.Forms.Label();
			this.comboBoxSearchType = new System.Windows.Forms.ComboBox();
			this.labelTemplateGuid = new System.Windows.Forms.Label();
			this.textBoxTemplateGuid = new System.Windows.Forms.TextBox();
			this.labelTemplateName = new System.Windows.Forms.Label();
			this.textBoxTemplateName = new System.Windows.Forms.TextBox();
			this.groupBoxPosting = new System.Windows.Forms.GroupBox();
			this.groupBoxTemplate = new System.Windows.Forms.GroupBox();
			this.groupBoxAdvanced.SuspendLayout();
			((System.ComponentModel.ISupportInitialize)(this.numericUpDownDays)).BeginInit();
			this.groupBoxPosting.SuspendLayout();
			this.groupBoxTemplate.SuspendLayout();
			this.SuspendLayout();
			// 
			// labelPostingName
			// 
			this.labelPostingName.Location = new System.Drawing.Point(8, 16);
			this.labelPostingName.Name = "labelPostingName";
			this.labelPostingName.Size = new System.Drawing.Size(168, 24);
			this.labelPostingName.TabIndex = 0;
			this.labelPostingName.Text = "All or part of the Posting Name";
			// 
			// textBoxGuid
			// 
			this.textBoxGuid.Location = new System.Drawing.Point(192, 40);
			this.textBoxGuid.Name = "textBoxGuid";
			this.textBoxGuid.Size = new System.Drawing.Size(248, 20);
			this.textBoxGuid.TabIndex = 1;
			this.textBoxGuid.Text = "";
			// 
			// listViewPosting
			// 
			this.listViewPosting.AllowColumnReorder = true;
			this.listViewPosting.Columns.AddRange(new System.Windows.Forms.ColumnHeader[] {
																							  this.columnName,
																							  this.columnChannel,
																							  this.columnGuid,
																							  this.columnPostingState,
																							  this.columnCreator,
																							  this.columnCreated});
			this.listViewPosting.ContextMenu = this.contextMenu;
			this.listViewPosting.FullRowSelect = true;
			this.listViewPosting.LargeImageList = this.imageList;
			this.listViewPosting.Location = new System.Drawing.Point(8, 304);
			this.listViewPosting.MultiSelect = false;
			this.listViewPosting.Name = "listViewPosting";
			this.listViewPosting.Size = new System.Drawing.Size(792, 216);
			this.listViewPosting.SmallImageList = this.imageList;
			this.listViewPosting.Sorting = System.Windows.Forms.SortOrder.Ascending;
			this.listViewPosting.StateImageList = this.imageList;
			this.listViewPosting.TabIndex = 6;
			this.listViewPosting.View = System.Windows.Forms.View.Details;
			this.listViewPosting.MouseDown += new System.Windows.Forms.MouseEventHandler(this.listViewPosting_MouseDown);
			this.listViewPosting.DoubleClick += new System.EventHandler(this.listViewPosting_DoubleClick);
			this.listViewPosting.ColumnClick += new System.Windows.Forms.ColumnClickEventHandler(this.listViewPosting_ColumnClick);
			this.listViewPosting.MouseMove += new System.Windows.Forms.MouseEventHandler(this.listViewPosting_MouseMove);
			this.listViewPosting.MouseLeave += new System.EventHandler(this.listViewPosting_MouseLeave);
			// 
			// columnName
			// 
			this.columnName.Text = "Name";
			this.columnName.Width = 130;
			// 
			// columnChannel
			// 
			this.columnChannel.Text = "Channel";
			this.columnChannel.Width = 170;
			// 
			// columnGuid
			// 
			this.columnGuid.Text = "Guid";
			this.columnGuid.Width = 150;
			// 
			// columnPostingState
			// 
			this.columnPostingState.Text = "Posting State";
			this.columnPostingState.Width = 110;
			// 
			// columnCreator
			// 
			this.columnCreator.Text = "Author";
			this.columnCreator.Width = 100;
			// 
			// columnCreated
			// 
			this.columnCreated.Text = "Created On";
			this.columnCreated.Width = 120;
			// 
			// imageList
			// 
			this.imageList.ImageSize = new System.Drawing.Size(16, 16);
			this.imageList.ImageStream = ((System.Windows.Forms.ImageListStreamer)(resources.GetObject("imageList.ImageStream")));
			this.imageList.TransparentColor = System.Drawing.Color.Transparent;
			// 
			// labelPlaceholder
			// 
			this.labelPlaceholder.Location = new System.Drawing.Point(16, 224);
			this.labelPlaceholder.Name = "labelPlaceholder";
			this.labelPlaceholder.Size = new System.Drawing.Size(224, 23);
			this.labelPlaceholder.TabIndex = 2;
			this.labelPlaceholder.Text = "A word or phrase in the placeholder content";
			// 
			// textBoxPlaceHolder
			// 
			this.textBoxPlaceHolder.Location = new System.Drawing.Point(16, 248);
			this.textBoxPlaceHolder.Name = "textBoxPlaceHolder";
			this.textBoxPlaceHolder.Size = new System.Drawing.Size(440, 20);
			this.textBoxPlaceHolder.TabIndex = 3;
			this.textBoxPlaceHolder.Text = "";
			// 
			// labelResults
			// 
			this.labelResults.Location = new System.Drawing.Point(8, 280);
			this.labelResults.Name = "labelResults";
			this.labelResults.Size = new System.Drawing.Size(208, 23);
			this.labelResults.TabIndex = 5;
			this.labelResults.Text = "Search Results";
			// 
			// buttonSearch
			// 
			this.buttonSearch.Location = new System.Drawing.Point(712, 536);
			this.buttonSearch.Name = "buttonSearch";
			this.buttonSearch.Size = new System.Drawing.Size(88, 23);
			this.buttonSearch.TabIndex = 7;
			this.buttonSearch.Text = "Sea&rch";
			this.buttonSearch.Click += new System.EventHandler(this.buttonSearch_Click);
			// 
			// labelFilesFound
			// 
			this.labelFilesFound.Location = new System.Drawing.Point(464, 536);
			this.labelFilesFound.Name = "labelFilesFound";
			this.labelFilesFound.Size = new System.Drawing.Size(128, 23);
			this.labelFilesFound.TabIndex = 8;
			// 
			// groupBoxAdvanced
			// 
			this.groupBoxAdvanced.Controls.Add(this.labeldays);
			this.groupBoxAdvanced.Controls.Add(this.checkBoxNew);
			this.groupBoxAdvanced.Controls.Add(this.numericUpDownDays);
			this.groupBoxAdvanced.Controls.Add(this.comboBoxPlaceholder);
			this.groupBoxAdvanced.Controls.Add(this.checkBoxPlaceholder);
			this.groupBoxAdvanced.Controls.Add(this.checkBoxDateCreated);
			this.groupBoxAdvanced.Controls.Add(this.checkBoxAuthor);
			this.groupBoxAdvanced.Controls.Add(this.checkBoxPostingState);
			this.groupBoxAdvanced.Controls.Add(this.dateTimePickerTo);
			this.groupBoxAdvanced.Controls.Add(this.dateTimePickerFrom);
			this.groupBoxAdvanced.Controls.Add(this.labelTo);
			this.groupBoxAdvanced.Controls.Add(this.labelFrom);
			this.groupBoxAdvanced.Controls.Add(this.textBoxAuthor);
			this.groupBoxAdvanced.Controls.Add(this.comboBoxPostingState);
			this.groupBoxAdvanced.Controls.Add(this.checkBoxImportant);
			this.groupBoxAdvanced.Location = new System.Drawing.Point(464, 8);
			this.groupBoxAdvanced.Name = "groupBoxAdvanced";
			this.groupBoxAdvanced.Size = new System.Drawing.Size(336, 280);
			this.groupBoxAdvanced.TabIndex = 4;
			this.groupBoxAdvanced.TabStop = false;
			this.groupBoxAdvanced.Text = "Advanced options";
			// 
			// labeldays
			// 
			this.labeldays.Location = new System.Drawing.Point(288, 253);
			this.labeldays.Name = "labeldays";
			this.labeldays.Size = new System.Drawing.Size(32, 18);
			this.labeldays.TabIndex = 12;
			this.labeldays.Text = "days";
			// 
			// checkBoxNew
			// 
			this.checkBoxNew.Location = new System.Drawing.Point(16, 248);
			this.checkBoxNew.Name = "checkBoxNew";
			this.checkBoxNew.Size = new System.Drawing.Size(224, 24);
			this.checkBoxNew.TabIndex = 10;
			this.checkBoxNew.Text = "Search for New Postings Created within ";
			this.checkBoxNew.CheckedChanged += new System.EventHandler(this.checkBoxNew_CheckedChanged);
			// 
			// numericUpDownDays
			// 
			this.numericUpDownDays.Location = new System.Drawing.Point(240, 248);
			this.numericUpDownDays.Maximum = new System.Decimal(new int[] {
																			  1000,
																			  0,
																			  0,
																			  0});
			this.numericUpDownDays.Name = "numericUpDownDays";
			this.numericUpDownDays.Size = new System.Drawing.Size(40, 20);
			this.numericUpDownDays.TabIndex = 11;
			// 
			// comboBoxPlaceholder
			// 
			this.comboBoxPlaceholder.DropDownStyle = System.Windows.Forms.ComboBoxStyle.DropDownList;
			this.comboBoxPlaceholder.Enabled = false;
			this.comboBoxPlaceholder.Location = new System.Drawing.Point(176, 50);
			this.comboBoxPlaceholder.Name = "comboBoxPlaceholder";
			this.comboBoxPlaceholder.Size = new System.Drawing.Size(152, 21);
			this.comboBoxPlaceholder.TabIndex = 3;
			// 
			// checkBoxPlaceholder
			// 
			this.checkBoxPlaceholder.Location = new System.Drawing.Point(16, 46);
			this.checkBoxPlaceholder.Name = "checkBoxPlaceholder";
			this.checkBoxPlaceholder.Size = new System.Drawing.Size(160, 32);
			this.checkBoxPlaceholder.TabIndex = 2;
			this.checkBoxPlaceholder.Text = "Placeholder definition Type";
			this.checkBoxPlaceholder.CheckedChanged += new System.EventHandler(this.checkBoxPlaceholder_CheckedChanged);
			// 
			// checkBoxDateCreated
			// 
			this.checkBoxDateCreated.Location = new System.Drawing.Point(16, 120);
			this.checkBoxDateCreated.Name = "checkBoxDateCreated";
			this.checkBoxDateCreated.TabIndex = 6;
			this.checkBoxDateCreated.Text = "Created Date";
			this.checkBoxDateCreated.CheckedChanged += new System.EventHandler(this.checkBoxDateCreated_CheckedChanged);
			// 
			// checkBoxAuthor
			// 
			this.checkBoxAuthor.Location = new System.Drawing.Point(16, 88);
			this.checkBoxAuthor.Name = "checkBoxAuthor";
			this.checkBoxAuthor.Size = new System.Drawing.Size(128, 24);
			this.checkBoxAuthor.TabIndex = 4;
			this.checkBoxAuthor.Text = "Name of the Author";
			this.checkBoxAuthor.CheckedChanged += new System.EventHandler(this.checkBoxAuthor_CheckedChanged);
			// 
			// checkBoxPostingState
			// 
			this.checkBoxPostingState.Location = new System.Drawing.Point(16, 18);
			this.checkBoxPostingState.Name = "checkBoxPostingState";
			this.checkBoxPostingState.Size = new System.Drawing.Size(96, 24);
			this.checkBoxPostingState.TabIndex = 0;
			this.checkBoxPostingState.Text = "Posting State";
			this.checkBoxPostingState.CheckedChanged += new System.EventHandler(this.checkBoxPostingState_CheckedChanged);
			// 
			// dateTimePickerTo
			// 
			this.dateTimePickerTo.Enabled = false;
			this.dateTimePickerTo.Location = new System.Drawing.Point(120, 184);
			this.dateTimePickerTo.Name = "dateTimePickerTo";
			this.dateTimePickerTo.Size = new System.Drawing.Size(208, 20);
			this.dateTimePickerTo.TabIndex = 8;
			// 
			// dateTimePickerFrom
			// 
			this.dateTimePickerFrom.Enabled = false;
			this.dateTimePickerFrom.Location = new System.Drawing.Point(120, 152);
			this.dateTimePickerFrom.Name = "dateTimePickerFrom";
			this.dateTimePickerFrom.Size = new System.Drawing.Size(208, 20);
			this.dateTimePickerFrom.TabIndex = 7;
			// 
			// labelTo
			// 
			this.labelTo.Location = new System.Drawing.Point(32, 184);
			this.labelTo.Name = "labelTo";
			this.labelTo.Size = new System.Drawing.Size(32, 23);
			this.labelTo.TabIndex = 8;
			this.labelTo.Text = "To";
			// 
			// labelFrom
			// 
			this.labelFrom.Location = new System.Drawing.Point(32, 152);
			this.labelFrom.Name = "labelFrom";
			this.labelFrom.Size = new System.Drawing.Size(56, 23);
			this.labelFrom.TabIndex = 6;
			this.labelFrom.Text = "From";
			// 
			// textBoxAuthor
			// 
			this.textBoxAuthor.Enabled = false;
			this.textBoxAuthor.Location = new System.Drawing.Point(144, 88);
			this.textBoxAuthor.Name = "textBoxAuthor";
			this.textBoxAuthor.Size = new System.Drawing.Size(184, 20);
			this.textBoxAuthor.TabIndex = 5;
			this.textBoxAuthor.Text = "";
			// 
			// comboBoxPostingState
			// 
			this.comboBoxPostingState.DropDownStyle = System.Windows.Forms.ComboBoxStyle.DropDownList;
			this.comboBoxPostingState.Enabled = false;
			this.comboBoxPostingState.Location = new System.Drawing.Point(144, 18);
			this.comboBoxPostingState.Name = "comboBoxPostingState";
			this.comboBoxPostingState.Size = new System.Drawing.Size(184, 21);
			this.comboBoxPostingState.TabIndex = 1;
			// 
			// checkBoxImportant
			// 
			this.checkBoxImportant.Location = new System.Drawing.Point(16, 216);
			this.checkBoxImportant.Name = "checkBoxImportant";
			this.checkBoxImportant.Size = new System.Drawing.Size(176, 24);
			this.checkBoxImportant.TabIndex = 9;
			this.checkBoxImportant.Text = "Search for Important Postings";
			// 
			// textBoxName
			// 
			this.textBoxName.Location = new System.Drawing.Point(8, 40);
			this.textBoxName.Name = "textBoxName";
			this.textBoxName.Size = new System.Drawing.Size(176, 20);
			this.textBoxName.TabIndex = 0;
			this.textBoxName.Text = "";
			// 
			// labelPostingGuid
			// 
			this.labelPostingGuid.Location = new System.Drawing.Point(192, 16);
			this.labelPostingGuid.Name = "labelPostingGuid";
			this.labelPostingGuid.Size = new System.Drawing.Size(168, 23);
			this.labelPostingGuid.TabIndex = 10;
			this.labelPostingGuid.Text = "All or part of the Posting Guid";
			// 
			// buttonClose
			// 
			this.buttonClose.DialogResult = System.Windows.Forms.DialogResult.Cancel;
			this.buttonClose.Location = new System.Drawing.Point(608, 536);
			this.buttonClose.Name = "buttonClose";
			this.buttonClose.Size = new System.Drawing.Size(88, 23);
			this.buttonClose.TabIndex = 8;
			this.buttonClose.Text = "Cl&ose";
			this.buttonClose.Click += new System.EventHandler(this.buttonClose_Click);
			// 
			// labelPlace
			// 
			this.labelPlace.Location = new System.Drawing.Point(8, 536);
			this.labelPlace.Name = "labelPlace";
			this.labelPlace.Size = new System.Drawing.Size(440, 23);
			this.labelPlace.TabIndex = 13;
			// 
			// labelSearchType
			// 
			this.labelSearchType.Location = new System.Drawing.Point(8, 16);
			this.labelSearchType.Name = "labelSearchType";
			this.labelSearchType.Size = new System.Drawing.Size(144, 23);
			this.labelSearchType.TabIndex = 14;
			this.labelSearchType.Text = "Search Type";
			// 
			// comboBoxSearchType
			// 
			this.comboBoxSearchType.DropDownStyle = System.Windows.Forms.ComboBoxStyle.DropDownList;
			this.comboBoxSearchType.Items.AddRange(new object[] {
																	"Case-insensitive substring",
																	"Case-sensitive substring",
																	"All words (case-insensitive)",
																	"Any words (case-insensitive)",
																	"Regular expression (case-insensitive)",
																	"!(Regular expression (case-insensitive))"});
			this.comboBoxSearchType.Location = new System.Drawing.Point(112, 16);
			this.comboBoxSearchType.Name = "comboBoxSearchType";
			this.comboBoxSearchType.Size = new System.Drawing.Size(344, 21);
			this.comboBoxSearchType.TabIndex = 0;
			// 
			// labelTemplateGuid
			// 
			this.labelTemplateGuid.Location = new System.Drawing.Point(192, 16);
			this.labelTemplateGuid.Name = "labelTemplateGuid";
			this.labelTemplateGuid.Size = new System.Drawing.Size(224, 23);
			this.labelTemplateGuid.TabIndex = 15;
			this.labelTemplateGuid.Text = "All or part of the Template Guid";
			// 
			// textBoxTemplateGuid
			// 
			this.textBoxTemplateGuid.Location = new System.Drawing.Point(192, 40);
			this.textBoxTemplateGuid.Name = "textBoxTemplateGuid";
			this.textBoxTemplateGuid.Size = new System.Drawing.Size(248, 20);
			this.textBoxTemplateGuid.TabIndex = 1;
			this.textBoxTemplateGuid.Text = "";
			// 
			// labelTemplateName
			// 
			this.labelTemplateName.Location = new System.Drawing.Point(8, 16);
			this.labelTemplateName.Name = "labelTemplateName";
			this.labelTemplateName.Size = new System.Drawing.Size(176, 23);
			this.labelTemplateName.TabIndex = 17;
			this.labelTemplateName.Text = "All or part of the Template name";
			// 
			// textBoxTemplateName
			// 
			this.textBoxTemplateName.Location = new System.Drawing.Point(8, 40);
			this.textBoxTemplateName.Name = "textBoxTemplateName";
			this.textBoxTemplateName.Size = new System.Drawing.Size(176, 20);
			this.textBoxTemplateName.TabIndex = 0;
			this.textBoxTemplateName.Text = "";
			// 
			// groupBoxPosting
			// 
			this.groupBoxPosting.Controls.Add(this.labelPostingName);
			this.groupBoxPosting.Controls.Add(this.labelPostingGuid);
			this.groupBoxPosting.Controls.Add(this.textBoxName);
			this.groupBoxPosting.Controls.Add(this.textBoxGuid);
			this.groupBoxPosting.Location = new System.Drawing.Point(8, 48);
			this.groupBoxPosting.Name = "groupBoxPosting";
			this.groupBoxPosting.Size = new System.Drawing.Size(448, 72);
			this.groupBoxPosting.TabIndex = 1;
			this.groupBoxPosting.TabStop = false;
			this.groupBoxPosting.Text = "Posting";
			// 
			// groupBoxTemplate
			// 
			this.groupBoxTemplate.Controls.Add(this.labelTemplateGuid);
			this.groupBoxTemplate.Controls.Add(this.textBoxTemplateGuid);
			this.groupBoxTemplate.Controls.Add(this.labelTemplateName);
			this.groupBoxTemplate.Controls.Add(this.textBoxTemplateName);
			this.groupBoxTemplate.Location = new System.Drawing.Point(8, 136);
			this.groupBoxTemplate.Name = "groupBoxTemplate";
			this.groupBoxTemplate.Size = new System.Drawing.Size(448, 72);
			this.groupBoxTemplate.TabIndex = 2;
			this.groupBoxTemplate.TabStop = false;
			this.groupBoxTemplate.Text = "Template";
			// 
			// FormSearch
			// 
			this.AcceptButton = this.buttonSearch;
			this.AutoScaleBaseSize = new System.Drawing.Size(5, 13);
			this.CancelButton = this.buttonClose;
			this.ClientSize = new System.Drawing.Size(810, 576);
			this.Controls.Add(this.groupBoxTemplate);
			this.Controls.Add(this.groupBoxPosting);
			this.Controls.Add(this.comboBoxSearchType);
			this.Controls.Add(this.labelSearchType);
			this.Controls.Add(this.labelPlace);
			this.Controls.Add(this.buttonClose);
			this.Controls.Add(this.textBoxPlaceHolder);
			this.Controls.Add(this.groupBoxAdvanced);
			this.Controls.Add(this.labelFilesFound);
			this.Controls.Add(this.buttonSearch);
			this.Controls.Add(this.labelResults);
			this.Controls.Add(this.labelPlaceholder);
			this.Controls.Add(this.listViewPosting);
			this.FormBorderStyle = System.Windows.Forms.FormBorderStyle.FixedSingle;
			this.Icon = ((System.Drawing.Icon)(resources.GetObject("$this.Icon")));
			this.MaximizeBox = false;
			this.Name = "FormSearch";
			this.ShowInTaskbar = false;
			this.StartPosition = System.Windows.Forms.FormStartPosition.CenterScreen;
			this.Text = "Search for Postings";
			this.Load += new System.EventHandler(this.FormSearch_Load);
			this.groupBoxAdvanced.ResumeLayout(false);
			((System.ComponentModel.ISupportInitialize)(this.numericUpDownDays)).EndInit();
			this.groupBoxPosting.ResumeLayout(false);
			this.groupBoxTemplate.ResumeLayout(false);
			this.ResumeLayout(false);

		}
		#endregion

		private void buttonClose_Click(object sender, System.EventArgs e)
		{
			try
			{
				ChannelGuid = "";
				cmsApplication.Dispose();
				this.Close();
			}
			catch{}
			finally
			{
				this.Close();
			}
		}

		private void FormSearch_Load(object sender, System.EventArgs e)
		{
			Init();
			if(TemplateGuid!="")
			{
				this.textBoxTemplateGuid.Text = TemplateGuid;
				this.buttonSearch_Click(null,null);
				TemplateGuid = ""; 
			}
		}

		private void checkBoxNew_CheckedChanged(object sender, System.EventArgs e)
		{
			if(this.checkBoxNew.Checked)
			{
				this.numericUpDownDays.Enabled = true;
			}
			else
			{
				this.numericUpDownDays.Enabled = false;
			}
		}

		private void Init()
		{
			this.thumbNailImage = new FloatControl();
			this.thumbNailImage.Name = "Thumbnail";
			this.thumbNailImage.TabStop = false;
			this.thumbNailImage.Visible = false;
			this.numericUpDownDays.Enabled = false;

			//Initialize the menu items
			postingGuid = new MenuItem("Copy Guid");
			postingReleaseOwner = new MenuItem("Kill Lock");
			postingOwner = new MenuItem("Owned By");
			postingApprove = new MenuItem("Approve");
			postingDecline = new MenuItem("Decline");
			postingSubmit = new MenuItem("Submit");
			postingPublichedURL = new MenuItem("Open in Published Mode");
			postingUpdateURL = new MenuItem("Open in Update Mode");
			postingUnPublichedURL = new MenuItem("Open in Unpublished Mode");
			postingEdit = new MenuItem("Edit");
			postingProperties = new MenuItem("Edit Custom Properties");
			postingConnected = new MenuItem("Get Connected Postings");

			postingGuid.Click +=new EventHandler(postingGuid_Click);
			postingReleaseOwner.Click +=new EventHandler(postingReleaseOwner_Click);
			postingOwner.Click +=new EventHandler(postingOwner_Click);
			postingApprove.Click +=new EventHandler(postingApprove_Click);
			postingDecline.Click +=new EventHandler(postingDecline_Click);
			postingSubmit.Click+=new EventHandler(postingSubmit_Click);
			postingPublichedURL.Click +=new EventHandler(postingPublichedURL_Click);
			postingUnPublichedURL.Click +=new EventHandler(postingUnPublichedURL_Click);
			postingUpdateURL.Click +=new EventHandler(postingUpdateURL_Click);
			postingEdit.Click +=new EventHandler(postingEdit_Click);
			postingProperties.Click +=new EventHandler(postingProperties_Click);
			postingConnected.Click +=new EventHandler(postingConnected_Click);

			//to sort in list view
			lvwColumnSorter = new ListViewColumnSorter();
			this.listViewPosting.ListViewItemSorter = lvwColumnSorter;

			//creation of cms application context with appropriate user and publishing mode
			cmsApplication.AuthenticateAsUser(FormMCMSManager.userName,FormMCMSManager.password,PublishingMode.Update);

			//Set the startup search type
			comboBoxSearchType.SelectedItem = comboBoxSearchType.Items[0];
			
			//Case-insensitive substring = 0
			//Case-sensitive substring = 1
			//All words = 2
			//Any words = 3
			//Regular expression = 4
			//!(Regular expression) = 5
		}

		private void checkBoxPostingState_CheckedChanged(object sender, System.EventArgs e)
		{
			if(this.checkBoxPostingState.Checked)
			{
				//adding items to combobox, posting states
				comboBoxPostingState.Items.Add(PostingState.Published);
				comboBoxPostingState.Items.Add(PostingState.Saved);
				comboBoxPostingState.Items.Add(PostingState.WaitingForEditorApproval);
				comboBoxPostingState.Items.Add(PostingState.WaitingForModeratorApproval);
				comboBoxPostingState.Items.Add(PostingState.EditorDeclined);
				comboBoxPostingState.Items.Add(PostingState.ModeratorDeclined);
				comboBoxPostingState.Items.Add(PostingState.Expired);
				comboBoxPostingState.Items.Add(PostingState.Historical);
				this.comboBoxPostingState.Enabled = true;
				this.comboBoxPostingState.SelectedIndex = 0;
			}
			else
			{
				this.comboBoxPostingState.Items.Clear();
				this.comboBoxPostingState.Enabled = false;
			}
		}

		private void checkBoxAuthor_CheckedChanged(object sender, System.EventArgs e)
		{
			if(this.checkBoxAuthor.Checked)
			{
				this.textBoxAuthor.Enabled = true;
			}
			else
			{
				this.textBoxAuthor.Enabled = false;
			}
		}

		private void checkBoxDateCreated_CheckedChanged(object sender, System.EventArgs e)
		{
			if(this.checkBoxDateCreated.Checked)
			{
				this.dateTimePickerFrom.Enabled = true;
				this.dateTimePickerTo.Enabled = true;
			}
			else
			{
				this.dateTimePickerFrom.Enabled = false;
				this.dateTimePickerTo.Enabled = false;
			}		
		}

		private void checkBoxPlaceholder_CheckedChanged(object sender, System.EventArgs e)
		{
			if(this.checkBoxPlaceholder.Checked)
			{
				this.comboBoxPlaceholder.Items.Add("HtmlPlaceholder");
				this.comboBoxPlaceholder.Items.Add("XmlPlaceholder");
				this.comboBoxPlaceholder.Items.Add("AttachmentPlaceholder");
				this.comboBoxPlaceholder.Items.Add("ImagePlaceholder");
				this.comboBoxPlaceholder.Items.Add("OfficeHtmlPlaceholder");
				this.comboBoxPlaceholder.Items.Add("OfficeAttachmentPlaceholder");
				this.comboBoxPlaceholder.Enabled = true;
				this.comboBoxPlaceholder.SelectedIndex = 0;
			}
			else
			{
				this.comboBoxPlaceholder.Items.Clear();
				this.comboBoxPlaceholder.Enabled = false;
			}
		}

		#endregion

		#region Search

		private void buttonSearch_Click(object sender, System.EventArgs e)
		{
			if(searchButton)
			{
				this.buttonClose.Enabled = false;
				searchButton = false;
				this.buttonSearch.Text = "Stop";
				postingFound = 0;
				this.listViewPosting.Items.Clear();
				//must use delegate to invoke
				SearchPostingsDelegate search = new SearchPostingsDelegate(SearchPostings);
				if(ChannelGuid=="")
				{
					search.BeginInvoke(cmsApplication.RootChannel,null,null);
				}
				else
				{
					Channel rootChannel = (Channel)cmsApplication.Searches.GetByGuid(ChannelGuid);
					if(rootChannel!=null)
					{
						search.BeginInvoke(rootChannel,null,null);
					}
					else
					{
						search.BeginInvoke(cmsApplication.RootChannel,null,null);
					}
				}
			}
			else
			{
				searchButton = true;
				this.buttonSearch.Enabled = false;
				this.buttonSearch.Text = "Stopping...";
			}
		}

		private static bool AllWordFound(string what,string where)
		{
			bool foundWord = false;
			string[] searchString = what.ToLower().Split(' ');
			string[] postingName = where.ToLower().Split(' ');
			int found = 0;
			for(int i=0;i<searchString.Length;i++)
			{
				for(int j=0;j<postingName.Length;j++)
				{
					if(searchString[i]==postingName[j])
					{
						found++;
						break;
					}
				}
			}
			if(searchString.Length==found)
			{
				foundWord=true;
			}
			return foundWord;
		}

		private bool AnyWordFound(string what,string where)
		{
			bool foundWord = false;
			string[] searchString = what.ToLower().Split(' ');
			string[] postingName = where.ToLower().Split(' ');
			bool found = false;
			for(int i=0;i<searchString.Length;i++)
			{
				if(found)
					break;
				for(int j=0;j<postingName.Length;j++)
				{
					if(searchString[i]==postingName[j])
					{
						foundWord=true;
						found = true;
						break;
					}
				}
			}
			return foundWord;
		}

		private bool RegularFound(Regex what,string where)
		{
			bool foundWord = false;
			Match match = what.Match(where);
			if (match.Success) 
			{
				foundWord = true;
			}
			return foundWord;
		}

		private bool NonRegularFound(Regex what,string where)
		{
			bool foundWord = false;
			Match match = what.Match(where);
			if (!match.Success)
			{
				foundWord = true;
			}
			return foundWord;
		}

		private void SearchPosting(Channel channel)
		{
			int foundCount = 0;
			int needCount = 0;
			searchType = comboBoxSearchType.SelectedIndex;
			//go through all the postings and find for needed text
			foreach(Posting posting in channel.Postings)
			{
				//is search not stopped yet
				if(!searchButton)
				{
					//if the text is long then can't display
					if(posting.Parent.Path.Length>40)
					{
						this.labelPlace.Text = "Searching inside ..."+posting.Parent.Path.Substring(posting.Parent.Path.Length-37,36);
					}
					else
					{
						this.labelPlace.Text = "Searching inside "+posting.Parent.Path;
					}
					if(this.textBoxName.Text!="")
					{
						needCount++;
						switch(searchType)
						{
							case 0:
							{
								if(posting.Name.ToLower().IndexOf(this.textBoxName.Text.ToLower())!=-1)
								{
									foundCount++;
								}
								break;
							}
							case 1:
							{
								if(posting.Name.IndexOf(this.textBoxName.Text)!=-1)
								{
									foundCount++;
								}
								break;
							}
							case 2:
							{
								if(AllWordFound(this.textBoxName.Text,posting.Name))
								{
									foundCount++;
								}
								break;
							}
							case 3:
							{
								if(AnyWordFound(this.textBoxName.Text,posting.Name))
								{
									foundCount++;
								}
								break;
							}
							case 4:
							{
								try
								{
									Regex re = new Regex(this.textBoxName.Text);
									if(RegularFound(re,posting.Name))
									{
										foundCount++;
									}
								}
								catch(Exception ex)
								{
									MessageBox.Show("While trying to search using regular expression an exception was thrown. Exception is : "+ex.Message,"Error",MessageBoxButtons.OK,MessageBoxIcon.Error);
								}
								break;
							}
							case 5:
							{
								try
								{
									Regex re = new Regex(this.textBoxName.Text);
									if(NonRegularFound(re,posting.Name))
									{
										foundCount++;
									}
								}
								catch(Exception ex)
								{
									MessageBox.Show("While trying to search using regular expression an exception was thrown. Exception is : "+ex.Message,"Error",MessageBoxButtons.OK,MessageBoxIcon.Error);
								}
								break;
							}
						}
					}

					if(this.textBoxTemplateName.Text!="")
					{
						needCount++;
						switch(searchType)
						{
							case 0:
							{
								if(posting.Template.Name.ToLower().IndexOf(this.textBoxTemplateName.Text.ToLower())!=-1)
								{
									foundCount++;
								}
								break;
							}
							case 1:
							{
								if(posting.Template.Name.IndexOf(this.textBoxTemplateName.Text)!=-1)
								{
									foundCount++;
								}
								break;
							}
							case 2:
							{
								if(AllWordFound(this.textBoxTemplateName.Text,posting.Template.Name))
								{
									foundCount++;
								}
								break;
							}
							case 3:
							{
								if(AnyWordFound(this.textBoxTemplateName.Text,posting.Template.Name))
								{
									foundCount++;
								}
								break;
							}
							case 4:
							{
								try
								{
									Regex re = new Regex(this.textBoxTemplateName.Text);
									if(RegularFound(re,posting.Template.Name))
									{
										foundCount++;
									}
								}
								catch(Exception ex)
								{
									MessageBox.Show("While trying to search using regular expression an exception was thrown. Exception is : "+ex.Message,"Error",MessageBoxButtons.OK,MessageBoxIcon.Error);
								}
								break;
							}
							case 5:
							{
								try
								{
									Regex re = new Regex(this.textBoxTemplateName.Text);
									if(NonRegularFound(re,posting.Template.Name))
									{
										foundCount++;
									}
								}
								catch(Exception ex)
								{
									MessageBox.Show("While trying to search using regular expression an exception was thrown. Exception is : "+ex.Message,"Error",MessageBoxButtons.OK,MessageBoxIcon.Error);
								}
								break;
							}
						}
					}

					if(this.textBoxGuid.Text!="")
					{
						needCount++;
						switch(searchType)
						{
							case 0:
							{
								if(posting.Guid.ToLower().IndexOf(this.textBoxGuid.Text.ToLower())!=-1)
								{
									foundCount++;
								}
								break;
							}
							case 1:
							{
								if(posting.Guid.IndexOf(this.textBoxGuid.Text)!=-1)
								{
									foundCount++;
								}
								break;
							}
							case 2:
							{
								if(AllWordFound(this.textBoxGuid.Text,posting.Guid))
								{
									foundCount++;
								}
								break;
							}
							case 3:
							{
								if(AnyWordFound(this.textBoxGuid.Text,posting.Guid))
								{
									foundCount++;
								}
								break;
							}
							case 4:
							{
								try
								{
									Regex re = new Regex(this.textBoxGuid.Text);
									if(RegularFound(re,posting.Guid))
									{
										foundCount++;
									}
								}
								catch(Exception ex)
								{
									MessageBox.Show("While trying to search using regular expression an exception was thrown. Exception is : "+ex.Message,"Error",MessageBoxButtons.OK,MessageBoxIcon.Error);
								}
								break;
							}
							case 5:
							{
								try
								{
									Regex re = new Regex(this.textBoxGuid.Text);
									if(NonRegularFound(re,posting.Guid))
									{
										foundCount++;
									}
								}
								catch(Exception ex)
								{
									MessageBox.Show("While trying to search using regular expression an exception was thrown. Exception is : "+ex.Message,"Error",MessageBoxButtons.OK,MessageBoxIcon.Error);
								}
								break;
							}
						}
					}

					if(this.checkBoxImportant.Checked)
					{
						needCount++;
						PostingCollection postings = cmsApplication.Searches.ImportantPostings();
						foreach(Posting p in postings)
						{
							if(posting.Guid == p.Guid)
							{
								foundCount++;
								break;
							}
						}	
					}

					if(this.checkBoxNew.Checked)
					{
						needCount++;
						int postDays = 0;
						try
						{
							postDays = int.Parse(numericUpDownDays.Value.ToString());
						}
						catch
						{}
						PostingCollection postings = cmsApplication.Searches.NewPostings(postDays);
						foreach(Posting p in postings)
						{
							if(posting.Guid == p.Guid)
							{
								foundCount++;
								break;
							}
						}	
					}

					if(this.textBoxTemplateGuid.Text!="")
					{
						needCount++;
						switch(searchType)
						{
							case 0:
							{
								if(posting.Template.Guid.ToLower().IndexOf(this.textBoxTemplateGuid.Text.ToLower())!=-1)
								{
									foundCount++;
								}
								break;
							}
							case 1:
							{
								if(posting.Template.Guid.IndexOf(this.textBoxTemplateGuid.Text)!=-1)
								{
									foundCount++;
								}
								break;
							}
							case 2:
							{
								if(AllWordFound(this.textBoxTemplateGuid.Text,posting.Template.Guid))
								{
									foundCount++;
								}
								break;
							}
							case 3:
							{
								if(AnyWordFound(this.textBoxTemplateGuid.Text,posting.Template.Guid))
								{
									foundCount++;
								}
								break;
							}
							case 4:
							{
								try
								{
									Regex re = new Regex(this.textBoxTemplateGuid.Text);
									if(RegularFound(re,posting.Template.Guid))
									{
										foundCount++;
									}
								}
								catch(Exception ex)
								{
									MessageBox.Show("While trying to search using regular expression an exception was thrown. Exception is : "+ex.Message,"Error",MessageBoxButtons.OK,MessageBoxIcon.Error);
								}
								break;
							}
							case 5:
							{
								try
								{
									Regex re = new Regex(this.textBoxTemplateGuid.Text);
									if(NonRegularFound(re,posting.Template.Guid))
									{
										foundCount++;
									}
								}
								catch(Exception ex)
								{
									MessageBox.Show("While trying to search using regular expression an exception was thrown. Exception is : "+ex.Message,"Error",MessageBoxButtons.OK,MessageBoxIcon.Error);
								}
								break;
							}
						}
					}


					if(this.textBoxPlaceHolder.Text!="")
					{
						needCount++;
						int howMany = 0;
						int startFound = foundCount;
						//This is not the best way to get the placeholdercontent, but the only way ( for any placeholder)
						foreach(Placeholder ph in posting.Placeholders)
						{
							if(startFound>foundCount)
							{
								break;
							}
							switch(searchType)
							{
								case 0:
								{
									if(ph.Datasource.RawContent.ToLower().IndexOf(this.textBoxPlaceHolder.Text.ToLower())!=-1)
									{
										foundCount++;
									}
									break;
								}
								case 1:
								{
									if(ph.Datasource.RawContent.IndexOf(this.textBoxPlaceHolder.Text)!=-1)
									{
										foundCount++;
									}
									break;
								}
								case 2:
								{
									if(AllWordFound(this.textBoxPlaceHolder.Text,ph.Datasource.RawContent))
									{
										foundCount++;
									}
									break;
								}
								case 3:
								{
									if(AnyWordFound(this.textBoxPlaceHolder.Text,ph.Datasource.RawContent))
									{
										foundCount++;
									}
									break;
								}
								case 4:
								{
									try
									{
										Regex re = new Regex(this.textBoxPlaceHolder.Text);
										if(RegularFound(re,ph.Datasource.RawContent))
										{
											foundCount++;
										}
									}
									catch(Exception ex)
									{
										MessageBox.Show("While trying to search using regular expression an exception was thrown. Exception is : "+ex.Message,"Error",MessageBoxButtons.OK,MessageBoxIcon.Error);
									}
									break;
								}
								case 5:
								{
									try
									{
										Regex re = new Regex(this.textBoxPlaceHolder.Text);
										if(NonRegularFound(re,ph.Datasource.RawContent))
										{
											howMany++;
										}
										if(howMany==posting.Placeholders.Count)
										{
											foundCount++;
										}
									}
									catch(Exception ex)
									{
										MessageBox.Show("While trying to search using regular expression an exception was thrown. Exception is : "+ex.Message,"Error",MessageBoxButtons.OK,MessageBoxIcon.Error);
									}
									break;
								}
							}
						}
					}

					if(this.checkBoxPostingState.Checked)
					{
						needCount++;
						if(posting.State==(PostingState)comboBoxPostingState.SelectedItem)
						{
							foundCount++;
						}
					}

					if(this.checkBoxAuthor.Checked)
					{
						needCount++;
						string clientName = posting.CreatedBy.ClientAccountName;
						if(clientName.IndexOf("/")!=-1)
						{
							clientName = posting.CreatedBy.ClientAccountName.Split('/')[clientName.Split('/').Length-1];
						}
						switch(searchType)
						{
							case 0:
							{
								if(clientName.ToLower().IndexOf(this.textBoxAuthor.Text.ToLower())!=-1)
								{
									foundCount++;
								}
								break;
							}
							case 1:
							{
								if(clientName.IndexOf(this.textBoxAuthor.Text)!=-1)
								{
									foundCount++;
								}
								break;
							}
							case 2:
							{
								if(AllWordFound(this.textBoxAuthor.Text,clientName))
								{
									foundCount++;
								}
								break;
							}
							case 3:
							{
								if(AnyWordFound(this.textBoxAuthor.Text,clientName))
								{
									foundCount++;
								}
								break;
							}
							case 4:
							{
								try
								{
									Regex re = new Regex(this.textBoxAuthor.Text);
									if(RegularFound(re,clientName))
									{
										foundCount++;
									}
								}
								catch(Exception ex)
								{
									MessageBox.Show("While trying to search using regular expression an exception was thrown. Exception is : "+ex.Message,"Error",MessageBoxButtons.OK,MessageBoxIcon.Error);
								}
								break;
							}
							case 5:
							{
								try
								{
									Regex re = new Regex(this.textBoxAuthor.Text);
									if(NonRegularFound(re,clientName))
									{
										foundCount++;
									}
								}
								catch(Exception ex)
								{
									MessageBox.Show("While trying to search using regular expression an exception was thrown. Exception is : "+ex.Message,"Error",MessageBoxButtons.OK,MessageBoxIcon.Error);
								}
								break;
							}
						}
						
					}

					if(this.checkBoxDateCreated.Checked)
					{
						needCount++;
						if(posting.CreatedDate>=dateTimePickerFrom.Value && posting.CreatedDate <= dateTimePickerTo.Value)
						{
							foundCount++;
						}
					}

					if(this.checkBoxPlaceholder.Checked)
					{
						needCount++;
						foreach(Placeholder ph in posting.Placeholders)
						{
							if(ph is ImagePlaceholder)
							{
								if(comboBoxPlaceholder.SelectedItem.ToString()=="ImagePlaceholder")
								{
									foundCount++;
									break;
								}
							}
							if(ph is AttachmentPlaceholder)
							{
								if(comboBoxPlaceholder.SelectedItem.ToString()=="AttachmentPlaceholder")
								{
									foundCount++;
									break;
								}
							}
							if(ph is HtmlPlaceholder)
							{
								if(comboBoxPlaceholder.SelectedItem.ToString()=="HtmlPlaceholder")
								{
									foundCount++;
									break;
								}
							}
							if(ph is XmlPlaceholder)
							{
								if(comboBoxPlaceholder.SelectedItem.ToString()=="XmlPlaceholder")
								{
									foundCount++;
									break;
								}
							}
							if(ph is OfficeAttachmentPlaceholder)
							{
								if(comboBoxPlaceholder.SelectedItem.ToString()=="OfficeAttachmentPlaceholder")
								{
									foundCount++;
									break;
								}
							}
							if(ph is OfficeHtmlPlaceholder)
							{
								if(comboBoxPlaceholder.SelectedItem.ToString()=="OfficeHtmlPlaceholder")
								{
									foundCount++;
									break;
								}
							}
						}
					}

					if(foundCount==needCount)
					{
						//result found
						postingFound++;
						string clientName = posting.CreatedBy.ClientAccountName;
						ListViewItem currentItem = null;
						if(clientName.IndexOf("/")==-1)
						{
							currentItem = new ListViewItem(new string[]{posting.Name,posting.Parent.Path,posting.Guid,posting.State.ToString(),clientName,posting.CreatedDate.ToString()},posting.ConnectedPostings.Count>0?1:0);
						}
						else
						{
							currentItem = new ListViewItem(new string[]{posting.Name,posting.Parent.Path,posting.Guid,posting.State.ToString(),clientName.Split('/')[clientName.Split('/').Length-1],posting.CreatedDate.ToString()},posting.ConnectedPostings.Count>0?1:0);
						}
						currentItem.Tag = posting;
						listViewPosting.Items.Add(currentItem);
						ThumbnailPosting(posting);
					}
					this.labelFilesFound.Text = postingFound.ToString() + " posting(s) found";
					foundCount = 0;
					needCount = 0;				
				}
				else
				{
					//stoped clicked. so stop.
					searchButton = true;
					this.buttonSearch.Text = "Search";
					this.labelPlace.Text = "Canceled";
					this.buttonClose.Enabled = true;
					this.buttonSearch.Enabled = true;
					return;
				}
			}
			//go through all the channels
			for(int i=0;i<channel.Channels.Count;i++)
			{
				if(channel.Channels!=null)
				{
					SearchPosting(channel.Channels[i]);
				}
			}

		}

		//This method is used to call with delegate 
		private void SearchPostings(Channel channel)
		{
			//call the actuall method to do the search
			SearchPosting(channel);
			searchButton = true;
			this.buttonSearch.Text = "Search";
			this.buttonClose.Enabled = true;
			this.labelPlace.Text = "Finished";
		}

		#endregion

		#region Sorting
		private void listViewPosting_ColumnClick(object sender, System.Windows.Forms.ColumnClickEventArgs e)
		{
			if (e.Column == lvwColumnSorter.SortColumn)
			{
				// Reverse the current sort direction for this column.
				if (lvwColumnSorter.Order == SortOrder.Ascending)
				{
					lvwColumnSorter.Order = SortOrder.Descending;
				}
				else
				{
					lvwColumnSorter.Order = SortOrder.Ascending;
				}
			}
			else
			{
				// Set the column number that is to be sorted; default to ascending.
				lvwColumnSorter.SortColumn = e.Column;
				lvwColumnSorter.Order = SortOrder.Ascending;
			}

			// Perform the sort with these new sort options.
			this.listViewPosting.Sort();
		}
		#endregion

		#region Adding menu items to Context Menu
		private void listViewPosting_MouseDown(object sender, System.Windows.Forms.MouseEventArgs e)
		{
			contextMenu.MenuItems.Clear();
			selectedItem = null;
			//Is the click is right mouse click
			if(e.Button == MouseButtons.Right)
			{
				//Get the item which is selected
				selectedItem = listViewPosting.GetItemAt(e.X,e.Y);
				if(selectedItem!=null)
				{
					//Get the posting in the current context
					Posting posting = (Posting)selectedItem.Tag;
					//Is locked by any user
					contextMenu.MenuItems.Add(postingOwner);
					if(!posting.OwnedBy.IsEverybody)
					{
						contextMenu.MenuItems.Add(postingReleaseOwner);
					}
					contextMenu.MenuItems.Add("-");
					//If can edit the posting must be able to edit
					contextMenu.MenuItems.Add(postingEdit);
					//contextMenuPosting.MenuItems.Add(postingEditDB);
					//Can the current user edit custom properties/do the posting has properties
					if(posting.CanSetProperties && posting.CustomProperties.Count>0)
					{
						contextMenu.MenuItems.Add(postingProperties);
					}
					contextMenu.MenuItems.Add("-");
					//Can this posting approved
					if(posting.CanApprove)
					{
						//Can submitted
						if(posting.CanSubmit)
						{
							contextMenu.MenuItems.Add(postingSubmit);
						}
						contextMenu.MenuItems.Add(postingApprove);
						//This is to check decline
						if(posting.State != PostingState.Saved && posting.State != PostingState.Published)
						{
							contextMenu.MenuItems.Add(postingDecline);
						}
						contextMenu.MenuItems.Add("-");
					}
					else
					{
						if(posting.State != PostingState.Saved)
						{
							if(posting.State!= PostingState.Published)
							{
								contextMenu.MenuItems.Add(postingDecline);
								contextMenu.MenuItems.Add("-");
							}
						}
						else if(posting.CanSubmit)
						{
							contextMenu.MenuItems.Add(postingSubmit);
							contextMenu.MenuItems.Add("-");
						}
					}
					//General items in context menu
					contextMenu.MenuItems.Add(postingGuid);
					contextMenu.MenuItems.Add("-");
					contextMenu.MenuItems.Add(postingPublichedURL);
					contextMenu.MenuItems.Add(postingUnPublichedURL);
					contextMenu.MenuItems.Add(postingUpdateURL);
					if(posting.ConnectedPostings.Count>0)
					{
						contextMenu.MenuItems.Add("-");
						contextMenu.MenuItems.Add(postingConnected);
					}
				}
			}			
		}

		#endregion

		#region Posting

		private void postingConnected_Click(object sender, EventArgs e)
		{
			Posting posting = (Posting)selectedItem.Tag;
			if(posting!=null)
			{
				try
				{
					FormConnectedSearch connectedSearch = new FormConnectedSearch();
					connectedSearch.Text+=", Posting Name : " + posting.Name;
					FormConnectedSearch.ConnectedPostingGuid = posting.Guid;
					connectedSearch.ShowDialog();
				}
				catch(Exception ex)
				{

					MessageBox.Show("While trying to get the connected posting an was thrown. The message was : "+ex.Message,"Error",MessageBoxButtons.OK,MessageBoxIcon.Error);
				}
			}
			else
			{
				MessageBox.Show("Selected posting not found","Error",MessageBoxButtons.OK,MessageBoxIcon.Error);
			}
		}

		private void postingGuid_Click(object sender, EventArgs e)
		{
			Posting posting = (Posting)selectedItem.Tag;
			
			if(posting!=null)
			{
				try
				{
					//Copy the guid to the clipboard
					Clipboard.SetDataObject(posting.Guid,true);
					MessageBox.Show("Posting Guid is copied to the clipboard.","Guid Copied");
				}
				catch(Exception ex)
				{

					MessageBox.Show("While trying to copy the Guid to clipboard an was thrown. The message was : "+ex.Message,"Error",MessageBoxButtons.OK,MessageBoxIcon.Error);
				}
			}
			else
			{
				MessageBox.Show("Selected posting not found","Error",MessageBoxButtons.OK,MessageBoxIcon.Error);
			}
		}
			
		private void postingOwner_Click(object sender, EventArgs e)
		{
			Posting posting = (Posting)selectedItem.Tag;
			if(posting!=null)
			{
				//Get the owner of the selected posting
				if(posting.OwnedBy.ClientAccountName.IndexOf("/")==-1)
				{
					MessageBox.Show("This posting is owned by : "+posting.OwnedBy.ClientAccountName,"Owner");
				}
				else
				{
					MessageBox.Show("This posting is owned by : "+posting.OwnedBy.ClientAccountName.Split('/')[posting.CreatedBy.ClientAccountName.Split('/').Length-1],"Owner");
				}
			}
			else
			{
				MessageBox.Show("Selected posting not found","Error",MessageBoxButtons.OK,MessageBoxIcon.Error);
			}
		}

		private void postingReleaseOwner_Click(object sender, EventArgs e)
		{
			Posting posting = (Posting)selectedItem.Tag;
			if(posting!=null)
			{
				DialogResult result = MessageBox.Show("This will try to release the ownership on "+posting.Name+". If the state of the posting is not saved, because of a bug in MCMS 2002 it will change the state to saved.","Warning!",MessageBoxButtons.OKCancel);
				if(result == DialogResult.OK)
				{
					try
					{
						//Release the ownership on the given posting
						posting.ReleaseOwnership(true);
						cmsApplication.CommitAll();
						//Reload the list view
						listViewPosting.SelectedItems[0].Remove();
						string clientName = posting.CreatedBy.ClientAccountName;
						ListViewItem currentItem = null;
						if(clientName.IndexOf("/")==-1)
						{
							currentItem = new ListViewItem(new string[]{posting.Name,posting.Parent.Path,posting.Guid,posting.State.ToString(),clientName,posting.CreatedDate.ToString()},posting.ConnectedPostings.Count>0?1:0);
						}
						else
						{
							currentItem = new ListViewItem(new string[]{posting.Name,posting.Parent.Path,posting.Guid,posting.State.ToString(),clientName.Split('/')[clientName.Split('/').Length-1],posting.CreatedDate.ToString()},posting.ConnectedPostings.Count>0?1:0);
						}
						currentItem.Tag = posting;
						listViewPosting.Items.Add(currentItem);
					}
					catch(Exception ex)
					{
						MessageBox.Show("While trying to release the ownership an exception was thrown. The message was : "+ex.Message,"Error",MessageBoxButtons.OK,MessageBoxIcon.Error);
					}
				}
			}
			else
			{
				MessageBox.Show("Selected posting not found","Error",MessageBoxButtons.OK,MessageBoxIcon.Error);
			}
		}

		private void postingState_Click(object sender, EventArgs e)
		{
			Posting posting = (Posting)selectedItem.Tag;
			if(posting!=null)
			{
				//Get the state of the posting
				MessageBox.Show("State of the Posting : "+posting.State.ToString(),"Posting State");
			}
			else
			{
				MessageBox.Show("Selected posting not found","Error",MessageBoxButtons.OK,MessageBoxIcon.Error);
			}
		}

		private void postingApprove_Click(object sender, EventArgs e)
		{
			Posting posting = (Posting)selectedItem.Tag;
			if(posting!=null)
			{
				DialogResult result = MessageBox.Show("This will change the state of the posting to the next approved level according to the rights the channel has and this user has. Do you want to proceed?","Warning!",MessageBoxButtons.OKCancel);
				if(result == DialogResult.OK)
				{
					try
					{
						//Approve the posting
						posting.Approve();
						//Commit it
						cmsApplication.CommitAll();
						//Reload the list view
						listViewPosting.SelectedItems[0].Remove();
						string clientName = posting.CreatedBy.ClientAccountName;
						ListViewItem currentItem = null;
						if(clientName.IndexOf("/")==-1)
						{
							currentItem = new ListViewItem(new string[]{posting.Name,posting.Parent.Path,posting.Guid,posting.State.ToString(),clientName,posting.CreatedDate.ToString()},posting.ConnectedPostings.Count>0?1:0);
						}
						else
						{
							currentItem = new ListViewItem(new string[]{posting.Name,posting.Parent.Path,posting.Guid,posting.State.ToString(),clientName.Split('/')[clientName.Split('/').Length-1],posting.CreatedDate.ToString()},posting.ConnectedPostings.Count>0?1:0);
						}
						currentItem.Tag = posting;
						listViewPosting.Items.Add(currentItem);
					}
					catch(Exception ex)
					{
						MessageBox.Show("While trying to approve the posting an exception was thrown. The message was : "+ex.Message,"Error",MessageBoxButtons.OK,MessageBoxIcon.Error);
					}
				}			
			}
			else
			{
				MessageBox.Show("Selected posting not found","Error",MessageBoxButtons.OK,MessageBoxIcon.Error);
			}
		}

		private void postingDecline_Click(object sender, EventArgs e)
		{
			Posting posting = (Posting)selectedItem.Tag;
			if(posting!=null)
			{
				DialogResult result = MessageBox.Show("This will change the state of the posting as declined. Do you want to proceed?","Warning!",MessageBoxButtons.OKCancel);
				if(result == DialogResult.OK)
				{
					try
					{
						//Decline the positng
						posting.Decline();
						cmsApplication.CommitAll();
						//Reset list view
						listViewPosting.SelectedItems[0].Remove();
						string clientName = posting.CreatedBy.ClientAccountName;
						ListViewItem currentItem = null;
						if(clientName.IndexOf("/")==-1)
						{
							currentItem = new ListViewItem(new string[]{posting.Name,posting.Parent.Path,posting.Guid,posting.State.ToString(),clientName,posting.CreatedDate.ToString()},posting.ConnectedPostings.Count>0?1:0);
						}
						else
						{
							currentItem = new ListViewItem(new string[]{posting.Name,posting.Parent.Path,posting.Guid,posting.State.ToString(),clientName.Split('/')[clientName.Split('/').Length-1],posting.CreatedDate.ToString()},posting.ConnectedPostings.Count>0?1:0);
						}
						currentItem.Tag = posting;
						listViewPosting.Items.Add(currentItem);
					}
					catch(Exception ex)
					{
						MessageBox.Show("While trying to decline the posting an exception was thrown. The message was : "+ex.Message,"Error",MessageBoxButtons.OK,MessageBoxIcon.Error);
					}
				}			
			}
			else
			{
				MessageBox.Show("Selected posting not found","Error",MessageBoxButtons.OK,MessageBoxIcon.Error);
			}
		}

		private void postingSubmit_Click(object sender, EventArgs e)
		{
			Posting posting = (Posting)selectedItem.Tag;
			if(posting!=null)
			{
				DialogResult result = MessageBox.Show("This will try to submit the current posting. Do you want to proceed?","Warning!",MessageBoxButtons.OKCancel);
				if(result == DialogResult.OK)
				{
					try
					{
						//Submit the posting
						posting.Submit();
						cmsApplication.CommitAll();
						//Reset list view
						listViewPosting.SelectedItems[0].Remove();
						string clientName = posting.CreatedBy.ClientAccountName;
						ListViewItem currentItem = null;
						if(clientName.IndexOf("/")==-1)
						{
							currentItem = new ListViewItem(new string[]{posting.Name,posting.Parent.Path,posting.Guid,posting.State.ToString(),clientName,posting.CreatedDate.ToString()},posting.ConnectedPostings.Count>0?1:0);
						}
						else
						{
							currentItem = new ListViewItem(new string[]{posting.Name,posting.Parent.Path,posting.Guid,posting.State.ToString(),clientName.Split('/')[clientName.Split('/').Length-1],posting.CreatedDate.ToString()},posting.ConnectedPostings.Count>0?1:0);
						}
						currentItem.Tag = posting;
						listViewPosting.Items.Add(currentItem);
						
					}
					catch(Exception ex)
					{
						MessageBox.Show("While trying to submit the posting an exception was thrown. The message was : "+ex.Message,"Error",MessageBoxButtons.OK,MessageBoxIcon.Error);
					}
				}			
			}
			else
			{
				MessageBox.Show("Selected posting not found","Error",MessageBoxButtons.OK,MessageBoxIcon.Error);
			}
		}
		
		//Open the posting in a browser
		private void postingPublichedURL_Click(object sender, EventArgs e)
		{
			Posting posting = (Posting)selectedItem.Tag;
			if(posting!=null)
			{
				try
				{
					if(posting.UrlModePublished.ToLower().StartsWith("http://"))
					{
						System.Diagnostics.Process.Start(posting.UrlModePublished);//,"iexplorer.exe");
					}
					else
					{
						System.Diagnostics.Process.Start(FormMCMSManager.serverName + posting.UrlModePublished);//,"iexplorer.exe");
					}
				}
				catch(Exception ex)
				{
					MessageBox.Show("While trying to open posting an exception was thrown. The message was : "+ex.Message,"Error",MessageBoxButtons.OK,MessageBoxIcon.Error);
				}
			}
			else
			{
				MessageBox.Show("Selected posting not found","Error",MessageBoxButtons.OK,MessageBoxIcon.Error);
			}
		}

		private void postingUnPublichedURL_Click(object sender, EventArgs e)
		{
			Posting posting = (Posting)selectedItem.Tag;
			if(posting!=null)
			{
				try
				{
					System.Diagnostics.Process.Start(FormMCMSManager.serverName + posting.UrlModeUnpublished + "&WBCMODE=PresentationUnpublished&wbc_purpose=Basic");//,"iexplorer.exe");
				}
				catch(Exception ex)
				{
					MessageBox.Show("While trying to open posting an exception was thrown. The message was : "+ex.Message,"Error",MessageBoxButtons.OK,MessageBoxIcon.Error);
				}
			}
			else
			{
				MessageBox.Show("Selected posting not found","Error",MessageBoxButtons.OK,MessageBoxIcon.Error);
			}
		}

		private void postingUpdateURL_Click(object sender, EventArgs e)
		{
			Posting posting = (Posting)selectedItem.Tag;
			if(posting!=null)
			{
				try
				{
					System.Diagnostics.Process.Start(FormMCMSManager.serverName + posting.UrlModeUpdate + "&WBCMODE=PresentationUnpublished");//,"iexplorer.exe");
				}
				catch(Exception ex)
				{
					MessageBox.Show("While trying to open posting an exception was thrown. The message was : "+ex.Message);
				}
			}
			else
			{
				MessageBox.Show("Selected posting not found","Error",MessageBoxButtons.OK,MessageBoxIcon.Error);
			}
		}

		private void listViewPostings_DoubleClick(object sender, System.EventArgs e)
		{
			Posting posting = (Posting)listViewPosting.SelectedItems[0].Tag;
			if(posting!=null)
			{
				try
				{
					System.Diagnostics.Process.Start(FormMCMSManager.serverName + posting.Url);//,"iexplorer.exe");
				}
				catch(Exception ex)
				{
					MessageBox.Show("While trying to open posting an exception was thrown. The message was : "+ex.Message,"Error",MessageBoxButtons.OK,MessageBoxIcon.Error);
				}
			}
		
			else
			{
				MessageBox.Show("Selected posting not found","Error",MessageBoxButtons.OK,MessageBoxIcon.Error);
			}
		}

		private void postingEdit_Click(object sender, EventArgs e)
		{
			Posting posting = (Posting)selectedItem.Tag;
			if(posting!=null)
			{
				bool edit = false;
				if(posting.State==PostingState.Saved)
				{
					edit = true;
				}
				else
				{
					DialogResult result = MessageBox.Show("State of the selected posting '"+posting.Name +"' is "+posting.State+". If you edit the content, then it must go through the workflow. Do you want to continue?","Posting State in not Saved",MessageBoxButtons.YesNo,MessageBoxIcon.Question);
					if(result == DialogResult.Yes)
					{
						edit = true;
					}
				}
				if(edit)
				{
					//Whehter the selected posting has data or not
					if(posting.Placeholders!=null && posting.Placeholders.Count>0)
					{
						FormMCMSManager.currentPosting = posting;
						FormEdit editForm = new FormEdit();
						editForm.ShowDialog();
						//Reload the list view
						listViewPosting.SelectedItems[0].Remove();
						string clientName = posting.CreatedBy.ClientAccountName;
						ListViewItem currentItem = null;
						if(clientName.IndexOf("/")==-1)
						{
							currentItem = new ListViewItem(new string[]{posting.Name,posting.Parent.Path,posting.Guid,posting.State.ToString(),clientName,posting.CreatedDate.ToString()},posting.ConnectedPostings.Count>0?1:0);
						}
						else
						{
							currentItem = new ListViewItem(new string[]{posting.Name,posting.Parent.Path,posting.Guid,posting.State.ToString(),clientName.Split('/')[clientName.Split('/').Length-1],posting.CreatedDate.ToString()},posting.ConnectedPostings.Count>0?1:0);
						}
						currentItem.Tag = posting;
						listViewPosting.Items.Add(currentItem);
					}
					else
					{
						MessageBox.Show("Selected posting '"+posting.Name +"' doesn't have any data which can be editted","No data",MessageBoxButtons.OK,MessageBoxIcon.Information);
					}
				}
			}
		}

		private void postingProperties_Click(object sender, EventArgs e)
		{
			Posting posting = (Posting)selectedItem.Tag;
			if(posting!=null)
			{
				if(posting!=null)
				{
					bool edit = false;
					if(posting.State==PostingState.Saved)
					{
						edit = true;
					}
					else
					{
						DialogResult result = MessageBox.Show("State of the selected posting '"+posting.Name +"' is "+posting.State+". If you edit properties, then it must go through the workflow. Do you want to continue?","Posting State in not Saved",MessageBoxButtons.YesNo,MessageBoxIcon.Question);
						if(result == DialogResult.Yes)
						{
							edit = true;
						}
					}
					if(edit)
					{
						FormMCMSManager.currentPosting = posting;
						FormProperties editForm = new FormProperties();
						editForm.ShowDialog();
						//Reload the list view
						listViewPosting.SelectedItems[0].Remove();
						string clientName = posting.CreatedBy.ClientAccountName;
						ListViewItem currentItem = null;
						if(clientName.IndexOf("/")==-1)
						{
							currentItem = new ListViewItem(new string[]{posting.Name,posting.Parent.Path,posting.Guid,posting.State.ToString(),clientName,posting.CreatedDate.ToString()},posting.ConnectedPostings.Count>0?1:0);
						}
						else
						{
							currentItem = new ListViewItem(new string[]{posting.Name,posting.Parent.Path,posting.Guid,posting.State.ToString(),clientName.Split('/')[clientName.Split('/').Length-1],posting.CreatedDate.ToString()},posting.ConnectedPostings.Count>0?1:0);
						}
						currentItem.Tag = posting;
						listViewPosting.Items.Add(currentItem);

					}		
				}
			}
		}

		private void listViewPosting_DoubleClick(object sender, System.EventArgs e)
		{
			Posting posting = (Posting)listViewPosting.SelectedItems[0].Tag;
			if(posting!=null)
			{
				try
				{
					System.Diagnostics.Process.Start(FormMCMSManager.serverName + posting.Url);//,"iexplorer.exe");
				}
				catch(Exception ex)
				{
					MessageBox.Show("While trying to open posting an exception was thrown. The message was : "+ex.Message,"Error",MessageBoxButtons.OK,MessageBoxIcon.Error);
				}
			}
		
			else
			{
				MessageBox.Show("Selected posting not found","Error",MessageBoxButtons.OK,MessageBoxIcon.Error);
			}
		}
		#endregion

		#region ThumpNail

		private void ThumbnailPosting(Posting p)
		{
			try
			{
				if(FormMCMSManager.showPreview)
				{
					string postingUrls="";
					if(p.UrlModePublished.ToLower().StartsWith("http://"))
					{
						postingUrls = p.UrlModePublished+"|"+FormMCMSManager.thumbnailPath+"\\"+p.Guid+".jpg"+"|"+FormMCMSManager.resolutionWidth+"|"+FormMCMSManager.resolutionHeight+"|"+FormMCMSManager.thumbnailWidth+"|"+FormMCMSManager.thumbnailHeight;
					}
					else
					{
						postingUrls = FormMCMSManager.serverName+p.UrlModePublished+"|"+FormMCMSManager.thumbnailPath+"\\"+p.Guid+".jpg"+"|"+FormMCMSManager.resolutionWidth+"|"+FormMCMSManager.resolutionHeight+"|"+FormMCMSManager.thumbnailWidth+"|"+FormMCMSManager.thumbnailHeight;
					}
					if(postingUrls!="")
					{
						Process process = Process.Start(Application.StartupPath+"//HtmlThumbnail.exe"/*"c:\\*/,postingUrls);
						process.WaitForExit();						
					}
				}
			}
			catch{}
		}

		private void listViewPosting_MouseMove(object sender, System.Windows.Forms.MouseEventArgs e)
		{
			OnListBoxMouseMove();
		}

		private void listViewPosting_MouseLeave(object sender, System.EventArgs e)
		{
			OnListBoxMouseCancel();
		}

		private void OnListBoxMouseCancel()
		{
			if (thumbNailImage.Visible)
			{
				thumbNailImage.Hide();
				lastListItemOver = null;
			}
		}

		private void OnListBoxMouseMove()
		{
			ListViewItem itemOver = null;

			Point pt = GetItemLocation(ref itemOver);
			Point thumbPoint = new Point(0,0);
			if(FormMCMSManager.desktopSize.Height<pt.Y+20+FormMCMSManager.thumbnailHeight)
			{
				thumbPoint = new Point(pt.X+11,FormMCMSManager.desktopSize.Height-FormMCMSManager.thumbnailHeight);
			}
			else
			{
				thumbPoint = new Point(pt.X+11,pt.Y+20);
			}
			
			thumbNailImage.Location = thumbPoint;
			if (itemOver != lastListItemOver)
			{
				if (itemOver != null)
				{
					thumbNailImage.Location = thumbPoint;
					if(FormMCMSManager.showPreview)
					{
						Posting posting = (Posting)itemOver.Tag;
						if(File.Exists(FormMCMSManager.thumbnailPath+"\\"+posting.Guid+".jpg"))
						{
							try
							{
								this.thumbNailImage.BackgroundImage = Bitmap.FromFile(FormMCMSManager.thumbnailPath+"\\"+posting.Guid+".jpg");
								this.thumbNailImage.Size = this.thumbNailImage.BackgroundImage.Size;
								thumbNailImage.ShowFloating();
							}
							catch(OutOfMemoryException ex)
							{
								MessageBox.Show("While showing the thumbnail an exception was thrown. Check space for the temp thumbnail drive. Exception : " + ex.ToString(),"Error",MessageBoxButtons.OK,MessageBoxIcon.Error);
							}
							catch{}
						}
						else
						{
							thumbNailImage.Hide();
						}
					}
				}
				else
				{
					OnListBoxMouseCancel();
				}
			}			
			lastListItemOver = itemOver;

		}

		private Point GetItemLocation(ref ListViewItem itemOver)
		{
			itemOver = null;
			Point cursorPosition = Cursor.Position;
			Point location = new Point(0,0);			
			// Convert cursor position to ListBox coordinates:
			cursorPosition = listViewPosting.PointToClient(cursorPosition);
			itemOver = listViewPosting.GetItemAt(cursorPosition.X,cursorPosition.Y);
			return listViewPosting.PointToScreen(cursorPosition);
		}


		#endregion

	}
}
