/**
 * @file FormSettings.cs
 *
 * MCMS Manager
 *
 * MCMS Manager is the legal property of its developer
 * Chester Ragel <chesterr@gmail.com> - Developer and Maintainer
 * Yahoo ID : chesterr1979 
 * MSN : chesterr79@hotmail.com
 *
 * If you want more information, found any bugs or have any doubts you 
 * can mail me or contact me through my yahoo id.
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2.1 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#region NameSpace
using System;
using System.Drawing;
using System.Collections;
using System.ComponentModel;
using System.Windows.Forms;
using System.Configuration;
//Application block
using Microsoft.Practices.EnterpriseLibrary.Configuration;
#endregion

namespace MCMS
{
	/// <summary>
	/// Common settings goes here. Mostly related with thumbnail.
	/// </summary>
	public class FormSettings : System.Windows.Forms.Form
	{

		#region Private Controls
		private System.Windows.Forms.GroupBox groupBoxPreview;
		private System.Windows.Forms.Button buttonOk;
		private System.Windows.Forms.Button buttonCancel;
		private System.Windows.Forms.CheckBox checkBoxPreview;
		private System.Windows.Forms.Button buttonBrowse;
		private System.Windows.Forms.Label labelTempPath;
		private System.Windows.Forms.TextBox textBoxTempPath;
		private System.Windows.Forms.GroupBox groupBoxServer;
		private System.Windows.Forms.Label labelServerName;
		private System.Windows.Forms.TextBox textBoxServerName;
		private System.Windows.Forms.NumericUpDown numericUpDownHeightT;
		private System.Windows.Forms.NumericUpDown numericUpDownWidthT;
		private System.Windows.Forms.Label labelHeightT;
		private System.Windows.Forms.Label labelWidthT;
		private System.Windows.Forms.FolderBrowserDialog folderBrowserDialog;
		private System.Windows.Forms.GroupBox groupBoxThumbnail;
		private System.Windows.Forms.GroupBox groupBoxResolution;
		private System.Windows.Forms.Label labelWidthR;
		private System.Windows.Forms.Label labelHeightR;
		private System.Windows.Forms.NumericUpDown numericUpDownWidthR;
		private System.Windows.Forms.NumericUpDown numericUpDownHeightR;
		private System.Windows.Forms.CheckBox checkBoxShowResiurce;
		private System.Windows.Forms.CheckBox checkBoxShowTemplate;

		/// <summary>
		/// Required designer variable.
		/// </summary>
		private System.ComponentModel.Container components = null;
		#endregion

		#region Private varibales
		private MCMSManagerConfig mcmsConfig;
		#endregion

		#region Init/Dispose
		public FormSettings()
		{
			InitializeComponent();
		}

		/// <summary>
		/// Clean up any resources being used.
		/// </summary>
		protected override void Dispose( bool disposing )
		{
			if( disposing )
			{
				if(components != null)
				{
					components.Dispose();
				}
			}
			base.Dispose( disposing );
		}

		#region Windows Form Designer generated code
		/// <summary>
		/// Required method for Designer support - do not modify
		/// the contents of this method with the code editor.
		/// </summary>
		private void InitializeComponent()
		{
			System.Resources.ResourceManager resources = new System.Resources.ResourceManager(typeof(FormSettings));
			this.groupBoxPreview = new System.Windows.Forms.GroupBox();
			this.checkBoxShowTemplate = new System.Windows.Forms.CheckBox();
			this.checkBoxShowResiurce = new System.Windows.Forms.CheckBox();
			this.groupBoxResolution = new System.Windows.Forms.GroupBox();
			this.numericUpDownHeightR = new System.Windows.Forms.NumericUpDown();
			this.numericUpDownWidthR = new System.Windows.Forms.NumericUpDown();
			this.labelHeightR = new System.Windows.Forms.Label();
			this.labelWidthR = new System.Windows.Forms.Label();
			this.groupBoxThumbnail = new System.Windows.Forms.GroupBox();
			this.labelHeightT = new System.Windows.Forms.Label();
			this.labelWidthT = new System.Windows.Forms.Label();
			this.numericUpDownHeightT = new System.Windows.Forms.NumericUpDown();
			this.numericUpDownWidthT = new System.Windows.Forms.NumericUpDown();
			this.buttonBrowse = new System.Windows.Forms.Button();
			this.textBoxTempPath = new System.Windows.Forms.TextBox();
			this.labelTempPath = new System.Windows.Forms.Label();
			this.checkBoxPreview = new System.Windows.Forms.CheckBox();
			this.buttonOk = new System.Windows.Forms.Button();
			this.buttonCancel = new System.Windows.Forms.Button();
			this.folderBrowserDialog = new System.Windows.Forms.FolderBrowserDialog();
			this.groupBoxServer = new System.Windows.Forms.GroupBox();
			this.textBoxServerName = new System.Windows.Forms.TextBox();
			this.labelServerName = new System.Windows.Forms.Label();
			this.groupBoxPreview.SuspendLayout();
			this.groupBoxResolution.SuspendLayout();
			((System.ComponentModel.ISupportInitialize)(this.numericUpDownHeightR)).BeginInit();
			((System.ComponentModel.ISupportInitialize)(this.numericUpDownWidthR)).BeginInit();
			this.groupBoxThumbnail.SuspendLayout();
			((System.ComponentModel.ISupportInitialize)(this.numericUpDownHeightT)).BeginInit();
			((System.ComponentModel.ISupportInitialize)(this.numericUpDownWidthT)).BeginInit();
			this.groupBoxServer.SuspendLayout();
			this.SuspendLayout();
			// 
			// groupBoxPreview
			// 
			this.groupBoxPreview.Controls.Add(this.checkBoxShowTemplate);
			this.groupBoxPreview.Controls.Add(this.checkBoxShowResiurce);
			this.groupBoxPreview.Controls.Add(this.groupBoxResolution);
			this.groupBoxPreview.Controls.Add(this.groupBoxThumbnail);
			this.groupBoxPreview.Controls.Add(this.buttonBrowse);
			this.groupBoxPreview.Controls.Add(this.textBoxTempPath);
			this.groupBoxPreview.Controls.Add(this.labelTempPath);
			this.groupBoxPreview.Controls.Add(this.checkBoxPreview);
			this.groupBoxPreview.Location = new System.Drawing.Point(8, 8);
			this.groupBoxPreview.Name = "groupBoxPreview";
			this.groupBoxPreview.Size = new System.Drawing.Size(376, 304);
			this.groupBoxPreview.TabIndex = 0;
			this.groupBoxPreview.TabStop = false;
			this.groupBoxPreview.Text = "Preview";
			// 
			// checkBoxShowTemplate
			// 
			this.checkBoxShowTemplate.Location = new System.Drawing.Point(16, 56);
			this.checkBoxShowTemplate.Name = "checkBoxShowTemplate";
			this.checkBoxShowTemplate.Size = new System.Drawing.Size(240, 24);
			this.checkBoxShowTemplate.TabIndex = 2;
			this.checkBoxShowTemplate.Text = "Show Preview for templates";
			this.checkBoxShowTemplate.CheckedChanged += new System.EventHandler(this.checkBoxShowTemplate_CheckedChanged);
			// 
			// checkBoxShowResiurce
			// 
			this.checkBoxShowResiurce.Location = new System.Drawing.Point(16, 264);
			this.checkBoxShowResiurce.Name = "checkBoxShowResiurce";
			this.checkBoxShowResiurce.Size = new System.Drawing.Size(328, 24);
			this.checkBoxShowResiurce.TabIndex = 6;
			this.checkBoxShowResiurce.Text = "Show Preview for resources";
			// 
			// groupBoxResolution
			// 
			this.groupBoxResolution.Controls.Add(this.numericUpDownHeightR);
			this.groupBoxResolution.Controls.Add(this.numericUpDownWidthR);
			this.groupBoxResolution.Controls.Add(this.labelHeightR);
			this.groupBoxResolution.Controls.Add(this.labelWidthR);
			this.groupBoxResolution.Location = new System.Drawing.Point(200, 96);
			this.groupBoxResolution.Name = "groupBoxResolution";
			this.groupBoxResolution.Size = new System.Drawing.Size(160, 104);
			this.groupBoxResolution.TabIndex = 4;
			this.groupBoxResolution.TabStop = false;
			this.groupBoxResolution.Text = "Resolution";
			// 
			// numericUpDownHeightR
			// 
			this.numericUpDownHeightR.Location = new System.Drawing.Point(88, 66);
			this.numericUpDownHeightR.Maximum = new System.Decimal(new int[] {
																				 11000,
																				 0,
																				 0,
																				 0});
			this.numericUpDownHeightR.Minimum = new System.Decimal(new int[] {
																				 1,
																				 0,
																				 0,
																				 0});
			this.numericUpDownHeightR.Name = "numericUpDownHeightR";
			this.numericUpDownHeightR.Size = new System.Drawing.Size(56, 20);
			this.numericUpDownHeightR.TabIndex = 1;
			this.numericUpDownHeightR.Value = new System.Decimal(new int[] {
																			   600,
																			   0,
																			   0,
																			   0});
			// 
			// numericUpDownWidthR
			// 
			this.numericUpDownWidthR.Location = new System.Drawing.Point(88, 26);
			this.numericUpDownWidthR.Maximum = new System.Decimal(new int[] {
																				2000,
																				0,
																				0,
																				0});
			this.numericUpDownWidthR.Minimum = new System.Decimal(new int[] {
																				1,
																				0,
																				0,
																				0});
			this.numericUpDownWidthR.Name = "numericUpDownWidthR";
			this.numericUpDownWidthR.Size = new System.Drawing.Size(56, 20);
			this.numericUpDownWidthR.TabIndex = 0;
			this.numericUpDownWidthR.Value = new System.Decimal(new int[] {
																			  800,
																			  0,
																			  0,
																			  0});
			// 
			// labelHeightR
			// 
			this.labelHeightR.Location = new System.Drawing.Point(16, 66);
			this.labelHeightR.Name = "labelHeightR";
			this.labelHeightR.Size = new System.Drawing.Size(56, 23);
			this.labelHeightR.TabIndex = 1;
			this.labelHeightR.Text = "Height";
			// 
			// labelWidthR
			// 
			this.labelWidthR.Location = new System.Drawing.Point(16, 26);
			this.labelWidthR.Name = "labelWidthR";
			this.labelWidthR.Size = new System.Drawing.Size(40, 23);
			this.labelWidthR.TabIndex = 0;
			this.labelWidthR.Text = "Width";
			// 
			// groupBoxThumbnail
			// 
			this.groupBoxThumbnail.Controls.Add(this.labelHeightT);
			this.groupBoxThumbnail.Controls.Add(this.labelWidthT);
			this.groupBoxThumbnail.Controls.Add(this.numericUpDownHeightT);
			this.groupBoxThumbnail.Controls.Add(this.numericUpDownWidthT);
			this.groupBoxThumbnail.Location = new System.Drawing.Point(16, 96);
			this.groupBoxThumbnail.Name = "groupBoxThumbnail";
			this.groupBoxThumbnail.Size = new System.Drawing.Size(152, 104);
			this.groupBoxThumbnail.TabIndex = 3;
			this.groupBoxThumbnail.TabStop = false;
			this.groupBoxThumbnail.Text = "Thumbnail";
			// 
			// labelHeightT
			// 
			this.labelHeightT.Location = new System.Drawing.Point(16, 66);
			this.labelHeightT.Name = "labelHeightT";
			this.labelHeightT.Size = new System.Drawing.Size(40, 16);
			this.labelHeightT.TabIndex = 3;
			this.labelHeightT.Text = "Height";
			// 
			// labelWidthT
			// 
			this.labelWidthT.Location = new System.Drawing.Point(16, 26);
			this.labelWidthT.Name = "labelWidthT";
			this.labelWidthT.Size = new System.Drawing.Size(40, 23);
			this.labelWidthT.TabIndex = 4;
			this.labelWidthT.Text = "Width";
			// 
			// numericUpDownHeightT
			// 
			this.numericUpDownHeightT.Location = new System.Drawing.Point(88, 66);
			this.numericUpDownHeightT.Maximum = new System.Decimal(new int[] {
																				 800,
																				 0,
																				 0,
																				 0});
			this.numericUpDownHeightT.Minimum = new System.Decimal(new int[] {
																				 1,
																				 0,
																				 0,
																				 0});
			this.numericUpDownHeightT.Name = "numericUpDownHeightT";
			this.numericUpDownHeightT.Size = new System.Drawing.Size(48, 20);
			this.numericUpDownHeightT.TabIndex = 1;
			this.numericUpDownHeightT.Value = new System.Decimal(new int[] {
																			   80,
																			   0,
																			   0,
																			   0});
			// 
			// numericUpDownWidthT
			// 
			this.numericUpDownWidthT.Location = new System.Drawing.Point(88, 26);
			this.numericUpDownWidthT.Maximum = new System.Decimal(new int[] {
																				600,
																				0,
																				0,
																				0});
			this.numericUpDownWidthT.Minimum = new System.Decimal(new int[] {
																				1,
																				0,
																				0,
																				0});
			this.numericUpDownWidthT.Name = "numericUpDownWidthT";
			this.numericUpDownWidthT.Size = new System.Drawing.Size(48, 20);
			this.numericUpDownWidthT.TabIndex = 0;
			this.numericUpDownWidthT.Value = new System.Decimal(new int[] {
																			  120,
																			  0,
																			  0,
																			  0});
			// 
			// buttonBrowse
			// 
			this.buttonBrowse.Location = new System.Drawing.Point(336, 224);
			this.buttonBrowse.Name = "buttonBrowse";
			this.buttonBrowse.Size = new System.Drawing.Size(24, 23);
			this.buttonBrowse.TabIndex = 5;
			this.buttonBrowse.Text = "...";
			this.buttonBrowse.Click += new System.EventHandler(this.buttonBrowse_Click);
			// 
			// textBoxTempPath
			// 
			this.textBoxTempPath.Location = new System.Drawing.Point(160, 224);
			this.textBoxTempPath.Name = "textBoxTempPath";
			this.textBoxTempPath.ReadOnly = true;
			this.textBoxTempPath.Size = new System.Drawing.Size(168, 20);
			this.textBoxTempPath.TabIndex = 10;
			this.textBoxTempPath.TabStop = false;
			this.textBoxTempPath.Text = "";
			// 
			// labelTempPath
			// 
			this.labelTempPath.Location = new System.Drawing.Point(8, 224);
			this.labelTempPath.Name = "labelTempPath";
			this.labelTempPath.Size = new System.Drawing.Size(168, 32);
			this.labelTempPath.TabIndex = 5;
			this.labelTempPath.Text = "Place to store temprary images";
			// 
			// checkBoxPreview
			// 
			this.checkBoxPreview.Location = new System.Drawing.Point(16, 24);
			this.checkBoxPreview.Name = "checkBoxPreview";
			this.checkBoxPreview.Size = new System.Drawing.Size(232, 16);
			this.checkBoxPreview.TabIndex = 1;
			this.checkBoxPreview.Text = "Show Preview for postings";
			this.checkBoxPreview.CheckedChanged += new System.EventHandler(this.checkBoxPreview_CheckedChanged);
			// 
			// buttonOk
			// 
			this.buttonOk.Location = new System.Drawing.Point(224, 392);
			this.buttonOk.Name = "buttonOk";
			this.buttonOk.TabIndex = 2;
			this.buttonOk.Text = "Ok";
			this.buttonOk.Click += new System.EventHandler(this.buttonOk_Click);
			// 
			// buttonCancel
			// 
			this.buttonCancel.DialogResult = System.Windows.Forms.DialogResult.Cancel;
			this.buttonCancel.Location = new System.Drawing.Point(312, 392);
			this.buttonCancel.Name = "buttonCancel";
			this.buttonCancel.TabIndex = 3;
			this.buttonCancel.Text = "Cancel";
			this.buttonCancel.Click += new System.EventHandler(this.buttonCancel_Click);
			// 
			// groupBoxServer
			// 
			this.groupBoxServer.Controls.Add(this.textBoxServerName);
			this.groupBoxServer.Controls.Add(this.labelServerName);
			this.groupBoxServer.Location = new System.Drawing.Point(8, 320);
			this.groupBoxServer.Name = "groupBoxServer";
			this.groupBoxServer.Size = new System.Drawing.Size(376, 56);
			this.groupBoxServer.TabIndex = 1;
			this.groupBoxServer.TabStop = false;
			this.groupBoxServer.Text = "Server";
			// 
			// textBoxServerName
			// 
			this.textBoxServerName.Location = new System.Drawing.Point(120, 24);
			this.textBoxServerName.Name = "textBoxServerName";
			this.textBoxServerName.Size = new System.Drawing.Size(240, 20);
			this.textBoxServerName.TabIndex = 0;
			this.textBoxServerName.Text = "";
			// 
			// labelServerName
			// 
			this.labelServerName.Location = new System.Drawing.Point(16, 24);
			this.labelServerName.Name = "labelServerName";
			this.labelServerName.TabIndex = 0;
			this.labelServerName.Text = "Server Name ";
			// 
			// FormSettings
			// 
			this.AcceptButton = this.buttonOk;
			this.AutoScaleBaseSize = new System.Drawing.Size(5, 13);
			this.CancelButton = this.buttonCancel;
			this.ClientSize = new System.Drawing.Size(394, 424);
			this.Controls.Add(this.groupBoxServer);
			this.Controls.Add(this.buttonCancel);
			this.Controls.Add(this.buttonOk);
			this.Controls.Add(this.groupBoxPreview);
			this.FormBorderStyle = System.Windows.Forms.FormBorderStyle.FixedDialog;
			this.Icon = ((System.Drawing.Icon)(resources.GetObject("$this.Icon")));
			this.MaximizeBox = false;
			this.MinimizeBox = false;
			this.Name = "FormSettings";
			this.ShowInTaskbar = false;
			this.StartPosition = System.Windows.Forms.FormStartPosition.CenterScreen;
			this.Text = "Settings - MCMS Manager";
			this.Load += new System.EventHandler(this.FormSettings_Load);
			this.groupBoxPreview.ResumeLayout(false);
			this.groupBoxResolution.ResumeLayout(false);
			((System.ComponentModel.ISupportInitialize)(this.numericUpDownHeightR)).EndInit();
			((System.ComponentModel.ISupportInitialize)(this.numericUpDownWidthR)).EndInit();
			this.groupBoxThumbnail.ResumeLayout(false);
			((System.ComponentModel.ISupportInitialize)(this.numericUpDownHeightT)).EndInit();
			((System.ComponentModel.ISupportInitialize)(this.numericUpDownWidthT)).EndInit();
			this.groupBoxServer.ResumeLayout(false);
			this.ResumeLayout(false);

		}
		#endregion

		private void FormSettings_Load(object sender, System.EventArgs e)
		{
			try
			{
				this.textBoxServerName.Text = FormMCMSManager.serverName;
				this.textBoxTempPath.Text = FormMCMSManager.thumbnailPath;
				if(this.textBoxTempPath.Text=="")
				{
					this.textBoxTempPath.Text = Application.UserAppDataPath;
				}
				if(this.textBoxTempPath.Text!="")
				{
					this.folderBrowserDialog.SelectedPath = this.textBoxTempPath.Text;
				}
				this.numericUpDownHeightR.Value = (decimal)FormMCMSManager.resolutionHeight;
				this.numericUpDownHeightT.Value = (decimal)FormMCMSManager.thumbnailHeight;
				this.numericUpDownWidthR.Value = (decimal)FormMCMSManager.resolutionWidth;
				this.numericUpDownWidthT.Value = (decimal)FormMCMSManager.thumbnailWidth;
				this.checkBoxPreview.Checked = FormMCMSManager.showPreview;
				this.checkBoxShowResiurce.Checked = FormMCMSManager.showPreviewResource;
				this.checkBoxShowTemplate.Checked = FormMCMSManager.showPreviewTemplate;
				if(this.checkBoxPreview.Checked ||  this.checkBoxShowTemplate.Checked)
				{
					this.numericUpDownHeightR.Enabled = true;
					this.numericUpDownWidthR.Enabled = true;
					this.numericUpDownHeightT.Enabled = true;
					this.numericUpDownWidthT.Enabled = true;
					this.buttonBrowse.Enabled = true;
				}			
				else
				{
					this.numericUpDownHeightR.Enabled = false;
					this.numericUpDownWidthR.Enabled = false;
					this.numericUpDownHeightT.Enabled = false;
					this.numericUpDownWidthT.Enabled = false;
					this.buttonBrowse.Enabled = false;
				}
			}
			catch(Exception ex)
			{
				MessageBox.Show("Configuration exception : "+ex.Message,"Error",MessageBoxButtons.OK,MessageBoxIcon.Error);

			}
		}
		#endregion

		#region Save and Cancel
		private void buttonCancel_Click(object sender, System.EventArgs e)
		{
			this.Close();
		}

		private void checkBoxShowTemplate_CheckedChanged(object sender, System.EventArgs e)
		{
			if(this.checkBoxShowTemplate.Checked||this.checkBoxPreview.Checked)
			{
				this.numericUpDownHeightR.Enabled = true;
				this.numericUpDownWidthR.Enabled = true;
				this.numericUpDownHeightT.Enabled = true;
				this.numericUpDownWidthT.Enabled = true;
				this.buttonBrowse.Enabled = true;
			}			
			else
			{
				this.numericUpDownHeightR.Enabled = false;
				this.numericUpDownWidthR.Enabled = false;
				this.numericUpDownHeightT.Enabled = false;
				this.numericUpDownWidthT.Enabled = false;
				this.buttonBrowse.Enabled = false;
			}
		}

		private void buttonOk_Click(object sender, System.EventArgs e)
		{
			try
			{
				mcmsConfig = ConfigurationManager.GetConfiguration("MCMSSettings") as MCMSManagerConfig;
				mcmsConfig.ServerName = this.textBoxServerName.Text;
				mcmsConfig.ShowPreview = this.checkBoxPreview.Checked?0:1;
				mcmsConfig.ShowPreviewResource = this.checkBoxShowResiurce.Checked?0:1;
				mcmsConfig.ShowPreviewTemplate = this.checkBoxShowTemplate.Checked?0:1;
				if(this.checkBoxPreview.Checked)
				{
					mcmsConfig.ResolutionHeight = (int)this.numericUpDownHeightR.Value;
					mcmsConfig.ResolutionWidth = (int)this.numericUpDownWidthR.Value;
					mcmsConfig.ThumbNailHeight = (int)this.numericUpDownHeightT.Value;
					mcmsConfig.ThumbnailWidth = (int)this.numericUpDownWidthT.Value;
					mcmsConfig.ThumbnailFolder = this.textBoxTempPath.Text;
					
					FormMCMSManager.resolutionWidth = mcmsConfig.ResolutionWidth;
					FormMCMSManager.resolutionHeight = mcmsConfig.ResolutionHeight;
					FormMCMSManager.thumbnailHeight = mcmsConfig.ThumbNailHeight;
					FormMCMSManager.thumbnailWidth = mcmsConfig.ThumbnailWidth ;
					FormMCMSManager.thumbnailPath = mcmsConfig.ThumbnailFolder;
				}
				FormMCMSManager.showPreview = this.checkBoxPreview.Checked;
				FormMCMSManager.showPreviewResource = this.checkBoxShowResiurce.Checked;
				FormMCMSManager.serverName = this.textBoxServerName.Text;
				FormMCMSManager.showPreviewTemplate = this.checkBoxShowTemplate.Checked;
                //Save
				ConfigurationManager.WriteConfiguration("MCMSSettings",mcmsConfig);
				MessageBox.Show("Some changes in thumbnail settings may require new CmsApplicationContext/Restart of the Application","Require Refresh",MessageBoxButtons.OK,MessageBoxIcon.Information);
				this.Close();
			}
			catch(Exception ex)
			{
				MessageBox.Show("Configuration exception : "+ex.Message,"Error",MessageBoxButtons.OK,MessageBoxIcon.Error);
			}
		}

		private void checkBoxPreview_CheckedChanged(object sender, System.EventArgs e)
		{
			if(this.checkBoxShowTemplate.Checked||this.checkBoxPreview.Checked)
			{
				this.numericUpDownHeightR.Enabled = true;
				this.numericUpDownWidthR.Enabled = true;
				this.numericUpDownHeightT.Enabled = true;
				this.numericUpDownWidthT.Enabled = true;
				this.buttonBrowse.Enabled = true;
			}			
			else
			{
				this.numericUpDownHeightR.Enabled = false;
				this.numericUpDownWidthR.Enabled = false;
				this.numericUpDownHeightT.Enabled = false;
				this.numericUpDownWidthT.Enabled = false;
				this.buttonBrowse.Enabled = false;
			}
		}

		private void buttonBrowse_Click(object sender, System.EventArgs e)
		{
			DialogResult result = folderBrowserDialog.ShowDialog();
			if(result == DialogResult.OK)
			{
				this.textBoxTempPath.Text = folderBrowserDialog.SelectedPath;
			}
		}
		#endregion

	}
}
