/**
 * @file FormStatistics.cs
 *
 * MCMS Manager
 *
 * MCMS Manager is the legal property of its developer
 * Chester Ragel <chesterr@gmail.com> - Developer and Maintainer
 * Yahoo ID : chesterr1979 
 * MSN : chesterr79@hotmail.com
 *
 * If you want more information, found any bugs or have any doubts you 
 * can mail me or contact me through my yahoo id.
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2.1 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#region Namespaces
using System;
using System.Drawing;
using System.Collections;
using System.ComponentModel;
using System.Windows.Forms;
using System.IO;
using System.Text.RegularExpressions;
//MCMS components
using Microsoft.ContentManagement.Common;
using Microsoft.ContentManagement.Publishing;
//Application block
using Microsoft.Practices.EnterpriseLibrary.Configuration;
#endregion

namespace MCMS
{
	/// <summary>
	/// Can create statistics using Cms and IIS log files
	/// </summary>
	public class FormStatistics : System.Windows.Forms.Form
	{
		#region Private Variables

		private System.Windows.Forms.Label labelFiles;
		private System.Windows.Forms.ComboBox comboBoxPosting;
		private System.Windows.Forms.Button buttonFiles;
		private System.Windows.Forms.Button buttonExit;
		private System.Windows.Forms.TextBox textBoxFiles;
		private System.Windows.Forms.Label labelPosting;
		private System.Windows.Forms.OpenFileDialog openFileDialog;
		private System.Windows.Forms.ImageList imageList;
		private System.Windows.Forms.ListView listViewPostings;
		private System.ComponentModel.IContainer components;
		private System.Windows.Forms.ProgressBar progressBar;

		private System.Windows.Forms.ColumnHeader columnCreatedOn;
		private System.Windows.Forms.ColumnHeader columnGuid;
		private System.Windows.Forms.ColumnHeader columnPageHits;
		private System.Windows.Forms.ColumnHeader columnAccessedBy;
		private System.Windows.Forms.ColumnHeader columnAccessedFrom;
		private System.Windows.Forms.ColumnHeader columnName;
		private System.Windows.Forms.ColumnHeader columnPostingState;
		private System.Windows.Forms.ColumnHeader columnChannel;
		private System.Windows.Forms.ColumnHeader columnAccessedOnDate;
		private System.Windows.Forms.ColumnHeader columnAccessedOnTime;

		private ListViewColumnSorter lvwColumnSorter;
		private System.Windows.Forms.Button buttonGenerate;
		private static string logFiles;
		private CmsPostings postings;
		private bool generateButton = true;

		private MCMSManagerConfig mcmsLog;
		private CmsApplicationContext cmsApplication = new CmsApplicationContext();

		#endregion

		#region Private delegate to start search/stop search
		private delegate void GenerateDelegate();
		#endregion

		#region Public static Variables
		public static string channelGuid;
		private System.Windows.Forms.StatusBar statusBar;
		private System.Windows.Forms.StatusBarPanel statusBarPanel;
		private System.Windows.Forms.StatusBarPanel statusBarPanelIIS;
		private System.Windows.Forms.Button buttonSave;
		private System.Windows.Forms.SaveFileDialog saveFileDialog;
		private static Channel rootChannel;
		#endregion

		#region Init/Dispose
		public FormStatistics()
		{
			InitializeComponent();
		}

		private void FormStatistics_Closing(object sender, System.ComponentModel.CancelEventArgs e)
		{
			try
			{
				cmsApplication.Dispose();
			}
			catch{}
		}

		/// <summary>
		/// Clean up any resources being used.
		/// </summary>
		protected override void Dispose( bool disposing )
		{
			if( disposing )
			{
				if(components != null)
				{
					components.Dispose();
					try
					{
						cmsApplication.Dispose();
					}
					catch{}
				}
			}
			base.Dispose( disposing );
		}

		#region Windows Form Designer generated code
		/// <summary>
		/// Required method for Designer support - do not modify
		/// the contents of this method with the code editor.
		/// </summary>
		private void InitializeComponent()
		{
			this.components = new System.ComponentModel.Container();
			System.Resources.ResourceManager resources = new System.Resources.ResourceManager(typeof(FormStatistics));
			this.comboBoxPosting = new System.Windows.Forms.ComboBox();
			this.listViewPostings = new System.Windows.Forms.ListView();
			this.imageList = new System.Windows.Forms.ImageList(this.components);
			this.columnAccessedBy = new System.Windows.Forms.ColumnHeader();
			this.columnAccessedFrom = new System.Windows.Forms.ColumnHeader();
			this.columnAccessedOnDate = new System.Windows.Forms.ColumnHeader();
			this.columnAccessedOnTime = new System.Windows.Forms.ColumnHeader();
			this.columnPageHits = new System.Windows.Forms.ColumnHeader();
			this.columnName = new System.Windows.Forms.ColumnHeader();
			this.columnChannel = new System.Windows.Forms.ColumnHeader();
			this.columnPostingState = new System.Windows.Forms.ColumnHeader();
			this.columnCreatedOn = new System.Windows.Forms.ColumnHeader();
			this.columnGuid = new System.Windows.Forms.ColumnHeader();
			this.labelFiles = new System.Windows.Forms.Label();
			this.openFileDialog = new System.Windows.Forms.OpenFileDialog();
			this.buttonFiles = new System.Windows.Forms.Button();
			this.buttonExit = new System.Windows.Forms.Button();
			this.textBoxFiles = new System.Windows.Forms.TextBox();
			this.labelPosting = new System.Windows.Forms.Label();
			this.buttonGenerate = new System.Windows.Forms.Button();
			this.progressBar = new System.Windows.Forms.ProgressBar();
			this.statusBar = new System.Windows.Forms.StatusBar();
			this.statusBarPanel = new System.Windows.Forms.StatusBarPanel();
			this.statusBarPanelIIS = new System.Windows.Forms.StatusBarPanel();
			this.buttonSave = new System.Windows.Forms.Button();
			this.saveFileDialog = new System.Windows.Forms.SaveFileDialog();
			((System.ComponentModel.ISupportInitialize)(this.statusBarPanel)).BeginInit();
			((System.ComponentModel.ISupportInitialize)(this.statusBarPanelIIS)).BeginInit();
			this.SuspendLayout();
			// 
			// comboBoxPosting
			// 
			this.comboBoxPosting.DropDownStyle = System.Windows.Forms.ComboBoxStyle.DropDownList;
			this.comboBoxPosting.Location = new System.Drawing.Point(72, 48);
			this.comboBoxPosting.Name = "comboBoxPosting";
			this.comboBoxPosting.Size = new System.Drawing.Size(264, 21);
			this.comboBoxPosting.TabIndex = 2;
			this.comboBoxPosting.SelectedIndexChanged += new System.EventHandler(this.comboBoxPosting_SelectedIndexChanged);
			// 
			// listViewPostings
			// 
			this.listViewPostings.AllowColumnReorder = true;
			this.listViewPostings.FullRowSelect = true;
			this.listViewPostings.LargeImageList = this.imageList;
			this.listViewPostings.Location = new System.Drawing.Point(8, 88);
			this.listViewPostings.Name = "listViewPostings";
			this.listViewPostings.Size = new System.Drawing.Size(672, 280);
			this.listViewPostings.SmallImageList = this.imageList;
			this.listViewPostings.StateImageList = this.imageList;
			this.listViewPostings.TabIndex = 3;
			this.listViewPostings.View = System.Windows.Forms.View.Details;
			this.listViewPostings.DoubleClick += new System.EventHandler(this.listViewPostings_DoubleClick);
			this.listViewPostings.ColumnClick += new System.Windows.Forms.ColumnClickEventHandler(this.listViewPostings_ColumnClick);
			this.listViewPostings.SelectedIndexChanged += new System.EventHandler(this.listViewPostings_SelectedIndexChanged);
			// 
			// imageList
			// 
			this.imageList.ImageSize = new System.Drawing.Size(16, 16);
			this.imageList.ImageStream = ((System.Windows.Forms.ImageListStreamer)(resources.GetObject("imageList.ImageStream")));
			this.imageList.TransparentColor = System.Drawing.Color.Transparent;
			// 
			// columnAccessedBy
			// 
			this.columnAccessedBy.Text = "Accessed By";
			this.columnAccessedBy.Width = 150;
			// 
			// columnAccessedFrom
			// 
			this.columnAccessedFrom.Text = "Accessed From";
			this.columnAccessedFrom.Width = 150;
			// 
			// columnAccessedOnDate
			// 
			this.columnAccessedOnDate.Text = "Accessed On (Date)";
			this.columnAccessedOnDate.Width = 140;
			// 
			// columnAccessedOnTime
			// 
			this.columnAccessedOnTime.Text = "Accessed On (Time)";
			this.columnAccessedOnTime.Width = 140;
			// 
			// columnPageHits
			// 
			this.columnPageHits.Text = "Page Hits";
			// 
			// columnName
			// 
			this.columnName.Text = "Name";
			this.columnName.Width = 125;
			// 
			// columnChannel
			// 
			this.columnChannel.Text = "Channel";
			this.columnChannel.Width = 130;
			// 
			// columnPostingState
			// 
			this.columnPostingState.Text = "Posting State";
			this.columnPostingState.Width = 100;
			// 
			// columnCreatedOn
			// 
			this.columnCreatedOn.Text = "Created On";
			this.columnCreatedOn.Width = 75;
			// 
			// columnGuid
			// 
			this.columnGuid.Text = "Guid";
			this.columnGuid.Width = 175;
			// 
			// labelFiles
			// 
			this.labelFiles.Location = new System.Drawing.Point(8, 16);
			this.labelFiles.Name = "labelFiles";
			this.labelFiles.Size = new System.Drawing.Size(376, 23);
			this.labelFiles.TabIndex = 6;
			this.labelFiles.Text = "Select the MCMS - IIS log files using which the statistics will be generated ";
			// 
			// openFileDialog
			// 
			this.openFileDialog.DefaultExt = "log";
			this.openFileDialog.Filter = "IIS(MCMS) Log Files|*.log";
			this.openFileDialog.Multiselect = true;
			// 
			// buttonFiles
			// 
			this.buttonFiles.Location = new System.Drawing.Point(656, 16);
			this.buttonFiles.Name = "buttonFiles";
			this.buttonFiles.Size = new System.Drawing.Size(24, 20);
			this.buttonFiles.TabIndex = 0;
			this.buttonFiles.Text = "...";
			this.buttonFiles.Click += new System.EventHandler(this.buttonFiles_Click);
			// 
			// buttonExit
			// 
			this.buttonExit.DialogResult = System.Windows.Forms.DialogResult.Cancel;
			this.buttonExit.Location = new System.Drawing.Point(600, 376);
			this.buttonExit.Name = "buttonExit";
			this.buttonExit.TabIndex = 5;
			this.buttonExit.Text = "Exit";
			this.buttonExit.Click += new System.EventHandler(this.buttonExit_Click);
			// 
			// textBoxFiles
			// 
			this.textBoxFiles.Location = new System.Drawing.Point(376, 16);
			this.textBoxFiles.Name = "textBoxFiles";
			this.textBoxFiles.ReadOnly = true;
			this.textBoxFiles.Size = new System.Drawing.Size(272, 20);
			this.textBoxFiles.TabIndex = 100;
			this.textBoxFiles.TabStop = false;
			this.textBoxFiles.Text = "";
			// 
			// labelPosting
			// 
			this.labelPosting.Location = new System.Drawing.Point(8, 48);
			this.labelPosting.Name = "labelPosting";
			this.labelPosting.Size = new System.Drawing.Size(56, 23);
			this.labelPosting.TabIndex = 12;
			this.labelPosting.Text = "Posting";
			// 
			// buttonGenerate
			// 
			this.buttonGenerate.Location = new System.Drawing.Point(568, 48);
			this.buttonGenerate.Name = "buttonGenerate";
			this.buttonGenerate.Size = new System.Drawing.Size(112, 23);
			this.buttonGenerate.TabIndex = 1;
			this.buttonGenerate.Text = "Generate Statistics";
			this.buttonGenerate.Click += new System.EventHandler(this.buttonGenerate_Click);
			// 
			// progressBar
			// 
			this.progressBar.Location = new System.Drawing.Point(352, 48);
			this.progressBar.Name = "progressBar";
			this.progressBar.Size = new System.Drawing.Size(208, 23);
			this.progressBar.TabIndex = 100;
			// 
			// statusBar
			// 
			this.statusBar.Location = new System.Drawing.Point(0, 409);
			this.statusBar.Name = "statusBar";
			this.statusBar.Panels.AddRange(new System.Windows.Forms.StatusBarPanel[] {
																						 this.statusBarPanel,
																						 this.statusBarPanelIIS});
			this.statusBar.ShowPanels = true;
			this.statusBar.Size = new System.Drawing.Size(688, 22);
			this.statusBar.TabIndex = 200;
			// 
			// statusBarPanel
			// 
			this.statusBarPanel.Width = 440;
			// 
			// statusBarPanelIIS
			// 
			this.statusBarPanelIIS.Text = "Note : This report depends on IIS/MCMS log file.";
			this.statusBarPanelIIS.Width = 248;
			// 
			// buttonSave
			// 
			this.buttonSave.Enabled = false;
			this.buttonSave.Location = new System.Drawing.Point(512, 376);
			this.buttonSave.Name = "buttonSave";
			this.buttonSave.TabIndex = 4;
			this.buttonSave.Text = "Save";
			this.buttonSave.Click += new System.EventHandler(this.buttonSave_Click);
			// 
			// saveFileDialog
			// 
			this.saveFileDialog.DefaultExt = "log";
			this.saveFileDialog.Filter = "MCMS Log Files|*.log";
			// 
			// FormStatistics
			// 
			this.AutoScaleBaseSize = new System.Drawing.Size(5, 13);
			this.CancelButton = this.buttonExit;
			this.ClientSize = new System.Drawing.Size(688, 431);
			this.Controls.Add(this.buttonSave);
			this.Controls.Add(this.statusBar);
			this.Controls.Add(this.progressBar);
			this.Controls.Add(this.buttonGenerate);
			this.Controls.Add(this.labelPosting);
			this.Controls.Add(this.textBoxFiles);
			this.Controls.Add(this.buttonExit);
			this.Controls.Add(this.buttonFiles);
			this.Controls.Add(this.labelFiles);
			this.Controls.Add(this.listViewPostings);
			this.Controls.Add(this.comboBoxPosting);
			this.FormBorderStyle = System.Windows.Forms.FormBorderStyle.FixedSingle;
			this.Icon = ((System.Drawing.Icon)(resources.GetObject("$this.Icon")));
			this.MaximizeBox = false;
			this.Name = "FormStatistics";
			this.StartPosition = System.Windows.Forms.FormStartPosition.CenterScreen;
			this.Text = "Statistics for Channel : ";
			this.Closing += new System.ComponentModel.CancelEventHandler(this.FormStatistics_Closing);
			this.Load += new System.EventHandler(this.FormStatistics_Load);
			((System.ComponentModel.ISupportInitialize)(this.statusBarPanel)).EndInit();
			((System.ComponentModel.ISupportInitialize)(this.statusBarPanelIIS)).EndInit();
			this.ResumeLayout(false);

		}
		#endregion

		private void FormStatistics_Load(object sender, System.EventArgs e)
		{
			Init();
		}

		private void Init()
		{
			//to sort in list view
			postings = new CmsPostings();
			cmsApplication.AuthenticateAsUser(FormMCMSManager.userName,FormMCMSManager.password,PublishingMode.Update);
			rootChannel = (Channel)cmsApplication.Searches.GetByGuid(channelGuid);
			lvwColumnSorter = new ListViewColumnSorter();
			this.listViewPostings.ListViewItemSorter = lvwColumnSorter;
			//get the information from the config file
			try
			{
				mcmsLog = ConfigurationManager.GetConfiguration("MCMSSettings") as MCMSManagerConfig;
				if(mcmsLog!=null)
				{
					logFiles = mcmsLog.MCMSLogFiles;
					if(logFiles!="")
					{
						string allFiles = "";
						foreach(string file in logFiles.Split(';'))
						{
							if(file!="")
							{
								allFiles += file.Split('\\')[file.Split('\\').Length-1]+";";
							}
						}
						this.textBoxFiles.Text = allFiles;
					}
				}
			}
			catch(Exception ex)
			{
				MessageBox.Show("Configuration Management exception : "+ex.Message,"Error",MessageBoxButtons.OK,MessageBoxIcon.Error);
			}
		}

		#endregion

		#region Sorting
		private void listViewPostings_ColumnClick(object sender, System.Windows.Forms.ColumnClickEventArgs e)
		{
			if (e.Column == lvwColumnSorter.SortColumn)
			{
				// Reverse the current sort direction for this column.
				if (lvwColumnSorter.Order == SortOrder.Ascending)
				{
					lvwColumnSorter.Order = SortOrder.Descending;
				}
				else
				{
					lvwColumnSorter.Order = SortOrder.Ascending;
				}
			}
			else
			{
				// Set the column number that is to be sorted; default to ascending.
				lvwColumnSorter.SortColumn = e.Column;
				lvwColumnSorter.Order = SortOrder.Ascending;
			}

			// Perform the sort with these new sort options.
			this.listViewPostings.Sort();
		}
		#endregion

		#region List Column according to Item		

		private void InitListViewPostings()
		{
			this.listViewPostings.Columns.Clear();
			this.listViewPostings.Columns.AddRange(new System.Windows.Forms.ColumnHeader[] {
																							   this.columnName,
																							   this.columnGuid,
																							   this.columnChannel,
																							   this.columnPostingState,
																							   this.columnPageHits,
																							   this.columnCreatedOn});
		}

		private void InitListViewPosting()
		{
			this.listViewPostings.Columns.Clear();
			this.listViewPostings.Columns.AddRange(new System.Windows.Forms.ColumnHeader[] {
																							   this.columnAccessedBy,
																							   this.columnAccessedFrom,
																							   this.columnAccessedOnDate,
																							   this.columnAccessedOnTime,
																							   this.columnPageHits});
		}

		#endregion

		#region Events

		private void buttonFiles_Click(object sender, System.EventArgs e)
		{
			DialogResult rResult = openFileDialog.ShowDialog();
			if(rResult != DialogResult.Cancel)
			{
				string[] files = openFileDialog.FileNames;

				// Open each file and display the image in PictureBox1.
				// Call Application.DoEvents to force a repaint after each
				// file is read.  
      
				string strDisplayNames = "";

				foreach (string file in files )
				{
					if(file!= "")
					{
						strDisplayNames += file + ";";
					}
				}
				logFiles = strDisplayNames;

				string allFiles = "";
				foreach(string file in logFiles.Split(';'))
				{
					if(file!="")
					{
						allFiles += file.Split('\\')[file.Split('\\').Length-1]+";";
					}
				}

				this.textBoxFiles.Text = allFiles;
			}
		}

		private void buttonExit_Click(object sender, System.EventArgs e)
		{
			mcmsLog.MCMSLogFiles = logFiles;
			cmsApplication.Dispose();
			ConfigurationManager.WriteConfiguration("MCMSSettings",mcmsLog);
			this.Close();
		}

		private void buttonGenerate_Click(object sender, System.EventArgs e)
		{
			if(generateButton)
			{
				this.buttonExit.Enabled = false;
				this.buttonSave.Enabled = false;
				this.buttonFiles.Enabled = false;
				this.comboBoxPosting.Enabled = false;
				this.buttonGenerate.Enabled = false;
				GenerateDelegate convert = new GenerateDelegate(GenerateReport);
				convert.BeginInvoke(null,null);
			}
			else
			{
				generateButton = true;
				this.buttonGenerate.Enabled = false;
				this.buttonGenerate.Text = "Stopping...";
			}
		}

		private void comboBoxPosting_SelectedIndexChanged(object sender, System.EventArgs e)
		{
			if(comboBoxPosting.SelectedIndex == 0) 
			{
				InitListViewPostings();
				this.listViewPostings.Items.Clear();
				if(postings.Count>0)
				{
					for(int i = 0;i<postings.Count;i++)
					{
						this.statusBar.Panels[0].Text = "Adding Posting : "+postings[i].Name;
						ListViewItem item = new ListViewItem(new string[] {postings[i].Name,postings[i].Guid,postings[i].ChannelName,postings[i].CmsPostingState.ToString(),postings[i].TotalHit.ToString(),postings[i].CreatedOn.ToShortDateString()},0);
						item.Tag = i+1;
						listViewPostings.Items.Add(item);
					}
					this.statusBarPanel.Text = "";
				}
				else
				{
					this.statusBarPanel.Text = "No records found in the log file";
				}
			}
			else
			{
				InitListViewPosting();
				this.listViewPostings.Items.Clear();
				for(int i=0;i<postings[this.comboBoxPosting.SelectedIndex-1].AccessedBy.Length;i++)
				{
					ListViewItem item = new ListViewItem(new string[] {postings[this.comboBoxPosting.SelectedIndex-1].AccessedBy[i],postings[this.comboBoxPosting.SelectedIndex-1].AccessedFrom[i],postings[this.comboBoxPosting.SelectedIndex-1].AccessedOnDate[i],postings[this.comboBoxPosting.SelectedIndex-1].AccessedOnTime[i],postings[this.comboBoxPosting.SelectedIndex-1].HitCount[i].ToString()});
					listViewPostings.Items.Add(item);
				}
				this.statusBarPanel.Text = "";
			}
		}

		private void listViewPostings_DoubleClick(object sender, System.EventArgs e)
		{
			this.comboBoxPosting.SelectedIndex = Convert.ToInt32(this.listViewPostings.SelectedItems[0].Tag);
		}

		private void listViewPostings_SelectedIndexChanged(object sender, System.EventArgs e)
		{
			if(this.comboBoxPosting.SelectedIndex == 0 )
			{
				this.statusBarPanel.Text = "Selected Posting(s) Count : "+listViewPostings.SelectedIndices.Count;
			}
			else
			{
				this.statusBarPanel.Text = "Selected Count : "+listViewPostings.SelectedIndices.Count;
			}
		}

		#endregion

		#region Report Generation
		private void GenerateReport()
		{
			try
			{
				this.buttonGenerate.Enabled = true;
				generateButton = false;
				this.buttonGenerate.Text = "Stop";
				string[] files = logFiles.Split(';');
				this.listViewPostings.Items.Clear();
				this.comboBoxPosting.Items.Clear();
				postings.Clear();
				if(rootChannel!=null)
				{
					AllPostings(rootChannel);
				}
				foreach(string file in files)
				{
					if(file!="")
					{
						FileInfo fileInfo = new FileInfo(file);
						if(fileInfo.Exists)
						{
							if(!generateButton)
							{
								this.statusBar.Panels[0].Text = "Analyzing log file : "+file.Split('\\')[file.Split('\\').Length-1];
								AnalyzeMCMSLog(fileInfo);
							}
						}
					}
				}
				if(!generateButton)
				{
					for(int i=0;i<postings.Count;i++)
					{
						if(postings[i].TotalHit==0)
						{
							postings.Remove(postings[i]);
							i--;
						}
					}
					if(postings.Count>0)
					{
						this.buttonSave.Enabled = true;
						this.comboBoxPosting.Items.Add("All");
						for(int i=0;i<postings.Count;i++)
						{
							this.statusBar.Panels[0].Text = "Adding Posting : "+postings[i].Name;
							if(!generateButton)
							{
								this.comboBoxPosting.Items.Add(postings[i].Name);
								if(this.comboBoxPosting.Items.Count>0)
								{
									this.comboBoxPosting.SelectedItem = this.comboBoxPosting.Items[0];
								}
								this.statusBar.Panels[0].Text = "Report Generated";
							}
							else
							{
								this.buttonGenerate.Text = "Generate Statistics";
								this.statusBar.Panels[0].Text = "Report generation canceled by the user";
								this.buttonExit.Enabled = true;
								this.buttonGenerate.Enabled = true;
								this.buttonFiles.Enabled = true;
								this.comboBoxPosting.Enabled = true;
								this.buttonSave.Enabled = true;
								this.progressBar.Value = 0;
							}
						}
					}
					else
					{
						this.buttonSave.Enabled = false;
						this.statusBarPanel.Text = "No records found in the log file";
					}
				}
			}
			catch(Exception ex)
			{
				MessageBox.Show("While generating the report an exception was thrown. Exception : "+ex.Message,"Error",MessageBoxButtons.OK,MessageBoxIcon.Error);
				this.progressBar.Value = 0;
				this.buttonExit.Enabled = true;
				this.buttonGenerate.Enabled = true;
				this.buttonFiles.Enabled = true;
				this.comboBoxPosting.Enabled = true;
				generateButton = true;
				this.buttonGenerate.Text = "Generate Statistics";
				this.statusBar.Panels[0].Text = "While generating report an error occured";
			}
			finally
			{
				if(!generateButton)
				{
					this.progressBar.Value = 0;
					this.buttonExit.Enabled = true;
					this.buttonGenerate.Enabled = true;
					this.buttonFiles.Enabled = true;
					this.comboBoxPosting.Enabled = true;
					generateButton = true;
					this.buttonGenerate.Text = "Generate Statistics";
				}
			}
		}

		private void AllPostings(Channel channel)
		{
			//all postings
			this.statusBar.Panels[0].Text = "Gathering postings in channel : "+channel.Name;
			this.progressBar.Maximum = (channel.Postings.Count>0?channel.Postings.Count-1:0);
			this.progressBar.Minimum = 0;
			this.progressBar.Step = 1;
			this.progressBar.Value = 0;
			foreach(Posting posting in channel.Postings)
			{
				if(!generateButton)
				{
					CmsPosting cmsPosting = new CmsPosting();
					cmsPosting.Guid = posting.Guid;
					cmsPosting.Name = posting.Name;
					cmsPosting.ExpiredOn = posting.ExpiryDate;
					cmsPosting.ChannelName = posting.Parent.Path;
					cmsPosting.CreatedOn = posting.CreatedDate;
					cmsPosting.CmsPostingState = posting.State;
					cmsPosting.AccessedBy = new string[1];
					cmsPosting.AccessedFrom = new string[1];
					cmsPosting.AccessedOnDate = new string[1];
					cmsPosting.AccessedOnTime = new string[1];
					cmsPosting.HitCount = new int[1];
					cmsPosting.AccessedBy[0] = "N/A";
					cmsPosting.AccessedFrom[0] = "N/A";
					cmsPosting.AccessedOnDate[0] = "N/A";
					cmsPosting.AccessedOnTime[0] = "N/A";
					cmsPosting.HitCount[0] = 0;
					postings.Add(cmsPosting);
					this.progressBar.Increment(1);
				}
				else
				{
					//stoped clicked. so stop.
					generateButton = true;
					this.buttonGenerate.Text = "Stopping...";
				}
				
			}
			//go through all the channels
			for(int i=0;i<channel.Channels.Count;i++)
			{
				if(!generateButton)
				{
					if(channel.Channels!=null)
						AllPostings(channel.Channels[i]);
				}
				else
				{
					this.buttonGenerate.Text = "Generate Statistics";
					this.statusBar.Panels[0].Text = "Report generation canceled by the user";
					this.buttonExit.Enabled = true;
					this.buttonGenerate.Enabled = true;
					this.buttonFiles.Enabled = true;
					this.comboBoxPosting.Enabled = true;
					this.buttonSave.Enabled = true;
					this.progressBar.Value = 0;
					return;
				}
			}
		}

		private void AnalyzeMCMSLog(FileInfo file)
		{
			StreamReader sr = file.OpenText();
			int posDate = -1;
			int posTime = -1;
			int posClient = -1;
			int posUser = -1;
			string line;
			int lineCount=0;
			int currentLine = 0;
			string text = this.statusBar.Panels[0].Text;
			while(sr.ReadLine()!=null)
			{
				lineCount++;
			}
			sr.BaseStream.Position = 0;
			this.progressBar.Maximum = (lineCount>0?lineCount-1:0);
			this.progressBar.Minimum = 0;
			this.progressBar.Step = 1;
			this.progressBar.Value = 0;
			try
			{
				while((line=sr.ReadLine())!=null)
				{
					if(!generateButton)
					{
						currentLine++;
						Regex field = new Regex(@"(#Fields:[^ ]*)");
						Regex software = new Regex(@"(#Software:[^ ]*)");
						Regex cmsUrl = new Regex(@"(/NR/exeres/[^ ]*)");
						if(field.IsMatch(line))
						{
							string[] posValues = line.ToLower().Split(' ');
							for(int i=0;i<posValues.Length;i++)
							{
								int a = posValues[i].IndexOf("date");
								if(posValues[i].IndexOf("date")!=-1)
								{
									posDate = i-1;
								}
								else if(posValues[i].IndexOf("time")!=-1)
								{
									posTime = i-1;
								}
								else if(posValues[i].IndexOf("c-ip")!=-1)
								{
									posClient = i-1;
								}
								else if(posValues[i].IndexOf("cs-username")!=-1)
								{
									posUser = i-1;
								}
							}
						}
						else if(software.IsMatch(line))
						{
							posDate = -1;
							posTime = -1;
							posClient = -1;
							posUser = -1;
						}
						else if(cmsUrl.IsMatch(line))
						{
							int iPos = 0;
							if((iPos = line.IndexOf(@"/NR/exeres/")) !=-1)
							{
								string tmp = line.Substring(iPos+11, 36);
								bool isFound = false;
								for(int i=0;i<postings.Count;i++)
								{
									if(postings[i].Guid.IndexOf(tmp)!=-1)
									{
										for(int j=0;j<postings[i].AccessedBy.Length;j++)
										{
											//The worst logic I've ever written in my life
											if(posUser!=-1)
											{
												if(postings[i].AccessedBy[j] == line.Split(' ')[posUser])
												{
													if(posDate!=-1)
													{
														if(postings[i].AccessedOnDate[j] == line.Split(' ')[posDate])
														{
															if(posTime!=-1)
															{
																if(postings[i].AccessedOnTime[j] == line.Split(' ')[posTime])
																{
																	if(posClient!=-1)
																	{
																		if(postings[i].AccessedFrom[j] == line.Split(' ')[posClient])
																		{
																			postings[i].HitCount[j]++;
																			isFound= true;
																		}
																	}
																	else
																	{
																		if(postings[i].AccessedFrom[j] == "N/A")
																		{
																			postings[i].HitCount[j]++;
																			isFound= true;
																		}
																	}
																}
															}
															else
															{
																if(postings[i].AccessedOnTime[j] == "N/A")
																{
																	if(posClient!=-1)
																	{
																		if(postings[i].AccessedFrom[j] == line.Split(' ')[posClient])
																		{
																			postings[i].HitCount[j]++;
																			isFound= true;
																		}
																	}
																	else
																	{
																		if(postings[i].AccessedFrom[j] == "N/A")
																		{
																			postings[i].HitCount[j]++;
																			isFound= true;
																		}
																	}
																}
															}
														}
													}
													else
													{
														if(postings[i].AccessedOnDate[j] == "N/A")
														{
															if(posTime!=-1)
															{
																if(postings[i].AccessedOnTime[j] == line.Split(' ')[posTime])
																{
																	if(posClient!=-1)
																	{
																		if(postings[i].AccessedFrom[j] == line.Split(' ')[posClient])
																		{
																			postings[i].HitCount[j]++;
																			isFound= true;
																		}
																	}
																	else
																	{
																		if(postings[i].AccessedFrom[j] == "N/A")
																		{
																			postings[i].HitCount[j]++;
																			isFound= true;
																		}
																	
																	}
																}
															}
															else
															{
																if(postings[i].AccessedOnTime[j] == "N/A")
																{
																	if(posClient!=-1)
																	{
																		if(postings[i].AccessedFrom[j] == line.Split(' ')[posClient])
																		{
																			postings[i].HitCount[j]++;
																			isFound= true;
																		}
																	}
																	else
																	{
																		if(postings[i].AccessedFrom[j] == "N/A")
																		{
																			postings[i].HitCount[j]++;
																			isFound= true;
																		}
																	
																	}
																}
															
															}
														}
													}
												}
											}
											else
											{
												if(postings[i].AccessedBy[j] == "N/A")
												{
													if(posDate!=-1)
													{
														if(postings[i].AccessedOnDate[j] == line.Split(' ')[posDate])
														{
															if(posTime!=-1)
															{
																if(postings[i].AccessedOnTime[j] == line.Split(' ')[posTime])
																{
																	if(posClient!=-1)
																	{
																		if(postings[i].AccessedFrom[j] == line.Split(' ')[posClient])
																		{
																			postings[i].HitCount[j]++;
																			isFound= true;
																		}
																	}
																	else
																	{
																		if(postings[i].AccessedFrom[j] == "N/A")
																		{
																			postings[i].HitCount[j]++;
																			isFound= true;
																		}
																	
																	}
																}
															}
															else
															{
																if(postings[i].AccessedOnTime[j] == "N/A")
																{
																	if(posClient!=-1)
																	{
																		if(postings[i].AccessedFrom[j] == line.Split(' ')[posClient])
																		{
																			postings[i].HitCount[j]++;
																			isFound= true;
																		}
																	}
																	else
																	{
																		if(postings[i].AccessedFrom[j] == "N/A")
																		{
																			postings[i].HitCount[j]++;
																			isFound= true;
																		}
																	
																	}
																}
															}
														}
													}
													else
													{
														if(postings[i].AccessedOnDate[j] == "N/A")
														{
															if(posTime!=-1)
															{
																if(postings[i].AccessedOnTime[j] == line.Split(' ')[posTime])
																{
																	if(posClient!=-1)
																	{
																		if(postings[i].AccessedFrom[j] == line.Split(' ')[posClient])
																		{
																			postings[i].HitCount[j]++;
																			isFound= true;
																		}
																	}
																	else
																	{
																		if(postings[i].AccessedFrom[j] == "N/A")
																		{
																			postings[i].HitCount[j]++;
																			isFound= true;
																		}
																	}
																}
															}
															else
															{
																if(postings[i].AccessedOnTime[j] == "N/A")
																{
																	if(posClient!=-1)
																	{
																		if(postings[i].AccessedFrom[j] == line.Split(' ')[posClient])
																		{
																			postings[i].HitCount[j]++;
																			isFound= true;
																		}
																	}
																	else
																	{
																		if(postings[i].AccessedFrom[j] == "N/A")
																		{
																			postings[i].HitCount[j]++;
																			isFound= true;
																		}
																	
																	}
																}
															
															}
														}
													
													}
												}
											}
										}
										if(!isFound)
										{
											if(postings[i].AccessedBy[postings[i].AccessedBy.Length-1]!=null && postings[i].AccessedBy[postings[i].AccessedBy.Length-1]=="N/A")
											{
												if(posUser!=-1)
												{
													string test = line.Split(' ')[posUser];
													postings[i].AccessedBy[postings[i].AccessedBy.Length-1] = line.Split(' ')[posUser];
												}
												if(posDate!=-1)
												{
													postings[i].AccessedOnDate[postings[i].AccessedBy.Length-1] = line.Split(' ')[posDate];
												}
												if(posTime!=-1)
												{
													postings[i].AccessedOnTime[postings[i].AccessedBy.Length-1] = line.Split(' ')[posTime];
												}
												if(posClient!=-1)
												{
													postings[i].AccessedFrom[postings[i].AccessedBy.Length-1] = line.Split(' ')[posClient];
												}
												postings[i].HitCount[postings[i].AccessedBy.Length-1]++;
											}
											else
											{
												int count = postings[i].AccessedBy.Length;
												string[] tempChange = new string[count];
												for(int k =0;k<count;k++)
												{
													tempChange[k] = postings[i].AccessedBy[k];
												}
												postings[i].AccessedBy = new string[count+1];
												for(int k =0;k<count;k++)
												{
													postings[i].AccessedBy[k] = tempChange[k];
												}
												if(posUser!=-1)
												{
													postings[i].AccessedBy[count] = line.Split(' ')[posUser];
												}
												else
												{
													postings[i].AccessedBy[count] = "N/A";
												}
												tempChange = new string[count];
												for(int k =0;k<count;k++)
												{
													tempChange[k] = postings[i].AccessedOnDate[k];
												}
												postings[i].AccessedOnDate = new string[count+1];
												for(int k =0;k<count;k++)
												{
													postings[i].AccessedOnDate[k] = tempChange[k];
												}
												if(posDate!=-1)
												{
													postings[i].AccessedOnDate[count] = line.Split(' ')[posDate];
												}
												else
												{
													postings[i].AccessedOnDate[count] = "N/A";
												}

												tempChange = new string[count];
												for(int k =0;k<count;k++)
												{
													tempChange[k] = postings[i].AccessedOnTime[k];
												}
												postings[i].AccessedOnTime = new string[count+1];
												for(int k =0;k<count;k++)
												{
													postings[i].AccessedOnTime[k] = tempChange[k];
												}
												if(posTime!=-1)
												{
													postings[i].AccessedOnTime[count] = line.Split(' ')[posTime];
												}
												else
												{
													postings[i].AccessedOnTime[count] = "N/A";
												}
												for(int k =0;k<count;k++)
												{
													tempChange[k] = postings[i].AccessedFrom[k];
												}
												postings[i].AccessedFrom = new string[count+1];
												for(int k =0;k<count;k++)
												{
													postings[i].AccessedFrom[k] = tempChange[k];
												}
												if(posClient!=-1)
												{
													postings[i].AccessedFrom[count] = line.Split(' ')[posClient];
												}
												else
												{
													postings[i].AccessedFrom[count] = "N/A";
												}

												int[] tempHit = new int[count];
												for(int k =0;k<count;k++)
												{
													tempHit[k] = postings[i].HitCount[k];
												}
												postings[i].HitCount = new int[count+1];
												for(int k =0;k<count;k++)
												{
													postings[i].HitCount[k] = tempHit[k];
												}
												postings[i].HitCount[count] = 1;

											}
										}
									}
								}
							}
						}
						this.progressBar.Increment(1);
						this.statusBar.Panels[0].Text = text + ", Line : " + currentLine.ToString();
					}
					else
					{
						//stoped clicked. so stop.
						generateButton = true;
						this.progressBar.Value = 0;
						this.buttonGenerate.Text = "Generate Statistics";
						this.statusBar.Panels[0].Text = "Report generation canceled by the user";
						this.buttonExit.Enabled = true;
						this.buttonGenerate.Enabled = true;
						this.buttonFiles.Enabled = true;
						this.buttonSave.Enabled = true;
						this.comboBoxPosting.Enabled = true;
						sr.Close();
						return;
					}
				}
				sr.Close();
			}
			catch(Exception ex)
			{
				MessageBox.Show("Error while analyzing the MCMS log file. Thrown exception was : " + ex.Message , " Error",MessageBoxButtons.OK, MessageBoxIcon.Error);
				generateButton = true;
				this.progressBar.Value = 0;
				this.buttonGenerate.Text = "Generate Statistics";
				this.statusBar.Panels[0].Text = "While generating statistics an error occured";
				this.buttonExit.Enabled = true;
				this.buttonGenerate.Enabled = true;
				this.buttonFiles.Enabled = true;
				this.buttonSave.Enabled = true;
				this.comboBoxPosting.Enabled = true;
				sr.Close();
			}
		}

		#endregion

		#region Save the log file
		private void buttonSave_Click(object sender, System.EventArgs e)
		{
			StreamWriter sw = null;
			try
			{
				DialogResult result = saveFileDialog.ShowDialog();
				if(result!=DialogResult.Cancel)
				{
					sw = new StreamWriter(saveFileDialog.FileName,true);
					sw.WriteLine("#Software: MCMS Manager 1.2");
					sw.WriteLine("#Date: "+DateTime.Now);
					sw.WriteLine("#Fields: name channel guid user date time state hit created expired accessedby accessedfrom");
					for(int i=0;i<postings.Count;i++)
					{
						for(int j=0;j<postings[i].AccessedBy.Length;j++)
						{
							sw.WriteLine(postings[i].Name.Replace(" ","")+" "+postings[i].ChannelName.Replace(" ","")+" "+postings[i].Guid.Replace(" ","")+" "+postings[i].AccessedBy[j].Replace(" ","")+" "+postings[i].AccessedOnDate[j].Replace(" ","")+" "+postings[i].AccessedOnTime[j].Replace(" ","")+" "+postings[i].CmsPostingState.ToString().Replace(" ","")+" "+postings[i].HitCount[j].ToString().Replace(" ","")+" "+postings[i].CreatedOn.ToShortDateString().Replace(" ","")+" "+postings[i].ExpiredOn.ToShortDateString().Replace(" ","")+" "+postings[i].AccessedBy[j].Replace(" ","") +" "+postings[i].AccessedFrom[j].Replace(" ",""));
						}
					}
					sw.Close();
					MessageBox.Show("File saved successfully" , " Saved",MessageBoxButtons.OK, MessageBoxIcon.Information);
				}
			}
			catch(Exception ex)
			{
				sw.Close();
				MessageBox.Show("Error while saving the log file. Thrown exception was : " + ex.Message , " Error",MessageBoxButtons.OK, MessageBoxIcon.Error);
			}
		}
		#endregion

	}
}
