/**
 * @file FormUserGroup.cs
 *
 * MCMS Manager
 *
 * MCMS Manager is the legal property of its developer
 * Chester Ragel <chesterr@gmail.com> - Developer and Maintainer
 * Yahoo ID : chesterr1979 
 * MSN : chesterr79@hotmail.com
 *
 * If you want more information, found any bugs or have any doubts you 
 * can mail me or contact me through my yahoo id.
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2.1 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#region Namespaces
using System;
using System.Drawing;
using System.Collections;
using System.ComponentModel;
using System.Windows.Forms;
using System.Text.RegularExpressions;
using System.IO;
using System.Xml;
//MCMS components
using Microsoft.ContentManagement.Common;
using Microsoft.ContentManagement.Publishing;
#endregion

namespace MCMS
{
	/// <summary>
	/// Summary description for FormUserGroup.
	/// </summary>
	public class FormUserGroup : System.Windows.Forms.Form
	{

		#region Private Controls

		private System.Windows.Forms.MenuItem menuItemFile;
		private System.Windows.Forms.MenuItem menuItemOpen;
		private System.Windows.Forms.MenuItem menuItemSave;
		private System.Windows.Forms.MenuItem menuItem4;
		private System.Windows.Forms.MenuItem menuItemExit;
		private System.Windows.Forms.MenuItem menuItemNew;
		private System.Windows.Forms.GroupBox groupBoxAuthentication;
		private System.Windows.Forms.Label labelPassword;
		private System.Windows.Forms.TextBox textBoxUserName;
		private System.Windows.Forms.Label labelUserName;
		private System.Windows.Forms.Label label3;
		private System.Windows.Forms.Label label2;
		private System.Windows.Forms.RadioButton radioButtonAuthenticateAsCurrentUser;
		private System.Windows.Forms.RadioButton radioButtonAuthenticateAsUser;
		private System.Windows.Forms.GroupBox groupBoxServerClient;
		private System.Windows.Forms.Label labelClient2;
		private System.Windows.Forms.Label labelClient1;
		private System.Windows.Forms.Label labelServer;
		private System.Windows.Forms.RadioButton radioButtonServer;
		private System.Windows.Forms.RadioButton radioButtonClient;
		private System.Windows.Forms.TabControl tabControl;
		private System.Windows.Forms.TabPage tabPageAuthentication;
		private System.Windows.Forms.TabPage tabPageScript;
		private System.Windows.Forms.TabPage tabPageOptions;
		private System.Windows.Forms.GroupBox groupBoxBR;
		private System.Windows.Forms.RadioButton radioButtonBackup;
		private System.Windows.Forms.RadioButton radioButtonRestore;
		private System.Windows.Forms.Label label4;
		private System.Windows.Forms.Label label5;
		private System.Windows.Forms.CheckBox checkBoxRemoveUsers;
		private System.Windows.Forms.Label label6;
		private System.Windows.Forms.Label labelFileName;
		private System.Windows.Forms.TextBox textBoxFileName;
		private System.Windows.Forms.Button buttonBrowse;
		private System.Windows.Forms.Button buttonGenerate;
		private System.Windows.Forms.MainMenu mainMenu;
		private System.Windows.Forms.TextBox textBoxServer;
		private System.Windows.Forms.Label labelServerUrl;
		private System.Windows.Forms.TabPage tabPageMoreOptions;
		private System.Windows.Forms.Label label9;
		private System.Windows.Forms.Label labelSDO;
		private System.Windows.Forms.Button buttonSDO;
		private System.Windows.Forms.TextBox textBoxSDO;
		private System.Windows.Forms.Label labelReport;
		private System.Windows.Forms.Button buttonReport;
		private System.Windows.Forms.TextBox textBoxReport;
		private System.Windows.Forms.FolderBrowserDialog folderBrowserDialog;
		private System.Windows.Forms.SaveFileDialog saveFileDialogsdo;
		private System.Windows.Forms.OpenFileDialog openFileDialogXml;
		private System.Windows.Forms.SaveFileDialog saveFileDialogXml;
		private System.Windows.Forms.SaveFileDialog saveFileDialogReport;
		private System.Windows.Forms.SaveFileDialog saveFileDialog;
		/// <summary>
		/// Required designer variable.
		/// </summary>
		private System.ComponentModel.Container components = null;

		#endregion

		#region Private Variables
		
		private bool isDirty = false;
		private bool isOpened = false;
		private CmsUserGroup cmsUserGroup = new CmsUserGroup();
		private XmlDocument xmlDocument;
		private System.Windows.Forms.TextBox textBoxPassword;
		private System.Windows.Forms.Label label8;
		private System.Windows.Forms.Label labelSDOArchive;
		private System.Windows.Forms.Button buttonSDOArchive;
		private System.Windows.Forms.TextBox textBoxSDOArchive;

		private CmsApplicationContext cmsApplicationContext = new CmsApplicationContext();

		#endregion

		#region Init/Dispose

		public FormUserGroup()
		{
			InitializeComponent();
			Init();
			InitNew();
		}

		/// <summary>
		/// Clean up any resources being used.
		/// </summary>
		protected override void Dispose( bool disposing )
		{
			if( disposing )
			{
				if(components != null)
				{
					components.Dispose();
				}
			}
			base.Dispose( disposing );
		}

		private void textBoxUserName_TextChanged(object sender, System.EventArgs e)
		{
			isDirty = true;
		}

		private void textBoxPassword_TextChanged(object sender, System.EventArgs e)
		{
			isDirty = true;
		}

		#region Windows Form Designer generated code
		/// <summary>
		/// Required method for Designer support - do not modify
		/// the contents of this method with the code editor.
		/// </summary>
		private void InitializeComponent()
		{
			System.Resources.ResourceManager resources = new System.Resources.ResourceManager(typeof(FormUserGroup));
			this.labelFileName = new System.Windows.Forms.Label();
			this.textBoxFileName = new System.Windows.Forms.TextBox();
			this.buttonBrowse = new System.Windows.Forms.Button();
			this.buttonGenerate = new System.Windows.Forms.Button();
			this.tabControl = new System.Windows.Forms.TabControl();
			this.tabPageAuthentication = new System.Windows.Forms.TabPage();
			this.groupBoxAuthentication = new System.Windows.Forms.GroupBox();
			this.textBoxPassword = new System.Windows.Forms.TextBox();
			this.labelPassword = new System.Windows.Forms.Label();
			this.textBoxUserName = new System.Windows.Forms.TextBox();
			this.labelUserName = new System.Windows.Forms.Label();
			this.label3 = new System.Windows.Forms.Label();
			this.label2 = new System.Windows.Forms.Label();
			this.radioButtonAuthenticateAsCurrentUser = new System.Windows.Forms.RadioButton();
			this.radioButtonAuthenticateAsUser = new System.Windows.Forms.RadioButton();
			this.tabPageOptions = new System.Windows.Forms.TabPage();
			this.groupBoxBR = new System.Windows.Forms.GroupBox();
			this.label6 = new System.Windows.Forms.Label();
			this.label5 = new System.Windows.Forms.Label();
			this.label4 = new System.Windows.Forms.Label();
			this.checkBoxRemoveUsers = new System.Windows.Forms.CheckBox();
			this.radioButtonRestore = new System.Windows.Forms.RadioButton();
			this.radioButtonBackup = new System.Windows.Forms.RadioButton();
			this.tabPageScript = new System.Windows.Forms.TabPage();
			this.groupBoxServerClient = new System.Windows.Forms.GroupBox();
			this.labelServerUrl = new System.Windows.Forms.Label();
			this.textBoxServer = new System.Windows.Forms.TextBox();
			this.labelClient2 = new System.Windows.Forms.Label();
			this.labelClient1 = new System.Windows.Forms.Label();
			this.labelServer = new System.Windows.Forms.Label();
			this.radioButtonServer = new System.Windows.Forms.RadioButton();
			this.radioButtonClient = new System.Windows.Forms.RadioButton();
			this.tabPageMoreOptions = new System.Windows.Forms.TabPage();
			this.label8 = new System.Windows.Forms.Label();
			this.labelSDOArchive = new System.Windows.Forms.Label();
			this.buttonSDOArchive = new System.Windows.Forms.Button();
			this.textBoxSDOArchive = new System.Windows.Forms.TextBox();
			this.label9 = new System.Windows.Forms.Label();
			this.labelSDO = new System.Windows.Forms.Label();
			this.buttonSDO = new System.Windows.Forms.Button();
			this.textBoxSDO = new System.Windows.Forms.TextBox();
			this.labelReport = new System.Windows.Forms.Label();
			this.buttonReport = new System.Windows.Forms.Button();
			this.textBoxReport = new System.Windows.Forms.TextBox();
			this.mainMenu = new System.Windows.Forms.MainMenu();
			this.menuItemFile = new System.Windows.Forms.MenuItem();
			this.menuItemNew = new System.Windows.Forms.MenuItem();
			this.menuItemOpen = new System.Windows.Forms.MenuItem();
			this.menuItemSave = new System.Windows.Forms.MenuItem();
			this.menuItem4 = new System.Windows.Forms.MenuItem();
			this.menuItemExit = new System.Windows.Forms.MenuItem();
			this.folderBrowserDialog = new System.Windows.Forms.FolderBrowserDialog();
			this.saveFileDialogsdo = new System.Windows.Forms.SaveFileDialog();
			this.openFileDialogXml = new System.Windows.Forms.OpenFileDialog();
			this.saveFileDialogXml = new System.Windows.Forms.SaveFileDialog();
			this.saveFileDialogReport = new System.Windows.Forms.SaveFileDialog();
			this.saveFileDialog = new System.Windows.Forms.SaveFileDialog();
			this.tabControl.SuspendLayout();
			this.tabPageAuthentication.SuspendLayout();
			this.groupBoxAuthentication.SuspendLayout();
			this.tabPageOptions.SuspendLayout();
			this.groupBoxBR.SuspendLayout();
			this.tabPageScript.SuspendLayout();
			this.groupBoxServerClient.SuspendLayout();
			this.tabPageMoreOptions.SuspendLayout();
			this.SuspendLayout();
			// 
			// labelFileName
			// 
			this.labelFileName.Location = new System.Drawing.Point(13, 298);
			this.labelFileName.Name = "labelFileName";
			this.labelFileName.Size = new System.Drawing.Size(168, 23);
			this.labelFileName.TabIndex = 1;
			this.labelFileName.Text = "Backup/Restore Script Name";
			// 
			// textBoxFileName
			// 
			this.textBoxFileName.Location = new System.Drawing.Point(160, 296);
			this.textBoxFileName.Name = "textBoxFileName";
			this.textBoxFileName.ReadOnly = true;
			this.textBoxFileName.Size = new System.Drawing.Size(176, 20);
			this.textBoxFileName.TabIndex = 1;
			this.textBoxFileName.Text = "";
			// 
			// buttonBrowse
			// 
			this.buttonBrowse.Location = new System.Drawing.Point(344, 296);
			this.buttonBrowse.Name = "buttonBrowse";
			this.buttonBrowse.TabIndex = 2;
			this.buttonBrowse.Text = "Browse...";
			this.buttonBrowse.Click += new System.EventHandler(this.buttonBrowse_Click);
			// 
			// buttonGenerate
			// 
			this.buttonGenerate.Location = new System.Drawing.Point(432, 296);
			this.buttonGenerate.Name = "buttonGenerate";
			this.buttonGenerate.TabIndex = 3;
			this.buttonGenerate.Text = "Generate";
			this.buttonGenerate.Click += new System.EventHandler(this.buttonGenerate_Click);
			// 
			// tabControl
			// 
			this.tabControl.Controls.Add(this.tabPageAuthentication);
			this.tabControl.Controls.Add(this.tabPageOptions);
			this.tabControl.Controls.Add(this.tabPageScript);
			this.tabControl.Controls.Add(this.tabPageMoreOptions);
			this.tabControl.Dock = System.Windows.Forms.DockStyle.Top;
			this.tabControl.Location = new System.Drawing.Point(0, 0);
			this.tabControl.Name = "tabControl";
			this.tabControl.SelectedIndex = 0;
			this.tabControl.Size = new System.Drawing.Size(512, 280);
			this.tabControl.TabIndex = 0;
			// 
			// tabPageAuthentication
			// 
			this.tabPageAuthentication.Controls.Add(this.groupBoxAuthentication);
			this.tabPageAuthentication.Location = new System.Drawing.Point(4, 22);
			this.tabPageAuthentication.Name = "tabPageAuthentication";
			this.tabPageAuthentication.Size = new System.Drawing.Size(504, 254);
			this.tabPageAuthentication.TabIndex = 0;
			this.tabPageAuthentication.Text = "Authentication";
			// 
			// groupBoxAuthentication
			// 
			this.groupBoxAuthentication.Controls.Add(this.textBoxPassword);
			this.groupBoxAuthentication.Controls.Add(this.labelPassword);
			this.groupBoxAuthentication.Controls.Add(this.textBoxUserName);
			this.groupBoxAuthentication.Controls.Add(this.labelUserName);
			this.groupBoxAuthentication.Controls.Add(this.label3);
			this.groupBoxAuthentication.Controls.Add(this.label2);
			this.groupBoxAuthentication.Controls.Add(this.radioButtonAuthenticateAsCurrentUser);
			this.groupBoxAuthentication.Controls.Add(this.radioButtonAuthenticateAsUser);
			this.groupBoxAuthentication.Location = new System.Drawing.Point(8, 8);
			this.groupBoxAuthentication.Name = "groupBoxAuthentication";
			this.groupBoxAuthentication.Size = new System.Drawing.Size(488, 240);
			this.groupBoxAuthentication.TabIndex = 0;
			this.groupBoxAuthentication.TabStop = false;
			this.groupBoxAuthentication.Text = "Authentication Type";
			// 
			// textBoxPassword
			// 
			this.textBoxPassword.Location = new System.Drawing.Point(176, 208);
			this.textBoxPassword.Name = "textBoxPassword";
			this.textBoxPassword.PasswordChar = '*';
			this.textBoxPassword.Size = new System.Drawing.Size(152, 20);
			this.textBoxPassword.TabIndex = 3;
			this.textBoxPassword.Text = "";
			this.textBoxPassword.TextChanged += new System.EventHandler(this.textBoxPassword_TextChanged);
			// 
			// labelPassword
			// 
			this.labelPassword.Location = new System.Drawing.Point(16, 208);
			this.labelPassword.Name = "labelPassword";
			this.labelPassword.TabIndex = 7;
			this.labelPassword.Text = "Password";
			// 
			// textBoxUserName
			// 
			this.textBoxUserName.Location = new System.Drawing.Point(176, 168);
			this.textBoxUserName.Name = "textBoxUserName";
			this.textBoxUserName.Size = new System.Drawing.Size(192, 20);
			this.textBoxUserName.TabIndex = 2;
			this.textBoxUserName.Text = "";
			this.textBoxUserName.TextChanged += new System.EventHandler(this.textBoxUserName_TextChanged);
			// 
			// labelUserName
			// 
			this.labelUserName.Location = new System.Drawing.Point(16, 168);
			this.labelUserName.Name = "labelUserName";
			this.labelUserName.Size = new System.Drawing.Size(192, 32);
			this.labelUserName.TabIndex = 5;
			this.labelUserName.Text = "User Name (WinNT://domain/username)";
			// 
			// label3
			// 
			this.label3.Location = new System.Drawing.Point(16, 128);
			this.label3.Name = "label3";
			this.label3.Size = new System.Drawing.Size(464, 32);
			this.label3.TabIndex = 4;
			this.label3.Text = "Establishes the specified user account as the account to use for an upcoming expo" +
				"rt operation.";
			// 
			// label2
			// 
			this.label2.Location = new System.Drawing.Point(16, 56);
			this.label2.Name = "label2";
			this.label2.Size = new System.Drawing.Size(456, 32);
			this.label2.TabIndex = 3;
			this.label2.Text = "Establishes the user account under which the script is running as the account to " +
				"use for an upcoming export operation.";
			// 
			// radioButtonAuthenticateAsCurrentUser
			// 
			this.radioButtonAuthenticateAsCurrentUser.Location = new System.Drawing.Point(16, 24);
			this.radioButtonAuthenticateAsCurrentUser.Name = "radioButtonAuthenticateAsCurrentUser";
			this.radioButtonAuthenticateAsCurrentUser.Size = new System.Drawing.Size(160, 24);
			this.radioButtonAuthenticateAsCurrentUser.TabIndex = 0;
			this.radioButtonAuthenticateAsCurrentUser.Text = "AuthenticateAsCurrentUser";
			this.radioButtonAuthenticateAsCurrentUser.CheckedChanged += new System.EventHandler(this.radioButtonAuthenticateAsCurrentUser_CheckedChanged);
			// 
			// radioButtonAuthenticateAsUser
			// 
			this.radioButtonAuthenticateAsUser.Location = new System.Drawing.Point(16, 96);
			this.radioButtonAuthenticateAsUser.Name = "radioButtonAuthenticateAsUser";
			this.radioButtonAuthenticateAsUser.Size = new System.Drawing.Size(192, 24);
			this.radioButtonAuthenticateAsUser.TabIndex = 1;
			this.radioButtonAuthenticateAsUser.Text = "AuthenticateAsUser";
			this.radioButtonAuthenticateAsUser.CheckedChanged += new System.EventHandler(this.radioButtonAuthenticateAsUser_CheckedChanged);
			// 
			// tabPageOptions
			// 
			this.tabPageOptions.Controls.Add(this.groupBoxBR);
			this.tabPageOptions.Location = new System.Drawing.Point(4, 22);
			this.tabPageOptions.Name = "tabPageOptions";
			this.tabPageOptions.Size = new System.Drawing.Size(504, 254);
			this.tabPageOptions.TabIndex = 2;
			this.tabPageOptions.Text = "Options";
			// 
			// groupBoxBR
			// 
			this.groupBoxBR.Controls.Add(this.label6);
			this.groupBoxBR.Controls.Add(this.label5);
			this.groupBoxBR.Controls.Add(this.label4);
			this.groupBoxBR.Controls.Add(this.checkBoxRemoveUsers);
			this.groupBoxBR.Controls.Add(this.radioButtonRestore);
			this.groupBoxBR.Controls.Add(this.radioButtonBackup);
			this.groupBoxBR.Location = new System.Drawing.Point(8, 8);
			this.groupBoxBR.Name = "groupBoxBR";
			this.groupBoxBR.Size = new System.Drawing.Size(488, 240);
			this.groupBoxBR.TabIndex = 0;
			this.groupBoxBR.TabStop = false;
			this.groupBoxBR.Text = "Backup / Restore";
			// 
			// label6
			// 
			this.label6.Location = new System.Drawing.Point(40, 200);
			this.label6.Name = "label6";
			this.label6.Size = new System.Drawing.Size(440, 32);
			this.label6.TabIndex = 5;
			this.label6.Text = "Whether all existing user lists from all rights groups (other than the MCMS admin" +
				"istrators rights group) are removed before the restore operation is performed.";
			// 
			// label5
			// 
			this.label5.Location = new System.Drawing.Point(16, 128);
			this.label5.Name = "label5";
			this.label5.Size = new System.Drawing.Size(456, 40);
			this.label5.TabIndex = 4;
			this.label5.Text = "Restores the rights groups and their user lists previously backed up to a Site De" +
				"ployment Object (SDO) file.";
			// 
			// label4
			// 
			this.label4.Location = new System.Drawing.Point(16, 48);
			this.label4.Name = "label4";
			this.label4.Size = new System.Drawing.Size(456, 48);
			this.label4.TabIndex = 3;
			this.label4.Text = "Backs up the rights groups and their user lists into a Site Deployment Object (SD" +
				"O) file that can be restored to the same server at a later time, or restored to " +
				"one or more different servers.";
			// 
			// checkBoxRemoveUsers
			// 
			this.checkBoxRemoveUsers.Location = new System.Drawing.Point(40, 168);
			this.checkBoxRemoveUsers.Name = "checkBoxRemoveUsers";
			this.checkBoxRemoveUsers.Size = new System.Drawing.Size(128, 24);
			this.checkBoxRemoveUsers.TabIndex = 2;
			this.checkBoxRemoveUsers.Text = "RemoveUsers";
			this.checkBoxRemoveUsers.CheckedChanged += new System.EventHandler(this.checkBoxRemoveUsers_CheckedChanged);
			// 
			// radioButtonRestore
			// 
			this.radioButtonRestore.Location = new System.Drawing.Point(16, 96);
			this.radioButtonRestore.Name = "radioButtonRestore";
			this.radioButtonRestore.TabIndex = 1;
			this.radioButtonRestore.Text = "Restore";
			this.radioButtonRestore.CheckedChanged += new System.EventHandler(this.radioButtonRestore_CheckedChanged);
			// 
			// radioButtonBackup
			// 
			this.radioButtonBackup.Location = new System.Drawing.Point(16, 24);
			this.radioButtonBackup.Name = "radioButtonBackup";
			this.radioButtonBackup.TabIndex = 0;
			this.radioButtonBackup.Text = "Backup";
			this.radioButtonBackup.CheckedChanged += new System.EventHandler(this.radioButtonBackup_CheckedChanged);
			// 
			// tabPageScript
			// 
			this.tabPageScript.Controls.Add(this.groupBoxServerClient);
			this.tabPageScript.Location = new System.Drawing.Point(4, 22);
			this.tabPageScript.Name = "tabPageScript";
			this.tabPageScript.Size = new System.Drawing.Size(504, 254);
			this.tabPageScript.TabIndex = 1;
			this.tabPageScript.Text = "Script Type";
			// 
			// groupBoxServerClient
			// 
			this.groupBoxServerClient.Controls.Add(this.labelServerUrl);
			this.groupBoxServerClient.Controls.Add(this.textBoxServer);
			this.groupBoxServerClient.Controls.Add(this.labelClient2);
			this.groupBoxServerClient.Controls.Add(this.labelClient1);
			this.groupBoxServerClient.Controls.Add(this.labelServer);
			this.groupBoxServerClient.Controls.Add(this.radioButtonServer);
			this.groupBoxServerClient.Controls.Add(this.radioButtonClient);
			this.groupBoxServerClient.Location = new System.Drawing.Point(8, 8);
			this.groupBoxServerClient.Name = "groupBoxServerClient";
			this.groupBoxServerClient.Size = new System.Drawing.Size(488, 240);
			this.groupBoxServerClient.TabIndex = 4;
			this.groupBoxServerClient.TabStop = false;
			this.groupBoxServerClient.Text = "Client Site / Server Site";
			// 
			// labelServerUrl
			// 
			this.labelServerUrl.Location = new System.Drawing.Point(48, 208);
			this.labelServerUrl.Name = "labelServerUrl";
			this.labelServerUrl.Size = new System.Drawing.Size(64, 23);
			this.labelServerUrl.TabIndex = 8;
			this.labelServerUrl.Text = "Server URL";
			// 
			// textBoxServer
			// 
			this.textBoxServer.Location = new System.Drawing.Point(128, 208);
			this.textBoxServer.Name = "textBoxServer";
			this.textBoxServer.Size = new System.Drawing.Size(208, 20);
			this.textBoxServer.TabIndex = 7;
			this.textBoxServer.Text = "";
			this.textBoxServer.TextChanged += new System.EventHandler(this.textBoxServer_TextChanged);
			// 
			// labelClient2
			// 
			this.labelClient2.Location = new System.Drawing.Point(16, 176);
			this.labelClient2.Name = "labelClient2";
			this.labelClient2.Size = new System.Drawing.Size(456, 23);
			this.labelClient2.TabIndex = 6;
			this.labelClient2.Text = "Access between server and client is provided using the HTTP or HTTPS protocol. ";
			// 
			// labelClient1
			// 
			this.labelClient1.Location = new System.Drawing.Point(16, 136);
			this.labelClient1.Name = "labelClient1";
			this.labelClient1.Size = new System.Drawing.Size(456, 32);
			this.labelClient1.TabIndex = 5;
			this.labelClient1.Text = "The client-side objects of the site deployment API are intended for use in script" +
				"s running remotely on an MCMS client. ";
			// 
			// labelServer
			// 
			this.labelServer.Location = new System.Drawing.Point(16, 64);
			this.labelServer.Name = "labelServer";
			this.labelServer.Size = new System.Drawing.Size(464, 32);
			this.labelServer.TabIndex = 4;
			this.labelServer.Text = "The server-side objects of the site deployment API are intended for use in script" +
				"s running locally on an MCMS server. ";
			// 
			// radioButtonServer
			// 
			this.radioButtonServer.Location = new System.Drawing.Point(16, 32);
			this.radioButtonServer.Name = "radioButtonServer";
			this.radioButtonServer.Size = new System.Drawing.Size(152, 32);
			this.radioButtonServer.TabIndex = 0;
			this.radioButtonServer.Text = "Server-side";
			this.radioButtonServer.CheckedChanged += new System.EventHandler(this.radioButtonServer_CheckedChanged);
			// 
			// radioButtonClient
			// 
			this.radioButtonClient.Location = new System.Drawing.Point(16, 104);
			this.radioButtonClient.Name = "radioButtonClient";
			this.radioButtonClient.TabIndex = 2;
			this.radioButtonClient.Text = "Client-side";
			this.radioButtonClient.CheckedChanged += new System.EventHandler(this.radioButtonClient_CheckedChanged);
			// 
			// tabPageMoreOptions
			// 
			this.tabPageMoreOptions.Controls.Add(this.label8);
			this.tabPageMoreOptions.Controls.Add(this.labelSDOArchive);
			this.tabPageMoreOptions.Controls.Add(this.buttonSDOArchive);
			this.tabPageMoreOptions.Controls.Add(this.textBoxSDOArchive);
			this.tabPageMoreOptions.Controls.Add(this.label9);
			this.tabPageMoreOptions.Controls.Add(this.labelSDO);
			this.tabPageMoreOptions.Controls.Add(this.buttonSDO);
			this.tabPageMoreOptions.Controls.Add(this.textBoxSDO);
			this.tabPageMoreOptions.Controls.Add(this.labelReport);
			this.tabPageMoreOptions.Controls.Add(this.buttonReport);
			this.tabPageMoreOptions.Controls.Add(this.textBoxReport);
			this.tabPageMoreOptions.Location = new System.Drawing.Point(4, 22);
			this.tabPageMoreOptions.Name = "tabPageMoreOptions";
			this.tabPageMoreOptions.Size = new System.Drawing.Size(504, 254);
			this.tabPageMoreOptions.TabIndex = 3;
			this.tabPageMoreOptions.Text = "More Options";
			// 
			// label8
			// 
			this.label8.Location = new System.Drawing.Point(8, 104);
			this.label8.Name = "label8";
			this.label8.Size = new System.Drawing.Size(480, 32);
			this.label8.TabIndex = 43;
			this.label8.Text = "Place of the sdo archive folder, where it should be placed for backup - later use" +
				". This is usually a local folder.";
			// 
			// labelSDOArchive
			// 
			this.labelSDOArchive.Location = new System.Drawing.Point(8, 72);
			this.labelSDOArchive.Name = "labelSDOArchive";
			this.labelSDOArchive.Size = new System.Drawing.Size(92, 32);
			this.labelSDOArchive.TabIndex = 42;
			this.labelSDOArchive.Text = "SDO Archive folder";
			// 
			// buttonSDOArchive
			// 
			this.buttonSDOArchive.Location = new System.Drawing.Point(420, 72);
			this.buttonSDOArchive.Name = "buttonSDOArchive";
			this.buttonSDOArchive.TabIndex = 41;
			this.buttonSDOArchive.Text = "Browse...";
			this.buttonSDOArchive.Click += new System.EventHandler(this.buttonSDOArchive_Click);
			// 
			// textBoxSDOArchive
			// 
			this.textBoxSDOArchive.Location = new System.Drawing.Point(108, 72);
			this.textBoxSDOArchive.Name = "textBoxSDOArchive";
			this.textBoxSDOArchive.Size = new System.Drawing.Size(296, 20);
			this.textBoxSDOArchive.TabIndex = 40;
			this.textBoxSDOArchive.Text = "";
			// 
			// label9
			// 
			this.label9.Location = new System.Drawing.Point(8, 200);
			this.label9.Name = "label9";
			this.label9.Size = new System.Drawing.Size(480, 32);
			this.label9.TabIndex = 39;
			this.label9.Text = "With the import/export, a report will be generated (This file will contain the im" +
				"port/export information and errors occured).";
			// 
			// labelSDO
			// 
			this.labelSDO.Location = new System.Drawing.Point(8, 18);
			this.labelSDO.Name = "labelSDO";
			this.labelSDO.Size = new System.Drawing.Size(96, 16);
			this.labelSDO.TabIndex = 37;
			this.labelSDO.Text = "SDO file";
			// 
			// buttonSDO
			// 
			this.buttonSDO.Location = new System.Drawing.Point(422, 15);
			this.buttonSDO.Name = "buttonSDO";
			this.buttonSDO.TabIndex = 1;
			this.buttonSDO.Text = "Browse...";
			this.buttonSDO.Click += new System.EventHandler(this.buttonSDO_Click);
			// 
			// textBoxSDO
			// 
			this.textBoxSDO.Location = new System.Drawing.Point(108, 16);
			this.textBoxSDO.Name = "textBoxSDO";
			this.textBoxSDO.Size = new System.Drawing.Size(296, 20);
			this.textBoxSDO.TabIndex = 0;
			this.textBoxSDO.Text = "";
			// 
			// labelReport
			// 
			this.labelReport.Location = new System.Drawing.Point(8, 160);
			this.labelReport.Name = "labelReport";
			this.labelReport.Size = new System.Drawing.Size(85, 16);
			this.labelReport.TabIndex = 34;
			this.labelReport.Text = "Report file";
			// 
			// buttonReport
			// 
			this.buttonReport.Location = new System.Drawing.Point(424, 160);
			this.buttonReport.Name = "buttonReport";
			this.buttonReport.TabIndex = 3;
			this.buttonReport.Text = "Browse...";
			this.buttonReport.Click += new System.EventHandler(this.buttonReport_Click);
			// 
			// textBoxReport
			// 
			this.textBoxReport.Location = new System.Drawing.Point(104, 160);
			this.textBoxReport.Name = "textBoxReport";
			this.textBoxReport.Size = new System.Drawing.Size(296, 20);
			this.textBoxReport.TabIndex = 2;
			this.textBoxReport.Text = "";
			// 
			// mainMenu
			// 
			this.mainMenu.MenuItems.AddRange(new System.Windows.Forms.MenuItem[] {
																					 this.menuItemFile});
			// 
			// menuItemFile
			// 
			this.menuItemFile.Index = 0;
			this.menuItemFile.MenuItems.AddRange(new System.Windows.Forms.MenuItem[] {
																						 this.menuItemNew,
																						 this.menuItemOpen,
																						 this.menuItemSave,
																						 this.menuItem4,
																						 this.menuItemExit});
			this.menuItemFile.Text = "&File";
			// 
			// menuItemNew
			// 
			this.menuItemNew.Index = 0;
			this.menuItemNew.Text = "&New";
			this.menuItemNew.Click += new System.EventHandler(this.menuItemNew_Click);
			// 
			// menuItemOpen
			// 
			this.menuItemOpen.Index = 1;
			this.menuItemOpen.Text = "&Open";
			this.menuItemOpen.Click += new System.EventHandler(this.menuItemOpen_Click);
			// 
			// menuItemSave
			// 
			this.menuItemSave.Index = 2;
			this.menuItemSave.Text = "&Save";
			this.menuItemSave.Click += new System.EventHandler(this.menuItemSave_Click);
			// 
			// menuItem4
			// 
			this.menuItem4.Index = 3;
			this.menuItem4.Text = "-";
			// 
			// menuItemExit
			// 
			this.menuItemExit.Index = 4;
			this.menuItemExit.Text = "E&xit";
			this.menuItemExit.Click += new System.EventHandler(this.menuItemExit_Click);
			// 
			// saveFileDialogsdo
			// 
			this.saveFileDialogsdo.Filter = "SDO files|*.sdo";
			this.saveFileDialogsdo.OverwritePrompt = false;
			// 
			// openFileDialogXml
			// 
			this.openFileDialogXml.Filter = "User Group Xml|*.xml";
			// 
			// saveFileDialogXml
			// 
			this.saveFileDialogXml.Filter = "User Group Xml|*.xml";
			// 
			// saveFileDialogReport
			// 
			this.saveFileDialogReport.Filter = "Report file|*.txt";
			// 
			// saveFileDialog
			// 
			this.saveFileDialog.Filter = "Vb Script|*.vbs";
			// 
			// FormUserGroup
			// 
			this.AutoScaleBaseSize = new System.Drawing.Size(5, 13);
			this.ClientSize = new System.Drawing.Size(512, 329);
			this.Controls.Add(this.tabControl);
			this.Controls.Add(this.buttonGenerate);
			this.Controls.Add(this.buttonBrowse);
			this.Controls.Add(this.textBoxFileName);
			this.Controls.Add(this.labelFileName);
			this.Icon = ((System.Drawing.Icon)(resources.GetObject("$this.Icon")));
			this.MaximizeBox = false;
			this.Menu = this.mainMenu;
			this.Name = "FormUserGroup";
			this.StartPosition = System.Windows.Forms.FormStartPosition.CenterScreen;
			this.Text = "User Group Backup / Restore - MCMS Manager";
			this.Closing += new System.ComponentModel.CancelEventHandler(this.FormUserGroup_Closing);
			this.tabControl.ResumeLayout(false);
			this.tabPageAuthentication.ResumeLayout(false);
			this.groupBoxAuthentication.ResumeLayout(false);
			this.tabPageOptions.ResumeLayout(false);
			this.groupBoxBR.ResumeLayout(false);
			this.tabPageScript.ResumeLayout(false);
			this.groupBoxServerClient.ResumeLayout(false);
			this.tabPageMoreOptions.ResumeLayout(false);
			this.ResumeLayout(false);

		}
		#endregion

		private void Init()
		{
			cmsApplicationContext.AuthenticateAsUser(FormMCMSManager.userName,FormMCMSManager.password,PublishingMode.Update);
		}
		private void MakeDefault()
		{
			this.radioButtonAuthenticateAsCurrentUser.Checked = true;
			this.textBoxUserName.Enabled = false;
			this.textBoxPassword.Enabled = false;
			this.radioButtonServer.Checked = true;
			this.buttonGenerate.Enabled = false;
			this.textBoxUserName.Text = "";
			this.textBoxPassword.Text = "";
			this.textBoxSDO.Text = "";
			this.textBoxReport.Text = "";
			this.radioButtonBackup.Checked = true;
			this.textBoxServer.Text = FormMCMSManager.serverName;
			this.checkBoxRemoveUsers.Enabled = false;
			isOpened = false;
			
		}

		private void menuItemNew_Click(object sender, System.EventArgs e)
		{
			if(isDirty)
			{
				DialogResult result = MessageBox.Show("Do you want to save?","Not saved",MessageBoxButtons.YesNo,MessageBoxIcon.Question);
				if(result == DialogResult.Yes)
				{
					Save();
				}
			}
			InitNew();
			isDirty = false;
		}

		private void menuItemOpen_Click(object sender, System.EventArgs e)
		{
			if(isDirty)
			{
				DialogResult result = MessageBox.Show("Do you want to save?","Not saved",MessageBoxButtons.YesNo,MessageBoxIcon.Question);
				if(result == DialogResult.Yes)
				{
					Save();
				}
			}
			InitOpen();
			isOpened = true;
		}

		private void InitOpen()
		{
			try
			{
				MakeDefault();
				cmsUserGroup = new CmsUserGroup();
				DialogResult result = openFileDialogXml.ShowDialog();
				if(result==DialogResult.OK)
				{
					xmlDocument = new XmlDocument();
					xmlDocument.Load(openFileDialogXml.FileName);
					XmlNodeList ele = xmlDocument.GetElementsByTagName("AuthenticationType");
					if(ele.Item(0).InnerText=="1")
					{
						cmsUserGroup.AuthenticationType = CmsAuthenticationType.AuthenticateAsCurrentUser;
						this.radioButtonAuthenticateAsCurrentUser.Checked = true;
						this.textBoxUserName.Enabled = false;
						this.textBoxPassword.Enabled = false;
					}
					else
					{
						cmsUserGroup.AuthenticationType = CmsAuthenticationType.AuthenticateAsUser;
						this.radioButtonAuthenticateAsUser.Checked = true;
						this.textBoxUserName.Enabled = true;
						this.textBoxPassword.Enabled = true;
					}
					ele = xmlDocument.GetElementsByTagName("ScriptType");
					if(ele.Item(0).InnerText=="1")
					{
						cmsUserGroup.ScriptType = CmsScriptType.ServerSide;
						this.radioButtonServer.Checked = true;
					}
					else
					{
						cmsUserGroup.ScriptType = CmsScriptType.ClientSide;
						this.radioButtonClient.Checked = true;
					}
					this.buttonGenerate.Enabled = false;
					
					ele = xmlDocument.GetElementsByTagName("ServerUrl");
					this.textBoxServer.Text = ele.Item(0).InnerText;
					cmsUserGroup.ServerUrl = ele.Item(0).InnerText;
					
					ele = xmlDocument.GetElementsByTagName("UserName");
					this.textBoxUserName.Text = ele.Item(0).InnerText;
					cmsUserGroup.UserName =  ele.Item(0).InnerText;
					
					ele = xmlDocument.GetElementsByTagName("Password");
					this.textBoxPassword.Text = ele.Item(0).InnerText;
					cmsUserGroup.Password =  ele.Item(0).InnerText;
					
					ele = xmlDocument.GetElementsByTagName("IsBackUp");
					if( ele.Item(0).InnerText=="True")
					{
						this.radioButtonBackup.Checked = true;
						this.checkBoxRemoveUsers.Enabled = false;
					}
					else
					{
						this.radioButtonRestore.Checked = true;
						this.checkBoxRemoveUsers.Enabled = true;
					}
					this.textBoxPassword.Text = ele.Item(0).InnerText;
					cmsUserGroup.Password =  ele.Item(0).InnerText;

					ele = xmlDocument.GetElementsByTagName("ReportFilePath");
					this.textBoxReport.Text = ele.Item(0).InnerText;
					cmsUserGroup.ReportFilePath =  ele.Item(0).InnerText;
					
					ele = xmlDocument.GetElementsByTagName("SDOFilePath");
					this.textBoxSDO.Text = ele.Item(0).InnerText;
					cmsUserGroup.SDOFilePath =  ele.Item(0).InnerText;

					ele = xmlDocument.GetElementsByTagName("SDOArchivePath");
					this.textBoxSDOArchive.Text = ele.Item(0).InnerText;
					cmsUserGroup.SDOArchivePath = ele.Item(0).InnerText;

					ele = xmlDocument.GetElementsByTagName("UserName");
					this.textBoxUserName.Text = ele.Item(0).InnerText;
					cmsUserGroup.UserName = ele.Item(0).InnerText;

					ele = xmlDocument.GetElementsByTagName("Password");
					this.textBoxPassword.Text = ele.Item(0).InnerText;
					cmsUserGroup.Password = ele.Item(0).InnerText;

					ele = xmlDocument.GetElementsByTagName("ScriptFile");
					this.textBoxFileName.Text = ele.Item(0).InnerText;
					cmsUserGroup.ScriptFile =  ele.Item(0).InnerText;

					this.buttonGenerate.Enabled = false;
					if(cmsUserGroup.ScriptFile!="")
					{
						this.buttonGenerate.Enabled = true;
					}

					isDirty = false;
				}
			}
			catch(Exception ex)
			{
				MessageBox.Show("While trying to open the document, an error occured. Error - "+ex.ToString(),"Error",MessageBoxButtons.OK,MessageBoxIcon.Error);
			}

		}

		private void InitNew()
		{
			MakeDefault();
			xmlDocument = new XmlDocument();
			xmlDocument.LoadXml("<UserGroup>" +
				"<AuthenticationType>1</AuthenticationType>" +
				"<SDOFilePath></SDOFilePath>" +
				"<SDOArchivePath></SDOArchivePath>" +
				"<ServerUrl>http://localhost</ServerUrl>" +
				"<ReportFilePath></ReportFilePath>" +
				"<ScriptType>1</ScriptType>" +
				"<IsBackUp>1</IsBackUp>" +
				"<UserName></UserName>" +
				"<Password></Password>" +
				"<ScriptFile></ScriptFile>" +
				"</UserGroup>");
			isDirty = false;
		}

		#endregion

		#region Script Generation

		private void menuItemSave_Click(object sender, System.EventArgs e)
		{
			if(Save())
			{
				MessageBox.Show("User Group Backup / Restore Xml file Saved","File Saved",MessageBoxButtons.OK,MessageBoxIcon.Information);
			}
		}

		private void menuItemExit_Click(object sender, System.EventArgs e)
		{
			if(isDirty)
			{
				DialogResult result = MessageBox.Show("Do you want to save?","Not saved",MessageBoxButtons.YesNo,MessageBoxIcon.Question);
				if(result == DialogResult.Yes)
				{
					Save();
				}
			}
			isDirty = false;
			this.Close();
		}

		private void radioButtonAuthenticateAsCurrentUser_CheckedChanged(object sender, System.EventArgs e)
		{
			if(!radioButtonAuthenticateAsCurrentUser.Checked)
			{
				this.textBoxUserName.Enabled = true;
				this.textBoxPassword.Enabled = true;
				cmsUserGroup.AuthenticationType = CmsAuthenticationType.AuthenticateAsUser;
			}
			else
			{
				this.textBoxUserName.Enabled = false;
				this.textBoxPassword.Enabled = false;
				cmsUserGroup.AuthenticationType = CmsAuthenticationType.AuthenticateAsCurrentUser;
			}
			isDirty = true;
		}

		private void radioButtonAuthenticateAsUser_CheckedChanged(object sender, System.EventArgs e)
		{
			if(radioButtonAuthenticateAsUser.Checked)
			{
				this.textBoxUserName.Enabled = true;
				this.textBoxPassword.Enabled = true;
				cmsUserGroup.AuthenticationType = CmsAuthenticationType.AuthenticateAsUser;
			}
			else
			{
				this.textBoxUserName.Enabled = false;
				this.textBoxPassword.Enabled = false;
				cmsUserGroup.AuthenticationType = CmsAuthenticationType.AuthenticateAsCurrentUser;
			}
			isDirty = true;
		}

		private void radioButtonServer_CheckedChanged(object sender, System.EventArgs e)
		{
			if(radioButtonServer.Checked)
			{
				cmsUserGroup.ScriptType = CmsScriptType.ServerSide;
				this.textBoxServer.Enabled = false;
			}
			else
			{
				cmsUserGroup.ScriptType = CmsScriptType.ClientSide;
				this.textBoxServer.Enabled = true;
			}
			isDirty = true;
		}

		private void radioButtonClient_CheckedChanged(object sender, System.EventArgs e)
		{
			if(radioButtonClient.Checked)
			{
				cmsUserGroup.ScriptType = CmsScriptType.ClientSide;
				this.textBoxServer.Enabled = true;
			}
			else
			{
				cmsUserGroup.ScriptType = CmsScriptType.ServerSide;
				this.textBoxServer.Enabled = false;
			}
			isDirty = true;
		}

		private void buttonSDO_Click(object sender, System.EventArgs e)
		{
			this.saveFileDialogsdo.ShowDialog();
			if(this.saveFileDialogsdo.FileName!="")
			{
				this.textBoxSDO.Text=saveFileDialogsdo.FileName;
				cmsUserGroup.SDOFilePath = saveFileDialogsdo.FileName;
				this.saveFileDialogsdo.FileName = "";
				isDirty = true;
			}
		}

		private void buttonReport_Click(object sender, System.EventArgs e)
		{
			this.saveFileDialogReport.ShowDialog();
			if(this.saveFileDialogReport.FileName!="")
			{
				this.textBoxReport.Text=saveFileDialogReport.FileName;
				cmsUserGroup.ReportFilePath = saveFileDialogReport.FileName;
				this.saveFileDialogReport.FileName = "";
				isDirty = true;
			}
		}

		private bool Save()
		{
			xmlDocument.RemoveAll();
			xmlDocument.LoadXml("<UserGroup>" +
				"<AuthenticationType>"+(int)cmsUserGroup.AuthenticationType+"</AuthenticationType>" +
				"<SDOFilePath>"+cmsUserGroup.SDOFilePath+"</SDOFilePath>" +
				"<SDOArchivePath>"+cmsUserGroup.SDOArchivePath+"</SDOArchivePath>" +
				"<ServerUrl>"+cmsUserGroup.ServerUrl+"</ServerUrl>" +
				"<ReportFilePath>"+cmsUserGroup.ReportFilePath+"</ReportFilePath>" +
				"<ScriptType>"+(int)cmsUserGroup.ScriptType+"</ScriptType>" +
				"<IsBackUp>"+cmsUserGroup.IsBackUp+"</IsBackUp>" +
				"<UserName>"+this.textBoxUserName.Text+"</UserName>" +
				"<Password>"+this.textBoxPassword.Text+"</Password>" +
				"<ScriptFile>"+this.textBoxFileName.Text+"</ScriptFile>" +
				"</UserGroup>");
			if(!isOpened)
			{
				saveFileDialogXml.ShowDialog();
				if(saveFileDialogXml.FileName!="")
				{
					try
					{
						xmlDocument.Save(saveFileDialogXml.FileName);
						isDirty = false;
						isOpened = true;
						return true;
					}
					catch(Exception ex)
					{
						MessageBox.Show("While trying to save the document, an error occured. Error - "+ex.ToString(),"Error",MessageBoxButtons.OK,MessageBoxIcon.Error);
					}
				}
			}
			else
			{
				try
				{
					if(openFileDialogXml.FileName!="")
					{
						xmlDocument.Save(openFileDialogXml.FileName);
					}
					else
					{
						xmlDocument.Save(saveFileDialogXml.FileName);
					}
					isDirty = false;
					isOpened = true;
					return true;
				}
				catch(Exception ex)
				{
					MessageBox.Show("While trying to save the document, an error occured. Error - "+ex.ToString(),"Error",MessageBoxButtons.OK,MessageBoxIcon.Error);
				}
			}
			return false;
		}

		private void BackUp()
		{
			//Set the script type
			string scriptType = "CmsDeployServer";
			if(cmsUserGroup.ScriptType==CmsScriptType.ClientSide)
			{
				scriptType = "CmsDeployClient";
			}

			StreamWriter sw = new StreamWriter(this.textBoxFileName.Text);
			ScriptComment sc = new ScriptComment(sw);
			sc.WriteComment();
			sw.WriteLine("Call Export");
			sw.WriteLine("Sub WriteErrorsToFile(reportTime,errorMsg)");
			sw.WriteLine("	Set fs = CreateObject(\"Scripting.FileSystemObject\")");
			sw.WriteLine("	Set ReportFile = fs.OpenTextFile(\""+this.textBoxReport.Text +"\",8,True,0)");
			sw.WriteLine("	ReportFile.WriteLine(\"Export Error @ \" & reportTime & \".\" & vbCrlf & \"Error Message: \" & errorMsg & vbCrlf)");
			sw.WriteLine("End Sub");
			sw.WriteLine("");
			sw.WriteLine("Sub Export");
			sw.WriteLine("	Dim pCmsDeployExport");
			sw.WriteLine("	Dim shell");
			sw.WriteLine("	Dim pReportTime");
			sw.WriteLine("	Dim pArchiveFileName");
			if(cmsUserGroup.AuthenticationType == CmsAuthenticationType.AuthenticateAsUser)
			{
				sw.WriteLine("	Dim strUserLogon");
				sw.WriteLine("	Dim strUserPwd");
				sw.WriteLine("	strUserLogon = \""+this.textBoxUserName.Text +"\"");
				sw.WriteLine("	strUserPwd = \""+this.textBoxPassword.Text+"\"");
			}
			sw.WriteLine("	On Error Resume Next");
			sw.WriteLine("	Set pCmsDeployExport = CreateObject(\""+ scriptType +".CmsUserGroupBackupRestore.1\")");
			sw.WriteLine("	If ( Err.Number <> 0 ) Then");
			sw.WriteLine("		Call WriteErrorsToFile(now,Err.Description)");
			sw.WriteLine("		Set pCmsDeployExport = Nothing");
			sw.WriteLine("		Exit Sub");
			sw.WriteLine("	End If");
			if(cmsUserGroup.AuthenticationType == CmsAuthenticationType.AuthenticateAsUser)
			{
				if(cmsUserGroup.ScriptType==CmsScriptType.ClientSide)
				{
					sw.WriteLine("	Call pCmsDeployExport.AuthenticateAsUser(\""+this.textBoxServer.Text+"\",strUserLogon,strUserPwd)");
				}
				else
				{
					sw.WriteLine("	Call pCmsDeployExport.AuthenticateAsUser(strUserLogon,strUserPwd)");
				}
			}
			else
			{
				if(cmsUserGroup.ScriptType==CmsScriptType.ClientSide)
				{
					sw.WriteLine("	Call pCmsDeployExport.AuthenticateAsCurrentUser(\""+this.textBoxServer.Text+"\")");
				}
				else
				{
					sw.WriteLine("	Call pCmsDeployExport.AuthenticateAsCurrentUser()");
				}
			}
			sw.WriteLine("	If ( Err.Number <> 0 ) Then");
			sw.WriteLine("		Call WriteErrorsToFile(now,Err.Description)");
			sw.WriteLine("		Set pCmsDeployExport = Nothing");
			sw.WriteLine("		Exit Sub");
			sw.WriteLine("	End If");
			sw.WriteLine("	Dim strPackageFileName");
			sw.WriteLine("	Dim strReportUrl");
			sw.WriteLine("	strPackageFileName = \""+this.textBoxSDO.Text+"\"");
			sw.WriteLine("	strReportUrl = pCmsDeployExport.Backup(\""+this.textBoxSDO.Text+"\")");
			sw.WriteLine("	If ( Err.Number <> 0 ) Then");
			sw.WriteLine("		Call WriteErrorsToFile(now,Err.Description)");
			sw.WriteLine("		Set pCmsDeployExport = Nothing");
			sw.WriteLine("		Exit Sub");
			sw.WriteLine("	End If");
			sw.WriteLine("	pReportTime = now");
			sw.WriteLine("	pReportTime = Replace(pReportTime,\" \",\"-\")");
			sw.WriteLine("	pReportTime = Replace(pReportTime,\"/\",\"-\")");
			sw.WriteLine("	pReportTime = Replace(pReportTime,\":\",\"-\")");
			sw.WriteLine("	Set fs = CreateObject(\"Scripting.FileSystemObject\")");
			sw.WriteLine("	pArchiveFilePath = \""+this.textBoxSDOArchive.Text+"\\\"");
			sw.WriteLine("	pArchiveFileName = \"export_\" & pReportTime & \".sdo\"");
			sw.WriteLine("	Call fs.CopyFile(\""+this.textBoxSDO.Text+"\", pArchiveFilePath & pArchiveFileName)");
			sw.WriteLine("	If (Err.number <> 0 ) Then");
			sw.WriteLine("		Call WriteErrorsToFile(pReportTime,Err.Description)");
			sw.WriteLine("		Set pCmsDeployExport = Nothing");
			sw.WriteLine("		Exit Sub");
			sw.WriteLine("	End If");
			sw.WriteLine("	Set ReportFile = fs.OpenTextFile(\""+this.textBoxReport.Text+"\",8,True,0)");
			sw.WriteLine("	ReportFile.WriteLine(\"Export Completed @ \" & pReportTime & \".\" & vbCrlf & \"Report URL: "+ this.textBoxServer.Text +"\" & strReportUrl & vbCrlf)");	
			sw.WriteLine("	Set pCmsDeployExport = Nothing");
			sw.WriteLine("	Set pReportTime = Nothing");
			sw.WriteLine("	Set fs = Nothing");
			sw.WriteLine("End Sub");
			sw.Flush();
			sw.Close();
			this.Cursor = Cursors.Default;
			MessageBox.Show("Script generated","Done",MessageBoxButtons.OK,MessageBoxIcon.Information);

		}

		private void Restore()
		{
			
			//Set the script type
			string scriptType = "CmsDeployServer";
			if(cmsUserGroup.ScriptType==CmsScriptType.ClientSide)
			{
				scriptType = "CmsDeployClient";
			}

			StreamWriter sw = new StreamWriter(this.textBoxFileName.Text);
			ScriptComment sc = new ScriptComment(sw);
			sc.WriteComment();
			sw.WriteLine("Dim strImportFile");
			sw.WriteLine("strImportFile = \""+cmsUserGroup.SDOFilePath+"\"");
			sw.WriteLine("Set fso = WScript.CreateObject(\"Scripting.FileSystemObject\")");
			sw.WriteLine("If(fso.FileExists(strImportFile))Then");
			sw.WriteLine("	Call Import(strImportFile)");
			sw.WriteLine("Else");
			sw.WriteLine("	Call WriteErrorsToFile(now,\"The import file \"\"\" & strImportFile & \"\"\" does not exist.\")");
			sw.WriteLine("End If");
			sw.WriteLine("Sub WriteErrorsToFile(reportTime,ErrorMsg)");
			sw.WriteLine("	Set fs = CreateObject(\"Scripting.FileSystemObject\")");
			sw.WriteLine("	Set ReportFile = fs.OpenTextFile(\""+this.textBoxReport.Text +"\",8,True,0)");
			sw.WriteLine("	ReportFile.WriteLine(\"Export Error @ \" & reportTime & \".\" & vbCrlf & \"Error Message: \" & errorMsg & vbCrlf)");
			sw.WriteLine("End Sub");
			sw.WriteLine("");
			sw.WriteLine("Sub Import(strImportFile)");
			sw.WriteLine("	Dim pCmsDeployImport");
			sw.WriteLine("	Dim pReportTime");
			if(cmsUserGroup.AuthenticationType == CmsAuthenticationType.AuthenticateAsUser)
			{
				sw.WriteLine("	Dim strUserLogon");
				sw.WriteLine("	Dim strUserPwd");
				sw.WriteLine("	strUserLogon = \""+this.textBoxUserName.Text +"\"");
				sw.WriteLine("	strUserPwd = \""+this.textBoxPassword.Text+"\"");
			}
			sw.WriteLine("	On Error Resume Next");
			sw.WriteLine("	Set pCmsDeployImport = CreateObject(\""+ scriptType +".CmsUserGroupBackupRestore.1\")");
			sw.WriteLine("	If ( Err.Number <> 0 ) Then");
			sw.WriteLine("		Call WriteErrorsToFile(now,Err.Description)");
			sw.WriteLine("		Set pCmsDeployImport = Nothing");
			sw.WriteLine("		Exit Sub");
			sw.WriteLine("	End If");
			if(cmsUserGroup.AuthenticationType == CmsAuthenticationType.AuthenticateAsUser)
			{
				if(cmsUserGroup.ScriptType==CmsScriptType.ClientSide)
				{
					sw.WriteLine("	Call pCmsDeployImport.AuthenticateAsUser(\""+this.textBoxServer.Text+"\",strUserLogon,strUserPwd)");
				}
				else
				{
					sw.WriteLine("	Call pCmsDeployImport.AuthenticateAsUser(strUserLogon,strUserPwd)");
				}
			}
			else
			{
				if(cmsUserGroup.ScriptType==CmsScriptType.ClientSide)
				{
					sw.WriteLine("	Call pCmsDeployImport.AuthenticateAsCurrentUser(\""+this.textBoxServer.Text+"\")");
				}
				else
				{
					sw.WriteLine("	Call pCmsDeployImport.AuthenticateAsCurrentUser()");
				}
			}
			sw.WriteLine("	If ( Err.Number <> 0 ) Then");
			sw.WriteLine("		Call WriteErrorsToFile(now,Err.Description)");
			sw.WriteLine("		Set pCmsDeployImport = Nothing");
			sw.WriteLine("		Exit Sub");
			sw.WriteLine("	End If");
			sw.WriteLine("	If ( Err.Number <> 0 ) Then");
			sw.WriteLine("		Call WriteErrorsToFile(now,Err.Description)");
			sw.WriteLine("		Set pCmsDeployImport = Nothing");
			sw.WriteLine("		Exit Sub");
			sw.WriteLine("	End If");
			sw.WriteLine("	Dim strReportUrl");
			sw.WriteLine("	strReportUrl = pCmsDeployImport.Restore(strImportFile,"+cmsUserGroup.RemoveUser.ToString().ToUpper()+")");
			sw.WriteLine("	If ( Err.Number <> 0 ) Then");
			sw.WriteLine("		Call WriteErrorsToFile(now,Err.Description)");
			sw.WriteLine("		Set pCmsDeployImport = Nothing");
			sw.WriteLine("		Exit Sub");
			sw.WriteLine("	End If");
			sw.WriteLine("	pReportTime = now");
			sw.WriteLine("	pReportTime = Replace(pReportTime,\" \",\"-\")");
			sw.WriteLine("	pReportTime = Replace(pReportTime,\"/\",\"-\")");
			sw.WriteLine("	pReportTime = Replace(pReportTime,\":\",\"-\")");
			sw.WriteLine("	Set fs = CreateObject(\"Scripting.FileSystemObject\")");
			sw.WriteLine("	Set ReportFile = fs.OpenTextFile(\""+this.textBoxReport.Text+"\",8,True,0)");
			sw.WriteLine("	ReportFile.WriteLine(\"Import Completed @ \" & pReportTime & \".\" & vbCrlf & \"Report URL: "+ this.textBoxServer.Text +"\" & strReportUrl & vbCrlf)");	
			sw.WriteLine("	Set pCmsDeployImport = Nothing");
			sw.WriteLine("	Set pReportTime = Nothing");
			sw.WriteLine("	Set fs = Nothing");
			sw.WriteLine("End Sub");
			sw.Flush();
			sw.Close();
			this.Cursor = Cursors.Default;
			MessageBox.Show("Script generated","Done",MessageBoxButtons.OK,MessageBoxIcon.Information);			
				
		}

		private void buttonGenerate_Click(object sender, System.EventArgs e)
		{
			this.Cursor = Cursors.WaitCursor;
			try
			{
				if(radioButtonBackup.Checked)
				{
					BackUp();
				}
				else
				{
					Restore();
				}
				this.Cursor = Cursors.Default;
			}
			catch(Exception ex)
			{
				this.Cursor = Cursors.Default;
				MessageBox.Show("While generating the script, an error occured. Error - " + ex.ToString(),"Error",MessageBoxButtons.OK,MessageBoxIcon.Error);
			}
			this.Cursor = Cursors.Default;
		}

		private void buttonBrowse_Click(object sender, System.EventArgs e)
		{
			this.saveFileDialog.ShowDialog();
			if(this.saveFileDialog.FileName!="")
			{
				this.textBoxFileName.Text=saveFileDialog.FileName;
				this.saveFileDialog.FileName = "";
				this.buttonGenerate.Enabled = true;
			}
		}

		private void radioButtonBackup_CheckedChanged(object sender, System.EventArgs e)
		{
			if(this.radioButtonBackup.Checked)
			{
				cmsUserGroup.IsBackUp = true;
				checkBoxRemoveUsers.Enabled = false;
				this.textBoxSDOArchive.Enabled = true;
				this.buttonSDOArchive.Enabled = true;
			}
			else
			{
				cmsUserGroup.IsBackUp = false;
				checkBoxRemoveUsers.Enabled = true;
				this.textBoxSDOArchive.Enabled = false;
				this.buttonSDOArchive.Enabled = false;
			}
		}

		private void radioButtonRestore_CheckedChanged(object sender, System.EventArgs e)
		{
			if(this.radioButtonRestore.Checked)
			{
				cmsUserGroup.IsBackUp = false;
				checkBoxRemoveUsers.Enabled = true;
				this.textBoxSDOArchive.Enabled = false;
				this.buttonSDOArchive.Enabled = false;
			}
			else
			{
				cmsUserGroup.IsBackUp = true;
				checkBoxRemoveUsers.Enabled = false;
				this.textBoxSDOArchive.Enabled = true;
				this.buttonSDOArchive.Enabled = true;
			}
		}

		private void buttonSDOArchive_Click(object sender, System.EventArgs e)
		{
			this.folderBrowserDialog.ShowDialog();
			if(this.folderBrowserDialog.SelectedPath!="")
			{
				this.textBoxSDOArchive.Text=this.folderBrowserDialog.SelectedPath;
				cmsUserGroup.SDOArchivePath = this.folderBrowserDialog.SelectedPath;
				this.folderBrowserDialog.SelectedPath = "";
				isDirty = true;
			}
		}

		private void checkBoxRemoveUsers_CheckedChanged(object sender, System.EventArgs e)
		{
			if(checkBoxRemoveUsers.Checked)
			{
				cmsUserGroup.RemoveUser = true;
			}
			else
			{
				cmsUserGroup.RemoveUser = false;
			}
		}

		private void FormUserGroup_Closing(object sender, System.ComponentModel.CancelEventArgs e)
		{
			if(isDirty)
			{
				DialogResult result = MessageBox.Show("Do you want to save before exit?","Not saved",MessageBoxButtons.YesNo,MessageBoxIcon.Question);
				if(result == DialogResult.Yes)
				{
					Save();
				}
			}
			cmsApplicationContext.Dispose();
		}	
		
		private void textBoxServer_TextChanged(object sender, System.EventArgs e)
		{
			isDirty = true;
		}

		#endregion

	}
}
