/**
 * @file MCMSManagerConfig.cs
 *
 * MCMS Manager
 *
 * MCMS Manager is the legal property of its developer
 * Chester Ragel <chesterr@gmail.com> - Developer and Maintainer
 * Yahoo ID : chesterr1979 
 * MSN : chesterr79@hotmail.com
 *
 * If you want more information, found any bugs or have any doubts you 
 * can mail me or contact me through my yahoo id.
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2.1 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#region Namespaces
using System;
using System.Text;
#endregion

namespace MCMS
{
	/// <summary>
	/// To serialize and de-serialize the data to store and retrive from the config file
	/// this object is used
	/// </summary>
	public class MCMSManagerConfig
	{

		#region Private Variables
		private string  _serverName;
		private string _userName;
		private string _password;
		private string  _iisLogFiles;
		private string _mcmsLogFiles;
		private string _mcmsLogFolder;
		private int _showPreview;
		private int _showPreviewTemplate;
		private int _showPreviewResource;
		private string _thumbnailFolder;
		private int _thumbNailHeight;
		private int _thumbnailWidth;
		private int _resolutionHeight;
		private int _resolutionWidth;

		#endregion

		#region Constructor
		public MCMSManagerConfig()
		{          
		}
		#endregion

		#region Propertise
		
		public string MCMSLogFiles
		{
			get
			{
				return _mcmsLogFiles;
			}
			set
			{
				_mcmsLogFiles = value;
			}
		}
		public string IISLogFiles 
		{
			get
			{
				return _iisLogFiles; 
			}
			set
			{
				_iisLogFiles = value; 
			}
		} 

		public string MCMSLogFolder
		{
			get
			{
				return _mcmsLogFolder;
			}
			set
			{
				_mcmsLogFolder = value;
			}
		}
		public string ServerName 
		{
			get
			{
				return _serverName; 
			}
			set
			{
				_serverName = value; 
			}
		} 
		
		public string Password 
		{
			get
			{
				return _password; 
			}
			set
			{
				_password = value; 
			}
		} 

		public string UserName 
		{
			get
			{
				return _userName; 
			}
			set
			{
				_userName = value; 
			}
		} 

		//0 is not to show and others to show
		public int ShowPreview 
		{
			get
			{
				return _showPreview; 
			}
			set
			{
				_showPreview = value; 
			}
		} 

		public int ShowPreviewResource
		{
			get
			{
				return _showPreviewResource; 
			}
			set
			{
				_showPreviewResource = value; 
			}
		}

		public int ShowPreviewTemplate
		{
			get
			{
				return _showPreviewTemplate; 
			}
			set
			{
				_showPreviewTemplate = value; 
			}
		}

		public string ThumbnailFolder 
		{
			get
			{
				return _thumbnailFolder; 
			}
			set
			{
				_thumbnailFolder = value; 
			}
		} 

		public int ThumbNailHeight 
		{
			get
			{
				return _thumbNailHeight; 
			}
			set
			{
				_thumbNailHeight = value; 
			}
		} 

		public int ThumbnailWidth 
		{
			get
			{
				return _thumbnailWidth; 
			}
			set
			{
				_thumbnailWidth = value; 
			}
		} 

		public int ResolutionWidth 
		{
			get
			{
				return _resolutionWidth; 
			}
			set
			{
				_resolutionWidth = value; 
			}
		} 

		public int ResolutionHeight 
		{
			get
			{
				return _resolutionHeight; 
			}
			set
			{
				_resolutionHeight = value; 
			}
		}
		#endregion

		#region ToString()
		//to get the string reprasentation
		public override string ToString() 
		{
			StringBuilder sb = new StringBuilder();
			sb.AppendFormat("ServerName = {0}; UserName = {1}; Password = {2}", ServerName, UserName, Password);

			return sb.ToString();
		}
		#endregion

	}
}
