using System;
using System.Drawing;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Collections;
using System.ComponentModel;
using System.IO;
using System.Text;
using System.Xml;
using System.Xml.Xsl;
using MSIBPlusPack.ContentManagement.Publishing.Placeholders;
using Microsoft.ContentManagement.Publishing;
using Microsoft.ContentManagement.Web;
using Microsoft.ContentManagement.WebControls;

namespace MSIBPlusPack.ContentManagement.Publishing.Placeholders
{
	
	
	

	/// <summary>
	///Used by the affinity items control, this is allows 
	///the adding of new affinity items and the editing of existing ones
	/// </summary>
	[DefaultProperty("Text"), 
		ToolboxData("<{0}:AffinityEditor runat=server></{0}:AffinityEditor>")]
	internal class AffinityEditor : System.Web.UI.WebControls.WebControl, INamingContainer
	{

		#region Enumerations
		/// <summary>
		/// The current mode of the control
		/// </summary>
		enum Mode
		{
			/// <summary>
			/// User is selecting an existing category from the dropdownlist
			/// </summary>
			UseExisting = 1,
			/// <summary>
			/// User is adding a new category
			/// </summary>
			AddNew = 2,
			/// <summary>
			/// Control is in edit mode
			/// </summary>
			Edit = 3
		
		}
		#endregion

		#region Constants

		private const string mcstrXML_DATA_FILE = "";
		private const string mcstrDISPLAYTITLE = "Affinity Editor";
		//css
		private const string mcstrCSS_TITLE = "affinitytitle";
		private const string mcstrCSS_PANEL = "affinitypanel";
		private const string mcstrCSS_ERROR = "affinitymessage";
		private const string mcstrCSS_BUTTONS = "affinitybuttons";

		//captions
		private const string mcstrOK_CAPTION = "Add";
		private const string mcstrADD_ITEM_BUTTON_CAPTION = "Add new item";
		private const string mcstrEDIT_BUTTON_CAPTION = "Edit existing item";
		private const string mcstrDELETE_BUTTON_CAPTION = "Delete";
		private const string mcstrUPDATE_BUTTON_CAPTION = "Update";
		private const string mcstrDISPLAY_NAME_CAPTION = "Display Name: ";
		private const string mcstrDESCRIPTION_CAPTION = "Description: ";
		private const string mcstrURL_CAPTION = "Url: ";
		private const string mcstrTARGET_CAPTION = "Target: ";
		private const string mcstrOPT_EXISTING_CATEGORY = "Use exising category";
		private const string mcstrOPT_NEW_CATEGORY = "Add new category";
		private const string mcstrVALIDATION_MESSAGE = "Please enter a value for all fields";
		private const string mcstrCATEGORY_CAPTION = "Category: ";
		private const string mcstrSELECT_ITEM_CAPTION = "Select item to edit";

		//xml constants
		private const string mcstrXML_SELECT_ALL_CATEGORIES = "/items/affinity_item";
		private const string mcstrXML_TITLE_ATTRIBUTE = "title";
		private const string mcstrXML_CATEGORY_ATTRIBUTE = "category";		
		private const string mcstrXML_VISIBLE_ATTRIBUTE = "visible";
		private const string mcstrXML_ROOT_NODE = "items";
		private const string mcstrXML_AFFINITY_NODE = "affinity_item";
		private const string mcstrXML_KEY_NODE = "key";
		private const string mcstrXML_DESC_NODE = "description";
		private const string mcstrXML_DISPLAY_TEXT_NODE = "display_text";
		private const string mcstrXML_URL_NODE = "url";
		private const string mcstrXML_TARGET_NODE = "target";

		//used to get a reference to the List_Select control to update it
		//when an item is added
		private const string mcstrLIST_SELECT_CTRL_NAME = "lstSelector";



		
		#endregion

		#region Controls

		DropDownList lstCategories;
		TextBox txtNewCategory;
		TextBox txtDisplayName;
		TextBox txtDescription;
		TextBox txtUrl;
		DropDownList lstTarget;
		Button cmdOK;
		Label lblTitle;
		Label lblDisplayName;
		Label lblDescription;
		Label lblUrl;
		Label lblTarget;
		Literal litError = new Literal();
		RadioButtonList optCategory;
		Button cmdAddItem;

		//edit mode
		DropDownList lstItems;
		Button cmdEdit;
		Button cmdUpdate;
		Button cmdDelete;
		TextBox txtEditCategory;
		TextBox txtEditDisplayName;
		TextBox txtEditDescription;
		TextBox txtEditUrl;
		DropDownList lstEditTarget;
		Label lblEditCategory;
		Label lblSelectItem;
		


		#endregion

		#region Private Member Variables

		//CSS
		private string _CSSTitle = mcstrCSS_TITLE;
		private string _CSSPanel = mcstrCSS_PANEL;
		private string _CSSError = mcstrCSS_ERROR;

		private string _displayTitle = mcstrDISPLAYTITLE;

		private string _xmlDataFile = mcstrXML_DATA_FILE;

		// Errors Collection
		private StringBuilder _Errors = new StringBuilder();

		private Mode _mode;

		

		#endregion

		#region Overriden properties 
		public override ControlCollection Controls 
		{
			get 
			{
				EnsureChildControls();
				return base.Controls;
			}
		}
		#endregion Overriden properties

		#region Public Properties

		#region CssTitle
		/// <summary>
		/// The CSS class of the control's title
		/// </summary>
		[
		Category("CSS"),
		DefaultValue(mcstrCSS_TITLE),
		Description("This sets the CSS class of the control's title")]
		public string CssTitle
		{
			get
			{
				return _CSSTitle;
			}
			set
			{
				_CSSTitle = value;
			}
		}
		#endregion

		#region CssPanel
		/// <summary>
		/// The CSS class of the control panel
		/// </summary>
		[
		Category("CSS"),
		DefaultValue(mcstrCSS_PANEL),
		Description("This sets the CSS class of the control panel")]
		public string CssPanel
		{
			get
			{
				return _CSSPanel;
			}
			set
			{
				_CSSPanel = value;
			}
		}
		#endregion

		#region CssError
		/// <summary>
		/// The CSS class of the error message
		/// </summary>
		[
		Category("CSS"),
		DefaultValue(mcstrCSS_ERROR),
		Description("This sets the CSS class of the error message")]
		public string CssError
		{
			get
			{
				return _CSSError;
			}
			set
			{
				_CSSError = value;
			}
		}
		#endregion

		#region DisplayTitle
		/// <summary>
		/// The title  to be displayed on the control
		/// </summary>
		[
		Category("Settings"),
		DefaultValue(mcstrDISPLAYTITLE),
		Description("This sets the title displayed on the control")]
		public string DisplayTitle
		{
			get
			{
				return _displayTitle;
			}
			set
			{
				_displayTitle = value;
			}
		}
		#endregion

		#region XmlDataFile
		/// <summary>
		/// The affinity items data file that the control will read and update
		/// </summary>
		[
		Category("Settings"),
		DefaultValue(mcstrXML_DATA_FILE),
		Description("The xml data file")]
		public string XmlDataFile
		{
			get
			{
				return _xmlDataFile;
			}
			set
			{
				_xmlDataFile = value;
			}
		}
		#endregion


		#endregion

		#region EventHandlers

		#region cmdOK_Click

		private void cmdOK_Click(object sender, EventArgs e)
		{	
			if(optCategory.SelectedIndex == 0)
			{
				_mode = Mode.UseExisting;
			}
			else
			{
				_mode = Mode.AddNew;
			}
			//before update, validate user data
			if(ValidateValues())
			{
				UpdateXml();
				//reset textboxes
				txtNewCategory.Text = "";
				txtDisplayName.Text = "";
				txtDescription.Text="";
				txtUrl.Text = "";
				lstTarget.SelectedIndex = 2;
				//reset mode
				_mode = Mode.UseExisting;
				PopulateCategoryList(ref lstCategories);
				try
				{
					string sListControl = this.UniqueID.Replace(this.ID,mcstrLIST_SELECT_CTRL_NAME);
					ListSelector lstSelect = (ListSelector)Page.FindControl(sListControl);
					lstSelect.UpdateItems();
					
				}
				catch(Exception ex)
				{
					string test = ex.Message;
				}
				

			}
			else
			{
				litError.Text = mcstrVALIDATION_MESSAGE;
				
			}
			

			
		}
		#endregion

		#region optCategory_SelectedIndexChanged

		private void optCategory_SelectedIndexChanged(object sender, EventArgs e)
		{
			if(optCategory.SelectedIndex == 0)
			{
				lstCategories.Enabled = true;
				txtNewCategory.Enabled = false;
				txtNewCategory.BackColor = ColorTranslator.FromHtml("#D6D3CE");
			}
			else
			{
				lstCategories.Enabled = false;
				txtNewCategory.Enabled = true;
				txtNewCategory.BackColor = Color.White;
			}
		}

		#endregion

		#region cmdEdit_Click

		private void cmdEdit_Click(object sender, EventArgs e)
		{
			//set mode and controls
			_mode = Mode.Edit;
			lblTitle.Text = GetTitle();
			lstCategories.Enabled = true;
			lstCategories.AutoPostBack = true;
			optCategory.Visible = false;
			cmdOK.Visible = false;
			cmdEdit.Enabled = false;
			cmdAddItem.Enabled = true;
			cmdUpdate.Visible = true;
			cmdDelete.Visible = true;
			lstItems.Visible = true;
			txtNewCategory.Visible = false;
			txtEditCategory.Visible = true;
			lblEditCategory.Visible = true;
			lblSelectItem.Visible = true;
			txtDisplayName.Visible = false;
			txtEditDisplayName.Visible = true;
			txtDescription.Visible = false;
			txtEditDescription.Visible = true;
			txtUrl.Visible = false;
			txtEditUrl.Visible = true;
			lstTarget.Visible = false;
			lstEditTarget.Visible = true;

			PopulateItems();

		}

		#endregion

		#region cmdUpdate_Click

		private void cmdUpdate_Click(object sender, EventArgs e)
		{
			//open XML file, select node and update with values from textboxes
			litError.Text = "";
			//first validate values
			if(ValidateEdit())
			{
				try
				{
					
					string sItem = lstItems.SelectedItem.Text;
					string sCategory = lstCategories.SelectedItem.Text;

					XmlDocument xmlDoc = GetXmlData();
					

					string sSelect = mcstrXML_SELECT_ALL_CATEGORIES  + "[" + "@" + mcstrXML_CATEGORY_ATTRIBUTE + "='" + sCategory + "']";
					
					XmlNodeList xnlItems = xmlDoc.SelectNodes(sSelect);
					foreach(XmlNode xmlItem in xnlItems)
					{
						string sDisplayText = xmlItem.SelectSingleNode(mcstrXML_DISPLAY_TEXT_NODE).InnerText;
						//if the items display text matches the selected item, display it
						if(sItem == sDisplayText)
						{
							//populate xml file with data from textboxes
							xmlItem.Attributes[mcstrXML_CATEGORY_ATTRIBUTE].Value = txtEditCategory.Text ;
							xmlItem.SelectSingleNode(mcstrXML_DISPLAY_TEXT_NODE).InnerText = txtEditDisplayName.Text;
							xmlItem.SelectSingleNode(mcstrXML_DESC_NODE).InnerText = txtEditDescription.Text;
							xmlItem.SelectSingleNode(mcstrXML_URL_NODE).InnerText = txtEditUrl.Text;
							xmlItem.SelectSingleNode(mcstrXML_TARGET_NODE).InnerText = lstEditTarget.SelectedItem.Text;
						}

					}

					SaveUpdatedXml(xmlDoc);

					litError.Text = "Item updated";
					try
					{
						string sListControl = this.UniqueID.Replace(this.ID,mcstrLIST_SELECT_CTRL_NAME);
						ListSelector lstSelect = (ListSelector)Page.FindControl(sListControl);
						lstSelect.UpdateItems();
					}
					catch
					{}
					PopulateCategoryList(ref lstCategories);
					PopulateItems();
				}
			
				catch(Exception ex)
				{
					logError(ex,"Error updating xml data file. Please contact administrator.","Affinity_Editor.cmdUpdate_Click()");
					litError.Text = _Errors.ToString();
				}
			}
				
			else
			{
				litError.Text = mcstrVALIDATION_MESSAGE;
			}
		}
		#endregion

		#region cmdDelete_Click

		private void cmdDelete_Click(object sender, EventArgs e)
		{
			try
			{
				string sItem = lstItems.SelectedItem.Text;
				string sCategory = lstCategories.SelectedItem.Text;
				XmlDocument xmlDoc = GetXmlData();

				string sSelect = mcstrXML_SELECT_ALL_CATEGORIES  + "[" + "@" + mcstrXML_CATEGORY_ATTRIBUTE + "='" + sCategory + "']";
					
				XmlNodeList xnlItems = xmlDoc.SelectNodes(sSelect);
				foreach(XmlNode xmlItem in xnlItems)
				{
					string sDisplayText = xmlItem.SelectSingleNode(mcstrXML_DISPLAY_TEXT_NODE).InnerText;
					//if the items display text matches the selected item, display it
					if(sItem == sDisplayText)
					{
						XmlNode xmlRoot = xmlDoc.SelectSingleNode(mcstrXML_ROOT_NODE);
						xmlRoot.RemoveChild(xmlItem);
					}
				}

				SaveUpdatedXml(xmlDoc);

				//clear textboxes and give message
				txtEditCategory.Text = "";
				txtEditDisplayName.Text = "";
				txtEditDescription.Text = "";
				txtEditUrl.Text = "";
				lstEditTarget.SelectedIndex = 2;
				litError.Text = "Item deleted";
				//update items dropdown
				PopulateItems();
				string sListControl = this.UniqueID.Replace(this.ID,mcstrLIST_SELECT_CTRL_NAME);
				ListSelector lstSelect = (ListSelector)Page.FindControl(sListControl);
				lstSelect.UpdateItems();
				_mode = Mode.Edit;


			}
			catch(Exception ex)
			{
				logError(ex,"Error updating xml data file. Please contact administrator.","Affinity_Editor.cmdDelete_Click()");
				litError.Text = _Errors.ToString();
			}
		}

		#endregion

		#region cmdAddItem_Click

		private void cmdAddItem_Click(object sender, EventArgs e)
		{
			//change mode to add and reset controls
			_mode = Mode.UseExisting;

			optCategory.SelectedIndex = 0;
			lblTitle.Text = GetTitle();
			lstCategories.Enabled = true;
			lstCategories.AutoPostBack = false;
			optCategory.Visible = true;
			cmdOK.Visible = true;
			cmdEdit.Enabled = true;
			cmdAddItem.Enabled = false;
			cmdUpdate.Visible = false;
			cmdDelete.Visible = false;
			lstItems.Visible = false;
			txtNewCategory.Visible = true;
			txtNewCategory.Enabled = false;
			txtNewCategory.BackColor = ColorTranslator.FromHtml("#D6D3CE");
			txtEditCategory.Visible = false;
			lblEditCategory.Visible = false;
			lblSelectItem.Visible = false;

			txtDisplayName.Visible = true;
			txtEditDisplayName.Visible = false;
			txtDescription.Visible = true;
			txtEditDescription.Visible = false;
			txtUrl.Visible = true;
			txtEditUrl.Visible = false;
			lstTarget.Visible = true;
			lstEditTarget.Visible = false;

			//clear textboxes
			txtNewCategory.Text = "";
			txtDisplayName.Text = "";
			txtDescription.Text = "";
			txtUrl.Text = "";
			lstTarget.SelectedIndex = -1;
			lstTarget.SelectedIndex = 2;
		}

		#endregion

		#region lstItems_SelectedIndexChanged

		private void lstItems_SelectedIndexChanged(object sender, EventArgs e)
		{
			PopulateTextboxes();
		}

		#endregion

		#region lstCategories_SelectedIndexChanged

		private void lstCategories_SelectedIndexChanged(object sender, EventArgs e)
		{
				PopulateItems();
		
		}

		#endregion


		#endregion

		#region PopulateItems
		/// <summary>
		/// In edit mode, this populate the items listbox with the affinity items from the selected category
		/// </summary>
		private void PopulateItems()
		{
			try
			{
				if(lstCategories.Items.Count > 0)
				{
					string sCategory = lstCategories.SelectedItem.Text;
				
					lstItems.Items.Clear();
			
					XmlDocument xmlDoc = GetXmlData();
					string sSelect = sSelect = mcstrXML_SELECT_ALL_CATEGORIES + "[" + "@" + mcstrXML_CATEGORY_ATTRIBUTE + "='" + sCategory + "']";
					XmlNodeList xmlList = xmlDoc.SelectNodes(sSelect);
					string sName = "";
					//if no items exist change to first category
					if (xmlList.Count > 0)
					{
						foreach(XmlNode ndeItem in xmlList)
						{
							sName = ndeItem.SelectSingleNode(mcstrXML_DISPLAY_TEXT_NODE).InnerText;
							lstItems.Items.Add(sName);
						}
					}
					else
					{
						//this category has been removed as it has no items
						//select first category in the list
						lstCategories.Items.Remove(sCategory);
						lstCategories.SelectedIndex = 0;
						lstCategories_SelectedIndexChanged(null,null);
					}
				
					PopulateTextboxes();
				}
				else
				{
					litError.Text = "No items to edit";
				}
			}
			
			catch(Exception e)
			{
				logError(e,"Error reading xml data file. Please contact administrator.","Affinity_Editor.PopulateItems()");
				litError.Text = _Errors.ToString();
			}
		}

		#endregion

		#region Populate Textboxes
		/// <summary>
		/// Populate the category, display name, description, url and target textboxes with data from the selected item
		/// </summary>
		private void PopulateTextboxes()
		{
			try
			{
				if (lstItems.SelectedIndex > -1)
				{
					string sCategory = lstCategories.SelectedItem.Text;
					string sItem = lstItems.SelectedItem.Text;
			
					XmlDocument xmlDoc = GetXmlData();
					//find all items for the selected category
					string sSelect = mcstrXML_SELECT_ALL_CATEGORIES  + "[" + "@" + mcstrXML_CATEGORY_ATTRIBUTE + "='" + sCategory + "']";
					
					XmlNodeList xnlItems = xmlDoc.SelectNodes(sSelect);
					foreach(XmlNode xmlItem in xnlItems)
					{
						string sDisplayText = xmlItem.SelectSingleNode(mcstrXML_DISPLAY_TEXT_NODE).InnerText;
						//if the items display text matches the selected item, display it
						if(sItem == sDisplayText)
						{
							//populate textboxes with data from xml file
							txtEditCategory.Text = xmlItem.Attributes[mcstrXML_CATEGORY_ATTRIBUTE].Value;
							txtEditDisplayName.Text = xmlItem.SelectSingleNode(mcstrXML_DISPLAY_TEXT_NODE).InnerText;
							txtEditDescription.Text = xmlItem.SelectSingleNode(mcstrXML_DESC_NODE).InnerText;
							txtEditUrl.Text = xmlItem.SelectSingleNode(mcstrXML_URL_NODE).InnerText;
							lstEditTarget.SelectedIndex = -1;
							try
							{
								lstEditTarget.Items.FindByText(xmlItem.SelectSingleNode(mcstrXML_TARGET_NODE).InnerText).Selected = true;
							}
							catch
							{
								lstEditTarget.SelectedIndex = 2;
							} 
						}
					}
				}

				
			}

			catch(Exception e)
			{
				logError(e,"Error reading xml data file. Please contact administrator.","Affinity_Editor.PopulateTextboxes()");
				litError.Text = _Errors.ToString();
			}

		}
		#endregion

		#region UpdateXml()
		/// <summary>
		/// Updates the xml data file with information entered by the user
		/// </summary>
		private void UpdateXml()
		{
			//string sPath = HttpContext.Current.Server.MapPath(_xmlDataFile);
			try
			{
				XmlDocument xmlDoc = GetXmlData();
				

				#region Get user values
				string sCategory = "";
				if(txtNewCategory.Text.Length > 0)
				{
					sCategory = txtNewCategory.Text;					
				}
				else
				{
					sCategory = lstCategories.SelectedItem.Value;
				}
				string sDisplayName = txtDisplayName.Text;
				string sDescription = txtDescription.Text;
				string sUrl = txtUrl.Text;
				string sTarget = lstTarget.SelectedItem.Text;
				#endregion

				XmlNode xmlRoot = xmlDoc.SelectSingleNode(mcstrXML_ROOT_NODE);
				XmlElement xmlItem = xmlDoc.CreateElement("",mcstrXML_AFFINITY_NODE ,"");

				//add category attribute
				XmlAttribute attCategory = xmlDoc.CreateAttribute(mcstrXML_CATEGORY_ATTRIBUTE);
				attCategory.Value = sCategory;
				xmlItem.Attributes.Append(attCategory);

				//add display name
				XmlElement xmlDisplayName = xmlDoc.CreateElement("",mcstrXML_DISPLAY_TEXT_NODE,"");
				xmlDisplayName.InnerText = sDisplayName;
				xmlItem.AppendChild(xmlDisplayName);

				//add description
				XmlElement xmlDescription = xmlDoc.CreateElement("",mcstrXML_DESC_NODE,"");
				xmlDescription.InnerText = sDescription;
				xmlItem.AppendChild(xmlDescription);

				//add url
				XmlElement xmlUrl = xmlDoc.CreateElement("",mcstrXML_URL_NODE,"");
				xmlUrl.InnerText = sUrl;
				xmlItem.AppendChild(xmlUrl);

				//add target
				XmlElement xmlTarget = xmlDoc.CreateElement("",mcstrXML_TARGET_NODE,"");
				xmlTarget.InnerText = sTarget;
				xmlItem.AppendChild(xmlTarget);

				//add new affinity item to the root node
				xmlRoot.AppendChild(xmlItem);

				//save updated document
				SaveUpdatedXml(xmlDoc);

				//display a message
				litError.Text = "Affinity item added";
			
			}
			catch(Exception e)
			{
				logError(e,"Error updating xml data file. Please contact administrator.","Affinity_Editor.UpdateXml()");
				litError.Text = _Errors.ToString();
			}

		}
		#endregion

		#region ValidateValues()
		/// <summary>
		/// Checks the values entered by the user when adding a new item to ensure all fields are completed
		/// </summary>
		/// <returns>False if the user has not completed all fields</returns>
		private bool ValidateValues()
		{
			bool bValid = true;

			#region Get user values
			string sCategoryText = txtNewCategory.Text;
			int iCategoryList = lstCategories.SelectedIndex;
			string sDisplayName = txtDisplayName.Text;
			string sDescription = txtDescription.Text;
			string sUrl = txtUrl.Text;
			string sTarget = lstTarget.SelectedItem.Text;
			#endregion

			if(_mode == Mode.AddNew)
			{
				if(sCategoryText == "")
				{
					return false;
				}
			}
			if(_mode == Mode.UseExisting)
			{
				if(lstCategories.SelectedIndex == -1)
				{
					return false;
				}
			}
			if(sDisplayName == "")
			{
				return false;
			}
			if(sDescription == "")
			{
				return false;
			}
			if(sUrl == "")
			{
				return false;
			}
			if(sTarget == "")
			{
				return false;
			}
			
            return bValid;			

		}
		#endregion

		#region ValidateEdit()
		/// <summary>
		/// Checks the values entered by the user when editing to ensure all fields are completed
		/// </summary>
		/// <returns>False if the user has not completed all fields</returns>
		private bool ValidateEdit()
		{
			bool bValid = true;

			#region Get user values
			string sCategoryText = txtEditCategory.Text;
			string sDisplayName = txtEditDisplayName.Text;
			string sDescription = txtEditDescription.Text;
			string sUrl = txtEditUrl.Text;
			string sTarget = lstEditTarget.SelectedItem.Text;
			#endregion

			if(sCategoryText == "")
			{
				return false;
			}
			if(sDisplayName == "")
			{
				return false;
			}
			if(sDescription == "")
			{
				return false;
			}
			if(sUrl == "")
			{
				return false;
			}
			if(sTarget == "")
			{
				return false;
			}
			
			return bValid;			

		}
		#endregion

		#region Category List Functions

		#region PopulateCategoryList
		/// <summary>
		/// Populates the category listbox using the categories from the XML file
		/// </summary>
		/// <param name="lstCategories">ref DropDownList lstCategories</param>
		private void PopulateCategoryList(ref DropDownList lstCategories)
		{
			try
			{
				lstCategories.Items.Clear();
				XmlDocument xmlDoc = GetXmlData();
				
		
				//get all the categories in the document
				string sCatList = GetCategories(xmlDoc);
				
				if(!(sCatList == ""))
				{
					string[] sArray = sCatList.Split(',');
					//loop through array and add each item to listbox
					for(int iCount = 0; iCount < sArray.Length; iCount++)
					{

						lstCategories.Items.Add (sArray[iCount].ToString());

					}
				}
				
			}
			
			catch(Exception e)
			{
				logError(e,"Error reading xml data file. Please contact administrator.","Affinity_Editor.PopulateCategoryList()");
				litError.Text = _Errors.ToString();
				
			}
	
		}
		#endregion

		#region GetCategories()
		/// <summary>
		/// Returns all categories from the xml document
		/// </summary>
		/// <param name="xmlDoc">XML Document containing the data</param>
		/// <returns>A comma delimited list of categories</returns>
		private string GetCategories(XmlDocument xmlDoc)
		{
			
			//loop through each affinity item node and retrieve the category attribute
			XmlNodeList xmlList = xmlDoc.SelectNodes(mcstrXML_SELECT_ALL_CATEGORIES);
			StringBuilder sbCatList = new StringBuilder();
			string sCategory = "";
			foreach(XmlNode ndeItem in xmlList)
			{
				try
				{
					sCategory = ndeItem.Attributes[mcstrXML_CATEGORY_ATTRIBUTE].Value;
					sbCatList.Append(sCategory);
					sbCatList.Append(",");
				}
				catch(Exception e)
				{
					string test = e.Message;
				}
			}
			string sTemp = sbCatList.ToString();
			//remove trailing comma
			sTemp = sTemp.Trim(',');
			//filter out duplicate values
			string sReturn = FilterValues(sTemp);
			return sReturn;


		}
		#endregion

		#region FilterValues
		/// <summary>
		/// Takes a comma delimited list of values and removes dupilcate values
		/// </summary>
		/// <param name="sList">The list to filter</param>
		/// <returns>A comma delimited list of values</returns>
		private string FilterValues(string sList)
		{
			string[] sArray = sList.Split(',');
			StringBuilder sbFiltered = new StringBuilder();
			ArrayList arrTemp = new ArrayList();
			string sCategory = "";
			
			for(int iCount = 0; iCount < sArray.Length; iCount++)
			{
				sCategory = sArray[iCount].ToString();
				//add each item to array only if it is not already there
				if(! arrTemp.Contains(sCategory))
				{
					arrTemp.Add(sCategory);
				}
			}
			arrTemp.Sort();
			
			foreach(string sItem in arrTemp)
			{
				sbFiltered.Append(sItem);
				sbFiltered.Append(",");

			}
			string sReturn = sbFiltered.ToString();
			sReturn = sReturn.Trim(',');
			return sReturn;


		}
		#endregion

		#endregion

		#region Error Handling logError(Exception e, string sCustomMessage, string sOrigin) + 2 overloads
		/// <summary>
		/// Logs errors to the internal error variable, if mode is correct
		/// </summary>
		/// <param name="e">Exception - the error object generated</param>
		private void logError(Exception e){logError(e, null, null);}
		/// <summary>
		/// Logs errors to the internal error variable, if mode is correct
		/// </summary>
		/// <param name="e">Exception - the error object generated</param>
		/// <param name="sCustomText">string - custom message</param>
		private void logError(Exception e, string sCustomText){logError(e, sCustomText, null);}
		/// <summary>
		/// Logs errors to the internal error variable, if mode is correct
		/// </summary>
		/// <param name="e">Exception - the error object generated</param>
		/// <param name="sCustomText">string - custom message</param>
		/// <param name="sOrigin">string - the origin of the error</param>
		protected void logError(Exception e, string sCustomText, string sOrigin)
		{
			StringBuilder sbError = new StringBuilder();
			
			const string cstrBR = "<br>";

			if(e != null)
			{
				sbError.Append(e.Message);
				sbError.Append(cstrBR);
				if(e.InnerException != null)
				{
					sbError.Append(e.InnerException.Message);
					sbError.Append(cstrBR);
				}
			}

			if(sCustomText != null)
			{
				sbError.Append(sCustomText);
				sbError.Append(cstrBR);

			}


			if(sOrigin != null)
			{
				sbError.Append(sOrigin);
				sbError.Append(cstrBR);
			}

			_Errors.Append(sbError.ToString());
			
			
		}
		#endregion

		#region GetTitle()
		/// <summary>
		/// Appends information about the control mode to the display title
		/// </summary>
		/// <returns>The title of the control and its current mode</returns>
		private string GetTitle()
		{
			string sReturn = DisplayTitle;

			if(_mode == Mode.Edit)
			{
				sReturn += " - Edit item";
			}
			else
			{
				sReturn += " - Add new item";
			}
			return sReturn;
		}
		#endregion

		#region CreateChildControls()
		protected override void CreateChildControls()
		{
			Controls.Clear();

			//control title
			lblTitle = new Label();
			lblTitle.Text = GetTitle();

			//category list
			lstCategories = new DropDownList();
			//Add categories found in xml to the list
			lstCategories.SelectedIndexChanged +=new EventHandler(lstCategories_SelectedIndexChanged);
			PopulateCategoryList(ref lstCategories);
			
			//new category textbox
			txtNewCategory = new TextBox();
			txtNewCategory.Enabled = false;
			txtNewCategory.BackColor = ColorTranslator.FromHtml("#D6D3CE");

			//data textboxs
			txtDisplayName = new TextBox();
			txtDescription = new TextBox();
			txtUrl = new TextBox();
			
			//target drop down
			lstTarget = new DropDownList();
			lstTarget.Items.Add("_blank");
			lstTarget.Items.Add("_parent");
			lstTarget.Items.Add("_self");
			lstTarget.Items.Add("_top");
			lstTarget.SelectedIndex = 2;


			//edit textboxes
			txtEditDisplayName = new TextBox();
			txtEditDisplayName.Visible = false;
			txtEditDescription = new TextBox();
			txtEditDescription.Visible = false;
			txtEditUrl = new TextBox();
			txtEditUrl.Visible = false;
			//target drop down
			lstEditTarget = new DropDownList();
			lstEditTarget.Items.Add("_blank");
			lstEditTarget.Items.Add("_parent");
			lstEditTarget.Items.Add("_self");
			lstEditTarget.Items.Add("_top");
			lstEditTarget.SelectedIndex = 2;
			lstEditTarget.Visible = false;

			//OK button
			cmdOK = new Button();
			cmdOK.Text = mcstrOK_CAPTION;
			cmdOK.Click += new  EventHandler(cmdOK_Click);

			//textbox captions
			lblDisplayName = new Label();
			lblDisplayName.Text = mcstrDISPLAY_NAME_CAPTION;

			lblDescription = new Label();
			lblDescription.Text = mcstrDESCRIPTION_CAPTION;

			lblUrl = new Label();
			lblUrl.Text = mcstrURL_CAPTION;

			lblTarget = new Label();
			lblTarget.Text = mcstrTARGET_CAPTION;

			//error literal
			litError = new Literal();
			litError.Text = _Errors.ToString();

			//radio button list
			optCategory = new RadioButtonList();
			optCategory.AutoPostBack = true;
			optCategory.SelectedIndexChanged +=new EventHandler(optCategory_SelectedIndexChanged);
			ListItem optExisting = new ListItem();
			optExisting.Text = mcstrOPT_EXISTING_CATEGORY;
			optExisting.Selected = true;
			optCategory.Items.Add(optExisting);
			ListItem optNew = new ListItem();
			optNew.Text = mcstrOPT_NEW_CATEGORY;
			optCategory.Items.Add(optNew);

			//edit mode controls
			//edit button
			cmdEdit = new Button();
			cmdEdit.Text = mcstrEDIT_BUTTON_CAPTION;
			cmdEdit.Click +=new EventHandler(cmdEdit_Click);	
			cmdEdit.Width = 150;

			cmdAddItem = new Button();
			cmdAddItem.Text = mcstrADD_ITEM_BUTTON_CAPTION;
			cmdAddItem.Click += new EventHandler(cmdAddItem_Click);
			cmdAddItem.Enabled = false;
			cmdAddItem.Width = 150;

			//update button
			cmdUpdate = new Button();
			cmdUpdate.Text = mcstrUPDATE_BUTTON_CAPTION;
			cmdUpdate.Visible = false;
			cmdUpdate.Click +=new EventHandler(cmdUpdate_Click);

			cmdDelete = new Button();
			cmdDelete.Text = mcstrDELETE_BUTTON_CAPTION;
			cmdDelete.Visible = false;
			cmdDelete.Click += new EventHandler(cmdDelete_Click);

			txtEditCategory = new TextBox();
			txtEditCategory.Visible = false;

			lblEditCategory = new Label();
			lblEditCategory.Text = mcstrCATEGORY_CAPTION;
			lblEditCategory.Visible = false;

			lblSelectItem = new Label();
			lblSelectItem.Text = mcstrSELECT_ITEM_CAPTION;
			lblSelectItem.Visible = false;

			lstItems = new DropDownList();
			lstItems.AutoPostBack = true;
			lstItems.SelectedIndexChanged +=new EventHandler(lstItems_SelectedIndexChanged);
			lstItems.Visible = false;
			

			this.Controls.Add(lblTitle);
			this.Controls.Add(optCategory);
			this.Controls.Add(lblSelectItem);
			this.Controls.Add(lstCategories);
			this.Controls.Add(lstItems);
			this.Controls.Add(txtNewCategory);
			this.Controls.Add(lblEditCategory);
			this.Controls.Add(txtEditCategory);
			this.Controls.Add(lblDisplayName);
			this.Controls.Add(txtDisplayName);
			this.Controls.Add(txtEditDisplayName);
			this.Controls.Add(lblDescription);
			this.Controls.Add(txtDescription);
			this.Controls.Add(txtEditDescription);
			this.Controls.Add(lblUrl);
			this.Controls.Add(txtUrl);
			this.Controls.Add(txtEditUrl);
			this.Controls.Add(lblTarget);
			this.Controls.Add(lstTarget);
			this.Controls.Add(lstEditTarget);
			this.Controls.Add(cmdOK);
			this.Controls.Add(cmdAddItem);
			this.Controls.Add(cmdEdit);
			this.Controls.Add(cmdUpdate);
			this.Controls.Add(cmdDelete);
			
			
			
			
			
		
		}
		#endregion

		#region GetXmlData()

		/// <summary>
		/// Opens the file specified in the XmlDataFile property and returns its contents
		/// </summary>
		/// <returns>The Xml data file</returns>
		private XmlDocument GetXmlData()
		{
			XmlDocument xmlDoc = new XmlDocument();
			XmlTextReader rdrXml = new XmlTextReader(XmlDataFile);
			try
			{
				xmlDoc.Load(rdrXml);
				rdrXml.Close();
			}
			catch(Exception e)
			{
				throw(e);
			}

			return xmlDoc;

		}
		#endregion

		#region SaveUpdatedXml()

		/// <summary>
		/// Saves the updated XML file to the path specified in the XmlDataFile property
		/// </summary>
		/// <param name="data">The XmlDocument to write to the file</param>
		private void SaveUpdatedXml(XmlDocument data)
		{

			try
			{
				StreamWriter swXml = new StreamWriter(XmlDataFile, false);
				swXml.Write(data.InnerXml);
				swXml.Close();
			}
			catch(Exception e)
			{
				throw(e);
			}
		}

		#endregion

		/// <summary> 
		/// Render this control to the output parameter specified.
		/// </summary>
		/// <param name="writer"> The HTML writer to write out to </param>
		protected override void Render(HtmlTextWriter writer)
		{
			AddAttributesToRender(writer);

			#region Table Code
			writer.AddAttribute(HtmlTextWriterAttribute.Border,"0");
			writer.AddAttribute(HtmlTextWriterAttribute.Class, _CSSPanel);
			writer.AddAttribute (HtmlTextWriterAttribute.Width, "300");
			writer.RenderBeginTag(HtmlTextWriterTag.Table); //table

			#region Title Row
			writer.RenderBeginTag(HtmlTextWriterTag.Tr);//tr

			writer.AddAttribute(HtmlTextWriterAttribute.Class, _CSSTitle);//td
			writer.AddAttribute(HtmlTextWriterAttribute.Colspan, "2");
			writer.RenderBeginTag(HtmlTextWriterTag.Td);
			lblTitle.RenderControl(writer);//add title label
			writer.RenderEndTag();

			writer.RenderEndTag();//end tr
			#endregion

			#region Error Message Row
			writer.RenderBeginTag(HtmlTextWriterTag.Tr);//tr

			writer.AddAttribute(HtmlTextWriterAttribute.Class, _CSSError);//td
			writer.AddAttribute(HtmlTextWriterAttribute.Colspan, "2");
			writer.RenderBeginTag(HtmlTextWriterTag.Td);
			litError.RenderControl(writer);//add error literal
			writer.RenderEndTag();

			writer.RenderEndTag();//end tr
			#endregion

			#region AddItem/Edit Row Button Row
			writer.RenderBeginTag(HtmlTextWriterTag.Tr);//tr

			writer.AddAttribute(HtmlTextWriterAttribute.Colspan, "2");
			writer.RenderBeginTag(HtmlTextWriterTag.Td);
			cmdAddItem.RenderControl(writer);
			cmdEdit.RenderControl(writer);

			writer.RenderEndTag();

			writer.RenderEndTag();//end tr
			#endregion

			#region Category Dropdown Row
			writer.RenderBeginTag(HtmlTextWriterTag.Tr);//tr

			writer.AddAttribute(HtmlTextWriterAttribute.Rowspan, "3");
			writer.RenderBeginTag(HtmlTextWriterTag.Td);//td
			optCategory.RenderControl(writer);//add category dropdown
			lblSelectItem.RenderControl(writer);
			writer.RenderEndTag();

			writer.RenderBeginTag(HtmlTextWriterTag.Td);//td
			lstCategories.RenderControl(writer);//add category dropdown
			writer.RenderEndTag();

			writer.RenderEndTag();//end tr
			#endregion

			#region Items Dropdown Row
			writer.RenderBeginTag(HtmlTextWriterTag.Tr);//tr
			
			writer.RenderBeginTag(HtmlTextWriterTag.Td);//td
			lstItems.RenderControl(writer);//add category dropdown
			writer.RenderEndTag();

			writer.RenderEndTag();//end tr
			#endregion

			#region Add Category Row
			writer.RenderBeginTag(HtmlTextWriterTag.Tr);//tr

			writer.RenderBeginTag(HtmlTextWriterTag.Td);
			txtNewCategory.RenderControl(writer);//add new category textbox
			writer.RenderEndTag();

			writer.RenderEndTag();//end tr
			#endregion

			#region Edit Category Row
			writer.RenderBeginTag(HtmlTextWriterTag.Tr);//tr

			writer.RenderBeginTag(HtmlTextWriterTag.Td);
			lblEditCategory.RenderControl(writer);//add caption
			writer.RenderEndTag();

			writer.RenderBeginTag(HtmlTextWriterTag.Td);
			txtEditCategory.RenderControl(writer);//add description textbox
			writer.RenderEndTag();

			writer.RenderEndTag();//end tr

			#endregion

			#region Display Name Row
			writer.RenderBeginTag(HtmlTextWriterTag.Tr);//tr

			writer.RenderBeginTag(HtmlTextWriterTag.Td);
			lblDisplayName.RenderControl(writer);//add caption
			writer.RenderEndTag();

			writer.RenderBeginTag(HtmlTextWriterTag.Td);
			txtDisplayName.RenderControl(writer);//add description textbox
			txtEditDisplayName.RenderControl(writer);
			writer.RenderEndTag();

			writer.RenderEndTag();//end tr

			#endregion

			#region Description Row
			writer.RenderBeginTag(HtmlTextWriterTag.Tr);//tr

			writer.RenderBeginTag(HtmlTextWriterTag.Td);
			lblDescription.RenderControl(writer);//add caption
			writer.RenderEndTag();

			writer.RenderBeginTag(HtmlTextWriterTag.Td);
			txtDescription.RenderControl(writer);//add description textbox
			txtEditDescription.RenderControl(writer);
			writer.RenderEndTag();

			writer.RenderEndTag();//end tr
			#endregion

			#region Url Row
			writer.RenderBeginTag(HtmlTextWriterTag.Tr);//tr

			writer.RenderBeginTag(HtmlTextWriterTag.Td);
			lblUrl.RenderControl(writer);//add caption
			writer.RenderEndTag();

			writer.RenderBeginTag(HtmlTextWriterTag.Td);
			txtUrl.RenderControl(writer);//add url textbox
			txtEditUrl.RenderControl(writer);
			writer.RenderEndTag();

			writer.RenderEndTag();//end tr
			#endregion
			
			#region Target Row
			writer.RenderBeginTag(HtmlTextWriterTag.Tr);//tr

			writer.RenderBeginTag(HtmlTextWriterTag.Td);
			lblTarget.RenderControl(writer);//add caption
			writer.RenderEndTag();

			writer.RenderBeginTag(HtmlTextWriterTag.Td);
			lstTarget.RenderControl(writer);
			lstEditTarget.RenderControl(writer);
			writer.RenderEndTag();

			writer.RenderEndTag();//end tr
			#endregion

			#region OK Button Row
			writer.RenderBeginTag(HtmlTextWriterTag.Tr);//tr

			writer.AddAttribute(HtmlTextWriterAttribute.Colspan, "2");
			writer.AddAttribute(HtmlTextWriterAttribute.Align, "right");
			writer.RenderBeginTag(HtmlTextWriterTag.Td);
			cmdOK.RenderControl(writer);//add OK button
			//edit buttons
			cmdUpdate.RenderControl(writer);
			cmdDelete.RenderControl(writer);

			writer.RenderEndTag();

			writer.RenderEndTag();//end tr
			#endregion
			

			writer.RenderEndTag();//end table

			#endregion

	
		}

		
	}
}
