using System;
using System.IO;
using System.Text;
using System.Text.RegularExpressions;
using System.Threading;
using System.Web;
using System.Web.Util;
using System.Windows.Forms;
using Microsoft.ContentManagement.Publishing; 

namespace CMSConvLogWinApp
{
	/// <summary>
	//	
	//	CMSConvLog 07-Oct-2003 - Written by:yanno@microsoft.com
	//
	//	Description:
	//
	//	CMSConvLog parses an IIS log file and converts
	//	- /NR/rdonlyres/<GUID> into the Resource.Path equivalent
	//	- /NR/exeres/<GUID> into the Channel.Path or Posting.Path.
	//
	//	CMSConvLog saves the new log file under the same directory as
	//	the input log, with a _CmsConvLog suffix. If the file already
	//	exists, new lines are appened.
	//
	//	CMSConvLog requires the logged on user to have proper access to the
	//	CMS repository in order to use GetByGUID() function.
	//
	//	CMSConvLog has been tested with:
	//	- Content Management Server 2002 with .Net Framework 1.0
	//	- Content Management Server 2002 SP1 with .Net Framework 1.0 or 1.1
	//	- NCSA or W3C log file formats.
	//
	//	Usage:
	//
	//	cmsconvlog.exe <log_file> [/NoRoots]
	//
	//	<log_file>    Filename of the log file to convert.
	//	/NoRoots      If specified root objects will not be printed as part of
	//	the node path, i.e.:
	//	- Default:           /Channels/WoodgroveNet/Default
	//	- NoRoots specified: /WoodgroveNet/Default
	//
	//	Examples:
	//
	//	CMSConvLog.exe c:\windows\system32\logfiles\w3svc1\ex030101.log
	//	CMSConvLog.exe ..\ex030101.log /NoRoots
	//
	/// </summary>

	class convlog
	{
		static int g_rdonlyresReplaced = 0;
		static int g_exeresReplaced = 0;
		//static string version = "\r\nCMSConvLog 07-Oct-2003 - Written by:yanno@microsoft.com\r\n";
		static bool g_PrintRootObjets = true;
		//static bool g_ShowStars = true;
		static StringBuilder Err = new StringBuilder();
		
		public int ConvertFile(string strFile, string strOutputDir)
		{
			System.IO.FileInfo fileInfo = new System.IO.FileInfo(strFile);
			string strSourceFileName = fileInfo.Name;
			string strOutputFileName = strOutputDir + fileInfo.Name;
			int dot = strOutputFileName.LastIndexOf(".");
			string strOutputFileNameNew = strOutputFileName.Insert(dot,"_CmsConvLog");
			return (ProcessLogFile(strFile,strOutputFileNameNew));
		}

		/// <summary>
		/// ProcessLogFile handles:
		///		- log file opening 
		///		- calls to Transform() to convert each line one by one
		///		- new log file creation and writting
		/// </summary>
		/// <param name="lg">Logfile to convert</param>
		/// <returns>0 if success, 1 if error</returns>
		/// 
		public int ProcessLogFile(string lg, string newlg)
		{
			string line;
			int i = 1;
			//string newlg;
			//try 
			//{
		//		int dot = lg.LastIndexOf(".");
	//			newlg = lg.Insert(dot,"_CmsConvLog");
	//		}
	//		catch (Exception e)
	//		{
//				Console.Write(" Warning: the log filename passed does not have an extension (Code " + e.GetHashCode() + ").\r\n");
	//			newlg = lg + "_CmsConvLog";
	//		}

			try
			{
				StreamReader sr = new StreamReader( lg );
				StreamWriter sw = new StreamWriter(newlg, true);
//				Console.Write(" Processing logfile  : " + lg + "\r\n");
//				Console.Write(" Writting new logfile: " + newlg + "\r\n");
				

				
//				ThreadStart worker = new ThreadStart ( ShowStars);
//				Thread t = new Thread (worker);
//				t.Start();
				
				while ((line = sr.ReadLine()) != null) 
				{
					try 
					{ 
						sw.WriteLine(Transform(line));
					}
					catch (Exception e)
					{
						Err.Append(" - Failed to parse or write line " + i + " properly (Code " + e.GetHashCode() + ")\r\n");
					}
					i++;
				}

				sr.Close();
				sw.Close();
					
//				g_ShowStars = false;
//				Console.Write("\r  ");
//				t.Abort();


//				Console.WriteLine("\r\n Successully processed " + i + " lines of IIS logs.");
//				Console.WriteLine(" " + g_rdonlyresReplaced + " occurence(s) of /NR/rdonlyres were converted");
//				Console.WriteLine(" " + g_exeresReplaced + " occurence(s) of /NR/exeres were converted");
				
				if ( Err.Length > 0 ) 
				{
					
					//Console.WriteLine(Err);
					MessageBox.Show(null,Err.ToString(),lg);
					Err.Remove(0,Err.Length);
				}
				
				return 0;
			}
			catch (Exception e) 
			{
				
				//Console.WriteLine(" An error occured (Code " + e.GetHashCode() + ")");
//				Console.WriteLine(" " + e.Message);
				MessageBox.Show(null,Err.ToString(),e.Message);
				return 1;
			}
		}

		/// <summary>
		/// Transform() searches for /NR patterns in a string and converts
		/// the associated GUID to a corresponding node in the CMS repository.
		/// </summary>
		/// <param name="line">String or line of log to convert</param>
		/// <returns>0 if success, 1 if error</returns>
		static string Transform(string line)
		{
			string tmp;
			int iPos = 0;

			Regex rdonlyres = new Regex(@"(/NR/rdonlyres/[^ ]*)");
			Regex exeres = new Regex(@"(/NR/exeres/[^ ]*)");

			if ( (iPos = line.IndexOf(@"/NR/rdonlyres/")) > 0) 
			{
				tmp = line.Substring(iPos+14, 36);    
				CmsApplicationContext cmsContext = new CmsApplicationContext(); 
				cmsContext.AuthenticateAsCurrentUser(PublishingMode.Unpublished); 

				Microsoft.ContentManagement.Publishing.Resource pResource = cmsContext.Searches.GetByGuid("{"+tmp+"}") as Microsoft.ContentManagement.Publishing.Resource;
				if (pResource != null) 
				{
					g_rdonlyresReplaced++;
					if ( g_PrintRootObjets ) return rdonlyres.Replace(line, System.Web.HttpUtility.UrlEncode(pResource.Path).Replace("%2f","/"));
					else return rdonlyres.Replace(line, System.Web.HttpUtility.UrlEncode(pResource.Path.Substring(10,pResource.Path.Length-10)).Replace("%2f","/")); 
				}
				else
					Err.Append(" - Failed to retrieve resource GUID: " + tmp + "\r\n");
			}
			else if ( (iPos = line.IndexOf(@"/NR/exeres/")) > 0)
			{
				tmp = line.Substring(iPos+11, 36);
				CmsApplicationContext cmsContext = new CmsApplicationContext(); 
				cmsContext.AuthenticateAsCurrentUser(PublishingMode.Unpublished); 

				Microsoft.ContentManagement.Publishing.Posting pPosting = cmsContext.Searches.GetByGuid("{"+tmp+"}") as Microsoft.ContentManagement.Publishing.Posting;
				if (pPosting != null) 
				{
					g_exeresReplaced++;
					if ( g_PrintRootObjets ) return exeres.Replace(line, System.Web.HttpUtility.UrlEncode(pPosting.Path).Replace("%2f","/"));
					else return exeres.Replace(line, System.Web.HttpUtility.UrlEncode(pPosting.Path.Substring(9,pPosting.Path.Length-9)).Replace("%2f","/"));
				}
				else 
				{
					Microsoft.ContentManagement.Publishing.Channel pChannel = cmsContext.Searches.GetByGuid("{"+tmp+"}") as Microsoft.ContentManagement.Publishing.Channel;
					if (pChannel != null) 
					{
						g_exeresReplaced++;
						if ( g_PrintRootObjets ) return exeres.Replace(line, System.Web.HttpUtility.UrlEncode(pChannel.Path).Replace("%2f","/"));
						else return exeres.Replace(line, System.Web.HttpUtility.UrlEncode(pChannel.Path.Substring(9,pChannel.Path.Length-9)).Replace("%2f","/"));
					}
					Err.Append(" - Failed to retrieve node GUID: " + tmp + "\r\n");
				}
			}
			return line;
		}

	
	
	}
}
